/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rptclient.gr.rptclient.ReportTimeScheduleTimerTask;
import com.kingdee.eas.rptclient.gr.rptclient.TimeCurrencyDAO;
import com.kingdee.eas.rptclient.gr.rptclient.TimeScheduleVO;
import com.kingdee.eas.rptclient.gr.rptclient.TimeTemplateDAO;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class ReportFtpTimer {
    public static final String EVERYDAY = "EVERYDAY";
    public static final String EVERYWEEK = "EVERYWEEK";
    public static final String EVERYMONTH = "EVERYMONTH";
    public static final String ONETIME = "ONETIME";
    private static final Timer REPORT_FTP_TIMER = new Timer();
    private ArrayList timertaskList = new ArrayList();

    public void reload() {
        this.removeAll();
        this.init();
        this.startAll();
    }

    public void restart() {
        this.pauseAll();
        this.startAll();
    }

    public void restart(String reportNumber) {
        this.pause(reportNumber);
        this.start(reportNumber);
    }

    public ArrayList getTimertaskList() {
        return this.timertaskList;
    }

    public void setTimertaskList(ArrayList timertaskList) {
        this.timertaskList = timertaskList;
    }

    public void init() {
        System.out.println(CslRptClientResourceHelper.getString("35_ReportFtpTimer"));
        String sql = "select Fid,Fnumber,Fname,Ftype,FtimeDef,FtimePeriod,Fstate  from T_EAS_TimeSchedule where FCompanyNumber = '" + UIConfig.getCurCompanyNumber() + "'";
        System.out.println(sql);
        try {
            IRowSet rowSet = DbUtil.executeQuery(sql.toString());
            TimeTemplateDAO timeTemplateDAO = new TimeTemplateDAO();
            TimeCurrencyDAO timeCurrencyDAO = new TimeCurrencyDAO();
            while (rowSet.next()) {
                TimeScheduleVO timeSchedule = new TimeScheduleVO();
                timeSchedule.setId(rowSet.getString("Fid"));
                timeSchedule.setNumber(rowSet.getString("Fnumber"));
                timeSchedule.setName(rowSet.getString("Fname"));
                timeSchedule.setType(rowSet.getString("Ftype"));
                timeSchedule.setTimeDef(rowSet.getString("FTimeDef"));
                timeSchedule.setTimePeriod(rowSet.getInt("FTimePeriod"));
                timeSchedule.setState(rowSet.getInt("Fstate"));
                timeSchedule.setCompanyNum(UIConfig.getCurCompanyNumber());
                timeSchedule.setTimeTemplateList(timeTemplateDAO.findBy(timeSchedule.getId()));
                timeSchedule.setTimeCurrencyList(timeCurrencyDAO.findBy(timeSchedule.getId()));
                this.putTimertaskList(timeSchedule);
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void putTimertaskList(TimeScheduleVO timeSchedule) {
        Locale locale = SysContext.getSysContext().getLocale();
        String type = timeSchedule.getType().trim().toUpperCase(locale);
        String timeDef = timeSchedule.getTimeDef().trim();
        String[] timeDefArr = ReportFtpTimer.split(timeDef, " ");
        if (timeDefArr.length < 6) {
            return;
        }
        if (type.equals(EVERYDAY)) {
            if (timeDef.endsWith("* * ?")) {
                Date firstTime = this.getFirstTime(Integer.parseInt(timeDefArr[2]), Integer.parseInt(timeDefArr[1]), Integer.parseInt(timeDefArr[0])).getTime();
                long period = 86400000L;
                ReportTimeScheduleTimerTask timerTask = new ReportTimeScheduleTimerTask(timeSchedule, firstTime, period, timeSchedule.getState());
                this.getTimertaskList().add(timerTask);
            } else if (!(timeDef.endsWith("* ?") && timeDef.indexOf("/") != -1 || timeDef.indexOf("? *") == -1)) {
                // empty if block
            }
        } else if (!type.equals(EVERYWEEK) && !type.equals(EVERYMONTH) && type.equals(ONETIME)) {
            if (timeDefArr.length < 7) {
                return;
            }
            Calendar cFirstTime = Calendar.getInstance();
            cFirstTime.set(1, Integer.parseInt(timeDefArr[6]));
            cFirstTime.set(2, Integer.parseInt(timeDefArr[4]) - 1);
            cFirstTime.set(5, Integer.parseInt(timeDefArr[3]));
            cFirstTime.set(11, Integer.parseInt(timeDefArr[2]));
            cFirstTime.set(12, Integer.parseInt(timeDefArr[1]));
            cFirstTime.set(13, Integer.parseInt(timeDefArr[0]));
            if (cFirstTime.getTime().before(new Date())) {
                return;
            }
            long period = -1L;
            ReportTimeScheduleTimerTask timerTask = new ReportTimeScheduleTimerTask(timeSchedule, cFirstTime.getTime(), period, timeSchedule.getState());
            this.getTimertaskList().add(timerTask);
        }
    }

    public Calendar getFirstTime(int hours, int minutes, int seconds) {
        Calendar firstTime = Calendar.getInstance();
        Calendar now = Calendar.getInstance();
        firstTime.set(11, hours);
        firstTime.set(12, minutes);
        firstTime.set(13, seconds);
        if (firstTime.getTimeInMillis() - now.getTimeInMillis() > 0L) {
            return firstTime;
        }
        firstTime.set(7, firstTime.get(7) + 1);
        return firstTime;
    }

    public Calendar[] getFirstTimeByWorkingDay(int hours, int minutes, int seconds) {
        Calendar[] caledarArr = new Calendar[5];
        ArrayList<Calendar> caledarList = new ArrayList<Calendar>();
        Calendar now = Calendar.getInstance();
        Calendar firstTime = Calendar.getInstance();
        firstTime.set(11, hours);
        firstTime.set(12, minutes);
        firstTime.set(13, seconds);
        if (now.get(7) == 1) {
            firstTime.set(7, firstTime.get(7) + 1);
        } else if (now.get(7) == 7) {
            firstTime.set(7, firstTime.get(7) + 2);
        } else {
            firstTime = this.getFirstTime(hours, minutes, seconds);
        }
        for (int i = 0; i < 7; ++i) {
            firstTime.set(7, firstTime.get(7) + i);
            caledarList.add(firstTime);
        }
        Iterator iterator = caledarList.iterator();
        Calendar calendar = Calendar.getInstance();
        int j = 0;
        while (iterator.hasNext()) {
            calendar = (Calendar)iterator.next();
            if (calendar.get(7) != 1 || calendar.get(7) != 7) continue;
            caledarArr[j++] = calendar;
        }
        return caledarArr;
    }

    public Calendar[] getFirstTimeByWeek(int hours, int minutes, int seconds, String para) {
        Calendar[] caledarArr = null;
        ArrayList<Calendar> caledarList = new ArrayList<Calendar>();
        Calendar firstTime = this.getFirstTime(hours, minutes, seconds);
        for (int i = 0; i < 7; ++i) {
            firstTime.set(7, firstTime.get(7) + i);
            if (para.indexOf(String.valueOf(firstTime.get(7))) != -1) continue;
            caledarList.add(firstTime);
        }
        caledarArr = new Calendar[caledarList.size()];
        Iterator iterator = caledarList.iterator();
        Calendar calendar = Calendar.getInstance();
        int j = 0;
        while (iterator.hasNext()) {
            calendar = (Calendar)iterator.next();
            caledarArr[j++] = calendar;
        }
        return caledarArr;
    }

    public Calendar[] getFirstTimeByMonth(int hours, int minutes, int seconds, String para) {
        Calendar[] caledarArr = null;
        ArrayList<Calendar> caledarList = new ArrayList<Calendar>();
        Calendar firstTime = this.getFirstTime(hours, minutes, seconds);
        for (int i = 0; i < 7; ++i) {
            firstTime.set(7, firstTime.get(7) + i);
            if (para.indexOf(String.valueOf(firstTime.get(7))) != -1) continue;
            caledarList.add(firstTime);
        }
        caledarArr = new Calendar[caledarList.size()];
        Iterator iterator = caledarList.iterator();
        Calendar calendar = Calendar.getInstance();
        int j = 0;
        while (iterator.hasNext()) {
            calendar = (Calendar)iterator.next();
            caledarArr[j++] = calendar;
        }
        return caledarArr;
    }

    public static String[] split(String s, String spliter) {
        int index;
        Vector<String> v = new Vector<String>();
        String temp = s;
        int len = spliter.length();
        while ((index = temp.indexOf(spliter)) != -1) {
            v.addElement(temp.substring(0, index));
            temp = temp.substring(index + len);
        }
        v.addElement(temp);
        String[] rs = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            rs[i] = (String)v.elementAt(i);
        }
        return rs;
    }

    public boolean start(String reportNumber) {
        ArrayList arrayList = this.getTimertaskList();
        Iterator iterator = arrayList.iterator();
        ReportTimeScheduleTimerTask timerTask = null;
        boolean isStartingAll = true;
        boolean isStartingPart = false;
        while (iterator.hasNext()) {
            timerTask = (ReportTimeScheduleTimerTask)iterator.next();
            if (!timerTask.getTimeSchedule().getNumber().equals(reportNumber) || timerTask.getState() != 0) continue;
            if (this.schedule(timerTask)) {
                timerTask.setState(1);
                isStartingPart = true;
                continue;
            }
            isStartingAll = false;
        }
        if (isStartingAll || isStartingPart) {
            // empty if block
        }
        return isStartingAll && isStartingPart;
    }

    public boolean start(ReportTimeScheduleTimerTask timerTask) {
        if (timerTask != null) {
            Iterator iterator = this.getTimertaskList().iterator();
            ReportTimeScheduleTimerTask timerTaskFromList = null;
            while (iterator.hasNext()) {
                timerTaskFromList = (ReportTimeScheduleTimerTask)iterator.next();
                if (!timerTaskFromList.getKey().equals(timerTask.getKey()) || timerTaskFromList.getState() != 0) continue;
                this.schedule(timerTaskFromList);
                timerTaskFromList.setState(1);
            }
            timerTask = null;
            return true;
        }
        return false;
    }

    public void startAll() {
        Iterator iterator = this.getTimertaskList().iterator();
        ReportTimeScheduleTimerTask timerTask = null;
        HashSet<String> hasHset = new HashSet<String>();
        while (iterator.hasNext()) {
            timerTask = (ReportTimeScheduleTimerTask)iterator.next();
            if (timerTask.getState() != 0) continue;
            hasHset.add(timerTask.getTimeSchedule().getNumber());
        }
        for (String number : hasHset) {
            this.start(number);
        }
        this.priTsListTest();
    }

    public boolean pause(String reportNumber) {
        Iterator iterator = this.getTimertaskList().iterator();
        ReportTimeScheduleTimerTask timerTask = null;
        ArrayList<ReportTimeScheduleTimerTask> timerTaskPause = new ArrayList<ReportTimeScheduleTimerTask>();
        while (iterator.hasNext()) {
            timerTask = (ReportTimeScheduleTimerTask)iterator.next();
            if (!timerTask.getTimeSchedule().getNumber().equals(reportNumber) || timerTask.getState() != 1) continue;
            timerTaskPause.add(timerTask);
        }
        Iterator iteratorPause = timerTaskPause.iterator();
        int originalState = 0;
        if (iteratorPause.hasNext()) {
            timerTask = (ReportTimeScheduleTimerTask)iteratorPause.next();
            originalState = timerTask.getState();
        }
        iteratorPause = timerTaskPause.iterator();
        boolean isPausingAll = true;
        boolean isPausingPart = false;
        while (iteratorPause.hasNext()) {
            timerTask = (ReportTimeScheduleTimerTask)iteratorPause.next();
            if (this.pause(timerTask)) {
                isPausingPart = true;
                continue;
            }
            isPausingAll = false;
        }
        if (!isPausingAll && isPausingPart) {
            this.rollback(reportNumber, originalState);
        }
        return isPausingAll && isPausingPart;
    }

    public boolean pause(ReportTimeScheduleTimerTask timerTask) {
        if (timerTask != null) {
            Iterator iterator = this.getTimertaskList().iterator();
            ReportTimeScheduleTimerTask timerTaskFromList = null;
            while (iterator.hasNext()) {
                ReportTimeScheduleTimerTask timerTaskByClone;
                timerTaskFromList = (ReportTimeScheduleTimerTask)iterator.next();
                if (!timerTaskFromList.getKey().equals(timerTask.getKey()) || timerTaskFromList.getState() != 1) continue;
                timerTaskFromList.cancel();
                try {
                    timerTaskByClone = (ReportTimeScheduleTimerTask)timerTaskFromList.clone();
                    timerTaskByClone.setState(0);
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                    return false;
                }
                this.getTimertaskList().remove(timerTaskFromList);
                timerTaskFromList = null;
                this.getTimertaskList().add(timerTaskByClone);
                return true;
            }
            return true;
        }
        return false;
    }

    public void pauseAll() {
        ArrayList arraylist = this.getTimertaskList();
        Iterator iterator = arraylist.iterator();
        HashSet<String> hasHset = new HashSet<String>();
        ReportTimeScheduleTimerTask timerTask = null;
        while (iterator.hasNext()) {
            timerTask = (ReportTimeScheduleTimerTask)iterator.next();
            if (timerTask.getState() != 1) continue;
            hasHset.add(timerTask.getTimeSchedule().getNumber());
        }
        for (String number : hasHset) {
            this.pause(number);
        }
    }

    private void priTsListTest() {
        Iterator iterator = this.getTimertaskList().iterator();
        ReportTimeScheduleTimerTask timerTask = null;
        int i = 1;
        while (iterator.hasNext()) {
            timerTask = (ReportTimeScheduleTimerTask)iterator.next();
            System.out.println(i++ + ". TimeSchedule=" + timerTask.getTimeSchedule().toString() + "(" + timerTask.getTimeSchedule().getNumber() + ")\tType = " + timerTask.getTimeSchedule().getType() + "\tFirstTime = " + timerTask.getFirstTime() + "\tDelay = " + timerTask.getDelay() + "\tPeriod = " + timerTask.getPeriod() + "\tState = " + timerTask.getState());
        }
    }

    public boolean add(ReportTimeScheduleTimerTask timerTask) {
        if (timerTask == null) {
            return false;
        }
        ArrayList arrayList = this.getTimertaskList();
        Iterator iterator = arrayList.iterator();
        ReportTimeScheduleTimerTask timerTask_tmp = null;
        boolean isContains = false;
        while (iterator.hasNext()) {
            timerTask_tmp = (ReportTimeScheduleTimerTask)iterator.next();
            if (!timerTask_tmp.getKey().equals(timerTask.getKey())) continue;
            isContains = true;
        }
        if (!isContains) {
            this.getTimertaskList().add(timerTask);
            return this.start(timerTask);
        }
        return false;
    }

    public boolean remove(ReportTimeScheduleTimerTask timerTask) {
        if (timerTask == null) {
            return false;
        }
        this.pause(timerTask);
        Iterator iterator = this.getTimertaskList().iterator();
        ReportTimeScheduleTimerTask timerTask_tmp = null;
        while (iterator.hasNext()) {
            timerTask_tmp = (ReportTimeScheduleTimerTask)iterator.next();
            if (!timerTask_tmp.getKey().equals(timerTask.getKey())) continue;
            this.getTimertaskList().remove(timerTask_tmp);
            return true;
        }
        return true;
    }

    public boolean remove(String reportNumber) {
        if (reportNumber == null) {
            return false;
        }
        Iterator iterator = this.getTimertaskList().iterator();
        ReportTimeScheduleTimerTask timerTask2 = null;
        ArrayList<ReportTimeScheduleTimerTask> timerTaskRemove = new ArrayList<ReportTimeScheduleTimerTask>();
        while (iterator.hasNext()) {
            timerTask2 = (ReportTimeScheduleTimerTask)iterator.next();
            if (!timerTask2.getTimeSchedule().getNumber().equals(reportNumber) || timerTask2.getState() != 1) continue;
            timerTaskRemove.add(timerTask2);
        }
        for (ReportTimeScheduleTimerTask timerTask2 : timerTaskRemove) {
            this.remove(timerTask2);
        }
        this.priTsListTest();
        return true;
    }

    public boolean removeAll() {
        this.pauseAll();
        this.setTimertaskList(new ArrayList());
        return true;
    }

    private void rollback(String reportNumber, int originalState) {
    }

    private boolean schedule(ReportTimeScheduleTimerTask timerTask) {
        System.out.println("** schedule : " + timerTask.getTimeSchedule().getNumber());
        if (timerTask.getPeriod() == -1L) {
            if (timerTask.getFirstTime() != null) {
                REPORT_FTP_TIMER.schedule((TimerTask)timerTask, timerTask.getFirstTime());
            } else {
                REPORT_FTP_TIMER.schedule((TimerTask)timerTask, timerTask.getPeriod());
            }
        } else if (timerTask.getFirstTime() != null) {
            REPORT_FTP_TIMER.schedule((TimerTask)timerTask, timerTask.getFirstTime(), timerTask.getPeriod());
        } else {
            REPORT_FTP_TIMER.schedule((TimerTask)timerTask, timerTask.getDelay(), timerTask.getPeriod());
        }
        return true;
    }
}

