/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.WebTimeUpScheduleInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.DPFFile;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.rptclient.gr.rptclient.ReportFtpTimer;
import com.kingdee.eas.rptclient.gr.rptclient.TimeCurrencyDAO;
import com.kingdee.eas.rptclient.gr.rptclient.TimeCurrencyVO;
import com.kingdee.eas.rptclient.gr.rptclient.TimeScheduleVO;
import com.kingdee.eas.rptclient.gr.rptclient.TimeTemplateDAO;
import com.kingdee.eas.rptclient.gr.rptclient.TimeTemplateVO;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;

public class TimeScheduleDAO {
    public void loadByRemoteTimeSchedule(String kdtPath) throws Exception {
        TimeScheduleVO timeSchedule = new TimeScheduleVO();
        ArrayList<TimeTemplateVO> timeTemplateList = new ArrayList<TimeTemplateVO>();
        ArrayList<TimeCurrencyVO> timeCurrencyList = new ArrayList<TimeCurrencyVO>();
        TimeTemplateVO timeTemplate = null;
        TimeCurrencyVO timeCurrency = null;
        String id = Uuid.create().toString();
        String number = "";
        String name = "";
        String type = "";
        String timeDef = "";
        String companyNumber = "";
        int timePeriod = 1;
        int state = 0;
        TimeScheduleVO oldTimeSchedule = null;
        String fileName = kdtPath.substring(kdtPath.lastIndexOf("\\") + 1);
        Calendar now = Calendar.getInstance();
        try {
            DPFFile file = null;
            try {
                file = new DPFFile(kdtPath, DPFFile.DNF_PASSWORD);
            }
            catch (RuntimeException e) {
                throw new Exception(CslRptClientResourceHelper.getString("62_TimeScheduleDAO") + kdtPath + CslRptClientResourceHelper.getString("63_TimeScheduleDAO") + e.toString());
            }
            WebTimeUpScheduleInfo schedule = file.getSchedule();
            if (schedule != null) {
                number = schedule.getNumber();
                if (number == null || number.equals("")) {
                    throw new Exception(CslRptClientResourceHelper.getString("64_TimeScheduleDAO") + kdtPath + CslRptClientResourceHelper.getString("65_TimeScheduleDAO"));
                }
            } else {
                throw new Exception(CslRptClientResourceHelper.getString("66_TimeScheduleDAO") + kdtPath + CslRptClientResourceHelper.getString("67_TimeScheduleDAO"));
            }
            name = schedule.getName();
            type = file.getTimeDef().indexOf("ONETIME") != -1 ? "ONETIME" : (file.getTimeDef().indexOf("EVERYWEEK") != -1 ? "EVERYWEEK" : (file.getTimeDef().indexOf("EVERYMONTH") != -1 ? "EVERYMONTH" : "EVERYDAY"));
            timeDef = file.getTimeDef().substring(file.getTimeDef().indexOf("InstructionType") + 20, file.getTimeDef().indexOf("</Scheduale>"));
            timePeriod = Integer.valueOf(file.getTimePeriod());
            oldTimeSchedule = this.getTimeScheduleVO(number);
            if (oldTimeSchedule != null) {
                id = oldTimeSchedule.getId();
            }
            Iterator templateIteratorTMP = file.getTemplateCollection().iterator();
            TemplateInfo template = null;
            while (templateIteratorTMP.hasNext()) {
                template = (TemplateInfo)templateIteratorTMP.next();
                timeTemplate = new TimeTemplateVO();
                timeTemplate.setId(Uuid.create().toString());
                timeTemplate.setScheduleId(id);
                timeTemplate.setTemplateNumber(template.getNumber());
                timeTemplate.setTemplateType(template.getTemplateType().getValue());
                timeTemplateList.add(timeTemplate);
            }
            Iterator currencyIteratorTMP = file.getCurrencyCollection().iterator();
            CurrencyInfo currency = null;
            while (currencyIteratorTMP.hasNext()) {
                currency = (CurrencyInfo)currencyIteratorTMP.next();
                timeCurrency = new TimeCurrencyVO();
                timeCurrency.setId(Uuid.create().toString());
                timeCurrency.setScheduleId(id);
                timeCurrency.setCurrencyNumber(currency.getNumber());
                timeCurrencyList.add(timeCurrency);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.toString());
        }
        timeSchedule.setId(id);
        timeSchedule.setNumber(number);
        timeSchedule.setName(name);
        timeSchedule.setType(type);
        timeSchedule.setTimeDef(timeDef);
        timeSchedule.setTimePeriod(timePeriod);
        timeSchedule.setState(state);
        timeSchedule.setCompanyNum(UIConfig.getCurCompanyNumber());
        timeSchedule.setTimeTemplateList(timeTemplateList);
        timeSchedule.setTimeCurrencyList(timeCurrencyList);
        if (timeSchedule.getNumber() == null || timeSchedule.getNumber().equals("")) {
            return;
        }
        if (oldTimeSchedule == null) {
            this.create(timeSchedule);
        } else {
            this.update(timeSchedule);
        }
        ReportFtpTimer timer = new ReportFtpTimer();
        timer.reload();
    }

    public TimeScheduleVO getTimeScheduleVO(String number) {
        TimeScheduleVO timeSchedule = null;
        String sql = "select Fid,Fnumber,Fname,Ftype,FtimeDef,FtimePeriod,Fstate, FCompanyNumber from T_EAS_TimeSchedule where Fnumber = '" + number + "'";
        try {
            IRowSet rowSet = DbUtil.executeQuery(sql.toString());
            if (rowSet.next()) {
                timeSchedule = new TimeScheduleVO();
                timeSchedule.setId(rowSet.getString("Fid"));
                timeSchedule.setNumber(rowSet.getString("Fnumber"));
                timeSchedule.setName(rowSet.getString("Fname"));
                timeSchedule.setType(rowSet.getString("Ftype"));
                timeSchedule.setTimeDef(rowSet.getString("FtimeDef"));
                timeSchedule.setTimePeriod(rowSet.getInt("FtimePeriod"));
                timeSchedule.setState(rowSet.getInt("Fstate"));
                timeSchedule.setCompanyNum(UIConfig.getCurCompanyNumber());
                return timeSchedule;
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return timeSchedule;
    }

    public void create(TimeScheduleVO timeSchedule) {
        System.out.println("Starting create(TimeScheduleVO timeSchedule) ... ...");
        String sql = "insert into T_EAS_TimeSchedule (Fid,Fnumber,Fname,Ftype,FtimeDef,FtimePeriod,Fstate, FCompanyNumber) values (?,?,?,?,?,?,?,?)";
        Object[] param = new Object[]{timeSchedule.getId(), timeSchedule.getNumber(), timeSchedule.getName(), timeSchedule.getType(), timeSchedule.getTimeDef(), String.valueOf(timeSchedule.getTimePeriod()), String.valueOf(timeSchedule.getState()), UIConfig.getCurCompanyNumber()};
        try {
            DbUtil.execute(sql, param);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        this.createTimeTemplateAndTimeCurrency(timeSchedule);
    }

    public void update(TimeScheduleVO timeSchedule) {
        System.out.println("Starting update(TimeScheduleVO timeSchedule) ... ...");
        StringBuffer oql = new StringBuffer();
        oql.append("update T_EAS_TimeSchedule set");
        oql.append(" Fname = '" + timeSchedule.getName() + "',");
        oql.append(" Ftype = '" + timeSchedule.getType() + "',");
        oql.append(" FtimeDef = '" + timeSchedule.getTimeDef() + "',");
        oql.append(" FtimePeriod = " + timeSchedule.getTimePeriod() + ",");
        oql.append(" Fstate = " + timeSchedule.getState() + "");
        oql.append(" where Fid = ?");
        try {
            DbUtil.execute(oql.toString(), new Object[]{timeSchedule.getId()});
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        this.removeTimeTemplateAndTimeCurrency(timeSchedule.getId());
        this.createTimeTemplateAndTimeCurrency(timeSchedule);
    }

    public void createTimeTemplateAndTimeCurrency(TimeScheduleVO timeSchedule) {
        Object[] param;
        ArrayList timeTemplateList = timeSchedule.getTimeTemplateList();
        Iterator timeTemplateIterator = timeTemplateList.iterator();
        String sql = "insert into T_EAS_TimeTemplate (Fid,FscheduleId,FtemplateNumber,FTemplateType) values (?,?,?,?)";
        while (timeTemplateIterator.hasNext()) {
            TimeTemplateVO timeTemplate = (TimeTemplateVO)timeTemplateIterator.next();
            param = new Object[]{timeTemplate.getId(), timeTemplate.getScheduleId(), timeTemplate.getTemplateNumber(), String.valueOf(timeTemplate.getTemplateType())};
            try {
                DbUtil.execute(sql, param);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        ArrayList timeCurrencyList = timeSchedule.getTimeCurrencyList();
        Iterator timeCurrencyIterator = timeCurrencyList.iterator();
        sql = "insert into T_EAS_TimeCurrency (Fid,FscheduleId,FcurrencyNumber) values (?,?,?)";
        while (timeCurrencyIterator.hasNext()) {
            TimeCurrencyVO timeCurrency = (TimeCurrencyVO)timeCurrencyIterator.next();
            param = new Object[]{timeCurrency.getId(), timeCurrency.getScheduleId(), timeCurrency.getCurrencyNumber()};
            try {
                DbUtil.execute(sql, param);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    public void removeTimeTemplateAndTimeCurrency(Object[] scheduleId) {
        int n = scheduleId.length;
        for (int i = 0; i < n; ++i) {
            this.removeTimeTemplateAndTimeCurrency((String)scheduleId[i]);
        }
    }

    public void removeTimeTemplateAndTimeCurrency(String scheduleId) {
        String sql = "";
        try {
            sql = "delete from T_EAS_TimeTemplate where FscheduleId = ?";
            DbUtil.execute(sql, new Object[]{scheduleId});
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        try {
            sql = "delete from T_EAS_TimeCurrency where FscheduleId = ?";
            DbUtil.execute(sql, new Object[]{scheduleId});
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public boolean remove(TimeScheduleVO timeSchedule) {
        boolean result = true;
        return this.remove(timeSchedule.getId());
    }

    public boolean remove(String id) {
        boolean result = true;
        String sql = "delete from T_EAS_TimeScheduleLog where FId = ?";
        try {
            DbUtil.execute(sql, new Object[]{id});
            this.removeTimeTemplateAndTimeCurrency(id);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return result;
    }

    public ArrayList findBy(String number, String name) {
        ArrayList<TimeScheduleVO> arrayList = new ArrayList<TimeScheduleVO>();
        TimeScheduleVO timeSchedule = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select Fid,Fnumber,Fname,Ftype,FtimeDef,FtimePeriod,Fstate ");
        sql.append(" from T_EAS_TimeSchedule where 1=1 and FCompanyNuber = '").append(UIConfig.getCurCompanyNumber()).append("'");
        if (number != null && !number.equals("")) {
            sql.append(" and Fnumber like '%" + number + "%'");
        }
        if (name != null && !name.equals("")) {
            sql.append(" and Fname like '%" + name + "%'");
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery(sql.toString());
            TimeTemplateDAO timeTemplateDAO = new TimeTemplateDAO();
            TimeCurrencyDAO timeCurrencyDAO = new TimeCurrencyDAO();
            while (rowSet.next()) {
                timeSchedule = new TimeScheduleVO();
                timeSchedule = new TimeScheduleVO();
                timeSchedule.setId(rowSet.getString("Fid"));
                timeSchedule.setNumber(rowSet.getString("Fnumber"));
                timeSchedule.setName(rowSet.getString("Fname"));
                timeSchedule.setType(rowSet.getString("Ftype"));
                timeSchedule.setTimeDef(rowSet.getString("FTimeDef"));
                timeSchedule.setTimePeriod(rowSet.getInt("FTimePeriod"));
                timeSchedule.setState(rowSet.getInt("Fstate"));
                timeSchedule.setTimeTemplateList(timeTemplateDAO.findBy(timeSchedule.getId()));
                timeSchedule.setTimeCurrencyList(timeCurrencyDAO.findBy(timeSchedule.getId()));
                arrayList.add(timeSchedule);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return arrayList;
    }
}

