/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.WebTimeUpPeriodEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.CslBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableHeaderModel;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.rptclient.base.IUIFactory;
import com.kingdee.eas.rptclient.base.UIFactory;
import com.kingdee.eas.rptclient.gr.rptclient.ReportFtpTimer;
import com.kingdee.eas.rptclient.gr.rptclient.TimeScheduleDAO;
import com.kingdee.eas.rptclient.gr.rptclient.TimeScheduleFilterUI;
import com.kingdee.eas.rptclient.gr.rptclient.TimeScheduleVO;
import com.kingdee.eas.rptclient.gr.rptclient.frame.CslListUI;
import com.kingdee.eas.rptclient.gr.rptclient.frame.RptClientItemAction;
import com.kingdee.eas.rptclient.gr.rptclient.query.BaseQueryPanel;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.FTPUpDown;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.eas.rptclient.newrpt.util.ExceptionHandler;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class TimeScheduleListUI
extends CslListUI {
    public static final String HEADER_TEMPLATE_NUMBER = CslRptClientResourceHelper.getString("76_TimeScheduleListUI");
    public static final String HEADER_TEMPLATE_NAME = CslRptClientResourceHelper.getString("77_TimeScheduleListUI");
    public static final String HEADER_TEMPLATE_TYPE = CslRptClientResourceHelper.getString("78_TimeScheduleListUI");
    public static final ReportFtpTimer timer = new ReportFtpTimer();
    private ActionFtpImportTimeSchedule actionFtpImportTimeSchedule = null;
    protected KDWorkButton btnFtpImportTimeSchedule;
    protected KDMenuItem menuItemFtpImportTimeSchedule;

    public TimeScheduleListUI() throws Exception {
        this.resHelper = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.resource.CslClientUIResource");
        this.actionFtpImportTimeSchedule = new ActionFtpImportTimeSchedule((IUIObject)this);
        this.getActionManager().registerAction("actionFtpImportTimeSchedule", (ItemAction)this.actionFtpImportTimeSchedule);
        this.btnFtpImportTimeSchedule = new KDWorkButton();
        this.btnFtpImportTimeSchedule.setName("btnFtpImportTimeSchedule");
        this.btnFtpImportTimeSchedule.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionFtpImportTimeSchedule), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnFtpImportTimeSchedule.setText(CslRptClientResourceHelper.getString("79_TimeScheduleListUI"));
        this.btnFtpImportTimeSchedule.setToolTipText(CslRptClientResourceHelper.getString("79_TimeScheduleListUI"));
        this.menuItemFtpImportTimeSchedule = new KDMenuItem();
        this.menuItemFtpImportTimeSchedule.setName("menuItemFtpImportTimeSchedule");
        this.menuItemFtpImportTimeSchedule.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionFtpImportTimeSchedule), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.menuItemFtpImportTimeSchedule.setText(CslRptClientResourceHelper.getString("79_TimeScheduleListUI"));
        this.menuItemFtpImportTimeSchedule.setToolTipText(CslRptClientResourceHelper.getString("79_TimeScheduleListUI"));
        this.menuItemFtpImportTimeSchedule.setMnemonic('F');
        this.initTable();
    }

    @Override
    public void initUIToolBarLayout() {
        super.initUIToolBarLayout();
        JToolBar.Separator s = new JToolBar.Separator();
        s.setOrientation(1);
        this.toolBar.add((Component)s);
        this.toolBar.add((Component)this.btnFtpImportTimeSchedule);
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
        this.menuTool.add((JMenuItem)this.menuItemFtpImportTimeSchedule);
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAddNew.setEnabled(false);
        this.actionAddNew.setVisible(false);
        this.actionView.setEnabled(false);
        this.actionView.setVisible(false);
        this.actionEdit.setEnabled(false);
        this.actionEdit.setVisible(false);
        this.btnFtpImportTimeSchedule.setIcon(EASResource.getIcon((String)"imgTbtn_inceptreport"));
        this.menuItemFtpImportTimeSchedule.setIcon(EASResource.getIcon((String)"imgTbtn_inceptreport"));
    }

    @Override
    protected String[] createTableKeys() {
        String[] keys = new String[]{"id", "number", "name", "type", "timeDef", "timePeriod"};
        return keys;
    }

    @Override
    protected KDTableHeaderModel createHeader() {
        int size = 6;
        String[][] hd = new String[1][size];
        int[] align = new int[size];
        int[] width = new int[size];
        String[] format = new String[size];
        hd[0][0] = CslRptClientResourceHelper.getString("74_TimeScheduleListUI");
        align[0] = 0;
        width[0] = 0;
        format[0] = "";
        this.setBinder("id", "t.Fid");
        hd[0][1] = CslRptClientResourceHelper.getString("69_TimeScheduleFilterUI");
        align[1] = 0;
        width[1] = 160;
        format[1] = "";
        this.setBinder("number", "t.Fnumber");
        hd[0][2] = CslRptClientResourceHelper.getString("70_TimeScheduleFilterUI");
        align[2] = 0;
        width[2] = 230;
        format[2] = "";
        this.setBinder("name", "t.Fname");
        hd[0][3] = CslRptClientResourceHelper.getString("71_TimeScheduleFilterUI");
        align[3] = 0;
        width[3] = 60;
        format[3] = "";
        this.setBinder("type", "t.Ftype");
        hd[0][4] = CslRptClientResourceHelper.getString("75_TimeScheduleListUI");
        align[4] = 0;
        width[4] = 180;
        format[4] = "";
        this.setBinder("timeDef", "t.FtimeDef");
        hd[0][5] = CslRptClientResourceHelper.getString("72_TimeScheduleFilterUI");
        align[5] = 0;
        width[5] = 80;
        format[5] = "";
        this.setBinder("timePeriod", "t.FtimePeriod");
        KDTableHeaderModel mm = new KDTableHeaderModel();
        mm.setHiddenColumnIndexices(new int[]{0});
        mm.setData(hd);
        mm.setAlignColumns(align);
        mm.setColumnsFormat(format);
        mm.setColumnWidths(width);
        return mm;
    }

    @Override
    public void query(Object condition) {
        super.doLayout();
        this.tblMain.removeRows();
    }

    @Override
    protected boolean objectExists(String id) throws BOSException, EASBizException {
        String sql = "select fid from T_EAS_TimeSchedule where fid = ?";
        IRowSet rowSet = DbUtil.executeQuery(sql, new Object[]{id});
        return rowSet.size() == 1;
    }

    @Override
    public void showEditUI(String key, String status) throws Exception {
        System.out.println("=======================");
    }

    @Override
    protected void runRemove(String id) throws Exception {
        String sql = "select FId,Fnumber from T_EAS_TimeSchedule where FId = ?";
        IRowSet rowSet = DbUtil.executeQuery(sql, new Object[]{id});
        if (rowSet.next()) {
            timer.remove(rowSet.getString("Fnumber"));
        }
        sql = "delete from T_EAS_TimeSchedule where FId = ?";
        DbUtil.execute(sql, new Object[]{id});
        TimeScheduleDAO dao = new TimeScheduleDAO();
        dao.removeTimeTemplateAndTimeCurrency(new Object[]{id});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableDataRequest(KDTDataRequestEvent e) {
        try {
            this.setCursorOfWair();
            int from = e.getFirstRow();
            int length = e.getLastRow() - e.getFirstRow() + 1;
            RptRowSet rst = DbUtil.executeQuery(this.getQuerySql(), from, length);
            Object[][] rstArr = rst.toArray();
            String type = "";
            String timeDef = "";
            String timeDefTranslate = "";
            int n = rstArr.length;
            for (int i = 0; i < n; ++i) {
                type = (String)rstArr[i][3];
                timeDef = (String)rstArr[i][4];
                rstArr[i][4] = this.translateTimeDef(type, timeDef);
            }
            KDTableUtil.insertRows((Object[][])rstArr, null, (int)from, (KDTable)this.tblMain);
        }
        catch (BOSException ex) {
            if (ex.getCause() instanceof SQLException) {
                MsgBox.showWarning((Component)((Object)this), CslRptClientResourceHelper.getString("80_TimeScheduleListUI"));
            } else {
                ExceptionHandler.handle(ex);
            }
        }
        catch (EASBizException ex) {
            ExceptionHandler.handle(ex);
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    private String translateTimeDef(String type, String timeDef) {
        String result = "";
        String[] timeDefArr = StringUtils.split((String)timeDef, (String)" ");
        if (type.equals(TimeScheduleVO.TYPE_EVERYDAY)) {
            if (timeDef.endsWith("* * ?")) {
                result = " " + this.formatTime(timeDefArr[2]) + ":" + this.formatTime(timeDefArr[1]) + ":" + this.formatTime(timeDefArr[0]);
            } else if (timeDef.endsWith("* ?") && timeDef.indexOf("/") != -1) {
                result = "\u6bcf" + timeDefArr[3].substring(timeDefArr[3].indexOf("/") + 1) + CslRptClientResourceHelper.getString("81_TimeScheduleListUI") + " " + this.formatTime(timeDefArr[2]) + ":" + this.formatTime(timeDefArr[1]) + ":" + this.formatTime(timeDefArr[0]);
            } else if (timeDef.indexOf("? *") != -1) {
                result = CslRptClientResourceHelper.getString("82_TimeScheduleListUI") + " " + this.formatTime(timeDefArr[2]) + ":" + this.formatTime(timeDefArr[1]) + ":" + this.formatTime(timeDefArr[0]);
            }
        } else if (type.equals(TimeScheduleVO.TYPE_EVERYWEEK)) {
            result = CslRptClientResourceHelper.getString("83_TimeScheduleListUI") + timeDefArr[5] + " " + this.formatTime(timeDefArr[2]) + ":" + this.formatTime(timeDefArr[1]) + ":" + this.formatTime(timeDefArr[0]);
        } else if (!type.equals(TimeScheduleVO.TYPE_EVERYMONTH) && type.equals(TimeScheduleVO.TYPE_ONETIME)) {
            result = timeDefArr[6] + "\u5e74" + timeDefArr[4] + "\u6708" + timeDefArr[3] + CslRptClientResourceHelper.getString("84_TimeScheduleListUI") + " " + this.formatTime(timeDefArr[2]) + ":" + this.formatTime(timeDefArr[1]) + ":" + this.formatTime(timeDefArr[0]);
        }
        return result;
    }

    private String formatTime(String para) {
        if ((para = para.trim()) == null || para.equals("")) {
            return "00";
        }
        return para.length() > 1 ? para : "0" + para;
    }

    public void actionFtpImportTimeSchedule_actionPerformed(ActionEvent e) throws Exception {
        String ip = UIConfig.getFTPIP();
        if (StringUtils.isEmpty((String)ip)) {
            MsgBox.showInfo((Component)((Object)this), this.resHelper.getString("SettingIPFirst"));
            return;
        }
        String name = UIConfig.getFTPUser();
        String password = UIConfig.getFTPPassword();
        String path = UIConfig.getFTPDownPath();
        String curPath = UIConfig.getShareFileUrl();
        String curCompanyNumber = UIConfig.getCurCompanyNumber();
        if (StringUtils.isEmpty((String)curCompanyNumber)) {
            MsgBox.showError((Component)((Object)this), this.resHelper.getString("setCurrencyCompany"));
            return;
        }
        String filename = curCompanyNumber + ".dpf";
        boolean hasFile = false;
        try {
            int i;
            FTPUpDown ftp = new FTPUpDown(ip, "21", name, password);
            String[] file = ftp.getDPFFile(path, curCompanyNumber);
            if (file.length > 0) {
                hasFile = true;
            }
            for (i = 0; i < file.length; ++i) {
                System.out.println("== " + file[i]);
                ftp = new FTPUpDown(ip, "21", name, password);
                filename = file[i];
                ftp.downFile(path, filename, curPath);
            }
            for (i = 0; i < file.length; ++i) {
                filename = file[i];
                TimeScheduleDAO dao = new TimeScheduleDAO();
                try {
                    dao.loadByRemoteTimeSchedule(curPath + "\\" + filename);
                    continue;
                }
                catch (Exception e1) {
                    System.out.println(e1.getMessage());
                    MsgBox.showError((Component)((Object)this), e1.getMessage());
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            MsgBox.showError((Component)((Object)this), ex.getMessage());
        }
        if (hasFile) {
            MsgBox.showInfo((Component)((Object)this), CslRptClientResourceHelper.getString("85_TimeScheduleListUI"));
        } else {
            MsgBox.showWarning((Component)((Object)this), CslRptClientResourceHelper.getString("86_TimeScheduleListUI"));
        }
        this.refresh(e);
    }

    @Override
    protected String getEditUIName() {
        return TimeScheduleListUI.class.getName();
    }

    @Override
    public CslBaseConditionUI getQueryDialogUserPanel() {
        return null;
    }

    @Override
    protected String[] getNotOrderColumns() {
        String[] cols = new String[]{"fid", "FtimeDef"};
        return cols;
    }

    @Override
    public BaseQueryPanel getQueryPanel() {
        if (this.queryPanel == null) {
            UIContext uiContext = new UIContext((Object)this);
            IUIFactory factory = UIFactory.createUIFactory("com.kingdee.eas.rptclient.base.ModelDialogFactory");
            try {
                this.queryPanel = (BaseQueryPanel)factory.create((Component)((Object)this), TimeScheduleFilterUI.class.getName(), (Map)uiContext);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.queryPanel;
    }

    @Override
    protected String getQuerySql() {
        String order;
        StringBuffer sql = new StringBuffer();
        sql.append("select t.Fid as TFid,");
        sql.append("t.Fnumber as TFnumber,t.Fname as TFname,");
        sql.append(CslRptClientResourceHelper.getString("88_TimeScheduleListUI"));
        sql.append(CslRptClientResourceHelper.getString("89_TimeScheduleListUI"));
        sql.append(CslRptClientResourceHelper.getString("90_TimeScheduleListUI"));
        sql.append(CslRptClientResourceHelper.getString("91_TimeScheduleListUI"));
        sql.append("t.FtimeDef as TFtimeDef,");
        sql.append("switch (t.FtimePeriod = ").append(WebTimeUpPeriodEnum.currentPeriod.getValue()).append(", '").append(TimeScheduleVO.TIMEPERIOD_CURRETN_TEXT).append("',");
        sql.append("t.FtimePeriod = ").append(WebTimeUpPeriodEnum.lastPeriod.getValue()).append(", '").append(TimeScheduleVO.TIMEPERIOD_LAST_TEXT).append("', true, '') as TFtimePeriod");
        sql.append(" from T_EAS_TimeSchedule t");
        sql.append(" where 1=1");
        sql.append(" and t.FCompanyNumber = '").append(UIConfig.getCurCompanyNumber()).append("'");
        if (this.queryPanel != null) {
            Map conditions = this.queryPanel.getConditions();
            if (conditions.containsKey("number")) {
                String number = (String)conditions.get("number");
                sql.append(" and t.FNumber = '").append(number).append("'");
            }
            if (conditions.containsKey("name")) {
                String name = (String)conditions.get("name");
                sql.append(" and t.FName like '%").append(name).append("%'");
            }
            if (conditions.containsKey("type")) {
                String type = (String)conditions.get("type");
                if (type.equals(TimeScheduleVO.TYPE_EVERYDAY)) {
                    sql.append(" and t.FType = 'EVERYDAY'");
                } else if (type.equals(TimeScheduleVO.TYPE_EVERYWEEK)) {
                    sql.append(" and t.FType = 'EVERYWEEK'");
                } else if (type.equals(TimeScheduleVO.TYPE_EVERYMONTH)) {
                    sql.append(" and t.FType = 'EVERYMONTH'");
                } else if (type.equals(TimeScheduleVO.TYPE_ONETIME)) {
                    sql.append(" and t.FType = 'ONETIME'");
                }
            }
            if (conditions.containsKey("timePeriod")) {
                WebTimeUpPeriodEnum period = (WebTimeUpPeriodEnum)conditions.get("timePeriod");
                sql.append(" and t.FTimePeriod = ").append(period.getValue());
            }
        }
        if (this.isCanOrderTable() && !StringUtils.isEmpty((String)(order = this.getOrderSql()))) {
            sql.append(" order by ").append(order);
        }
        return sql.toString();
    }

    protected class ActionFtpImportTimeSchedule
    extends RptClientItemAction {
        public ActionFtpImportTimeSchedule() {
            this(null);
        }

        public ActionFtpImportTimeSchedule(IUIObject uiObject) {
            super(uiObject);
            String _tempStr = null;
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl shift I"));
            _tempStr = CslRptClientResourceHelper.getString("87_TimeScheduleListUI");
            this.putValue("ShortDescription", _tempStr);
            _tempStr = CslRptClientResourceHelper.getString("87_TimeScheduleListUI");
            this.putValue("LongDescription", _tempStr);
            _tempStr = CslRptClientResourceHelper.getString("87_TimeScheduleListUI");
            this.putValue("Name", _tempStr);
        }

        public void actionPerformed(ActionEvent e) {
            TimeScheduleListUI.this.getUIContext().put("ORG.PK", TimeScheduleListUI.this.getOrgPK(this));
            this.innerActionPerformed("eas", (CoreUIObject)TimeScheduleListUI.this, "ActionFtpImportTimeSchedule", "actionFtpImportTimeSchedule_actionPerformed", e);
        }
    }
}

