/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient.frame;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.service.ServiceExecutionException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.util.NumericException;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Icon;

public class RptClientItemAction
extends ItemAction
implements IItemAction {
    private static final long serialVersionUID = 7521772824195698745L;
    private boolean invokeFailed = false;

    public RptClientItemAction() {
    }

    public RptClientItemAction(IUIObject uiObj) {
        this.uiObj = uiObj;
    }

    public RptClientItemAction(String name) {
        super(name);
    }

    public RptClientItemAction(String name, Icon icon) {
        super(name, icon);
    }

    public RptClientItemAction(IUIObject uiObj, String logicKey) {
        this.uiObj = uiObj;
        this.itemLogicKey = logicKey;
    }

    public void innerActionPerformed(String contextName, CoreUIObject uiObj, String actionClassName, String actionMethodName, ActionEvent event) {
        if (this.isDaemonRun()) {
            final String ctxName = contextName;
            final CoreUIObject obj = uiObj;
            final String actionName = actionClassName;
            final String methodName = actionMethodName;
            final ActionEvent e = event;
            Thread workThread = new Thread(){

                @Override
                public void run() {
                    obj.addJobToPool(actionName, (Thread)this);
                    RptClientItemAction.this.reflectPerformAction(ctxName, obj, actionName, methodName, e);
                    obj.removeFromPool(actionName);
                }
            };
            workThread.start();
        } else {
            this.reflectPerformAction(contextName, uiObj, actionClassName, actionMethodName, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reflectPerformAction(String contextName, CoreUIObject uiObj, String actionClassName, String actionMethodName, ActionEvent event) {
        block15: {
            Method method = null;
            try {
                method = uiObj.getClass().getMethod(actionMethodName, ActionEvent.class);
            }
            catch (NoSuchMethodException nsmex) {
                uiObj.handUIException((Throwable)nsmex);
            }
            catch (SecurityException se) {
                uiObj.handUIException((Throwable)se);
            }
            if (method == null) {
                return;
            }
            try {
                Context ctx = new Context(contextName);
                ServiceContext svcCtx = this.createServiceContext(new MetaDataPK(actionClassName), new Object[]{ctx});
                this.invokeServiceBefore(svcCtx);
                method.invoke((Object)uiObj, event);
                this.invokeServiceAfter(svcCtx);
                this.invokeFailed = false;
            }
            catch (InvocationTargetException ite) {
                this.invokeFailed = true;
                if (ite.getCause() == null) {
                    uiObj.handUIException((Throwable)ite);
                    return;
                }
                if (ite.getCause() instanceof NumericException) {
                    NumericException ne = (NumericException)ite.getCause();
                    uiObj.handUIException((Throwable)ne);
                    ne.afterShowException(uiObj.getUIContext());
                    return;
                }
                uiObj.handUIException(ite.getCause());
            }
            catch (IllegalAccessException iae) {
                this.invokeFailed = true;
                if (iae.getCause() != null) {
                    uiObj.handUIException(iae.getCause());
                    break block15;
                }
                uiObj.handUIException((Throwable)iae);
            }
            catch (ServiceExecutionException see) {
                this.invokeFailed = true;
                uiObj.handUIException((Throwable)see);
            }
            catch (BOSException bose) {
                this.invokeFailed = true;
                uiObj.handUIException((Throwable)bose);
            }
            catch (Throwable te) {
                this.invokeFailed = true;
                uiObj.handUIException(te);
            }
        }
    }

    public boolean isInvokeFailed() {
        return this.invokeFailed;
    }
}

