/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient.frame;

import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDStatusBar;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.base.uiframe.client.MainStatusBarManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.rptclient.base.AbstractPanel;
import com.kingdee.eas.rptclient.base.IUIFactory;
import com.kingdee.eas.rptclient.base.UIFactory;
import com.kingdee.eas.rptclient.dataupdate.ui.DataUpdatePanel;
import com.kingdee.eas.rptclient.gr.rptclient.ChangePasswordUI;
import com.kingdee.eas.rptclient.gr.rptclient.CurrencyMapingListUI;
import com.kingdee.eas.rptclient.gr.rptclient.DBSettingUI;
import com.kingdee.eas.rptclient.gr.rptclient.FTPSettingUI;
import com.kingdee.eas.rptclient.gr.rptclient.LoginFrame;
import com.kingdee.eas.rptclient.gr.rptclient.ParamSettingUI;
import com.kingdee.eas.rptclient.gr.rptclient.ReportFtpTimer;
import com.kingdee.eas.rptclient.gr.rptclient.ReportListUI;
import com.kingdee.eas.rptclient.gr.rptclient.TemplateListUI;
import com.kingdee.eas.rptclient.gr.rptclient.TimeScheduleListUI;
import com.kingdee.eas.rptclient.gr.rptclient.TimeScheduleLogListUI;
import com.kingdee.eas.rptclient.gr.rptclient.UserListUI;
import com.kingdee.eas.rptclient.gr.rptclient.frame.CslListUI;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.gr.rptclient.util.CslConstant;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.eas.rptclient.gr.update.ui.UpdateSettingUI;
import com.kingdee.eas.rptclient.newrpt.util.ExceptionHandler;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class RptClientMainFrame
extends KDFrame {
    private boolean isRelogin = false;
    private Hashtable catchRightPanels = new Hashtable();
    protected KDSplitPane pnlMain;
    protected KDTreeView viewMainMenu;
    protected KDTree tree;
    protected KDPanel panel;
    protected KDMenu menuSystem;
    protected KDMenuItem menuItemChangePassword;
    protected KDMenuItem menuItemRelogin;
    protected KDSeparator kDSeparator1;
    protected KDMenuItem menuItemExit;
    protected KDToolBar mainToolBar = null;
    private JToolBar.Separator endSeparator = null;
    private KDWorkButton btnClose = null;
    protected KDMenuBar mainMenuBar = null;
    protected KDStatusBar mainStatusBar = null;
    private ResourceBundleHelper resHelper = null;

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        RptClientMainFrame frame = new RptClientMainFrame();
        frame.show();
    }

    public RptClientMainFrame() {
        this.jbInit();
        this.initBars();
        if (UIConfig.getUserType() == 0 && UIConfig.isAutoSchedulRpt()) {
            ReportFtpTimer timer = new ReportFtpTimer();
            timer.reload();
        }
    }

    private void initBars() {
        this.initUIMenuBarLayout();
        this.initUIToolBarLayout();
    }

    private void jbInit() {
        this.clearLocaleCache();
        this.resHelper = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.resource.CslClientUIResource");
        this.setUITitle();
        this.setDefaultCloseOperation(3);
        this.setExtendedState(6);
        this.setSize(400, 300);
        this.getContentPane().setLayout(new BorderLayout());
        this.mainMenuBar = new KDMenuBar();
        this.mainMenuBar.setName("uiMenubar");
        this.mainToolBar = new KDToolBar();
        this.mainToolBar.setName("uiToolbar");
        this.mainStatusBar = new KDStatusBar();
        this.mainStatusBar.setName("uiStatusbar");
        this.pnlMain = new KDSplitPane();
        this.viewMainMenu = new KDTreeView();
        this.panel = new KDPanel();
        this.pnlMain.setName("pnlMain");
        this.viewMainMenu.setName("viewCompany");
        this.pnlMain.setMinimumSize(new Dimension(1003, 609));
        this.pnlMain.setMaximumSize(new Dimension(1003, 609));
        this.pnlMain.setPreferredSize(new Dimension(1003, 609));
        this.pnlMain.setDividerLocation(240);
        this.viewMainMenu.setShowButton(false);
        this.viewMainMenu.setShowControlPanel(false);
        this.initTree();
        this.tree.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 1) {
                    try {
                        RptClientMainFrame.this.tree_valueChanged();
                    }
                    catch (Exception exc) {
                        System.out.println(exc.getMessage());
                        StackTraceElement[] s = exc.getStackTrace();
                        for (int i = 0; i < s.length; ++i) {
                            System.out.println("    " + s[i].toString());
                        }
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
                RptClientMainFrame.this.btnClose_actionPerformed(null);
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }
        });
        this.initUIContentLayout();
        this.addDataUpdateKeyListener();
        this.addParamModifyKeyListener();
    }

    private void addDataUpdateKeyListener() {
        JRootPane rootPane = this.getRootPane();
        InputMap inputMap = rootPane.getInputMap(2);
        ActionMap actionMap = rootPane.getActionMap();
        if (inputMap == null || actionMap == null) {
            return;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(122, 3);
        inputMap.put(keyStroke, "dataUpdate");
        actionMap.remove("dataUpdate");
        actionMap.put("dataUpdate", new DataUpdateAction());
    }

    private void addParamModifyKeyListener() {
        JRootPane rootPane = this.getRootPane();
        InputMap inputMap = rootPane.getInputMap(2);
        ActionMap actionMap = rootPane.getActionMap();
        if (inputMap == null || actionMap == null) {
            return;
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(123, 3);
        inputMap.put(keyStroke, "paramModify");
        actionMap.remove("paramModify");
        actionMap.put("paramModify", new ParamModifyAction());
    }

    private void setUITitle() {
        String uiTitle = this.resHelper.getString("rptclient.title");
        if (!StringUtils.isEmpty((String)UIConfig.getCurCompanyName())) {
            uiTitle = uiTitle + "--";
            uiTitle = uiTitle + UIConfig.getCurCompanyName();
        }
        this.setTitle(uiTitle);
    }

    private void initTree() {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"RootNode");
        DefaultKingdeeTreeNode node = null;
        switch (UIConfig.getUserType()) {
            case 1: {
                DefaultKingdeeTreeNode settingNode = new DefaultKingdeeTreeNode((Object)"settingNode");
                settingNode.setText(this.resHelper.getString("SysSetting"));
                settingNode.setCustomOpenIcon(EASResource.getIcon((String)"imgTree_folder_open"));
                root.add((MutableTreeNode)settingNode);
                node = new DefaultKingdeeTreeNode((Object)"serverNode");
                node.setText(this.resHelper.getString("EasServerSetting"));
                node.setUserObject((Object)DBSettingUI.class.getName());
                node.setCustomIcon(EASResource.getIcon((String)"imgTree_folder_leaf"));
                node = new DefaultKingdeeTreeNode((Object)"userNode");
                node.setText(this.resHelper.getString("UserManager"));
                node.setUserObject((Object)UserListUI.class.getName());
                node.setCustomIcon(EASResource.getIcon((String)"imgTree_folder_leaf"));
                settingNode.add((MutableTreeNode)node);
                node = new DefaultKingdeeTreeNode((Object)"fileServerNode");
                node.setText(this.resHelper.getString("FileServerSetting"));
                node.setUserObject((Object)FTPSettingUI.class.getName());
                node.setCustomIcon(EASResource.getIcon((String)"imgTree_folder_leaf"));
                settingNode.add((MutableTreeNode)node);
                node = new DefaultKingdeeTreeNode((Object)"updateNode");
                node.setText(this.resHelper.getString("clientUpdate"));
                node.setUserObject((Object)UpdateSettingUI.class.getName());
                node.setCustomIcon(EASResource.getIcon((String)"imgTree_folder_leaf"));
                settingNode.add((MutableTreeNode)node);
                break;
            }
            case 0: {
                node = new DefaultKingdeeTreeNode((Object)"templateNode");
                node.setText(this.resHelper.getString("TemplateManager"));
                node.setUserObject((Object)TemplateListUI.class.getName());
                node.setCustomIcon(EASResource.getIcon((String)"imgTree_folder_leaf"));
                root.add((MutableTreeNode)node);
                node = new DefaultKingdeeTreeNode((Object)"rptNode");
                node.setText(this.resHelper.getString("ReportManager"));
                node.setUserObject((Object)ReportListUI.class.getName());
                node.setCustomIcon(EASResource.getIcon((String)"imgTree_folder_leaf"));
                root.add((MutableTreeNode)node);
                DefaultKingdeeTreeNode docNode = new DefaultKingdeeTreeNode((Object)"docNode");
                docNode.setText(this.resHelper.getString("BaseDataSetting"));
                docNode.setCustomOpenIcon(EASResource.getIcon((String)"imgTree_folder_open"));
                root.add((MutableTreeNode)docNode);
                node = new DefaultKingdeeTreeNode((Object)"currencyNode");
                node.setText(this.resHelper.getString("CurrencyMapping"));
                node.setUserObject((Object)CurrencyMapingListUI.class.getName());
                node.setCustomIcon(EASResource.getIcon((String)"imgTree_folder_leaf"));
                docNode.add((MutableTreeNode)node);
                node = new DefaultKingdeeTreeNode((Object)"updateNode");
                node.setText(this.resHelper.getString("clientUpdate"));
                node.setUserObject((Object)UpdateSettingUI.class.getName());
                node.setCustomIcon(EASResource.getIcon((String)"imgTree_folder_leaf"));
                root.add((MutableTreeNode)node);
                if (!UIConfig.isAutoSchedulRpt()) break;
                DefaultKingdeeTreeNode timerNode = new DefaultKingdeeTreeNode((Object)"timerNode");
                timerNode.setText(CslRptClientResourceHelper.getString("73_TimeScheduleListUI"));
                timerNode.setCustomOpenIcon(EASResource.getIcon((String)"imgTree_folder_open"));
                root.add((MutableTreeNode)timerNode);
                node = new DefaultKingdeeTreeNode((Object)"TimeScheduleNode");
                node.setText(CslRptClientResourceHelper.getString("73_TimeScheduleListUI"));
                node.setUserObject((Object)TimeScheduleListUI.class.getName());
                node.setCustomIcon(EASResource.getIcon((String)"imgTree_folder_leaf"));
                timerNode.add((MutableTreeNode)node);
                node = new DefaultKingdeeTreeNode((Object)"TimeScheduleNode");
                node.setText(CslRptClientResourceHelper.getString("93_TimeScheduleLogListUI"));
                node.setUserObject((Object)TimeScheduleLogListUI.class.getName());
                node.setCustomIcon(EASResource.getIcon((String)"imgTree_folder_leaf"));
                timerNode.add((MutableTreeNode)node);
                break;
            }
        }
        this.tree = new KDTree();
        this.tree.setModel((TreeModel)new KingdeeTreeModel((TreeNode)root));
        this.tree.setName("treeCompany");
        this.tree.setAutoscrolls(true);
        this.tree.setRootVisible(false);
        this.tree.setCollapsePathDisabled(true);
        this.tree.setShowCheckBox(false);
        this.tree.expandAllNodes(true, (TreeNode)root);
    }

    private void initUIContentLayout() {
        this.getContentPane().add((Component)this.pnlMain, "Center");
        this.setJMenuBar((JMenuBar)this.mainMenuBar);
        this.addToolBar((JToolBar)this.mainToolBar);
        this.pnlMain.add((Component)this.panel, (Object)"right");
        this.pnlMain.add((Component)this.viewMainMenu, (Object)"left");
        this.viewMainMenu.setTree(this.tree);
    }

    private void initUIMenuBarLayout() {
        this.menuSystem = new KDMenu();
        this.kDSeparator1 = new KDSeparator();
        this.menuItemExit = new KDMenuItem();
        this.menuItemRelogin = new KDMenuItem();
        this.menuItemChangePassword = new KDMenuItem();
        this.menuSystem.setName("menuSystem");
        this.menuItemChangePassword.setName("menuItemChangePassword");
        this.menuItemRelogin.setName("menuItemRelogin");
        this.kDSeparator1.setName("kDSeparator1");
        this.menuItemExit.setName("menuItemExit");
        String tmp = this.resHelper.getString("System") + "(S)";
        this.menuSystem.setText(tmp);
        this.menuSystem.setToolTipText(tmp);
        this.menuSystem.setMnemonic('S');
        tmp = this.resHelper.getString("ChangePasswordUI.title") + "(C)";
        this.menuItemChangePassword.setText(tmp);
        this.menuItemChangePassword.setToolTipText(tmp);
        this.menuItemChangePassword.setMnemonic('C');
        this.menuItemChangePassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RptClientMainFrame.this.menuItemChangePassword_actionPerformed(e);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    ExceptionHandler.handle((Component)((Object)RptClientMainFrame.this), ex.getMessage(), ex);
                }
            }
        });
        tmp = this.resHelper.getString("relogin") + "(R)";
        this.menuItemRelogin.setText(tmp);
        this.menuItemRelogin.setToolTipText(tmp);
        this.menuItemRelogin.setMnemonic('R');
        this.menuItemRelogin.setIcon(EASResource.getIcon((String)"imgTbtn_logout"));
        this.menuItemRelogin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RptClientMainFrame.this.menuItemRelogin_actionPerformed(e);
            }
        });
        tmp = this.resHelper.getString("exit") + "(E)";
        this.menuItemExit.setText(tmp);
        this.menuItemExit.setToolTipText(tmp);
        this.menuItemExit.setMnemonic('E');
        this.menuItemExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RptClientMainFrame.this.btnClose_actionPerformed(e);
            }
        });
        this.mainMenuBar.add((JMenu)this.menuSystem);
        this.menuSystem.add((JMenuItem)this.menuItemChangePassword);
        this.menuSystem.add((JMenuItem)this.menuItemRelogin);
        this.menuSystem.add((Component)this.kDSeparator1);
        this.menuSystem.add((JMenuItem)this.menuItemExit);
    }

    private void initUIToolBarLayout() {
        this.endSeparator = new JToolBar.Separator();
        this.endSeparator.setOrientation(1);
        this.btnClose = new KDWorkButton();
        this.btnClose.setName("btnClose");
        this.btnClose.setIcon(EASResource.getIcon((String)"imgTbtn_quit"));
        this.btnClose.setText(this.resHelper.getString("exit"));
        this.btnClose.setToolTipText(this.resHelper.getString("exit"));
        this.btnClose.setTextIconDisStyle((short)3);
        this.btnClose.setIsControlByParent(false);
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RptClientMainFrame.this.btnClose_actionPerformed(e);
            }
        });
        this.mainToolBar.add((Component)this.endSeparator);
        this.mainToolBar.add((Component)this.btnClose);
        this.mainToolBar.setFloatable(false);
    }

    private void addAppMenu(KDMenuBar menuBar) {
        if (menuBar == null) {
            this.setJMenuBar((JMenuBar)this.mainMenuBar);
        } else {
            menuBar.add((Component)this.menuSystem, 0);
            this.setJMenuBar((JMenuBar)menuBar);
        }
    }

    private void addAppToolBar(KDToolBar toolBar) {
        this.removeAllToolBar();
        if (toolBar == null) {
            toolBar = this.mainToolBar;
            this.addToolBar((JToolBar)toolBar);
        } else {
            if (toolBar.isFloatable()) {
                toolBar.setFloatable(false);
            }
            toolBar.add((Component)this.endSeparator);
            toolBar.add((Component)this.btnClose);
            this.addToolBar((JToolBar)toolBar);
        }
        toolBar.invalidate();
        if (toolBar.getParent() != null) {
            toolBar.getParent().validate();
        }
    }

    private void addAppStatusBar(KDStatusBar statusBar) {
        this.removeAllStatusBar();
        if (statusBar == null) {
            this.setStatusBar(this.mainStatusBar);
        } else {
            this.setStatusBar(statusBar);
        }
        if (this.getStatusBar() != null) {
            this.getStatusBar().revalidate();
            this.getStatusBar().repaint();
        }
    }

    protected void tree_valueChanged() throws Exception {
        TreePath path = this.tree.getSelectionPath();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (!node.isLeaf()) {
            return;
        }
        String className = (String)node.getUserObject();
        if (this.catchRightPanels.containsKey(className)) {
            if (this.isParentClass(CslListUI.class.getName(), className)) {
                CslListUI ui = (CslListUI)((Object)this.catchRightPanels.get(className));
                this.pnlMain.add((Component)((Object)ui), (Object)"right");
                this.addAppMenu(ui.getUIMenuBar());
                this.addAppToolBar(ui.getUIToolBar());
                ui.refreshList();
                this.setCursor(Cursor.getPredefinedCursor(0));
                this.show();
            } else if (this.isParentClass(AbstractPanel.class.getName(), className)) {
                AbstractPanel panel = (AbstractPanel)((Object)this.catchRightPanels.get(className));
                panel.showWindow();
            } else if (this.isParentClass(CoreUIObject.class.getName(), className)) {
                CoreUIObject ui = (CoreUIObject)this.catchRightPanels.get(className);
                this.pnlMain.add((Component)ui, (Object)"right");
                this.addAppMenu(ui.getUIMenuBar());
                this.addAppToolBar(ui.getUIToolBar());
                this.setCursor(Cursor.getPredefinedCursor(0));
                this.show();
            }
        } else {
            System.err.println("create instance class:" + className);
            if (this.isParentClass(CoreUIObject.class.getName(), className)) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                Class<?> clasz = Class.forName(className);
                Object obj = clasz.newInstance();
                CoreUIObject ui = (CoreUIObject)obj;
                ui.initLayout();
                ui.onLoad();
                this.pnlMain.add((Component)ui, (Object)"right");
                this.addAppMenu(ui.getUIMenuBar());
                this.addAppToolBar(ui.getUIToolBar());
                this.setCursor(Cursor.getPredefinedCursor(0));
                this.show();
                this.catchRightPanels.put(className, ui);
            } else if (this.isParentClass(AbstractPanel.class.getName(), className)) {
                UIContext uiContext = new UIContext((Object)this);
                AbstractPanel panel = UIFactory.createUIFactory("com.kingdee.eas.rptclient.base.ModelDialogFactory").create((Component)((Object)this), className, (Map)uiContext);
                panel.showWindow();
                this.catchRightPanels.put(className, panel);
            }
        }
    }

    private boolean isParentClass(String parentClass, String childClass) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(childClass);
        while (!clazz.getName().equals(Object.class.getName())) {
            if (clazz.getName().equals(parentClass)) {
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    protected void btnClose_actionPerformed(ActionEvent e) {
        UIConfig.storeConfig();
        this.catchRightPanels.clear();
        if (this.isRelogin) {
            LoginFrame login = new LoginFrame();
            login.show();
        } else {
            int result = MsgBox.showConfirm2(this.resHelper.getString("isExitApp"));
            if (result != 0) {
                return;
            }
            System.exit(0);
        }
    }

    protected void menuItemRelogin_actionPerformed(ActionEvent e) {
        if (MsgBox.showConfirm2((Component)((Object)this), this.resHelper.getString("ReloginOrNot")) == 0) {
            this.isRelogin = true;
            UIConfig.setK3Ip("");
            UIConfig.setK3Url("");
            this.dispose();
            MainStatusBarManager.clearStatus();
            this.clearLocaleCache();
        }
    }

    protected void menuItemChangePassword_actionPerformed(ActionEvent e) throws Exception {
        String currentUser = UIConfig.getLoginUser();
        if ("administrator".equalsIgnoreCase(currentUser)) {
            MsgBox.showInfo((Component)((Object)this), this.resHelper.getString("can'tmodify.text"));
            return;
        }
        HashMap returnMap = new HashMap();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put(CslConstant.SHOW_SELEDT_COMPANY, (Object)new Boolean(false));
        String sql = "select fid, fusertype from t_eas_user where fnumber = ?";
        try {
            IRowSet rs = DbUtil.executeQuery(sql, new Object[]{currentUser});
            if (rs.next()) {
                uiContext.put(CslConstant.USER_ID, (Object)rs.getString(1));
                uiContext.put(CslConstant.USER_TYPE, (Object)new Integer(rs.getInt(2)));
            }
        }
        catch (Exception ex) {
            throw new EASBizException(new NumericExceptionSubItem("1", ex.getMessage()));
        }
        uiContext.put((Object)"parentUI", (Object)this);
        uiContext.put((Object)"returnMap", returnMap);
        ChangePasswordUI ui = null;
        try {
            ui = (ChangePasswordUI)UIFactory.createUIFactory("com.kingdee.eas.rptclient.base.ModelDialogFactory").create((Component)((Object)this), ChangePasswordUI.class.getName(), (Map)uiContext);
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
        if (ui != null) {
            ui.showWindow();
        }
    }

    private void clearLocaleCache() {
    }

    private class ParamModifyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private ParamModifyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (UIConfig.getUserType() == 0) {
                return;
            }
            RptClientMainFrame parentUi = RptClientMainFrame.this;
            IUIFactory fy = UIFactory.createUIFactory("com.kingdee.eas.rptclient.base.ModelDialogFactory");
            try {
                ParamSettingUI ui = (ParamSettingUI)fy.create((Component)((Object)parentUi), ParamSettingUI.class.getName(), (Map)new UIContext((Object)parentUi));
                if (ui == null) {
                    return;
                }
                ui.showWindow();
            }
            catch (Exception e1) {
                MsgBox.showError((Component)((Object)parentUi), e1.getMessage());
            }
            ((Component)((Object)parentUi)).repaint();
        }
    }

    private class DataUpdateAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private DataUpdateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (UIConfig.getUserType() == 0) {
                return;
            }
            DataUpdatePanel panel = DataUpdatePanel.getInstance((Component)((Object)RptClientMainFrame.this), null);
            panel.showWindow();
            RptClientMainFrame.this.repaint();
        }
    }
}

