/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient.frame;

import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.AbstractUIFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.eas.base.uiframe.UIFrameResource;
import com.kingdee.eas.base.uiframe.client.AppletUtil;
import com.kingdee.eas.rptclient.gr.rptclient.frame.UINewFrame;
import com.kingdee.eas.util.AbortException;
import java.util.Map;
import org.apache.log4j.Logger;

public class UINewFrameFactory
extends AbstractUIFactory {
    private Logger logger = Logger.getLogger(UINewFrameFactory.class);

    private UINewFrameFactory() {
    }

    public static IUIFactory newInstance() {
        return new UINewFrameFactory();
    }

    public IUIWindow create(String name, Map uiContext, Map dataObjects, String oprt) throws UIException {
        return this.create(name, uiContext, dataObjects, oprt, 95);
    }

    public IUIWindow create(String name, Map uiContext, Map dataObjects) throws UIException {
        return this.create(name, uiContext, dataObjects, null);
    }

    public IUIWindow create(String name, Map uiContext) throws UIException {
        return this.create(name, uiContext, null, null);
    }

    public IUIWindow create(String name, Map uiContext, Map dataObjects, String oprt, int winStyle) throws UIException {
        IUIWindow uiWindow = AppletUtil.createAppletFrame((String)name, (Map)uiContext, (Map)dataObjects, (String)oprt);
        if (uiWindow != null) {
            return uiWindow;
        }
        IUIObject uiObject = UINewFrameFactory.initUIObject(this, name, uiContext, dataObjects, oprt);
        uiWindow = new UINewFrame(uiObject, winStyle);
        uiObject.getUIContext().put("WinStyle", new Integer(winStyle));
        return uiWindow;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IUIObject initUIObject(UINewFrameFactory factory, String name, Map uiContext, Map dataObjects, String oprt) throws UIException {
        long start = System.currentTimeMillis();
        factory.logger.debug((Object)("Begin initUIObject " + name + " : " + start + "!"));
        IUIObject uiObject = null;
        Class<?> c = null;
        String key0 = "";
        boolean isCache = false;
        try {
            if (uiObject == null) {
                c = Class.forName(name);
                uiObject = (IUIObject)c.newInstance();
            }
            long instanceCost = System.currentTimeMillis() - start;
            factory.logger.info((Object)("UIObject " + name + " new instance : " + instanceCost + " ms."));
            IUIObject ui = uiObject.getInstance(uiContext);
            if (ui != null) {
                uiObject = ui;
            }
            if (uiObject instanceof CoreUIObject) {
                CoreUIObject coreUIObj = (CoreUIObject)uiObject;
                coreUIObj.initLayout();
            }
        }
        catch (ClassNotFoundException exc) {
            factory.logger.error((Object)exc);
            throw new AbortException();
        }
        catch (Exception exc) {
            if (!(exc instanceof AbortException)) throw new UIException(UIFrameResource.getString((String)"UIFactoryHelper_createUIError"), (Throwable)exc);
            throw (AbortException)exc;
        }
        if (dataObjects != null && dataObjects.size() > 0) {
            for (String key : dataObjects.keySet()) {
                uiObject.setDataObject(key, (IObjectValue)((AbstractObjectValue)dataObjects.get(key)));
            }
        }
        if (uiContext != null && uiContext.size() > 0) {
            for (String key : uiContext.keySet()) {
                uiObject.getUIContext().put(key, uiContext.get(key));
            }
        }
        if (oprt != null && !oprt.equals("")) {
            uiObject.setOprtState(oprt);
        }
        try {
            long onLoadStart = System.currentTimeMillis();
            uiObject.onLoad();
            long onLoadCost = System.currentTimeMillis() - onLoadStart;
            factory.logger.info((Object)("UIObject " + name + " onLoad spent " + onLoadCost + " ms."));
        }
        catch (Exception exc) {
            try {
                boolean b = uiObject.destroyWindow();
                if (!b) throw new UIException(UIFrameResource.getString((String)"UIFactoryHelper_onLoadError"), (Throwable)exc);
            }
            catch (Exception ex) {
                factory.logger.error((Object)("destory window error:" + ex));
            }
            throw new UIException(UIFrameResource.getString((String)"UIFactoryHelper_onLoadError"), (Throwable)exc);
        }
        if (uiObject.isBindWorkFlow()) {
            uiObject.checkWfAssignment();
        }
        long end = System.currentTimeMillis();
        factory.logger.debug((Object)("End initUIObject " + name + " : " + end + "!"));
        long cost = end - start;
        factory.logger.info((Object)("InitUIObject " + name + " : " + cost + " ms!"));
        return uiObject;
    }
}

