/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class BaseBizDataUtil {
    private BaseBizDataUtil() {
    }

    public static CurrencyCollection getCurrencies() throws BOSException, EASBizException {
        CurrencyCollection col = new CurrencyCollection();
        String sql = "select FId, FNumber, FName from t_eas_currency order by FNumber";
        IRowSet rowSet = DbUtil.executeQuery(sql);
        try {
            while (rowSet.next()) {
                CurrencyInfo info = new CurrencyInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("FID")));
                info.setNumber(rowSet.getString("FNumber"));
                info.setName(rowSet.getString("FName"));
                col.add(info);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return col;
    }

    public static TemplateCollection getTemplates() throws BOSException, EASBizException {
        TemplateCollection templates = new TemplateCollection();
        StringBuffer querySql = new StringBuffer();
        querySql.append("select FId, FNumber, FName from t_eas_template");
        querySql.append(" where FVersionStatus = 1");
        querySql.append(" order by FPeriodType,FNumber");
        IRowSet rowSet = DbUtil.executeQuery(querySql.toString());
        try {
            while (rowSet.next()) {
                TemplateInfo info = new TemplateInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("FID")));
                info.setNumber(rowSet.getString("FNumber"));
                info.setName(rowSet.getString("FName"));
                templates.add(info);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return templates;
    }

    public static Map getIdAndNumber(String tableName, String colId, String colNumber) {
        HashMap<String, String> idAndNumbers = new HashMap<String, String>();
        if (colId == null || "".equals(colId.trim())) {
            colId = "FID";
        }
        if (colNumber == null || "".equals(colNumber.trim())) {
            colNumber = "FNumber";
        }
        StringBuffer querySql = new StringBuffer();
        querySql.append("select ").append(colId).append(",");
        querySql.append(colNumber).append(" from ").append(tableName);
        try {
            IRowSet rowSet = DbUtil.executeQuery(querySql.toString());
            while (rowSet.next()) {
                idAndNumbers.put(rowSet.getString(1), rowSet.getString(2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return idAndNumbers;
    }

    public static Map getIdAndNumber(String tableName, String colId, String colNumber, String companyNumber) {
        HashMap<String, String> idAndNumbers = new HashMap<String, String>();
        if (colId == null || "".equals(colId.trim())) {
            colId = "FID";
        }
        if (colNumber == null || "".equals(colNumber.trim())) {
            colNumber = "FNumber";
        }
        StringBuffer querySql = new StringBuffer();
        querySql.append("select ").append(colId).append(",");
        querySql.append(colNumber).append(" from ").append(tableName);
        querySql.append(" where FCompanyNumber = '").append(companyNumber).append("'");
        try {
            IRowSet rowSet = DbUtil.executeQuery(querySql.toString());
            while (rowSet.next()) {
                idAndNumbers.put(rowSet.getString(1), rowSet.getString(2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return idAndNumbers;
    }

    public static Map getCompanyIdAndNumber() {
        return BaseBizDataUtil.getIdAndNumber("t_eas_company", "FID", "FNumber");
    }

    public static Map getCurrencyIdAndNumber() {
        return BaseBizDataUtil.getIdAndNumber("t_eas_currency", "FID", "FNumber", UIConfig.getCurCompanyNumber());
    }
}

