/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient.util;

import com.kingdee.eas.rptclient.gr.rptclient.util.ClientRptParam;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class CslrptParamUtil {
    private static final Logger logger = Logger.getLogger(CslrptParamUtil.class);
    private static Set paramSet;

    public static Set getParams() {
        return paramSet;
    }

    public static void initParam() {
        paramSet = new HashSet();
        String sql = "select fid, fnumber, fname, fvalue from t_eas_param";
        try {
            IRowSet rs = DbUtil.executeQuery(sql);
            while (rs.next()) {
                ClientRptParam p = new ClientRptParam();
                p.setFid(rs.getString("fid"));
                p.setFnumber(rs.getString("fnumber"));
                p.setFname(rs.getString("fname"));
                p.setFvalue(rs.getString("fvalue"));
                paramSet.add(p);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public static String getParamValue(String number, String id) throws Exception {
        IRowSet rs;
        if (number == null && id == null) {
            throw new Exception(" missing query param, number or id");
        }
        if (paramSet != null && !paramSet.isEmpty()) {
            for (ClientRptParam p : paramSet) {
                if (!(number == null ? id.equals(p.getFid()) : (id == null ? number.equals(p.getFnumber()) : number.equals(p.getFnumber()) && id.equals(p.getFid())))) continue;
                return p.getFvalue();
            }
        }
        StringBuffer sql = new StringBuffer("select fvalue from t_eas_param where 1 = 1");
        ArrayList<String> params = new ArrayList<String>();
        if (number != null) {
            sql.append(" and fnumber = ?");
            params.add(number);
        }
        if (id != null) {
            sql.append(" and fid = ?");
            params.add(id);
        }
        if ((rs = DbUtil.executeQuery(sql.toString(), params.toArray())).next()) {
            return rs.getString("fvalue");
        }
        return null;
    }

    public static String getParamValueByNumber(String number) throws Exception {
        return CslrptParamUtil.getParamValue(number, null);
    }

    public static String getParamValueById(String id) throws Exception {
        return CslrptParamUtil.getParamValue(null, id);
    }

    public static void putParamValue(ClientRptParam param) throws Exception {
        String id = param.getFid();
        String number = param.getFnumber();
        String name = param.getFname();
        String newValue = param.getFvalue();
        String name_tw = param.getFname_tw();
        StringBuffer sql = new StringBuffer();
        String oldValue = CslrptParamUtil.getParamValue(number, id);
        if (oldValue != null) {
            if (oldValue.equals(newValue)) {
                return;
            }
            sql.append("update t_eas_param set fvalue = ? where fnumber = ?");
            Object[] params = null;
            if (id == null) {
                params = new Object[]{newValue, number};
            } else {
                sql.append(" and fid = ?");
                params = new Object[]{newValue, number, id};
            }
            DbUtil.execute(sql.toString(), params);
        } else {
            String fid = Uuid.create().toString();
            ClientRptParam p = new ClientRptParam(fid, number, name, newValue, name_tw);
            CslrptParamUtil.validataParam(p);
            sql.append("insert into t_eas_param (FId, FNumber, FName, FName_TW, FValue) ".concat("values (?, ?, ?, ?, ?)"));
            DbUtil.execute(sql.toString(), new Object[]{fid, number, name, name_tw, newValue});
        }
        CslrptParamUtil.initParam();
    }

    public static void putParamValue(Collection params) {
        if (params == null || params.isEmpty()) {
            return;
        }
        for (ClientRptParam param : params) {
            try {
                CslrptParamUtil.putParamValue(param);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private static void validataParam(ClientRptParam p) throws Exception {
        if (StringUtils.isEmpty((String)p.getFid())) {
            throw new Exception(" param fid is null or empty ");
        }
        if (StringUtils.isEmpty((String)p.getFnumber())) {
            throw new Exception(" param fnumber is null or empty ");
        }
        if (StringUtils.isEmpty((String)p.getFname())) {
            throw new Exception(" param fname is null or empty ");
        }
        if (StringUtils.isEmpty((String)p.getFvalue())) {
            throw new Exception(" param fvalue is null or empty ");
        }
    }

    public static boolean isTrue(Object target) {
        if (target == null) {
            return false;
        }
        if (target instanceof Boolean) {
            return (Boolean)target;
        }
        List<String> trueList = Arrays.asList("TRUE", "true", "yes", "YES", "1", "Y", "y", "\u662f");
        String strResult = target.toString();
        return trueList.contains(strResult);
    }

    static {
        CslrptParamUtil.initParam();
    }
}

