/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.rpt.FormulaViewTypeEnum;
import com.kingdee.eas.rptclient.gr.rptclient.ReportVO;
import com.kingdee.eas.rptclient.gr.rptclient.util.TemplateHelper;

public class DataCollectUtil {
    public static void fillCellFormulaByDataCollect(Book book, String dataCollectNumber) throws BOSException, SyntaxErrorException {
        String tmpkey;
        String curkey;
        if (book == null || dataCollectNumber == null) {
            return;
        }
        if (dataCollectNumber.equals("ACTUALDATA")) {
            curkey = "0";
            tmpkey = "1";
        } else if (dataCollectNumber.equals("BUDGETDATA")) {
            curkey = "1";
            tmpkey = "0";
        } else {
            return;
        }
        int sheetCount = book.getSheetCount();
        for (int index = 0; index < sheetCount; ++index) {
            Sheet sheet = book.getSheet(index);
            int maxRows = sheet.getMaxRowIndex();
            int maxCols = sheet.getMaxColIndex();
            for (int rows = 0; rows <= maxRows; ++rows) {
                for (int cols = 0; cols <= maxCols; ++cols) {
                    Cell cell = sheet.getCell(rows, cols, false);
                    if (cell == null) continue;
                    String curFormula = TemplateHelper.getFormulaFromUserObject(cell, curkey);
                    String tmpFormula = TemplateHelper.getFormulaFromUserObject(cell, tmpkey);
                    if (curFormula == null && tmpFormula == null) continue;
                    if (curFormula == null) {
                        Object value = TemplateHelper.getValueFromUserObject(cell);
                        if (value != null) {
                            cell.setFormula(value.toString());
                        }
                    } else {
                        cell.setFormula(curFormula);
                    }
                    cell.setUserObject("0", null);
                    cell.setUserObject("1", null);
                    if (cell.getUserObject(FormulaViewTypeEnum.CSLFormula.getName()) != null) {
                        cell.setUserObject(FormulaViewTypeEnum.CSLFormula.getName(), null);
                    }
                    if (cell.getUserObject(FormulaViewTypeEnum.BgFormula.getName()) == null) continue;
                    cell.setUserObject(FormulaViewTypeEnum.BgFormula.getName(), null);
                }
            }
        }
    }

    public static void clearCellFormulaByDataCollect(Book book) throws BOSException, SyntaxErrorException {
        int sheetCount = book.getSheetCount();
        for (int index = 0; index < sheetCount; ++index) {
            Sheet sheet = book.getSheet(index);
            int maxRows = sheet.getMaxRowIndex();
            int maxCols = sheet.getMaxColIndex();
            for (int rows = 0; rows <= maxRows; ++rows) {
                for (int cols = 0; cols <= maxCols; ++cols) {
                    Cell cell = sheet.getCell(rows, cols, false);
                    if (cell == null) continue;
                    cell.setUserObject("0", null);
                    cell.setUserObject("1", null);
                    if (cell.getUserObject(FormulaViewTypeEnum.CSLFormula.getName()) != null) {
                        cell.setUserObject(FormulaViewTypeEnum.CSLFormula.getName(), null);
                    }
                    if (cell.getUserObject(FormulaViewTypeEnum.BgFormula.getName()) == null) continue;
                    cell.setUserObject(FormulaViewTypeEnum.BgFormula.getName(), null);
                }
            }
        }
    }

    public static String getRptDataCollectName(ReportVO vo) {
        return DataCollectUtil.getRptDataCollectName(vo.getDataCollectNumber());
    }

    public static String getRptDataCollectName(String dataCollectNumber) {
        if (dataCollectNumber != null) {
            if (dataCollectNumber.equals("ACTUALDATA")) {
                return DataCollectConstant.getActualDC().getName();
            }
            if (dataCollectNumber.equals("BUDGETDATA")) {
                return DataCollectConstant.getBudgetDC().getName();
            }
        }
        return DataCollectConstant.getActualDC().getName();
    }
}

