/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.Location;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeInfo;
import com.kingdee.eas.fi.gr.dynamic.client.DynaHeadItem;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.PointXComparator;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.newrpt.designer.BookProperties;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Point;
import java.awt.Rectangle;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class DynamicTemplateUtility {
    public static ArrayList getBasePointList(Sheet sheet) {
        int i;
        int rowCount = sheet.getMaxRowIndex();
        int columnCount = sheet.getMaxColIndex();
        ArrayList<Point> list = new ArrayList<Point>();
        boolean isFindBasePosition = false;
        Cell c = null;
        Point firstPoint = null;
        for (i = 0; i < rowCount; ++i) {
            for (int j = 0; j < columnCount; ++j) {
                c = sheet.getCell(i, j, false);
                if (!DynamicTemplateUtility.isBasePointCell(c)) continue;
                isFindBasePosition = true;
                firstPoint = new Point(j, i);
                list.add(firstPoint);
                break;
            }
            if (isFindBasePosition) break;
        }
        if (firstPoint != null) {
            for (i = firstPoint.x + 1; i < columnCount; ++i) {
                c = sheet.getCell(firstPoint.y, i, false);
                if (!DynamicTemplateUtility.isBasePointCell(c)) continue;
                firstPoint = new Point(i, firstPoint.y);
                list.add(firstPoint);
            }
            for (int j = firstPoint.y + 1; j < rowCount; ++j) {
                c = sheet.getCell(j, firstPoint.x, false);
                if (!DynamicTemplateUtility.isBasePointCell(c)) continue;
                firstPoint = new Point(firstPoint.x, j);
                list.add(firstPoint);
            }
        }
        return list;
    }

    public static boolean hasItemFormula(Cell cell) {
        if (cell == null) {
            return false;
        }
        Object obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula) {
            return ((ItemFormula)obj).getExt("GRADE_NUMBER") == null;
        }
        return false;
    }

    public static boolean isBasePointCell(Cell cell) {
        return DynamicTemplateUtility.getDynaParametersFromCell(cell) != null;
    }

    public static DynaParameters getDynaParameters(Sheet sheet, Point basepoint) {
        return DynamicTemplateUtility.getDynaParametersFromCell(sheet.getCell(basepoint.y, basepoint.x, false));
    }

    public static DynaParameters getDynaParametersFromCell(Cell cell) {
        ItemFormula f;
        if (cell == null) {
            return null;
        }
        Object obj = cell.getUserObjectValue("ITEM");
        if (obj != null && obj instanceof ItemFormula && (obj = (f = (ItemFormula)obj).getExt("DynaParameters")) != null && obj instanceof String) {
            return DynaParameters.getInstanceFromString((String)((String)obj));
        }
        return null;
    }

    public static void saveParametersToCell(Cell curCell, DynaParameters parameters) {
        ItemFormula curF;
        Object curCellObj = curCell.getUserObjectValue("ITEM");
        if (curCellObj != null && curCellObj instanceof ItemFormula) {
            curF = (ItemFormula)curCellObj;
        } else {
            curF = new ItemFormula();
            curCell.setUserObject("ITEM", (Object)curF);
        }
        curF.putExt("DynaParameters", parameters.toString());
    }

    public static Rectangle getRectangle(Sheet sheet, Point point) {
        DynaParameters parameters = DynamicTemplateUtility.getDynaParametersFromCell(sheet.getCell(point.y, point.x, false));
        int headWidth = DynamicTemplateUtility.getDynaHeadItemCount(sheet, point);
        int bodyHeight = parameters.getDefaultCounter();
        if (parameters.isIncludeSum()) {
            ++bodyHeight;
        }
        if (parameters.getSpreadStyle() == 0) {
            return new Rectangle(point.x, point.y, headWidth + 1, bodyHeight + 1);
        }
        if (parameters.getSpreadStyle() == 1) {
            return new Rectangle(point.x, point.y, bodyHeight + 1, headWidth + 1);
        }
        return null;
    }

    public static int getDynaHeadItemCount(Sheet table, Point point) {
        int result;
        block4: {
            int spreadStyle;
            Cell cell;
            block3: {
                DynaParameters parameters = DynamicTemplateUtility.getDynaParametersFromCell(table.getCell(point.y, point.x, false));
                cell = null;
                if (parameters == null) {
                    return 0;
                }
                result = 0;
                spreadStyle = parameters.getSpreadStyle();
                if (spreadStyle != 0) break block3;
                for (int i = point.x; i < table.getMaxColIndex(); ++i) {
                    cell = table.getCell(point.y, i, false);
                    if (!DynamicTemplateUtility.hasItemFormula(cell)) continue;
                    ++result;
                }
                break block4;
            }
            if (spreadStyle != 1) break block4;
            for (int i = point.y; i < table.getMaxRowIndex(); ++i) {
                cell = table.getCell(i, point.x, false);
                if (!DynamicTemplateUtility.hasItemFormula(cell)) continue;
                ++result;
            }
        }
        return result;
    }

    public static ArrayList getDynaHeadItemList(Sheet sheet, Point point) throws EASBizException, BOSException {
        ArrayList<DynaHeadItem> list;
        block4: {
            int spreadStyle;
            Cell cell;
            block3: {
                DynaParameters parameters = DynamicTemplateUtility.getDynaParametersFromCell(sheet.getCell(point.y, point.x, false));
                list = new ArrayList<DynaHeadItem>();
                cell = null;
                if (parameters == null) {
                    return list;
                }
                spreadStyle = parameters.getSpreadStyle();
                if (spreadStyle != 0) break block3;
                for (int i = point.x; i < sheet.getMaxColIndex(); ++i) {
                    cell = sheet.getCell(point.y, i, false);
                    if (!DynamicTemplateUtility.hasItemFormula(cell)) continue;
                    list.add(DynaHeadItem.getInstanceFromFormula((ItemFormula)((ItemFormula)cell.getUserObjectValue("ITEM"))));
                }
                break block4;
            }
            if (spreadStyle != 1) break block4;
            for (int i = point.y; i < sheet.getMaxRowIndex(); ++i) {
                cell = sheet.getCell(i, point.x, false);
                if (!DynamicTemplateUtility.hasItemFormula(cell)) continue;
                list.add(DynaHeadItem.getInstanceFromFormula((ItemFormula)((ItemFormula)cell.getUserObjectValue("ITEM"))));
            }
        }
        return list;
    }

    public static Point getBasePoint(Sheet sheet, Point point, ArrayList basePointList) {
        for (Point element : basePointList) {
            if (!DynamicTemplateUtility.getRectangle(sheet, element).contains(point)) continue;
            return element;
        }
        return null;
    }

    public static Point getLastPoint(ArrayList basePointList) {
        int[] temp = new int[basePointList.size()];
        int max = 0;
        for (int i = 0; i < basePointList.size(); ++i) {
            Point point = (Point)basePointList.get(i);
            temp[i] = point.x + point.y;
            if (temp[i] <= max) continue;
            max = temp[i];
        }
        int index = Arrays.binarySearch(temp, max);
        return (Point)basePointList.get(index);
    }

    public static void clearDynaTableFirst(List sheets) {
        Sheet sheet = null;
        Cell cell = null;
        int n = sheets.size();
        for (int i = 0; i < n; ++i) {
            sheet = (Sheet)sheets.get(i);
            if (sheet == null) continue;
            int rowCount = sheet.getMaxRowIndex();
            int colCount = sheet.getMaxColIndex();
            ArrayList baseList = DynamicTemplateUtility.getBasePointList(sheet);
            int m = baseList.size();
            for (int j = 0; j < m; ++j) {
                int col;
                int row;
                int k;
                boolean isLeftUp;
                Point basePoint = (Point)baseList.get(j);
                DynaParameters param = DynamicTemplateUtility.getDynaParameters(sheet, basePoint);
                if (param == null) continue;
                boolean isHorizon = param.getSpreadStyle() == 1;
                boolean bl = isLeftUp = param.getPosition() == 1;
                if (param.getSumMethod().equals((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE)) continue;
                ArrayList<Integer> xList = new ArrayList<Integer>();
                ArrayList<Integer> yList = new ArrayList<Integer>();
                if (isHorizon) {
                    yList.add(new Integer(basePoint.y));
                } else {
                    xList.add(new Integer(basePoint.x));
                }
                int start = isHorizon ? basePoint.y + 1 : basePoint.x + 1;
                int end = isHorizon ? rowCount : colCount;
                for (k = start; k < end; ++k) {
                    row = isHorizon ? k : basePoint.y;
                    cell = sheet.getCell(row, col = isHorizon ? basePoint.x : k, false);
                    if (cell == null || !DynamicTemplateUtility.hasItemFormula(cell)) continue;
                    if (isHorizon) {
                        yList.add(new Integer(k));
                        continue;
                    }
                    xList.add(new Integer(k));
                }
                start = isHorizon ? basePoint.x + 1 : basePoint.y + 1;
                end = isHorizon ? basePoint.x : basePoint.y;
                end += param.getDefaultCounter();
                if (param.isIncludeSum() && isLeftUp) {
                    ++start;
                    ++end;
                }
                for (k = start; k <= end; ++k) {
                    row = isHorizon ? basePoint.y : k;
                    cell = sheet.getCell(row, col = isHorizon ? k : basePoint.x, false);
                    if (cell == null || k == start && cell.isLocked() || cell.getValue() == null) continue;
                    if (isHorizon) {
                        xList.add(new Integer(k));
                        continue;
                    }
                    yList.add(new Integer(k));
                }
                Integer xInt2 = null;
                Integer yInt2 = null;
                for (Integer xInt2 : xList) {
                    for (Integer yInt2 : yList) {
                        cell = sheet.getCell(yInt2.intValue(), xInt2.intValue(), false);
                        if (cell == null) continue;
                        cell.setValue(null);
                        cell.removeUserObject("ITEM");
                        cell.setFormula(null);
                    }
                }
            }
        }
    }

    public static Point getSumPoint(Sheet sheet, Point basePoint, DynaParameters param) {
        boolean isHorizon = param.getSpreadStyle() == 1;
        boolean isLeftUp = param.getPosition() == 1;
        int baseLine = isHorizon ? basePoint.x + 1 : basePoint.y + 1;
        baseLine = isLeftUp ? ++baseLine : baseLine;
        int sumCount = param.getDefaultCounter();
        int sumLine = isHorizon ? (isLeftUp ? basePoint.x + 1 : basePoint.x + sumCount + 1) : (isLeftUp ? basePoint.y + 1 : basePoint.y + sumCount + 1);
        int sumCol = isHorizon ? basePoint.y + 1 : basePoint.x;
        return isHorizon ? new Point(sumCol, sumLine) : new Point(sumLine, sumCol);
    }

    public static void autoAdjustSum(Sheet sheet, Point basePoint, int actualSize) {
        int baseLine;
        DynaParameters param = DynamicTemplateUtility.getDynaParameters(sheet, basePoint);
        if (param == null) {
            return;
        }
        boolean isHorizon = param.getSpreadStyle() == 1;
        boolean isLeftUp = param.getPosition() == 1;
        int n = baseLine = isHorizon ? basePoint.x + 1 : basePoint.y + 1;
        if (isLeftUp) {
            ++baseLine;
        }
        if (param.isIncludeSum()) {
            int sumLine = isHorizon ? (isLeftUp ? basePoint.x + 1 : basePoint.x + actualSize + 1) : (isLeftUp ? basePoint.y + 1 : basePoint.y + actualSize + 1);
            int start = isHorizon ? basePoint.y + 1 : basePoint.x + 1;
            int end = isHorizon ? sheet.getMaxRowIndex() : sheet.getMaxColIndex();
            for (int dot = start; dot <= end; ++dot) {
                String cellEnd;
                String exp;
                int col;
                int row = isHorizon ? dot : sumLine;
                Cell cell = sheet.getCell(row, col = isHorizon ? sumLine : dot, false);
                if (cell == null || (exp = cell.getFormula()) == null || !exp.toLowerCase().matches("\\=sum\\(.+")) continue;
                String cellStart = isHorizon ? Location.getCellName((int)dot, (int)baseLine) : Location.getCellName((int)baseLine, (int)dot);
                String string = cellEnd = isHorizon ? Location.getCellName((int)dot, (int)(baseLine + actualSize - 1)) : Location.getCellName((int)(baseLine + actualSize - 1), (int)dot);
                if (actualSize == 0) {
                    cell.setFormula(null);
                    continue;
                }
                cell.setFormula("=sum(" + cellStart + ":" + cellEnd + ")");
            }
        }
    }

    private static boolean beforeRowColEdit(Sheet sheet, int index, boolean isRow, boolean isInsert) {
        int minimum;
        boolean isLeftUp;
        ArrayList baseList = DynamicTemplateUtility.getBasePointList(sheet);
        if (baseList == null || baseList.size() == 0) {
            return false;
        }
        Point basePoint = (Point)baseList.get(0);
        Cell cell = sheet.getCell(basePoint.y, basePoint.x, false);
        if (cell == null) {
            return false;
        }
        DynaParameters param = DynamicTemplateUtility.getDynaParametersFromCell(cell);
        if (param == null) {
            return false;
        }
        boolean isHorizon = param.getSpreadStyle() == 1;
        boolean bl = isLeftUp = param.getPosition() == 1;
        if (isHorizon == isRow) {
            return false;
        }
        boolean found = false;
        int n = minimum = isHorizon ? basePoint.x + 1 : basePoint.y + 1;
        if (index <= minimum) {
            return false;
        }
        for (int i = 0; i < baseList.size(); ++i) {
            if (baseList.size() > 0) {
                basePoint = (Point)baseList.get(i);
                cell = sheet.getCell(basePoint.y, basePoint.x, false);
                param = DynamicTemplateUtility.getDynaParametersFromCell(cell);
                isLeftUp = param.getPosition() == 1;
                int n2 = minimum = isHorizon ? basePoint.x + 1 : basePoint.y + 1;
                if (!isInsert && (isRow && basePoint.y == index || !isRow && basePoint.x == index)) {
                    MsgBox.showError(CslRptClientResourceHelper.getString("113_DynamicTemplateUtility"));
                    return true;
                }
            }
            int counter = param.getDefaultCounter();
            int maximum = minimum + counter - 1;
            int n3 = maximum = param.isIncludeSum() ? maximum + 1 : maximum;
            if (index < minimum || index > maximum) continue;
            if (isInsert) {
                if (isLeftUp && index == minimum) {
                    MsgBox.showError(CslRptClientResourceHelper.getString("114_DynamicTemplateUtility"));
                    return true;
                }
            } else if (isLeftUp && index == minimum || !isLeftUp && index == maximum) {
                MsgBox.showError(CslRptClientResourceHelper.getString("115_DynamicTemplateUtility"));
                return true;
            }
            counter = isInsert ? counter + 1 : counter - 1;
            param.setDefaultCounter(counter);
            found = true;
            break;
        }
        if (found) {
            DynamicTemplateUtility.saveParametersToCell(cell, param);
        }
        return false;
    }

    public static boolean beforeAddRow(Sheet sheet, int row) {
        return DynamicTemplateUtility.beforeRowColEdit(sheet, row, true, true);
    }

    public static boolean beforeAddColumn(Sheet sheet, int col) {
        return DynamicTemplateUtility.beforeRowColEdit(sheet, col, false, true);
    }

    public static boolean beforeDeleteRow(Sheet sheet, int row) {
        return DynamicTemplateUtility.beforeRowColEdit(sheet, row, true, false);
    }

    public static boolean beforeDeleteColumn(Sheet sheet, int col) {
        return DynamicTemplateUtility.beforeRowColEdit(sheet, col, false, false);
    }

    public static void autoAdjustPasteRange(Sheet sheet, int rowStart, int colStart, int rowEnd, int colEnd) {
        ArrayList baseList = DynamicTemplateUtility.getBasePointList(sheet);
        if (baseList == null || baseList.size() == 0) {
            return;
        }
        Point basePoint = (Point)baseList.get(0);
        if (basePoint == null) {
            return;
        }
        Cell cell = sheet.getCell(basePoint.y, basePoint.x, false);
        if (cell == null) {
            return;
        }
        DynaParameters param = DynamicTemplateUtility.getDynaParametersFromCell(cell);
        if (param == null) {
            return;
        }
        boolean isHorizon = param.getSpreadStyle() == 1;
        Object[] baseArray = baseList.toArray();
        if (isHorizon) {
            Arrays.sort(baseArray, new PointXComparator());
        } else {
            Arrays.sort(baseArray, new PointXComparator());
        }
        for (int i = baseList.size() - 1; i >= 0; --i) {
            int indexForwardEnd;
            int indexItem;
            basePoint = (Point)baseList.get(i);
            int indexSideStart = isHorizon ? rowStart : colStart;
            int indexSideEnd = isHorizon ? rowEnd : colEnd;
            int n = indexItem = isHorizon ? basePoint.y : basePoint.x;
            if (indexItem < indexSideStart && indexItem > indexSideEnd) continue;
            cell = sheet.getCell(basePoint.y, basePoint.x, false);
            param = DynamicTemplateUtility.getDynaParametersFromCell(cell);
            boolean isIncludeSum = param.isIncludeSum();
            boolean isLeftUp = param.getPosition() == 1;
            int minimum = isHorizon ? basePoint.x + 1 : basePoint.y + 1;
            minimum = isIncludeSum && isLeftUp ? minimum + 1 : minimum;
            int maximum = minimum + param.getDefaultCounter() - 1;
            int indexForwardStart = isHorizon ? colStart : rowStart;
            int n2 = indexForwardEnd = isHorizon ? colEnd : rowEnd;
            if (indexForwardStart < minimum || indexForwardStart > maximum) continue;
            if (indexForwardEnd < maximum - 1) break;
            int diff = indexForwardEnd - maximum + 1;
            for (int j = 0; j < diff; ++j) {
                Range rg;
                if (isHorizon) {
                    rg = sheet.getColRange(maximum + 1, maximum + 1);
                    rg.insert();
                    continue;
                }
                rg = sheet.getRowRange(maximum + 1, maximum + 1);
                rg.insert();
            }
            param.setDefaultCounter(param.getDefaultCounter() + diff);
            DynamicTemplateUtility.saveParametersToCell(cell, param);
            DynamicTemplateUtility.autoAdjustSum(sheet, basePoint, param.getDefaultCounter());
            break;
        }
    }

    public static boolean checkItem(Book book) {
        HashSet<String> formulaCache = new HashSet<String>();
        Cell cell = null;
        BookProperties bookProperties = BookProperties.loadFromSpread(book);
        for (int n = 0; n < book.getSheetCount(); ++n) {
            CSLReportGroupEnum groupEnum;
            String value;
            Sheet sheet = book.getSheet(n);
            VariableEntry entry = bookProperties.getVariables().get("SheetClass", sheet.getSheetName());
            if (entry != null && (value = entry.getValue()) != null && !(groupEnum = CSLReportGroupEnum.getEnum((int)Integer.parseInt(value))).equals((Object)CSLReportGroupEnum.COMMON)) continue;
            for (int i = 0; i <= sheet.getMaxRowIndex(); ++i) {
                for (int j = 0; j <= sheet.getMaxColIndex(); ++j) {
                    ItemFormula itemFormula;
                    String formula;
                    Object obj;
                    cell = sheet.getCell(i, j, false);
                    if (cell == null || (obj = cell.getUserObjectValue("ITEM")) == null || !(obj instanceof ItemFormula) || (formula = (itemFormula = (ItemFormula)obj).getFormula()) == null || formula.length() == 0) continue;
                    itemFormula.removeExt("20");
                    if (formulaCache.contains(formula)) {
                        itemFormula.putExt("20", "24");
                        return false;
                    }
                    formulaCache.add(formula);
                }
            }
        }
        return true;
    }

    public static String checkNumber(Book book) {
        ReportVariables variable = ReportVariables.loadFromBook((Book)book);
        boolean bError = false;
        StringBuffer sb = new StringBuffer("\u5728\u57fa\u7840\u8d44\u6599\u4e2d\u627e\u4e0d\u5230\u7684\u516c\u53f8\u7f16\u7801\u6240\u5bf9\u5e94\u7684\u5355\u5143\u683c\u4f4d\u7f6e\u5982\u4e0b\uff1a");
        for (int j = 0; j < book.getSheetCount(); ++j) {
            boolean firstError = true;
            Sheet sheet = book.getSheet(j);
            int sheet_type = variable.getIntValue("SheetClass", sheet.getSheetName(), 1);
            if (sheet_type == 10 || sheet_type == 20) {
                int bottom;
                int left;
                HashMap basePosition = CslRptUtil.getBasePosition((Sheet)sheet);
                if (basePosition == null || basePosition.size() < 1) continue;
                int right = left = ((Integer)basePosition.get("left")).intValue();
                int top = (Integer)basePosition.get("top") + 1;
                String checkResult = DynamicTemplateUtility.checkRange(sheet, top, left, bottom = sheet.getMaxRowIndex(), right, firstError, true, false);
                if (checkResult.length() <= 0) continue;
                bError = true;
                firstError = false;
                sb.append(checkResult);
                continue;
            }
            if (sheet_type != 1) continue;
            ArrayList basePointList = DynamicTemplateUtility.getBasePointList(sheet);
            for (Point basePoint : basePointList) {
                String checkResult;
                boolean isVertical;
                int right;
                int left;
                int bottom;
                int top;
                DynaParameters param = DynamicTemplateUtility.getDynaParameters(sheet, basePoint);
                DItemGradeInfo info = (DItemGradeInfo)sheet.getRange(basePoint.y, basePoint.x).getUserObject("DItemGradeInfo");
                if (param.isGrade() && info != null) {
                    top = basePoint.y;
                    bottom = basePoint.y;
                    left = basePoint.x;
                    right = basePoint.x;
                    for (DItemGradeEntryInfo entry : info.getEntries()) {
                        String checkResult2;
                        if (param.getSpreadStyle() == 0) {
                            isVertical = true;
                            ++left;
                            ++right;
                            top = param.getPosition() == 1 ? bottom + 2 : bottom + 1;
                            bottom = top + entry.getDetailCount() - 1;
                        } else {
                            isVertical = false;
                            left = param.getPosition() == 1 ? right + 2 : right + 1;
                            right = left + entry.getDetailCount() - 1;
                            ++top;
                            ++bottom;
                        }
                        if (entry.getDetailSource() == 1 && (checkResult2 = DynamicTemplateUtility.checkRange(sheet, top, left, bottom, right, firstError, isVertical, true)).length() > 0) {
                            bError = true;
                            firstError = false;
                            sb.append(checkResult2);
                        }
                        if (param.getPosition() != 2) continue;
                        if (param.getSpreadStyle() == 0) {
                            ++bottom;
                            continue;
                        }
                        ++right;
                    }
                    continue;
                }
                if (param.getDynaItemSource() != 1) continue;
                if (param.getSpreadStyle() == 0) {
                    isVertical = true;
                    right = left = basePoint.x + 1;
                    top = param.getPosition() == 1 ? basePoint.y + 2 : basePoint.y + 1;
                    bottom = top + param.getDefaultCounter() - 1;
                } else {
                    isVertical = false;
                    bottom = top = basePoint.y + 1;
                    left = param.getPosition() == 1 ? basePoint.x + 2 : basePoint.x + 1;
                    right = left + param.getDefaultCounter() - 1;
                }
                if ((checkResult = DynamicTemplateUtility.checkRange(sheet, top, left, bottom, right, firstError, isVertical, true)).length() <= 0) continue;
                bError = true;
                firstError = false;
                sb.append(checkResult);
            }
        }
        if (bError) {
            return sb.toString();
        }
        return null;
    }

    public static String checkRange(Sheet sheet, int top, int left, int bottom, int right, boolean firstError, boolean isVertical, boolean isDynamic) {
        StringBuffer errorPlaceInfo = new StringBuffer("");
        Sheet.ICellsIterator it = sheet.getCellsIterator(top, left, bottom, right, false, true);
        while (it.hasNext()) {
            Cell cell = it.next();
            if (cell.getFormula() != null && (cell.getFormula() + "").toUpperCase().indexOf("SUM") > -1) continue;
            String companyId = null;
            if (isDynamic) {
                ItemFormula item = UserObjectHelper.getItemFormula((Cell)cell);
                if (item != null) {
                    String[] companyIds;
                    String companyLongNumber = item.getExt("26");
                    if (companyLongNumber.indexOf("!") > 0) {
                        companyIds = companyLongNumber.split("!");
                        companyId = companyIds[companyIds.length - 1];
                    } else {
                        companyIds = companyLongNumber.split("_");
                        companyId = companyIds[companyIds.length - 1];
                    }
                }
            } else {
                if (cell == null || cell.getValue().isEmpty() || cell.getValue().isNull()) continue;
                companyId = (cell.getValue() + "").split("-")[0];
            }
            if (companyId == null || DynamicTemplateUtility.getCompanyList().contains(companyId)) continue;
            if (firstError) {
                errorPlaceInfo.append("\n" + sheet.getSheetName() + "\n");
                firstError = false;
            } else {
                errorPlaceInfo.append(", ");
            }
            if (isDynamic) {
                if (isVertical) {
                    errorPlaceInfo.append(TableToolkit.xy2range((int)(cell.getCol() - 1), (int)cell.getRow()));
                    continue;
                }
                errorPlaceInfo.append(TableToolkit.xy2range((int)cell.getCol(), (int)(cell.getRow() - 1)));
                continue;
            }
            errorPlaceInfo.append(TableToolkit.xy2range((int)cell.getCol(), (int)cell.getRow()));
        }
        return errorPlaceInfo.toString();
    }

    public static ArrayList getCompanyList() {
        ArrayList<String> companyList = null;
        if (companyList == null) {
            String sqlStr = "select fnumber from T_EAS_Company";
            IRowSet rs = null;
            try {
                rs = DbUtil.executeQuery(sqlStr);
                companyList = new ArrayList<String>(rs.size());
                while (rs.next()) {
                    companyList.add(rs.getString("fnumber"));
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return companyList;
    }

    public static void clearDynaTableFirst(Sheet table) {
        Range range = null;
        if (table == null) {
            return;
        }
        if (!table.isEnableCalculation()) {
            return;
        }
        int rowCount = table.getRows().getMaxIntMark() + 1;
        int colCount = table.getCols().getMaxIntMark() + 1;
        ArrayList baseList = DynamicTemplateUtility.getBasePointList(table);
        int m = baseList.size();
        for (int j = 0; j < m; ++j) {
            int col;
            int row;
            int k;
            boolean isLeftUp;
            Point basePoint = (Point)baseList.get(j);
            DynaParameters param = DynamicTemplateUtility.getDynaParameters(table, basePoint);
            if (param == null) continue;
            boolean isHorizon = param.getSpreadStyle() == 1;
            boolean bl = isLeftUp = param.getPosition() == 1;
            if (param.getSumMethod().equals((Object)DynaSumMethodEnum.SUM_BY_TEMPLATE)) {
                return;
            }
            ArrayList<Integer> xList = new ArrayList<Integer>();
            ArrayList<Integer> yList = new ArrayList<Integer>();
            if (isHorizon) {
                yList.add(new Integer(basePoint.y));
            } else {
                xList.add(new Integer(basePoint.x));
            }
            int start = isHorizon ? basePoint.y + 1 : basePoint.x + 1;
            int end = isHorizon ? rowCount : colCount;
            for (k = start; k < end; ++k) {
                row = isHorizon ? k : basePoint.y;
                range = UserObjectHelper.getUnprotectedRange((Range)table.getRange(row, col = isHorizon ? basePoint.x : k));
                if (CslRptUIUtil.getFormula((Range)range) == null) continue;
                if (isHorizon) {
                    yList.add(new Integer(k));
                    continue;
                }
                xList.add(new Integer(k));
            }
            start = isHorizon ? basePoint.x + 1 : basePoint.y + 1;
            end = isHorizon ? basePoint.x : basePoint.y;
            end += param.getDefaultCounter();
            if (param.isIncludeSum() && isLeftUp) {
                ++start;
                ++end;
            }
            for (k = start; k <= end; ++k) {
                row = isHorizon ? basePoint.y : k;
                range = UserObjectHelper.getUnprotectedRange((Range)table.getRange(row, col = isHorizon ? k : basePoint.x));
                ItemFormula item = UserObjectHelper.getItemFormula((Range)range);
                if (item != null && item.isBasePoint() || k == start && range.isCellLocked() || range.getValue().isEmpty()) continue;
                if (isHorizon) {
                    xList.add(new Integer(k));
                    continue;
                }
                yList.add(new Integer(k));
            }
            Integer xInt2 = null;
            Integer yInt2 = null;
            for (Integer xInt2 : xList) {
                for (Integer yInt2 : yList) {
                    range = UserObjectHelper.getUnprotectedRange((Range)table.getRange(yInt2.intValue(), xInt2.intValue()));
                    range.setValue(Variant.nullVariant);
                    range.setFormula(null);
                    range.setUserObject("ITEM", null);
                }
            }
        }
    }
}

