/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient.util;

import com.kingdee.bos.service.netfile.ftp.FTPClient;
import com.kingdee.bos.service.netfile.ftp.FTPException;
import com.kingdee.bos.service.netfile.ftp.FTPTransferType;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.newrpt.util.CommonUtil;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FTPUpDown {
    private String ftpServer;
    private String ftpPort;
    private String ftpUserName;
    private String ftpPassword;
    private FTPClient ftpClient;
    private boolean isLogin = false;
    private ResourceBundleHelper resHelper = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.resource.CslClientUIResource");
    private Logger logger = Logger.getLogger(FTPUpDown.class);

    public FTPUpDown(String pFtpServer, String pFtpPort, String pFtpUserName, String pFtpPassword) throws Exception {
        this.ftpServer = pFtpServer;
        this.ftpPort = pFtpPort.trim().equals("") ? "21" : pFtpPort;
        this.ftpUserName = pFtpUserName.trim().equals("") ? "Anonymous" : pFtpUserName;
        this.ftpPassword = pFtpPassword;
        try {
            this.ftpClient = new FTPClient(this.ftpServer, Integer.parseInt(this.ftpPort));
            this.ftpClient.login(this.ftpUserName, this.ftpPassword);
            this.ftpClient.chdir("/");
            this.isLogin = true;
        }
        catch (FTPException e) {
            switch (e.getReplyCode()) {
                case 530: {
                    throw new Exception(CslRptClientResourceHelper.getString("116_FTPUpDown") + this.ftpUserName + CslRptClientResourceHelper.getString("117_FTPUpDown"), e);
                }
            }
            throw e;
        }
        catch (UnknownHostException e) {
            throw new Exception(CslRptClientResourceHelper.getString("118_FTPUpDown") + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new Exception(CslRptClientResourceHelper.getString("119_FTPUpDown"), e);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    public String uploadFolder(String folderName, String ftpPath) throws Exception {
        if (this.isLogin) {
            String strMsg;
            block12: {
                strMsg = "";
                try {
                    File file = new File(folderName);
                    if (file.isDirectory()) {
                        this.ftpClient.chdir("/");
                        this.ftpClient.setType(FTPTransferType.BINARY);
                        if (this.checkFolderIsExist(ftpPath)) {
                            this.ftpClient.chdir(ftpPath);
                        } else {
                            this.createFolder(ftpPath);
                        }
                        if (!this.checkFolderIsExist(file.getName())) {
                            this.ftpClient.mkdir(file.getName());
                        }
                        this.ftpClient.chdir(file.getName());
                        ftpPath = ftpPath + "/" + file.getName();
                        File[] files = file.listFiles();
                        for (int i = 0; i < files.length; ++i) {
                            if (files[i].isDirectory()) {
                                this.uploadFolder(files[i].getPath(), ftpPath);
                                continue;
                            }
                            if (!files[i].isFile()) continue;
                            try {
                                this.ftpClient.put(files[i].getPath(), files[i].getName());
                                continue;
                            }
                            catch (Exception ee) {
                                strMsg = strMsg + "upload file<<\uff1a" + files[i].getPath() + ">> error\uff01Message:" + ee.getMessage() + "\r\n";
                            }
                        }
                        if (!strMsg.equals("")) {
                            throw new Exception(strMsg);
                        }
                        break block12;
                    }
                    throw new Exception(folderName + " is not a folder'name!");
                }
                catch (Exception e) {
                    strMsg = strMsg + e.getMessage() + "\r\n";
                }
            }
            return strMsg;
        }
        throw new Exception("you didnot login remote ftp server!");
    }

    public void uploadAllFilesInFolder(String folderName, String ftpPath) throws Exception {
        block9: {
            if (this.isLogin) {
                String strMsg = "";
                try {
                    File file = new File(folderName);
                    if (file.isDirectory()) {
                        this.ftpClient.chdir("/");
                        this.ftpClient.setType(FTPTransferType.BINARY);
                        if (this.checkFolderIsExist(ftpPath)) {
                            this.ftpClient.chdir(ftpPath);
                        } else {
                            this.createFolder(ftpPath);
                        }
                        File[] files = file.listFiles();
                        for (int i = 0; i < files.length; ++i) {
                            if (!files[i].isFile()) continue;
                            try {
                                this.ftpClient.put(files[i].getPath(), files[i].getName());
                                continue;
                            }
                            catch (Exception ee) {
                                strMsg = strMsg + "upload file<<\uff1a" + files[i].getPath() + ">> error\uff01Message:" + ee.getMessage() + "\r\n";
                                System.out.println(strMsg);
                            }
                        }
                        break block9;
                    }
                    throw new Exception(folderName + " is not a folder'name!");
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage());
                }
            }
            throw new Exception("you didnot login remote ftp server!");
        }
    }

    public void uploadFile(String clientFileName, String ftpPath) throws Exception {
        if (this.isLogin) {
            try {
                String filename = "";
                int index = clientFileName.lastIndexOf("\\");
                filename = clientFileName.substring(index + 1);
                this.ftpClient.chdir("/");
                this.ftpClient.setType(FTPTransferType.BINARY);
                if (this.checkFolderIsExist(ftpPath)) {
                    this.ftpClient.chdir(ftpPath);
                } else {
                    this.createFolder(ftpPath);
                }
                this.ftpClient.put(clientFileName, filename);
            }
            catch (Exception ex) {
                throw new Exception(ex.getMessage());
            }
        } else {
            throw new Exception("you didnot login remote ftp server!");
        }
    }

    public boolean checkFolderIsExist(String pFolder) throws Exception {
        if (this.isLogin && !StringUtils.isEmpty((String)pFolder)) {
            boolean result = false;
            String upLayer = "..";
            String[] folders = pFolder.split("/");
            for (int i = 1; i < folders.length; ++i) {
                upLayer = upLayer + "/" + upLayer;
            }
            this.ftpClient.chdir(pFolder);
            this.ftpClient.chdir(upLayer);
            result = true;
            return result;
        }
        throw new Exception("you didnot login remote ftp server!");
    }

    public void createFolder(String pFolder) throws Exception {
        if (this.isLogin) {
            if (!this.checkFolderIsExist(pFolder)) {
                try {
                    String path = "";
                    this.ftpClient.chdir("/");
                    String[] folders = pFolder.split("/");
                    for (int i = 0; i < folders.length; ++i) {
                        try {
                            this.ftpClient.chdir(folders[i]);
                            continue;
                        }
                        catch (Exception ex) {
                            this.ftpClient.mkdir(folders[i]);
                            this.ftpClient.chdir(folders[i]);
                        }
                    }
                }
                catch (Exception ex) {
                    throw new Exception(ex.getMessage());
                }
            }
        } else {
            throw new Exception("you didnot login remote ftp server!");
        }
    }

    public void downFolder(String folderName, String localPath) throws Exception {
        File filePath = new File(localPath);
        if (!filePath.exists()) {
            filePath.mkdirs();
        }
        if (this.ftpClient.getType() != FTPTransferType.BINARY) {
            this.ftpClient.setType(FTPTransferType.BINARY);
        }
        this.ftpClient.chdir(folderName);
        String[] files = this.ftpClient.dir();
        for (int i = 0; i < files.length; ++i) {
            String file = files[i];
            if (file.indexOf(".") == -1) {
                try {
                    this.ftpClient.chdir(file);
                    this.ftpClient.chdir("..");
                }
                catch (Exception e) {
                    System.err.println("can't chdir dir to the file(" + file + ") without extend name.");
                    continue;
                }
                this.downFolder(file, localPath + File.separator + file);
                this.ftpClient.chdir("..");
                continue;
            }
            this.ftpClient.get(localPath + File.separator + file, file);
        }
    }

    public void downFolder(String ftpPath, String folderName, String localPath) throws Exception {
        File filePath = new File(localPath + File.separator + folderName);
        if (!filePath.exists()) {
            filePath.mkdirs();
        }
        this.downFolder(ftpPath + File.separator + folderName, localPath + File.separator + folderName);
    }

    public void downFile(String ftpPath, String ftpFileName, String localPath) throws Exception {
        this.ftpClient.setType(FTPTransferType.BINARY);
        boolean existPath = false;
        if (!StringUtils.isEmpty((String)ftpPath)) {
            existPath = this.checkFolderIsExist(ftpPath);
        }
        if (!existPath) {
            String msg = MessageFormat.format(CommonUtil.getResource("downPathNotExists"), ftpPath);
            throw new FileNotFoundException(msg);
        }
        this.ftpClient.chdir(ftpPath);
        if (!this.isExistFile(ftpFileName)) {
            throw new FileNotFoundException(this.resHelper.getString("FTPFileNotExist") + ":" + ftpFileName);
        }
        this.ftpClient.get(localPath + "/" + ftpFileName, ftpFileName);
        System.out.println("download file '" + ftpFileName + "'successed!");
    }

    public boolean downSearchFile(String ftpPath, String fileName, String localPath) throws Exception {
        File filePath = new File(localPath);
        if (!filePath.exists()) {
            filePath.mkdirs();
        }
        if (this.ftpClient.getType() != FTPTransferType.BINARY) {
            this.ftpClient.setType(FTPTransferType.BINARY);
        }
        this.ftpClient.chdir(ftpPath);
        String[] files = this.ftpClient.dir();
        for (int i = 0; i < files.length; ++i) {
            String file = files[i];
            if (file.indexOf(".") == -1) {
                try {
                    this.ftpClient.chdir(file);
                    this.ftpClient.chdir("..");
                }
                catch (Exception e) {
                    System.err.println("can't chdir to the file(" + file + ") without extend name.");
                    continue;
                }
                boolean b = this.downSearchFile(file, fileName, localPath);
                if (b) {
                    return true;
                }
                this.ftpClient.chdir("..");
                continue;
            }
            if (!fileName.equalsIgnoreCase(file)) continue;
            this.ftpClient.get(localPath + "/" + file, file);
            return true;
        }
        return false;
    }

    public void resetPath() throws Exception {
        this.ftpClient.chdir("/");
    }

    public boolean isExistFile(String ftpFileName) {
        try {
            this.ftpClient.setType(FTPTransferType.BINARY);
            Date date = this.ftpClient.modtime(ftpFileName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void main(String[] args) {
        FTPUpDown.testIsExistFile();
    }

    private static void testUpload() {
        try {
            FTPUpDown ftp = new FTPUpDown("192.168.18.239", "21", "administrator", "administrator");
            ftp.uploadAllFilesInFolder("c:/temp/temp/", "k3test");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private static void testDownload() {
        try {
            FTPUpDown ftp = new FTPUpDown("192.168.18.239", "21", "administrator", "administrator");
            ftp.downFile("k3test", "RPTDataServiceControllerBean.java", "c:/temp/temp/download");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private static void testDownload1() {
        try {
            FTPUpDown ftp = new FTPUpDown("202.105.139.162", "21", "wzf", "wangzf123");
            ftp.downFile("", "zjmi0731.rar", "c:\\temp\\temp\\download");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private static void testIsExistFile() {
        try {
            FTPUpDown ftp = new FTPUpDown("192.168.18.239", "21", "administrator", "administrator");
            if (ftp.isExistFile(CslRptClientResourceHelper.getString("120_FTPUpDown"))) {
                System.out.println("File Exist\uff01");
            } else {
                System.out.println("File Not Exist\uff01");
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public String[] getDPFFile(String ftpPath, String curCompanyNumber) {
        try {
            HashSet<String> hasHset = new HashSet<String>();
            String[] fileNameArr = this.ftpClient.dir(ftpPath);
            Locale locale = SysContext.getSysContext().getLocale();
            int n = fileNameArr.length;
            for (int i = 0; i < n; ++i) {
                if (!fileNameArr[i].startsWith(curCompanyNumber) || !fileNameArr[i].toUpperCase(locale).endsWith("DPF")) continue;
                hasHset.add(fileNameArr[i]);
            }
            String[] fielNameArr = new String[hasHset.size()];
            Iterator iterator = hasHset.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                fielNameArr[i++] = (String)iterator.next();
            }
            return fielNameArr;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (FTPException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Map getRemoteJarLastModifiedTime(String ftpPath) throws Exception {
        HashMap<String, Long> timeCache = new HashMap<String, Long>();
        String[] jarFileNames = this.getJarFileNames(ftpPath, ".jar");
        try {
            int size = jarFileNames.length;
            for (int i = 0; i < size; ++i) {
                long time = this.ftpClient.modtime(ftpPath + File.separator + jarFileNames[i]).getTime();
                timeCache.put(jarFileNames[i], new Long(time));
            }
        }
        catch (Exception e) {
            this.logger.info((Object)(CslRptClientResourceHelper.getString("121_FTPUpDown") + ftpPath + CslRptClientResourceHelper.getString("122_FTPUpDown") + e));
            System.out.println(CslRptClientResourceHelper.getString("121_FTPUpDown") + ftpPath + CslRptClientResourceHelper.getString("122_FTPUpDown") + e);
            throw e;
        }
        return timeCache;
    }

    public String[] getJarFileNames(String ftpPath, String suffix) throws Exception {
        HashSet<String> nameSet = new HashSet<String>();
        ArrayList<String> list = new ArrayList<String>();
        try {
            String[] fileNameArr = this.ftpClient.dir(ftpPath);
            int n = fileNameArr.length;
            for (int i = 0; i < n; ++i) {
                nameSet.add(fileNameArr[i]);
            }
            for (String filename : nameSet) {
                if (!filename.endsWith(suffix)) continue;
                list.add(filename);
            }
            String[] fielNameArr = new String[list.size()];
            return list.toArray(fielNameArr);
        }
        catch (Exception e) {
            this.logger.info((Object)(CslRptClientResourceHelper.getString("121_FTPUpDown") + ftpPath + CslRptClientResourceHelper.getString("123_FTPUpDown") + e));
            System.out.println(CslRptClientResourceHelper.getString("121_FTPUpDown") + ftpPath + CslRptClientResourceHelper.getString("123_FTPUpDown") + e);
            throw e;
        }
    }

    public void quit() throws IOException, FTPException {
        this.ftpClient.quit();
    }
}

