/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.update;

import com.kingdee.bos.service.netfile.ftp.FTPException;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.gr.rptclient.util.FTPUpDown;
import com.kingdee.eas.rptclient.gr.update.FtpConfigService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class UpdateJarFileService {
    private static final String SRC_PATH = "lib" + File.separator + "sp";
    private static final String DEST_PATH = "lib" + File.separator + "bak";
    private static Logger logger = Logger.getLogger(UpdateJarFileService.class);

    public static void main(String[] args) {
        UpdateJarFileService.clientUpdateJarFromFTP();
    }

    public static void bakFile() {
        String src = UpdateJarFileService.getAbsolutenessPath(SRC_PATH);
        String dest = UpdateJarFileService.getAbsolutenessPath(DEST_PATH);
        UpdateJarFileService.traverse(src, dest);
    }

    public static boolean clientUpdateJarFromFTP() {
        Map lastmodifiedMap = UpdateJarFileService.getFilesLastmodifiedTime(SRC_PATH);
        String localpath = UpdateJarFileService.getAbsolutenessPath(SRC_PATH);
        String ftpPath = FtpConfigService.getInstance().getDFPath();
        try {
            FTPUpDown ftpClient = UpdateJarFileService.getFTPUpDown();
            Map remoteLasttimeMap = ftpClient.getRemoteJarLastModifiedTime(ftpPath);
            for (Map.Entry entry : remoteLasttimeMap.entrySet()) {
                String filename = (String)entry.getKey();
                if (!UpdateJarFileService.isBig(entry, lastmodifiedMap)) continue;
                ftpClient.downFile(ftpPath, filename, localpath);
                ftpClient.resetPath();
                UpdateJarFileService.modifiedLasttime(entry, localpath);
            }
            ftpClient.quit();
        }
        catch (Exception e) {
            logger.info((Object)("\u66f4\u65b0FTPjar\u5305\u5931\u8d25." + e));
            System.out.println(e);
            return false;
        }
        return true;
    }

    public static boolean haveNewJarToUpdate() throws Exception {
        Map lastmodifiedMap = UpdateJarFileService.getFilesLastmodifiedTime(SRC_PATH);
        String ftpPath = FtpConfigService.getInstance().getDFPath();
        try {
            FTPUpDown ftpClient = UpdateJarFileService.getFTPUpDown();
            Map remoteLasttimeMap = ftpClient.getRemoteJarLastModifiedTime(ftpPath);
            for (Map.Entry entry : remoteLasttimeMap.entrySet()) {
                if (!UpdateJarFileService.isBig(entry, lastmodifiedMap)) continue;
                return true;
            }
            ftpClient.quit();
        }
        catch (FTPException e) {
            logger.info((Object)("excu:haveNewJarToUpdate \u51fa\u9519\uff1a" + (Object)((Object)e)));
            System.out.println("excu:haveNewJarToUpdate \u51fa\u9519\uff1a" + (Object)((Object)e));
            switch (e.getReplyCode()) {
                case 550: {
                    throw new Exception(MessageFormat.format(CslRptClientResourceHelper.getString("119_FileNotExists"), ftpPath), e);
                }
            }
            throw e;
        }
        return false;
    }

    public static FTPUpDown getFTPUpDown() throws Exception {
        String ip = FtpConfigService.getInstance().getIp();
        String logname = FtpConfigService.getInstance().getLogname();
        String password = FtpConfigService.getInstance().getPassword();
        return new FTPUpDown(ip, "", logname, password);
    }

    private static boolean isBig(Map.Entry entry, Map lastmodifiedMap) {
        Long temp;
        if (lastmodifiedMap == null || lastmodifiedMap.isEmpty() || !lastmodifiedMap.keySet().contains(entry.getKey())) {
            return true;
        }
        String filename = (String)entry.getKey();
        Long lastmodified = (Long)entry.getValue();
        return lastmodified.compareTo(temp = (Long)lastmodifiedMap.get(filename)) > 0;
    }

    private static void modifiedLasttime(Map.Entry entry, String localpath) {
        String fullname = localpath + File.separator + (String)entry.getKey();
        long lastmodifiedtime = (Long)entry.getValue();
        File file = new File(fullname);
        if (file.exists()) {
            file.setLastModified(lastmodifiedtime);
        }
    }

    private static void traverse(String src, String dest) {
        File file = new File(src);
        if (!file.isDirectory()) {
            UpdateJarFileService.copy(src, dest + File.separator + file.getName());
        } else {
            for (File child : file.listFiles()) {
                UpdateJarFileService.traverse(child.getPath(), dest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(String src, String dest) {
        FileInputStream srcIns = null;
        FileOutputStream destOuts = null;
        AbstractInterruptibleChannel srcCh = null;
        AbstractInterruptibleChannel destCh = null;
        try {
            int r;
            srcIns = new FileInputStream(src);
            destOuts = new FileOutputStream(dest);
            srcCh = srcIns.getChannel();
            destCh = destOuts.getChannel();
            ByteBuffer bf = ByteBuffer.allocate(1024);
            while ((r = ((FileChannel)srcCh).read(bf)) != -1) {
                bf.flip();
                ((FileChannel)destCh).write(bf);
                bf.clear();
            }
            File srcfile = new File(src);
            File destfile = new File(dest);
            destfile.setLastModified(srcfile.lastModified());
        }
        catch (FileNotFoundException e) {
            logger.info((Object)("\u5907\u4efd\u6587\u4ef6\u4ecesp\u76ee\u5f55\u5230bak\u76ee\u5f55\u5931\u8d25\uff1a" + e));
        }
        catch (IOException e) {
            logger.info((Object)("\u5907\u4efd\u6587\u4ef6\u4ecesp\u76ee\u5f55\u5230bak\u76ee\u5f55\u5931\u8d25\uff1a" + e));
        }
        finally {
            if (srcCh != null) {
                try {
                    srcCh.close();
                }
                catch (IOException e) {
                    logger.error((Object)"srcCh.close()", (Throwable)e);
                }
            }
            if (destCh != null) {
                try {
                    destCh.close();
                }
                catch (IOException e) {
                    logger.error((Object)"destCh.close()", (Throwable)e);
                }
            }
            if (destOuts != null) {
                try {
                    destOuts.close();
                }
                catch (IOException e) {
                    logger.error((Object)"destOuts.close()", (Throwable)e);
                }
            }
            if (srcIns != null) {
                try {
                    srcIns.close();
                }
                catch (IOException e) {
                    logger.error((Object)"srcIns.close()", (Throwable)e);
                }
            }
        }
    }

    private static String getAbsolutenessPath(String comparePath) {
        String rootPath = System.getProperty("user.dir");
        rootPath = FilenameUtils.normalize((String)rootPath);
        File file = new File(rootPath);
        rootPath = file.getParent();
        String subpath = FilenameUtils.normalize((String)(rootPath + File.separator + comparePath));
        if (!(file = new File(subpath)).exists()) {
            file.mkdir();
        }
        return subpath;
    }

    private static Map getFilesLastmodifiedTime(String comparePath) {
        HashMap<String, Long> cache = new HashMap<String, Long>();
        String abspath = UpdateJarFileService.getAbsolutenessPath(comparePath);
        File dir = new File(abspath);
        if (dir.isDirectory()) {
            for (File child : dir.listFiles()) {
                if (!child.isFile()) continue;
                cache.put(child.getName(), new Long(child.lastModified()));
            }
        }
        return cache;
    }
}

