/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.update.ui;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDProgressBar;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.rptclient.base.AbstractPanel;
import com.kingdee.eas.rptclient.base.IUIFactory;
import com.kingdee.eas.rptclient.base.UIFactory;
import com.kingdee.eas.rptclient.gr.update.FtpConfigService;
import com.kingdee.eas.rptclient.gr.update.UpdateJarFileService;
import com.kingdee.eas.rptclient.gr.update.ui.AnotherUpdateSettingUI;
import com.kingdee.eas.rptclient.newrpt.util.ExceptionHandler;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public class UpdateProgressBarUI
extends AbstractPanel {
    private static final long serialVersionUID = 1L;
    private KDProgressBar progressBar;
    private KDButton btnCancel;
    private ResourceBundleHelper updateResHelper = null;
    private KDLabel lbcontent;
    private boolean ignoreCheck = true;
    Logger logger = Logger.getLogger(UpdateProgressBarUI.class);

    @Override
    public void initUIContentLayout() {
        this.updateResHelper = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.resource.autoUpdateUIResource");
        this.jbInit();
        this.initContentLayout();
    }

    private void jbInit() {
        this.progressBar = new KDProgressBar();
        this.btnCancel = new KDButton();
        this.btnCancel.setText(this.updateResHelper.getString("cancel"));
        this.btnCancel.setToolTipText(this.updateResHelper.getString("cancel"));
        this.lbcontent = new KDLabel();
        this.getOwnerWindow().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
            }
        });
    }

    protected void initContentLayout() {
        this.setUITitle(this.updateResHelper.getString("autoupdating"));
        this.setBounds(new Rectangle(0, 0, 300, 50));
        this.progressBar.setBounds(new Rectangle(10, 34, 200, 21));
        this.progressBar.setStringPainted(false);
        this.progressBar.setString("");
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setIndeterminate(true);
        this.lbcontent.setBounds(new Rectangle(10, 60, 200, 21));
        this.lbcontent.setHorizontalAlignment(4);
        this.add((Component)this.progressBar, null);
        this.add((Component)this.lbcontent, null);
    }

    protected void setTitle(String title) {
        ((KDDialog)this.getOwnerWindow()).setTitle(title);
    }

    public void run(boolean cancel) {
        Thread runner = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    UpdateProgressBarUI.this.lbcontent.setText(UpdateProgressBarUI.this.updateResHelper.getString("checkParamsIsValid"));
                    Thread.sleep(1000L);
                    if (!UpdateProgressBarUI.this.isCheckedValidParamsStep1()) {
                        return;
                    }
                    UpdateProgressBarUI.this.updateJar();
                }
                catch (Exception e) {
                    System.out.println("\u68c0\u67e5\u6587\u4ef6\u66f4\u65b0\u51fa\u9519:" + e);
                    UpdateProgressBarUI.this.logger.info((Object)("\u68c0\u67e5\u6587\u4ef6\u66f4\u65b0\u51fa\u9519:" + e));
                    MsgBox.showDetailAndOK(null, UpdateProgressBarUI.this.updateResHelper.getString("updatefail"), e.toString(), 3);
                }
                finally {
                    UpdateProgressBarUI.this.disposeUIWindow();
                }
            }
        });
        runner.start();
    }

    private boolean isCheckedValidParamsStep1() {
        if (this.ignoreCheck) {
            return true;
        }
        boolean isInvalidFTPSetting = FtpConfigService.getInstance().isInvalidFTPparams();
        if (isInvalidFTPSetting) {
            this.lbcontent.setText(this.updateResHelper.getString("checkParamsIsValid"));
            AnotherUpdateSettingUI ui = AnotherUpdateSettingUI.getInstance((Component)((Object)this), null);
            if (ui != null) {
                ui.showWindow();
                if (!ui.isOk()) {
                    return false;
                }
            } else {
                return true;
            }
        }
        return true;
    }

    private void updateJar() throws Exception {
        boolean isNeedtoUpdate = UpdateJarFileService.haveNewJarToUpdate();
        if (isNeedtoUpdate) {
            this.lbcontent.setText(this.updateResHelper.getString("bakLocalJar"));
            UpdateJarFileService.bakFile();
            String ip = FtpConfigService.getInstance().getIp();
            String content = MessageFormat.format(this.updateResHelper.getString("downFile"), ip);
            this.lbcontent.setText(content);
            boolean success = UpdateJarFileService.clientUpdateJarFromFTP();
            if (success) {
                MsgBox.showInfo(this.updateResHelper.getString("updatesuccess"));
            } else {
                MsgBox.showInfo(this.updateResHelper.getString("updatefail"));
            }
        } else {
            MsgBox.showInfo(this.updateResHelper.getString("nonewjarupdate"));
        }
    }

    public void setIgnoreCheckedValidParamsStep1(boolean ignore) {
        this.ignoreCheck = ignore;
    }

    public static UpdateProgressBarUI getInstance(Component parent, Map ctx) {
        try {
            IUIFactory fy = UIFactory.createUIFactory("com.kingdee.eas.rptclient.base.ModelDialogFactory");
            UpdateProgressBarUI ui = (UpdateProgressBarUI)fy.create(parent, UpdateProgressBarUI.class.getName(), ctx);
            return ui;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return null;
        }
    }

    public static void main(String[] args) {
    }
}

