/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.designer.batch;

import com.kingdee.eas.common.client.SysContext;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class FormulaCalcInstaller
extends DefaultHandler {
    private static FormulaCalcInstaller instaler = null;
    private static HashMap map = new HashMap();

    private void load() throws Exception {
        XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        reader.setContentHandler(this);
        reader.setErrorHandler(this);
        reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        InputStream in = this.getClass().getResource("FormulaCalculatorProvider.properties").openStream();
        reader.parse(new InputSource(in));
    }

    private FormulaCalcInstaller() throws Exception {
        this.load();
    }

    private void installFormulaCalculator(String[] formula) {
        Locale locale = SysContext.getSysContext().getLocale();
        map.put(formula[0].trim().toUpperCase(locale), formula);
    }

    public HashMap install() {
        return map;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String fullName, Attributes attributes) throws SAXException {
        Locale locale = SysContext.getSysContext().getLocale();
        if (fullName.trim().toLowerCase(locale).equals("calculator")) {
            String[] calcConfig = new String[3];
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getLocalName(i).toLowerCase(locale).trim().equals("fouction_name")) {
                    calcConfig[0] = attributes.getValue(i);
                    continue;
                }
                if (attributes.getLocalName(i).toLowerCase(locale).trim().equals("provider")) {
                    calcConfig[1] = attributes.getValue(i);
                    continue;
                }
                if (!attributes.getLocalName(i).toLowerCase(locale).trim().equals("batch_listener")) continue;
                calcConfig[2] = attributes.getValue(i);
            }
            this.installFormulaCalculator(calcConfig);
        }
    }

    public static FormulaCalcInstaller getInstance() throws Exception {
        if (instaler == null) {
            instaler = new FormulaCalcInstaller();
        }
        return instaler;
    }
}

