/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.designer.check;

import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.RptCheckExpTank;
import com.kingdee.eas.rptclient.newrpt.client.designer.IDataProvider;
import com.kingdee.eas.rptclient.newrpt.designer.BookProperties;
import com.kingdee.eas.rptclient.newrpt.designer.check.ReportCheck;
import com.kingdee.eas.rptclient.newrpt.functionimpl.CalculateContext;
import com.kingdee.eas.rptclient.newrpt.functionimpl.FunctionProviderImpl;
import com.kingdee.eas.rptclient.newrpt.functionimpl.ICalculateContext;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ReportCheckHelper {
    public static final String IS_CHECKED_PASS = "isCheckPass";
    public static final String CHECKED_RESULT = "checkResult";

    public static String checkReport(Book book, IDataProvider data) throws Exception {
        return ReportCheckHelper.checkReport(book, data, Locale.getDefault());
    }

    public static String checkReport(Book book, IDataProvider data, Locale locale) throws Exception {
        return ReportCheckHelper.checkReport(book, data, null, locale);
    }

    public static String checkReport(final Book book, IDataProvider data, RptCheckExpTank expTank, Locale locale) throws Exception {
        com.kingdee.eas.fi.rpt.check.ReportCheck ck;
        Map rs;
        BookProperties bookProperties = BookProperties.loadFromSpread(book);
        ReportCalculateErrorProvider ee = bookProperties.getErrorProvider();
        CalculateContext.getInstance().setErrorProvider((IErrorProvider)ee);
        FunctionProviderImpl functionProviderImpl = new FunctionProviderImpl();
        book.getDeps().getFunctionManager().addFunctionProvider((Object)functionProviderImpl, true);
        functionProviderImpl.setContext(new ICalculateContext(){

            @Override
            public Book getBook() {
                return book;
            }
        });
        book.getDeps().getFunctionManager().setErrorProvider(Exception.class, (IErrorProvider)ee);
        book.setUserObject("CTX", (Object)data);
        bookProperties.restoreToSpread(book);
        if (expTank == null) {
            expTank = bookProperties.getOperationSchema().getExpTank();
        }
        if ((rs = (ck = new com.kingdee.eas.fi.rpt.check.ReportCheck(book, expTank, locale)).doCheck()) == null || rs.size() < 1) {
            return null;
        }
        String string = ck.exportPlainCheckResult(rs);
        return string;
    }

    public static Map checkReportResult(final Book book, IDataProvider data, RptCheckExpTank expTank, Locale locale) throws Exception {
        BookProperties bookProperties = BookProperties.loadFromSpread(book);
        ReportCalculateErrorProvider ee = bookProperties.getErrorProvider();
        CalculateContext.getInstance().setErrorProvider((IErrorProvider)ee);
        FunctionProviderImpl functionProviderImpl = new FunctionProviderImpl();
        book.getDeps().getFunctionManager().addFunctionProvider((Object)functionProviderImpl, true);
        functionProviderImpl.setContext(new ICalculateContext(){

            @Override
            public Book getBook() {
                return book;
            }
        });
        book.getDeps().getFunctionManager().setErrorProvider(Exception.class, (IErrorProvider)ee);
        book.setUserObject("CTX", (Object)data);
        bookProperties.restoreToSpread(book);
        expTank = expTank == null ? bookProperties.getOperationSchema().getExpTank() : expTank;
        locale = locale == null ? Locale.getDefault() : locale;
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        ReportCheck ck = new ReportCheck(book, expTank, locale);
        Map checkMap = ck.doCheck();
        if (checkMap == null) {
            returnMap.put(IS_CHECKED_PASS, new Boolean(true));
            return returnMap;
        }
        String resultString = ck.exportPlainCheckResult(checkMap);
        boolean isCheckedPass = ck.getCheckPass();
        returnMap.put(IS_CHECKED_PASS, new Boolean(isCheckedPass));
        returnMap.put(CHECKED_RESULT, resultString);
        return returnMap;
    }

    public static Map checkReportResult(Book book, IDataProvider data, Locale locale) throws Exception {
        return ReportCheckHelper.checkReportResult(book, data, null, locale);
    }

    public static Map checkReportResult(Book book, IDataProvider data) throws Exception {
        return ReportCheckHelper.checkReportResult(book, data, null, null);
    }
}

