/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.designer.check;

import com.kingdee.eas.fi.rpt.RptCheckExpression;
import com.kingdee.eas.rptclient.base.UIFactory;
import com.kingdee.eas.rptclient.newrpt.designer.check.AbstractRptCheckExpressionEditUI;
import com.kingdee.eas.rptclient.newrpt.designer.check.ICheckExpressionEdit;
import com.kingdee.eas.rptclient.newrpt.designer.check.RptCheckExpDescEditUI;
import com.kingdee.eas.rptclient.newrpt.designer.check.RptCheckExpLineEditUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;

public class RptCheckExpressionEditUI
extends AbstractRptCheckExpressionEditUI {
    private ICheckExpressionEdit listener;
    private RptCheckExpression expression = null;
    private boolean isAddNew = false;

    public static RptCheckExpressionEditUI getUIInstance(Map context) throws Exception {
        RptCheckExpressionEditUI panel = (RptCheckExpressionEditUI)UIFactory.createUIFactory("com.kingdee.eas.rptclient.base.ModelDialogFactory").create(null, RptCheckExpressionEditUI.class.getName(), context);
        return panel;
    }

    public RptCheckExpressionEditUI() throws Exception {
        this.onLoad();
    }

    public void onLoad() throws Exception {
        this.initializeUI();
    }

    private void initializeUI() throws Exception {
        RptCheckExpLineEditUI rptCheckExpLineEditUI = new RptCheckExpLineEditUI();
        this.pnlCore.add((Component)((Object)rptCheckExpLineEditUI));
        this.pnlCore.add((Component)((Object)new RptCheckExpDescEditUI()));
    }

    @Override
    public void actionBtnOk_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnOk_actionPerformed(e);
        this.endWizard(true);
    }

    @Override
    public void actionBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnCancel_actionPerformed(e);
        this.endWizard(false);
    }

    public void open() {
        this.expression = this.listener.loadCheckExpression();
        this.loadExpression(this.expression);
        if (this.expression != null) {
            this.btnOk.setEnabled(this.expression.isEditable());
        }
        this.showWindow();
    }

    public boolean isAddNew() {
        return this.isAddNew;
    }

    public void setAddnew(boolean b) {
        this.isAddNew = b;
    }

    void endWizard(boolean isOk) {
        if (isOk) {
            String txt = this.txtName.getText();
            if (txt != null && (txt = txt.trim()).length() == 0) {
                txt = null;
            }
            if (!(!this.isAddNew && this.expression.getName().equalsIgnoreCase(txt) || this.listener.checkIsExpNameDuplicate(txt))) {
                return;
            }
            this.expression.setName(txt);
            this.expression.setContent(((RptCheckExpLineEditUI)((Object)this.pnlCore.getComponentAt(0))).getExpression());
            this.expression.setDescription(((RptCheckExpDescEditUI)((Object)this.pnlCore.getComponentAt(1))).getDescription());
            this.listener.restoreCheckExpression(this.expression);
        }
        this.disposeUIWindow();
    }

    private boolean loadExpression(RptCheckExpression exp) {
        this.expression = exp != null ? (RptCheckExpression)exp.clone() : new RptCheckExpression();
        this.txtName.setText(this.expression.getName());
        ((RptCheckExpLineEditUI)((Object)this.pnlCore.getComponentAt(0))).setExpression(this.expression.getContent());
        ((RptCheckExpDescEditUI)((Object)this.pnlCore.getComponentAt(1))).setDescription(this.expression.getDescription());
        return true;
    }

    public ICheckExpressionEdit getCheckExpressionEdit() {
        return this.listener;
    }

    public void setCheckExpressionEdit(ICheckExpressionEdit listener) {
        this.listener = listener;
    }
}

