/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.designer.formulawizard;

import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.IRptDataPublisher;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptOperObject;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FormulaValidator
extends RptOperObject {
    private Boolean strict = null;
    private String provider = null;
    private String method = null;
    private List params = null;
    private Map message = this.description;
    private String commentLanguage;
    private final int STAT_COMMENT = 1;
    private final int STAT_INIT = -1;

    public FormulaValidator(String name) {
        super(name);
    }

    public FormulaValidator(String name, IRptDataPublisher pb) {
        super(name, pb);
    }

    @Override
    public void goContent(String value) {
        if (this.status == 1) {
            this.setDescription(this.commentLanguage, value);
            this.status = -1;
        }
    }

    @Override
    public void goInto(String target, Attributes atts) throws SAXException {
        if (target.equalsIgnoreCase("validator")) {
            String av = atts.getValue("name");
            if (StringUtils.isEmpty((String)av)) {
                throw new SAXException("Invalid validator name");
            }
            this.name = av;
            av = atts.getValue("strict");
            if (StringUtils.isEmpty((String)av)) {
                this.strict = null;
            } else if ("true".equalsIgnoreCase(av)) {
                this.strict = Boolean.TRUE;
            } else if ("false".equalsIgnoreCase(av)) {
                this.strict = Boolean.FALSE;
            }
            av = atts.getValue("provider");
            if (StringUtils.isEmpty((String)av)) {
                throw new SAXException("Invalid validator provider");
            }
            this.provider = av;
            av = atts.getValue("method");
            if (StringUtils.isEmpty((String)av)) {
                throw new SAXException("Invalid validation method");
            }
            this.method = av;
        } else if (target.equalsIgnoreCase("methodParam")) {
            String av = atts.getValue("param");
            if (StringUtils.isEmpty((String)av)) {
                throw new SAXException("Invalid validation method parameter");
            }
            this.getParams().add(av);
        } else if (target.equalsIgnoreCase("comment")) {
            String av;
            this.commentLanguage = av = atts.getValue("language");
            this.status = 1;
        }
    }

    @Override
    public void goOut(String target) {
        if (target.equalsIgnoreCase("validator")) {
            this.publisher.publish(this);
        }
        this.publisher.keep(this);
    }

    public Map getMessage() {
        return this.message;
    }

    public void setMessage(Map message) {
        this.message = message;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getProvider() {
        return this.provider;
    }

    public List getParams() {
        if (this.params == null) {
            this.params = new ArrayList(2);
        }
        return this.params;
    }

    public Boolean isStrict() {
        return this.strict;
    }

    public void setParams(List params) {
        this.params = params;
    }
}

