/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.designer.formulawizard;

import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.FormulaValidator;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.FormulaWizardCompoundResult;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.IFormulaValidate;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.IFormulaValidateExtension;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptContextManager;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormulaComp;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormulaParameter;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.ValidatorResults;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidatorAction {
    private ClassLoader classLoader;
    private Class validationClass;
    private FormulaValidator validator;
    private Method validationMethod = null;
    private FormulaWizardCompoundResult paramValues;
    private Class[] parameterClasses;
    private List vars;
    private Object instance;

    public ValidatorAction(FormulaValidator validator, List vars, FormulaWizardCompoundResult paramValues) {
        this.validator = validator;
        this.vars = vars;
        this.paramValues = paramValues;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean validate(ValidatorResults results, RptContextManager context) throws Exception {
        this.loadValidationClass(this.classLoader);
        this.loadParameterClasses(this.classLoader);
        this.loadValidationMethod();
        this.getValidationClassInstance();
        if (this.instance != null) {
            if (this.instance instanceof IFormulaValidate) {
                ((IFormulaValidate)this.instance).initValidator(this.paramValues.getFormulaName(), this.paramValues.getParamValues(), results);
            }
            if (this.instance instanceof IFormulaValidateExtension) {
                ((IFormulaValidateExtension)this.instance).setFormulaContext(context);
            }
        }
        Object[] paramValues = this.getParameterValues();
        Object result = null;
        result = this.validationMethod.invoke(this.instance, paramValues);
        boolean valid = this.isValid(result);
        if (!valid) {
            String msg = this.validator.getDescription();
            results.addValidateResult(this.componMessage(msg));
        }
        return valid;
    }

    private String componMessage(String msg) {
        if (StringUtils.isEmpty((String)msg)) {
            return msg;
        }
        StringBuffer sb = new StringBuffer(msg.length());
        Pattern p = Pattern.compile("\\{\\d+\\}");
        Matcher m = p.matcher(msg);
        int start = 0;
        int end = 0;
        while (m.find()) {
            start = m.start();
            sb.append(msg.substring(end, start));
            String index = m.group();
            index = index.substring(1, index.length() - 1);
            int ix = Integer.parseInt(index);
            String var = (String)this.vars.get(ix);
            sb.append(this.componMessages(var));
            start = m.start();
            end = m.end();
        }
        sb.append(msg.substring(end));
        return sb.toString();
    }

    private boolean isValid(Object result) {
        if (result instanceof Boolean) {
            Boolean valid = (Boolean)result;
            return valid;
        }
        return result != null;
    }

    private void loadValidationClass(ClassLoader loader) throws Exception {
        if (this.validationClass != null) {
            return;
        }
        this.validationClass = loader.loadClass(this.validator.getProvider());
    }

    private void loadParameterClasses(ClassLoader loader) throws Exception {
        if (this.parameterClasses != null) {
            return;
        }
        List params = this.validator.getParams();
        this.parameterClasses = new Class[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            String paramClassName = (String)params.get(i);
            this.parameterClasses[i] = loader.loadClass(paramClassName);
        }
    }

    private void loadValidationMethod() throws Exception {
        if (this.validationMethod != null) {
            return;
        }
        this.validationMethod = this.validationClass.getMethod(this.validator.getMethod(), this.parameterClasses);
    }

    private Object[] getParameterValues() {
        Object[] paramValue = new Object[this.parameterClasses.length];
        for (int i = 0; i < this.parameterClasses.length; ++i) {
            String var = (String)this.vars.get(i);
            paramValue[i] = this.componValues(var, this.paramValues);
        }
        return paramValue;
    }

    private String componValues(String var, FormulaWizardCompoundResult values) {
        StringBuffer value = new StringBuffer(15);
        StringBuffer name = new StringBuffer(15);
        boolean inParam = false;
        for (int i = 0; i < var.length(); ++i) {
            char c = var.charAt(i);
            if (c == '$') {
                if (inParam) {
                    inParam = false;
                    value.append(values.get(name.toString()));
                    name = new StringBuffer(15);
                    continue;
                }
                inParam = true;
                continue;
            }
            if (inParam) {
                name.append(c);
                continue;
            }
            value.append(c);
        }
        return value.toString();
    }

    private String componMessages(String var) {
        StringBuffer value = new StringBuffer(15);
        StringBuffer name = new StringBuffer(15);
        boolean inParam = false;
        for (int i = 0; i < var.length(); ++i) {
            char c = var.charAt(i);
            if (c == '$') {
                if (inParam) {
                    inParam = false;
                    value.append(this.getParamName(name.toString()));
                    name = new StringBuffer(15);
                    continue;
                }
                inParam = true;
                continue;
            }
            if (inParam) {
                name.append(c);
                continue;
            }
            value.append(c);
        }
        return value.toString();
    }

    private String getParamName(String name) {
        Collection coll;
        RptFormulaComp comp = RptFormulaComp.getInstance();
        try {
            coll = comp.getFormula(this.paramValues.getFormulaName()).getParameters();
        }
        catch (Exception e) {
            return null;
        }
        for (RptFormulaParameter p : coll) {
            if (!p.getName().equalsIgnoreCase(name)) continue;
            return p.getLocalName();
        }
        return name;
    }

    private Object getValidationClassInstance() throws Exception {
        if (Modifier.isStatic(this.validationMethod.getModifiers())) {
            this.instance = null;
        } else if (this.instance == null) {
            try {
                this.instance = this.validationClass.newInstance();
            }
            catch (InstantiationException e) {
                String msg = "Couldn't create instance of " + this.validationClass.getName() + ".  " + e.getMessage();
                throw new Exception(msg);
            }
            catch (IllegalAccessException e) {
                String msg = "Couldn't create instance of " + this.validationClass.getName() + ".  " + e.getMessage();
                throw new Exception(msg);
            }
        }
        return this.instance;
    }
}

