/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.functionimpl;

import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.rptclient.gr.k3webservice.K3WebServiceContext;
import com.kingdee.eas.rptclient.gr.k3webservice.impl.K3AccFunctionsSoapStub;
import com.kingdee.eas.rptclient.gr.rptclient.frame.CslReportDataProvider;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.newrpt.client.designer.IDataProvider;
import com.kingdee.eas.rptclient.newrpt.designer.BookProperties;
import com.kingdee.eas.rptclient.newrpt.functionimpl.CalculateContext;
import com.kingdee.eas.rptclient.newrpt.functionimpl.IFormulaBatchExecute;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import javax.xml.rpc.Service;
import org.apache.axis.AxisFault;
import org.apache.log4j.Logger;

public class AcctItemBatchExecute
extends IFormulaBatchExecute {
    private static final Logger logger = Logger.getLogger(AcctItemBatchExecute.class);

    @Override
    protected void execOne(Parameter param) throws Exception {
        IDataProvider dataProvider;
        Book book = this.getBook();
        Sheet sheet = book.getSheet(param.getSheetName());
        ReportVariables variables = BookProperties.loadVariables(book);
        Object[] args = param.getArgs();
        if (args[0] instanceof Object[]) {
            args = (Object[])args[0];
        }
        String sdsnName = "";
        try {
            sdsnName = (String)((Variant)args[10]).getValue();
        }
        catch (Exception e) {
            sdsnName = "";
        }
        int year = ((Number)((Variant)args[7]).getValue()).intValue();
        int startp = ((Number)((Variant)args[8]).getValue()).intValue();
        int endp = ((Number)((Variant)args[9]).getValue()).intValue();
        String currency = (String)((Variant)args[4]).getValue();
        if (year <= 0) {
            year += variables.getIntValue("StartYear", sheet.getSheetName(), 0);
        }
        if (startp <= 0) {
            startp += variables.getIntValue("StartPeriod", sheet.getSheetName(), 0);
        }
        if (endp <= 0) {
            endp += variables.getIntValue("EndPeriod", sheet.getSheetName(), 0);
        }
        if (StringUtils.isEmpty((String)currency)) {
            currency = variables.getStringValue("Currency", sheet.getSheetName());
        }
        if ((dataProvider = (IDataProvider)book.getUserObjectValue("CTX")) instanceof CslReportDataProvider) {
            CslReportDataProvider pp = (CslReportDataProvider)dataProvider;
            if (year <= 0) {
                year += pp.getReportVO().getYear();
            }
            if (startp <= 0) {
                startp += pp.getReportVO().getPeriod();
            }
            if (endp <= 0) {
                endp += pp.getReportVO().getPeriod();
            }
            if (StringUtils.isEmpty((String)currency)) {
                currency = pp.getReportVO().getCurrencyNumber();
            }
        }
        boolean include = variables.getBoolValue("IncludePosted", sheet.getSheetName(), false);
        Object result = this.acctItem((String)((Variant)args[0]).getValue(), (String)((Variant)args[1]).getValue(), (String)((Variant)args[2]).getValue(), (String)((Variant)args[3]).getValue(), currency, (String)((Variant)args[5]).getValue(), (String)((Variant)args[6]).getValue(), year, startp, endp, include, sdsnName);
        Variant var = null;
        try {
            if (result instanceof Number) {
                BigDecimal value = new BigDecimal(result.toString());
                var = new Variant((Object)value);
            } else {
                var = new Variant(result);
            }
            param.setValue((Object)var);
        }
        catch (Exception e) {
            logger.error((Object)e);
            param.setValue(result);
        }
    }

    public Object acctItem(String orgBound, String orgUnit, String rptItem, String period, String currency, String dataSource, String dataElement, int year, int startPeriod, int endPeriod, boolean includePost, String sdName) throws Exception {
        try {
            String oldc = currency;
            currency = CalculateContext.getInstance().getK3CurrencyNumber(currency);
            if (StringUtils.isEmpty((String)currency)) {
                if ("GLC".equals(oldc)) {
                    currency = "";
                } else {
                    throw new Exception("#BAD CURRENCY: " + oldc);
                }
            }
            K3AccFunctionsSoapStub proxy = new K3AccFunctionsSoapStub(K3WebServiceContext.getInstance().getK3FunctionEndPoint(), (Service)new org.apache.axis.client.Service());
            StringBuffer sb = new StringBuffer();
            sb.append(orgBound).append(",");
            sb.append(orgUnit).append(",");
            sb.append(rptItem).append(",");
            sb.append(period).append(",");
            sb.append(currency == null ? "" : currency).append(",");
            if (dataSource.equals(CslRptClientResourceHelper.getString("160_AcctItemBatchExecute"))) {
                sb.append("4");
            } else if (dataSource.equals(CslRptClientResourceHelper.getString("161_AcctItemBatchExecute"))) {
                sb.append("3");
            } else if (dataSource.equals(CslRptClientResourceHelper.getString("162_AcctItemBatchExecute"))) {
                sb.append("2");
            } else if (dataSource.equals(CslRptClientResourceHelper.getString("163_AcctItemBatchExecute"))) {
                sb.append("1");
            } else {
                sb.append(dataSource);
            }
            sb.append(",");
            sb.append(dataElement).append(",");
            sb.append(year).append(",");
            sb.append(startPeriod).append(",");
            sb.append(endPeriod).append(",");
            sb.append(includePost ? "Y" : "N");
            String sdsn = K3WebServiceContext.getInstance().getSDSNByName(sdName);
            if (StringUtils.isEmpty((String)sdsn)) {
                throw new SyntaxErrorException(0x400000L, (Object)CslRptClientResourceHelper.getString("3_K3WebServiceContext"));
            }
            String acctItem = proxy.acctItem(sdsn, sb.toString());
            if ("#".equals(acctItem)) {
                return "0";
            }
            return acctItem;
        }
        catch (AxisFault e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }
}

