/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.MsgBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.ServerException;
import com.kingdee.eas.fi.newrpt.CslGradeManageSettingCollection;
import com.kingdee.eas.fi.newrpt.CslGradeManageSettingFactory;
import com.kingdee.eas.fi.newrpt.CslGradeManageSettingInfo;
import com.kingdee.eas.fi.newrpt.CslMaterialCollection;
import com.kingdee.eas.fi.newrpt.CslMaterialFactory;
import com.kingdee.eas.fi.newrpt.CslMaterialInfo;
import com.kingdee.eas.fi.newrpt.MultOrgUnitHelper;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.client.util.CslGradeManageUtilClient;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class CslGradeManageUtil {
    private static Map cacheclsMaterialMap = null;
    public static final String TABLENAME = "tableName";
    public static final String SELECTEDIDLIST = "selectedIDList";
    public static final String ORGID = "orgID";
    public static final String ORGCOLNAME = "orgColName";
    private static final String ROOTORGUNIT = "00000000-0000-0000-0000-000000000000CCE7AED4";
    private static final Logger logger = Logger.getLogger(CslGradeManageUtil.class);

    public static void filteData(FilterInfo filterInfo, String className) throws BOSException, ParserException {
        CslGradeManageUtil.filteData(filterInfo, "trackRecordCreator.id", className, null);
    }

    public static void filteData(FilterInfo filterInfo, String CreateOrgKey, String className, String orgUnitId) throws BOSException, ParserException {
        orgUnitId = CslGradeManageUtil.getOrgUnitId(orgUnitId);
        String longNumber = CslGradeManageUtil.getCurrentOrgUpLongNumbers(null, orgUnitId);
        CslMaterialInfo info = CslGradeManageUtil.getMaterialConfigInfo(className, orgUnitId);
        CslGradeManageUtil.getCslGradeManageFilter(filterInfo, CreateOrgKey, longNumber, info);
    }

    public static void filterData(FilterInfo filterInfo, String CreateOrgKey, String orgUnitId, CslMaterialInfo info) throws BOSException, ParserException {
        orgUnitId = CslGradeManageUtil.getOrgUnitId(orgUnitId);
        String longNumber = CslGradeManageUtil.getCurrentOrgUpLongNumbers(null, orgUnitId);
        CslGradeManageUtil.getCslGradeManageFilter(filterInfo, CreateOrgKey, longNumber, info);
    }

    public static String getOrgUnitId(String orgUnitId) throws BOSException {
        return CslGradeManageUtil.getOrgUnitId(orgUnitId, null);
    }

    public static void getCslGradeManageFilter(FilterInfo filterInfo, String CreateOrgKey, String orgLongNumber, CslMaterialInfo info) throws BOSException, ParserException {
        if (info.isIsAllVisible()) {
            return;
        }
        if (info.isIsUpVisible() && info.isIsSubVisible()) {
            CslGradeManageUtil.filterUpAndSubData(filterInfo, CreateOrgKey, orgLongNumber);
        } else if (info.isIsUpVisible()) {
            CslGradeManageUtil.getUpSql(filterInfo, CreateOrgKey, orgLongNumber);
        } else if (info.isIsSubVisible()) {
            CslGradeManageUtil.getSubData(filterInfo, CreateOrgKey, orgLongNumber);
        } else {
            CslGradeManageUtil.getSelfData(filterInfo, CreateOrgKey, orgLongNumber);
        }
    }

    public static void getUpSqlPub(FilterInfo filterInfo, String CreateOrgKey) throws BOSException, ParserException {
        String currentOrgID = CslGradeManageUtil.getOrgUnitId(null);
        String longNumber = CslGradeManageUtil.getCurrentOrgUpLongNumbers(null, currentOrgID);
        CslGradeManageUtil.getUpSql(filterInfo, CreateOrgKey, longNumber);
    }

    private static void getSelfData(FilterInfo filterInfo, String CreateOrgKey, String longNumber) throws ParserException, BOSException {
        String selfSql = CslGradeManageUtil.getSelfSql(longNumber);
        FilterInfo selfFilter = new FilterInfo(CreateOrgKey + " in (" + selfSql + ")");
        filterInfo.mergeFilter(selfFilter, "and");
    }

    public static void getSelfDataPub(FilterInfo filterInfo, String CreateOrgKey, String className, String orgUnitId) throws BOSException, ParserException {
        String currentOrgID = CslGradeManageUtil.getOrgUnitId(orgUnitId);
        String longNumber = CslGradeManageUtil.getCurrentOrgUpLongNumbers(null, currentOrgID);
        CslGradeManageUtil.getSelfData(filterInfo, CreateOrgKey, longNumber);
    }

    private static void getSubData(FilterInfo filterInfo, String CreateOrgKey, String longNumber) throws ParserException, BOSException {
        String subSql = CslGradeManageUtil.getSubSql(longNumber);
        FilterInfo subFilter = new FilterInfo(CreateOrgKey + " in (" + subSql + ")");
        filterInfo.mergeFilter(subFilter, "and");
    }

    private static void getUpSql(FilterInfo filterInfo, String CreateOrgKey, String longNumber) throws ParserException, BOSException {
        String upSql = CslGradeManageUtil.getUpSql(longNumber);
        FilterInfo upFilter = new FilterInfo(CreateOrgKey + " in (" + upSql + ")");
        filterInfo.mergeFilter(upFilter, "and");
    }

    private static void filterUpAndSubData(FilterInfo filterInfo, String CreateOrgKey, String longNumber) throws ParserException, BOSException {
        String upSql = CslGradeManageUtil.getUpSql(longNumber);
        String subSql = CslGradeManageUtil.getSubSql(longNumber);
        FilterInfo upAndSubFilter = new FilterInfo(CreateOrgKey + " in (" + upSql + " union " + subSql + ")");
        filterInfo.mergeFilter(upAndSubFilter, "and");
    }

    private static String getSubSql(String longNumber) {
        String subSql = "select tos.FUnitId from T_ORG_Structure tos inner join T_ORG_Tree tot on tos.FTreeId = tot.fid where (tos.FLongNumber LIKE '" + longNumber + "!%' or tos.FLongNumber = '" + longNumber + "') and tot.FTYPE = " + 1;
        return subSql;
    }

    private static String getUpSql(String longNumber) {
        String longNumberCondition = CslGradeManageUtil.getUpAndSelfLongNumbersSqlCondition(longNumber);
        String subSql = "select tos.FUnitId from T_ORG_Structure tos inner join T_ORG_Tree tot on tos.FTreeId = tot.fid where tos.FLongNumber in (" + longNumberCondition + ") and tot.FTYPE = " + 1;
        return subSql;
    }

    private static String getSelfSql(String longNumber) {
        String subSql = "select tos.FUnitId from T_ORG_Structure tos inner join T_ORG_Tree tot on tos.FTreeId = tot.fid where tos.FLongNumber = '" + longNumber + "' and tot.FTYPE = " + 1;
        return subSql;
    }

    private static String getUpAndSelfLongNumbersSqlCondition(String longNumber) {
        String orgLongNumbers = "";
        String[] arr = longNumber.split("!");
        for (int i = arr.length - 1; i >= 0; --i) {
            String tempLongNumber = "";
            for (int j = 0; j <= i; ++j) {
                if (j > 0) {
                    tempLongNumber = tempLongNumber + "!";
                }
                tempLongNumber = tempLongNumber + arr[j];
            }
            orgLongNumbers = i == arr.length - 1 ? orgLongNumbers + "'" + tempLongNumber + "'" : orgLongNumbers + ",'" + tempLongNumber + "'";
        }
        return orgLongNumbers;
    }

    private static CslMaterialInfo getMaterialConfigInfo(String className, String currentOrgID) throws BOSException {
        CslMaterialInfo info = CslGradeManageUtil.getMaterialDefualtInfo(className);
        EntityViewInfo view = CslGradeManageUtil.getGradeConfigViewInfo(info.getMaclass(), info.getId().toString(), currentOrgID);
        CslGradeManageSettingCollection colls = CslGradeManageSettingFactory.getRemoteInstance().getCslGradeManageSettingCollection(view);
        if (colls.size() != 0) {
            CslGradeManageSettingInfo cslGradeManageSettingInfo = new CslGradeManageSettingInfo();
            cslGradeManageSettingInfo = colls.get(0);
            info.setIsUpVisible(cslGradeManageSettingInfo.isIsUpVisible());
            info.setIsSubVisible(cslGradeManageSettingInfo.isIsSubVisible());
            info.setIsAllVisible(cslGradeManageSettingInfo.isIsAllVisible());
        }
        return info;
    }

    private static String getCurrentOrgUpLongNumbers(Context ctx, String currentOrgID) {
        OrgStructureInfo orgStructureInfo = new OrgStructureInfo();
        EntityViewInfo longNumberView = CslGradeManageUtil.getCurrentOrgLongNumberView(currentOrgID);
        try {
            orgStructureInfo = (ctx == null ? OrgStructureFactory.getRemoteInstance() : OrgStructureFactory.getLocalInstance((Context)ctx)).getOrgStructureCollection(longNumberView).get(0);
        }
        catch (BOSException e) {
            logger.error((Object)"get longNumber error", (Throwable)e);
        }
        String longNumber = orgStructureInfo.getLongNumber();
        return longNumber;
    }

    private static EntityViewInfo getCurrentOrgLongNumberView(String currentOrgID) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)currentOrgID, CompareType.EQUALS));
        HashSet<String> viewTypes = new HashSet<String>();
        viewTypes.add(String.valueOf(1));
        filter.getFilterItems().add(new FilterItemInfo("tree.type", viewTypes, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("longNumber"));
        view.setSelector(coll);
        return view;
    }

    private static EntityViewInfo getGradeConfigViewInfo(String className, String maID, String currentOrgID) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cslMaterial.id", (Object)maID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("createOrg.id", (Object)currentOrgID, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("isUpVisible"));
        coll.add(new SelectorItemInfo("isSubVisible"));
        coll.add(new SelectorItemInfo("isAllVisible"));
        view.setSelector(coll);
        return view;
    }

    public static synchronized CslMaterialInfo getMaterialDefualtInfo(String className) {
        if (cacheclsMaterialMap == null) {
            CslGradeManageUtil.initMaGradeConfig();
        }
        HashMap copyCacheclsMaterialMap = new HashMap();
        CslMaterialInfo copyCslMaterialInfo = new CslMaterialInfo();
        if (cacheclsMaterialMap.containsKey(className)) {
            CslMaterialInfo materialInfo = (CslMaterialInfo)cacheclsMaterialMap.get(className);
            copyCslMaterialInfo = (CslMaterialInfo)materialInfo.clone();
        } else {
            MsgBox.error(null, (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"78_CslGradeManageConfig"), null);
            SysUtil.abort();
        }
        return copyCslMaterialInfo;
    }

    private static void initMaGradeConfig() {
        CslMaterialCollection colls = new CslMaterialCollection();
        cacheclsMaterialMap = new HashMap();
        try {
            colls = CslMaterialFactory.getRemoteInstance().getCslMaterialCollection();
        }
        catch (BOSException e) {
            logger.error((Object)"get cslMaterialDefaultConfig error", (Throwable)e);
        }
        for (int i = 0; i < colls.size(); ++i) {
            CslMaterialInfo info = colls.get(i);
            cacheclsMaterialMap.put(info.getMaclass(), info);
        }
    }

    public static void setRptItemF7GMFilter(KDBizPromptBox rptItemF7, String orgUnitId) throws Exception {
        EntityViewInfo curView = rptItemF7.getEntityViewInfo();
        if (curView == null) {
            curView = new EntityViewInfo();
        }
        if (curView.getFilter() == null) {
            curView.setFilter(new FilterInfo());
        }
        CslGradeManageUtil.filteData(curView.getFilter(), "trackRecordCreator.id", "com.kingdee.eas.fi.gr.cslrpt.client.RptItemListUI", orgUnitId);
        rptItemF7.setEntityViewInfo(curView);
    }

    public static void setF7CurrentGradeFilter(KDBizPromptBox rptItemF7, String orgUnitId) throws Exception {
        EntityViewInfo curView = rptItemF7.getEntityViewInfo();
        if (curView == null) {
            curView = new EntityViewInfo();
        }
        if (curView.getFilter() == null) {
            curView.setFilter(new FilterInfo());
        }
        CslMaterialInfo info = new CslMaterialInfo();
        info.setIsAllVisible(false);
        info.setIsSubVisible(false);
        info.setIsUpVisible(false);
        CslGradeManageUtil.filterData(curView.getFilter(), "trackRecordCreator.id", orgUnitId, info);
        rptItemF7.setEntityViewInfo(curView);
    }

    public static EntityViewInfo filterRptItemGradeManage(EntityViewInfo viewInfo, String orgUnitId) throws Exception {
        return CslGradeManageUtil.filteData(null, viewInfo, "trackRecordCreator.id", "com.kingdee.eas.fi.gr.cslrpt.client.RptItemListUI", orgUnitId);
    }

    public static EntityViewInfo filterRptItemTypeGradeManage(EntityViewInfo viewInfo, String orgUnitId) throws Exception {
        return CslGradeManageUtil.filteData(null, viewInfo, "trackRecordCreator.id", "com.kingdee.eas.fi.gr.cslrpt.client.RptItemRptTypeListUI", orgUnitId);
    }

    public static EntityViewInfo filterDataElementGradeManage(EntityViewInfo viewInfo, String orgUnitId) throws Exception {
        return CslGradeManageUtil.filteData(null, viewInfo, "trackRecordCreator.id", "com.kingdee.eas.fi.gr.cslrpt.client.DataElementListUI", orgUnitId);
    }

    public static EntityViewInfo filterElimModeGradeManage(EntityViewInfo viewInfo, String orgUnitId) throws Exception {
        return CslGradeManageUtil.filteData(null, viewInfo, "trackRecordCreator.id", "com.kingdee.eas.fi.gr.cslrpt.client.EliminationModeListUI", orgUnitId);
    }

    public static EntityViewInfo filterElimTempletGroupGradeManage(EntityViewInfo viewInfo, String orgUnitId) throws Exception {
        return CslGradeManageUtil.filteData(null, viewInfo, "trackRecordCreator.id", "com.kingdee.eas.fi.gr.cslrpt.client.ElimTempletGroupListUI", orgUnitId);
    }

    public static EntityViewInfo filterAdjustModeGradeManage(Context ctx, EntityViewInfo viewInfo, String orgUnitId) throws Exception {
        return CslGradeManageUtil.filteData(ctx, viewInfo, "trackRecordCreator.id", "com.kingdee.eas.fi.gr.cslrpt.client.AdjustModeListUI", orgUnitId);
    }

    public static FilterInfo setOrgTreeFilter(FilterInfo filterInfo, String filterColStr) {
        if (StringUtils.isEmpty((String)filterColStr)) {
            filterColStr = "CU.ID";
        }
        String orgUnitId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        filterInfo.appendFilterItem(filterColStr, (Object)orgUnitId);
        return filterInfo;
    }

    public static CslMaterialInfo getGradeManageConfig(Context ctx, String className, String orgUnitId) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("select defaultCof.Fisupvisible,defaultCof.Fissubvisible,defaultCof.Fisallvisible from T_Csl_Material defaultCof");
        sql.append(" left join T_Csl_GradeManageSetting actCof on actCof.Fcslmaterialid=defaultCof.fid and actCof.FCreateOrgID=? ");
        sql.append(" where actCof.fid is null and defaultCof.Fmaclass=? ");
        sql.append(" union all ");
        sql.append(" select actCof.Fisupvisible,actCof.Fissubvisible,actCof.Fisallvisible from T_Csl_GradeManageSetting actCof ");
        sql.append(" inner join T_Csl_Material defaultCof on actCof.Fcslmaterialid=defaultCof.fid ");
        sql.append(" where defaultCof.Fmaclass=? and actCof.FCreateOrgID=? ");
        IRowSet rs = DbUtil.executeQuery(ctx, sql.toString(), new Object[]{orgUnitId, className, className, orgUnitId});
        if (rs.next()) {
            CslMaterialInfo info = new CslMaterialInfo();
            info.setIsSubVisible(rs.getBoolean(2));
            info.setIsUpVisible(rs.getBoolean(1));
            info.setIsAllVisible(rs.getBoolean(3));
            return info;
        }
        return null;
    }

    public static void filterGradeManage(Context ctx, FilterInfo filterInfo, String filterProperty, String classNmae, String orgUnitId) throws Exception {
        if ((orgUnitId = CslGradeManageUtil.getOrgUnitId(orgUnitId, ctx)) == null) {
            logger.error((Object)"DelegateCompany is null");
            return;
        }
        CslMaterialInfo info = CslGradeManageUtil.getGradeManageConfig(ctx, classNmae, orgUnitId);
        if (info == null) {
            logger.error((Object)"GradeManageConfig is null");
            return;
        }
        String longNumber = CslGradeManageUtil.getCurrentOrgUpLongNumbers(ctx, orgUnitId);
        if (info.isIsAllVisible()) {
            return;
        }
        if (info.isIsUpVisible() && info.isIsSubVisible()) {
            CslGradeManageUtil.filterUpAndSubData(filterInfo, filterProperty, longNumber);
        } else if (info.isIsUpVisible()) {
            CslGradeManageUtil.getUpSql(filterInfo, filterProperty, longNumber);
        } else if (info.isIsSubVisible()) {
            CslGradeManageUtil.getSubData(filterInfo, filterProperty, longNumber);
        } else {
            CslGradeManageUtil.getSelfData(filterInfo, filterProperty, longNumber);
        }
    }

    public static String getGradeManageFilterSql(Context ctx, String filterColStr, String classNmae, String orgUnitId) throws Exception {
        StringBuffer sql = new StringBuffer();
        if ((orgUnitId = CslGradeManageUtil.getOrgUnitId(orgUnitId, ctx)) == null) {
            logger.error((Object)"DelegateCompany is null");
            return null;
        }
        CslMaterialInfo info = CslGradeManageUtil.getGradeManageConfig(ctx, classNmae, orgUnitId);
        if (info == null) {
            return null;
        }
        String longNumber = CslGradeManageUtil.getCurrentOrgUpLongNumbers(ctx, orgUnitId);
        if (info.isIsAllVisible()) {
            return null;
        }
        if (info.isIsUpVisible() && info.isIsSubVisible()) {
            String upSql = CslGradeManageUtil.getUpSql(longNumber);
            String subSql = CslGradeManageUtil.getSubSql(longNumber);
            sql.append(" ( ").append(filterColStr).append(" in (").append(upSql).append(") or ");
            sql.append(filterColStr).append(" in (").append(subSql).append("))");
            return sql.toString();
        }
        if (info.isIsUpVisible()) {
            String upSql = CslGradeManageUtil.getUpSql(longNumber);
            sql.append(filterColStr).append(" in (").append(upSql).append(")");
            return sql.toString();
        }
        if (info.isIsSubVisible()) {
            String subSql = CslGradeManageUtil.getSubSql(longNumber);
            sql.append(filterColStr).append(" in (").append(subSql).append(")");
            return sql.toString();
        }
        String selfSql = CslGradeManageUtil.getSelfSql(longNumber);
        sql.append(filterColStr).append(" in (").append(selfSql).append(")");
        return sql.toString();
    }

    public static EntityViewInfo filteData(Context ctx, EntityViewInfo viewInfo, String CreateOrgKey, String className, String orgUnitId) throws Exception {
        FilterInfo filterInfo;
        if (viewInfo == null) {
            viewInfo = new EntityViewInfo();
        }
        if ((filterInfo = viewInfo.getFilter()) == null) {
            filterInfo = new FilterInfo();
            viewInfo.setFilter(filterInfo);
        }
        if (ctx == null) {
            CslGradeManageUtil.filteData(filterInfo, CreateOrgKey, className, orgUnitId);
        } else {
            CslGradeManageUtil.filterGradeManage(ctx, filterInfo, CreateOrgKey, className, orgUnitId);
        }
        return viewInfo;
    }

    public static void updateMaintainOrg(String tableName, String orgColName, ArrayList selectedIDList) throws EASBizException, BOSException {
        CslGradeManageUtilClient cslGradeManageUtilClient = new CslGradeManageUtilClient();
        cslGradeManageUtilClient.updateMaintainOrgLocal(tableName, orgColName, selectedIDList);
    }

    public static void showBtnByCurrentOrg(KDWorkButton btn) {
        String currentOrgID = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        if (ROOTORGUNIT.equals(currentOrgID)) {
            btn.setVisible(true);
        } else {
            btn.setVisible(false);
        }
    }

    public static void checkNumberDup(String number, DataBaseInfo dataBaseInfo, ICoreBase intf) throws BOSException, EASBizException {
        CoreBaseInfo info;
        if (!StringUtils.isEmpty((String)number) && dataBaseInfo.containsKey("trackRecordCreator") && dataBaseInfo.containsKey("number") && (info = intf.getValue("select trackRecordCreator.name where number='" + number + "'")) != null) {
            throw new ServerException(ServerException.CHECKNUMBERDUP, new Object[]{number, ((CoreBaseInfo)info.get("trackRecordCreator")).get("name")});
        }
    }

    public static void initCslGradeManageButton(KDToolBar toolBar, final EntityViewInfo mainQuery, final String companyField, final String updateTable, final String compoanyCol, final BOSObjectType bosType, final ListUI listUI) {
        if (mainQuery == null || mainQuery.getFilter() == null) {
            return;
        }
        final KDWorkButton displayButton = new KDWorkButton();
        displayButton.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"showSelf"));
        toolBar.add((Component)displayButton);
        final String initFilterSql = mainQuery.getFilter().toSql();
        displayButton.addActionListener(new ActionListener(){
            boolean selfGradeOnly = true;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    String displayStr = null;
                    FilterInfo filterInfo = new FilterInfo();
                    if (!this.selfGradeOnly) {
                        displayStr = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"showSelf");
                        mainQuery.setFilter(initFilterSql);
                    } else {
                        displayStr = EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"showAll");
                        CslGradeManageUtil.getSelfDataPub(filterInfo, companyField, null, null);
                        if (mainQuery.getFilter() == null) {
                            mainQuery.setFilter(filterInfo);
                        } else {
                            mainQuery.getFilter().mergeFilter(filterInfo, "and");
                        }
                    }
                    displayButton.setText(displayStr);
                    listUI.actionRefresh_actionPerformed(null);
                    this.selfGradeOnly = !this.selfGradeOnly;
                }
                catch (Exception e) {
                    logger.error((Object)"displayButton error", (Throwable)e);
                    listUI.handUIException((Throwable)e);
                }
            }
        });
        if (SysContext.getSysContext().getCurrentOrgUnit().getId().toString().equals(ROOTORGUNIT)) {
            KDWorkButton UpdateMaintainOrgButton = new KDWorkButton();
            UpdateMaintainOrgButton.setText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptNewUIResource", (String)"90_alterOrg"));
            toolBar.add((Component)UpdateMaintainOrgButton);
            UpdateMaintainOrgButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    try {
                        CslGradeManageUtil.updateMaintainOrg(updateTable, compoanyCol, listUI.getAllSelecteIDListValues());
                        CacheServiceFactory.getInstance().discardType(bosType);
                        listUI.actionRefresh_actionPerformed(null);
                    }
                    catch (Exception e) {
                        logger.error((Object)"UpdateMaintainOrgButton error", (Throwable)e);
                        listUI.handUIException((Throwable)e);
                    }
                }
            });
        }
    }

    public static String getOrgUnitId(String orgUnitId, Context ctx) throws BOSException {
        FullOrgUnitInfo fullOrgUnitInfo = null;
        try {
            if (StringUtils.isEmpty((String)orgUnitId)) {
                return CslGradeManageUtil.getCurrentOrgUnitId(ctx);
            }
            fullOrgUnitInfo = CslGradeManageUtil.getFullOrgUnitInterface(ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId));
            if (fullOrgUnitInfo != null && fullOrgUnitInfo.isIsUnion()) {
                return CslGradeManageUtil.getCurrentOrgUnitId(ctx);
            }
            CompanyOrgUnitInfo orgUnit = MultOrgUnitHelper.getInstance().getDelegateCompany(OrgType.NONE, orgUnitId, ctx);
            if (orgUnit == null) {
                logger.error((Object)"DelegateCompany is null");
                return null;
            }
            orgUnitId = orgUnit.getId().toString();
        }
        catch (Exception ex) {
            logger.error((Object)"get orgUnit error", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        return orgUnitId;
    }

    private static String getCurrentOrgUnitId(Context ctx) {
        if (ctx == null) {
            return SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        }
        return ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
    }

    private static IFullOrgUnit getFullOrgUnitInterface(Context ctx) throws BOSException {
        if (ctx == null) {
            return FullOrgUnitFactory.getRemoteInstance();
        }
        return FullOrgUnitFactory.getLocalInstance((Context)ctx);
    }

    public static void setF7GMFilter(KDBizPromptBox f7, String CreateOrgKey, String className, String orgUnitId) throws Exception {
        EntityViewInfo curView = f7.getEntityViewInfo();
        if (curView == null) {
            curView = new EntityViewInfo();
        }
        if (curView.getFilter() == null) {
            curView.setFilter(new FilterInfo());
        }
        CslGradeManageUtil.filteData(curView.getFilter(), CreateOrgKey, className, orgUnitId);
        f7.setEntityViewInfo(curView);
    }

    public static void setDataElementF7GMFilter(KDBizPromptBox dataElementF7, String orgUnitId, boolean isIncludeUnUsed) throws Exception {
        EntityViewInfo view = dataElementF7.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        if (view.getFilter() == null) {
            view.setFilter(new FilterInfo());
        }
        if (!isIncludeUnUsed) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("isUsedElim", (Object)Boolean.TRUE));
        }
        CslGradeManageUtil.filteData(view.getFilter(), "trackRecordCreator.id", "com.kingdee.eas.fi.gr.cslrpt.client.DataElementListUI", orgUnitId);
        dataElementF7.setEntityViewInfo(view);
    }
}

