/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MultOrgUnitHelper {
    private static MultOrgUnitHelper helper = null;
    private static Map<OrgType, OrgUnitHandle> entry = null;
    private static Map<String, CompanyOrgUnitInfo> cache = null;

    private MultOrgUnitHelper() {
        entry = new ConcurrentHashMap<OrgType, OrgUnitHandle>();
        cache = new ConcurrentHashMap<String, CompanyOrgUnitInfo>();
        this.register(OrgType.Company, new OrgUnitHandle(OrgType.Company){

            @Override
            protected CompanyOrgUnitInfo excuteQuery(String pk, Context ctx) throws EASBizException, BOSException {
                return MultOrgUnitHelper.this.getCompanyOrgUnitInterface(ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(pk));
            }
        });
        this.register(OrgType.ProfitCenter, new OrgUnitHandle(OrgType.ProfitCenter));
        this.register(OrgType.NONE, new OrgUnitHandle(OrgType.NONE){

            @Override
            protected CompanyOrgUnitInfo excuteQuery(String pk, Context ctx) throws EASBizException, BOSException {
                FullOrgUnitInfo orgUnitInfo = MultOrgUnitHelper.this.getFullOrgUnitInterface(ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(pk));
                if (orgUnitInfo.isIsCompanyOrgUnit()) {
                    return MultOrgUnitHelper.this.getDelegateCompany(OrgType.Company, pk, ctx);
                }
                if (orgUnitInfo.isIsProfitOrgUnit()) {
                    return MultOrgUnitHelper.this.getDelegateCompany(OrgType.ProfitCenter, pk, ctx);
                }
                throw new IllegalArgumentException("Only support OrgType:Company,ProfitCenter!");
            }
        });
    }

    public static synchronized MultOrgUnitHelper getInstance() {
        if (helper == null) {
            helper = new MultOrgUnitHelper();
        }
        return helper;
    }

    public CompanyOrgUnitInfo getDelegateCompany(OrgType orgType, String pk, Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo;
        String key = pk;
        if (ctx != null && pk != null) {
            key = ctx.getAIS() + pk;
        }
        if ((companyInfo = this.getCompanyFromCache(key)) == null && (companyInfo = this.getCompanyFromQuery(orgType, pk, ctx)) != null) {
            this.cacheIt(key, companyInfo);
        }
        return this.getCompanyFromCache(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheIt(String pk, CompanyOrgUnitInfo companyInfo) {
        Map<String, CompanyOrgUnitInfo> map = cache;
        synchronized (map) {
            if (cache.size() > 200) {
                cache.clear();
            }
            cache.put(new String(pk), companyInfo);
        }
    }

    public CompanyOrgUnitInfo getDelegateCompanyNoOrgType(OrgUnitInfo unitInfo, Context ctx) throws EASBizException, BOSException {
        return this.getDelegateCompany(OrgType.NONE, unitInfo.getId().toString(), ctx);
    }

    private CompanyOrgUnitInfo getCompanyFromQuery(OrgType orgType, String pk, Context ctx) throws EASBizException, BOSException {
        this.checkSupport(orgType);
        return entry.get(orgType).excuteQuery(pk, ctx);
    }

    private void checkSupport(OrgType orgType) {
        if (!entry.containsKey(orgType)) {
            throw new IllegalArgumentException("Not Support OrgType " + orgType == null ? null : orgType.getName());
        }
    }

    public CompanyOrgUnitCollection getCompanysFromRelationOrgQuery(OrgType orgType, String orgWhereSql, String orgAlias, Context ctx, SelectorItemCollection selectors) throws EASBizException, BOSException {
        this.checkSupport(orgType);
        return entry.get(orgType).excuteRelationOrgQuery(orgWhereSql, orgAlias, ctx, selectors);
    }

    private CompanyOrgUnitInfo getCompanyFromCache(String key) {
        CompanyOrgUnitInfo companyInfo = cache.get(key);
        if (companyInfo != null) {
            return (CompanyOrgUnitInfo)companyInfo.clone();
        }
        return null;
    }

    private void register(OrgType orgType, OrgUnitHandle handle) {
        entry.put(orgType, handle);
    }

    private ICompanyOrgUnit getCompanyOrgUnitInterface(Context ctx) throws BOSException {
        if (ctx == null) {
            return CompanyOrgUnitFactory.getRemoteInstance();
        }
        return CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
    }

    private IFullOrgUnit getFullOrgUnitInterface(Context ctx) throws BOSException {
        if (ctx == null) {
            return FullOrgUnitFactory.getRemoteInstance();
        }
        return FullOrgUnitFactory.getLocalInstance((Context)ctx);
    }

    private class OrgUnitHandle {
        OrgType _orgType;

        protected OrgUnitHandle(OrgType orgType) {
            this._orgType = orgType;
        }

        protected CompanyOrgUnitInfo excuteQuery(String pk, Context ctx) throws BOSException, EASBizException {
            String companyId = this.getCompanyId(pk, ctx);
            if (StringUtils.isEmpty((String)companyId)) {
                return this.mockDelegateCompany(ctx);
            }
            return MultOrgUnitHelper.this.getCompanyOrgUnitInterface(ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        }

        protected CompanyOrgUnitCollection excuteRelationOrgQuery(String whereSql, String unitPrefixALias, Context ctx, SelectorItemCollection selectors) throws BOSException, EASBizException {
            StringBuffer sql = new StringBuffer();
            sql.append(" select ur.FToUnitID fiUnitId, ");
            sql.append(unitPrefixALias).append(".fnumber fromUnitNumber ");
            sql.append(" from T_ORG_UnitRelation ur ");
            sql.append(" inner join T_ORG_TypeRelation tr ");
            sql.append(" on tr.fid = ur.fTypeRelationID ");
            sql.append(" inner join t_org_baseunit ").append(unitPrefixALias);
            sql.append(" on ").append(unitPrefixALias).append(".fid = ur.FFromUnitID ");
            sql.append(" where tr.FFromType = ? and tr.FToType = 1 ");
            sql.append(" and ( ").append(whereSql);
            sql.append(" ) ");
            IRowSet rs = new DBHandler(ctx).getExecuteSQL().executeQuery(sql.toString(), new Object[]{this._orgType.getValue()});
            if (rs.size() == 0) {
                CompanyOrgUnitCollection companys = new CompanyOrgUnitCollection();
                companys.add(this.mockDelegateCompany(ctx));
                return companys;
            }
            HashSet<String> fiIds = new HashSet<String>(rs.size());
            HashMap<String, String> from2To = new HashMap<String, String>();
            try {
                while (rs.next()) {
                    fiIds.add(rs.getString("fiUnitId"));
                    from2To.put(rs.getString("fiUnitId"), rs.getString("fromUnitNumber"));
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            EntityViewInfo view = new EntityViewInfo();
            if (selectors != null) {
                view.setSelector(selectors);
                view.getSelector().add("id");
            }
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("id", fiIds, CompareType.INCLUDE));
            CompanyOrgUnitCollection companys = MultOrgUnitHelper.this.getCompanyOrgUnitInterface(ctx).getCompanyOrgUnitCollection(view);
            for (int i = 0; i < companys.size(); ++i) {
                String number = (String)from2To.get(companys.get(i).getId().toString());
                if (number == null) continue;
                companys.get(i).setExtendedProperty("fromUnitNumber", number);
            }
            return companys;
        }

        private CompanyOrgUnitInfo mockDelegateCompany(Context ctx) {
            if (ctx == null) {
                return SysContext.getSysContext().getCurrentFIUnit();
            }
            return ContextUtil.getCurrentFIUnit((Context)ctx);
        }

        private String getCompanyId(String pk, Context ctx) throws BOSException {
            StringBuilder oql = new StringBuilder();
            oql.append(" select * \n").append(" where fromunit.id =").append(this.toFormat(pk, true)).append(" and typeRelation.fromtype =").append(this.toFormat(this._orgType.getValue(), false)).append(" and typeRelation.totype = 1");
            OrgUnitRelationCollection col = this.getOrgUnitRelationInterface(ctx).getOrgUnitRelationCollection(oql.toString());
            if (col != null && col.size() > 0) {
                return col.get(0).getToUnit().getId().toString();
            }
            return null;
        }

        private String toFormat(Object param, boolean isString) {
            if (isString) {
                return "'" + param.toString() + "'";
            }
            return param.toString();
        }

        private IOrgUnitRelation getOrgUnitRelationInterface(Context ctx) throws BOSException {
            if (ctx == null) {
                return OrgUnitRelationFactory.getRemoteInstance();
            }
            return OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        }
    }
}

