/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxy;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.uiframe.client.IUIManager;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.base.uiframe.client.ui.IMainUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.ContextManagerFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.IContextManager;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.ConvertStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.FormulaCalcContextInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.client.SumRptProcessUI;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.newrpt.MultOrgUnitHelper;
import com.kingdee.eas.fi.newrpt.RptNewUIHandleFacadeFactory;
import com.kingdee.eas.fi.newrpt.client.rptnewui.ProfReportProcessUI;
import com.kingdee.eas.fi.newrpt.client.rptnewui.RptReportProcessNewUI;
import com.kingdee.eas.fi.newrpt.client.rptnewui.SingleReportProcessNewUI;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.OrgNodeUserDefineInfo;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.ReportCondition;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.UserOrgPermissionInfo;
import com.kingdee.eas.fi.newrpt.client.rptnewui.util.context.WktbContextFactory;
import com.kingdee.eas.fi.newrpt.cslworktable.util.context.CslReportCondition;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CheckedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.IsSupportGroupReportEnum;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportCollection;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptHandleStatusEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamFactory;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.client.RptReportProcessUI;
import com.kingdee.eas.fi.rpt.client.template.TemplateProvider;
import com.kingdee.eas.framework.client.service.PermissionService;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.jfree.util.Log;

public class RptNewUIUtil {
    public static String combineReportKey(ReportInfo report) {
        StringBuffer reportKey = new StringBuffer();
        if (report == null) {
            return reportKey.toString();
        }
        reportKey.append(RptNewUIUtil.wrappedKey("companyPK:" + report.getCompany().getId()));
        reportKey.append(RptNewUIUtil.wrappedKey("periodType:" + report.getPeriodType().getName()));
        reportKey.append(RptNewUIUtil.wrappedKey("year:" + report.getYear()));
        reportKey.append(RptNewUIUtil.wrappedKey("period:" + report.getPeriod()));
        reportKey.append(RptNewUIUtil.wrappedKey("currencyPK:" + report.getCurrency().getId()));
        reportKey.append(RptNewUIUtil.wrappedKey("templategroup:" + (report.getTemplate() == null ? "NULL" : (report.getK3Template() != null ? report.getK3Template().getGroup() : report.getTemplate().getGroup()))));
        return reportKey.toString();
    }

    public static String combineRptCondtionKey(ReportCondition condition) {
        StringBuffer conditionKey = new StringBuffer();
        conditionKey.append(RptNewUIUtil.wrappedKey("companyPK:" + condition.getOrgNodeInfo().getOrgPK()));
        conditionKey.append(RptNewUIUtil.wrappedKey("periodType:" + condition.getPeriodType().getName()));
        conditionKey.append(RptNewUIUtil.wrappedKey("year:" + condition.getYear()));
        conditionKey.append(RptNewUIUtil.wrappedKey("period:" + condition.getPeriod()));
        conditionKey.append(RptNewUIUtil.wrappedKey("currencyPK:" + condition.getCurrency().getId()));
        conditionKey.append(RptNewUIUtil.wrappedKey("templategroup:" + (condition.getTmplNodeInfo() != null ? condition.getTmplNodeInfo().getTmplGroup() : "NULL")));
        return conditionKey.toString();
    }

    public static String wrappedKey(String value) {
        return "[" + value + "]";
    }

    public static ReportCollection getReportCollByCondition(Set<String> grpIDs, ReportCondition condition) throws BOSException {
        if (grpIDs == null || grpIDs.size() == 0) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("template.group");
        sic.add("k3Template.group");
        StringBuffer mask = new StringBuffer();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("template.group", grpIDs, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("k3Template.group", grpIDs, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)condition.getPeriodType().getValue()));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)condition.getYear()));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)condition.getPeriod()));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)condition.getOrgNodeInfo().getOrgPK()));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)condition.getCurrency().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("dataCollectNumber", (Object)"ACTUALDATA"));
        mask.append("(#0 or #1) and #2 and #3 and #4 and #5 and #6 and #7");
        if (condition.isAutoGetItem()) {
            filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)100));
            mask.append(" and #8 ");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("isSupportGroup", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)100, CompareType.NOTEQUALS));
            mask.append(" and (#8 or #9) and #10");
        }
        filter.setMaskString(mask.toString());
        view.setSelector(sic);
        view.setFilter(filter);
        return ReportFactory.getRemoteInstance().getReportCollection(view);
    }

    public static ReportCollection getReportCollByTmplGroupID(Context ctx, SelectorItemCollection sic, Set<String> grpIDs, RptPeriodTypeEnum periodType, int year, int period, String companyPK, String currencyID) throws BOSException {
        if (sic == null) {
            sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("template.group");
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("template.group", grpIDs, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodType.getValue()));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)year));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)period));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyPK));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyID));
        filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)100, CompareType.NOTEQUALS));
        view.setFilter(filter);
        view.setSelector(sic);
        if (ctx == null) {
            return ReportFactory.getRemoteInstance().getReportCollection(view);
        }
        return ReportFactory.getLocalInstance((Context)ctx).getReportCollection(view);
    }

    public static Map<String, String> collectGrpIDsMap(Context ctx, TemplateCollection tmplCol, boolean includeK3) throws BOSException {
        HashMap<String, String> grpIDs = new HashMap<String, String>();
        if (tmplCol == null || tmplCol.size() == 0) {
            return grpIDs;
        }
        HashSet<String> IDs = new HashSet<String>();
        for (int i = 0; i < tmplCol.size(); ++i) {
            TemplateInfo info = tmplCol.get(i);
            IDs.add(info.getId().toString());
            if (StringUtils.isEmpty((String)info.getEasTplIdForK3()) || !includeK3) continue;
            IDs.add(info.getEasTplIdForK3());
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("group");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", IDs, CompareType.INCLUDE));
        view.setFilter(filter);
        TemplateCollection col = ctx == null ? TemplateFactory.getRemoteInstance().getTemplateCollection(view) : TemplateFactory.getLocalInstance((Context)ctx).getTemplateCollection(view);
        for (int i = 0; i < col.size(); ++i) {
            grpIDs.put(col.get(i).getId().toString(), col.get(i).getGroup());
        }
        return grpIDs;
    }

    public static void setReportTag2Template(ReportCollection rptCol, TemplateCollection tmplCol, Map<String, String> grpIDsMap) {
        int i;
        if (tmplCol == null) {
            return;
        }
        HashSet<String> grpIDs = new HashSet<String>(rptCol.size());
        if (rptCol != null) {
            for (i = 0; i < rptCol.size(); ++i) {
                grpIDs.add(rptCol.get(i).getTemplate().getGroup());
            }
        }
        for (i = 0; i < tmplCol.size(); ++i) {
            if (grpIDs.contains(tmplCol.get(i).getGroup()) || grpIDs.contains(grpIDsMap.get(tmplCol.get(i).getEasTplIdForK3()))) {
                tmplCol.get(i).put("hasReport", (Object)1);
                tmplCol.get(i).put("select", (Object)Boolean.FALSE);
                continue;
            }
            tmplCol.get(i).put("hasReport", (Object)0);
            tmplCol.get(i).put("select", (Object)Boolean.TRUE);
        }
    }

    public static CurrencyInfo getCompanyBasicCurrency(OrgType orgType, String selNodeOrgPK) throws EASBizException, BOSException {
        CompanyOrgUnitInfo delegateCom;
        ObjectStringPK pk = RptNewUIUtil.isFiOrgType(orgType) ? new ObjectStringPK(selNodeOrgPK) : new ObjectStringPK((delegateCom = RptNewUIUtil.getDelegateCompany(orgType, selNodeOrgPK)) == null ? SysContext.getSysContext().getCurrentFIUnit().getId().toString() : delegateCom.getId().toString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("baseCurrency.id"));
        selector.add(new SelectorItemInfo("baseCurrency.precision"));
        selector.add(new SelectorItemInfo("baseCurrency.number"));
        selector.add(new SelectorItemInfo("baseCurrency.name"));
        return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)pk, selector).getBaseCurrency();
    }

    public static boolean isFiOrgType(OrgType orgType) {
        return OrgType.Company.equals((Object)orgType);
    }

    public static Integer getIntegerVal(Object obj, int defaltVal) {
        Integer value = null;
        value = obj instanceof Number ? Integer.valueOf(((Number)obj).intValue()) : (obj instanceof String ? Integer.getInteger((String)obj) : new Integer(defaltVal));
        if (value == null) {
            value = new Integer(defaltVal);
        }
        return value;
    }

    public static String getStringVal(Object obj, String defaltVal) {
        if (obj instanceof Number) {
            return ((Number)obj).toString();
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return defaltVal;
    }

    public static Map<String, OrgNodeUserDefineInfo> getAuthorizedOrg(IObjectPK userPK, String[] permItems, OrgType orgType) throws Exception {
        IRowSet rs = RptNewUIHandleFacadeFactory.getRemoteInstance().getAuthorizedOrg(userPK, permItems, orgType);
        if (rs == null || rs.size() == 0) {
            return new HashMap<String, OrgNodeUserDefineInfo>(0);
        }
        return RptNewUIUtil.wrapOrgPermItemInfo(rs, orgType);
    }

    public static Map<String, OrgNodeUserDefineInfo> getAuthorizedOrg(IObjectPK userPK, String[] permItems, OrgType orgType, RptProperties pros) throws Exception {
        IRowSet rs = RptNewUIHandleFacadeFactory.getRemoteInstance().getAuthorizedOrg(userPK, permItems, orgType, pros);
        if (rs == null || rs.size() == 0) {
            return new HashMap<String, OrgNodeUserDefineInfo>(0);
        }
        return RptNewUIUtil.wrapOrgPermItemInfo(rs, orgType);
    }

    private static Map<String, OrgNodeUserDefineInfo> wrapOrgPermItemInfo(IRowSet rs, OrgType orgType) throws SQLException {
        HashMap<String, OrgNodeUserDefineInfo> OrgNodeMap = new HashMap<String, OrgNodeUserDefineInfo>();
        while (rs.next()) {
            OrgNodeUserDefineInfo nodeInfo;
            String orgPK = rs.getString("FID");
            String number = rs.getString("FNumber");
            String longNum = rs.getString("FLongNumber");
            String name = rs.getString("Fname");
            String permItemName = rs.getString("FPermItemName");
            if (OrgNodeMap.containsKey(orgPK)) {
                nodeInfo = (OrgNodeUserDefineInfo)OrgNodeMap.get(orgPK);
            } else {
                nodeInfo = new OrgNodeUserDefineInfo();
                nodeInfo.setOrgPermInfo(new UserOrgPermissionInfo());
                nodeInfo.setOrgPK(orgPK);
                nodeInfo.setLongNum(longNum);
                nodeInfo.setName(name);
                nodeInfo.setNumber(number);
                nodeInfo.setOrgType(orgType);
                OrgNodeMap.put(orgPK, nodeInfo);
            }
            UserOrgPermissionInfo permInfo = nodeInfo.getOrgPermInfo();
            permInfo.handlePermission(permItemName);
        }
        return OrgNodeMap;
    }

    public static void setMenuEnabled(boolean isEnabled, Component[] menuItems, Set<KDMenuItem> excludeMenu) {
        if (menuItems == null) {
            return;
        }
        for (int i = 0; i < menuItems.length; ++i) {
            if (!(menuItems[i] instanceof KDMenuItem)) continue;
            KDMenuItem menuitem = (KDMenuItem)menuItems[i];
            if (excludeMenu != null && excludeMenu.contains(menuitem)) continue;
            if (menuitem.getAction() != null) {
                menuitem.getAction().setEnabled(isEnabled);
                continue;
            }
            menuitem.setEnabled(isEnabled);
        }
    }

    public static void registerWorkTableTag(Map uiContext) {
        if (uiContext == null) {
            return;
        }
        uiContext.put("fromWorkTable", Boolean.TRUE);
    }

    public static void putOrgTypeOnContext(Map uiContext, OrgType orgType) {
        if (uiContext == null) {
            return;
        }
        uiContext.put("orgType", orgType);
    }

    public static OrgType getOrgTypeOnContext(Map uiContext) {
        if (uiContext == null) {
            return OrgType.Company;
        }
        Object obj = uiContext.get("orgType");
        return obj == null ? OrgType.Company : (OrgType)obj;
    }

    public static void removeWorkTableFlag(UIContext uiContext) {
        if (uiContext == null) {
            return;
        }
        uiContext.remove((Object)"fromWorkTable");
    }

    public static boolean isFromWorkTable(Map uiContext) {
        if (uiContext == null || !uiContext.containsKey("fromWorkTable")) {
            return false;
        }
        return (Boolean)uiContext.get("fromWorkTable");
    }

    public static void openProcessUI(UIContext uiContext, String className, String oprtState) throws UIException {
        final IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(className, (Map)uiContext, null, oprtState);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                uiWindow.show();
            }
        });
    }

    public static void openReportUIAllInOne(UIContext uiContext, String className, String oprtState) throws UIException {
        RptNewUIUtil.openReportUIAllInOne(uiContext, className, oprtState, false);
    }

    public static void openReportUIAllInOne(UIContext uiContext, String className, String oprtState, boolean isFromWeb) throws UIException {
        IUIObject uiObject = RptNewUIUtil.findUI(uiContext, className);
        if (uiObject == null) {
            if (isFromWeb) {
                SystemEntry.instance.closingWindow(SystemEntry.instance.getMainUIObject().getUIContainer(), false);
            }
            RptNewUIUtil.openProcessUI(uiContext, className, oprtState);
        } else {
            RptReportProcessNewUI ui = (RptReportProcessNewUI)uiObject;
            if (!ui.isShowing()) {
                ui.getUIWindow().show();
            }
            ui.openReportByUIContext(uiContext, oprtState);
        }
    }

    public static IUIObject findUI(UIContext uiContext, String uiClassName) throws UIException {
        IMainUIObject mainUI = UIFactoryHelper.getMainUIObject((Map)uiContext);
        IUIManager uiManager = mainUI.getUiManager();
        List winUiObjects = uiManager.getWinUiObjects();
        IUIObject uiObject2 = null;
        boolean isFound = false;
        for (IUIObject uiObject2 : winUiObjects) {
            if (!uiClassName.equals(uiObject2.getClass().getName())) continue;
            isFound = true;
            if (!(isFound = RptNewUIUtil.checkIfFromSingleRpt(uiContext, uiObject2, isFound))) continue;
        }
        if (!isFound) {
            List tabUIObjects = uiManager.getTabUiObjects();
            for (IUIObject uiObject2 : tabUIObjects) {
                if (!uiClassName.equals(uiObject2.getClass().getName())) continue;
                isFound = true;
                if (!(isFound = RptNewUIUtil.checkIfFromSingleRpt(uiContext, uiObject2, isFound))) continue;
            }
        }
        return isFound ? uiObject2 : null;
    }

    private static boolean checkIfFromSingleRpt(UIContext uiContext, IUIObject uiObject, boolean isFound) {
        if (isFound && uiObject instanceof SingleReportProcessNewUI && uiContext.containsKey((Object)"currentInfo")) {
            isFound = ((SingleReportProcessNewUI)uiObject).getWindowTag().equals(((FormulaCalcContextInfo)uiContext.get((Object)"currentInfo")).getId().toString());
        }
        return isFound;
    }

    public static IUIObject getParentUIFromUIContext(Map uiContext) {
        if (uiContext == null) {
            return null;
        }
        Object parentUI = uiContext.get("Owner");
        while (parentUI != null) {
            if (parentUI instanceof IUIObject) {
                return (IUIObject)parentUI;
            }
            if (!(parentUI instanceof Map)) continue;
            parentUI = ((Map)parentUI).get("Owner");
        }
        return null;
    }

    public static IsSupportGroupReportEnum IsSupportGroupReport(RptTmpTypeEnum tmplType) {
        if (tmplType == null || RptTmpTypeEnum.COMMONREPORT.equals((Object)tmplType) || RptTmpTypeEnum.COMMONPUBLICTEMPLATE.equals((Object)tmplType)) {
            return IsSupportGroupReportEnum.NOTSUPPORT;
        }
        return IsSupportGroupReportEnum.SUPPORT;
    }

    public static boolean isGroupTemplate(RptTmpTypeEnum tmplType) {
        return IsSupportGroupReportEnum.SUPPORT.equals((Object)RptNewUIUtil.IsSupportGroupReport(tmplType));
    }

    public static ReportInfo constructReportInfoByTemplateInfo(TemplateInfo tmpl) throws IOException, Exception {
        return RptNewUIUtil.constructReportInfoByTemplateInfo(tmpl, true);
    }

    public static ReportInfo constructReportInfoByTemplateInfo(TemplateInfo tmpl, boolean isSetBook) throws IOException, Exception {
        ReportInfo report = new ReportInfo();
        report.setId(BOSUuid.create((BOSObjectType)report.getBOSType()));
        report.setName(tmpl.getName());
        if (isSetBook) {
            Book book = tmpl.getBook();
            boolean isAutoCalculate = book.isAutoCalculate();
            book.setAutoCalculate(false);
            report.setBook(book);
            book.setAutoCalculate(isAutoCalculate);
        }
        report.setPeriodType(tmpl.getPeriodType());
        report.setSourceType(RptNewUIUtil.adjustReportSourceType(tmpl.getTemplateType()));
        report.setDataCollect(DataCollectConstant.getActualDC());
        report.setDataCollectNumber("ACTUALDATA");
        report.setIsSupportGroup(IsSupportGroupReportEnum.NOTSUPPORT);
        report.setHandleStatus(RptHandleStatusEnum.FINISHED);
        report.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        report.setConvertStatus(ConvertStatusEnum.BeforeConvert);
        report.setPublishedStatus(PublishedStatusEnum.UNPUBLISHED);
        report.setCommittedStatus(CommittedStatusEnum.UNCOMMITTED);
        report.setCheckedStatus(CheckedStatusEnum.UNCHECKED);
        report.setIsOpenAutoCalc(false);
        report.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        if (tmpl.isIsK3Tpl()) {
            report.setK3Template(tmpl);
            report.setTemplate((TemplateInfo)new TemplateProvider().queryEditData((IObjectPK)new ObjectUuidPK(tmpl.getEasTplIdForK3())));
        } else {
            report.setTemplate(tmpl);
        }
        report.getSheetParam().addCollection(RptNewUIUtil.queryTemplateParams(tmpl));
        return report;
    }

    public static RptSheetParamCollection queryTemplateParams(TemplateInfo temp) throws Exception {
        String tempId = temp.getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("sheetName"));
        sic.add(new SelectorItemInfo("startYear"));
        sic.add(new SelectorItemInfo("endYear"));
        sic.add(new SelectorItemInfo("startPeriod"));
        sic.add(new SelectorItemInfo("endPeriod"));
        sic.add(new SelectorItemInfo("startDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("isIncludingUnposted"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("relaType"));
        sic.add(new SelectorItemInfo("sheetID"));
        sic.add(new SelectorItemInfo("report.id"));
        sic.add(new SelectorItemInfo("reportClass"));
        sic.add(new SelectorItemInfo("postil.*"));
        sic.add(new SelectorItemInfo("dfData.*"));
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("report", (Object)tempId);
        filter.getFilterItems().add(filterItem);
        view.setFilter(filter);
        RptSheetParamCollection rptSheetParamCollection = RptSheetParamFactory.getRemoteInstance().getRptSheetParamCollection(view);
        if (rptSheetParamCollection != null && rptSheetParamCollection.size() > 0) {
            for (int j = 0; j < rptSheetParamCollection.size(); ++j) {
                RptSheetParamInfo info = rptSheetParamCollection.get(j);
                info.setRelaType(ReportTypeEnum.REPORT);
                info.setId(null);
                info.setStatus(1);
            }
        }
        return rptSheetParamCollection;
    }

    public static RptSrcTypeEnum adjustReportSourceType(RptTmpTypeEnum tmplType) {
        if (tmplType == null) {
            return RptSrcTypeEnum.NORMAL;
        }
        if (RptTmpTypeEnum.COMMONREPORT.equals((Object)tmplType) || RptTmpTypeEnum.COMMONPUBLICTEMPLATE.equals((Object)tmplType)) {
            return RptSrcTypeEnum.NORMAL;
        }
        if (RptTmpTypeEnum.DYNAMICNORMALREPORT.equals((Object)tmplType) || RptTmpTypeEnum.RPTDYNAMICREPORT.equals((Object)tmplType)) {
            return RptSrcTypeEnum.DYNAMICNORMALREPORT;
        }
        if (RptTmpTypeEnum.MULTIDYNAMICCSLREPORT.equals((Object)tmplType) || RptTmpTypeEnum.MULTIRPTDYNAMICREPORT.equals((Object)tmplType)) {
            return RptSrcTypeEnum.MULTIDYNAMICNORMALREPORT;
        }
        return RptSrcTypeEnum.COMMITREPORT;
    }

    public static OrgUnitInfo getRptWktOrgUnitInfo(Map uiContext, IUIObject ui) {
        if (RptNewUIUtil.isFromWorkTable(uiContext)) {
            try {
                return WktbContextFactory.getInstance().getRptContext(RptNewUIUtil.getOrgTypeOnContext(uiContext)).getOrgUnitInfo();
            }
            catch (Exception e) {
                ui.handUIException((Throwable)e);
                SysUtil.abort();
            }
        }
        return SysContext.getSysContext().getCurrentFIUnit();
    }

    public static CompanyOrgUnitInfo getDelegateCompany(Map uiContext, IUIObject ui) {
        if (RptNewUIUtil.isFromWorkTable(uiContext)) {
            try {
                OrgType orgType = RptNewUIUtil.getOrgTypeOnContext(uiContext);
                String pk = WktbContextFactory.getInstance().getRptContext(RptNewUIUtil.getOrgTypeOnContext(uiContext)).getOrgUnitInfo().getId().toString();
                return RptNewUIUtil.getDelegateCompany(orgType, pk);
            }
            catch (Exception e) {
                ui.handUIException((Throwable)e);
                SysUtil.abort();
            }
        }
        return SysContext.getSysContext().getCurrentFIUnit();
    }

    public static CompanyOrgUnitInfo getDelegateCompany(OrgType orgType, String pk) throws EASBizException, BOSException {
        if (orgType == null) {
            orgType = OrgType.Company;
        }
        return MultOrgUnitHelper.getInstance().getDelegateCompany(orgType, pk, null);
    }

    public static CompanyOrgUnitInfo getDelegateCompany(OrgType orgType, OrgUnitInfo unitInfo) throws EASBizException, BOSException {
        if (orgType == null) {
            orgType = OrgType.Company;
        }
        return MultOrgUnitHelper.getInstance().getDelegateCompany(orgType, unitInfo.getId().toString(), null);
    }

    public static CompanyOrgUnitInfo getDelegateCompanyNoOrgType(Context ctx, OrgUnitInfo unitInfo) throws EASBizException, BOSException {
        return MultOrgUnitHelper.getInstance().getDelegateCompanyNoOrgType(unitInfo, ctx);
    }

    public static CompanyOrgUnitCollection getDelegateCompany(Context ctx, OrgType orgType, String orgWhereSql, String orgAlias, SelectorItemCollection selectors) throws EASBizException, BOSException {
        return MultOrgUnitHelper.getInstance().getCompanysFromRelationOrgQuery(orgType, orgWhereSql, orgAlias, ctx, selectors);
    }

    public static CompanyOrgUnitInfo getDelegateCompanyByNumber(Context ctx, OrgType orgType, String orgNum, SelectorItemCollection selectors) throws EASBizException, BOSException {
        String orgAlias = "bu";
        String orgWhereSql = orgAlias + ".fnumber = '" + orgNum + "'";
        CompanyOrgUnitCollection orgs = RptNewUIUtil.getDelegateCompany(ctx, orgType, orgWhereSql, orgAlias, selectors);
        if (orgs.isEmpty()) {
            return null;
        }
        return orgs.get(0);
    }

    public static void putOrgTypeOnUIContextUsedReflect(Map uicontext, Class uiClass, Object instance) {
        OrgType orgType = RptNewUIUtil.getOrgTypeUsedReflect(uiClass, instance);
        if (orgType != null) {
            uicontext.put("orgType", orgType);
        }
    }

    public static OrgType getOrgTypeUsedReflect(Class glass, Object instance) {
        try {
            Method method = glass.getDeclaredMethod("getWktbOrgType", new Class[0]);
            if (method != null) {
                NewRptUtil.makeAccessible(method);
                return (OrgType)method.invoke(instance, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return OrgType.Company;
    }

    public static OrgUnitInfo getTmplWktOrgUnitInfo(Map uiContext, IUIObject ui) {
        if (RptNewUIUtil.isFromWorkTable(uiContext)) {
            try {
                return WktbContextFactory.getInstance().getTemplateContext(RptNewUIUtil.getOrgTypeOnContext(uiContext)).getOrgUnitInfo();
            }
            catch (Exception e) {
                ui.handUIException((Throwable)e);
                SysUtil.abort();
            }
        }
        return SysContext.getSysContext().getCurrentFIUnit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasMutexLock(Context ctx, String objectId) {
        IMutexServiceControl mutexService = null;
        boolean tag = true;
        if (StringUtils.isEmpty((String)objectId)) {
            return false;
        }
        try {
            mutexService = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
            tag = mutexService.requestBizObjIDForUpdate(objectId);
        }
        catch (Exception ex) {
            Log.error((Object)ex.getMessage(), (Exception)ex);
        }
        finally {
            if (tag) {
                mutexService.releaseObjIDForUpdate(objectId);
            }
        }
        return !tag;
    }

    public static void synchroOrgInfo2Server(IContextManager ctxManager, OrgUnitInfo org, CtrlUnitInfo cu, OrgType orgType) throws BOSException {
        if (ctxManager == null) {
            ctxManager = ContextManagerFactory.getRemoteInstance();
        }
        if (org == null) {
            org = SysContext.getSysContext().getCurrentOrgUnit();
        }
        if (OrgType.Company.equals((Object)orgType) && !(org instanceof CompanyOrgUnitInfo)) {
            org = (CompanyOrgUnitInfo)org.cast(CompanyOrgUnitInfo.class);
        }
        HashMap<OrgType, Object> syncMap = new HashMap<OrgType, Object>();
        syncMap.put(orgType, org);
        if (cu != null && !StringUtils.isEmpty((String)cu.getLongNumber())) {
            syncMap.put(OrgType.ControlUnit, cu);
        } else if (org.getCU() != null) {
            CtrlUnitInfo curCu = org.getCU();
            if (StringUtils.isEmpty((String)org.getCU().getLongNumber())) {
                try {
                    curCu = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(org.getCU().getId()));
                }
                catch (EASBizException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            syncMap.put(OrgType.ControlUnit, curCu);
        }
        ctxManager.setContext(syncMap);
    }

    public static int[] getFICurrPeriod(CompanyOrgUnitInfo companyOrgUnitInfo) {
        if (!companyOrgUnitInfo.isIsBizUnit()) {
            String subCompanyIds = RptNewUIUtil.getSubCompanyIds(companyOrgUnitInfo);
            companyOrgUnitInfo.setDescription(subCompanyIds);
        }
        try {
            PeriodEntity periodEntity = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)companyOrgUnitInfo);
            PeriodEntity currPeriod = periodEntity.getQueryPeriod();
            return new int[]{currPeriod.getCurrentYear(), currPeriod.getCurrentPeriod()};
        }
        catch (Exception e) {
            return RptNewUIUtil.getCurrNaturePeriod();
        }
    }

    public static int[] getFICurrPeriod(OrgUnitInfo orgUnitInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo comInfo = RptNewUIUtil.getDelegateCompanyNoOrgType(null, orgUnitInfo);
        return RptNewUIUtil.getFICurrPeriod(comInfo);
    }

    public static int[] getCurrNaturePeriod() {
        return RPTDateUtil.getPeriod((Date)new Date(), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
    }

    public static PeriodCollection getFiscal(OrgUnitInfo unitInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo comInfo = RptNewUIUtil.getDelegateCompanyNoOrgType(null, unitInfo);
        return InitDataFacadaFactory.getRemoteInstance().getFiscal((IObjectPK)new ObjectUuidPK(comInfo.getId().toString()));
    }

    private static String getSubCompanyIds(CompanyOrgUnitInfo company) {
        return new StringBuffer(" SELECT FID FROM T_ORG_COMPANY WHERE FLONGNUMBER LIKE '").append(company.getLongNumber()).append("!%' AND FISASSISTANTORG = 0 AND FISBIZUNIT = 1 ").toString();
    }

    public static CompanyOrgUnitInfo getCompanyOrgUnitInfo(String pk) throws EASBizException, BOSException {
        return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(pk));
    }

    public static FullOrgUnitInfo getFullOrgUnitInfo(String pk) throws EASBizException, BOSException {
        return FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(pk));
    }

    public static void removeActionPermisionService(HashMap actionSet) {
        if (actionSet != null) {
            for (Map.Entry entry : actionSet.entrySet()) {
                ItemAction action = (ItemAction)entry.getValue();
                action.getServices().remove(PermissionService.class.getName());
            }
        }
    }

    public static void removeMenuBarActionPermisionService(KDMenuBar menuBar) {
        if (menuBar == null) {
            return;
        }
        Field serviceField = RptNewUIUtil.getActionProxyServiceField();
        int size = menuBar.getMenuCount();
        for (int i = 0; i < size; ++i) {
            KDMenu menu = (KDMenu)menuBar.getMenu(i);
            RptNewUIUtil.removeMenuPermisionService(menu, serviceField);
        }
    }

    private static void removeMenuPermisionService(KDMenu menu, Field serviceField) {
        for (Component item : menu.getMenuComponents()) {
            if (item instanceof KDMenuItem) {
                Action a = ((KDMenuItem)item).getAction();
                if (!(a instanceof ActionProxy) || serviceField == null) continue;
                try {
                    ((Map)serviceField.get((ActionProxy)a)).remove(PermissionService.class.getName());
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!(item instanceof KDMenu)) continue;
            RptNewUIUtil.removeMenuPermisionService((KDMenu)item, serviceField);
        }
    }

    private static Field getActionProxyServiceField() {
        Field[] fs = ActionProxy.class.getDeclaredFields();
        Field serviceField = null;
        for (Field f : fs) {
            if (f.getName() != "services") continue;
            serviceField = f;
            NewRptUtil.makeAccessible(serviceField);
            break;
        }
        return serviceField;
    }

    public static void removeToolsBarActionPermisionService(KDToolBar toolBar) {
        if (toolBar == null) {
            return;
        }
        Field serviceField = RptNewUIUtil.getActionProxyServiceField();
        for (Component item : toolBar.getToolBarComponents()) {
            Action a;
            if (!(item instanceof KDWorkButton) || !((a = ((KDWorkButton)item).getAction()) instanceof ActionProxy) || serviceField == null) continue;
            try {
                ((Map)serviceField.get((ActionProxy)a)).remove(PermissionService.class.getName());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static void handleHideComponentsByVertical(List<Component[]> componentList) throws Exception {
        for (int i = componentList.size() - 1; i >= 1; --i) {
            Component[] compArr = componentList.get(i);
            if (RptNewUIUtil.isVisible(compArr)) continue;
            RptNewUIUtil.hideChildComponents(componentList, i);
        }
    }

    private static void hideChildComponents(List<Component[]> componentList, int index) throws Exception {
        Component[] compArr = componentList.get(index);
        int offSetY = 0;
        if (componentList.size() <= index + 1) {
            return;
        }
        offSetY = componentList.get((int)(index + 1))[0].getBounds().y - compArr[0].getBounds().y;
        Rectangle tmpRectangle = null;
        for (int i = index + 1; i < componentList.size(); ++i) {
            for (Component component : compArr = componentList.get(i)) {
                tmpRectangle = component.getBounds();
                tmpRectangle.y -= offSetY;
                component.setBounds(tmpRectangle);
            }
        }
    }

    private static boolean isVisible(Component[] compArr) {
        boolean isVisible = false;
        for (Component comp : compArr) {
            if (!comp.isVisible()) continue;
            isVisible = true;
        }
        return isVisible;
    }

    public static String combineCslReportKey(CslReportInfo report, boolean isTemplate) {
        StringBuffer reportKey = new StringBuffer();
        if (report == null) {
            return reportKey.toString();
        }
        reportKey.append(RptNewUIUtil.wrappedKey("companyPK:" + report.getOrgUnit().getId()));
        reportKey.append(RptNewUIUtil.wrappedKey("periodType:" + report.getPeriodType().getName()));
        reportKey.append(RptNewUIUtil.wrappedKey("year:" + report.getYear()));
        reportKey.append(RptNewUIUtil.wrappedKey("period:" + report.getPeriod()));
        reportKey.append(RptNewUIUtil.wrappedKey("currencyPK:" + report.getCurrency().getId()));
        reportKey.append(RptNewUIUtil.wrappedKey("cslreportid:" + (isTemplate ? report.getTemplate().getId().toString() : report.getId().toString())));
        reportKey.append(RptNewUIUtil.wrappedKey("orgTreePK:" + report.getOrgTree().getId()));
        return reportKey.toString();
    }

    public static String combineCslRptCondtionKey(CslReportCondition condition) {
        StringBuffer conditionKey = new StringBuffer();
        conditionKey.append(RptNewUIUtil.wrappedKey("companyPK:" + condition.getOrgNodeInfo().getUnit().getId().toString()));
        conditionKey.append(RptNewUIUtil.wrappedKey("periodType:" + condition.getPeriodType().getName()));
        conditionKey.append(RptNewUIUtil.wrappedKey("year:" + condition.getYear()));
        conditionKey.append(RptNewUIUtil.wrappedKey("period:" + condition.getPeriod()));
        conditionKey.append(RptNewUIUtil.wrappedKey("currencyPK:" + condition.getCurrency().getId()));
        conditionKey.append(RptNewUIUtil.wrappedKey("cslreportid:" + (condition.getTmplNodeInfo() != null ? (condition.getTmplNodeInfo().isTemplate() ? condition.getTmplNodeInfo().getTmplID() : condition.getTmplNodeInfo().getReportID()) : "NULL")));
        conditionKey.append(RptNewUIUtil.wrappedKey("orgTreePK:" + condition.getTreeInfo().getId().toString()));
        return conditionKey.toString();
    }

    public static String getUIModule(Object uiObject) {
        String module = null;
        if (uiObject != null) {
            if (uiObject instanceof ProfReportProcessUI) {
                module = "RPT";
            } else if (uiObject instanceof RptReportProcessNewUI) {
                module = "FSSC_RPT";
            } else if (uiObject instanceof RptReportProcessUI) {
                module = "RPT";
            } else if (uiObject instanceof MnsRptProcessUI || uiObject instanceof CslRptProcessUI || uiObject instanceof SumRptProcessUI || uiObject instanceof GroupRptProcessUI) {
                module = "CONS";
            }
        }
        return module;
    }
}

