/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.AbstractPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.accountcheck.client.CheckageCompanyF7UI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccountCheckF7
extends AbstractPromptSelector {
    private static Logger logger = Logger.getLogger(AccountCheckF7.class);
    protected CheckageCompanyF7UI f7ui = null;
    protected Window owner = null;
    protected IUIObject uiOwner = null;
    private Set selectedOrgIds;

    public AccountCheckF7(IUIObject _uiObject) {
        this.uiOwner = _uiObject;
    }

    public void setInputData(HashMap params) throws Exception {
    }

    public void show() {
        this.createF7UI();
        if (this.f7ui != null) {
            this.f7ui.getUIWindow().show();
        }
    }

    private void createF7UI() {
        try {
            if (this.uiOwner != null) {
                this.owner = ComponentUtil.getOwnerWindow((Component)((Component)this.uiOwner));
            }
            if (this.owner == null) {
                this.owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            }
            long t1 = System.currentTimeMillis();
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CheckageCompanyF7UI.class.getName(), this.buildUIContext());
            this.f7ui = (CheckageCompanyF7UI)uiWindow.getUIObject();
            logger.info((Object)("createUI cost: " + (System.currentTimeMillis() - t1)));
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
        }
    }

    private Map buildUIContext() {
        UIContext uiContext = new UIContext((Object)this.owner);
        uiContext.put((Object)"OrgF7Proxy", (Object)this);
        uiContext.put((Object)"selectedOrgIds", (Object)this.selectedOrgIds);
        return uiContext;
    }

    public Set getSelectedOrgIds() {
        return this.selectedOrgIds;
    }

    public void setSelectedOrgIds(Set selectedOrgIds) {
        this.selectedOrgIds = selectedOrgIds;
    }

    public boolean isCanceled() {
        if (this.f7ui == null) {
            return false;
        }
        return this.f7ui.isCancel();
    }

    public Object getData() {
        if (this.f7ui == null) {
            return null;
        }
        Collection selectedOrgs = this.f7ui.getReturnValue();
        if (selectedOrgs == null || selectedOrgs.size() == 0) {
            return null;
        }
        return this.getTypedInfos(selectedOrgs);
    }

    protected String getTypedInfos(Collection selectedOrgs) {
        StringBuilder sb = new StringBuilder();
        if (selectedOrgs == null || selectedOrgs.size() == 0) {
            return null;
        }
        Iterator it = selectedOrgs.iterator();
        int i = 0;
        while (it.hasNext()) {
            if (i != 0) {
                sb.append(";");
            }
            CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)it.next();
            if (this.selectedOrgIds == null) {
                this.selectedOrgIds = new HashSet();
            }
            this.selectedOrgIds.add(info.getId().toString());
            sb.append(info.getName());
            ++i;
        }
        return sb.toString();
    }

    public SelectorItemCollection getSelectorCollection() {
        SelectorItemCollection selectorCollection = new SelectorItemCollection();
        selectorCollection.add(new SelectorItemInfo("id"));
        selectorCollection.add(new SelectorItemInfo("number"));
        selectorCollection.add(new SelectorItemInfo("name"));
        selectorCollection.add(new SelectorItemInfo("code"));
        return selectorCollection;
    }

    public EntityViewInfo getEntityViewExceptTreeFilter() throws BOSException {
        EntityViewInfo result = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        result.setFilter(filter);
        if (this.selectedOrgIds != null && this.selectedOrgIds.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.selectedOrgIds, CompareType.NOTINCLUDE));
        }
        return result;
    }

    public void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.f7ui.setCancel(false);
        this.f7ui.getUIWindow().close();
    }
}

