/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountAndMapAccountCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountAndMapAccountInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.app.AbstractAccountMapControllerBean;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AccountMapControllerBean
extends AbstractAccountMapControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.accountcheck.app.AccountMapControllerBean");

    @Override
    protected void _enableOrDisEnable(Context ctx, List selectList, boolean isEnable) throws BOSException {
        if (selectList == null || selectList.size() < 1) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Update T_Csl_AccountMap set FIsFree=");
        if (isEnable) {
            sql.append("0 \n");
        } else {
            sql.append("1 \n");
        }
        sql.append("where FID in(").append(CslRptUtil.collection2String((Collection)selectList, (String)",", (boolean)true)).append(")");
        DbUtil.execute(ctx, sql.toString());
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("*"));
        AccountMapInfo info = this.getAccountMapInfo(ctx, pk, sc);
        StringBuffer retValue = new StringBuffer();
        if (info.getNumber() != null) {
            retValue.append(info.getNumber()).append("-");
        }
        if (info.getElimType() != null) {
            retValue.append(info.getElimType().toString()).append("-");
        }
        if (info.getRemark() != null) {
            retValue.append(info.getRemark()).append("-");
        }
        retValue.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"AccountMap", (Locale)ContextUtils.getLocaleFromEnv())).append("-");
        if (info.isIsFree()) {
            retValue.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"dienable", (Locale)ContextUtils.getLocaleFromEnv()));
        } else {
            retValue.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"enable", (Locale)ContextUtils.getLocaleFromEnv()));
        }
        return retValue.toString();
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        SorterItemInfo info = new SorterItemInfo("account.isMapAccount");
        info.setSortType(SortType.DESCEND);
        sorterItemCollection.add(info);
        sorterItemCollection.add(new SorterItemInfo("account.seq"));
        return super._getValue(ctx, pk, selector, sorterItemCollection);
    }

    @Override
    protected String _getExistNumber(Context ctx, AccountAndMapAccountCollection accountAndMapAccountCollection, String id, boolean isUnilateralReconciliation, ItemTypeEnum itemType) throws BOSException {
        boolean isFirst;
        SQLBuilder sql = new SQLBuilder();
        if (isUnilateralReconciliation) {
            sql.append("select DISTINCT AccountMap.Fnumber from T_Csl_AccountMap AccountMap \n");
            sql.append("INNER JOIN T_Csl_AccountAndMapAccount AS ACCOUNT ON ACCOUNTMAP.FID = ACCOUNT.FAccountMapId \n");
            sql.append("LEFT OUTER JOIN T_Csl_CheckageAccount AS CHECKACCOUNT ON ACCOUNT.FCheckAccountId = CHECKACCOUNT.FID \n ");
            sql.append("where (");
            isFirst = true;
            for (int i = 0; i < accountAndMapAccountCollection.size(); ++i) {
                CheckageAccountInfo info = accountAndMapAccountCollection.get(i).getCheckAccount();
                if (!isFirst) {
                    sql.append("OR ");
                }
                sql.append(" CHECKACCOUNT.FItemNumber = ?", info.getItemNumber());
                if (ItemTypeEnum.account == itemType) {
                    sql.append(" and CHECKACCOUNT.FBalType = ?", info.getBalType().getValue());
                    sql.append(" and CHECKACCOUNT.FAccountTableid=?", info.getAccountTableid()).append("\n");
                } else {
                    sql.append(" and CHECKACCOUNT.FDataElement=?", info.getDataElement()).append("\n");
                }
                isFirst = false;
            }
            sql.append(")");
            if (id != null) {
                sql.append("AND ACCOUNTMAP.FID <> ?", id);
            }
            sql.append(" AND ACCOUNTMAP.FIsFree = 0");
        } else {
            sql.append("select  DISTINCT AccountMap.Fnumber from T_Csl_AccountMap AccountMap \n");
            sql.append("INNER JOIN T_Csl_AccountAndMapAccount AS ACCOUNT ON ACCOUNTMAP.FID = ACCOUNT.FAccountMapId \n");
            sql.append("INNER JOIN T_Csl_AccountAndMapAccount AS ACCOUNT2 ON ACCOUNTMAP.FID = ACCOUNT2.FAccountMapId \n");
            sql.append("LEFT OUTER JOIN T_Csl_CheckageAccount AS CHECKACCOUNT ON ACCOUNT.FCheckAccountId = CHECKACCOUNT.FID \n ");
            sql.append("LEFT OUTER JOIN T_Csl_CheckageAccount AS CHECKACCOUNT2 ON ACCOUNT2.FCheckAccountId = CHECKACCOUNT2.FID \n");
            sql.append("where (((");
            isFirst = true;
            boolean isFirst2 = true;
            boolean isFirst3 = true;
            String accountTableid = null;
            String accountTableid2 = null;
            SQLBuilder sql2 = new SQLBuilder();
            SQLBuilder sql3 = new SQLBuilder();
            SQLBuilder sql4 = new SQLBuilder();
            sql2.append(" ( ACCOUNTMAP.FIsUnilateralReconciliation=1 and (");
            for (int i = 0; i < accountAndMapAccountCollection.size(); ++i) {
                AccountAndMapAccountInfo accountAndMapAccountInfo = accountAndMapAccountCollection.get(i);
                CheckageAccountInfo checkAccount = accountAndMapAccountInfo.getCheckAccount();
                if (accountAndMapAccountInfo.isIsMapAccount()) {
                    accountTableid = checkAccount.getAccountTableid();
                    if (!isFirst) {
                        sql3.append("OR ");
                    }
                    sql3.append(" CHECKACCOUNT.Fid = ?", checkAccount.getId().toString()).append("\n");
                    isFirst = false;
                } else {
                    accountTableid2 = checkAccount.getAccountTableid();
                    if (!isFirst2) {
                        sql4.append("OR ");
                    }
                    sql4.append(" CHECKACCOUNT2.Fid = ?", checkAccount.getId().toString()).append("\n");
                    isFirst2 = false;
                }
                if (!isFirst3) {
                    sql2.append("OR ");
                }
                sql2.append(" CHECKACCOUNT.Fid = ?", checkAccount.getId().toString()).append("\n");
                isFirst3 = false;
            }
            sql.append(sql3.toString());
            sql.getParamList().addAll(sql3.getParamList());
            sql.append(" OR ");
            sql.append(sql4.toString());
            sql.getParamList().addAll(sql4.getParamList());
            sql.append(" ) and  ACCOUNT.FAccountMapId = ACCOUNT2.FAccountMapId and ACCOUNTMAP.FIsUnilateralReconciliation=0 and CHECKACCOUNT.FID <> CHECKACCOUNT2.FID   and ACCOUNT.FISMAPACCOUNT <> ACCOUNT2.FISMAPACCOUNT ");
            if (ItemTypeEnum.account == itemType && accountTableid != null && accountTableid2 != null) {
                sql.append("and (CHECKACCOUNT.FAccountTableid =?", accountTableid).append(" and CHECKACCOUNT2.FAccountTableid =?", accountTableid2).append(" or CHECKACCOUNT.FAccountTableid =?", accountTableid2).append(" and CHECKACCOUNT2.FAccountTableid =?", accountTableid).append(")");
            }
            sql.append(") OR ");
            sql.append(sql2.toString());
            sql.getParamList().addAll(sql2.getParamList());
            sql.append(")))");
            if (id != null) {
                sql.append(" AND ACCOUNTMAP.FID <> ?", id);
            }
            sql.append(" AND ACCOUNTMAP.FIsFree = 0");
        }
        IRowSet rowSet = null;
        String number = null;
        try {
            rowSet = DbUtil.executeQuery(ctx, sql.toString(), sql.getParams());
            if (rowSet != null && rowSet.next()) {
                number = rowSet.getString(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"DbUtil.executeQuery", (Throwable)e);
        }
        return number;
    }

    @Override
    protected Map _removeOfNoQuote(Context ctx, List selectIdList) throws BOSException {
        String lan = ctx.getLocale().getLanguage();
        SQLBuilder sql = new SQLBuilder();
        sql.append(" SELECT DISTINCT AccountMap.fid amId,AccountMap.Fnumber amNum,CheckageBillHead.fnumber hNum,CheckageBill.FYear year,CheckageBill.FPeriod period,own.FName_" + lan + " ownName,tar.FName_" + lan + " tarName,cur.FName_" + lan + " curName \r\n");
        sql.append(" FROM T_Csl_AccountMap AccountMap \r\n");
        sql.append(" INNER JOIN T_Csl_CheckageBillHead AS CheckageBillHead ON ACCOUNTMAP.FID = CheckageBillHead.FAccountMapId    \r\n");
        sql.append(" INNER JOIN T_Csl_CheckageBill AS CheckageBill ON CheckageBill.FBillHeadId = CheckageBillHead.FID     \r\n");
        sql.append(" INNER JOIN T_Org_BaseUnit own On own.fid = CheckageBill.FCompanyId \r\n");
        sql.append(" INNER JOIN T_Org_BaseUnit tar On tar.fid = CheckageBill.FTargetCompanyId \r\n");
        sql.append(" INNER JOIN T_Bd_Currency cur On cur.fid = CheckageBill.FCurrencyId \r\n");
        sql.append(" WHERE  AccountMap.fid in ", selectIdList);
        sql.append(" ORDER BY CheckageBill.FYear,CheckageBill.FPeriod,own.FName_" + lan + ",cur.FName_" + lan + ", CheckageBillHead.fnumber");
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), sql.getParams());
        HashMap resultMap = new HashMap();
        ArrayList<String> noRemoveIDList = new ArrayList<String>();
        if (rowSet != null) {
            String yearLabel = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"555_year", (Locale)ctx.getOriginLocale());
            String periodLabel = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"556_period", (Locale)ctx.getOriginLocale());
            String wkLabel = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"CheckWorkTable", (Locale)ctx.getOriginLocale());
            try {
                StringBuffer msg = null;
                String key = null;
                HashMap<String, StringBuffer> sames = null;
                HashMap sameMap = new HashMap();
                while (rowSet.next()) {
                    String headNum = rowSet.getString("hNum");
                    String amNum = rowSet.getString("amNum");
                    String year = rowSet.getString("year");
                    String period = rowSet.getString("period");
                    String ownName = rowSet.getString("ownName");
                    String tarName = rowSet.getString("tarName");
                    String curName = rowSet.getString("curName");
                    key = ownName + tarName + curName + year + period;
                    if (!noRemoveIDList.contains(rowSet.getString("amId"))) {
                        noRemoveIDList.add(rowSet.getString("amId"));
                    }
                    if (sameMap.get(amNum) != null) {
                        if (((Map)sameMap.get(amNum)).containsKey(key)) {
                            ((StringBuffer)((Map)sameMap.get(amNum)).get(key)).append(wkLabel).append(headNum).append("\n");
                            continue;
                        }
                        msg = new StringBuffer();
                        msg.append("[").append(ownName).append("-").append(tarName).append("-").append(curName).append("-");
                        msg.append(year).append(yearLabel).append(period).append(periodLabel);
                        msg.append("]").append("\uff1a\n");
                        msg.append(wkLabel).append(headNum).append("\n");
                        ((Map)sameMap.get(amNum)).put(key, msg);
                        continue;
                    }
                    sames = new HashMap<String, StringBuffer>();
                    msg = new StringBuffer();
                    msg.append("[").append(ownName).append("-").append(tarName).append("-").append(curName).append("-");
                    msg.append(year).append(yearLabel).append(period).append(periodLabel);
                    msg.append("]").append("\uff1a\n");
                    msg.append(wkLabel).append(headNum).append("\n");
                    sames.put(key, msg);
                    sameMap.put(amNum, sames);
                }
                if (!sameMap.isEmpty()) {
                    ArrayList<String> msgList = null;
                    Iterator it = sameMap.keySet().iterator();
                    while (it.hasNext()) {
                        msgList = new ArrayList<String>();
                        String amNum = (String)it.next();
                        Map msgMap = (Map)sameMap.get(amNum);
                        for (StringBuffer msgBuffer : msgMap.values()) {
                            msgList.add(msgBuffer.toString());
                        }
                        Collections.sort(msgList);
                        resultMap.put(amNum, msgList);
                    }
                }
            }
            catch (SQLException e) {
                logger.error((Object)"removeOfNoSystem()", (Throwable)e);
            }
        }
        resultMap.put("noRemoveIDList", noRemoveIDList);
        return resultMap;
    }

    @Override
    protected ArrayList _getBillNumber(Context ctx, String id) throws BOSException {
        String lan = ctx.getLocale().getLanguage();
        SQLBuilder sql = new SQLBuilder();
        sql.append("SELECT DISTINCT CheckageBillHead.FNumber hNum,CheckageBill.FYear year,CheckageBill.FPeriod period,cur.fname_" + lan + " curName,own.fname_" + lan + " ownName,tar.fname_" + lan + " tarName FROM T_Csl_CheckageBillHead CheckageBillHead \r\n");
        sql.append("INNER JOIN T_Csl_CheckageBill AS CheckageBill ON CheckageBill.FBillHeadId = CheckageBillHead.FID    \r\n");
        sql.append("INNER JOIN T_Csl_CheckageBill AS CheckageBill2 ON CheckageBill2.FBillHeadId = CheckageBill.FBillHeadId     \r\n");
        sql.append("INNER JOIN T_Csl_CheckageBillCompany AS CheckageBillCompany ON CheckageBillCompany.FID=CheckageBill.FBillCompanyId     \r\n");
        sql.append("INNER JOIN T_Csl_CheckageBillCompany AS CheckageBillCompany2 ON CheckageBillCompany2.FID=CheckageBill2.FBillCompanyId     \r\n");
        sql.append("INNER JOIN T_Org_BaseUnit own On own.fid = CheckageBill.FCompanyId \r\n");
        sql.append("INNER JOIN T_Org_BaseUnit tar On tar.fid = CheckageBill.FTargetCompanyId \r\n");
        sql.append("INNER JOIN T_Bd_Currency cur On cur.fid = CheckageBill.FCurrencyId \r\n");
        sql.append("WHERE CheckageBillHead.FAccountMapId= ? \r\n", id);
        sql.append("AND CheckageBill.fid <> CheckageBill2.fid and CheckageBill.FCompanyId <> CheckageBill2.FCompanyId \r\n");
        sql.append("AND ((CheckageBillCompany.FConfirmStatus=0 and CheckageBillCompany2.FConfirmStatus=1) or (CheckageBillCompany.FConfirmStatus=1 and CheckageBillCompany2.FConfirmStatus=0)) \r\n");
        sql.append("ORDER BY own.fname_" + lan + ",cur.fname_" + lan + ",CheckageBill.FYear,CheckageBill.FPeriod,CheckageBillHead.FNumber ");
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), sql.getParams());
        ArrayList<String> billNumberList = new ArrayList<String>();
        ArrayList<String> msgList = new ArrayList<String>();
        String yearLabel = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"555_year", (Locale)ctx.getOriginLocale());
        String periodLabel = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"556_period", (Locale)ctx.getOriginLocale());
        String wkLabel = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"CheckWorkTable", (Locale)ctx.getOriginLocale());
        if (rowSet != null) {
            StringBuffer msg = null;
            String key = null;
            HashMap<String, StringBuffer> sames = new HashMap<String, StringBuffer>();
            try {
                while (rowSet.next()) {
                    String headNumber = rowSet.getString("hNum");
                    msg = new StringBuffer();
                    if (billNumberList.contains(headNumber)) continue;
                    String year = rowSet.getString("year");
                    String period = rowSet.getString("period");
                    String curName = rowSet.getString("curName");
                    String ownName = rowSet.getString("ownName");
                    String tarName = rowSet.getString("tarName");
                    key = ownName + tarName + curName + year + period;
                    if (sames.containsKey(key)) {
                        msg = (StringBuffer)sames.get(key);
                        msg.append(wkLabel).append(headNumber).append("\n");
                    } else {
                        msg.append("[").append(ownName).append("-").append(tarName).append("-").append(curName).append("-");
                        msg.append(year).append(yearLabel).append(period).append(periodLabel);
                        msg.append("]").append("\uff1a\n");
                        msg.append(wkLabel).append(headNumber).append("\n");
                        sames.put(key, msg);
                    }
                    billNumberList.add(headNumber);
                }
                if (!sames.isEmpty()) {
                    for (StringBuffer value : sames.values()) {
                        msgList.add(value.toString());
                    }
                }
            }
            catch (SQLException e) {
                logger.error((Object)"removeOfNoSystem()", (Throwable)e);
            }
        }
        SQLBuilder sql2 = new SQLBuilder();
        sql2.append("SELECT DISTINCT CheckageBillHead.FNumber hNum,CheckageBill.FYear year,CheckageBill.FPeriod period,cur.FName_" + lan + " curName,own.FName_" + lan + " ownName,tar.FName_" + lan + " tarName, max(CheckageBillCompany.FConfirmStatus) ,  max (CheckageBillHead.FAccountMapId)  FROM T_Csl_CheckageBillHead CheckageBillHead  \r\n");
        sql2.append("INNER JOIN T_Csl_CheckageBill AS CheckageBill ON CheckageBill.FBillHeadId = CheckageBillHead.FID \r\n");
        sql2.append("INNER JOIN T_Csl_CheckageBillCompany AS CheckageBillCompany ON CheckageBillCompany.FID=CheckageBill.FBillCompanyId \r\n");
        sql2.append("INNER JOIN T_Org_BaseUnit own On own.fid = CheckageBill.FCompanyId \r\n");
        sql2.append("INNER JOIN T_Org_BaseUnit tar On tar.fid = CheckageBill.FTargetCompanyId \r\n");
        sql2.append("INNER JOIN T_Bd_Currency cur On cur.fid = CheckageBill.FCurrencyId \r\n");
        sql2.append("GROUP BY CheckageBill.FYear,CheckageBill.FPeriod,cur.FName_" + lan + ",own.FName_" + lan + ",tar.FName_" + lan + ",CheckageBillHead.FNumber Having count(CheckageBillHead.FNumber)=1      \r\n");
        sql2.append("AND max(CheckageBillCompany.FConfirmStatus)=0     \r\n");
        sql2.append("AND  max (CheckageBillHead.FAccountMapId)= ? \r\n", id);
        sql2.append("ORDER BY own.FName_" + lan + ",cur.FName_" + lan + ",CheckageBill.FYear,CheckageBill.FPeriod,CheckageBillHead.FNumber ");
        IRowSet rowSet2 = DbUtil.executeQuery(ctx, sql2.toString(), sql2.getParams());
        if (rowSet2 != null) {
            StringBuffer msg = null;
            String key = null;
            HashMap<String, StringBuffer> sames = new HashMap<String, StringBuffer>();
            try {
                while (rowSet2.next()) {
                    String headNumber = rowSet2.getString("hNum");
                    msg = new StringBuffer();
                    if (billNumberList.contains(headNumber)) continue;
                    String year = rowSet2.getString("year");
                    String period = rowSet2.getString("period");
                    String curName = rowSet2.getString("curName");
                    String ownName = rowSet2.getString("ownName");
                    String tarName = rowSet2.getString("tarName");
                    key = ownName + tarName + curName + year + period;
                    if (sames.containsKey(key)) {
                        msg = (StringBuffer)sames.get(key);
                        msg.append(wkLabel).append(headNumber).append("\n");
                    } else {
                        msg.append("[").append(ownName).append("-").append(tarName).append("-").append(curName).append("-");
                        msg.append(year).append(yearLabel).append(period).append(periodLabel);
                        msg.append("]").append("\uff1a\n");
                        msg.append(wkLabel).append(headNumber).append("\n");
                        sames.put(key, msg);
                    }
                    billNumberList.add(headNumber);
                }
                if (!sames.isEmpty()) {
                    for (StringBuffer value : sames.values()) {
                        msgList.add(value.toString());
                    }
                }
            }
            catch (SQLException e) {
                logger.error((Object)"removeOfNoSystem()", (Throwable)e);
            }
        }
        Collections.sort(msgList);
        return msgList;
    }

    @Override
    protected Map _getUnEnableNumber(Context ctx, String id, ItemTypeEnum itemType) throws BOSException {
        BOSUuid uuid = BOSUuid.read((String)id);
        ObjectUuidPK pk = new ObjectUuidPK(uuid);
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("isUnilateralReconciliation"));
        sc.add(new SelectorItemInfo("account.*"));
        AccountMapInfo info = null;
        try {
            info = this.getAccountMapInfo(ctx, (IObjectPK)pk, sc);
        }
        catch (EASBizException e) {
            logger.error((Object)"_getUnEnableNumber", (Throwable)e);
        }
        if (info != null) {
            AccountAndMapAccountCollection accountAndMapAccountCollection = info.getAccount();
            this.getExistNumber(ctx, accountAndMapAccountCollection, id, info.isIsUnilateralReconciliation(), itemType);
        }
        return null;
    }
}

