/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapDispenseCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapDispenseFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapDispenseInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.IAccountMap;
import com.kingdee.eas.fi.newrpt.accountcheck.app.AbstractAccountMapDispenseControllerBean;
import com.kingdee.eas.framework.IObjectBase;
import com.kingdee.eas.framework.ObjectBaseCollection;
import com.kingdee.eas.framework.ObjectBaseInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccountMapDispenseControllerBean
extends AbstractAccountMapDispenseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.accountcheck.app.AccountMapDispenseControllerBean");

    @Override
    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        this.writeUndispenseLog(ctx, arrayPK);
        super._delete(ctx, arrayPK);
    }

    protected IObjectPK[] _submitBatchData(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        IObjectPK[] pks = super._submitBatchData(ctx, colls);
        this.writeDispenseLog(ctx, colls);
        return pks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeUndispenseLog(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        if (arrayPK != null) {
            HashSet<String> ids = new HashSet<String>();
            for (IObjectPK pk : arrayPK) {
                ids.add(pk.toString());
            }
            ParamTempTblService srv = null;
            try {
                StringBuffer idInStrs = new StringBuffer();
                if (arrayPK.length > 100) {
                    TableInfo table = new TableInfo("T_TMPL_DISIDS");
                    table.addColumn("ID");
                    srv = new ParamTempTblService(ctx, table, ids, null);
                    idInStrs.append(" select id from ").append(srv.getParamsSql());
                } else {
                    idInStrs.append(CslRptUtil.collection2String(ids, (String)",", (boolean)true));
                }
                AccountMapDispenseCollection colls = AccountMapDispenseFactory.getLocalInstance(ctx).getAccountMapDispenseCollection("select id,checkageCompany.company.number,checkageCompany.company.name,accountMap.itemType,accountMap.number where id in(" + idInStrs.toString() + ")");
                IAccountMap iAccountMap = AccountMapFactory.getLocalInstance(ctx);
                for (int i = 0; i < colls.size(); ++i) {
                    iAccountMap.undispense_log(colls.get(i));
                }
            }
            finally {
                if (srv != null) {
                    srv.release();
                }
            }
        }
    }

    protected void writeDispenseLog(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        HashSet<String> checkageCompanyIds = new HashSet<String>();
        HashSet<String> accountMapIds = new HashSet<String>();
        for (int i = 0; i < colls.size(); ++i) {
            AccountMapDispenseInfo dispInfo = (AccountMapDispenseInfo)colls.getObject(i);
            checkageCompanyIds.add(dispInfo.getCheckageCompany().getId().toString());
            accountMapIds.add(dispInfo.getAccountMap().getId().toString());
        }
        Map<String, ObjectBaseInfo> companyMap = this.getObjectInfoMap(ctx, checkageCompanyIds, "id,company.number,company.name", CheckageCompanyFactory.getLocalInstance(ctx));
        Map<String, ObjectBaseInfo> accountMapMap = this.getObjectInfoMap(ctx, accountMapIds, "id,number,itemType", AccountMapFactory.getLocalInstance(ctx));
        IAccountMap iAccountMap = AccountMapFactory.getLocalInstance(ctx);
        for (int i = 0; i < colls.size(); ++i) {
            AccountMapDispenseInfo dispInfo = (AccountMapDispenseInfo)colls.getObject(i);
            String companyId = dispInfo.getCheckageCompany().getId().toString();
            dispInfo.setCheckageCompany((CheckageCompanyInfo)companyMap.get(companyId));
            String accountMapId = dispInfo.getAccountMap().getId().toString();
            dispInfo.setAccountMap((AccountMapInfo)accountMapMap.get(accountMapId));
            iAccountMap.dispense_log(dispInfo);
        }
    }

    protected Map<String, ObjectBaseInfo> getObjectInfoMap(Context ctx, Set<String> objIds, String selectStr, IObjectBase iObjectBase) throws BOSException, EASBizException {
        int batchSize = 200;
        HashSet<String> ids = new HashSet<String>();
        HashMap<String, ObjectBaseInfo> objMap = new HashMap<String, ObjectBaseInfo>();
        for (String checkageCompanyId : objIds) {
            ids.add(checkageCompanyId);
            if (ids.size() < batchSize) continue;
            ObjectBaseCollection colls = iObjectBase.getObjectBaseCollection("select " + selectStr + " where id in(" + CslRptUtil.collection2String(ids, (String)",", (boolean)true) + ")");
            for (int i = 0; i < colls.size(); ++i) {
                ObjectBaseInfo tmpInfo = colls.get(i);
                objMap.put(tmpInfo.getId().toString(), tmpInfo);
            }
            ids.clear();
        }
        if (!ids.isEmpty()) {
            ObjectBaseCollection colls = iObjectBase.getObjectBaseCollection("select " + selectStr + " where id in(" + CslRptUtil.collection2String(ids, (String)",", (boolean)true) + ")");
            for (int i = 0; i < colls.size(); ++i) {
                ObjectBaseInfo tmpInfo = colls.get(i);
                objMap.put(tmpInfo.getId().toString(), tmpInfo);
            }
        }
        return objMap;
    }
}

