/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmDetailLogCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmDetailLogInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckStatusEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckTaskEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.app.AbstractAutoCheckSchmDetailLogControllerBean;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class AutoCheckSchmDetailLogControllerBean
extends AbstractAutoCheckSchmDetailLogControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.accountcheck.app.AutoCheckSchmDetailLogControllerBean");

    @Override
    protected AutoCheckSchmDetailLogCollection _getAutoCheckSchmDetailLogCol(Context ctx, String schmLogId, String orgUnitId) throws BOSException, EASBizException {
        String language = ctx.getLocale().getLanguage();
        AutoCheckSchmDetailLogCollection col = new AutoCheckSchmDetailLogCollection();
        SQLBuilder sql = new SQLBuilder();
        sql.append("select detailLog.fid,detailLog.FOrgUnitId,detailLog.FAutoExecStep,detailLog.FExecStatus,detailLog.FFailDetail, \n");
        sql.append("unit.fname_").append(language).append(" unitName from T_Csl_AutoCheckSchmDetailLog detailLog \n");
        sql.append("inner join t_org_baseunit unit on unit.fid=detailLog.FOrgUnitId \n");
        sql.append("where detailLog.fschmLogId=? \n", schmLogId);
        if (!StringUtils.isEmpty((String)orgUnitId)) {
            sql.append("and detailLog.forgUnitId=? \n", orgUnitId);
        }
        sql.append("order by detailLog.forgUnitId,detailLog.FAutoExecStep");
        try {
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            if (rowSet != null && rowSet.size() > 0) {
                while (rowSet.next()) {
                    AutoCheckSchmDetailLogInfo info = new AutoCheckSchmDetailLogInfo();
                    info.setSchmLogId(schmLogId);
                    info.setOrgUnitId(rowSet.getString("FOrgUnitId"));
                    info.put("orgName", rowSet.getString("unitName"));
                    info.setAutoExecStep(AutoCheckTaskEnum.getEnum(rowSet.getInt("FAutoExecStep")));
                    info.setExecStatus(AutoCheckStatusEnum.getEnum(rowSet.getInt("FExecStatus")));
                    info.setFailDetail(rowSet.getString("FFailDetail").getBytes("UTF-8"));
                    info.setId(BOSUuid.read((String)rowSet.getString("fid")));
                    col.add(info);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"_getAutoCheckSchmDetailLogCol error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return col;
    }
}

