/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckFacadeFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmLogCondition;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmLogInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmLogUIInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckStatusEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.app.AbstractAutoCheckSchmLogControllerBean;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AutoCheckSchmLogControllerBean
extends AbstractAutoCheckSchmLogControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.accountcheck.app.AutoCheckSchmLogControllerBean");

    @Override
    protected AutoCheckSchmLogInfo _getLastValue(Context ctx, String schmId) throws BOSException, EASBizException {
        AutoCheckSchmLogInfo autoCheckSchmLogInfo = new AutoCheckSchmLogInfo();
        SQLBuilder sql = new SQLBuilder();
        sql.append("select top 1 schmLog.Fid schmLogId,schmLog.FSchmId schmId,schmLog.FCurrencyId currencyId,schmLog.FPeriodType periodType,schmLog.FYear year,  \n");
        sql.append("schmLog.FPeriod period,currency.Fnumber currencyNumber,currency.Fname_" + ctx.getLocale().getLanguage() + " currencyName,currency.Fprecision currencyPrecision  \n");
        sql.append("from T_Csl_AutoCheckSchmLog schmLog  \n");
        sql.append("inner join T_Csl_AutoCheckSchm schm on schm.fid=schmLog.FSchmId \n");
        sql.append("inner join T_BD_Currency currency on currency.fid=schmLog.FCurrencyId \n");
        sql.append("where schmLog.FSchmId=? \n", schmId);
        sql.append("order by schmLog.flastUpdatetime desc");
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        if (rowSet != null && rowSet.size() > 0) {
            try {
                rowSet.next();
                CurrencyInfo currencyInfo = new CurrencyInfo();
                currencyInfo.setId(BOSUuid.read((String)rowSet.getString("currencyId")));
                currencyInfo.setNumber(rowSet.getString("currencyNumber"));
                currencyInfo.setName(rowSet.getString("currencyName"));
                currencyInfo.setPrecision(rowSet.getInt("currencyPrecision"));
                autoCheckSchmLogInfo.setId(BOSUuid.read((String)rowSet.getString("schmLogId")));
                autoCheckSchmLogInfo.setSchmId(rowSet.getString("schmId"));
                autoCheckSchmLogInfo.setCurrency(currencyInfo);
                autoCheckSchmLogInfo.setPeriodType(RptPeriodTypeEnum.getEnum((int)rowSet.getInt("periodType")));
                autoCheckSchmLogInfo.setYear(rowSet.getInt("year"));
                autoCheckSchmLogInfo.setPeriod(rowSet.getInt("period"));
            }
            catch (SQLException e) {
                logger.error((Object)"_getLastValue", (Throwable)e);
            }
        } else {
            return null;
        }
        return autoCheckSchmLogInfo;
    }

    @Override
    protected Map _batchDeleteElim(Context ctx, String schmId, List schmUnitLogIds) throws BOSException {
        try {
            Set<String>[] elims = this.getElims(ctx, schmId, schmUnitLogIds);
            if (elims != null) {
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                Set<String> auditedNums = elims[0];
                resultMap.put("auditedNums", auditedNums);
                Set<String> elimIds = elims[1];
                this.checkIsExistConvtElim(ctx, elimIds, resultMap);
                if (!elimIds.isEmpty()) {
                    ArrayList<String> ids = new ArrayList<String>();
                    ids.addAll(elimIds);
                    EliminationFactory.getLocalInstance((Context)ctx).removeBatch(ids);
                    resultMap.put("successCount", ids.size());
                }
                HashMap<String, Object> hashMap = resultMap;
                return hashMap;
            }
        }
        catch (Exception e) {
            logger.error((Object)"_batchUnAudit error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    protected void checkIsExistConvtElim(Context ctx, Set<String> elimIds, Map<String, Object> resultMap) throws Exception {
        if (elimIds != null && !elimIds.isEmpty()) {
            SQLBuilder sql = new SQLBuilder();
            sql.append(" select distinct after.fid afterId,before.fid beforeId,before.fnumber ");
            sql.append(" from t_csl_elimination after ");
            sql.append(" inner join t_csl_elimination before on before.fid=after.fconvertBeforeid ");
            sql.append(" where before.fid in ", elimIds);
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            HashMap<String, String> existConvtIds = new HashMap<String, String>();
            HashSet<String> existNums = new HashSet<String>();
            while (rowSet != null && rowSet.next()) {
                String beforeId = rowSet.getString("beforeId");
                String afterId = rowSet.getString("afterId");
                String fnumber = rowSet.getString("fnumber");
                existConvtIds.put(beforeId, afterId);
                existNums.add(fnumber);
            }
            elimIds.removeAll(existConvtIds.keySet());
            resultMap.put("existConvtIds", existConvtIds);
            resultMap.put("existNums", existNums);
        }
    }

    protected Set<String>[] getElims(Context ctx, String schmId, List schmUnitLogIds) throws Exception {
        Object[] Objects = this.getCommFilters(ctx, schmUnitLogIds);
        if (Objects != null) {
            int year = (Integer)Objects[0];
            int period = (Integer)Objects[1];
            int periodType = (Integer)Objects[2];
            String currencyId = (String)Objects[3];
            SQLBuilder sql = new SQLBuilder();
            sql.append("select distinct elim.fid,elim.fnumber,elim.fcheckedstatus ");
            sql.append(" from t_csl_elimination elim ");
            sql.append(" inner join t_csl_eliminationentry elimEntry on elimEntry.feliminationid=elim.fid ");
            sql.append(" inner join T_Csl_CheckageBillRelatElim relat on elimEntry.fid=relat.FElimEntryId ");
            sql.append(" inner join T_Csl_CheckageBill bill on relat.FCheckageBillId=bill.fid ");
            sql.append(" inner join T_Csl_CheckageBillHead billhead on bill.FBillHeadId=billhead.fid ");
            sql.append(" inner join T_Csl_AutoCheckSchmUnitLog log on (log.FOwnCompanyId=bill.fcompanyid and log.FTargetCompanyId=bill.FTargetCompanyId ");
            sql.append(" or log.FOwnCompanyId=bill.FTargetCompanyId and log.FTargetCompanyId=bill.fcompanyid) and (log.FDiffMode=billhead.FDiffMode or log.FDiffMode is null) ");
            sql.append(" where log.fid in ", schmUnitLogIds);
            sql.append(" and bill.fyear=?", year);
            sql.append(" and bill.FCurrencyId=?", currencyId);
            if (3 != periodType) {
                RptPeriodTypeEnum rptPeriodType = RptPeriodTypeEnum.getEnum((int)periodType);
                int[] yearPeriod = RPTDateUtil.getPeriod((Date)RPTDateUtil.getPeriodFirstDate((int)year, (int)period, (RptPeriodTypeEnum)rptPeriodType), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
                int[] lastYearPeriod = RPTDateUtil.getPeriod((Date)RPTDateUtil.getPeriodLastDate((int)year, (int)period, (RptPeriodTypeEnum)rptPeriodType), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
                int lastPeriod = lastYearPeriod[1];
                if (lastPeriod == 12) {
                    ++lastPeriod;
                }
                sql.append("  and bill.fperiod>=? ", yearPeriod[1]);
                sql.append("  and bill.fperiod<=? ", lastPeriod);
            } else {
                sql.append("  and bill.fperiod=? ", period);
            }
            sql.append(" and relat.FCreateElimSchmId=?", schmId);
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            HashSet<String> auditedNums = new HashSet<String>();
            HashSet<String> elimIds = new HashSet<String>();
            while (rowSet != null && rowSet.next()) {
                if (2 == rowSet.getInt("fcheckedstatus")) {
                    auditedNums.add(rowSet.getString("fnumber"));
                    continue;
                }
                elimIds.add(rowSet.getString("fid"));
            }
            return new Set[]{auditedNums, elimIds};
        }
        return null;
    }

    @Override
    protected Map _batchUnAudit(Context ctx, String schmId, List schmUnitLogIds) throws BOSException {
        String tmpTable = null;
        try {
            if (schmUnitLogIds != null && !schmUnitLogIds.isEmpty()) {
                tmpTable = this.getBillHeadIdsTmpTable(ctx, schmId, schmUnitLogIds);
                String msg = this.checkBillsForCreateElimOrAudited(ctx, tmpTable);
                int updateCount = this.unAudit(ctx, tmpTable);
                HashMap<String, Object> result = new HashMap<String, Object>();
                if (!StringUtils.isEmpty((String)msg)) {
                    result.put("msg", msg);
                }
                if (updateCount > 0) {
                    result.put("updateCount", updateCount);
                }
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
        }
        catch (Exception e) {
            logger.error((Object)"_batchUnAudit error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (!DebugLogger.isDebug && !StringUtils.isEmpty(tmpTable)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tmpTable);
            }
        }
        return null;
    }

    protected int unAudit(Context ctx, String tmpTable) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append("update T_Csl_CheckageBillHead set FAuditedStatus=?", 1);
        sql.append(",FAuditorId=?", (Object)null);
        sql.append(",FAuditedTime=?", (Object)null);
        sql.append(" where fid in(select distinct tmp.fid from ").append(tmpTable).append(" tmp ");
        sql.append("             where not exists(select 1 from T_Csl_CheckageBillRelatElim rela ");
        sql.append("             inner join T_Csl_CheckageBill bill on rela.FCheckageBillId = bill.fid ");
        sql.append("             where  bill.FBillHeadId = tmp.fid )) ");
        sql.append(" and FAuditedStatus=? ", 2);
        int size = DbUtil.executeUpdate(ctx, sql.getSQL(), sql.getParams());
        return size;
    }

    public String checkBillsForCreateElimOrAudited(Context ctx, String tmpTable) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append(" select distinct head.fnumber,elim.fperiodType,head.FAuditedStatus,tree.fname_").append(ctx.getLocale()).append(" treeName ");
        sql.append(" from T_Csl_CheckageBillHead head ");
        sql.append(" inner join T_Csl_CheckageBill bill on bill.FBillHeadId=head.fid ");
        sql.append(" inner join ").append(tmpTable).append(" tmp on tmp.fid=head.fid ");
        sql.append(" left join T_Csl_CheckageBillRelatElim relat on relat.FCheckageBillId=bill.fid ");
        sql.append(" left join t_csl_eliminationentry elimEntry on elimEntry.fid=relat.FElimEntryId ");
        sql.append(" left join t_csl_elimination elim on elim.fid=elimEntry.feliminationid ");
        sql.append(" left join t_org_tree tree on tree.fid=elim.forgBoundid ");
        sql.append(" where relat.fid is not null or head.FAuditedStatus=?", 1);
        MessageFormat createElimMsg = null;
        MessageFormat auditMsg = null;
        StringBuffer msg = new StringBuffer();
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        while (rowSet != null && rowSet.next()) {
            if (rowSet.getInt("FAuditedStatus") == 1) {
                if (auditMsg == null) {
                    auditMsg = new MessageFormat(AccountCheckUtil.getResourceString(ctx, "120unAuditNoNeedUnAudit", null));
                }
                msg.append(auditMsg.format(new Object[]{rowSet.getString("fnumber")})).append("\n");
                continue;
            }
            if (createElimMsg == null) {
                createElimMsg = new MessageFormat(AccountCheckUtil.getResourceString(ctx, "117linkElimCantUnAudit", null));
            }
            if (rowSet.getInt("fperiodType") <= 0) continue;
            msg.append(createElimMsg.format(new Object[]{rowSet.getString("fnumber"), rowSet.getString("treeName"), RptPeriodTypeEnum.getEnum((int)rowSet.getInt("fperiodType")).getAlias()})).append("\n");
        }
        return msg.toString();
    }

    public Object[] getCommFilters(Context ctx, List schmUnitLogIds) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append("select distinct log.FCurrencyId,log.FPeriodType,log.FYear,log.FPeriod from T_Csl_AutoCheckSchmLog log ");
        sql.append(" inner join T_Csl_AutoCheckSchmUnitLog unitlog on unitlog.FSchmLogId=log.fid ");
        sql.append(" where unitlog.fid=? ", schmUnitLogIds.get(0));
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        if (rowSet != null && rowSet.next()) {
            int year = rowSet.getInt("FYear");
            int period = rowSet.getInt("FPeriod");
            int periodType = rowSet.getInt("FPeriodType");
            String currencyId = rowSet.getString("FCurrencyId");
            return new Object[]{year, period, periodType, currencyId};
        }
        return null;
    }

    public String getBillHeadIdsTmpTable(Context ctx, String schmId, List schmUnitLogIds) throws Exception {
        TempTablePool tmpTablePool = TempTablePool.getInstance((Context)ctx);
        String tmpTable = tmpTablePool.createTempTable("create table t_csl_BillHead(fid varchar(44))");
        Object[] Objects = this.getCommFilters(ctx, schmUnitLogIds);
        if (Objects != null) {
            int year = (Integer)Objects[0];
            int period = (Integer)Objects[1];
            int periodType = (Integer)Objects[2];
            String currencyId = (String)Objects[3];
            SQLBuilder sql = new SQLBuilder();
            sql.append("insert into ").append(tmpTable).append("(fid)");
            sql.append(" select billhead.fid from T_Csl_CheckageBillHead billhead ");
            sql.append(" inner join T_Csl_CheckageBill bill on bill.FBillHeadId=billhead.fid ");
            sql.append(" inner join T_Csl_AutoCheckSchmUnitLog log on (log.FOwnCompanyId=bill.fcompanyid and log.FTargetCompanyId=bill.FTargetCompanyId ");
            sql.append(" or log.FOwnCompanyId=bill.FTargetCompanyId and log.FTargetCompanyId=bill.fcompanyid)  ");
            sql.append(" and (log.FDiffMode is null or log.FDiffMode is not null and log.FDiffMode=billhead.FDiffMode) ");
            sql.append(" where log.fid in ", schmUnitLogIds);
            sql.append(" and bill.fyear=?", year);
            sql.append(" and bill.FCurrencyId=?", currencyId);
            if (3 != periodType) {
                RptPeriodTypeEnum rptPeriodType = RptPeriodTypeEnum.getEnum((int)periodType);
                int[] yearPeriod = RPTDateUtil.getPeriod((Date)RPTDateUtil.getPeriodFirstDate((int)year, (int)period, (RptPeriodTypeEnum)rptPeriodType), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
                int[] lastYearPeriod = RPTDateUtil.getPeriod((Date)RPTDateUtil.getPeriodLastDate((int)year, (int)period, (RptPeriodTypeEnum)rptPeriodType), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
                int lastPeriod = lastYearPeriod[1];
                if (lastPeriod == 12) {
                    ++lastPeriod;
                }
                sql.append("  and bill.fperiod>=? ", yearPeriod[1]);
                sql.append("  and bill.fperiod<=? ", lastPeriod);
            } else {
                sql.append("  and bill.fperiod=? ", period);
            }
            sql.append(" and billhead.FAuditSchmId=?", schmId);
            DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
        }
        return tmpTable;
    }

    private int[] getPeiodsByPeriodType(RptPeriodTypeEnum periodType, int period, boolean isIncludAdjustPeriod) {
        int[] periods = null;
        periods = periodType.equals((Object)RptPeriodTypeEnum.QUARTERLY) ? this.getQuarterPeriods(period, isIncludAdjustPeriod) : (periodType.equals((Object)RptPeriodTypeEnum.SEMIYEARLY) ? this.getSemiYearPeriods(period, isIncludAdjustPeriod) : (periodType.equals((Object)RptPeriodTypeEnum.YEARLY) ? this.getFullYearPeriod(isIncludAdjustPeriod) : (period == 12 && isIncludAdjustPeriod ? new int[]{12, 13} : new int[]{period})));
        return periods;
    }

    private int[] getFullYearPeriod(boolean isIncludAdjustPeriod) {
        int[] periods = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
        if (isIncludAdjustPeriod) {
            periods[12] = 13;
        }
        return periods;
    }

    private int[] getQuarterPeriods(int period, boolean isIncludAdjustPeriod) {
        int[] periods = new int[3];
        if (period == 1) {
            periods[0] = 1;
            periods[1] = 2;
            periods[2] = 3;
        } else if (period == 2) {
            periods[0] = 4;
            periods[1] = 5;
            periods[2] = 6;
        } else if (period == 3) {
            periods[0] = 7;
            periods[1] = 8;
            periods[2] = 9;
        } else {
            periods[0] = 10;
            periods[1] = 11;
            periods[2] = 12;
            if (isIncludAdjustPeriod) {
                periods[3] = 13;
            }
        }
        return periods;
    }

    private int[] getSemiYearPeriods(int period, boolean isIncludAdjustPeriod) {
        int[] periods = new int[6];
        if (period == 1) {
            periods[0] = 1;
            periods[1] = 2;
            periods[2] = 3;
            periods[3] = 4;
            periods[4] = 5;
            periods[5] = 6;
        } else {
            periods[0] = 7;
            periods[1] = 8;
            periods[2] = 9;
            periods[3] = 10;
            periods[4] = 11;
            periods[5] = 12;
            if (isIncludAdjustPeriod) {
                periods[6] = 13;
            }
        }
        return periods;
    }

    @Override
    protected Map _batchRemoveData(Context ctx, String schmId, List schmUnitLogIds) throws BOSException, EASBizException {
        try {
            if (schmUnitLogIds != null && !schmUnitLogIds.isEmpty()) {
                Object[] Objects = this.getCommFilters(ctx, schmUnitLogIds);
                if (Objects != null) {
                    int year = (Integer)Objects[0];
                    int period = (Integer)Objects[1];
                    int periodType = (Integer)Objects[2];
                    String currencyId = (String)Objects[3];
                    int[] peiods = this.getPeiods(ctx, schmId, periodType, period);
                    Map billHeadIdAndCompanyId = this.getBillHeadIdAndCompanyId(ctx, year, peiods, currencyId, schmId, schmUnitLogIds);
                    if (billHeadIdAndCompanyId == null || billHeadIdAndCompanyId.isEmpty()) {
                        return null;
                    }
                    Map removeData = AccountCheckFacadeFactory.getLocalInstance(ctx).removeData(billHeadIdAndCompanyId);
                    return removeData;
                }
                return null;
            }
        }
        catch (Exception e) {
            logger.error((Object)"_batchRemoveData error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private Map getBillHeadIdAndCompanyId(Context ctx, int year, int[] peiods, String currencyId, String schmId, List schmUnitLogIds) throws BOSException {
        HashMap map = new HashMap();
        if (peiods == null || peiods.length == 0) {
            return map;
        }
        try {
            IRowSet rowSet = this.getHeadIdAndCompanyIdRow(ctx, schmId, schmUnitLogIds, year, currencyId, peiods);
            if (rowSet != null && rowSet.size() > 0) {
                HashSet<String> headIdSet = new HashSet<String>();
                HashSet<String> companyIdSet = new HashSet<String>();
                while (rowSet.next()) {
                    headIdSet.add(rowSet.getString("headId"));
                    companyIdSet.add(rowSet.getString("companyId"));
                    companyIdSet.add(rowSet.getString("tarCompanyId"));
                }
                map.put("billheadIdSet", headIdSet);
                map.put("companyIdSet", companyIdSet);
                IObjectPK[] pkArray = new IObjectPK[companyIdSet.size()];
                int y = 0;
                for (String companyIdStr : companyIdSet) {
                    pkArray[y++] = new ObjectUuidPK(companyIdStr);
                }
                ObjectUuidPK userPK = new ObjectUuidPK(ctx.getCaller().toString());
                Set haveViewPermissionOrgSet = PermissionFactory.getLocalInstance((Context)ctx).checkBatchPermission((IObjectPK)userPK, pkArray, "csl_checkwork_view");
                HashSet<String> haveOrgPermissionOrgSet = new HashSet<String>();
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                view.setSelector(sic);
                sic.add(new SelectorItemInfo("company"));
                sic.add(new SelectorItemInfo("isfree"));
                sic.add(new SelectorItemInfo("freeTime"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("company", companyIdSet, CompareType.INCLUDE));
                view.setFilter(filter);
                CheckageCompanyCollection checkageCompanyCollection = CheckageCompanyFactory.getLocalInstance(ctx).getCheckageCompanyCollection(view);
                if (checkageCompanyCollection == null || checkageCompanyCollection.isEmpty()) {
                    return null;
                }
                String yearPeriodStr = RptUtil.getYearPeriod((int)year, (int)peiods[0], (int)year, (int)peiods[0]);
                for (int x = 0; x < checkageCompanyCollection.size(); ++x) {
                    CheckageCompanyInfo chInfo = checkageCompanyCollection.get(x);
                    CompanyOrgUnitInfo company = chInfo.getCompany();
                    if (company == null || company.getId() == null) continue;
                    boolean isfree = chInfo.isIsfree();
                    String companyId = company.getId().toString();
                    if (isfree) {
                        int freeTime = chInfo.getFreeTime();
                        String freezeStr = freeTime + "";
                        if (freezeStr.compareTo(yearPeriodStr) <= 0 || haveViewPermissionOrgSet == null || !haveViewPermissionOrgSet.contains(companyId)) continue;
                        haveOrgPermissionOrgSet.add(companyId);
                        continue;
                    }
                    if (haveViewPermissionOrgSet == null || !haveViewPermissionOrgSet.contains(companyId)) continue;
                    haveOrgPermissionOrgSet.add(companyId);
                }
                map.put("hasPermissionOrgIDSet", haveOrgPermissionOrgSet);
            }
        }
        catch (Exception e) {
            logger.error((Object)"getBillHeadIdAndCompanyId error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private int[] getPeiods(Context ctx, String schmId, int periodType, int period) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append("select FIsIncludAdjustPeriod from T_Csl_AutoCheckSchm where fid=? ", schmId);
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        boolean isIncludAdjustPeriod = false;
        if (rowSet != null && rowSet.next()) {
            isIncludAdjustPeriod = rowSet.getBoolean("FIsIncludAdjustPeriod");
        }
        return this.getPeiodsByPeriodType(RptPeriodTypeEnum.getEnum((int)periodType), period, isIncludAdjustPeriod);
    }

    @Override
    protected Map _batchUnConfirm(Context ctx, String schmId, List schmUnitLogIds) throws BOSException, EASBizException {
        try {
            if (schmUnitLogIds != null && !schmUnitLogIds.isEmpty()) {
                Object[] Objects = this.getCommFilters(ctx, schmUnitLogIds);
                if (Objects != null) {
                    int year = (Integer)Objects[0];
                    int period = (Integer)Objects[1];
                    int periodType = (Integer)Objects[2];
                    String currencyId = (String)Objects[3];
                    int[] peiods = this.getPeiods(ctx, schmId, periodType, period);
                    return this.batchUnConfirm(ctx, year, peiods, currencyId, schmId, schmUnitLogIds);
                }
                return null;
            }
        }
        catch (Exception e) {
            logger.error((Object)"_batchRemoveData error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private IRowSet getHeadIdAndCompanyIdRow(Context ctx, String schmId, List schmUnitLogIds, int year, String currencyId, int[] peiods) throws BOSException {
        SQLBuilder sql = new SQLBuilder();
        sql.append("select distinct billhead.fid headId, bill.FCompanyId companyId, bill.FTargetCompanyId tarCompanyId from T_Csl_CheckageBillHead billhead  \n");
        sql.append("inner join T_Csl_CheckageBill bill on bill.FBillHeadId=billhead.fid \n");
        sql.append("inner join T_Csl_CheckageBillCompany billCompany on bill.FBillCompanyId=billCompany.fid \n");
        sql.append("inner join T_Csl_AutoCheckSchmUnitLog schmUnitlog on schmUnitlog.FOwnCompanyId=bill.fcompanyid and schmUnitlog.FTargetCompanyId=bill.FTargetCompanyId \n");
        sql.append("where schmUnitlog.fid in \n", schmUnitLogIds);
        sql.append("and billCompany.FPackSchmId=? \n", schmId);
        sql.append("and bill.fyear=? \n", year);
        sql.append("and bill.FCurrencyId=? \n", currencyId);
        if (peiods.length == 1) {
            sql.append("and bill.fperiod=? ", peiods[0]);
        } else {
            sql.append("and bill.fperiod>=? ", peiods[0]);
            sql.append(" and bill.fperiod<=? ", peiods[peiods.length - 1]);
        }
        return DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
    }

    private Map batchUnConfirm(Context ctx, int year, int[] peiods, String currencyId, String schmId, List schmUnitLogIds) throws BOSException {
        HashMap map = new HashMap();
        if (peiods == null || peiods.length == 0) {
            return map;
        }
        try {
            StringBuilder sbInfo = new StringBuilder();
            Locale locale = ctx.getLocale();
            HashSet<String> schmHeadIdSet = new HashSet<String>();
            SQLBuilder sql = new SQLBuilder();
            sql.append("select distinct bill.FBillHeadId headId \n");
            sql.append("from T_Csl_CheckageBill bill \n");
            sql.append("inner join T_Csl_CheckageBillCompany billCompany on billCompany.Fid=bill.FBillCompanyId \n");
            sql.append("inner join T_Csl_AutoCheckSchmUnitLog schmUnitlog on schmUnitlog.FOwnCompanyId=bill.fcompanyid and schmUnitlog.FTargetCompanyId=bill.FTargetCompanyId \n");
            sql.append("where schmUnitlog.fid in \n", schmUnitLogIds);
            sql.append("and bill.fyear=? \n", year);
            sql.append("and bill.FCurrencyId=? \n", currencyId);
            if (peiods.length == 1) {
                sql.append("and bill.fperiod=? \n", peiods[0]);
            } else {
                sql.append("and bill.fperiod>=? ", peiods[0]);
                sql.append(" and bill.fperiod<=? \n", peiods[peiods.length - 1]);
            }
            sql.append("and billCompany.FConfirmSchmId=? \n", schmId);
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            if (rowSet != null && rowSet.size() > 0) {
                while (rowSet.next()) {
                    schmHeadIdSet.add(rowSet.getString("headId"));
                }
            }
            HashMap<String, HashSet<String>> billHeadIdMap = new HashMap<String, HashSet<String>>();
            HashSet<String> auditHeadSet = new HashSet<String>();
            boolean dataConfirmIsReview = CSLParamUtil.getParamBooleanValue((Context)ctx, (String)"GR_CSL_DZPT_DataConfirmIsReview");
            if (!schmHeadIdSet.isEmpty()) {
                sql.reset();
                sql.append("select distinct bill.FBillHeadId headId, billHead.Fnumber headNumber,billHead.FAuditedStatus auditedSta,billCompany.FConfirmStatus confirmSta,bill.fcompanyid companyId \n");
                sql.append(",company.fname_").append(locale.getLanguage()).append(" companyName \n");
                sql.append("from T_Csl_CheckageBill bill \n");
                sql.append("inner join T_ORG_Company company on company.Fid=bill.FCompanyId \n");
                sql.append("inner join T_Csl_CheckageBillHead billHead on bill.FBillHeadId=billHead.Fid \n");
                sql.append("inner join T_Csl_CheckageBillCompany billCompany on billCompany.Fid=bill.FBillCompanyId \n");
                sql.append("where bill.FBillHeadId in \n", schmHeadIdSet);
                sql.append(" and (billCompany.FConfirmStatus=").append(0);
                sql.append(" or billHead.FAuditedStatus=").append(2).append(")");
                rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                if (rowSet != null && rowSet.size() > 0) {
                    while (rowSet.next()) {
                        String headId = rowSet.getString("headId");
                        String headNumber = rowSet.getString("headNumber");
                        int auditedStatus = rowSet.getInt("auditedSta");
                        int confirmStatus = rowSet.getInt("confirmSta");
                        String companyId = rowSet.getString("companyId");
                        String companyName = rowSet.getString("companyName");
                        if (2 == auditedStatus) {
                            if (dataConfirmIsReview) {
                                auditHeadSet.add(headId);
                                HashSet<String> headIdSet = (Set)billHeadIdMap.get(companyId);
                                if (headIdSet == null) {
                                    headIdSet = new HashSet<String>();
                                    billHeadIdMap.put(companyId, headIdSet);
                                }
                                headIdSet.add(headId);
                            } else {
                                sbInfo.append(AccountCheckUtil.getResourceString(ctx, "canNotUnConfirmAuditedData", new Object[]{headNumber})).append("\n");
                            }
                        }
                        if (0 != confirmStatus) continue;
                        sbInfo.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"canNotDupUnConfirmCompanyData", (Locale)locale), headNumber, companyName)).append("\n");
                    }
                }
                sql.reset();
                sql.append("select distinct billHead.Fid headId,bill.fcompanyid companyId from T_Csl_CheckageBill bill \n");
                sql.append("inner join T_Csl_CheckageBillHead billHead on bill.FBillHeadId=billHead.Fid \n");
                sql.append("inner join T_Csl_CheckageBillCompany billCompany on billCompany.Fid=bill.FBillCompanyId \n");
                sql.append("where bill.FBillHeadId in \n", schmHeadIdSet);
                sql.append("and billCompany.FConfirmStatus=").append(1);
                sql.append(" and billHead.FAuditedStatus=").append(1);
                rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                if (rowSet != null && rowSet.size() > 0) {
                    while (rowSet.next()) {
                        String companyId = rowSet.getString("companyId");
                        String headId = rowSet.getString("headId");
                        HashSet<String> headIdSet = (HashSet<String>)billHeadIdMap.get(companyId);
                        if (headIdSet == null) {
                            headIdSet = new HashSet<String>();
                            billHeadIdMap.put(companyId, headIdSet);
                        }
                        headIdSet.add(headId);
                    }
                }
            }
            Set companyIdSet = billHeadIdMap.keySet();
            IObjectPK[] pkArray = new IObjectPK[companyIdSet.size()];
            int y = 0;
            for (String companyIdStr : companyIdSet) {
                pkArray[y++] = new ObjectUuidPK(companyIdStr);
            }
            ObjectUuidPK userPK = new ObjectUuidPK(ctx.getCaller().toString());
            Set haveUnConfirmPermissionOrgSet = PermissionFactory.getLocalInstance((Context)ctx).checkBatchPermission((IObjectPK)userPK, pkArray, "csl_checkwork_unconfirm");
            HashSet haveNoPermissionOrgSet = new HashSet(companyIdSet);
            haveNoPermissionOrgSet.removeAll(haveUnConfirmPermissionOrgSet);
            if (haveNoPermissionOrgSet != null && !haveNoPermissionOrgSet.isEmpty()) {
                for (String companyIdStr : haveNoPermissionOrgSet) {
                    billHeadIdMap.remove(companyIdStr);
                }
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                view.setSelector(sic);
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", haveNoPermissionOrgSet, CompareType.INCLUDE));
                view.setFilter(filter);
                CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
                if (companyOrgUnitCollection != null && !companyOrgUnitCollection.isEmpty()) {
                    for (int i = 0; i < companyOrgUnitCollection.size(); ++i) {
                        CompanyOrgUnitInfo companyOrgUnitInfo = companyOrgUnitCollection.get(i);
                        sbInfo.append(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"hasNoPermission", (Locale)locale), companyOrgUnitInfo.getName(), EASResource.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"unconfirm_Permission", (Locale)locale))).append("\n");
                    }
                }
            }
            HashMap<String, Cloneable> infoMap = new HashMap<String, Cloneable>();
            infoMap.put("billHeadMap", billHeadIdMap);
            infoMap.put("auditHeadSet", auditHeadSet);
            Map resultMap = AccountCheckFacadeFactory.getLocalInstance(ctx).confirm(infoMap, false);
            if (resultMap != null) {
                String canNotUnAuditStr = (String)resultMap.get("canNotUnAuditSb");
                if (!StringUtils.isEmpty((String)canNotUnAuditStr)) {
                    sbInfo.append(canNotUnAuditStr).append("\n");
                }
                map.put("hasUnConfrimData", resultMap.get("unConfrim"));
            } else {
                map.put("noData", "true");
            }
            map.put("info", sbInfo.toString());
        }
        catch (Exception e) {
            logger.error((Object)"batchUnConfirm error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private AutoCheckSchmLogCondition fetchData(Context ctx, AutoCheckSchmLogCondition condition, boolean isCompany) throws BOSException {
        block25: {
            String language = ctx.getLocale().getLanguage();
            int period = condition.getPeriod();
            RptPeriodTypeEnum periodType = condition.getPeriodType();
            AutoCheckStatusEnum autoCheckStatus = condition.getAutoCheckStatus();
            String diffType = condition.getDiffType();
            BigDecimal diffAmount = condition.getDiffAmount();
            int year = condition.getYear();
            String currencyId = condition.getCurrencyId();
            String schmId = condition.getSchmId();
            TempTablePool tmpTablePool = null;
            String srcBillDataTmep = null;
            try {
                tmpTablePool = TempTablePool.getInstance((Context)ctx);
                if (!StringUtils.isEmpty((String)condition.getTmpTable())) {
                    tmpTablePool.releaseTable(condition.getTmpTable());
                    condition.setTmpTable(null);
                    condition.setMaxRow(0);
                    condition.setFrom(0);
                    condition.setLength(0);
                }
                SQLBuilder sql = new SQLBuilder();
                if (isCompany) {
                    String selectCompanyId;
                    sql.append(" select max(log.id) id,max(log.lastUpdateTime) lastUpdateTime,log.ownCompanyId,log.targetCompanyId,log.getDataExecStatus,log.confirmExecStatus,log.diffAmount,");
                    sql.append("ownCompany.fname_").append(language).append(" ownCompanyName, tarCompany.fname_").append(language).append(" tarCompanyName \n");
                    sql.append(",tarCompany.fnumber tarCompanyNumber,ownCompany.fnumber ownCompanyNumber from (");
                    sql.append("select schmUnitLog.fid id,case when schmUnitLog.FOwnCompanyId<schmUnitLog.FTargetCompanyId then schmUnitLog.FOwnCompanyId else schmUnitLog.FTargetCompanyId end ownCompanyId, \n");
                    sql.append("case when schmUnitLog.FOwnCompanyId<schmUnitLog.FTargetCompanyId then schmUnitLog.FTargetCompanyId else schmUnitLog.FOwnCompanyId end targetCompanyId, \n");
                    sql.append("schmUnitLog.FGetDataExecStatus getDataExecStatus, schmUnitLog.FConfirmExecStatus confirmExecStatus,  \n");
                    sql.append("schmUnitLog.FDiffAmount diffAmount, schmUnitLog.FLastUpdateTime lastUpdateTime  \n");
                    sql.append("from T_Csl_AutoCheckSchmUnitLog schmUnitLog  \n");
                    sql.append("inner join T_Csl_AutoCheckSchmLog schmLog on schmLog.fid=schmUnitLog.FSchmLogId \n");
                    sql.append("where schmLog.FSchmId=? \n", schmId);
                    sql.append("and schmLog.FCurrencyId=? \n", currencyId);
                    sql.append("and schmLog.FPeriodType=? \n", periodType.getValue());
                    sql.append("and schmLog.FYear=? \n", year);
                    sql.append("and schmLog.FPeriod=? \n", period);
                    if (!StringUtils.isEmpty((String)diffType)) {
                        sql.append("and schmUnitLog.FDiffAmount").append(diffType).append(diffAmount != null ? diffAmount : BigDecimal.ZERO).append(" \n");
                    }
                    if (!StringUtils.isEmpty((String)(selectCompanyId = condition.getSelectCompanyId()))) {
                        sql.append("and schmUnitLog.FOwnCompanyId=? \n", selectCompanyId);
                    } else {
                        Set<String> companySet = condition.getCompanySet();
                        if (companySet != null && companySet.size() > 0) {
                            sql.append("and schmUnitLog.FOwnCompanyId in \n", companySet);
                        }
                    }
                    sql.append(" and schmUnitLog.FOrgUnitId is null \n");
                    if (autoCheckStatus != null) {
                        sql.append(" and (schmUnitLog.FGetDataExecStatus=? ", autoCheckStatus.getValue());
                        sql.append(" or schmUnitLog.FConfirmExecStatus=?) \n", autoCheckStatus.getValue());
                    }
                    sql.append(") log ");
                    sql.append("left join T_ORG_BaseUnit ownCompany on ownCompany.fid=log.ownCompanyId \n");
                    sql.append("left join T_ORG_BaseUnit tarCompany on tarCompany.fid=log.targetCompanyId \n");
                    sql.append("group by log.ownCompanyId,log.targetCompanyId,log.getDataExecStatus,log.confirmExecStatus,log.diffAmount,tarCompany.fnumber,ownCompany.fnumber,");
                    sql.append("ownCompany.fname_").append(language).append(", tarCompany.fname_").append(language);
                } else {
                    String selectOrgUnitId;
                    sql.append("select schmUnitLog.fid id,schmUnitLog.FOwnCompanyId ownCompanyId, schmUnitLog.FTargetCompanyId targetCompanyId, orgUnit.fname_").append(language).append(" orgUnitName, \n");
                    sql.append("orgUnit.fid orgUnitId,schmUnitLog.FDiffHdExecStatus diffHdExecStatus, schmUnitLog.FAuditExecStatus auditExecStatus, schmUnitLog.FCreateElimExecStatus createElimExecStatus, \n");
                    sql.append("schmUnitLog.FDiffMode diffMode, schmUnitLog.FDiffAmount diffAmount, schmUnitLog.FLastUpdateTime lastUpdateTime, ownCompany.fnumber ownCompanyNumber,  \n");
                    sql.append("ownCompany.fname_").append(language).append(" ownCompanyName, tarCompany.fnumber tarCompanyNumber, tarCompany.fname_").append(language).append(" tarCompanyName \n");
                    sql.append("from T_Csl_AutoCheckSchmUnitLog schmUnitLog  \n");
                    sql.append("inner join T_Csl_AutoCheckSchmLog schmLog on schmLog.fid=schmUnitLog.FSchmLogId \n");
                    sql.append("inner join T_ORG_BaseUnit orgUnit on orgUnit.fid=schmUnitLog.FOrgUnitId \n");
                    sql.append("left join T_ORG_BaseUnit ownCompany on ownCompany.fid=schmUnitLog.FOwnCompanyId \n");
                    sql.append("left join T_ORG_BaseUnit tarCompany on tarCompany.fid=schmUnitLog.FTargetCompanyId \n");
                    sql.append("where schmLog.FSchmId=? \n", schmId);
                    sql.append("and schmLog.FCurrencyId=? \n", currencyId);
                    sql.append("and schmLog.FPeriodType=? \n", periodType.getValue());
                    sql.append("and schmLog.FYear=? \n", year);
                    sql.append("and schmLog.FPeriod=? \n", period);
                    if (!StringUtils.isEmpty((String)diffType)) {
                        sql.append("and schmUnitLog.FDiffAmount").append(diffType).append(diffAmount != null ? diffAmount : BigDecimal.ZERO).append(" \n");
                    }
                    if (!StringUtils.isEmpty((String)(selectOrgUnitId = condition.getSelectOrgUnitId()))) {
                        sql.append(" and schmUnitLog.FOrgUnitId=? \n", selectOrgUnitId);
                    } else {
                        Set<String> orgUnitSet = condition.getOrgUnitSet();
                        if (orgUnitSet != null && orgUnitSet.size() > 0) {
                            sql.append("and schmUnitLog.FOrgUnitId in \n", orgUnitSet);
                        }
                    }
                    if (autoCheckStatus != null) {
                        sql.append(" and (schmUnitLog.FDiffHdExecStatus=? ", autoCheckStatus.getValue());
                        sql.append(" or schmUnitLog.FAuditExecStatus=? ", autoCheckStatus.getValue());
                        sql.append(" or schmUnitLog.FCreateElimExecStatus=?) \n", autoCheckStatus.getValue());
                    }
                    sql.append("order by schmUnitLog.FOwnCompanyId");
                }
                IRowSet row = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                if (row == null || row.size() <= 0) break block25;
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                Object[] parmas = null;
                sql.reset();
                if (isCompany) {
                    sql.append("create table t_csl_tempSchmLog(id varchar(44), ownCompanyId varchar(44), ");
                    sql.append("targetCompanyId varchar(44), nameKey nvarchar(512), getDataExecStatus int, confirmExecStatus int, diffAmount NUMERIC(21,6), lastUpdateTime DateTime)");
                } else {
                    sql.append("create table t_csl_tempSchmLog(id varchar(44), orgUnitId varchar(44),orgUnitName varchar(255),  ");
                    sql.append("ownCompanyId varchar(44), targetCompanyId varchar(44), nameKey nvarchar(512), diffHdExecStatus int, ");
                    sql.append("auditExecStatus int, createElimExecStatus int, diffMode int, diffAmount NUMERIC(21,6), lastUpdateTime DateTime)");
                }
                srcBillDataTmep = tmpTablePool.createTempTable(sql.getSQL());
                StringBuilder insertSqlSb = new StringBuilder();
                if (isCompany) {
                    insertSqlSb.append("insert into ").append(srcBillDataTmep).append(" (id,ownCompanyId,");
                    insertSqlSb.append("targetCompanyId,nameKey,getDataExecStatus,confirmExecStatus,diffAmount,lastUpdateTime)");
                    insertSqlSb.append("values(?,?,?,?,?,?,?,?)");
                    while (row.next()) {
                        String ownCompanyNumber = row.getString("ownCompanyNumber");
                        String ownCompanyName = row.getString("ownCompanyName");
                        String tarCompanyNumber = row.getString("tarCompanyNumber");
                        String tarCompanyName = row.getString("tarCompanyName");
                        parmas = new Object[8];
                        parmas[0] = row.getString("id");
                        parmas[1] = row.getString("ownCompanyId");
                        parmas[2] = row.getString("targetCompanyId");
                        if (!StringUtils.isEmpty((String)tarCompanyNumber) && !StringUtils.isEmpty((String)ownCompanyNumber)) {
                            parmas[3] = ownCompanyName + "-" + tarCompanyName;
                        }
                        parmas[4] = row.getInt("getDataExecStatus");
                        parmas[5] = row.getInt("confirmExecStatus");
                        parmas[6] = row.getBigDecimal("diffAmount");
                        parmas[7] = row.getTimestamp("lastUpdateTime");
                        paramsList.add(parmas);
                    }
                } else {
                    insertSqlSb.append("insert into ").append(srcBillDataTmep).append(" (id,orgUnitId, orgUnitName,ownCompanyId,targetCompanyId,nameKey,");
                    insertSqlSb.append("diffHdExecStatus,auditExecStatus,createElimExecStatus,diffMode,diffAmount,lastUpdateTime)");
                    insertSqlSb.append("values(?,?,?,?,?,?,?,?,?,?,?,?)");
                    while (row.next()) {
                        String ownCompanyNumber = row.getString("ownCompanyNumber");
                        String ownCompanyName = row.getString("ownCompanyName");
                        String tarCompanyNumber = row.getString("tarCompanyNumber");
                        String tarCompanyName = row.getString("tarCompanyName");
                        String orgUnitName = row.getString("orgUnitName");
                        parmas = new Object[12];
                        parmas[0] = row.getString("id");
                        parmas[1] = row.getString("orgUnitId");
                        parmas[2] = row.getString("orgUnitName");
                        parmas[3] = row.getString("ownCompanyId");
                        parmas[4] = row.getString("targetCompanyId");
                        if (!StringUtils.isEmpty((String)ownCompanyNumber) && !StringUtils.isEmpty((String)tarCompanyNumber)) {
                            parmas[5] = ownCompanyNumber.compareTo(tarCompanyNumber) <= 0 ? ownCompanyName + "-" + tarCompanyName : tarCompanyName + "-" + ownCompanyName;
                        }
                        parmas[6] = row.getInt("diffHdExecStatus");
                        parmas[7] = row.getInt("auditExecStatus");
                        parmas[8] = row.getInt("createElimExecStatus");
                        parmas[9] = row.getInt("diffMode");
                        parmas[10] = row.getBigDecimal("diffAmount");
                        parmas[11] = row.getTimestamp("lastUpdateTime");
                        paramsList.add(parmas);
                    }
                }
                if (paramsList.size() > 0) {
                    DbUtil.executeBatch(ctx, insertSqlSb.toString(), paramsList);
                }
                sql.reset();
                sql.append(" select count(*) countNum from ").append(srcBillDataTmep);
                row = DbUtil.executeQuery(ctx, sql.getSQL());
                if (row.next()) {
                    condition.setMaxRow(row.getInt("countNum"));
                }
                condition.setTmpTable(srcBillDataTmep);
                this.getAutoCheckStNum(ctx, condition, isCompany, srcBillDataTmep);
            }
            catch (Exception e) {
                logger.error((Object)"fetchData_error.", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return condition;
    }

    private void getAutoCheckStNum(Context ctx, AutoCheckSchmLogCondition condition, boolean isCompany, String srcBillDataTmep) throws Exception {
        if (isCompany) {
            this.getCounts(ctx, "getDataExecStatus", srcBillDataTmep, condition);
            this.getCounts(ctx, "confirmExecStatus", srcBillDataTmep, condition);
        } else {
            this.getCounts(ctx, "diffHdExecStatus", srcBillDataTmep, condition);
            this.getCounts(ctx, "auditExecStatus", srcBillDataTmep, condition);
            this.getCounts(ctx, "createElimExecStatus", srcBillDataTmep, condition);
        }
    }

    private void getCounts(Context ctx, String autoCheckStatusValue, String srcBillDataTmep, AutoCheckSchmLogCondition condition) throws Exception {
        int unExecCount = condition.getUnExecCount();
        int execCount = condition.getExecCount();
        int successCount = condition.getSuccessCount();
        int failCount = condition.getFailCount();
        SQLBuilder sql = new SQLBuilder();
        sql.append("select ").append(autoCheckStatusValue).append(",count(*) countRow from ").append(srcBillDataTmep).append(" group by ").append(autoCheckStatusValue);
        IRowSet row = DbUtil.executeQuery(ctx, sql.getSQL());
        while (row.next()) {
            int countRow = row.getInt("countRow");
            switch (row.getInt(autoCheckStatusValue)) {
                case 1: {
                    unExecCount += countRow;
                    break;
                }
                case 2: {
                    execCount += countRow;
                    break;
                }
                case 3: {
                    successCount += countRow;
                    break;
                }
                case 4: {
                    failCount += countRow;
                    break;
                }
            }
        }
        condition.setUnExecCount(unExecCount);
        condition.setExecCount(execCount);
        condition.setSuccessCount(successCount);
        condition.setFailCount(failCount);
    }

    private ArrayList getData(Context ctx, AutoCheckSchmLogCondition condition, boolean isCompany) throws BOSException {
        ArrayList<AutoCheckSchmLogUIInfo> resultList = new ArrayList<AutoCheckSchmLogUIInfo>();
        String fetchTmpTable = condition.getTmpTable();
        if (StringUtils.isEmpty((String)fetchTmpTable)) {
            return null;
        }
        SQLBuilder sql = new SQLBuilder();
        if (isCompany) {
            sql.append("select id,ownCompanyId,targetCompanyId,nameKey,getDataExecStatus,confirmExecStatus,diffAmount,lastUpdateTime from ").append(fetchTmpTable);
        } else {
            sql.append("select id,orgUnitId,orgUnitName,ownCompanyId,targetCompanyId,nameKey,diffHdExecStatus,auditExecStatus,createElimExecStatus,diffMode,diffAmount,lastUpdateTime from ").append(fetchTmpTable);
        }
        int from = condition.getFrom();
        int lenth = condition.getLength();
        try {
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), from, lenth);
            if (rowSet != null && rowSet.size() > 0) {
                while (rowSet.next()) {
                    AutoCheckSchmLogUIInfo auLogUIInfo = new AutoCheckSchmLogUIInfo();
                    auLogUIInfo.id = rowSet.getString("id");
                    auLogUIInfo.ownCompanyId = rowSet.getString("ownCompanyId");
                    auLogUIInfo.targetCompanyId = rowSet.getString("targetCompanyId");
                    auLogUIInfo.checkCompany = rowSet.getString("nameKey");
                    auLogUIInfo.diffAmount = rowSet.getBigDecimal("diffAmount");
                    auLogUIInfo.createtime = rowSet.getTimestamp("lastUpdateTime");
                    if (isCompany) {
                        auLogUIInfo.getDataExecStatus = rowSet.getInt("getDataExecStatus");
                        auLogUIInfo.confirmExecStatus = rowSet.getInt("confirmExecStatus");
                    } else {
                        auLogUIInfo.orgUnitId = rowSet.getString("orgUnitId");
                        auLogUIInfo.orgUnitName = rowSet.getString("orgUnitName");
                        auLogUIInfo.diffHdExecStatus = rowSet.getInt("diffHdExecStatus");
                        auLogUIInfo.auditExecStatus = rowSet.getInt("auditExecStatus");
                        auLogUIInfo.createElimExecStatus = rowSet.getInt("createElimExecStatus");
                        auLogUIInfo.diffMode = rowSet.getInt("diffMode");
                    }
                    resultList.add(auLogUIInfo);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"getCompanyData_error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return resultList;
    }

    @Override
    protected AutoCheckSchmLogCondition _fetchCompanyData(Context ctx, AutoCheckSchmLogCondition condition) throws BOSException, EASBizException {
        return this.fetchData(ctx, condition, true);
    }

    @Override
    protected ArrayList _getCompanyData(Context ctx, AutoCheckSchmLogCondition condition) throws BOSException, EASBizException {
        return this.getData(ctx, condition, true);
    }

    @Override
    protected AutoCheckSchmLogCondition _fetchOrgUnitData(Context ctx, AutoCheckSchmLogCondition condition) throws BOSException, EASBizException {
        return this.fetchData(ctx, condition, false);
    }

    @Override
    protected ArrayList _getOrgUnitData(Context ctx, AutoCheckSchmLogCondition condition) throws BOSException, EASBizException {
        return this.getData(ctx, condition, false);
    }
}

