/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class CheckageCompanyImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.accountcheck.app.CheckageCompanyImport");
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Map<String, String> exsitCompanyMap = new HashMap<String, String>();
    private Map<String, Integer> exsitCompanyIndexMap = new HashMap<String, Integer>();
    private int index = 4;
    private Map<String, FullOrgUnitInfo> companyMap = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return CheckageCompanyFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        CheckageCompanyInfo info = (CheckageCompanyInfo)coreBaseInfo;
        try {
            if (coreBaseInfo == null) {
                return;
            }
            if (coreBaseInfo.getId() == null || !this.getController(ctx).exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                IObjectPK addnew = this.getController(ctx).addnew(coreBaseInfo);
                if (this.isSltImportUpdate()) {
                    this.exsitCompanyMap.put(info.getCompany().getId().toString(), addnew.toString());
                }
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        if (!this.isSltImportUpdate() && info != null && info.getCompany().getId() != null) {
            this.exsitCompanyMap.put(info.getCompany().getId().toString(), info.getId().toString());
            this.exsitCompanyIndexMap.put(info.getCompany().getId().toString(), this.index);
        }
    }

    public void importOnFinished(Context ctx, Map map) throws TaskExternalException {
        super.importOnFinished(ctx, map);
    }

    private boolean isExsitCompany(Context ctx, FullOrgUnitInfo info) throws TaskExternalException {
        SQLBuilder sql = new SQLBuilder();
        try {
            String companyId = info.getId().toString();
            sql.append("select FCompanyId,Fid from T_Csl_CheckageCompany \n");
            sql.append("where FCompanyId=?", companyId);
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), sql.getParams());
            if (rowSet.next()) {
                this.exsitCompanyMap.put(rowSet.getString("FCompanyId"), rowSet.getString("Fid"));
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"queryExsitCompany_error:", (Throwable)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String isIncludingUnPostedStr;
        String contect2;
        String contect;
        ++this.index;
        String companyNumber = this.fecthData(hsData, "FCompanyNumber");
        if (StringUtils.isEmpty((String)companyNumber)) {
            throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageCompany_import_companyNumberNull", null));
        }
        if (!this.companyIsExist(ctx, companyNumber = companyNumber.replaceAll(" ", ""))) {
            throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageCompany_import_orgNull", new Object[]{companyNumber}));
        }
        FullOrgUnitInfo orgUnitInfo = this.getCompany(ctx, companyNumber);
        if (orgUnitInfo == null) {
            throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageCompany_import_orgOutRange", new Object[]{companyNumber}));
        }
        if (!Boolean.TRUE.equals(orgUnitInfo.get("isbizunit"))) {
            throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageCompany_import_orgNotBiz", new Object[]{companyNumber}));
        }
        String companyId = orgUnitInfo.getId().toString();
        String updateId = null;
        if (!this.isSltImportUpdate()) {
            if (this.exsitCompanyMap.containsKey(companyId)) {
                Integer existIndex = this.exsitCompanyIndexMap.get(companyId);
                if (existIndex != null) {
                    throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageCompany_import_rowDup", new Object[]{existIndex}));
                }
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageCompany_import_companyDup", null));
            }
            if (this.isExsitCompany(ctx, orgUnitInfo)) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageCompany_import_companyDup", null));
            }
        } else if (!this.exsitCompanyMap.containsKey(companyId)) {
            if (!this.isExsitCompany(ctx, orgUnitInfo)) {
                this.exsitCompanyMap.put(companyId, null);
            } else {
                updateId = this.exsitCompanyMap.get(companyId);
            }
        } else {
            updateId = this.exsitCompanyMap.get(companyId);
        }
        if (!StringUtils.isEmpty((String)(contect = this.fecthData(hsData, "FContect"))) && contect.length() > 120) {
            throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageCompany_import_contectTooLong", null));
        }
        String cell = this.fecthData(hsData, "FCell");
        if (!(StringUtils.isEmpty((String)cell) || (cell = cell.trim()).length() <= 20 && Pattern.matches("^[+0-9][\\d-\\s]{" + (cell.length() - 1) + "}", cell))) {
            throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageCompany_import_cellError", null));
        }
        String email = this.fecthData(hsData, "FEmail");
        if (!StringUtils.isEmpty((String)email)) {
            if ((email = email.trim()).indexOf("@") < 0 || email.endsWith("@")) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageCompany_import_emailError", null));
            }
            if (email.length() > 200) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageCompany_import_emailTooLong", null));
            }
        }
        if (!StringUtils.isEmpty((String)(contect2 = this.fecthData(hsData, "FContect2"))) && contect2.length() > 120) {
            throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageCompany_import_contect2TooLong", null));
        }
        String cell2 = this.fecthData(hsData, "FCell2");
        if (!(StringUtils.isEmpty((String)cell2) || (cell2 = cell2.trim()).length() <= 20 && Pattern.matches("^[+0-9][\\d-\\s]{" + (cell2.length() - 1) + "}", cell2))) {
            throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageCompany_import_cell2Error", null));
        }
        String email2 = this.fecthData(hsData, "FEmail2");
        if (!StringUtils.isEmpty((String)email2)) {
            if ((email2 = email2.trim()).indexOf("@") < 0 || email2.endsWith("@")) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageCompany_import_email2Error", null));
            }
            if (email2.length() > 200) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageCompany_import_email2TooLong", null));
            }
        }
        if (StringUtils.isEmpty((String)(isIncludingUnPostedStr = this.fecthData(hsData, "FIsIncludingUnPosted")))) {
            throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageCompany_import_isIncludingUnPostedNull", null));
        }
        if (!"Y".equalsIgnoreCase(isIncludingUnPostedStr) && !"N".equalsIgnoreCase(isIncludingUnPostedStr)) {
            throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageCompany_import_isIncludingUnPostedError", null));
        }
        boolean isIncludingUnPosted = "Y".equalsIgnoreCase(isIncludingUnPostedStr);
        String isfreeStr = this.fecthData(hsData, "FIsfree");
        boolean isfree = "Y".equalsIgnoreCase(isfreeStr);
        String freeTimeStr = this.fecthData(hsData, "FFreeTime");
        int freeTime = -1;
        if (isfree) {
            if (StringUtils.isEmpty((String)freeTimeStr)) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageCompany_import_freeTimeNull", null));
            }
            if (!freeTimeStr.matches("\\d{4}-\\d{1,2}")) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageCompany_import_freeTimeError", null));
            }
            int freeYear = -1;
            int freePeriod = -1;
            try {
                freeYear = Integer.parseInt(freeTimeStr.split("-")[0]);
                freePeriod = Integer.parseInt(freeTimeStr.split("-")[1]);
            }
            catch (Exception e) {
                logger.error((Object)"error:", (Throwable)e);
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            int[] queryQuoteTime = this.queryQuoteTime(ctx, orgUnitInfo);
            int minYear = -1;
            int minPeriod = -1;
            if (queryQuoteTime[0] != -1 && queryQuoteTime[1] != -1) {
                if (queryQuoteTime[1] == 13) {
                    minYear = queryQuoteTime[0] + 1;
                    minPeriod = 1;
                } else {
                    minYear = queryQuoteTime[0];
                    minPeriod = queryQuoteTime[1] + 1;
                }
            } else {
                minYear = queryQuoteTime[2];
                minPeriod = queryQuoteTime[3];
            }
            int maxYear = queryQuoteTime[4];
            int maxPeriod = queryQuoteTime[5];
            if (freeYear < minYear || freeYear > maxYear || freeYear == minYear && freePeriod < minPeriod || freeYear == maxYear && freePeriod > maxPeriod) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "checkageCompany_import_freeTimeOutRange", null));
            }
            freeTime = Integer.valueOf(RptUtil.getYearPeriod((int)freeYear, (int)freePeriod, (int)freeYear, (int)freePeriod));
        }
        CheckageCompanyInfo checkageCompanyInfo = new CheckageCompanyInfo();
        if (updateId != null) {
            checkageCompanyInfo.setId(BOSUuid.read((String)updateId));
        }
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo.setId(orgUnitInfo.getId());
        checkageCompanyInfo.setCompany(companyInfo);
        checkageCompanyInfo.setContect(contect);
        checkageCompanyInfo.setCell(cell);
        checkageCompanyInfo.setEmail(email);
        checkageCompanyInfo.setContect2(contect2);
        checkageCompanyInfo.setCell2(cell2);
        checkageCompanyInfo.setEmail2(email2);
        checkageCompanyInfo.setIsIncludingUnPosted(isIncludingUnPosted);
        checkageCompanyInfo.setIsfree(isfree);
        checkageCompanyInfo.setFreeTime(isfree ? freeTime : 0);
        return checkageCompanyInfo;
    }

    private int[] queryQuoteTime(Context ctx, FullOrgUnitInfo orgUnitInfo) throws TaskExternalException {
        int[] yearAndPeriodTime = new int[6];
        String companyId = orgUnitInfo.getId().toString();
        SQLBuilder sql = new SQLBuilder();
        sql.append("select top 1 FYear,FPeriod from T_Csl_CheckageBill \n");
        sql.append("where FCompanyId=? ", companyId);
        sql.append("or FTargetCompanyId=? ", companyId);
        sql.append("order by FYear DESC,FPeriod DESC");
        try {
            int year = -1;
            int period = -1;
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), sql.getParams());
            if (rowSet.next()) {
                year = rowSet.getInt("FYear");
                period = rowSet.getInt("FPeriod");
            }
            String accountPeriodTypeId = (String)orgUnitInfo.get("accountPeriodTypeId");
            int minYear = -1;
            int minPeriod = -1;
            int maxYear = -1;
            int maxPeriod = -1;
            if (!StringUtils.isEmpty((String)accountPeriodTypeId)) {
                sql.reset();
                sql.append("select FPeriodYear,FPeriodNumber from T_BD_Period  \n");
                sql.append("where FTypeID =? ", accountPeriodTypeId);
                sql.append(" order by FPeriodYear,FPeriodNumber asc ");
                rowSet = DbUtil.executeQuery(ctx, sql.toString(), sql.getParams());
                if (rowSet != null && rowSet.size() > 0) {
                    int pYear = -1;
                    int pPeriod = -1;
                    while (rowSet.next()) {
                        pYear = rowSet.getInt("FPeriodYear");
                        pPeriod = rowSet.getInt("FPeriodNumber");
                        if (minYear == -1) {
                            minYear = pYear;
                        }
                        if (minPeriod == -1 || pPeriod < minPeriod) {
                            minPeriod = pPeriod;
                        }
                        maxYear = pYear;
                        if (maxPeriod != -1 && pPeriod <= maxPeriod) continue;
                        maxPeriod = pPeriod;
                    }
                }
            }
            yearAndPeriodTime[0] = year;
            yearAndPeriodTime[1] = period;
            yearAndPeriodTime[2] = minYear;
            yearAndPeriodTime[3] = minPeriod;
            yearAndPeriodTime[4] = maxYear;
            yearAndPeriodTime[5] = maxPeriod;
        }
        catch (Exception e) {
            logger.error((Object)"queryQuoteTime_error:", (Throwable)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return yearAndPeriodTime;
    }

    private String fecthData(Hashtable htData, String key) {
        DataToken dataToken = (DataToken)htData.get(key);
        if (dataToken != null) {
            return dataToken.toString();
        }
        return null;
    }

    private boolean companyIsExist(Context ctx, String companyNumber) throws TaskExternalException {
        SQLBuilder sql = new SQLBuilder();
        sql.append("select fid from T_ORG_BaseUnit \n");
        sql.append("where fnumber=?", companyNumber);
        try {
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), sql.getParams());
            return rowSet != null && rowSet.size() > 0;
        }
        catch (Exception e) {
            logger.error((Object)"companyIsExist_error:", (Throwable)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private FullOrgUnitInfo getCompany(Context ctx, String companyNumber) throws TaskExternalException {
        this.queryCompany(ctx);
        if (this.companyMap != null && !this.companyMap.isEmpty()) {
            return this.companyMap.get(companyNumber);
        }
        return null;
    }

    private void queryCompany(Context ctx) throws TaskExternalException {
        if (this.companyMap != null) {
            return;
        }
        this.companyMap = new HashMap<String, FullOrgUnitInfo>();
        String userId = ctx.getCaller().toString();
        String la = ctx.getLocale().getLanguage();
        SQLBuilder sql = new SQLBuilder();
        sql.append("select unit.fid unitId,unit.fnumber unitNumber, company.fid companyId, company.fname_").append(la).append(" companyName, company.FAccountPeriodID accountPeriodTypeId,company.fisbizunit isbizunit \n");
        sql.append("from T_PM_OrgRange range \n");
        sql.append("inner join T_ORG_BaseUnit unit ON unit.fid = range.FOrgID \n");
        sql.append("left join T_ORG_Company company on company.fid=unit.fid \n");
        sql.append("where range.FUserID=? \n", userId);
        sql.append("and range.FType=?", 10);
        try {
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), sql.getParams());
            if (rowSet != null && rowSet.size() > 0) {
                while (rowSet.next()) {
                    FullOrgUnitInfo orgUnitInfo = new FullOrgUnitInfo();
                    String unitId = rowSet.getString("unitId");
                    String unitNumber = rowSet.getString("unitNumber");
                    orgUnitInfo.setId(BOSUuid.read((String)unitId));
                    orgUnitInfo.setNumber(unitNumber);
                    String companyId = rowSet.getString("companyId");
                    if (!StringUtils.isEmpty((String)companyId)) {
                        String companyName = rowSet.getString("companyName");
                        boolean isbizunit = rowSet.getBoolean("isbizunit");
                        orgUnitInfo.setName(companyName);
                        orgUnitInfo.put("isbizunit", (Object)isbizunit);
                        String accountPeriodTypeId = rowSet.getString("accountPeriodTypeId");
                        if (!StringUtils.isEmpty((String)accountPeriodTypeId)) {
                            orgUnitInfo.put("accountPeriodTypeId", (Object)accountPeriodTypeId);
                        }
                    }
                    this.companyMap.put(unitNumber, orgUnitInfo);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"queryCompany_error:", (Throwable)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            String freeTimeStr;
            this.setData(result, "FCompanyNumber", rs.getObject("company.number"));
            this.setData(result, "FCompanyName", rs.getObject("company.name"));
            this.setData(result, "FContect", rs.getObject("contect"));
            this.setData(result, "FCell", rs.getObject("cell"));
            this.setData(result, "FEmail", rs.getObject("email"));
            this.setData(result, "FContect2", rs.getObject("contect2"));
            this.setData(result, "FCell2", rs.getObject("cell2"));
            this.setData(result, "FEmail2", rs.getObject("email2"));
            if (rs.getBoolean("isIncludingUnPosted")) {
                result.put("FIsIncludingUnPosted", "Y");
            } else {
                result.put("FIsIncludingUnPosted", "N");
            }
            if (rs.getBoolean("isfree")) {
                result.put("FIsfree", "Y");
            } else {
                result.put("FIsfree", "N");
            }
            int freeTime = rs.getInt("freeTime");
            if (0 != freeTime && (freeTimeStr = freeTime + "").matches("\\d{6}")) {
                this.setData(result, "FFreeTime", freeTimeStr.substring(0, 4) + "-" + freeTimeStr.substring(4, freeTimeStr.length()));
            }
            this.setData(result, "FCreator", rs.getObject("creator.number"));
            this.setData(result, "FCreateTime", this.sdf.format(rs.getObject("createTime")));
            this.setData(result, "FLastUpdateUser", rs.getObject("lastUpdateUser.number"));
            this.setData(result, "FLastUpdateTime", this.sdf.format(rs.getObject("lastUpdateTime")));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void setData(Hashtable result, String key, Object value) {
        if (value != null) {
            if (value instanceof BigDecimal) {
                result.put(key, CslRptUtil.ReduceBigDecimalZeros((BigDecimal)((BigDecimal)value)));
            } else {
                result.put(key, value.toString());
            }
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyForExportQuery";
    }

    public String getMainField() {
        return "FNumber";
    }

    public int getSubmitType() {
        return 0;
    }

    public void setContextParameter(Hashtable param) {
        param.put("mainQueryPK", MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyForExportQuery"));
        super.setContextParameter((Map)param);
    }
}

