/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fi.gl.app.check.IPluginClosePeriodCheck;
import com.kingdee.eas.fi.gl.check.CheckResult;
import com.kingdee.eas.fi.gl.check.ResultStatusCode;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Time;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GLClosePeriodCheckCSLImpl
implements IPluginClosePeriodCheck {
    private static Logger logger = Logger.getLogger((String)GLClosePeriodCheckCSLImpl.class.getName());
    private String paramNumber = "GR_CSL_DZPT_CheckDataDifferenceCannotClosing";
    private MessageFormat checkOneDiffBigTolerMsgFormat = null;
    private MessageFormat checkAllDiffBigTolerMsgFormat = null;
    private String existCompanyDiffMsg = null;
    private String companyNameMsg = null;

    public CheckResult check(Context ctx, FullOrgUnitInfo fullOrgUnitInfo, PeriodInfo periodInfo, Map<String, Object> extendParam) {
        logger.error((Object)("GLClosePeriodCheckCSLImpl params:" + fullOrgUnitInfo.getId().toString() + ";" + periodInfo.getPeriodYear() + ";" + periodInfo.getPeriodNumber()));
        CheckResult checkResult = new CheckResult(ResultStatusCode.SUCCESS);
        try {
            Object checkDiffParamValue = CSLParamUtil.getParamValue((Context)ctx, (String)fullOrgUnitInfo.getId().toString(), (String)this.paramNumber);
            if (checkDiffParamValue != null && !"0".equals(checkDiffParamValue) && CheckageCompanyFactory.getLocalInstance(ctx).exists(" where company.id='" + fullOrgUnitInfo.getId().toString() + "'")) {
                this.checkGenerateCheckageData(ctx, fullOrgUnitInfo, periodInfo, extendParam, checkResult);
                Set<String> targetCompanyIds = null;
                if (!ResultStatusCode.FAILD.equals((Object)checkResult.getStatusCode())) {
                    targetCompanyIds = this.getTargetCompanyIds(ctx, fullOrgUnitInfo, periodInfo, extendParam, (String)checkDiffParamValue);
                    this.checkCheckageDataChanged(ctx, fullOrgUnitInfo, periodInfo, extendParam, (String)checkDiffParamValue, targetCompanyIds, checkResult);
                }
                if (!ResultStatusCode.FAILD.equals((Object)checkResult.getStatusCode())) {
                    if (targetCompanyIds == null) {
                        targetCompanyIds = this.getTargetCompanyIds(ctx, fullOrgUnitInfo, periodInfo, extendParam, (String)checkDiffParamValue);
                    }
                    this.checkDiff(ctx, fullOrgUnitInfo, periodInfo, extendParam, (String)checkDiffParamValue, targetCompanyIds, checkResult);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"check", (Throwable)e);
            checkResult.setStatusCode(ResultStatusCode.FAILD);
            checkResult.setMessage(e.getMessage());
        }
        logger.error((Object)("check end:" + checkResult.getStatusCode() + ":" + checkResult.getMessage()));
        return checkResult;
    }

    public void checkGenerateCheckageData(Context ctx, FullOrgUnitInfo fullOrgUnitInfo, PeriodInfo periodInfo, Map<String, Object> extendParam, CheckResult checkResult) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append(" select fid from T_Csl_CheckageOrgPack ");
        sql.append("where FYear=? ", periodInfo.getPeriodYear());
        sql.append(" and FPeriod=? ", periodInfo.getPeriodNumber());
        sql.append(" and FCompanyId=? ", fullOrgUnitInfo.getId().toString());
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        if (rowSet.size() <= 0) {
            checkResult.setStatusCode(ResultStatusCode.FAILD);
            checkResult.setMessage("\n" + AccountCheckUtil.getResourceString(ctx, "457noGenerateCheckData", null));
        }
    }

    public void checkDiff(Context ctx, FullOrgUnitInfo fullOrgUnitInfo, PeriodInfo periodInfo, Map<String, Object> extendParam, String checkDiffParamValue, Set<String> targetCompanyIds, CheckResult checkResult) throws Exception {
        HashSet<String> checkCompanyIds = new HashSet<String>();
        if (targetCompanyIds != null) {
            checkCompanyIds.addAll(targetCompanyIds);
        }
        checkCompanyIds.add(fullOrgUnitInfo.getId().toString());
        Map<String, Map<String, String>>[] noPassCompanys = ToleranceUtil.getInstance().batchCheckToleranceForGLClosePeriod(ctx, checkCompanyIds, periodInfo.getPeriodYear(), periodInfo.getPeriodNumber());
        if (noPassCompanys != null && noPassCompanys.length >= 3) {
            Map<String, Map<String, String>> noPassOneTolerCompany = noPassCompanys[0];
            Map<String, Map<String, String>> noPassAllTolerCompany = noPassCompanys[1];
            Map<String, Map<String, String>> noPassDiffCompany = noPassCompanys[2];
            if (!(noPassOneTolerCompany.isEmpty() && noPassAllTolerCompany.isEmpty() && noPassDiffCompany.isEmpty())) {
                checkResult.setStatusCode(ResultStatusCode.FAILD);
                StringBuffer msg = new StringBuffer();
                for (String companyId : noPassOneTolerCompany.keySet()) {
                    Map<String, String> oneTolerSubMap = noPassOneTolerCompany.get(companyId);
                    this.buildTolerMsg(ctx, oneTolerSubMap, msg, false);
                    Map<String, String> allTolerSubMap = noPassAllTolerCompany.get(companyId);
                    if (allTolerSubMap == null || allTolerSubMap.isEmpty()) continue;
                    this.buildTolerMsg(ctx, allTolerSubMap, msg, true);
                }
                for (String companyId : noPassAllTolerCompany.keySet()) {
                    if (noPassOneTolerCompany.containsKey(companyId)) continue;
                    Map<String, String> allTolerSubMap = noPassAllTolerCompany.get(companyId);
                    this.buildTolerMsg(ctx, allTolerSubMap, msg, true);
                }
                boolean isAppendHead = false;
                for (String companyId : noPassDiffCompany.keySet()) {
                    if (noPassOneTolerCompany.containsKey(companyId) || noPassAllTolerCompany.containsKey(companyId)) continue;
                    if (this.existCompanyDiffMsg == null) {
                        this.existCompanyDiffMsg = AccountCheckUtil.getResourceString(ctx, "562_existCompanyDiff", null);
                    }
                    if (this.companyNameMsg == null) {
                        this.companyNameMsg = AccountCheckUtil.getResourceString(ctx, "563_checkCompanyName", null);
                    }
                    if (!isAppendHead) {
                        msg.append("\n").append(this.existCompanyDiffMsg).append("\n");
                        isAppendHead = true;
                    }
                    Map<String, String> companyDiffSubMap = noPassDiffCompany.get(companyId);
                    for (String companyName : companyDiffSubMap.keySet()) {
                        msg.append(this.companyNameMsg).append(companyName).append("\n");
                        msg.append(companyDiffSubMap.get(companyName)).append("\n");
                        msg.append("\n");
                    }
                }
                checkResult.setMessage("\n" + msg.toString());
            }
        }
    }

    private void buildTolerMsg(Context ctx, Map<String, String> tolerSubMap, StringBuffer msg, boolean isAllToler) throws Exception {
        if (isAllToler) {
            if (this.checkAllDiffBigTolerMsgFormat == null) {
                String checkAllDiffBigTolerMsgRes = AccountCheckUtil.getResourceString(ctx, "561_checkAllDiffBigToler", null);
                this.checkAllDiffBigTolerMsgFormat = new MessageFormat(checkAllDiffBigTolerMsgRes);
            }
        } else if (this.checkOneDiffBigTolerMsgFormat == null) {
            String checkOneDiffBigTolerMsgRes = AccountCheckUtil.getResourceString(ctx, "560_checkOneDiffBigToler", null);
            this.checkOneDiffBigTolerMsgFormat = new MessageFormat(checkOneDiffBigTolerMsgRes);
        }
        for (String companyName : tolerSubMap.keySet()) {
            msg.append("\n");
            msg.append((isAllToler ? this.checkAllDiffBigTolerMsgFormat : this.checkOneDiffBigTolerMsgFormat).format(new Object[]{companyName})).append("\n");
            msg.append(tolerSubMap.get(companyName)).append("\n");
        }
    }

    public Set<String> getTargetCompanyIds(Context ctx, FullOrgUnitInfo fullOrgUnitInfo, PeriodInfo periodInfo, Map<String, Object> extendParam, String checkDiffParamValue) throws Exception {
        boolean isCheck2Company = "2".equals(checkDiffParamValue);
        HashSet<String> targetCompanyIds = null;
        if (!isCheck2Company) {
            targetCompanyIds = new HashSet<String>();
            return targetCompanyIds;
        }
        SQLBuilder sql = new SQLBuilder();
        Locale locale = ctx.getLocale();
        sql.append(" select item.FOrgUnitId from t_bas_param param ");
        sql.append(" inner join t_bas_paramItem item on param.fid=item.fkeyid ");
        sql.append(" where param.fnumber=?", this.paramNumber);
        sql.append(" and item.fvalue_").append(locale).append(" in ('1','2') ");
        sql.append(" and item.FOrgUnitId in (");
        sql.append("   select distinct ftargetCompanyId companyId from t_csl_checkagebill ");
        sql.append("   where FYear=? ", periodInfo.getPeriodYear());
        sql.append("   and FPeriod=? ", periodInfo.getPeriodNumber());
        sql.append("   and FCompanyId=? ", fullOrgUnitInfo.getId().toString());
        sql.append("   union select distinct fCompanyId companyId from t_csl_checkagebill ");
        sql.append("   where FYear=? ", periodInfo.getPeriodYear());
        sql.append("   and FPeriod=? ", periodInfo.getPeriodNumber());
        sql.append("   and ftargetCompanyId=? ", fullOrgUnitInfo.getId().toString());
        sql.append("   ) ");
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        targetCompanyIds = new HashSet();
        while (rowSet.next()) {
            targetCompanyIds.add(rowSet.getString("FOrgUnitId"));
        }
        return targetCompanyIds;
    }

    public void checkCheckageDataChanged(Context ctx, FullOrgUnitInfo fullOrgUnitInfo, PeriodInfo periodInfo, Map<String, Object> extendParam, String checkDiffParamValue, Set<String> targetCompanyIds, CheckResult checkResult) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        targetCompanyIds.add(fullOrgUnitInfo.getId().toString());
        sql.append(" select FCompanyId,max(FLastGetDataTime) FLastGetDataTime from T_Csl_CheckageOrgPack where FCompanyId in ", targetCompanyIds);
        sql.append(" and FYear=? ", periodInfo.getPeriodYear());
        sql.append(" and FPeriod=? ", periodInfo.getPeriodNumber());
        sql.append(" group by FCompanyId ");
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        HashMap<String, Time> checkageData = new HashMap<String, Time>();
        while (rowSet.next()) {
            checkageData.put(rowSet.getString("FCompanyId"), rowSet.getTime("FLastGetDataTime"));
        }
        if (!checkageData.isEmpty()) {
            sql.reset();
            String lang = ctx.getLocale().getLanguage();
            sql.append(" select max(voucher.flastupdatetime) lastUpdateTime,voucher.fcompanyid,unit.fname_").append(lang).append(" orgUnit ");
            sql.append(" from t_gl_voucher voucher ");
            sql.append(" inner join t_org_baseunit unit on unit.fid=voucher.fcompanyid");
            sql.append(" where voucher.fcompanyid in ", checkageData.keySet());
            sql.append(" and voucher.fperiodid=? ", periodInfo.getId().toString());
            sql.append(" group by voucher.fcompanyid,unit.fname_").append(lang);
            rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            StringBuffer msg = new StringBuffer();
            while (rowSet.next()) {
                String companyId = rowSet.getString("fcompanyid");
                Time lastUpdateTime = rowSet.getTime("lastUpdateTime");
                Time checkageTime = (Time)checkageData.get(companyId);
                if (checkageTime == null || !checkageTime.before(lastUpdateTime)) continue;
                if (msg.length() <= 0) {
                    msg.append(AccountCheckUtil.getResourceString(ctx, "458checkDataChanged", null));
                }
                msg.append(rowSet.getString("orgUnit")).append("\r\n");
            }
            if (msg.length() <= 0) {
                sql.reset();
                sql.append(" select distinct unit.fname_").append(lang).append(" orgUnit,unit.fnumber ");
                sql.append(" from T_Csl_CheckageBillCompany billCompany ");
                sql.append(" inner join T_Csl_CheckageBill bill on bill.FBillCompanyId=billCompany.fid ");
                sql.append(" inner join t_org_baseunit unit on unit.fid=bill.fcompanyid ");
                sql.append(" where bill.fcompanyid in ", checkageData.keySet());
                sql.append(" and bill.fyear=? ", periodInfo.getPeriodYear());
                sql.append(" and bill.fperiod=? ", periodInfo.getPeriodNumber());
                sql.append(" and billCompany.fconfirmstatus=? ", 1);
                sql.append(" and billCompany.ftag=1 ");
                sql.append(" order by unit.fnumber ");
                rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                while (rowSet.next()) {
                    String orgUnitName = rowSet.getString("orgUnit");
                    if (msg.length() <= 0) {
                        msg.append(AccountCheckUtil.getResourceString(ctx, "550_confirmDataChanged", null));
                    }
                    msg.append("[").append(orgUnitName).append("]\r\n");
                }
            }
            if (msg.length() > 0) {
                checkResult.setStatusCode(ResultStatusCode.FAILD);
                checkResult.setMessage("\n" + msg.toString());
            }
        }
    }
}

