/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeSysEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportServiceFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccessRecordFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccessRecordInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AccessReportFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccessReportInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.BalTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillDataCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillDataInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageOrgPackInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.DataSourceEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.MappingRecordFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.MappingRecordInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.app.AbstractQueryCheckageDataFacadeControllerBean;
import com.kingdee.eas.fi.newrpt.accountcheck.app.querycheckagedata.IQueryBalance;
import com.kingdee.eas.fi.newrpt.accountcheck.app.querycheckagedata.QueryBalanceFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.app.querycheckagedata.QueryBalanceUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.app.querycheckagedata.QueryCheckageAccounts;
import com.kingdee.eas.fi.newrpt.accountcheck.app.querycheckagedata.QueryCheckageCompanys;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.batch.log.LogService;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.util.CachingMap;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.FillSheetAssistant;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.fi.rpt.util.InterAndExchFormulaParse;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class QueryCheckageDataFacadeControllerBean
extends AbstractQueryCheckageDataFacadeControllerBean {
    private static final long serialVersionUID = -1138536461846780798L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.accountcheck.app.QueryCheckageDataFacadeControllerBean");
    private Map preAcctPeriodCache = new CachingMap();
    private Map nextPeriodCache = new CachingMap();
    private LogService logService;

    @Override
    protected String _queryCheckageData(Context ctx, Map params) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        this.logService = new LogService(logger, DebugLogger.isDebug);
        this.logService.addLogItem("DZPT: QueryCheckageData", "-------------start-------------");
        StringBuffer message = new StringBuffer();
        int year = Integer.valueOf(String.valueOf(params.get("year")));
        int period = Integer.valueOf(String.valueOf(params.get("period")));
        String currencyId = String.valueOf(params.get("currencyId"));
        String userId = ctx.getCaller().toString();
        ItemTypeEnum itemTypeEnum = ItemTypeEnum.account;
        if (params.containsKey("itemTypeEnum")) {
            itemTypeEnum = (ItemTypeEnum)((Object)params.get("itemTypeEnum"));
        }
        if (params.containsKey("userId")) {
            userId = String.valueOf(params.get("userId"));
        }
        HashSet<String> orgIds = null;
        if (params.containsKey("orgIds")) {
            orgIds = (HashSet<String>)params.get("orgIds");
        }
        String companyId = null;
        if (params.containsKey("companyId")) {
            companyId = (String)params.get("companyId");
            if (orgIds == null) {
                orgIds = new HashSet<String>();
                orgIds.add(companyId);
            }
        }
        boolean isFromImport = Boolean.valueOf(String.valueOf(params.get("isFromImport")));
        QueryCheckageCompanys queryCheckageCompanys = new QueryCheckageCompanys(ctx, userId, year, period);
        ArrayList<String> companyIds = new ArrayList<String>();
        ArrayList<String> enableCompanyIds = new ArrayList();
        HashMap<String, Boolean> includeUnPosteds = new HashMap();
        Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeAccountIds = null;
        Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeDeatilAccountIds = null;
        Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeAccountNumbers = null;
        Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeDeatilAccountNumbers = null;
        Map<String, Map<Integer, List<AccountViewInfo>>> companyIdbalTypeAccountViews = null;
        QueryCheckageAccounts queryCheckageAccounts = null;
        ParamTempTblService service = null;
        String companyTempTable = null;
        try {
            enableCompanyIds = queryCheckageCompanys.getCheckageCompanys();
            includeUnPosteds = queryCheckageCompanys.getIncludeUnPosteds();
            companyIds.addAll(orgIds);
            if (companyIds != null && !companyIds.isEmpty()) {
                service = queryCheckageCompanys.getCheckageCompanysTempTable(companyIds);
                companyTempTable = service.getTmpTableName();
            }
            QueryBalanceUtil.removeCheckageBillData(ctx, isFromImport, 0, 0, companyTempTable, year, period, currencyId);
            QueryBalanceUtil.removeDeletedCheckageBillRecord(ctx, 0, 0, companyTempTable, year, period, currencyId);
            Map<String, PeriodInfo> curPeriods = this.getCurrentPeriods(ctx, companyTempTable);
            Map<String, PeriodInfo> acctPeriods = this.getAcctPeriods(ctx, companyTempTable, year, period);
            queryCheckageAccounts = new QueryCheckageAccounts(ctx, companyTempTable, year, period);
            companyIdasstActTypeAccountIds = queryCheckageAccounts.getAsstActTypeAccountIds();
            companyIdasstActTypeAccountNumbers = queryCheckageAccounts.getAsstActTypeAccountNumbers();
            companyIdasstActTypeDeatilAccountIds = queryCheckageAccounts.getAsstActTypeDetailAccountIds();
            companyIdasstActTypeDeatilAccountNumbers = queryCheckageAccounts.getAsstActTypeDetailAccountNumbers();
            companyIdbalTypeAccountViews = queryCheckageAccounts.getAccountByBalType();
            if ((companyIdasstActTypeAccountIds == null || companyIdasstActTypeAccountIds.isEmpty()) && (companyIdasstActTypeDeatilAccountIds == null || companyIdasstActTypeDeatilAccountIds.isEmpty())) {
                logger.error((Object)"DZPT: Checkage Account Is Not Exist!");
                String string = null;
                return string;
            }
            List<Boolean> status = this.getIsIncludeUnPostedStatus();
            List<String> keys = QueryBalanceUtil.getDeletedChekageRecord(ctx, 0, year, period, currencyId, 0);
            this.getCheckageBillData(ctx, message, year, period, currencyId, itemTypeEnum, isFromImport, companyIds, enableCompanyIds, includeUnPosteds, companyIdasstActTypeAccountIds, companyIdasstActTypeDeatilAccountIds, companyIdasstActTypeAccountNumbers, companyIdasstActTypeDeatilAccountNumbers, companyIdbalTypeAccountViews, queryCheckageAccounts, curPeriods, acctPeriods, status, keys);
            long endTime = System.currentTimeMillis();
            this.logService.addLogItem("DZPT: QueryCheckageDataSpanTime: ", String.valueOf(endTime - startTime) + "-------------end-------------");
            this.logService.addLogItem("DZPT: QueryCheckageData", "-------------end-------------");
            this.logService.logIt();
            this.logService.reset();
        }
        catch (Exception e) {
            logger.error((Object)"DZPT: _queryCheckageData: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (service != null) {
                service.release();
            }
            companyTempTable = null;
            this.nextPeriodCache.clear();
            this.preAcctPeriodCache.clear();
        }
        return message.toString();
    }

    private void getCheckageBillData(final Context ctx, StringBuffer message, final int year, final int period, final String currencyId, final ItemTypeEnum itemTypeEnum, final boolean isFromImport, List<String> companyIds, final List<String> enableCompanyIds, final Map<String, Boolean> includeUnPosteds, final Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeAccountIds, final Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeDeatilAccountIds, final Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeAccountNumbers, final Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeDeatilAccountNumbers, final Map<String, Map<Integer, List<AccountViewInfo>>> companyIdbalTypeAccountViews, final QueryCheckageAccounts queryCheckageAccounts, Map<String, PeriodInfo> curPeriods, Map<String, PeriodInfo> acctPeriods, final List<Boolean> status, final List<String> keys) throws Exception {
        final Timestamp nowTimest = new Timestamp(new Date().getTime());
        final CopyOnWriteArrayList<String> detailList = new CopyOnWriteArrayList<String>();
        String param = this.getBalacnceCslParams(ctx);
        int threadCount = Integer.valueOf(param);
        boolean isUseThread = false;
        if (companyIds.size() > 1) {
            isUseThread = true;
        }
        final AtomicInteger atomic = new AtomicInteger(0);
        for (final String company : companyIds) {
            final PeriodInfo currentPeriodInfo = curPeriods.get(company);
            if (currentPeriodInfo == null) {
                logger.error((Object)("DZPT: currentPeriodInfo Is Null! ComapnyId: " + company));
                continue;
            }
            final PeriodInfo acctPeriodInfo = acctPeriods.get(company);
            if (acctPeriodInfo == null) {
                logger.error((Object)("DZPT: acctPeriodInfo Is Null!  ComapnyId:" + company));
                continue;
            }
            if (isUseThread) {
                while (atomic.get() >= threadCount) {
                    Thread.sleep(50L);
                }
                Thread thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            long startTime = System.currentTimeMillis();
                            QueryCheckageDataFacadeControllerBean.this.exeSingleCompanyCheckageBillData(ctx, year, period, currencyId, includeUnPosteds, companyIdasstActTypeAccountIds, companyIdasstActTypeAccountNumbers, companyIdasstActTypeDeatilAccountIds, companyIdasstActTypeDeatilAccountNumbers, companyIdbalTypeAccountViews, queryCheckageAccounts, status, company, currentPeriodInfo, acctPeriodInfo, isFromImport, keys, detailList, nowTimest, itemTypeEnum, enableCompanyIds);
                            long endTime = System.currentTimeMillis();
                            QueryCheckageDataFacadeControllerBean.this.logService.addLogItem("DZPT: queryCheckageDataSingleCompanyId", new Object[]{company, " exeSingleCompanySpanTime: " + String.valueOf(startTime - endTime)});
                        }
                        catch (Exception e) {
                            logger.error((Object)" queryCheckageData thread error.", (Throwable)e);
                        }
                        finally {
                            atomic.addAndGet(-1);
                        }
                    }
                };
                atomic.addAndGet(1);
                thread.start();
                continue;
            }
            long startTime = System.currentTimeMillis();
            this.exeSingleCompanyCheckageBillData(ctx, year, period, currencyId, includeUnPosteds, companyIdasstActTypeAccountIds, companyIdasstActTypeAccountNumbers, companyIdasstActTypeDeatilAccountIds, companyIdasstActTypeDeatilAccountNumbers, companyIdbalTypeAccountViews, queryCheckageAccounts, status, company, currentPeriodInfo, acctPeriodInfo, isFromImport, keys, detailList, nowTimest, itemTypeEnum, enableCompanyIds);
            long endTime = System.currentTimeMillis();
            this.logService.addLogItem("DZPT: queryCheckageDataSingleCompanyId", new Object[]{company, " exeSingleCompanySpanTime: " + String.valueOf(startTime - endTime)});
        }
        if (isUseThread && atomic.get() > 0) {
            while (isUseThread && atomic.get() > 0) {
                Thread.sleep(100L);
            }
        }
        if (detailList != null && !detailList.isEmpty()) {
            String title = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"accountCheckageDataChangeDetail", (Locale)ctx.getOriginLocale());
            message.append(title).append(" \n ");
            for (String detail : detailList) {
                message.append(detail).append("\n");
            }
        }
    }

    private void exeSingleCompanyCheckageBillData(Context ctx, int year, int period, String currencyId, Map<String, Boolean> includeUnPosteds, Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeAccountIds, Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeAccountNumbers, Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeDeatilAccountIds, Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeDeatilAccountNumbers, Map<String, Map<Integer, List<AccountViewInfo>>> companyIdbalTypeAccountViews, QueryCheckageAccounts queryCheckageAccounts, List<Boolean> status, String company, PeriodInfo currentPeriodInfo, PeriodInfo acctPeriodInfo, boolean isFromImport, List<String> keys, List<String> detailList, Timestamp nowTimest, ItemTypeEnum itemTypeEnum, List<String> enableCompanyIds) throws Exception {
        this.writeOrgPackInfo(ctx, nowTimest, year, period, currencyId, company, itemTypeEnum);
        CheckageBillDataCollection checkageBillDataCollection = new CheckageBillDataCollection();
        AtomicInteger calAtomic = new AtomicInteger(0);
        boolean isUseThread = this.getNotDetailData(ctx, year, period, currencyId, includeUnPosteds, companyIdasstActTypeAccountIds, companyIdasstActTypeAccountNumbers, companyIdbalTypeAccountViews, queryCheckageAccounts, status, company, checkageBillDataCollection, currentPeriodInfo, acctPeriodInfo, calAtomic, companyIdasstActTypeDeatilAccountIds);
        this.getDetailData(ctx, year, period, currencyId, includeUnPosteds, companyIdasstActTypeDeatilAccountIds, companyIdasstActTypeDeatilAccountNumbers, companyIdbalTypeAccountViews, queryCheckageAccounts, status, company, checkageBillDataCollection, currentPeriodInfo, acctPeriodInfo, companyIdasstActTypeAccountIds);
        if (isUseThread && calAtomic.get() > 0) {
            while (calAtomic.get() > 0) {
                Thread.sleep(100L);
            }
        }
        QueryBalanceUtil.removeDisabledCompanyCheckageData(enableCompanyIds, checkageBillDataCollection);
        QueryBalanceUtil.removeExistsCheckageBillData(ctx, 0, company, currencyId, year, period, checkageBillDataCollection);
        QueryBalanceUtil.removeWrongStatusChekageData(includeUnPosteds, checkageBillDataCollection);
        QueryBalanceUtil.removeDeletedChekageData(ctx, keys, checkageBillDataCollection);
        QueryBalanceUtil.removeCheckageBillDataByImportRecord(ctx, 0, isFromImport, company, currencyId, year, period, checkageBillDataCollection);
        List<String> msgList = QueryBalanceUtil.removeCheckageBillDataByConfirmedData(ctx, 0, 0, company, currencyId, year, period, checkageBillDataCollection);
        if (msgList != null && !msgList.isEmpty()) {
            if (detailList != null && !detailList.isEmpty()) {
                for (String n : msgList) {
                    if (detailList.contains(n)) continue;
                    detailList.add(n);
                }
            } else {
                detailList.addAll(msgList);
            }
        }
        QueryBalanceUtil.insertCheckageBillData(ctx, ItemTypeEnum.account, DataSourceEnum.glSystem, company, checkageBillDataCollection);
    }

    private void getDetailData(final Context ctx, final int year, final int period, final String currencyId, final Map<String, Boolean> includeUnPosteds, final Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeDeatilAccountIds, final Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeDeatilAccountNumbers, final Map<String, Map<Integer, List<AccountViewInfo>>> companyIdbalTypeAccountViews, final QueryCheckageAccounts queryCheckageAccounts, final List<Boolean> status, final String company, final CheckageBillDataCollection checkageBillDataCollection, final PeriodInfo currentPeriodInfo, final PeriodInfo acctPeriodInfo, Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeAccountIds) throws Exception {
        boolean isUseThread = this.isHasData(companyIdasstActTypeAccountIds, company);
        final AtomicInteger atomic = new AtomicInteger(0);
        if (companyIdasstActTypeDeatilAccountIds != null && !companyIdasstActTypeDeatilAccountIds.isEmpty() && companyIdasstActTypeDeatilAccountIds.containsKey(company)) {
            if (isUseThread) {
                Thread thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            long startTime = System.currentTimeMillis();
                            QueryCheckageDataFacadeControllerBean.this.getDetailBalanceData(ctx, year, period, currencyId, includeUnPosteds, companyIdasstActTypeDeatilAccountIds, companyIdasstActTypeDeatilAccountNumbers, companyIdbalTypeAccountViews, queryCheckageAccounts, status, company, checkageBillDataCollection, currentPeriodInfo, acctPeriodInfo);
                            long endTime = System.currentTimeMillis();
                            QueryCheckageDataFacadeControllerBean.this.logService.addLogItem("DZPT: getDetailBalanceDataCompanyId", new Object[]{company, " getNotDetailBalanceDataSpanTime: " + String.valueOf(startTime - endTime)});
                        }
                        catch (Exception e) {
                            logger.error((Object)" getDetailBalanceData thread error.", (Throwable)e);
                        }
                        finally {
                            atomic.addAndGet(-1);
                        }
                    }
                };
                atomic.addAndGet(1);
                thread.start();
            } else {
                long startTime = System.currentTimeMillis();
                this.getDetailBalanceData(ctx, year, period, currencyId, includeUnPosteds, companyIdasstActTypeDeatilAccountIds, companyIdasstActTypeDeatilAccountNumbers, companyIdbalTypeAccountViews, queryCheckageAccounts, status, company, checkageBillDataCollection, currentPeriodInfo, acctPeriodInfo);
                long endTime = System.currentTimeMillis();
                this.logService.addLogItem("DZPT: getDetailBalanceDataCompanyId", new Object[]{company, " getNotDetailBalanceDataSpanTime: " + String.valueOf(startTime - endTime)});
            }
            if (isUseThread && atomic.get() > 0) {
                while (atomic.get() > 0) {
                    Thread.sleep(100L);
                }
            }
        }
    }

    private void getDetailBalanceData(Context ctx, int year, int period, String currencyId, Map<String, Boolean> includeUnPosteds, Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeDeatilAccountIds, Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeDeatilAccountNumbers, Map<String, Map<Integer, List<AccountViewInfo>>> companyIdbalTypeAccountViews, QueryCheckageAccounts queryCheckageAccounts, List<Boolean> status, String company, CheckageBillDataCollection checkageBillDataCollection, PeriodInfo currentPeriodInfo, PeriodInfo acctPeriodInfo) throws Exception {
        Map<Integer, List<AccountViewInfo>> balTypeAccountViews = companyIdbalTypeAccountViews.get(company);
        Map<String, Map<String, List<String>>> asstActTypeDeatilAccountIds = companyIdasstActTypeDeatilAccountIds.get(company);
        Map<String, Map<String, List<String>>> asstActTypeDeatilAccountNumbers = companyIdasstActTypeDeatilAccountNumbers.get(company);
        boolean isIncludePosted = false;
        if (!includeUnPosteds.isEmpty()) {
            isIncludePosted = includeUnPosteds.get(company);
        }
        this.queryBalanceData(ctx, isIncludePosted, status, true, year, period, currencyId, company, currentPeriodInfo, acctPeriodInfo, queryCheckageAccounts, asstActTypeDeatilAccountIds, asstActTypeDeatilAccountNumbers, balTypeAccountViews, checkageBillDataCollection);
    }

    private boolean getNotDetailData(final Context ctx, final int year, final int period, final String currencyId, final Map<String, Boolean> includeUnPosteds, final Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeAccountIds, final Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeAccountNumbers, final Map<String, Map<Integer, List<AccountViewInfo>>> companyIdbalTypeAccountViews, final QueryCheckageAccounts queryCheckageAccounts, final List<Boolean> status, final String company, final CheckageBillDataCollection checkageBillDataCollection, final PeriodInfo currentPeriodInfo, final PeriodInfo acctPeriodInfo, final AtomicInteger atomic, Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeDeatilAccountIds) throws Exception {
        boolean isUseThread = this.isHasData(companyIdasstActTypeDeatilAccountIds, company);
        if (companyIdasstActTypeAccountIds != null && !companyIdasstActTypeAccountIds.isEmpty() && companyIdasstActTypeAccountIds.containsKey(company)) {
            if (isUseThread) {
                Thread thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            long startTime = System.currentTimeMillis();
                            QueryCheckageDataFacadeControllerBean.this.getNotDetailBalanceData(ctx, year, period, currencyId, includeUnPosteds, companyIdasstActTypeAccountIds, companyIdasstActTypeAccountNumbers, companyIdbalTypeAccountViews, queryCheckageAccounts, status, company, checkageBillDataCollection, currentPeriodInfo, acctPeriodInfo);
                            long endTime = System.currentTimeMillis();
                            QueryCheckageDataFacadeControllerBean.this.logService.addLogItem("DZPT: getNotDetailBalanceDataCompanyId", new Object[]{company, " getNotDetailBalanceDataSpanTime: " + String.valueOf(startTime - endTime)});
                        }
                        catch (Exception e) {
                            logger.error((Object)" getNotDetailBalanceData thread error.", (Throwable)e);
                        }
                        finally {
                            atomic.addAndGet(-1);
                        }
                    }
                };
                atomic.addAndGet(1);
                thread.start();
            } else {
                long startTime = System.currentTimeMillis();
                this.getNotDetailBalanceData(ctx, year, period, currencyId, includeUnPosteds, companyIdasstActTypeAccountIds, companyIdasstActTypeAccountNumbers, companyIdbalTypeAccountViews, queryCheckageAccounts, status, company, checkageBillDataCollection, currentPeriodInfo, acctPeriodInfo);
                long endTime = System.currentTimeMillis();
                this.logService.addLogItem("DZPT: getNotDetailBalanceDataCompanyId", new Object[]{company, " getNotDetailBalanceDataSpanTime: " + String.valueOf(startTime - endTime)});
            }
        }
        return isUseThread;
    }

    private boolean isHasData(Map<String, Map<String, Map<String, List<String>>>> companyIdToAccountIds, String company) {
        return companyIdToAccountIds != null && !companyIdToAccountIds.isEmpty() && companyIdToAccountIds.containsKey(company);
    }

    private void getNotDetailBalanceData(Context ctx, int year, int period, String currencyId, Map<String, Boolean> includeUnPosteds, Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeAccountIds, Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeAccountNumbers, Map<String, Map<Integer, List<AccountViewInfo>>> companyIdbalTypeAccountViews, QueryCheckageAccounts queryCheckageAccounts, List<Boolean> status, String company, CheckageBillDataCollection checkageBillDataCollection, PeriodInfo currentPeriodInfo, PeriodInfo acctPeriodInfo) throws Exception {
        Map<Integer, List<AccountViewInfo>> balTypeAccountViews = companyIdbalTypeAccountViews.get(company);
        Map<String, Map<String, List<String>>> asstActTypeAccountIds = companyIdasstActTypeAccountIds.get(company);
        Map<String, Map<String, List<String>>> asstActTypeAccountNumbers = companyIdasstActTypeAccountNumbers.get(company);
        boolean isIncludePosted = false;
        if (!includeUnPosteds.isEmpty()) {
            isIncludePosted = includeUnPosteds.get(company);
        }
        this.queryBalanceData(ctx, isIncludePosted, status, false, year, period, currencyId, company, currentPeriodInfo, acctPeriodInfo, queryCheckageAccounts, asstActTypeAccountIds, asstActTypeAccountNumbers, balTypeAccountViews, checkageBillDataCollection);
    }

    private void writeOrgPackInfo(Context ctx, Timestamp nowTimest, int year, int period, String currencyId, String company, ItemTypeEnum itemTypeEnum) {
        try {
            SQLBuilder sql = new SQLBuilder();
            sql.append("select top 1 Fid,FPackTime from T_Csl_CheckageOrgPack \n");
            sql.append("where FYear=?    \n", year);
            sql.append("and FPeriod=?    \n", period);
            sql.append("and FCurrencyId=?  \n", currencyId);
            sql.append("and FCompanyId=?  \n", company);
            sql.append("and FItemType=?  \n", itemTypeEnum.getValue());
            sql.append("order by FPackTime desc");
            IRowSet row = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            if (row == null || row.size() < 1) {
                sql.reset();
                sql.append("insert into T_Csl_CheckageOrgPack(FYear,FPeriod,FCurrencyId,FCompanyId,FPackTime,FItemType,Fid,FLastGetDataTime) values(?,?,?,?,?,?,?,?)");
                DbUtil.execute(ctx, sql.getSQL(), new Object[]{year, period, currencyId, company, nowTimest, itemTypeEnum.getValue(), BOSUuid.create((BOSObjectType)new CheckageOrgPackInfo().getBOSType()).toString(), nowTimest});
            } else {
                sql.reset();
                sql.append(" update T_Csl_CheckageOrgPack set FLastGetDataTime=?", nowTimest);
                sql.append("where FYear=?    \n", year);
                sql.append("and FPeriod=?    \n", period);
                sql.append("and FCurrencyId=?  \n", currencyId);
                sql.append("and FCompanyId=?  \n", company);
                sql.append("and FItemType=?  \n", itemTypeEnum.getValue());
                DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
            }
        }
        catch (Exception e) {
            logger.error((Object)"writeOrgPackInfo error.", (Throwable)e);
        }
    }

    private List<Boolean> getIsIncludeUnPostedStatus() {
        ArrayList<Boolean> status = new ArrayList<Boolean>();
        status.add(Boolean.TRUE);
        status.add(Boolean.FALSE);
        return status;
    }

    private int[] setMultiUnPostedPeriod(Context ctx, String balTypeString, PeriodInfo currentPeriodInfo, PeriodInfo acctPeriodInfo, int year, int period) throws EASBizException, BOSException {
        int[] yearPeriod = new int[4];
        int startYear = year;
        int startPeriod = period;
        int endYear = year;
        int endPeriod = period;
        if (balTypeString.equals("C")) {
            PeriodInfo prePeriod = this.getPreAcctPeriodInfo(ctx, acctPeriodInfo);
            startYear = currentPeriodInfo.getPeriodYear();
            startPeriod = currentPeriodInfo.getPeriodNumber();
            endYear = prePeriod.getPeriodYear();
            endPeriod = prePeriod.getPeriodNumber();
        } else if ((balTypeString.equals("JL_DL") || balTypeString.equals("SL")) && year > currentPeriodInfo.getPeriodYear()) {
            startYear = year;
            startPeriod = 1;
            endYear = year;
            endPeriod = period;
        } else {
            PeriodInfo nextPeriod = this.getNextPeriodInfo(ctx, currentPeriodInfo);
            startYear = nextPeriod.getPeriodYear();
            startPeriod = nextPeriod.getPeriodNumber();
            endYear = year;
            endPeriod = period;
        }
        yearPeriod[0] = startYear;
        yearPeriod[1] = startPeriod;
        yearPeriod[2] = endYear;
        yearPeriod[3] = endPeriod;
        return yearPeriod;
    }

    public boolean isMultiUnPosted(PeriodInfo currentPeriodInfo, int year, int period) {
        return year > currentPeriodInfo.getPeriodYear() || year == currentPeriodInfo.getPeriodYear() && period > currentPeriodInfo.getPeriodNumber();
    }

    private PeriodInfo getPreAcctPeriodInfo(Context ctx, PeriodInfo currentPeriodInfo) throws EASBizException, BOSException {
        String currentPeriodId = currentPeriodInfo.getId().toString();
        PeriodInfo period = (PeriodInfo)this.preAcctPeriodCache.get(currentPeriodId);
        if (period == null) {
            period = PeriodUtils.getPrePeriodInfo((Context)ctx, (IObjectPK)new ObjectStringPK(currentPeriodId));
            this.preAcctPeriodCache.put(currentPeriodId, period);
        }
        return period;
    }

    private PeriodInfo getNextPeriodInfo(Context ctx, PeriodInfo currentPeriodInfo) throws EASBizException, BOSException {
        String currentPeriodId = currentPeriodInfo.getId().toString();
        PeriodInfo period = (PeriodInfo)this.nextPeriodCache.get(currentPeriodId);
        if (period == null) {
            period = PeriodUtils.getNextPeriodInfo((Context)ctx, (IObjectPK)new ObjectStringPK(currentPeriodId));
            this.nextPeriodCache.put(currentPeriodId, period);
        }
        return period;
    }

    private Map<String, PeriodInfo> getCurrentPeriods(Context ctx, String companyTempTable) throws Exception {
        HashMap<String, PeriodInfo> periods = new HashMap<String, PeriodInfo>();
        StringBuffer sql = new StringBuffer();
        sql.append(" Select period.Fid id, period.FPeriodYear year, period.FPeriodNumber period, ssc.FCompanyID companyId \n");
        sql.append(" From T_BD_SystemStatusCtrol ssc \n");
        sql.append(" Inner Join T_BD_SystemStatus ss On ssc.FSystemStatusID = ss.Fid \n");
        sql.append(" Inner Join T_BD_Period period On ssc.FCurrentPeriodID = period.Fid \n");
        sql.append(" Inner join ").append(companyTempTable).append(" tempTable On ssc.FCompanyID = tempTable.FCompanyID \n");
        sql.append(" Where ss.FName = ? \n");
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(new Integer(SystemEnum.GENERALLEDGER.getValue()));
        IRowSet iRowSet = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
        while (iRowSet.next()) {
            PeriodInfo periodInfo = new PeriodInfo();
            periodInfo.setId(BOSUuid.read((String)iRowSet.getString("id")));
            periodInfo.setPeriodYear(iRowSet.getInt("year"));
            periodInfo.setPeriodNumber(iRowSet.getInt("period"));
            String company = iRowSet.getString("companyId");
            periods.put(company, periodInfo);
        }
        return periods;
    }

    private Map<String, PeriodInfo> getAcctPeriods(Context ctx, String companyTempTable, int year, int period) throws Exception {
        HashMap<String, PeriodInfo> periods = new HashMap<String, PeriodInfo>();
        StringBuffer sql = new StringBuffer();
        sql.append("Select period.Fid id, period.FPeriodYear year, period.FPeriodNumber period, company.Fid companyId \n");
        sql.append("From T_bd_Period period \n");
        sql.append("Inner join t_org_company company On company.FAccountPeriodID = period.FTypeID \n");
        sql.append("Inner join ").append(companyTempTable).append(" tempTable On tempTable.FCompanyId = company.Fid \n");
        sql.append("Where period.FPeriodYear = ? And period.FPeriodNumber = ? ");
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(year);
        params.add(period);
        IRowSet iRowSet = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
        while (iRowSet.next()) {
            PeriodInfo periodInfo = new PeriodInfo();
            periodInfo.setId(BOSUuid.read((String)iRowSet.getString("id")));
            periodInfo.setPeriodYear(iRowSet.getInt("year"));
            periodInfo.setPeriodNumber(iRowSet.getInt("period"));
            String company = iRowSet.getString("companyId");
            periods.put(company, periodInfo);
        }
        return periods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryBalanceData(Context ctx, boolean isIncludePosted, List<Boolean> postedStatus, boolean isDetailAccount, int year, int period, String currencyId, String companyId, PeriodInfo currentPeriodInfo, PeriodInfo acctPeriodInfo, QueryCheckageAccounts queryCheckageAccounts, Map<String, Map<String, List<String>>> balTypeAccountIds, Map<String, Map<String, List<String>>> balTypeAccountNumbers, Map<Integer, List<AccountViewInfo>> balTypeAccountViews, CheckageBillDataCollection CheckageBillDataCollection2) throws Exception {
        for (String balTypeString : balTypeAccountIds.keySet()) {
            int startYear = year;
            int startPeriod = period;
            int endYear = year;
            int endPeriod = period;
            boolean isMultiUnPosted = false;
            if ((balTypeString.equals("C") || balTypeString.equals("Y") || balTypeString.equals("SL") || balTypeString.equals("JL_DL")) && (isMultiUnPosted = this.isMultiUnPosted(currentPeriodInfo, year, period))) {
                int[] yearPeriod = this.setMultiUnPostedPeriod(ctx, balTypeString, currentPeriodInfo, acctPeriodInfo, year, period);
                startYear = yearPeriod[0];
                startPeriod = yearPeriod[1];
                endYear = yearPeriod[2];
                endPeriod = yearPeriod[3];
            }
            Map<String, List<String>> asstActTypeAccountIds = balTypeAccountIds.get(balTypeString);
            Map<String, List<String>> asstActTypeAccountNumbers = balTypeAccountNumbers.get(balTypeString);
            for (String actType : asstActTypeAccountIds.keySet()) {
                try {
                    List<String> accountIds = asstActTypeAccountIds.get(actType);
                    String accountTempTable = queryCheckageAccounts.getAccountTempTable(accountIds);
                    IQueryBalance iQueryBalance = QueryBalanceFactory.createInstance(ctx, isIncludePosted, isMultiUnPosted, isDetailAccount, currentPeriodInfo, startYear, startPeriod, endYear, endPeriod, currencyId, balTypeString, actType, companyId, accountTempTable);
                    IRowSet rowSet = iQueryBalance.queryOwnBalance();
                    CheckageBillDataCollection2.addCollection(QueryBalanceUtil.getCheckageBillDataCollection(ctx, true, rowSet, isIncludePosted, balTypeString, acctPeriodInfo.getPeriodYear(), acctPeriodInfo.getPeriodNumber(), currencyId, balTypeAccountViews));
                }
                finally {
                    queryCheckageAccounts.release();
                }
                try {
                    for (Boolean posted : postedStatus) {
                        List<String> accountNumbers = asstActTypeAccountNumbers.get(actType);
                        String accountTempTable = queryCheckageAccounts.getAccountTempTable(accountNumbers);
                        IQueryBalance iQueryBalance = QueryBalanceFactory.createInstance(ctx, posted, isMultiUnPosted, isDetailAccount, currentPeriodInfo, startYear, startPeriod, endYear, endPeriod, currencyId, balTypeString, actType, companyId, accountTempTable);
                        IRowSet rowSet = iQueryBalance.queryTargetBalance();
                        CheckageBillDataCollection2.addCollection(QueryBalanceUtil.getCheckageBillDataCollection(ctx, false, rowSet, posted, balTypeString, acctPeriodInfo.getPeriodYear(), acctPeriodInfo.getPeriodNumber(), currencyId, balTypeAccountViews));
                        queryCheckageAccounts.release();
                    }
                }
                finally {
                    queryCheckageAccounts.release();
                }
            }
        }
    }

    @Override
    protected String _queryFormulaCheckageData(Context ctx, Map params) throws BOSException, EASBizException {
        long time = System.currentTimeMillis();
        this.logService = new LogService(logger, DebugLogger.isDebug);
        this.logService.addLogItem("DZPT: QueryFormulaCheckageDataBegin", "-------------start-------------");
        StringBuffer message = new StringBuffer();
        int year = Integer.valueOf(String.valueOf(params.get("year")));
        int period = Integer.valueOf(String.valueOf(params.get("period")));
        String currencyId = String.valueOf(params.get("currencyId"));
        String userId = ctx.getCaller().toString();
        HashSet<String> orgIds = null;
        if (params.containsKey("orgIds")) {
            orgIds = (HashSet<String>)params.get("orgIds");
        }
        String companyId = null;
        if (params.containsKey("companyId")) {
            companyId = (String)params.get("companyId");
            if (orgIds == null) {
                orgIds = new HashSet<String>();
                orgIds.add(companyId);
            }
        }
        boolean isFromImport = Boolean.valueOf(String.valueOf(params.get("isFromImport")));
        ArrayList<String> companyIds = new ArrayList<String>();
        CopyOnWriteArrayList<String> enableCompanyIds = new CopyOnWriteArrayList();
        HashMap<String, Boolean> includeUnPosteds = new HashMap();
        HashMap<String, String> companyNumbers = new HashMap();
        HashMap<String, String> companyNames = new HashMap();
        HashMap<String, String> customerNumbers = new HashMap<String, String>();
        HashMap<String, String> providerNumbers = new HashMap<String, String>();
        QueryCheckageCompanys queryCheckageCompanys = new QueryCheckageCompanys(ctx, userId, year, period);
        ParamTempTblService service = null;
        String companyTempTable = null;
        try {
            companyIds.addAll(orgIds);
            if (companyIds != null && !companyIds.isEmpty()) {
                service = queryCheckageCompanys.getCheckageCompanysTempTable(companyIds);
                companyTempTable = service.getTmpTableName();
            }
            QueryBalanceUtil.removeCheckageBillData(ctx, isFromImport, 1, 4, companyTempTable, year, period, currencyId);
            QueryBalanceUtil.removeDeletedCheckageBillRecord(ctx, 1, 4, companyTempTable, year, period, currencyId);
            CheckageAccountCollection checkageAccounts = QueryBalanceUtil.getCheckageAccountWithFormula(ctx, companyIds);
            if (checkageAccounts == null || checkageAccounts.isEmpty()) {
                logger.error((Object)"DZPT: checkageAccounts is null");
                String string = null;
                return string;
            }
            this.logService.addLogItem("DZPT: OwnerCheckageCompany size: ", String.valueOf(companyIds.size()));
            this.logService.addLogItem("DZPT: CheckageAccount size: ", String.valueOf(checkageAccounts.size()));
            CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            enableCompanyIds = queryCheckageCompanys.getCheckageCompanys();
            includeUnPosteds = queryCheckageCompanys.getIncludeUnPosteds();
            companyNumbers = queryCheckageCompanys.getCompanyNumbers();
            companyNames = queryCheckageCompanys.getCompanyNames();
            List<String> keys = QueryBalanceUtil.getDeletedChekageRecord(ctx, 1, year, period, currencyId, 4);
            Timestamp nowTimest = new Timestamp(new Date().getTime());
            String customerActNumber = this.getCustomerActNumber(ctx);
            String providerActNumber = this.getProviderActNumber(ctx);
            this.getAsstNumbers(ctx, enableCompanyIds, customerNumbers, providerNumbers);
            FillSheetAssistant fillsheet = new FillSheetAssistant();
            String numberTitle = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"267_itemTitle", (Locale)ctx.getOriginLocale());
            String formulaTitle = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"268_accessTitle", (Locale)ctx.getOriginLocale());
            Map<String, PeriodInfo> curPeriods = this.getCurrentPeriods(ctx, companyTempTable);
            this.calFormula(ctx, message, year, period, currency, isFromImport, companyIds, enableCompanyIds, includeUnPosteds, companyNumbers, companyNames, customerNumbers, providerNumbers, checkageAccounts, keys, nowTimest, customerActNumber, providerActNumber, fillsheet, numberTitle, formulaTitle, curPeriods);
        }
        catch (Exception e) {
            logger.error((Object)"DZPT: _queryFormulaCheckageData: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (service != null) {
                service.release();
            }
            companyTempTable = null;
        }
        this.logService.addLogItem("DZPT: QueryFormulaCheckageDataSpanTime: ", String.valueOf(System.currentTimeMillis() - time));
        this.logService.addLogItem("DZPT: QueryFormulaCheckageData: ", "----------------------end---------------------");
        this.logService.logIt();
        this.logService.reset();
        return message.toString();
    }

    private void calFormula(final Context ctx, StringBuffer message, final int year, final int period, final CurrencyInfo currency, final boolean isFromImport, final List<String> companyIds, final List<String> enableCompanyIds, final Map<String, Boolean> includeUnPosteds, final Map<String, String> companyNumbers, final Map<String, String> companyNames, final Map<String, String> customerNumbers, final Map<String, String> providerNumbers, final CheckageAccountCollection checkageAccounts, final List<String> keys, final Timestamp nowTimest, final String customerActNumber, final String providerActNumber, final FillSheetAssistant fillsheet, final String numberTitle, final String formulaTitle, Map<String, PeriodInfo> curPeriods) throws Exception {
        final ArrayList<String> detailList = new ArrayList<String>();
        boolean isUseThread = false;
        final String[] params = this.getFormulaCslParams(ctx, "DZPT_SetThreadCountForGetCheckDataByFormula");
        if (companyIds.size() > 1) {
            isUseThread = true;
        }
        final AtomicInteger atomic = new AtomicInteger(0);
        int threadCount = Integer.valueOf(params[0]);
        for (final String company : companyIds) {
            PeriodInfo currentPeriodInfo = curPeriods.get(company);
            if (currentPeriodInfo == null) {
                logger.error((Object)("DZPT: currentPeriodInfo Is Null! ComapnyId: " + company));
                this.logService.addLogItem("DZPT: currentPeriodInfo Is Null! ComapnyId: ", company);
                continue;
            }
            if (isUseThread) {
                while (atomic.get() >= threadCount) {
                    Thread.sleep(50L);
                }
                atomic.addAndGet(1);
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            QueryCheckageDataFacadeControllerBean.this.calFormulaForSingleCompany(ctx, year, period, currency, isFromImport, companyIds, enableCompanyIds, includeUnPosteds, companyNumbers, companyNames, customerNumbers, providerNumbers, checkageAccounts, keys, nowTimest, customerActNumber, providerActNumber, fillsheet, detailList, numberTitle, formulaTitle, company, params);
                        }
                        catch (Exception e) {
                            logger.error((Object)" calTarCompanyFormula thread error.", (Throwable)e);
                        }
                        finally {
                            atomic.addAndGet(-1);
                        }
                    }
                };
                thread.start();
                continue;
            }
            this.calFormulaForSingleCompany(ctx, year, period, currency, isFromImport, companyIds, enableCompanyIds, includeUnPosteds, companyNumbers, companyNames, customerNumbers, providerNumbers, checkageAccounts, keys, nowTimest, customerActNumber, providerActNumber, fillsheet, detailList, numberTitle, formulaTitle, company, params);
        }
        if (isUseThread && atomic.get() > 0) {
            while (isUseThread && atomic.get() > 0) {
                Thread.sleep(100L);
            }
        }
        if (detailList != null && !detailList.isEmpty()) {
            for (String detail : detailList) {
                message.append(detail).append("\n");
            }
        }
    }

    private String[] getFormulaCslParams(Context ctx, String key) {
        String[] params = new String[2];
        String param = CSLParamUtil.getStringCslParamValue((Context)ctx, (String)key);
        if (param == null) {
            params[0] = "2";
            params[1] = "4";
        } else if (param.contains(",")) {
            params = param.split(",");
            if (params.length != 2) {
                params[0] = "2";
                params[1] = "4";
            }
        } else {
            params[0] = "2";
            params[1] = "4";
        }
        return params;
    }

    private String getBalacnceCslParams(Context ctx) {
        String param = CSLParamUtil.getStringCslParamValue((Context)ctx, (String)"DZPT_SetThreadCountForGetCheckDataByBalance");
        if (param == null) {
            param = "3";
        }
        return param;
    }

    private void calFormulaForSingleCompany(Context ctx, int year, int period, CurrencyInfo currency, boolean isFromImport, List<String> companyIds, List<String> enableCompanyIds, Map<String, Boolean> includeUnPosteds, Map<String, String> companyNumbers, Map<String, String> companyNames, Map<String, String> customerNumbers, Map<String, String> providerNumbers, CheckageAccountCollection checkageAccounts, List<String> keys, Timestamp nowTimest, String customerActNumber, String providerActNumber, FillSheetAssistant fillsheet, List<String> detailList, String numberTitle, String formulaTitle, String company, String[] params) throws Exception {
        this.logService.addLogItem("DZPT: OwnerCheckageCompany Id", company);
        String currencyId = currency.getId().toString();
        this.writeOrgPackInfo(ctx, nowTimest, year, period, currencyId, company, ItemTypeEnum.rptItem);
        ConcurrentHashMap<String, BigDecimal> values = new ConcurrentHashMap<String, BigDecimal>();
        ConcurrentHashMap<String, String> checkageItemNumbers = new ConcurrentHashMap<String, String>();
        CopyOnWriteArrayList<Map<String, String>> formulasBySeq = new CopyOnWriteArrayList<Map<String, String>>();
        ConcurrentHashMap<String, Map<String, String>> tarFormulas = new ConcurrentHashMap<String, Map<String, String>>();
        long startTime = System.currentTimeMillis();
        this.batchConstructFormula(ctx, year, period, currency, companyIds, enableCompanyIds, includeUnPosteds, companyNumbers, customerNumbers, providerNumbers, checkageAccounts, customerActNumber, providerActNumber, fillsheet, company, params, checkageItemNumbers, formulasBySeq, tarFormulas);
        long endTime = System.currentTimeMillis();
        this.logService.addLogItem("DZPT: OwnerCheckageCompanyId", new Object[]{company, "ConstructFormulasTotalSpanTime: " + String.valueOf(endTime - startTime)});
        startTime = System.currentTimeMillis();
        this.logService.addLogItem("DZPT: OwnerCheckageCompanyId", new Object[]{company, "GenCheckageBillDataBegin: -----------------start-----------------"});
        if (!formulasBySeq.isEmpty()) {
            AtomicInteger calAtomic = new AtomicInteger(0);
            this.calOwnerCompany(ctx, year, period, currency, companyNames, numberTitle, formulaTitle, company, includeUnPosteds, companyNumbers, values, checkageItemNumbers, formulasBySeq, tarFormulas, calAtomic);
            long tarComCalTimeStart = System.currentTimeMillis();
            this.calTarCompanyFormulas(ctx, year, period, company, currency, tarFormulas, checkageItemNumbers, values, companyNumbers, includeUnPosteds, numberTitle, formulaTitle, params);
            while (calAtomic.get() > 0) {
                Thread.sleep(100L);
            }
            long tarComCalTimeEnd = System.currentTimeMillis();
            this.logService.addLogItem("DZPT: OwnerCheckageCompanyId", new Object[]{company, "TarCalculateFormulasTotalSpanTime: " + String.valueOf(tarComCalTimeEnd - tarComCalTimeStart)});
            long exeTimeStart = System.currentTimeMillis();
            this.logService.addLogItem("DZPT: OwnerCheckageCompanyId", new Object[]{company, "ExeDataBegin: -----------------start-----------------"});
            CheckageBillDataCollection checkageBillDatas = this.getCheckageBillDatas(values);
            if (!checkageBillDatas.isEmpty()) {
                QueryBalanceUtil.removeDisabledCompanyCheckageData(enableCompanyIds, checkageBillDatas);
                QueryBalanceUtil.removeExistsCheckageBillData(ctx, 1, company, currencyId, year, period, checkageBillDatas);
                QueryBalanceUtil.removeWrongStatusChekageData(includeUnPosteds, checkageBillDatas);
                QueryBalanceUtil.removeDeletedChekageData(ctx, keys, checkageBillDatas);
                QueryBalanceUtil.removeCheckageBillDataByImportRecord(ctx, 1, isFromImport, company, currencyId, year, period, checkageBillDatas);
                List<String> msgList = QueryBalanceUtil.removeCheckageBillDataByConfirmedData(ctx, 1, 4, company, currencyId, year, period, checkageBillDatas);
                if (msgList != null && !msgList.isEmpty()) {
                    if (detailList != null && !detailList.isEmpty()) {
                        for (String n : msgList) {
                            if (detailList.contains(n)) continue;
                            detailList.add(n);
                        }
                    } else {
                        detailList.addAll(msgList);
                    }
                }
                QueryBalanceUtil.insertCheckageBillData(ctx, ItemTypeEnum.rptItem, DataSourceEnum.accessSetting, company, checkageBillDatas);
            }
            long exeTimeEnd = System.currentTimeMillis();
            this.logService.addLogItem("DZPT: OwnerCheckageCompanyId", new Object[]{company, "ExeDataSpanTime: " + String.valueOf(exeTimeEnd - exeTimeStart)});
            this.logService.addLogItem("DZPT: OwnerCheckageCompanyId", new Object[]{company, "ExeDataEnd: --------------end------------"});
        }
        endTime = System.currentTimeMillis();
        this.logService.addLogItem("DZPT: GenCheckageBillDataSpanTime", String.valueOf(endTime - startTime));
        this.logService.addLogItem("DZPT: OwnerCheckageCompanyId", new Object[]{company, "GenCheckageBillDataSpanTime: " + String.valueOf(endTime - startTime)});
        this.logService.addLogItem("DZPT: OwnerCheckageCompanyId", new Object[]{company, "GenCheckageBillDataEnd: -----------------end-----------------"});
    }

    private void calOwnerCompany(final Context ctx, final int year, final int period, final CurrencyInfo currency, final Map<String, String> companyNames, final String numberTitle, final String formulaTitle, final String company, final Map<String, Boolean> includeUnPosteds, final Map<String, String> companyNumbers, final Map<String, BigDecimal> values, final Map<String, String> checkageItemNumbers, final List<Map<String, String>> formulasBySeq, Map<String, Map<String, String>> tarFormulas, final AtomicInteger calAtomic) throws Exception {
        if (tarFormulas.size() > 1) {
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        long ownerComCalTimeStart = System.currentTimeMillis();
                        QueryCheckageDataFacadeControllerBean.this.calOwnerCompanyFormulas(ctx, year, period, currency, companyNames, includeUnPosteds, companyNumbers, formulasBySeq, checkageItemNumbers, values, company, numberTitle, formulaTitle);
                        long ownerComCalTimeEnd = System.currentTimeMillis();
                        QueryCheckageDataFacadeControllerBean.this.logService.addLogItem("DZPT: OwnerCheckageCompanyId", new Object[]{company, " CalculateFormulasSpanTime: " + String.valueOf(ownerComCalTimeEnd - ownerComCalTimeStart)});
                    }
                    catch (Exception e) {
                        logger.error((Object)" calOwnerCompanyFormulas thread error.", (Throwable)e);
                    }
                    finally {
                        calAtomic.addAndGet(-1);
                    }
                }
            };
            calAtomic.addAndGet(1);
            thread.start();
        } else {
            long ownerComCalTimeStart = System.currentTimeMillis();
            this.calOwnerCompanyFormulas(ctx, year, period, currency, companyNames, includeUnPosteds, companyNumbers, formulasBySeq, checkageItemNumbers, values, company, numberTitle, formulaTitle);
            long ownerComCalTimeEnd = System.currentTimeMillis();
            this.logService.addLogItem("DZPT: OwnerCheckageCompanyId", new Object[]{company, "CalculateFormulasSpanTime: " + String.valueOf(ownerComCalTimeEnd - ownerComCalTimeStart)});
        }
    }

    private void constructFormulasByThread(final Context ctx, final int year, final int period, final CurrencyInfo currency, final List<String> companyIds, final List<String> enableCompanyIds, final Map<String, Boolean> includeUnPosteds, final Map<String, String> companyNumbers, final Map<String, String> customerNumbers, final Map<String, String> providerNumbers, CheckageAccountCollection checkageAccounts, final String customerActNumber, final String providerActNumber, final FillSheetAssistant fillsheet, final String company, String[] params, final Map<String, String> checkageItemNumbers, final List<Map<String, String>> formulasBySeq, final Map<String, Map<String, String>> tarFormulas) throws Exception {
        boolean isUseThread = false;
        if (checkageAccounts.size() > 1) {
            isUseThread = true;
        }
        final AtomicInteger atomic = new AtomicInteger(0);
        int threadCount = Integer.valueOf(params[1]);
        int size = checkageAccounts.size();
        for (int i = 0; i < size; ++i) {
            final CheckageAccountInfo checkageAccount = checkageAccounts.get(i);
            if (isUseThread) {
                while (atomic.get() >= threadCount) {
                    Thread.sleep(50L);
                }
                atomic.addAndGet(1);
                Thread thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            long getDynItemDataStart = System.currentTimeMillis();
                            QueryCheckageDataFacadeControllerBean.this.constructFormula(ctx, year, period, currency, companyIds, enableCompanyIds, includeUnPosteds, companyNumbers, customerNumbers, providerNumbers, customerActNumber, providerActNumber, fillsheet, company, checkageItemNumbers, formulasBySeq, tarFormulas, checkageAccount, enableCompanyIds);
                            long getDynItemDataEnd = System.currentTimeMillis();
                            QueryCheckageDataFacadeControllerBean.this.logService.addLogItem("DZPT: OwnerCheckageCompanyId", new Object[]{company, "constructSingleFormulaSpanTime: " + String.valueOf(getDynItemDataEnd - getDynItemDataStart)});
                        }
                        catch (Exception e) {
                            logger.error((Object)" constructFormulas thread error.", (Throwable)e);
                        }
                        finally {
                            atomic.addAndGet(-1);
                        }
                    }
                };
                thread.start();
                continue;
            }
            long getDynItemDataStart = System.currentTimeMillis();
            this.constructFormula(ctx, year, period, currency, companyIds, enableCompanyIds, includeUnPosteds, companyNumbers, customerNumbers, providerNumbers, customerActNumber, providerActNumber, fillsheet, company, checkageItemNumbers, formulasBySeq, tarFormulas, checkageAccount, enableCompanyIds);
            long getDynItemDataEnd = System.currentTimeMillis();
            this.logService.addLogItem("DZPT: OwnerCheckageCompanyId", new Object[]{company, "constructSingleFormulaSpanTime: " + String.valueOf(getDynItemDataEnd - getDynItemDataStart)});
        }
        if (isUseThread && atomic.get() > 0) {
            while (isUseThread && atomic.get() > 0) {
                Thread.sleep(100L);
            }
        }
    }

    private void batchConstructFormula(Context ctx, int year, int period, CurrencyInfo currency, List<String> companyIds, List<String> enableCompanyIds, Map<String, Boolean> includeUnPosteds, Map<String, String> companyNumbers, Map<String, String> customerNumbers, Map<String, String> providerNumbers, CheckageAccountCollection checkageAccounts, String customerActNumber, String providerActNumber, FillSheetAssistant fillsheet, String company, String[] params, Map<String, String> checkageItemNumbers, List<Map<String, String>> formulasBySeq, Map<String, Map<String, String>> tarFormulas) throws Exception {
        String formulaId;
        CheckageAccountInfo checkageAccount;
        int i;
        ReportInfo reportInfo = this.initReportInfo(ctx, year, period, currency);
        String companyNumber = companyNumbers.get(company);
        this.setCompanyForReportInfo(company, companyNumber, reportInfo);
        OrgUnitInfo orgUnit = this.getOwnerOrgUnitInfo(company, companyNumber);
        boolean includePosted = includeUnPosteds.get(company);
        Book book = QueryBalanceUtil.initBook(ctx, reportInfo, includePosted);
        Sheet sheet = book.getSheet(0);
        String sheetName = sheet.getSheetName();
        RptReportPropertyAdapter adapter = new RptReportPropertyAdapter(reportInfo);
        ReportVariables vars = this.getReportVariable(reportInfo, includePosted, sheetName);
        FullOrgUnitInfo fullOrgUnitInfo = orgUnit.castToFullOrgUnitInfo();
        long getDynItemDataStart = System.currentTimeMillis();
        this.logService.addLogItem("DZPT: OwnerCheckageCompanyId", new Object[]{company, "getDynItemDataStart: ---------------------start-------------------------"});
        HashMap<String, String> firstLineId_Formulas = new HashMap<String, String>();
        for (int i2 = 0; i2 < checkageAccounts.size(); ++i2) {
            String formula = checkageAccounts.get(i2).getFormula();
            if (!formula.startsWith("=")) {
                formula = "=" + formula;
            }
            firstLineId_Formulas.put(String.valueOf(i2), formula);
        }
        this.logService.addLogItem("DZPT: OwnerCheckageCompanyId", new Object[]{company, "getDynItemDataStart: ---------------------start-------------------------"});
        InterAndExchFormulaParse formulaPars = new InterAndExchFormulaParse(ctx, firstLineId_Formulas, vars, (IReportPropertyAdapter)adapter, sheetName, (OrgUnitInfo)fullOrgUnitInfo);
        formulaPars.formulaParse(sheet);
        Map fillItemMap = null;
        if (!(!formulaPars.isAccordFillItem() || formulaPars.getAcctCashFormulasMap().isEmpty() && formulaPars.getAcctFormulaMap().isEmpty())) {
            Map filterParamMap = fillsheet.createFilterParamMap(ctx, formulaPars, vars, sheet, (OrgUnitInfo)fullOrgUnitInfo, null, false);
            filterParamMap.put("isGroupByFormula", true);
            Map dataMap = CslReportServiceFacadeFactory.getLocalInstance((Context)ctx).getDynItemData(filterParamMap);
            if (dataMap.get("isExecuteError") == null || !((Boolean)dataMap.get("isExecuteError")).booleanValue()) {
                fillItemMap = (Map)dataMap.get("fillItemSet");
            }
        }
        Map ownerfillItemMap = null;
        if (!(!formulaPars.isAccordFillItem() || formulaPars.getAcctCashFormulasMap().isEmpty() && formulaPars.getAcctFormulaMap().isEmpty())) {
            Map filterParamMap = fillsheet.createFilterParamMap(ctx, formulaPars, vars, sheet, (OrgUnitInfo)fullOrgUnitInfo, null, false);
            filterParamMap.put("isQueryOwnerCompany", true);
            Map dataMap = CslReportServiceFacadeFactory.getLocalInstance((Context)ctx).getDynItemData(filterParamMap);
            if (dataMap.get("isExecuteError") == null || !((Boolean)dataMap.get("isExecuteError")).booleanValue()) {
                ownerfillItemMap = (Map)dataMap.get("fillItemSet");
            }
        }
        long getDynItemDataEnd = System.currentTimeMillis();
        this.logService.addLogItem("DZPT: OwnerCheckageCompanyId", new Object[]{company, " getDynItemDataSpanTime: " + String.valueOf(getDynItemDataEnd - getDynItemDataStart)});
        CheckageAccountCollection curCheckageAccounts = new CheckageAccountCollection();
        for (i = 0; i < checkageAccounts.size(); ++i) {
            checkageAccount = checkageAccounts.get(i);
            formulaId = String.valueOf(i);
            if (formulaPars.getHandleFormulaIds().contains(formulaId)) {
                if (fillItemMap == null) continue;
                Set tarCompanyIds = (Set)fillItemMap.get(formulaId);
                if (tarCompanyIds != null && !tarCompanyIds.isEmpty()) {
                    this.constructFormula(ctx, year, period, currency, companyIds, enableCompanyIds, includeUnPosteds, companyNumbers, customerNumbers, providerNumbers, customerActNumber, providerActNumber, fillsheet, company, checkageItemNumbers, formulasBySeq, tarFormulas, checkageAccount, tarCompanyIds);
                }
                if (tarCompanyIds == null) {
                    this.logService.addLogItem("DZPT: OwnerCheckageCompanyId", new Object[]{company, checkageAccount.getFormula() + "TarCheckageCompany Size: 0"});
                    continue;
                }
                this.logService.addLogItem("DZPT: OwnerCheckageCompanyId", new Object[]{company, checkageAccount.getFormula() + "TarCheckageCompany Size: " + String.valueOf(tarCompanyIds.size())});
                continue;
            }
            curCheckageAccounts.add(checkageAccount);
            this.logService.addLogItem("DZPT: OwnerCheckageCompanyId all TargetCompany", checkageAccount.getFormula());
        }
        for (i = 0; i < checkageAccounts.size(); ++i) {
            Set ownerCompanyIds;
            checkageAccount = checkageAccounts.get(i);
            formulaId = String.valueOf(i);
            if (!formulaPars.getHandleFormulaIds().contains(formulaId) || ownerfillItemMap == null || (ownerCompanyIds = (Set)ownerfillItemMap.get(formulaId)) == null || ownerCompanyIds.isEmpty()) continue;
            this.constructOwnerFormula(ctx, year, period, currency, companyIds, enableCompanyIds, includeUnPosteds, companyNumbers, customerNumbers, providerNumbers, customerActNumber, providerActNumber, fillsheet, company, checkageItemNumbers, tarFormulas, checkageAccount, ownerCompanyIds);
        }
        if (!curCheckageAccounts.isEmpty()) {
            this.constructFormulasByThread(ctx, year, period, currency, companyIds, enableCompanyIds, includeUnPosteds, companyNumbers, customerNumbers, providerNumbers, curCheckageAccounts, customerActNumber, providerActNumber, fillsheet, company, params, checkageItemNumbers, formulasBySeq, tarFormulas);
        }
    }

    private void constructOwnerFormula(Context ctx, int year, int period, CurrencyInfo currency, List<String> companyIds, List<String> enableCompanyIds, Map<String, Boolean> includeUnPosteds, Map<String, String> companyNumbers, Map<String, String> customerNumbers, Map<String, String> providerNumbers, String customerActNumber, String providerActNumber, FillSheetAssistant fillsheet, String company, Map<String, String> checkageItemNumbers, Map<String, Map<String, String>> tarFormulas, CheckageAccountInfo checkageAccount, Collection<String> ownerCompanyIds) throws Exception {
        HashMap<String, String> ownerFormula = null;
        String itemNumber = checkageAccount.getItemNumber();
        String itemName = checkageAccount.getItemName();
        int dataElement = checkageAccount.getDataElement();
        String formula = checkageAccount.getFormula();
        int dc = checkageAccount.getItemDC().getValue();
        String number = checkageAccount.getNumber();
        if (!formula.startsWith("=")) {
            formula = "=" + formula;
        }
        String companyNumber = companyNumbers.get(company);
        for (String ownerCompanyId : ownerCompanyIds) {
            if (!enableCompanyIds.contains(ownerCompanyId) || companyIds.contains(ownerCompanyId)) continue;
            String currencyId = currency.getId().toString();
            boolean includePostedForTarCom = includeUnPosteds.get(ownerCompanyId);
            String key2 = this.constructCheckageBillKey(ownerCompanyId, company, year, period, currencyId, includePostedForTarCom, itemNumber, itemName, dc, dataElement);
            String customerNumber2 = customerNumbers.get(company);
            String providerNumber2 = providerNumbers.get(company);
            String newFormula2 = this.replaceComapny(ctx, formula, companyNumber, customerActNumber, providerActNumber, customerNumber2 != null ? customerNumber2 : companyNumber, providerNumber2 != null ? providerNumber2 : companyNumber);
            if (tarFormulas.containsKey(ownerCompanyId)) {
                if (!tarFormulas.get(ownerCompanyId).containsKey(key2)) {
                    tarFormulas.get(ownerCompanyId).put(key2, newFormula2);
                }
            } else {
                ownerFormula = new HashMap<String, String>();
                ownerFormula.put(key2, newFormula2);
                tarFormulas.put(ownerCompanyId, ownerFormula);
            }
            if (checkageItemNumbers.containsKey(key2)) continue;
            checkageItemNumbers.put(key2, number);
        }
    }

    private void constructFormula(Context ctx, int year, int period, CurrencyInfo currency, List<String> companyIds, List<String> enableCompanyIds, Map<String, Boolean> includeUnPosteds, Map<String, String> companyNumbers, Map<String, String> customerNumbers, Map<String, String> providerNumbers, String customerActNumber, String providerActNumber, FillSheetAssistant fillsheet, String company, Map<String, String> checkageItemNumbers, List<Map<String, String>> formulasBySeq, Map<String, Map<String, String>> tarFormulas, CheckageAccountInfo checkageAccount, Collection<String> tagCompanyIds) throws Exception {
        HashMap<String, String> tarformula = null;
        HashMap<String, String> formulas = new HashMap<String, String>();
        String itemNumber = checkageAccount.getItemNumber();
        String itemName = checkageAccount.getItemName();
        int dataElement = checkageAccount.getDataElement();
        String formula = checkageAccount.getFormula();
        int dc = checkageAccount.getItemDC().getValue();
        String number = checkageAccount.getNumber();
        if (!formula.startsWith("=")) {
            formula = "=" + formula;
        }
        ReportInfo reportInfo = this.initReportInfo(ctx, year, period, currency);
        String companyNumber = companyNumbers.get(company);
        this.setCompanyForReportInfo(company, companyNumber, reportInfo);
        boolean includePosted = includeUnPosteds.get(company);
        for (String tarCompany : tagCompanyIds) {
            if (!enableCompanyIds.contains(tarCompany)) continue;
            String currencyId = currency.getId().toString();
            String key = this.constructCheckageBillKey(company, tarCompany, year, period, currencyId, includePosted, itemNumber, itemName, dc, dataElement);
            String tarcompanyNumber = companyNumbers.get(tarCompany);
            String customerNumber = customerNumbers.get(tarCompany);
            String providerNumber = providerNumbers.get(tarCompany);
            String newFormula = this.replaceComapny(ctx, formula, tarcompanyNumber, customerActNumber, providerActNumber, customerNumber != null ? customerNumber : tarcompanyNumber, providerNumber != null ? providerNumber : tarcompanyNumber);
            formulas.put(key, newFormula);
            checkageItemNumbers.put(key, number);
            if (companyIds.contains(tarCompany)) continue;
            boolean includePostedForTarCom = includeUnPosteds.get(tarCompany);
            String key2 = this.constructCheckageBillKey(tarCompany, company, year, period, currencyId, includePostedForTarCom, itemNumber, itemName, dc, dataElement);
            String customerNumber2 = customerNumbers.get(company);
            String providerNumber2 = providerNumbers.get(company);
            String newFormula2 = this.replaceComapny(ctx, formula, companyNumber, customerActNumber, providerActNumber, customerNumber2 != null ? customerNumber2 : companyNumber, providerNumber2 != null ? providerNumber2 : companyNumber);
            if (tarFormulas.containsKey(tarCompany)) {
                tarFormulas.get(tarCompany).put(key2, newFormula2);
            } else {
                tarformula = new HashMap<String, String>();
                tarformula.put(key2, newFormula2);
                tarFormulas.put(tarCompany, tarformula);
            }
            checkageItemNumbers.put(key2, number);
        }
        if (!formulas.isEmpty()) {
            formulasBySeq.add(formulas);
        }
    }

    private ReportVariables getReportVariable(ReportInfo reportInfo, boolean includePosted, String sheetName) {
        ReportVariables vars = VariablesHelper.sheetParams2Variables(reportInfo);
        for (int i = 0; i < vars.getAllVariables().size(); ++i) {
            ((VariableEntry)vars.getAllVariables().get(i)).setSheetName(sheetName);
        }
        VariableEntry includePostedEntry = vars.get("IncludePosted", sheetName);
        if (includePostedEntry == null) {
            includePostedEntry = new VariableEntry("IncludePosted", sheetName, 2, String.valueOf(includePosted), true);
        } else {
            includePostedEntry.setValue(String.valueOf(includePosted));
            includePostedEntry.setType(1);
        }
        vars.addOrReplace(includePostedEntry);
        vars.add(new VariableEntry("Check_Permissioin", null, 1, "false", false));
        return vars;
    }

    private OrgUnitInfo getOwnerOrgUnitInfo(String company, String companyNumber) {
        OrgUnitInfo orgUnit = new OrgUnitInfo();
        orgUnit.setId(BOSUuid.read((String)company));
        orgUnit.setNumber(companyNumber);
        return orgUnit;
    }

    private boolean checkFormulas(List<String> firstLineFormulas, Set<String> formulaNames) {
        for (String formula : firstLineFormulas) {
            if (ExcelFormulaPaserHelper.isSpecialInFormulas((String)formula, formulaNames, (int)0)) continue;
            return false;
        }
        return true;
    }

    private void calTarCompanyFormulas(final Context ctx, final int year, final int period, final String company, final CurrencyInfo currency, final Map<String, Map<String, String>> tarFormulas, final Map<String, String> checkageItemNumbers, final Map<String, BigDecimal> values, final Map<String, String> companyNumbers, final Map<String, Boolean> includeUnPosteds, final String numberTitle, final String formulaTitle, String[] params) throws Exception {
        Iterator<String> it = tarFormulas.keySet().iterator();
        boolean isUseThread = false;
        if (tarFormulas.size() > 1) {
            isUseThread = true;
        }
        final AtomicInteger atomic = new AtomicInteger(0);
        int threadCount = Integer.valueOf(params[1]);
        while (it.hasNext()) {
            final String tarCompanyId = it.next();
            if (isUseThread) {
                while (atomic.get() >= threadCount) {
                    Thread.sleep(50L);
                }
                atomic.addAndGet(1);
                Thread thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            long tarComCalTimeStart = System.currentTimeMillis();
                            QueryCheckageDataFacadeControllerBean.this.exeTarCompanyFormula(ctx, year, period, company, currency, tarFormulas, checkageItemNumbers, values, companyNumbers, includeUnPosteds, numberTitle, formulaTitle, tarCompanyId);
                            long tarComCalTimeEnd = System.currentTimeMillis();
                            QueryCheckageDataFacadeControllerBean.this.logService.addLogItem("DZPT: OwnerCheckageCompanyId", new Object[]{company, "TarCompanyId: " + tarCompanyId, " CalculateTotalSpanTime: " + String.valueOf(tarComCalTimeEnd - tarComCalTimeStart)});
                        }
                        catch (Exception e) {
                            logger.error((Object)" calTarCompanyFormula thread error.", (Throwable)e);
                        }
                        finally {
                            atomic.addAndGet(-1);
                        }
                    }
                };
                thread.start();
                continue;
            }
            long tarComCalTimeStart = System.currentTimeMillis();
            this.exeTarCompanyFormula(ctx, year, period, company, currency, tarFormulas, checkageItemNumbers, values, companyNumbers, includeUnPosteds, numberTitle, formulaTitle, tarCompanyId);
            long tarComCalTimeEnd = System.currentTimeMillis();
            this.logService.addLogItem("DZPT: OwnerCheckageCompanyId", new Object[]{company, "TarCompanyId: " + tarCompanyId, " CalculateTotalSpanTime: " + String.valueOf(tarComCalTimeEnd - tarComCalTimeStart)});
        }
        if (isUseThread && atomic.get() > 0) {
            while (isUseThread && atomic.get() > 0) {
                Thread.sleep(100L);
            }
        }
    }

    private void exeTarCompanyFormula(Context ctx, int year, int period, String company, CurrencyInfo currency, Map<String, Map<String, String>> tarFormulas, Map<String, String> checkageItemNumbers, Map<String, BigDecimal> values, Map<String, String> companyNumbers, Map<String, Boolean> includeUnPosteds, String numberTitle, String formulaTitle, String tarCompanyId) throws Exception {
        String currencyId = currency.getId().toString();
        ReportInfo reportInfo = this.initReportInfo(ctx, year, period, currency);
        ArrayList<Map<String, String>> formulas = new ArrayList<Map<String, String>>();
        HashMap<String, String> formulasWithResult = new HashMap<String, String>();
        boolean includePosted = includeUnPosteds.get(tarCompanyId);
        Map<String, String> formulaMap = tarFormulas.get(tarCompanyId);
        formulas.add(formulaMap);
        String tarCompanyNumber = companyNumbers.get(tarCompanyId);
        this.setCompanyForReportInfo(tarCompanyId, tarCompanyNumber, reportInfo);
        long tarComCalTimeStart = System.currentTimeMillis();
        Book book = QueryBalanceUtil.initBook(ctx, reportInfo, includePosted);
        Sheet sheet = book.getSheet(0);
        this.fillFormulaToSheet(ctx, sheet, checkageItemNumbers, formulas, numberTitle, formulaTitle);
        sheet.calc();
        this.getFormulaValues(sheet, formulas, values, formulasWithResult);
        long tarComCalTimeEnd = System.currentTimeMillis();
        this.logService.addLogItem("DZPT: TarCompanyId", new Object[]{tarCompanyId + "(" + tarCompanyNumber + ")", " BookCalculateSpanTime: " + String.valueOf(tarComCalTimeEnd - tarComCalTimeStart)});
        tarComCalTimeStart = System.currentTimeMillis();
        this.writeAccessRecord(ctx, year, period, currencyId, tarCompanyId, company, formulasWithResult);
        tarComCalTimeEnd = System.currentTimeMillis();
        this.logService.addLogItem("DZPT: TarCompanyId", new Object[]{tarCompanyId + "(" + tarCompanyNumber + ")", " writeAccessRecordSpanTime: " + String.valueOf(tarComCalTimeEnd - tarComCalTimeStart)});
    }

    private void calOwnerCompanyFormulas(Context ctx, int year, int period, CurrencyInfo currency, Map<String, String> companyNames, Map<String, Boolean> includeUnPosteds, Map<String, String> companyNumbers, List<Map<String, String>> formulasBySeq, Map<String, String> checkageItemNumbers, Map<String, BigDecimal> values, String company, String numberTitle, String formulaTitle) throws Exception {
        String currencyId = currency.getId().toString();
        ReportInfo reportInfo = this.initReportInfo(ctx, year, period, currency);
        String companyNumber = companyNumbers.get(company);
        this.setCompanyForReportInfo(company, companyNumber, reportInfo);
        boolean includePosted = includeUnPosteds.get(company);
        long ownerComCalTimeStart = System.currentTimeMillis();
        Book book = QueryBalanceUtil.initBook(ctx, reportInfo, includePosted);
        Sheet sheet = book.getSheet(0);
        HashMap<String, String> formulasWithResult = new HashMap<String, String>();
        this.fillFormulaToSheet(ctx, sheet, checkageItemNumbers, formulasBySeq, numberTitle, formulaTitle);
        sheet.calc();
        boolean isError = this.getFormulaValues(sheet, formulasBySeq, values, formulasWithResult);
        long ownerComCalTimeEnd = System.currentTimeMillis();
        this.logService.addLogItem("DZPT: OwnerCheckageCompanyId", new Object[]{company + "(" + companyNumber + ")", " BookCalculateSpanTime: " + String.valueOf(ownerComCalTimeEnd - ownerComCalTimeStart)});
        ownerComCalTimeStart = System.currentTimeMillis();
        String companyName = companyNames.get(company);
        this.writeAccessFormulaLog(ctx, year, period, currencyId, company, companyNumber, companyName, book, isError);
        this.writeAccessRecord(ctx, year, period, currencyId, company, company, formulasWithResult);
        ownerComCalTimeEnd = System.currentTimeMillis();
        this.logService.addLogItem("DZPT: OwnerCheckageCompanyId", new Object[]{company + "(" + companyNumber + ")", " writeAccessRecordSpanTime: " + String.valueOf(ownerComCalTimeEnd - ownerComCalTimeStart)});
    }

    private void setCompanyForReportInfo(String company, String companyNumber, ReportInfo reportInfo) {
        OrgUnitInfo orgUnit = this.getOwnerOrgUnitInfo(company, companyNumber);
        reportInfo.setCompany(orgUnit);
    }

    private void writeAccessRecord(Context ctx, int year, int period, String currencyId, String companyId, String createCompanyId, Map<String, String> formulasWithResult) throws EASBizException, BOSException {
        if (formulasWithResult.isEmpty()) {
            return;
        }
        this.delOldAccessRecord(ctx, year, period, currencyId, companyId, createCompanyId);
        Iterator<String> it = formulasWithResult.keySet().iterator();
        CoreBaseCollection accessRecords = new CoreBaseCollection();
        String userId = ctx.getCaller().toString();
        Timestamp time = QueryBalanceUtil.getTime();
        while (it.hasNext()) {
            String key = it.next();
            String formula = formulasWithResult.get(key);
            String[] keys = key.split("###");
            AccessRecordInfo accessRecord = new AccessRecordInfo();
            companyId = keys[0];
            String tarCompanyId = keys[1];
            year = Integer.valueOf(keys[2]);
            period = Integer.valueOf(keys[3]);
            currencyId = keys[4];
            String itemNumber = keys[6];
            int dataElement = Integer.valueOf(keys[9]);
            accessRecord.setCompanyId(companyId);
            accessRecord.setTarCompanyId(tarCompanyId);
            accessRecord.setYear(year);
            accessRecord.setPeriod(period);
            accessRecord.setCurrencyId(currencyId);
            accessRecord.setItemNumber(itemNumber);
            accessRecord.setDataElement(dataElement);
            accessRecord.setFormula(formula);
            UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userId));
            accessRecord.setCreator(user);
            accessRecord.setCreateTime(time);
            accessRecord.setCreateCompanyId(createCompanyId);
            accessRecords.add((CoreBaseInfo)accessRecord);
        }
        AccessRecordFactory.getLocalInstance(ctx).addnewBatchData(accessRecords);
    }

    private void delOldAccessRecord(Context ctx, int year, int period, String currencyId, String companyId, String createCompanyId) throws EASBizException, BOSException {
        if (companyId.equals(createCompanyId)) {
            AccessRecordFactory.getLocalInstance(ctx).delete("where year = " + year + " And period = " + period + " And currencyId = '" + currencyId + "' And companyId = '" + companyId + "'");
        } else {
            AccessRecordFactory.getLocalInstance(ctx).delete("where year = " + year + " And period = " + period + " And currencyId = '" + currencyId + "' And companyId = '" + companyId + "' And createCompanyId = '" + createCompanyId + "'");
        }
    }

    private void writeAccessFormulaLog(Context ctx, int year, int period, String currencyId, String companyId, String companyNumber, String companyName, Book book, boolean isError) throws IOException, EASBizException, BOSException {
        this.delOldAccessFormulaLog(ctx, year, period, currencyId, companyId);
        String userId = ctx.getCaller().toString();
        Timestamp time = QueryBalanceUtil.getTime();
        byte[] data = IOHelper.packBook((Book)book);
        AccessReportInfo accessReportInfo = new AccessReportInfo();
        accessReportInfo.setCompanyId(companyId);
        accessReportInfo.setCompanyNumber(companyNumber);
        accessReportInfo.setCompanyName(companyName);
        accessReportInfo.setYear(year);
        accessReportInfo.setPeriod(period);
        accessReportInfo.setCurrencyId(currencyId);
        accessReportInfo.setData(data);
        String result = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"273_success", (Locale)ctx.getOriginLocale());
        if (isError) {
            result = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource", (String)"274_fail", (Locale)ctx.getOriginLocale());
        }
        accessReportInfo.setResult(result);
        UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userId));
        accessReportInfo.setCreator(user);
        accessReportInfo.setCreateTime(time);
        AccessReportFactory.getLocalInstance(ctx).addnew(accessReportInfo);
    }

    private void delOldAccessFormulaLog(Context ctx, int year, int period, String currencyId, String companyId) throws EASBizException, BOSException {
        AccessReportFactory.getLocalInstance(ctx).delete("where year = " + year + " and period = " + period + " and currencyId = '" + currencyId + "' and companyId = '" + companyId + "'");
    }

    private CheckageBillDataCollection getCheckageBillDatas(Map<String, BigDecimal> values) {
        CheckageBillDataCollection checkageBillDatas = new CheckageBillDataCollection();
        Iterator<String> it = values.keySet().iterator();
        BigDecimal zero = new BigDecimal(0);
        while (it.hasNext()) {
            String key = it.next();
            BigDecimal value = values.get(key);
            if (value.compareTo(zero) == 0) continue;
            CheckageBillDataInfo checkageBillData = new CheckageBillDataInfo();
            String[] keys = key.split("###");
            String companyId = keys[0];
            String tarCompanyId = keys[1];
            int year = Integer.valueOf(keys[2]);
            int period = Integer.valueOf(keys[3]);
            String currencyId = keys[4];
            boolean includePosted = Boolean.valueOf(keys[5]);
            String itemNumber = keys[6];
            String itemName = keys[7];
            int dc = Integer.valueOf(keys[8]);
            int dataElement = Integer.valueOf(keys[9]);
            CompanyOrgUnitInfo company = this.getCompanyOrgUnitInfo(companyId);
            checkageBillData.setCompany(company);
            CompanyOrgUnitInfo tarCompany = this.getCompanyOrgUnitInfo(tarCompanyId);
            checkageBillData.setTargetCompany(tarCompany);
            checkageBillData.setYear(year);
            checkageBillData.setPeriod(period);
            CurrencyInfo currency = this.getCurrencyInfo(currencyId);
            checkageBillData.setCurrency(currency);
            checkageBillData.setIsIncludeUnPosted(includePosted);
            checkageBillData.setItemNumber(itemNumber);
            checkageBillData.setItemName(itemName);
            checkageBillData.setDataElement(dataElement);
            checkageBillData.setItemType(ItemTypeEnum.rptItem);
            if (dc == 1) {
                checkageBillData.setDebit(value);
                checkageBillData.setAuditDebit(value);
                checkageBillData.setConfirmDebit(value);
            } else if (dc == -1) {
                checkageBillData.setCredit(value);
                checkageBillData.setAuditCredit(value);
                checkageBillData.setConfirmCredit(value);
            }
            checkageBillDatas.add(checkageBillData);
        }
        return checkageBillDatas;
    }

    private CurrencyInfo getCurrencyInfo(String currencyId) {
        CurrencyInfo currency = new CurrencyInfo();
        currency.setId(BOSUuid.read((String)currencyId));
        return currency;
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfo(String companyId) {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        return company;
    }

    private boolean getFormulaValues(Sheet sheet, List<Map<String, String>> formulasBySeq, Map<String, BigDecimal> values, Map<String, String> formulasWithResult) throws SyntaxErrorException, EASBizException {
        int size = 0;
        for (Map<String, String> formulas : formulasBySeq) {
            size += formulas.size();
        }
        BigDecimal zero = new BigDecimal(0);
        boolean isError = false;
        for (int i = 0; i < size; ++i) {
            Variant key = sheet.getCell(i + 1, 0, true).getValue();
            String formula = sheet.getCell(i + 1, 2, true).getFormula();
            Variant value = sheet.getCell(i + 1, 2, true).getValue();
            if (key == null) continue;
            if (value == null) {
                values.put(key.toString(), zero);
                continue;
            }
            if (value.isError()) {
                values.put(key.toString(), zero);
                isError = true;
                continue;
            }
            if (value != null) {
                if (value.toString().equalsIgnoreCase("false")) {
                    values.put(key.toString(), zero);
                    continue;
                }
                if (value.toString().equalsIgnoreCase("true")) {
                    values.put(key.toString(), zero);
                    continue;
                }
                if (value.toString().equalsIgnoreCase("#DIV/0!")) {
                    values.put(key.toString(), zero);
                    continue;
                }
                if (value.isString()) {
                    values.put(key.toString(), zero);
                    isError = true;
                    continue;
                }
            }
            BigDecimal bgValue = value.toBigDecimal();
            CslRptUtil.checkBigDecimalLength((BigDecimal)bgValue);
            values.put(key.toString(), bgValue);
            if (formulasWithResult == null || value.toBigDecimal().compareTo(zero) == 0) continue;
            formulasWithResult.put(key.toString(), formula);
        }
        return isError;
    }

    private void fillFormulaToSheet(Context ctx, Sheet sheet, Map<String, String> checkageItemNumbers, List<Map<String, String>> formulasBySeq, String numberTitle, String formulaTitle) {
        String keyTitle = "KEY";
        sheet.getCell(0, 0, true).setValue(new Variant((Object)keyTitle));
        sheet.getCell(0, 1, true).setValue(new Variant((Object)numberTitle));
        sheet.getCell(0, 2, true).setValue(new Variant((Object)formulaTitle));
        int index = 1;
        for (Map<String, String> formulas : formulasBySeq) {
            for (String key : formulas.keySet()) {
                String formula = formulas.get(key);
                if (!formula.startsWith("=")) {
                    formula = "=" + formula;
                }
                String checkageItemNumber = checkageItemNumbers.get(key);
                sheet.getCell(index, 0, true).setValue(new Variant((Object)key));
                sheet.getCell(index, 1, true).setValue(new Variant((Object)checkageItemNumber));
                sheet.getCell(index, 2, true).setFormula(formula);
                ++index;
            }
        }
    }

    private String replaceComapny(Context ctx, String formula, String companyNumber, String customerActNumber, String providerActNumber, String customerNumber, String providerNumber) {
        if (formula.indexOf("@") > -1) {
            String proReg;
            String cusReg = "|" + customerActNumber + "|";
            if (formula.indexOf(cusReg) > -1) {
                if (customerNumber.indexOf("@") > 0) {
                    customerNumber = customerNumber.replace("@", "##");
                }
                cusReg = "|" + customerActNumber + "|@";
                String cusRep = "|" + customerActNumber + "|" + customerNumber;
                formula = formula.replace(cusReg, cusRep);
            }
            if (formula.indexOf(proReg = "|" + providerActNumber + "|") > -1) {
                if (providerNumber.indexOf("@") > 0) {
                    providerNumber = providerNumber.replace("@", "##");
                }
                proReg = "|" + providerActNumber + "|@";
                String proRep = "|" + providerActNumber + "|" + providerNumber;
                formula = formula.replace(proReg, proRep);
            }
            formula = formula.replace("@", companyNumber);
            formula = formula.replace("##", "@");
        }
        return formula;
    }

    private void getAsstNumbers(Context ctx, List<String> enableCompanyIds, Map<String, String> customerNumbers, Map<String, String> providerNumbers) throws BOSException {
        ParamTempTblService service = null;
        try {
            QueryCheckageCompanys queryCheckageCompanys = new QueryCheckageCompanys(ctx);
            service = queryCheckageCompanys.getCheckageCompanysTempTable(enableCompanyIds);
            String companyTmpTable = service.getTmpTableName();
            this.getCustomerNumberByInternalCompanyId(ctx, companyTmpTable, customerNumbers);
            this.getProviderNumberByInternalCompanyId(ctx, companyTmpTable, providerNumbers);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (service != null) {
                service.release();
            }
        }
    }

    private void getCustomerNumberByInternalCompanyId(Context ctx, String companyTmpTable, Map<String, String> customerNumbers) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Select tmp.FCompanyId companyId, customer.FNumber number \n");
        sql.append(" From T_BD_Customer customer \n");
        sql.append(" Inner join ").append(companyTmpTable).append(" tmp On tmp.FCompanyId = customer.FInternalCompanyID \n");
        sql.append(" Where customer.FIsInternalCompany = 1 \n");
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString());
        try {
            while (rowSet.next()) {
                String companyId = rowSet.getString("companyId");
                String customerNumber = rowSet.getString("number");
                customerNumbers.put(companyId, customerNumber);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void getProviderNumberByInternalCompanyId(Context ctx, String companyTmpTable, Map<String, String> providerNumbers) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Select tmp.FCompanyId companyId, provider.FNumber number \n");
        sql.append(" From T_BD_Supplier provider \n");
        sql.append(" Inner join ").append(companyTmpTable).append(" tmp On tmp.FCompanyId = provider.FInternalCompanyID \n");
        sql.append(" Where provider.FIsInternalCompany = 1 \n");
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString());
        try {
            while (rowSet.next()) {
                String companyId = rowSet.getString("companyId");
                String providerNumber = rowSet.getString("number");
                providerNumbers.put(companyId, providerNumber);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getCustomerActNumber(Context ctx) throws EASBizException, BOSException {
        AsstActTypeInfo asstActType = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActType(AsstActTypeSysEnum.CUSTOMER);
        String number = asstActType.getNumber();
        return number;
    }

    private String getProviderActNumber(Context ctx) throws EASBizException, BOSException {
        AsstActTypeInfo asstActType = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActType(AsstActTypeSysEnum.PROVIDER);
        String number = asstActType.getNumber();
        return number;
    }

    private String constructCheckageBillKey(String company, String tarCompany, int year, int period, String currencyId, boolean includePosted, String itemNumber, String itemName, int dc, int dataElement) {
        StringBuilder key = new StringBuilder();
        key.append(company).append("###").append(tarCompany).append("###").append(year).append("###");
        key.append(period).append("###").append(currencyId).append("###").append(includePosted).append("###");
        key.append(itemNumber).append("###").append(itemName).append("###").append(dc).append("###").append(dataElement);
        return key.toString();
    }

    private ReportInfo initReportInfo(Context ctx, int year, int period, CurrencyInfo currency) throws EASBizException, BOSException {
        ReportInfo reportInfo = new ReportInfo();
        reportInfo.setYear(year);
        reportInfo.setPeriod((short)period);
        reportInfo.setPeriodType(RptPeriodTypeEnum.MONTHLY);
        reportInfo.setCurrency(currency);
        return reportInfo;
    }

    @Override
    protected String _queryMappingCheckageData(final Context ctx, Map params) throws BOSException, EASBizException {
        long time = System.currentTimeMillis();
        this.logService = new LogService(logger, DebugLogger.isDebug);
        this.logService.addLogItem("DZPT: QueryMappingCheckageData", "-------------start-------------");
        StringBuffer message = new StringBuffer();
        final int year = Integer.valueOf(String.valueOf(params.get("year")));
        final int period = Integer.valueOf(String.valueOf(params.get("period")));
        final String currencyId = String.valueOf(params.get("currencyId"));
        String userId = ctx.getCaller().toString();
        HashSet<String> orgIds = null;
        if (params.containsKey("orgIds")) {
            orgIds = (HashSet<String>)params.get("orgIds");
        }
        String companyId = null;
        if (params.containsKey("companyId")) {
            companyId = (String)params.get("companyId");
            if (orgIds == null) {
                orgIds = new HashSet<String>();
                orgIds.add(companyId);
            }
        }
        if (orgIds == null || orgIds != null && orgIds.isEmpty()) {
            logger.error((Object)"QueryMappingCheckageData: company is null.");
            return message.toString();
        }
        final boolean isFromImport = Boolean.valueOf(String.valueOf(params.get("isFromImport")));
        ParamTempTblService service = null;
        try {
            QueryCheckageCompanys queryCheckageCompanys = new QueryCheckageCompanys(ctx, userId, year, period);
            final List<Boolean> status = this.getIsIncludeUnPostedStatus();
            final ArrayList<String> companyIds = new ArrayList<String>();
            final List<String> enableCompanyIds = queryCheckageCompanys.getCheckageCompanys();
            final Map<String, Boolean> includeUnPosteds = queryCheckageCompanys.getIncludeUnPosteds();
            companyIds.addAll(orgIds);
            service = queryCheckageCompanys.getCheckageCompanysTempTable(companyIds);
            final String companyTempTable = service.getTmpTableName();
            final Map<String, String> rptItemMaps = this.queryRptItemMapIds(ctx, companyTempTable);
            if (rptItemMaps == null || rptItemMaps != null && rptItemMaps.isEmpty()) {
                logger.error((Object)"QueryMappingCheckageData: rptItemMaps is null.");
                String string = message.toString();
                return string;
            }
            Iterator<String> it = rptItemMaps.keySet().iterator();
            QueryBalanceUtil.removeCheckageBillData(ctx, isFromImport, 1, 5, companyTempTable, year, period, currencyId);
            QueryBalanceUtil.removeDeletedCheckageBillRecord(ctx, 1, 5, companyTempTable, year, period, currencyId);
            final List<String> delkeys = QueryBalanceUtil.getDeletedChekageRecord(ctx, 1, year, period, currencyId, 5);
            final Map<String, PeriodInfo> curPeriods = this.getCurrentPeriods(ctx, companyTempTable);
            final Map<String, PeriodInfo> acctPeriods = this.getAcctPeriods(ctx, companyTempTable, year, period);
            final Timestamp nowTimest = new Timestamp(new Date().getTime());
            final ArrayList<String> detailList = new ArrayList<String>();
            final String[] cslParam = this.getFormulaCslParams(ctx, "DZPT_SetThreadCountForGetCheckDataByMapping");
            int threadCount = Integer.valueOf(cslParam[0]);
            boolean isUseThread = rptItemMaps.size() > 1;
            final AtomicInteger atomic = new AtomicInteger(0);
            while (it.hasNext()) {
                final String key = it.next();
                if (isUseThread) {
                    while (atomic.get() >= threadCount) {
                        Thread.sleep(50L);
                    }
                    atomic.addAndGet(1);
                    Thread thread = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                long start = System.currentTimeMillis();
                                QueryCheckageDataFacadeControllerBean.this.genDataForSingleMapping(ctx, year, period, currencyId, isFromImport, rptItemMaps, companyTempTable, delkeys, status, companyIds, enableCompanyIds, includeUnPosteds, curPeriods, acctPeriods, nowTimest, detailList, cslParam, key);
                                long end = System.currentTimeMillis();
                                QueryCheckageDataFacadeControllerBean.this.logService.addLogItem("DZPT: genDataForSingleMappingKey", new Object[]{key, " genDataForSingleMappingSpanTime: " + String.valueOf(end - start)});
                            }
                            catch (Exception e) {
                                logger.error((Object)" genDataForSingleMapping thread error.", (Throwable)e);
                            }
                            finally {
                                atomic.addAndGet(-1);
                            }
                        }
                    };
                    thread.start();
                    continue;
                }
                long start = System.currentTimeMillis();
                this.genDataForSingleMapping(ctx, year, period, currencyId, isFromImport, rptItemMaps, companyTempTable, delkeys, status, companyIds, enableCompanyIds, includeUnPosteds, curPeriods, acctPeriods, nowTimest, detailList, cslParam, key);
                long end = System.currentTimeMillis();
                this.logService.addLogItem("DZPT: genDataForSingleMappingKey", new Object[]{key, " genDataForSingleMappingSpanTime: " + String.valueOf(end - start)});
            }
            if (isUseThread && atomic.get() > 0) {
                while (isUseThread && atomic.get() > 0) {
                    Thread.sleep(100L);
                }
            }
            if (detailList != null && !detailList.isEmpty()) {
                for (String detail : detailList) {
                    message.append(detail).append("\n");
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"DZPT: _queryMappingCheckageData: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (service != null) {
                service.release();
            }
            this.nextPeriodCache.clear();
            this.preAcctPeriodCache.clear();
        }
        this.logService.addLogItem("DZPT: QueryMappingCheckageDataSpanTime: ", String.valueOf(System.currentTimeMillis() - time));
        this.logService.addLogItem("DZPT: QueryMappingCheckageData: ", "----------------------end---------------------");
        this.logService.logIt();
        this.logService.reset();
        return message.toString();
    }

    private Map<String, String> queryRptItemMapIds(Context ctx, String companyTempTable) throws Exception {
        String lan = ctx.getLocale().getLanguage();
        HashMap<String, String> rptItemMaps = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append("Select rim.FId rimId,ri.FNumber riNumber,ri.FName_" + lan + " riName,ri.FDc riDc,rim.FDataElement deSeq \n");
        sql.append("From T_Csl_RPTItemMap rim \n");
        sql.append("Inner Join T_Csl_RptItem ri On ri.fId = rim.FRptItemId \n");
        sql.append("Inner Join T_Csl_CheckageAccount ca On ca.FItemNumber = ri.FNumber And rim.FDataElement = ca.FDataElement \n");
        sql.append("Inner Join T_Csl_AccountAndMapAccount ama On ca.FId = ama.FCheckAccountId \n");
        sql.append("Inner Join T_Csl_AccountMap am On am.fid = ama.FAccountMapId \n");
        sql.append("Inner Join T_Csl_AccountMapDispense disp ON disp.FAccountMapId = am.FId \n");
        sql.append("Inner Join T_Csl_CheckageCompany chkCom On chkCom.FID = disp.FCheckageCompanyId \n");
        sql.append("Inner Join ").append(companyTempTable).append(" tempTbl On chkCom.FCompanyId = tempTbl.FcompanyId \n");
        sql.append("Where rim.FIsAccess = ? And rim.FItemType = ? And rim.FIsFree = ? \n");
        sql.append(" And ca.FItemType = ? And ca.FIsFree = ? And am.FItemType = ? And am.FIsFree = ? And ama.FDataSource = ?");
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(1);
        params.add(0);
        params.add(0);
        params.add(1);
        params.add(0);
        params.add(1);
        params.add(0);
        params.add(1);
        IRowSet rs = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
        while (rs.next()) {
            String rimId = rs.getString("rimId");
            String itemNumber = rs.getString("riNumber");
            String itemName = rs.getString("riName");
            int dataElement = rs.getInt("deSeq");
            int dc = rs.getInt("riDc");
            String key = itemNumber + "###" + itemName + "###" + dc + "###" + dataElement;
            rptItemMaps.put(key, rimId);
        }
        return rptItemMaps;
    }

    private void genDataForSingleMapping(Context ctx, int year, int period, String currencyId, boolean isFromImport, Map<String, String> rptItemMapingMap, String companyTempTable, List<String> delkeys, List<Boolean> status, List<String> companyIds, List<String> enableCompanyIds, Map<String, Boolean> includeUnPosteds, Map<String, PeriodInfo> curPeriods, Map<String, PeriodInfo> acctPeriods, Timestamp nowTimest, List<String> detailList, String[] cslParam, String key) throws Exception, EASBizException, BOSException {
        String[] keys = key.split("###");
        String itemNumber = keys[0];
        String itemName = keys[1];
        int dc = Integer.valueOf(keys[2]);
        int dataElement = Integer.valueOf(keys[3]);
        String mappingId = rptItemMapingMap.get(key);
        QueryCheckageAccounts queryCheckageAccounts = new QueryCheckageAccounts(ctx, companyTempTable, year, period, mappingId);
        Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeAccountIds = queryCheckageAccounts.getAsstActTypeAccountIds();
        Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeAccountNumbers = queryCheckageAccounts.getAsstActTypeAccountNumbers();
        Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeDeatilAccountIds = queryCheckageAccounts.getAsstActTypeDetailAccountIds();
        Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeDeatilAccountNumbers = queryCheckageAccounts.getAsstActTypeDetailAccountNumbers();
        Map<String, Map<Integer, List<AccountViewInfo>>> companyIdbalTypeAccountViews = queryCheckageAccounts.getAccountByBalType();
        if ((companyIdasstActTypeAccountIds == null || companyIdasstActTypeAccountIds.isEmpty()) && (companyIdasstActTypeDeatilAccountIds == null || companyIdasstActTypeDeatilAccountIds.isEmpty())) {
            logger.error((Object)("DZPT: QueryMappingCheckageData\u2014Checkage Account Is Not Exist! MappingId: " + mappingId));
            this.logService.addLogItem("DZPT: QueryMappingCheckageData\u2014Checkage Account Is Not Exist! MappingId: ", mappingId);
            return;
        }
        ConcurrentHashMap<String, BigDecimal> mappingReports = new ConcurrentHashMap<String, BigDecimal>();
        this.loopForGenaratingAllData(ctx, year, period, currencyId, isFromImport, delkeys, status, companyIds, enableCompanyIds, includeUnPosteds, curPeriods, acctPeriods, nowTimest, detailList, itemNumber, itemName, dc, dataElement, queryCheckageAccounts, companyIdasstActTypeAccountIds, companyIdasstActTypeAccountNumbers, companyIdasstActTypeDeatilAccountIds, companyIdasstActTypeDeatilAccountNumbers, companyIdbalTypeAccountViews, mappingReports, cslParam);
        if (!mappingReports.isEmpty()) {
            this.writeMappingReportRecord(ctx, mappingReports, itemNumber, dataElement, year, period, currencyId, companyIds);
        }
    }

    private void loopForGenaratingAllData(final Context ctx, final int year, final int period, final String currencyId, final boolean isFromImport, final List<String> delkeys, final List<Boolean> status, final List<String> companyIds, final List<String> enableCompanyIds, final Map<String, Boolean> includeUnPosteds, Map<String, PeriodInfo> curPeriods, Map<String, PeriodInfo> acctPeriods, final Timestamp nowTimest, final List<String> detailList, final String itemNumber, final String itemName, final int dc, final int dataElement, final QueryCheckageAccounts queryCheckageAccounts, final Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeAccountIds, final Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeAccountNumbers, final Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeDeatilAccountIds, final Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeDeatilAccountNumbers, final Map<String, Map<Integer, List<AccountViewInfo>>> companyIdbalTypeAccountViews, final Map<String, BigDecimal> mappingReports, String[] params) throws Exception {
        boolean isUseThread = companyIds.size() > 1;
        final AtomicInteger atomic = new AtomicInteger(0);
        int threadCount = Integer.valueOf(params[1]);
        for (final String company : companyIds) {
            final PeriodInfo currentPeriodInfo = curPeriods.get(company);
            if (currentPeriodInfo == null) {
                logger.error((Object)("DZPT: MappingCurrentPeriodInfo Is Null!CompanyId: " + company));
                this.logService.addLogItem("DZPT: MappingCurrentPeriodInfo Is Null!CompanyId: ", company);
                continue;
            }
            final PeriodInfo acctPeriodInfo = acctPeriods.get(company);
            if (acctPeriodInfo == null) {
                logger.error((Object)("DZPT: MappingAcctPeriodInfo Is Null!CompanyId: " + company));
                this.logService.addLogItem("DZPT: MappingAcctPeriodInfo Is Null!CompanyId: ", company);
                continue;
            }
            if (isUseThread) {
                while (atomic.get() >= threadCount) {
                    Thread.sleep(50L);
                }
                atomic.addAndGet(1);
                Thread thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            long start = System.currentTimeMillis();
                            QueryCheckageDataFacadeControllerBean.this.genSingleCompanyData(ctx, company, year, period, currencyId, isFromImport, delkeys, status, companyIds, enableCompanyIds, includeUnPosteds, currentPeriodInfo, acctPeriodInfo, nowTimest, detailList, itemNumber, itemName, dc, dataElement, queryCheckageAccounts, companyIdasstActTypeAccountIds, companyIdasstActTypeAccountNumbers, companyIdasstActTypeDeatilAccountIds, companyIdasstActTypeDeatilAccountNumbers, companyIdbalTypeAccountViews, mappingReports);
                            long end = System.currentTimeMillis();
                            QueryCheckageDataFacadeControllerBean.this.logService.addLogItem("DZPT: genSingleCompanyData-CompanyId: ", new Object[]{company, " genSingleCompanyDataSpanTime: " + String.valueOf(end - start)});
                        }
                        catch (Exception e) {
                            logger.error((Object)" genSingleCompanyData thread error.", (Throwable)e);
                        }
                        finally {
                            atomic.addAndGet(-1);
                        }
                    }
                };
                thread.start();
                continue;
            }
            long start = System.currentTimeMillis();
            this.genSingleCompanyData(ctx, company, year, period, currencyId, isFromImport, delkeys, status, companyIds, enableCompanyIds, includeUnPosteds, currentPeriodInfo, acctPeriodInfo, nowTimest, detailList, itemNumber, itemName, dc, dataElement, queryCheckageAccounts, companyIdasstActTypeAccountIds, companyIdasstActTypeAccountNumbers, companyIdasstActTypeDeatilAccountIds, companyIdasstActTypeDeatilAccountNumbers, companyIdbalTypeAccountViews, mappingReports);
            long end = System.currentTimeMillis();
            this.logService.addLogItem("DZPT: genSingleCompanyData-CompanyId: ", new Object[]{company, " genSingleCompanyDataSpanTime: " + String.valueOf(end - start)});
        }
        if (isUseThread && atomic.get() > 0) {
            while (isUseThread && atomic.get() > 0) {
                Thread.sleep(100L);
            }
        }
    }

    private void genSingleCompanyData(Context ctx, String company, int year, int period, String currencyId, boolean isFromImport, List<String> delkeys, List<Boolean> status, List<String> companyIds, List<String> enableCompanyIds, Map<String, Boolean> includeUnPosteds, PeriodInfo currentPeriodInfo, PeriodInfo acctPeriodInfo, Timestamp nowTimest, List<String> detailList, String itemNumber, String itemName, int dc, int dataElement, QueryCheckageAccounts queryCheckageAccounts, Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeAccountIds, Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeAccountNumbers, Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeDeatilAccountIds, Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeDeatilAccountNumbers, Map<String, Map<Integer, List<AccountViewInfo>>> companyIdbalTypeAccountViews, Map<String, BigDecimal> mappingReports) throws Exception {
        AtomicInteger calAtomic = new AtomicInteger(0);
        CheckageBillDataCollection checkageBillDatas = new CheckageBillDataCollection();
        ConcurrentHashMap<String, BigDecimal> values = new ConcurrentHashMap<String, BigDecimal>();
        this.writeOrgPackInfo(ctx, nowTimest, year, period, currencyId, company, ItemTypeEnum.rptItem);
        boolean isUseThread = this.getNotDetailDataForMapping(ctx, year, period, currencyId, values, mappingReports, status, includeUnPosteds, queryCheckageAccounts, companyIdasstActTypeAccountIds, companyIdasstActTypeAccountNumbers, companyIdbalTypeAccountViews, company, currentPeriodInfo, acctPeriodInfo, companyIdasstActTypeDeatilAccountIds, calAtomic);
        this.getDetailDataForMapping(ctx, year, period, currencyId, values, mappingReports, status, includeUnPosteds, queryCheckageAccounts, companyIdasstActTypeDeatilAccountIds, companyIdasstActTypeDeatilAccountNumbers, companyIdbalTypeAccountViews, company, currentPeriodInfo, acctPeriodInfo, companyIdasstActTypeAccountIds);
        if (isUseThread && calAtomic.get() > 0) {
            while (calAtomic.get() > 0) {
                Thread.sleep(100L);
            }
        }
        if (!values.isEmpty()) {
            for (String str : values.keySet()) {
                BigDecimal value = (BigDecimal)values.get(str);
                String[] strs = str.split("###");
                String comId = strs[0];
                String tarComId = strs[1];
                boolean includePosted = includeUnPosteds.get(comId);
                CheckageBillDataInfo checkageBillData = this.getCheckageBillDataInfo(year, period, currencyId, comId, tarComId, includePosted, itemNumber, itemName, dc, dataElement, value);
                checkageBillDatas.add(checkageBillData);
            }
        }
        if (!checkageBillDatas.isEmpty()) {
            QueryBalanceUtil.removeDisabledCompanyCheckageData(enableCompanyIds, checkageBillDatas);
            QueryBalanceUtil.removeExistsCheckageBillData(ctx, 1, company, currencyId, year, period, checkageBillDatas);
            QueryBalanceUtil.removeWrongStatusChekageData(includeUnPosteds, checkageBillDatas);
            QueryBalanceUtil.removeDeletedChekageData(ctx, delkeys, checkageBillDatas);
            QueryBalanceUtil.removeSameChekageData(ctx, 1, year, period, currencyId, 4, checkageBillDatas);
            QueryBalanceUtil.removeCheckageBillDataByImportRecord(ctx, 1, isFromImport, company, currencyId, year, period, checkageBillDatas);
            List<String> msgList = QueryBalanceUtil.removeCheckageBillDataByConfirmedData(ctx, 1, 5, company, currencyId, year, period, checkageBillDatas);
            if (msgList != null && !msgList.isEmpty()) {
                if (detailList != null && !detailList.isEmpty()) {
                    for (String n : msgList) {
                        if (detailList.contains(n)) continue;
                        detailList.add(n);
                    }
                } else {
                    detailList.addAll(msgList);
                }
            }
            QueryBalanceUtil.insertCheckageBillData(ctx, ItemTypeEnum.rptItem, DataSourceEnum.mappingRelation, company, checkageBillDatas);
        }
    }

    private void getDetailDataForMapping(final Context ctx, final int year, final int period, final String currencyId, final Map<String, BigDecimal> values, final Map<String, BigDecimal> mappingReports, final List<Boolean> status, final Map<String, Boolean> includeUnPosteds, final QueryCheckageAccounts queryCheckageAccounts, final Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeDeatilAccountIds, final Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeDeatilAccountNumbers, final Map<String, Map<Integer, List<AccountViewInfo>>> companyIdbalTypeAccountViews, final String company, final PeriodInfo currentPeriodInfo, final PeriodInfo acctPeriodInfo, Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeAccountIds) throws Exception {
        if (companyIdasstActTypeDeatilAccountIds != null && !companyIdasstActTypeDeatilAccountIds.isEmpty() && companyIdasstActTypeDeatilAccountIds.containsKey(company)) {
            boolean isUseThread = this.isHasData(companyIdasstActTypeAccountIds, company);
            final AtomicInteger atomic = new AtomicInteger(0);
            if (isUseThread) {
                Thread thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            long startTime = System.currentTimeMillis();
                            QueryCheckageDataFacadeControllerBean.this.getDetailBalanceForMapping(ctx, year, period, currencyId, values, mappingReports, status, includeUnPosteds, queryCheckageAccounts, companyIdasstActTypeDeatilAccountIds, companyIdasstActTypeDeatilAccountNumbers, companyIdbalTypeAccountViews, company, currentPeriodInfo, acctPeriodInfo);
                            long endTime = System.currentTimeMillis();
                            QueryCheckageDataFacadeControllerBean.this.logService.addLogItem("DZPT: getDetailDataForMappingCompanyId", new Object[]{company, " getDetailDataForMappingSpanTime: " + String.valueOf(startTime - endTime)});
                        }
                        catch (Exception e) {
                            logger.error((Object)" getDetailDataForMapping thread error.", (Throwable)e);
                        }
                        finally {
                            atomic.addAndGet(-1);
                        }
                    }
                };
                atomic.addAndGet(1);
                thread.start();
            } else {
                this.getDetailBalanceForMapping(ctx, year, period, currencyId, values, mappingReports, status, includeUnPosteds, queryCheckageAccounts, companyIdasstActTypeDeatilAccountIds, companyIdasstActTypeDeatilAccountNumbers, companyIdbalTypeAccountViews, company, currentPeriodInfo, acctPeriodInfo);
            }
            if (isUseThread && atomic.get() > 0) {
                while (atomic.get() > 0) {
                    Thread.sleep(100L);
                }
            }
        }
    }

    private void getDetailBalanceForMapping(Context ctx, int year, int period, String currencyId, Map<String, BigDecimal> values, Map<String, BigDecimal> mappingReports, List<Boolean> status, Map<String, Boolean> includeUnPosteds, QueryCheckageAccounts queryCheckageAccounts, Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeDeatilAccountIds, Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeDeatilAccountNumbers, Map<String, Map<Integer, List<AccountViewInfo>>> companyIdbalTypeAccountViews, String company, PeriodInfo currentPeriodInfo, PeriodInfo acctPeriodInfo) throws Exception {
        Map<Integer, List<AccountViewInfo>> balTypeAccountViews = companyIdbalTypeAccountViews.get(company);
        Map<String, Map<String, List<String>>> asstActTypeDeatilAccountIds = companyIdasstActTypeDeatilAccountIds.get(company);
        Map<String, Map<String, List<String>>> asstActTypeDeatilAccountNumbers = companyIdasstActTypeDeatilAccountNumbers.get(company);
        boolean isIncludePosted = false;
        if (!includeUnPosteds.isEmpty()) {
            isIncludePosted = includeUnPosteds.get(company);
        }
        this.queryBalanceDataByMapping(ctx, isIncludePosted, status, true, year, period, currencyId, company, currentPeriodInfo, acctPeriodInfo, queryCheckageAccounts, asstActTypeDeatilAccountIds, asstActTypeDeatilAccountNumbers, balTypeAccountViews, values, includeUnPosteds, mappingReports);
    }

    private boolean getNotDetailDataForMapping(final Context ctx, final int year, final int period, final String currencyId, final Map<String, BigDecimal> values, final Map<String, BigDecimal> mappingReports, final List<Boolean> status, final Map<String, Boolean> includeUnPosteds, final QueryCheckageAccounts queryCheckageAccounts, final Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeAccountIds, final Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeAccountNumbers, final Map<String, Map<Integer, List<AccountViewInfo>>> companyIdbalTypeAccountViews, final String company, final PeriodInfo currentPeriodInfo, final PeriodInfo acctPeriodInfo, Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeDeatilAccountIds, final AtomicInteger calAtomic) throws Exception {
        boolean isUseThread = this.isHasData(companyIdasstActTypeDeatilAccountIds, company);
        if (companyIdasstActTypeAccountIds != null && !companyIdasstActTypeAccountIds.isEmpty() && companyIdasstActTypeAccountIds.containsKey(company)) {
            if (isUseThread) {
                Thread thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            long startTime = System.currentTimeMillis();
                            QueryCheckageDataFacadeControllerBean.this.getNotDetailBalanceForMapping(ctx, year, period, currencyId, values, mappingReports, status, includeUnPosteds, queryCheckageAccounts, companyIdasstActTypeAccountIds, companyIdasstActTypeAccountNumbers, companyIdbalTypeAccountViews, company, currentPeriodInfo, acctPeriodInfo);
                            long endTime = System.currentTimeMillis();
                            QueryCheckageDataFacadeControllerBean.this.logService.addLogItem("DZPT: getNotDetailDataForMppingCompanyId", new Object[]{company, " getNotDetailDataForMppingSpanTime: " + String.valueOf(endTime - startTime)});
                        }
                        catch (Exception e) {
                            logger.error((Object)" getNotDetailDataForMpping thread error.", (Throwable)e);
                        }
                        finally {
                            calAtomic.addAndGet(-1);
                        }
                    }
                };
                calAtomic.addAndGet(1);
                thread.start();
            } else {
                this.getNotDetailBalanceForMapping(ctx, year, period, currencyId, values, mappingReports, status, includeUnPosteds, queryCheckageAccounts, companyIdasstActTypeAccountIds, companyIdasstActTypeAccountNumbers, companyIdbalTypeAccountViews, company, currentPeriodInfo, acctPeriodInfo);
            }
        }
        return isUseThread;
    }

    private void getNotDetailBalanceForMapping(Context ctx, int year, int period, String currencyId, Map<String, BigDecimal> values, Map<String, BigDecimal> mappingReports, List<Boolean> status, Map<String, Boolean> includeUnPosteds, QueryCheckageAccounts queryCheckageAccounts, Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeAccountIds, Map<String, Map<String, Map<String, List<String>>>> companyIdasstActTypeAccountNumbers, Map<String, Map<Integer, List<AccountViewInfo>>> companyIdbalTypeAccountViews, String company, PeriodInfo currentPeriodInfo, PeriodInfo acctPeriodInfo) throws Exception {
        Map<Integer, List<AccountViewInfo>> balTypeAccountViews = companyIdbalTypeAccountViews.get(company);
        Map<String, Map<String, List<String>>> asstActTypeAccountIds = companyIdasstActTypeAccountIds.get(company);
        Map<String, Map<String, List<String>>> asstActTypeAccountNumbers = companyIdasstActTypeAccountNumbers.get(company);
        boolean isIncludePosted = false;
        if (!includeUnPosteds.isEmpty()) {
            isIncludePosted = includeUnPosteds.get(company);
        }
        this.queryBalanceDataByMapping(ctx, isIncludePosted, status, false, year, period, currencyId, company, currentPeriodInfo, acctPeriodInfo, queryCheckageAccounts, asstActTypeAccountIds, asstActTypeAccountNumbers, balTypeAccountViews, values, includeUnPosteds, mappingReports);
    }

    private void writeMappingReportRecord(Context ctx, Map<String, BigDecimal> mappingReports, String itemNumber, int dataElement, int year, int period, String currencyId, List companyIds) throws EASBizException, BOSException {
        this.delOldMappingRecord(ctx, itemNumber, dataElement, year, period, currencyId, companyIds);
        Iterator<String> it = mappingReports.keySet().iterator();
        CoreBaseCollection mappingRecords = new CoreBaseCollection();
        String userId = ctx.getCaller().toString();
        UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userId));
        Timestamp time = QueryBalanceUtil.getTime();
        while (it.hasNext()) {
            String key = it.next();
            BigDecimal value = mappingReports.get(key);
            String[] keys = key.split("###");
            String companyId = keys[0];
            String tarCompanyId = keys[1];
            String accountId = keys[2];
            int dc = Integer.valueOf(keys[3]);
            int balType = Integer.valueOf(keys[4]);
            MappingRecordInfo mappingRecord = new MappingRecordInfo();
            mappingRecord.setCompanyId(companyId);
            mappingRecord.setTarCompanyId(tarCompanyId);
            mappingRecord.setYear(year);
            mappingRecord.setPeriod(period);
            mappingRecord.setCurrencyId(currencyId);
            mappingRecord.setItemNumber(itemNumber);
            mappingRecord.setDataElement(dataElement);
            mappingRecord.setAccountId(accountId);
            mappingRecord.setAccountDC(BalanceDirectionEnum.getEnum((int)dc));
            mappingRecord.setBalType(BalTypeEnum.getEnum(balType));
            mappingRecord.setValue(value);
            mappingRecord.setCreator(user);
            mappingRecord.setCreateTime(time);
            mappingRecords.add((CoreBaseInfo)mappingRecord);
        }
        MappingRecordFactory.getLocalInstance(ctx).addnewBatchData(mappingRecords);
    }

    private void delOldMappingRecord(Context ctx, String itemNumber, int dataElement, int year, int period, String currencyId, List companyIds) throws EASBizException, BOSException {
        MappingRecordFactory.getLocalInstance(ctx).delete("where year = " + year + " And period = " + period + " And currencyId = '" + currencyId + "' And itemNumber = '" + itemNumber + "' And dataElement = " + dataElement + " and companyId in (" + CslRptUtil.list2String((List)companyIds, (String)",", (boolean)true) + ")");
    }

    private CheckageBillDataInfo getCheckageBillDataInfo(int year, int period, String currencyId, String comId, String tarComId, boolean includePosted, String itemNumber, String itemName, int dc, int dataElement, BigDecimal value) {
        CheckageBillDataInfo checkageBillData = new CheckageBillDataInfo();
        CompanyOrgUnitInfo company = this.getCompanyOrgUnitInfo(comId);
        checkageBillData.setCompany(company);
        CompanyOrgUnitInfo tarCompany = this.getCompanyOrgUnitInfo(tarComId);
        checkageBillData.setTargetCompany(tarCompany);
        checkageBillData.setYear(year);
        checkageBillData.setPeriod(period);
        CurrencyInfo currency = this.getCurrencyInfo(currencyId);
        checkageBillData.setCurrency(currency);
        checkageBillData.setIsIncludeUnPosted(includePosted);
        checkageBillData.setItemNumber(itemNumber);
        checkageBillData.setItemName(itemName);
        checkageBillData.setDataElement(dataElement);
        checkageBillData.setItemType(ItemTypeEnum.rptItem);
        if (dc == 1) {
            checkageBillData.setDebit(value);
            checkageBillData.setAuditDebit(value);
            checkageBillData.setConfirmDebit(value);
        } else if (dc == 0) {
            checkageBillData.setCredit(value);
            checkageBillData.setAuditCredit(value);
            checkageBillData.setConfirmCredit(value);
        }
        return checkageBillData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryBalanceDataByMapping(Context ctx, boolean isIncludePosted, List<Boolean> postedStatus, boolean isDetailAccount, int year, int period, String currencyId, String companyId, PeriodInfo currentPeriodInfo, PeriodInfo acctPeriodInfo, QueryCheckageAccounts queryCheckageAccounts, Map<String, Map<String, List<String>>> balTypeAccountIds, Map<String, Map<String, List<String>>> balTypeAccountNumbers, Map<Integer, List<AccountViewInfo>> balTypeAccountViews, Map<String, BigDecimal> values, Map<String, Boolean> includeUnPosteds, Map<String, BigDecimal> mappingReport) throws Exception {
        for (String balTypeString : balTypeAccountIds.keySet()) {
            int startYear = year;
            int startPeriod = period;
            int endYear = year;
            int endPeriod = period;
            boolean isMultiUnPosted = false;
            if ((balTypeString.equals("C") || balTypeString.equals("Y") || balTypeString.equals("SL") || balTypeString.equals("JL_DL")) && (isMultiUnPosted = this.isMultiUnPosted(currentPeriodInfo, year, period))) {
                int[] yearPeriod = this.setMultiUnPostedPeriod(ctx, balTypeString, currentPeriodInfo, acctPeriodInfo, year, period);
                startYear = yearPeriod[0];
                startPeriod = yearPeriod[1];
                endYear = yearPeriod[2];
                endPeriod = yearPeriod[3];
            }
            Map<String, List<String>> asstActTypeAccountIds = balTypeAccountIds.get(balTypeString);
            Map<String, List<String>> asstActTypeAccountNumbers = balTypeAccountNumbers.get(balTypeString);
            for (String actType : asstActTypeAccountIds.keySet()) {
                try {
                    List<String> accountIds = asstActTypeAccountIds.get(actType);
                    String accountTempTable = queryCheckageAccounts.getAccountTempTable(accountIds);
                    IQueryBalance iQueryBalance = QueryBalanceFactory.createInstance(ctx, isIncludePosted, isMultiUnPosted, isDetailAccount, currentPeriodInfo, startYear, startPeriod, endYear, endPeriod, currencyId, balTypeString, actType, companyId, accountTempTable);
                    IRowSet rowSet = iQueryBalance.queryOwnBalance();
                    QueryBalanceUtil.getTotalValue(ctx, true, rowSet, balTypeString, endYear, endPeriod, currencyId, isIncludePosted, balTypeAccountViews, values, includeUnPosteds, mappingReport);
                }
                finally {
                    queryCheckageAccounts.release();
                }
                try {
                    for (Boolean posted : postedStatus) {
                        List<String> accountNumbers = asstActTypeAccountNumbers.get(actType);
                        String accountTempTable = queryCheckageAccounts.getAccountTempTable(accountNumbers);
                        IQueryBalance iQueryBalance = QueryBalanceFactory.createInstance(ctx, posted, isMultiUnPosted, isDetailAccount, currentPeriodInfo, startYear, startPeriod, endYear, endPeriod, currencyId, balTypeString, actType, companyId, accountTempTable);
                        IRowSet rowSet = iQueryBalance.queryTargetBalance();
                        QueryBalanceUtil.getTotalValue(ctx, false, rowSet, balTypeString, endYear, endPeriod, currencyId, posted, balTypeAccountViews, values, includeUnPosteds, mappingReport);
                        queryCheckageAccounts.release();
                    }
                }
                finally {
                    queryCheckageAccounts.release();
                }
            }
        }
    }
}

