/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.ReconciliactionOrgType;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.ToleranceTypeEnum;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class ReconciliationToleranceSettingImport
extends AbstractDataTransmission {
    private static final String RES = "com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource";
    private static final String FORGTYPE = "FOrgType";
    private static final String FORGNUMBER = "FOrgNumber";
    private static final String FORGNAME = "FOrgName";
    private static final String FTARORGNUMBER = "FTarOrgNumber";
    private static final String FTARORGNAME = "FTarOrgName";
    private static final String FITEMTYPE = "FItemType";
    private static final String FMAPPINGNUMBER = "FMappingNumber";
    private static final String FELIMTYPE = "FElimType";
    private static final String FTOLERANCEVALUE = "FToleranceValue";
    private static final String FTOLERANCETYPE = "FToleranceType";
    private static final String FREMARK = "FRemark";
    private Map<String, Integer> keyMap = null;
    private CoreBaseCollection tolerances = null;
    private CheckageCompanyCollection checkageCompanyCollection = null;
    private AccountMapCollection accountMapCollection = null;
    private Map<String, String> toleranceKeys = null;
    private int index = 5;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ToleranceFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String key;
        ToleranceInfo telerance = new ToleranceInfo();
        String orgNumber = this.fecthData(hsData, FORGNUMBER);
        if (StringUtil.isEmptyString((String)orgNumber)) {
            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"517_orgNull", (Locale)ctx.getOriginLocale()));
        }
        CheckageCompanyInfo checkageCompanyInfo = this.getCheckageCompany(ctx, orgNumber = orgNumber.replace(" ", ""));
        if (checkageCompanyInfo == null) {
            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"518_chkOrg", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{orgNumber}));
        }
        CompanyOrgUnitInfo org = checkageCompanyInfo.getCompany();
        String orgId = org.getId().toString();
        if (!this.orgInOrgRange(ctx, orgId)) {
            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"519_orgRange", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{orgNumber}));
        }
        String tarOrgNumber = this.fecthData(hsData, FTARORGNUMBER);
        String tarOrgId = null;
        CompanyOrgUnitInfo tarOrg = null;
        if (!StringUtil.isEmptyString((String)tarOrgNumber)) {
            CheckageCompanyInfo tarCheckageCompanyInfo = this.getCheckageCompany(ctx, tarOrgNumber);
            if (tarCheckageCompanyInfo == null) {
                throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"548_tarChkOrg", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{tarOrgNumber}));
            }
            tarOrg = tarCheckageCompanyInfo.getCompany();
            tarOrgId = tarOrg.getId().toString();
        }
        String itemTypeNumber = this.fecthData(hsData, FITEMTYPE);
        String mappingNumber = this.fecthData(hsData, FMAPPINGNUMBER);
        if (!StringUtil.isEmptyString((String)mappingNumber) && StringUtil.isEmptyString((String)itemTypeNumber)) {
            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"520_noItemType", (Locale)ctx.getOriginLocale()));
        }
        if (!StringUtil.isEmptyString((String)mappingNumber) && !StringUtil.isEmptyString((String)itemTypeNumber) && this.getItemType(itemTypeNumber = itemTypeNumber.replace(" ", "")) == null) {
            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"521_itemTypeError", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{itemTypeNumber}));
        }
        AccountMapInfo accountMap = null;
        if (!StringUtil.isEmptyString((String)mappingNumber) && (accountMap = this.getAccountMapInfo(ctx, mappingNumber = mappingNumber.replace(" ", ""), itemTypeNumber)) == null) {
            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"522_noMap", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{mappingNumber}));
        }
        String toleranceValue = this.fecthData(hsData, FTOLERANCEVALUE);
        if (StringUtil.isEmptyString((String)toleranceValue)) {
            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"523_toleranceNull", (Locale)ctx.getOriginLocale()));
        }
        if (!this.isDigit(toleranceValue)) {
            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"524_digit", (Locale)ctx.getOriginLocale()));
        }
        this.digitOver(ctx, toleranceValue);
        BigDecimal value = new BigDecimal(toleranceValue);
        String toleranceType = this.fecthData(hsData, FTOLERANCETYPE);
        if (StringUtil.isEmptyString((String)toleranceType)) {
            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"528_defineNull", (Locale)ctx.getOriginLocale()));
        }
        if (!toleranceType.equals("A") && !toleranceType.equals("E")) {
            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"529_defineErr", (Locale)ctx.getOriginLocale()));
        }
        if (toleranceType.equals("E") && StringUtil.isEmptyString((String)mappingNumber)) {
            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"530_needMap", (Locale)ctx.getOriginLocale()));
        }
        String remark = this.fecthData(hsData, FREMARK);
        if (remark.length() > 500) {
            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"532_over500", (Locale)ctx.getOriginLocale()));
        }
        telerance.setOrgUnit(org.castToFullOrgUnitInfo());
        if (tarOrg != null) {
            telerance.setTarOrgUnit(tarOrg.castToFullOrgUnitInfo());
        }
        if (toleranceType.equals("E")) {
            telerance.setAccountMap(accountMap);
        }
        telerance.setValue(value);
        if (toleranceType.equals("E")) {
            telerance.setToleranceType(ToleranceTypeEnum.one);
        } else {
            telerance.setToleranceType(ToleranceTypeEnum.all);
        }
        if (!StringUtil.isEmptyString((String)remark)) {
            telerance.setRemark(remark);
        }
        if (this.keyMap == null) {
            this.keyMap = new HashMap<String, Integer>();
        }
        if (!this.keyMap.containsKey(key = this.getKey(telerance))) {
            this.keyMap.put(key, this.index);
            if (telerance.getTarOrgUnit() != null && telerance.getToleranceType().getValue() == 0) {
                String mappingId = telerance.getAccountMap().getId().toString();
                String tarOrgUnitId = telerance.getTarOrgUnit().getId().toString();
                String orgUnitId = telerance.getOrgUnit().getId().toString();
                String key2 = tarOrgUnitId + orgUnitId + mappingId;
                this.keyMap.put(key2, this.index);
            }
        } else {
            int seq = this.keyMap.get(key);
            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"533_repeat", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{seq}));
        }
        String teleranceId = this.getRepeatToleranceId(ctx, telerance);
        if (!this.isSltImportUpdate()) {
            if (teleranceId != null) {
                if (tarOrgId != null) {
                    throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"549_dup", (Locale)ctx.getOriginLocale()));
                }
                throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"534_dup", (Locale)ctx.getOriginLocale()));
            }
        } else if (teleranceId != null) {
            try {
                ToleranceFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(teleranceId));
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        ++this.index;
        return telerance;
    }

    private String getRepeatToleranceId(Context ctx, ToleranceInfo telerance) throws TaskExternalException {
        String newKey;
        this.getAllToleranceKey(ctx);
        if (this.toleranceKeys != null && !this.toleranceKeys.isEmpty() && this.toleranceKeys.containsKey(newKey = this.getKey(telerance))) {
            return this.toleranceKeys.get(newKey);
        }
        return null;
    }

    private void getAllToleranceKey(Context ctx) throws TaskExternalException {
        if (this.toleranceKeys == null) {
            this.toleranceKeys = new HashMap<String, String>();
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" Select t.FId id, t.FOrgUnitId orgId, t.FTarOrgUnitId tarOrgId, t.FToleranceType toleranceType, t.FAccountMapId accountMapId \n");
        sql.append(" From T_Csl_Tolerance t \n");
        try {
            IRowSet rs = DbUtil.executeQuery(ctx, sql.toString());
            StringBuffer key = null;
            while (rs.next()) {
                String id = rs.getString("id");
                String orgId = rs.getString("orgId");
                String tarOrgId = rs.getString("tarOrgId");
                int toleranceType = rs.getInt("toleranceType");
                key = new StringBuffer();
                key.append(orgId);
                if (toleranceType == 0) {
                    String accountMapId = rs.getString("accountMapId");
                    key.append(accountMapId);
                    if (tarOrgId != null) {
                        key = new StringBuffer();
                        key.append(orgId).append(tarOrgId).append(accountMapId);
                        this.toleranceKeys.put(key.toString(), id);
                        key = new StringBuffer();
                        key.append(tarOrgId).append(orgId).append(accountMapId);
                    }
                }
                this.toleranceKeys.put(key.toString(), id);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private String getKey(ToleranceInfo telerance) {
        String orgId = telerance.getOrgUnit().getId().toString();
        int toleranceType = telerance.getToleranceType().getValue();
        String mappingId = null;
        String tarOrgId = null;
        if (toleranceType == 0) {
            mappingId = telerance.getAccountMap().getId().toString();
            if (telerance.getTarOrgUnit() != null) {
                tarOrgId = telerance.getTarOrgUnit().getId().toString();
            }
        }
        StringBuffer key = new StringBuffer();
        key.append(orgId);
        if (mappingId != null) {
            if (tarOrgId != null) {
                key.append(tarOrgId);
            }
            key.append(mappingId);
        }
        return key.toString();
    }

    private void digitOver(Context ctx, String digit) throws TaskExternalException {
        if (digit.contains(".")) {
            String[] digits = digit.split("\\.");
            String first = digits[0];
            String second = digits[1];
            if (first.length() > 15) {
                throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"525_over15", (Locale)ctx.getOriginLocale()));
            }
            if (second.length() > 6) {
                throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"526_over6", (Locale)ctx.getOriginLocale()));
            }
        } else if (digit.length() > 15) {
            throw new TaskExternalException(ResourceBase.getString((String)RES, (String)"527_valueOver15", (Locale)ctx.getOriginLocale()));
        }
    }

    private boolean isDigit(String digit) {
        Pattern p = Pattern.compile("[0-9]+.?[0-9]*");
        return p.matcher(digit).matches();
    }

    private ItemTypeEnum getItemType(String itemType) {
        if ("001".equals(itemType)) {
            return ItemTypeEnum.account;
        }
        if ("002".equals(itemType)) {
            return ItemTypeEnum.rptItem;
        }
        return null;
    }

    private boolean orgInOrgRange(Context ctx, String orgId) throws TaskExternalException {
        String userId = ctx.getCaller().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("org", (Object)orgId));
        filter.getFilterItems().add(new FilterItemInfo("user", (Object)userId));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)10));
        try {
            if (OrgRangeFactory.getLocalInstance((Context)ctx).exists(filter)) {
                return true;
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private AccountMapInfo getAccountMapInfo(Context ctx, String mappingNumber, String itemTypeNumber) throws TaskExternalException {
        this.getAccountMapCollection(ctx);
        if (this.accountMapCollection != null && !this.accountMapCollection.isEmpty()) {
            Iterator it = this.accountMapCollection.iterator();
            ItemTypeEnum itemType = this.getItemType(itemTypeNumber);
            while (it.hasNext()) {
                AccountMapInfo accountMap = (AccountMapInfo)it.next();
                String number = accountMap.getNumber();
                int itemTypeValue = accountMap.getItemType().getValue();
                if (!mappingNumber.equals(number) || itemTypeValue != itemType.getValue()) continue;
                return accountMap;
            }
        }
        return null;
    }

    private void getAccountMapCollection(Context ctx) throws TaskExternalException {
        if (this.accountMapCollection != null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("isFree", (Object)0));
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(sic);
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("itemType"));
        try {
            this.accountMapCollection = AccountMapFactory.getLocalInstance(ctx).getAccountMapCollection(view);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private CheckageCompanyInfo getCheckageCompany(Context ctx, String companyNumber) throws TaskExternalException {
        this.getCheckageCompanyCollection(ctx);
        if (this.checkageCompanyCollection != null && !this.checkageCompanyCollection.isEmpty()) {
            Iterator it = this.checkageCompanyCollection.iterator();
            while (it.hasNext()) {
                CheckageCompanyInfo checkageCompanyInfo = (CheckageCompanyInfo)it.next();
                String chkComNumber = checkageCompanyInfo.getCompany().getNumber();
                if (!companyNumber.equals(chkComNumber)) continue;
                return checkageCompanyInfo;
            }
        }
        return null;
    }

    private void getCheckageCompanyCollection(Context ctx) throws TaskExternalException {
        if (this.checkageCompanyCollection != null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(sic);
        sic.add(new SelectorItemInfo("company"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.accountTable"));
        sic.add(new SelectorItemInfo("isfree"));
        sic.add(new SelectorItemInfo("freeTime"));
        try {
            this.checkageCompanyCollection = CheckageCompanyFactory.getLocalInstance(ctx).getCheckageCompanyCollection(view);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private String fecthData(Hashtable hsData, String key) {
        DataToken dataToken = (DataToken)hsData.get(key);
        if (dataToken != null) {
            return dataToken.toString();
        }
        return null;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ToleranceInfo telerance = (ToleranceInfo)coreBaseInfo;
        if (this.tolerances == null) {
            this.tolerances = new CoreBaseCollection();
        }
        this.tolerances.add((CoreBaseInfo)telerance);
    }

    public void importOnFinished(Context ctx, Map map) throws TaskExternalException {
        if (this.tolerances != null && !this.tolerances.isEmpty()) {
            try {
                ToleranceFactory.getLocalInstance(ctx).submit(this.tolerances);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        try {
            Hashtable result = new Hashtable();
            this.setData(result, FORGTYPE, rs.getInt("orgUnit.isUnion") == 0 ? ReconciliactionOrgType.Company.getAlias() : ReconciliactionOrgType.OrgUnit.getAlias());
            this.setData(result, FORGNUMBER, rs.getString("orgUnit.number"));
            this.setData(result, FORGNAME, rs.getString("orgUnit.name"));
            this.setData(result, FTARORGNUMBER, rs.getString("tarOrgUnit.number"));
            this.setData(result, FTARORGNAME, rs.getString("tarOrgUnit.name"));
            this.setData(result, FITEMTYPE, rs.getInt("accountMap.itemType") == 0 ? "001" : "002");
            this.setData(result, FMAPPINGNUMBER, rs.getString("accountMap.number"));
            this.setData(result, FELIMTYPE, rs.getInt("accountMap.elimType") == 1 ? ElimTypeEnum.ComeAndGo.getAlias() : ElimTypeEnum.exchange.getAlias());
            this.setData(result, FTOLERANCEVALUE, rs.getBigDecimal("value"));
            this.setData(result, FTOLERANCETYPE, rs.getInt("toleranceType") == 0 ? "E" : "A");
            this.setData(result, FREMARK, rs.getString("remark"));
            return result;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.newrpt.accountcheck.ReconciliationToleranceQuery";
    }

    public void setContextParameter(Hashtable param) {
        param.put("mainQueryPK", MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fi.newrpt.accountcheck.ReconciliationToleranceQuery"));
        super.setContextParameter((Map)param);
    }

    private void setData(Hashtable result, String key, Object value) {
        if (value != null) {
            if (value instanceof BigDecimal) {
                result.put(key, CslRptUtil.ReduceBigDecimalZeros((BigDecimal)((BigDecimal)value)));
            } else {
                result.put(key, value.toString());
            }
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return new FilterInfo();
    }
}

