/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fi.gl.RptBaseFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmUnitEntryCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmUnitLogInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckTaskEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageFilterInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AbstractAutoCheckTask;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AutoCheckParams;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AutoCheckTaskCatchImpl;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.IAutoCheckTaskCatch;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractAutoCheckOrgUnitTask
extends AbstractAutoCheckTask {
    protected String catchKey = null;
    protected String sameParentCompanysTbl = null;

    @Override
    protected boolean beforeProcess() throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.catchKey)) {
            this.catchKey = this.params.getSchmLogId() + "catch";
        }
        return super.beforeProcess();
    }

    @Override
    protected boolean AfterProcess() throws Exception {
        boolean result = super.AfterProcess();
        result = this.clearTmpTableCatch() && result;
        return result;
    }

    @Override
    protected boolean beforeProcessSingleOrgUnit(Context ctx, AutoCheckParams params, FullOrgUnitInfo orgUnit) throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.catchKey)) {
            this.catchKey = params.getSchmLogId() + "catch";
        }
        return super.beforeProcessSingleOrgUnit(ctx, params, orgUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean afterProcessSingleOrgUnit(Context ctx, AutoCheckParams params, FullOrgUnitInfo orgUnit, String failMsg) throws Exception {
        try {
            boolean bl = super.afterProcessSingleOrgUnit(ctx, params, orgUnit, failMsg);
            return bl;
        }
        finally {
            this.dropOrCatchTempTable(ctx, orgUnit, this.sameParentCompanysTbl);
        }
    }

    protected void dropOrCatchTempTable(Context ctx, FullOrgUnitInfo orgUnit, String tmpTable) throws Exception {
        boolean isCatchTmpTable = false;
        if (this.autoCheckTaskInfo != null && this.autoCheckTaskInfo.getNextTaskInfo() != null && (AutoCheckTaskEnum.checkDataAudit.equals((Object)this.autoCheckTaskInfo.getNextTaskInfo().getAutoCheckTaskEnum()) || AutoCheckTaskEnum.createElim.equals((Object)this.autoCheckTaskInfo.getNextTaskInfo().getAutoCheckTaskEnum()))) {
            isCatchTmpTable = true;
        }
        if (!StringUtils.isEmpty((CharSequence)tmpTable)) {
            if (isCatchTmpTable) {
                IAutoCheckTaskCatch AutoCheckTaskCatch = AutoCheckTaskCatchImpl.getAutoCheckTaskCatchIntf(ctx);
                AutoCheckTaskCatch.put(this.catchKey + orgUnit.getId().toString(), tmpTable);
            } else {
                this.dropTmpTable(ctx, tmpTable);
            }
        }
    }

    protected void dropTmpTable(Context ctx, String tmpTable) throws Exception {
        if (!StringUtils.isEmpty((CharSequence)tmpTable) && !DebugLogger.isDebug) {
            RptBaseFactory.getLocalInstance((Context)ctx).dropTable(tmpTable);
        }
    }

    public boolean clearTmpTableCatch() throws Exception {
        if (this.params != null && this.params.getSchmInfo() != null && this.autoCheckTaskInfo.getNextTaskInfo() == null) {
            IAutoCheckTaskCatch AutoCheckTaskCatch = AutoCheckTaskCatchImpl.getAutoCheckTaskCatchIntf(this.ctx);
            Map tmpTableCatch = AutoCheckTaskCatch.getCatch();
            AutoCheckSchmUnitEntryCollection unitColl = this.params.getSchmInfo().getOrgUnitEntries();
            for (int i = 0; i < unitColl.size(); ++i) {
                String tmpTableCatchKey = this.catchKey + unitColl.get(i).getOrgUnit().getId().toString();
                String tmpTable = (String)tmpTableCatch.get(tmpTableCatchKey);
                if (StringUtils.isEmpty((CharSequence)tmpTable)) continue;
                AutoCheckTaskCatch.remove(tmpTableCatchKey);
                this.dropTmpTable(this.ctx, tmpTable);
            }
        }
        return true;
    }

    protected CheckageFilterInfo initCommonFilterInfo(AutoCheckParams params, FullOrgUnitInfo orgUnit) {
        CheckageFilterInfo filterInfo = new CheckageFilterInfo();
        filterInfo.periodType = params.getSchmInfo().getPeriodType().getValue();
        filterInfo.year = params.getYear();
        filterInfo.period = params.getPeriod();
        filterInfo.currencyId = params.getSchmInfo().getCurrency().getId().toString();
        filterInfo.treeId = params.getSchmInfo().getOrgTree().getId().toString();
        filterInfo.orgUnitId = orgUnit.getId().toString();
        filterInfo.autoCheckTaskEnum = this.autoCheckTaskInfo.getAutoCheckTaskEnum().getValue();
        filterInfo.autoCheckSchmId = params.getSchmInfo().getId().toString();
        filterInfo.sameParentCompanyTbl = this.sameParentCompanysTbl;
        filterInfo.itemType = params.getSchmInfo().getItemType().getValue();
        return filterInfo;
    }

    @Override
    protected void insertOrgUnitExecLog(Context ctx, FullOrgUnitInfo orgUnit, boolean isSuccess) throws Exception {
        int autoCheckTask = this.autoCheckTaskInfo.getAutoCheckTaskEnum().getValue();
        if (this.sameParentCompanysTbl != null) {
            SQLBuilder sql = new SQLBuilder();
            String bosType = new AutoCheckSchmUnitLogInfo().getBOSType().toString();
            String schmLogId = this.params.getSchmLogId();
            String schmId = this.params.getSchmInfo().getId().toString();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String curTime = "{ts'" + formatter.format(new Date()) + "'}";
            int diffHdExecStatus = this.params.getSchmInfo().isIsDiffHandle() ? 1 : 0;
            int AuditExecStatus = this.params.getSchmInfo().isIsAudit() ? 1 : 0;
            int createElimExecStatus = this.params.getSchmInfo().isIsCreateElim() ? 1 : 0;
            String creatorId = ctx.getCaller().toString();
            switch (autoCheckTask) {
                case 3: {
                    diffHdExecStatus = isSuccess ? 3 : 4;
                    break;
                }
                case 4: {
                    AuditExecStatus = isSuccess ? 3 : 4;
                    break;
                }
                case 5: {
                    int n = createElimExecStatus = isSuccess ? 3 : 4;
                }
            }
            if (autoCheckTask == 4 && this.params.getSchmInfo().isIsDiffHandle()) {
                diffHdExecStatus = 1;
            }
            if (autoCheckTask == 5) {
                if (this.params.getSchmInfo().isIsDiffHandle()) {
                    diffHdExecStatus = 1;
                }
                if (this.params.getSchmInfo().isIsAudit()) {
                    AuditExecStatus = 1;
                }
            }
            sql.append("insert into T_Csl_AutoCheckSchmUnitLog(fid,FSchmLogId,FOrgUnitId,FOwnCompanyId,FTargetCompanyId,FDiffHdExecStatus");
            sql.append(",FAuditExecStatus,FCreateElimExecStatus,FDiffMode,FDiffAmount,FcreateTime,fcreatorId,flastUpdateUserId,flastUpdateTime) ");
            sql.append(" select newbosid('").append(bosType).append("') fid,'").append(schmLogId).append("' FSchmLogId,'").append(orgUnit.getId().toString()).append("' FOrgUnitId,");
            sql.append("ownCompanyId FOwnCompanyId,targetCompanyId FTargetCompanyId,").append(diffHdExecStatus).append(" FDiffHdExecStatus,").append(AuditExecStatus).append(" FAuditExecStatus,");
            sql.append(createElimExecStatus).append(" FCreateElimExecStatus,diffMode FDiffMode,abs(diff) FDiffAmount,").append(curTime).append(" FcreateTime,'").append(creatorId).append("' fcreatorId,'");
            sql.append(creatorId).append("' flastUpdateUserId,").append(curTime).append(" flastUpdateTime ");
            sql.append("from (");
            sql.append("    select  ownCompanyId,targetCompanyId,head.FDiffMode diffMode,sum(head.FCompanyDiff) diff ");
            sql.append("    from (");
            sql.append("     select distinct case when ownUnit.fnumber>targetUnit.fnumber then entry.ftargetCompanyid else entry.fcompanyid end ownCompanyId,");
            sql.append("      case when ownUnit.fnumber>targetUnit.fnumber then entry.fcompanyid else entry.ftargetCompanyid end targetCompanyId,entry.FBillHeadId");
            sql.append("     from T_Csl_CheckageBill entry  ");
            sql.append("     inner join t_org_baseunit ownUnit on ownUnit.fid=entry.fcompanyid ");
            sql.append("     inner join t_org_baseunit targetUnit on targetUnit.fid=entry.ftargetCompanyid ");
            sql.append("     inner join ").append(this.sameParentCompanysTbl).append(" tmp on (tmp.fcompanyid=entry.fcompanyid and tmp.ftargetcompanyId=entry.FTargetCompanyId ");
            sql.append("           \t\t\t\t\t\t\t\t\t\t\t\tor tmp.fcompanyid=entry.FTargetCompanyId and tmp.ftargetcompanyId=entry.fcompanyid) ");
            if (autoCheckTask == 3 || autoCheckTask == 4) {
                sql.append("     inner join T_Csl_CheckageBillHead inhead on inhead.fid=entry.FBillHeadId ");
                sql.append(" where ").append(autoCheckTask == 3 ? "inhead.FDiffSchmId = ? " : "inhead.FAuditSchmId = ? ", schmId);
            } else if (autoCheckTask == 5) {
                sql.append("     inner join T_Csl_CheckageBillRelatElim relat on relat.FCheckageBillId=entry.fid ");
                sql.append(" where relat.FCreateElimSchmId=? ", schmId);
            }
            sql.append("  and entry.fyear=? ", this.params.getYear());
            RptPeriodTypeEnum periodType = this.params.getSchmInfo().getPeriodType();
            if (!RptPeriodTypeEnum.MONTHLY.equals((Object)periodType)) {
                int[] yearPeriod = RPTDateUtil.getPeriod((Date)RPTDateUtil.getPeriodFirstDate((int)this.params.getYear(), (int)this.params.getPeriod(), (RptPeriodTypeEnum)periodType), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
                int[] lastYearPeriod = RPTDateUtil.getPeriod((Date)RPTDateUtil.getPeriodLastDate((int)this.params.getYear(), (int)this.params.getPeriod(), (RptPeriodTypeEnum)periodType), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
                int lastPeriod = lastYearPeriod[1];
                if (lastPeriod == 12) {
                    ++lastPeriod;
                }
                sql.append("  and entry.fperiod>=? ", yearPeriod[1]);
                sql.append("  and entry.fperiod<=? ", lastPeriod);
            } else {
                sql.append("  and entry.fperiod=? ", this.params.getPeriod());
            }
            sql.append(" and entry.FCurrencyId=? ", this.params.getSchmInfo().getCurrency().getId().toString());
            sql.append("   ) checkData ");
            sql.append("   inner join T_Csl_CheckageBillHead head on head.fid=checkData.FBillHeadId ");
            sql.append("   group by ownCompanyId,targetCompanyId,head.FDiffMode ");
            sql.append(") tmpData ");
            DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
        }
        this.insertFailtLog(ctx, orgUnit, isSuccess);
    }

    protected void insertFailtLog(Context ctx, FullOrgUnitInfo orgUnit, boolean isSuccess) throws Exception {
        int autoCheckTask = this.autoCheckTaskInfo.getAutoCheckTaskEnum().getValue();
        if (autoCheckTask == 5 || autoCheckTask == 4 && !this.params.getSchmInfo().isIsCreateElim() || autoCheckTask == 3 && !this.params.getSchmInfo().isIsCreateElim() && !this.params.getSchmInfo().isIsAudit()) {
            SQLBuilder sql = new SQLBuilder();
            sql.append("select top 1 fid from T_Csl_AutoCheckSchmUnitLog where FSchmLogId=? ", this.params.getSchmLogId());
            sql.append(" and FOrgUnitId=? ", orgUnit.getId().toString());
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            if (rowSet == null || rowSet.size() <= 0) {
                sql.reset();
                sql.append("select top 1 newBosId('").append(new AutoCheckSchmUnitLogInfo().getBOSType().toString()).append("') fid from T_Csl_AutoCheckSchmLOG ");
                rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                String id = null;
                if (rowSet != null && rowSet.next()) {
                    id = rowSet.getString("fid");
                }
                if (id != null) {
                    sql.reset();
                    sql.append(" insert into T_Csl_AutoCheckSchmUnitLog(fid,FSchmLogId,FOrgUnitId,FDiffHdExecStatus");
                    sql.append(",FAuditExecStatus,FCreateElimExecStatus,FcreateTime,fcreatorId,flastUpdateUserId,flastUpdateTime) ");
                    sql.append(" values(?,?,?,?,?,?,?,?,?,?)");
                    ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                    Timestamp time = new Timestamp(new Date().getTime());
                    paramsList.add(new Object[]{id, this.params.getSchmLogId(), orgUnit.getId().toString(), this.params.getSchmInfo().isIsDiffHandle() ? 4 : 1, this.params.getSchmInfo().isIsAudit() ? 4 : 1, this.params.getSchmInfo().isIsCreateElim() ? 4 : 1, time, ctx.getCaller().toString(), ctx.getCaller().toString(), time});
                    DbUtil.executeBatch(ctx, sql.getSQL(), paramsList);
                }
            }
        }
    }
}

