/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobIsolationLevel;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmCompEntryInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmDetailLogInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmTaskFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmTaskInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmUnitEntryInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmUnitLogInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckTaskEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AutoCheckParams;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AutoCheckTaskByOrgUnitHandle;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AutoCheckTaskCatchImpl;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AutoTaskInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.IAutoCheckTaskCatch;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.OrgUnitAutoCheckJobInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractAutoCheckTask {
    private static Logger logger = Logger.getLogger(AbstractAutoCheckTask.class);
    protected Context ctx = null;
    protected AutoCheckParams params = null;
    protected AutoTaskInfo autoCheckTaskInfo = null;
    protected Set<String> hasPermOrgUnits = null;
    protected OrgUnitAutoCheckJobInfo jobInfo = null;

    public void instance(Context ctx, AutoCheckParams params, AutoTaskInfo autoCheckTaskInfo) {
        this.ctx = ctx;
        this.params = params;
        this.autoCheckTaskInfo = autoCheckTaskInfo;
    }

    protected boolean beforeProcess() throws Exception {
        AccountCheckUtil.initOrgTree(this.ctx, this.params);
        this.hasPermOrgUnits = this.getHasPermOrgUnits();
        return true;
    }

    protected boolean AfterProcess() throws Exception {
        this.writePermDetailFailLog();
        return true;
    }

    protected boolean beforeProcessSingleOrgUnit(Context ctx, AutoCheckParams params, FullOrgUnitInfo orgUnit) throws Exception {
        this.updateExecTaskCountByNewTrans(ctx, params, orgUnit, true, true);
        this.writerOrgUnitLogByNewTrans(ctx, params, new FullOrgUnitInfo[]{orgUnit}, false, true);
        return true;
    }

    protected abstract void processSingleOrgUnit(Context var1, AutoCheckParams var2, FullOrgUnitInfo var3) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean afterProcessSingleOrgUnit(Context ctx, AutoCheckParams params, FullOrgUnitInfo orgUnit, String failMsg) throws Exception {
        if (!StringUtils.isEmpty((String)failMsg)) {
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            paramsList.add(new Object[]{params.getSchmLogId(), orgUnit.getId().toString(), this.autoCheckTaskInfo.getAutoCheckTaskEnum().getValue(), 4, failMsg});
            this.writeFailDetailLogByNewTrans(paramsList);
        }
        try {
            boolean isSuccess = StringUtils.isEmpty((String)failMsg);
            this.writerOrgUnitLogByNewTrans(ctx, params, new FullOrgUnitInfo[]{orgUnit}, isSuccess, false);
            this.updateExecTaskCountByNewTrans(ctx, params, orgUnit, isSuccess, false);
        }
        catch (Exception e) {
            block8: {
                try {
                    logger.error((Object)(this.autoCheckTaskInfo.getAutoCheckTaskEnum().getAlias() + ":" + orgUnit.getName() + " error."), (Throwable)e);
                    failMsg = AccountCheckUtil.getExceptionDetail(e);
                    if (e instanceof EASBizException) break block8;
                    throw e;
                }
                catch (Throwable throwable) {
                    if (!StringUtils.isEmpty((String)failMsg)) {
                        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                        paramsList.add(new Object[]{params.getSchmLogId(), orgUnit.getId().toString(), this.autoCheckTaskInfo.getAutoCheckTaskEnum().getValue(), 4, failMsg});
                        this.writeFailDetailLogByNewTrans(paramsList);
                    }
                    throw throwable;
                }
            }
            if (!StringUtils.isEmpty((String)failMsg)) {
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                paramsList.add(new Object[]{params.getSchmLogId(), orgUnit.getId().toString(), this.autoCheckTaskInfo.getAutoCheckTaskEnum().getValue(), 4, failMsg});
                this.writeFailDetailLogByNewTrans(paramsList);
            }
        }
        if (!StringUtils.isEmpty((String)failMsg)) {
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            paramsList.add(new Object[]{params.getSchmLogId(), orgUnit.getId().toString(), this.autoCheckTaskInfo.getAutoCheckTaskEnum().getValue(), 4, failMsg});
            this.writeFailDetailLogByNewTrans(paramsList);
        }
        return true;
    }

    public void execute() throws Exception {
        try {
            if (this.beforeProcess()) {
                this.process();
            }
        }
        catch (Exception e) {
            logger.error((Object)(this.autoCheckTaskInfo.getAutoCheckTaskEnum().getAlias() + " error."), (Throwable)e);
            throw e;
        }
        finally {
            this.AfterProcess();
        }
    }

    public void process() throws Exception {
        if (this.params != null && this.params.getSchmInfo() != null && this.autoCheckTaskInfo != null) {
            AutoCheckSchmInfo schmInfo = this.params.getSchmInfo();
            AbstractObjectCollection OrgUnitEntryColl = null;
            OrgUnitEntryColl = AutoCheckTaskEnum.getCheckData.equals((Object)this.autoCheckTaskInfo.getAutoCheckTaskEnum()) || AutoCheckTaskEnum.checkDataConfirm.equals((Object)this.autoCheckTaskInfo.getAutoCheckTaskEnum()) ? schmInfo.getCompanyEntries() : schmInfo.getOrgUnitEntries();
            this.processByOrgUnits(this.ctx, this.params, OrgUnitEntryColl);
        }
    }

    public void processByOrgUnits(Context ctx, AutoCheckParams params, AbstractObjectCollection orgUnitEntryColl) throws Exception {
        if (orgUnitEntryColl != null) {
            IAutoCheckTaskCatch AutoCheckTaskCatch = AutoCheckTaskCatchImpl.getAutoCheckTaskCatchIntf(ctx);
            HashSet<String> catchIds = new HashSet<String>();
            Object[] CslParamValues = CSLParamUtil.batchGetCslParam((Context)ctx, (String[])new String[]{"KEY_CSLPARAM_AUTOCHECKTASK_SERVER", "KEY_CSLPARAM_AUTOCHECKTASK_PARALLELCOUNT"});
            String server = CslParamValues[0] == null || StringUtils.isEmpty((String)((String)CslParamValues[0])) ? null : CslParamValues[0].toString();
            int parallelCount = CslParamValues[1] == null ? 1 : Integer.valueOf(CslParamValues[1].toString());
            String mutex = "autoCheckTask";
            ArrayList<String> jobList = new ArrayList<String>();
            ArrayList<String> companyIdList = new ArrayList<String>();
            MessageFormat title = new MessageFormat(AccountCheckUtil.getResourceString(ctx, "188_autoCheckTitle", null));
            int index = 1;
            for (int i = 0; i < orgUnitEntryColl.size(); ++i) {
                IObjectValue objValue = orgUnitEntryColl.getObject(i);
                FullOrgUnitInfo orgUnitInfo = null;
                if (objValue instanceof AutoCheckSchmCompEntryInfo) {
                    orgUnitInfo = ((AutoCheckSchmCompEntryInfo)objValue).getCompany();
                } else if (objValue instanceof AutoCheckSchmUnitEntryInfo) {
                    orgUnitInfo = ((AutoCheckSchmUnitEntryInfo)objValue).getOrgUnit();
                }
                if (orgUnitInfo == null || this.hasPermOrgUnits == null || !this.hasPermOrgUnits.contains(orgUnitInfo.getId().toString())) continue;
                String catchKey = params.getSchmLogId() + orgUnitInfo.getId().toString();
                try {
                    catchIds.add(catchKey);
                    OrgUnitAutoCheckJobInfo JobParam = this.createJobParam(ctx, params, orgUnitInfo);
                    String curTitle = title.format(new Object[]{this.autoCheckTaskInfo.getAutoCheckTaskEnum().getAlias(), params.getSchmInfo().getName(), orgUnitInfo.getNumber()});
                    Job job = (Job)CslRptUtil.invokeByManual((Object)this, (String)"createJobByOrgUnit", (Class[])new Class[]{Context.class, Object.class, String.class, String.class, String.class, IJobHandler.class, String.class}, (Object[])new Object[]{ctx, JobParam, curTitle, mutex + index % parallelCount, server, new AutoCheckTaskByOrgUnitHandle(), catchKey}, (int)3);
                    jobList.add(job.getId());
                    companyIdList.add(orgUnitInfo.getId().toString());
                }
                catch (Throwable ex) {
                    catchIds.remove(catchKey);
                    AutoCheckTaskCatch.remove(catchKey);
                    throw new Exception(ex);
                }
                ++index;
            }
            this.addAutoCheckSchmTask(ctx, params, jobList, companyIdList);
            this.waitProcess(AutoCheckTaskCatch, catchIds);
        }
    }

    private void addAutoCheckSchmTask(Context ctx, AutoCheckParams params, List jobList, List companyIdList) throws BOSException, EASBizException {
        if (jobList.size() == 0) {
            return;
        }
        String schmId = params.getSchmInfo().getId().toString();
        RptPeriodTypeEnum periodType = params.getSchmInfo().getPeriodType();
        int year = params.getYear();
        int period = params.getPeriod();
        this.setAutoCheckSchmNoUsage(ctx, schmId);
        AutoCheckSchmTaskInfo taskInfo = null;
        CoreBaseCollection colls = new CoreBaseCollection();
        for (int i = 0; i < jobList.size(); ++i) {
            taskInfo = new AutoCheckSchmTaskInfo();
            taskInfo.setJobinstid((String)jobList.get(i));
            taskInfo.setSchmId(schmId);
            taskInfo.setPeriodType(periodType);
            taskInfo.setYear(year);
            taskInfo.setPeriod(period);
            taskInfo.setCompanyId((String)companyIdList.get(i));
            taskInfo.setIsUsage(true);
            Calendar d = Calendar.getInstance();
            taskInfo.setCreateTime(new Timestamp(d.getTime().getTime()));
            colls.add((CoreBaseInfo)taskInfo);
        }
        AutoCheckSchmTaskFactory.getLocalInstance(ctx).addnew(colls);
    }

    private void setAutoCheckSchmNoUsage(Context ctx, String schmId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Update T_CSL_AutoCheckSchmTask Set FIsUsage = 0 Where FSchmId = '").append(schmId).append("' And FIsUsage = 1");
        DbUtil.execute(ctx, sql.toString());
    }

    protected OrgUnitAutoCheckJobInfo createJobParam(Context ctx, AutoCheckParams params, FullOrgUnitInfo orgUnit) throws Exception {
        if (this.jobInfo == null) {
            this.jobInfo = new OrgUnitAutoCheckJobInfo();
            this.jobInfo.setAutoCheckParams(params);
            this.jobInfo.setAutoTaskInfo(this.autoCheckTaskInfo);
        }
        this.jobInfo.setOrgUnit(orgUnit);
        return this.jobInfo;
    }

    protected void waitProcess(IAutoCheckTaskCatch AutoCheckTaskCatch, Set<String> catchIds) throws Exception {
        HashSet<String> removes = new HashSet<String>();
        while (!catchIds.isEmpty()) {
            Map taskCatch = AutoCheckTaskCatch.getCatch();
            for (String catchkey : catchIds) {
                if (taskCatch.containsKey(catchkey)) break;
                removes.add(catchkey);
            }
            catchIds.removeAll(removes);
            removes.clear();
            if (catchIds.isEmpty()) {
                return;
            }
            Thread.sleep(3000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void executeByOrgUnit(Context ctx, AutoCheckParams params, FullOrgUnitInfo orgUnit) throws Exception {
        String failMsg;
        block13: {
            failMsg = null;
            if (!this.beforeProcessSingleOrgUnit(ctx, params, orgUnit)) break block13;
            this.processSingleOrgUnit(ctx, params, orgUnit);
        }
        try {
            this.afterProcessSingleOrgUnit(ctx, params, orgUnit, failMsg);
        }
        finally {
            AutoCheckTaskCatchImpl.getAutoCheckTaskCatchIntf(ctx).remove(params.getSchmLogId() + orgUnit.getId().toString());
        }
        catch (Exception e) {
            block14: {
                try {
                    logger.error((Object)(this.autoCheckTaskInfo.getAutoCheckTaskEnum().getAlias() + ":" + orgUnit.getName() + " error."), (Throwable)e);
                    failMsg = AccountCheckUtil.getExceptionDetail(e);
                    if (e instanceof EASBizException) break block14;
                    throw e;
                }
                catch (Throwable throwable) {
                    try {
                        this.afterProcessSingleOrgUnit(ctx, params, orgUnit, failMsg);
                    }
                    finally {
                        AutoCheckTaskCatchImpl.getAutoCheckTaskCatchIntf(ctx).remove(params.getSchmLogId() + orgUnit.getId().toString());
                    }
                    throw throwable;
                }
            }
            try {
                this.afterProcessSingleOrgUnit(ctx, params, orgUnit, failMsg);
            }
            finally {
                AutoCheckTaskCatchImpl.getAutoCheckTaskCatchIntf(ctx).remove(params.getSchmLogId() + orgUnit.getId().toString());
            }
        }
    }

    public AutoTaskInfo getAutoCheckTaskInfo() {
        return this.autoCheckTaskInfo;
    }

    public void setAutoCheckTaskInfo(AutoTaskInfo autoCheckTaskInfo) {
        this.autoCheckTaskInfo = autoCheckTaskInfo;
    }

    protected Set<String> getHasPermOrgUnits() throws Exception {
        if (this.autoCheckTaskInfo != null && this.autoCheckTaskInfo.getAutoCheckTaskEnum() != null) {
            String permItem = null;
            switch (this.autoCheckTaskInfo.getAutoCheckTaskEnum().getValue()) {
                case 1: {
                    permItem = "csl_checkwork_generateData";
                    break;
                }
                case 2: {
                    permItem = "csl_checkwork_confirm";
                    break;
                }
                case 3: {
                    permItem = "csl_groupCheckage_diffHandle";
                    break;
                }
                case 4: {
                    permItem = "csl_groupCheckage_audit";
                    break;
                }
                case 5: {
                    permItem = "csl_checkageCreateElim_create";
                }
            }
            if (permItem != null) {
                AbstractObjectCollection coll = null;
                if (this.autoCheckTaskInfo.getAutoCheckTaskEnum().getValue() == 1 || this.autoCheckTaskInfo.getAutoCheckTaskEnum().getValue() == 2) {
                    coll = this.params.getSchmInfo().getCompanyEntries();
                } else {
                    AccountCheckUtil.initOrgTree(this.ctx, this.params);
                    coll = this.params.getSchmInfo().getOrgUnitEntries();
                }
                IObjectPK[] orgPKs = new IObjectPK[coll.size()];
                for (int i = 0; i < coll.size(); ++i) {
                    IObjectValue objValue = coll.getObject(i);
                    FullOrgUnitInfo orgUnitInfo = null;
                    if (objValue instanceof AutoCheckSchmCompEntryInfo) {
                        orgUnitInfo = ((AutoCheckSchmCompEntryInfo)objValue).getCompany();
                    } else if (objValue instanceof AutoCheckSchmUnitEntryInfo) {
                        orgUnitInfo = ((AutoCheckSchmUnitEntryInfo)objValue).getOrgUnit();
                    }
                    if (orgUnitInfo == null || orgUnitInfo.getId() == null) continue;
                    orgPKs[i] = new ObjectStringPK(orgUnitInfo.getId().toString());
                }
                this.hasPermOrgUnits = PermissionFactory.getLocalInstance((Context)this.ctx).checkBatchPermission((IObjectPK)new ObjectUuidPK(this.params.getUserId()), orgPKs, permItem);
                if (this.hasPermOrgUnits == null) {
                    this.hasPermOrgUnits = new HashSet<String>();
                }
            }
        }
        return this.hasPermOrgUnits;
    }

    protected void writePermDetailFailLog() throws Exception {
        if (this.hasPermOrgUnits != null) {
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            AbstractObjectCollection coll = null;
            coll = this.autoCheckTaskInfo.getAutoCheckTaskEnum().getValue() == 1 || this.autoCheckTaskInfo.getAutoCheckTaskEnum().getValue() == 2 ? this.params.getSchmInfo().getCompanyEntries() : this.params.getSchmInfo().getOrgUnitEntries();
            String orgUnitId = null;
            ArrayList<FullOrgUnitInfo> failOrgUnits = new ArrayList<FullOrgUnitInfo>();
            ArrayList<String> noPermissionCompanyList = new ArrayList<String>();
            for (int i = 0; i < coll.size(); ++i) {
                String failDetail = null;
                IObjectValue objValue = coll.getObject(i);
                FullOrgUnitInfo orgUnitInfo = null;
                if (objValue instanceof AutoCheckSchmCompEntryInfo) {
                    orgUnitInfo = ((AutoCheckSchmCompEntryInfo)objValue).getCompany();
                    orgUnitId = orgUnitInfo.getId().toString();
                    if (!this.hasPermOrgUnits.contains(orgUnitId)) {
                        noPermissionCompanyList.add(orgUnitInfo.getId().toString());
                        if (StringUtils.isEmpty(failDetail)) {
                            switch (this.autoCheckTaskInfo.getAutoCheckTaskEnum().getValue()) {
                                case 1: {
                                    failDetail = AccountCheckUtil.getResourceString(this.ctx, "hasNoPermission", new Object[]{orgUnitInfo.getName(), AccountCheckUtil.getResourceString(this.ctx, "generateData_Permission", null)});
                                    break;
                                }
                                case 2: {
                                    failDetail = AccountCheckUtil.getResourceString(this.ctx, "hasNoPermission", new Object[]{orgUnitInfo.getName(), AccountCheckUtil.getResourceString(this.ctx, "confirm_Permission", null)});
                                }
                            }
                        }
                    }
                } else if (objValue instanceof AutoCheckSchmUnitEntryInfo && !this.hasPermOrgUnits.contains(orgUnitId = (orgUnitInfo = ((AutoCheckSchmUnitEntryInfo)objValue).getOrgUnit()).getId().toString())) {
                    if (StringUtils.isEmpty(failDetail)) {
                        switch (this.autoCheckTaskInfo.getAutoCheckTaskEnum().getValue()) {
                            case 3: {
                                failDetail = AccountCheckUtil.getResourceString(this.ctx, "108noDiffPermission", null);
                                break;
                            }
                            case 4: {
                                failDetail = AccountCheckUtil.getResourceString(this.ctx, "113noAuditPermisson", null);
                                break;
                            }
                            case 5: {
                                failDetail = AccountCheckUtil.getResourceString(this.ctx, "173_noCreateElimPermission", null);
                            }
                        }
                    }
                    failOrgUnits.add(orgUnitInfo);
                }
                if (StringUtils.isEmpty(failDetail)) continue;
                paramsList.add(new Object[]{this.params.getSchmLogId(), orgUnitId, this.autoCheckTaskInfo.getAutoCheckTaskEnum().getValue(), 4, failDetail});
            }
            if (!failOrgUnits.isEmpty()) {
                this.writerOrgUnitLogByNewTrans(this.ctx, this.params, failOrgUnits.toArray(new FullOrgUnitInfo[failOrgUnits.size()]), false, false);
            }
            this.writeFailDetailLogByNewTrans(paramsList);
            this.writeFailUnitLogByNewTrans(noPermissionCompanyList, this.params.getSchmLogId(), this.autoCheckTaskInfo.getAutoCheckTaskEnum().getValue());
        }
    }

    private void writeFailUnitLogByNewTrans(List noPermissionCompanyList, String schmLogId, int autoCheckTaskValue) throws Exception {
        CslRptUtil.invokeByManual((Object)this, (String)"writeFailUnitLog", (Class[])new Class[]{List.class, String.class, Integer.TYPE}, (Object[])new Object[]{noPermissionCompanyList, schmLogId, autoCheckTaskValue}, (int)3);
    }

    public void writeFailUnitLog(List noPermissionCompanyList, String schmLogId, int autoCheckTaskValue) throws Exception {
        if (noPermissionCompanyList == null || noPermissionCompanyList.isEmpty()) {
            return;
        }
        SQLBuilder sql = new SQLBuilder();
        sql.append("select top 1 fid from T_Csl_AutoCheckSchmUnitLog where FSchmLogId=? \n", schmLogId);
        sql.append("and FOwnCompanyId in \n", noPermissionCompanyList);
        sql.append("and FTargetCompanyId is null");
        IRowSet row = DbUtil.executeQuery(this.ctx, sql.getSQL(), sql.getParams());
        if (row != null && row.size() > 0) {
            this.updateFailUnitLog(noPermissionCompanyList, schmLogId, autoCheckTaskValue);
        } else {
            this.insertFailUnitLog(noPermissionCompanyList, schmLogId, autoCheckTaskValue);
        }
    }

    private void insertFailUnitLog(List noPermissionCompanyList, String schmLogId, int autoCheckTaskValue) throws Exception {
        Timestamp nowTime = new Timestamp(new Date().getTime());
        String userId = this.ctx.getCaller().toString();
        SQLBuilder sql = new SQLBuilder();
        String filed = "FGetDataExecStatus";
        if (2 == autoCheckTaskValue) {
            filed = "FConfirmExecStatus";
        }
        String bosType = new AutoCheckSchmUnitLogInfo().getBOSType().toString();
        sql.append("insert into T_Csl_AutoCheckSchmUnitLog(fid,FSchmLogId,FOwnCompanyId,").append(filed);
        sql.append(",FcreateTime,fcreatorId,flastUpdateUserId,flastUpdateTime) \n");
        sql.append("values(newbosid('" + bosType + "'),?,?,?,?,?,?,?)");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] parm = null;
        for (int i = 0; i < noPermissionCompanyList.size(); ++i) {
            parm = new Object[]{schmLogId, noPermissionCompanyList.get(i), 4, nowTime, userId, userId, nowTime};
            paramList.add(parm);
        }
        DbUtil.executeBatch(this.ctx, sql.getSQL(), paramList);
    }

    private void updateFailUnitLog(List noPermissionCompanyList, String schmLogId, int autoCheckTaskValue) throws Exception {
        Timestamp nowTime = new Timestamp(new Date().getTime());
        String userId = this.ctx.getCaller().toString();
        SQLBuilder sql = new SQLBuilder();
        String filed = "FGetDataExecStatus";
        if (2 == autoCheckTaskValue) {
            filed = "FConfirmExecStatus";
        }
        sql.append("update T_Csl_AutoCheckSchmUnitLog set ").append(filed).append("=").append(4);
        sql.append(",flastUpdateUserId=?", userId);
        sql.append(",flastUpdateTime=? \n", nowTime);
        sql.append("where FOwnCompanyId in", noPermissionCompanyList);
        sql.append(" and FSchmLogId=? \n", schmLogId);
        sql.append("and FTargetCompanyId is null");
        DbUtil.execute(this.ctx, sql.getSQL(), sql.getParams());
    }

    protected void writeFailDetailLogByNewTrans(List paramsList) throws Exception {
        CslRptUtil.invokeByManual((Object)this, (String)"writeFailDetailLog", (Class[])new Class[]{List.class}, (Object[])new Object[]{paramsList}, (int)3);
    }

    public void writeFailDetailLog(List paramsList) throws Exception {
        if (!paramsList.isEmpty()) {
            SQLBuilder sql = new SQLBuilder();
            String bosType = new AutoCheckSchmDetailLogInfo().getBOSType().toString();
            sql.append("insert into T_Csl_AutoCheckSchmDetailLog(fid,fschmLogId,forgUnitId,fautoExecStep,fexecStatus,ffailDetail) values(newbosid('" + bosType + "'),?,?,?,?,?) ");
            DbUtil.executeBatch(this.ctx, sql.getSQL(), paramsList);
        }
    }

    protected void updateExecTaskCountByNewTrans(Context ctx, AutoCheckParams params, FullOrgUnitInfo orgUnit, boolean isSuccess, boolean isBeforeProcess) throws Exception {
        CslRptUtil.invokeByManual((Object)this, (String)"updateExecTaskCount", (Class[])new Class[]{Context.class, AutoCheckParams.class, FullOrgUnitInfo.class, Boolean.TYPE, Boolean.TYPE}, (Object[])new Object[]{ctx, params, orgUnit, isSuccess, isBeforeProcess}, (int)3);
    }

    public void updateExecTaskCount(Context ctx, AutoCheckParams params, FullOrgUnitInfo orgUnit, boolean isSuccess, boolean isBeforeProcess) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        if (isBeforeProcess) {
            sql.append(" update T_Csl_AutoCheckSchmLog set fexecCount=fexecCount+1,funExecCount=funExecCount-1 where fid=? ", params.getSchmLogId());
        } else if (isSuccess) {
            sql.append(" update T_Csl_AutoCheckSchmLog set fexecCount=fexecCount-1,FSuccessCount=FSuccessCount+1 where fid=? ", params.getSchmLogId());
        } else {
            sql.append(" update T_Csl_AutoCheckSchmLog set fexecCount=fexecCount-1,FFailCount=FFailCount+1 where fid=? ", params.getSchmLogId());
        }
        DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
    }

    protected boolean writerOrgUnitLogByNewTrans(Context ctx, AutoCheckParams params, FullOrgUnitInfo[] orgUnits, boolean isSuccess, boolean isBeforeProcess) throws Exception {
        return (Boolean)CslRptUtil.invokeByManual((Object)this, (String)"writerOrgUnitLog", (Class[])new Class[]{Context.class, AutoCheckParams.class, FullOrgUnitInfo[].class, Boolean.TYPE, Boolean.TYPE}, (Object[])new Object[]{ctx, params, orgUnits, isSuccess, isBeforeProcess}, (int)3);
    }

    public boolean writerOrgUnitLog(Context ctx, AutoCheckParams params, FullOrgUnitInfo[] orgUnits, boolean isSuccess, boolean isBeforeProcess) throws Exception {
        AutoTaskInfo preTaskInfo = this.getAutoCheckTaskInfo().getPreTaskInfo();
        if (!(isBeforeProcess || preTaskInfo != null && this.isExistLog(ctx, params, orgUnits[0]))) {
            this.insertOrgUnitExecLog(ctx, orgUnits[0], isSuccess);
        } else if (preTaskInfo != null && (preTaskInfo.getAutoCheckTaskEnum().equals((Object)AutoCheckTaskEnum.diffHandle) || preTaskInfo.getAutoCheckTaskEnum().equals((Object)AutoCheckTaskEnum.checkDataAudit) || preTaskInfo.getAutoCheckTaskEnum().equals((Object)AutoCheckTaskEnum.getCheckData) && this.getAutoCheckTaskInfo().getAutoCheckTaskEnum().equals((Object)AutoCheckTaskEnum.checkDataConfirm))) {
            int status = 2;
            if (!isBeforeProcess) {
                status = isSuccess ? 3 : 4;
            }
            this.updateOrgUnitsExecStatus(ctx, params, orgUnits, status);
        }
        return true;
    }

    protected boolean isExistLog(Context ctx, AutoCheckParams params, FullOrgUnitInfo orgUnit) throws Exception {
        IRowSet rowSet;
        AutoCheckTaskEnum curTaskEnum = this.getAutoCheckTaskInfo().getAutoCheckTaskEnum();
        String filterOrgField = "FOrgUnitId";
        boolean isCompany = false;
        if (curTaskEnum.equals((Object)AutoCheckTaskEnum.checkDataConfirm) || curTaskEnum.equals((Object)AutoCheckTaskEnum.getCheckData)) {
            filterOrgField = "FOwnCompanyId";
            isCompany = true;
        }
        SQLBuilder sql = new SQLBuilder();
        sql.append("select 1 from T_Csl_AutoCheckSchmLog log ");
        sql.append(" inner join T_Csl_AutoCheckSchmUnitLog unitlog on log.fid=unitlog.FSchmLogId ");
        sql.append(" where log.FSchmId=?", params.getSchmInfo().getId().toString());
        sql.append(" and log.FYear=?", params.getYear());
        sql.append(" and log.FPeriod=?", params.getPeriod());
        sql.append(" and log.FPeriodType=?", params.getSchmInfo().getPeriodType());
        sql.append(" and unitlog.").append(filterOrgField).append("=?", orgUnit.getId().toString());
        if (isCompany) {
            sql.append(" and unitlog.FOrgUnitId is null");
        }
        return (rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams())) != null && rowSet.size() > 0;
    }

    protected void insertOrgUnitExecLog(Context ctx, FullOrgUnitInfo orgUnit, boolean isSuccess) throws Exception {
    }

    protected void updateOrgUnitsExecStatus(Context ctx, AutoCheckParams params, FullOrgUnitInfo[] orgUnits, int status) throws Exception {
        AutoCheckTaskEnum curTaskEnum = this.getAutoCheckTaskInfo().getAutoCheckTaskEnum();
        SQLBuilder sql = new SQLBuilder();
        String statusField = null;
        String filterOrgField = "forgUnitId";
        boolean isCompany = false;
        if (curTaskEnum.equals((Object)AutoCheckTaskEnum.checkDataAudit)) {
            statusField = "FAuditExecStatus";
        } else if (curTaskEnum.equals((Object)AutoCheckTaskEnum.createElim)) {
            statusField = "FCreateElimExecStatus";
        } else if (curTaskEnum.equals((Object)AutoCheckTaskEnum.checkDataConfirm)) {
            statusField = "FConfirmExecStatus";
            filterOrgField = "FOwnCompanyId";
            isCompany = true;
        }
        if (statusField != null) {
            sql.append(" update T_Csl_AutoCheckSchmUnitLog set ").append(statusField).append("=?", status);
            sql.append(" where FSchmLogId=?", params.getSchmLogId());
            sql.append(" and ").append(filterOrgField).append(" in ", orgUnits);
            if (isCompany) {
                sql.append(" and forgUnitId is null");
            }
            DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
        }
    }

    public Job createJobByOrgUnit(Context ctx, Object param, String title, String mutex, String server, IJobHandler jobHandler, String catchKey) throws Exception {
        JobInstanceConfig jobInstance = new JobInstanceConfig(jobHandler, true, false, 1000000, mutex, null, JobIsolationLevel.Server);
        Timestamp scheduledTime = new Timestamp(System.currentTimeMillis());
        Job job = new Job(ctx, title, jobInstance, param, scheduledTime, null, -1, server);
        AutoCheckTaskCatchImpl.getAutoCheckTaskCatchIntf(ctx).put(catchKey, job.getId());
        try {
            JobManager.instance().add(job);
        }
        catch (Exception e) {
            logger.error((Object)("AbstractAutoCheckTask.createJobByOrgUnit" + ((OrgUnitAutoCheckJobInfo)param).getOrgUnit().getNumber()), (Throwable)e);
            throw e;
        }
        return job;
    }
}

