/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobInstanceConfig;
import com.kingdee.bos.service.job.core.JobIsolationLevel;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmLogFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmLogInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckTaskEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AbstractAutoCheckTask;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AutoCheckParams;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AutoCheckTaskFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AutoTaskInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;

public class AutoCheckSchemeHandle
implements IJobHandler {
    protected static final Logger logger = Logger.getLogger(AutoCheckSchemeHandle.class);

    public Object execute(Job job) throws Exception {
        AutoCheckParams autoCheckParams = (AutoCheckParams)job.getParameters();
        if (autoCheckParams != null) {
            AutoCheckSchmInfo autoCheckSchmInfo = autoCheckParams.getSchmInfo();
            if (autoCheckSchmInfo.getItemType() == null) {
                autoCheckSchmInfo.setItemType(ItemTypeEnum.account);
            }
            if (autoCheckSchmInfo != null) {
                ArrayList<AbstractAutoCheckTask> tasks = new ArrayList<AbstractAutoCheckTask>();
                LinkedHashMap<String, AutoCheckTaskEnum> taskeMap = new LinkedHashMap<String, AutoCheckTaskEnum>();
                taskeMap.put("isGetCheckData", AutoCheckTaskEnum.getCheckData);
                taskeMap.put("isConfirm", AutoCheckTaskEnum.checkDataConfirm);
                taskeMap.put("isDiffHandle", AutoCheckTaskEnum.diffHandle);
                taskeMap.put("isAudit", AutoCheckTaskEnum.checkDataAudit);
                taskeMap.put("isCreateElim", AutoCheckTaskEnum.createElim);
                for (String taskName : taskeMap.keySet()) {
                    boolean isExecute = autoCheckSchmInfo.getBoolean(taskName);
                    if (!isExecute) continue;
                    AutoTaskInfo autoCheckTask = new AutoTaskInfo();
                    autoCheckTask.setAutoCheckTaskEnum((AutoCheckTaskEnum)((Object)taskeMap.get(taskName)));
                    tasks.add(AutoCheckTaskFactory.getTask(job.getContext(), autoCheckParams, autoCheckTask));
                }
                this.writerLogByNewTrans(job.getContext(), autoCheckParams, tasks.size());
                if (!tasks.isEmpty()) {
                    for (int i = 0; i < tasks.size(); ++i) {
                        AutoTaskInfo preTaskInfo = null;
                        AutoTaskInfo nextTaskInfo = null;
                        if (i > 0) {
                            preTaskInfo = ((AbstractAutoCheckTask)tasks.get(i - 1)).getAutoCheckTaskInfo();
                        }
                        if (i + 1 < tasks.size()) {
                            nextTaskInfo = ((AbstractAutoCheckTask)tasks.get(i + 1)).getAutoCheckTaskInfo();
                        }
                        AutoTaskInfo curTaskInfo = ((AbstractAutoCheckTask)tasks.get(i)).getAutoCheckTaskInfo();
                        curTaskInfo.setNextTaskInfo(nextTaskInfo);
                        curTaskInfo.setPreTaskInfo(preTaskInfo);
                        ((AbstractAutoCheckTask)tasks.get(i)).execute();
                    }
                }
            }
        }
        return null;
    }

    protected void writerLogByNewTrans(Context ctx, AutoCheckParams autoCheckParams, int taskCount) throws Exception {
        String schmLogId = (String)CslRptUtil.invokeByManual((Object)this, (String)"writerLog", (Class[])new Class[]{Context.class, AutoCheckParams.class, Integer.TYPE}, (Object[])new Object[]{ctx, autoCheckParams, taskCount}, (int)3);
        if (schmLogId != null) {
            autoCheckParams.setSchmLogId(schmLogId);
        }
    }

    public String writerLog(Context ctx, AutoCheckParams autoCheckParams, int taskCount) throws Exception {
        AccountCheckUtil.initOrgTree(ctx, autoCheckParams);
        AutoCheckSchmInfo autoCheckSchmInfo = autoCheckParams.getSchmInfo();
        if (autoCheckSchmInfo != null && taskCount > 0) {
            this.deleteExistsLog(ctx, autoCheckParams);
            AutoCheckSchmLogInfo schmLog = new AutoCheckSchmLogInfo();
            schmLog.setSchmId(autoCheckSchmInfo.getId().toString());
            schmLog.setCurrency(autoCheckSchmInfo.getCurrency());
            schmLog.setPeriodType(autoCheckSchmInfo.getPeriodType());
            schmLog.setYear(autoCheckParams.getYear());
            schmLog.setPeriod(autoCheckParams.getPeriod());
            schmLog.setItemType(autoCheckSchmInfo.getItemType());
            if (autoCheckSchmInfo.getOrgTree() != null && autoCheckSchmInfo.getOrgTree().getId() != null) {
                schmLog.setOrgBoundId(autoCheckSchmInfo.getOrgTree().getId().toString());
            }
            int size = 0;
            if (autoCheckSchmInfo.getCompanyEntries() != null && !autoCheckSchmInfo.getCompanyEntries().isEmpty()) {
                size += autoCheckSchmInfo.getCompanyEntries().size();
            }
            if (autoCheckSchmInfo.getOrgUnitEntries() != null && !autoCheckSchmInfo.getOrgUnitEntries().isEmpty()) {
                size += autoCheckSchmInfo.getOrgUnitEntries().size();
            }
            schmLog.setUnExecCount(taskCount * size);
            IObjectPK schmLogId = AutoCheckSchmLogFactory.getLocalInstance(ctx).addnew(schmLog);
            return schmLogId.toString();
        }
        return null;
    }

    protected void deleteExistsLog(Context ctx, AutoCheckParams autoCheckParams) throws Exception {
        AutoCheckSchmInfo autoCheckSchmInfo = autoCheckParams.getSchmInfo();
        if (autoCheckSchmInfo != null) {
            String schmLogId;
            SQLBuilder sql = new SQLBuilder();
            sql.append(" select fid from T_Csl_AutoCheckSchmLog ");
            sql.append(" where FSchmId=? ", autoCheckSchmInfo.getId().toString());
            sql.append(" and FCurrencyId=? ", autoCheckSchmInfo.getCurrency().getId().toString());
            sql.append(" and FperiodType=? ", autoCheckSchmInfo.getPeriodType().getValue());
            sql.append(" and FYear=? ", autoCheckParams.getYear());
            sql.append(" and FPeriod=? ", autoCheckParams.getPeriod());
            sql.append(" and FitemType=? ", autoCheckSchmInfo.getItemType().getValue());
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            if (rowSet != null && rowSet.next() && !StringUtils.isEmpty((String)(schmLogId = rowSet.getString("fid")))) {
                sql.reset();
                sql.append("delete from T_Csl_AutoCheckSchmUnitLog where FSchmLogId=? ", schmLogId);
                DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
                sql.reset();
                sql.append("delete from T_Csl_AutoCheckSchmLog where fid=? ", schmLogId);
                DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
                sql.reset();
                sql.append("delete from t_csl_autocheckschmdetaillog where FSchmLogId=? ", schmLogId);
                DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
            }
        }
    }

    public static void executeTest(Context ctx) throws Exception {
        AutoCheckParams params = new AutoCheckParams();
        AutoCheckSchemeHandle handle = new AutoCheckSchemeHandle();
        String schmId = "c6oAAACUQSCItMgg";
        String oql = "select name,number,periodType,currency.id,currency.number,currency.precision,isGetCheckData,isConfirm,isDiffHandle,isAudit,isCreateElim,isCoverGetChkData,confirmSDiffCmpChar,confirmSDffCmpValueconfirmDDiffCmpChar,confirmDDiffCmpValue,singleDiffMode,doubleDiffMode,auditSDiffCmpChar,auditSDiffCmpValue,auditDDiffCmpChar,auditDDiffCmpValue,orgTree.id,orgTree.number,orgUnitEntries.orgUnit.id,orgUnitEntries.orgUnit.number,companyEntries.company.id,companyEntries.company.number where id='" + schmId + "'";
        params.setSchmInfo(AutoCheckSchmFactory.getLocalInstance(ctx).getAutoCheckSchmInfo(oql));
        params.setPeriod(1);
        params.setYear(2018);
        params.setUserId(ctx.getCaller().toString());
        Timestamp scheduledTime = new Timestamp(System.currentTimeMillis());
        JobInstanceConfig jobInstance = new JobInstanceConfig((IJobHandler)handle, true, false, 1, "tttt", null, JobIsolationLevel.Server);
        Job job = new Job(ctx, "", jobInstance, (Object)params, scheduledTime, null, -1, null);
        handle.execute(job);
    }
}

