/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckFacadeFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckWorkeFilterInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmUnitLogInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AbstractAutoCheckTask;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AutoCheckException;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AutoCheckParams;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class AutoConfirmCheckDataHandleTask
extends AbstractAutoCheckTask {
    private static final Logger logger = Logger.getLogger(AutoConfirmCheckDataHandleTask.class);

    @Override
    protected void processSingleOrgUnit(Context ctx, AutoCheckParams autoCheckParams, FullOrgUnitInfo orgUnit) throws Exception {
        int[] periods = autoCheckParams.getPeriods();
        AccountCheckWorkeFilterInfo filterInfo = AutoConfirmCheckDataHandleTask.getAccountCheckWorkeFilter(ctx, autoCheckParams, orgUnit);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("autoCheckParams", autoCheckParams);
        for (int i = 0; i < periods.length; ++i) {
            int period = periods[i];
            filterInfo.setPeriod(period);
            params.put("filterInfo", filterInfo);
            AccountCheckFacadeFactory.getLocalInstance(ctx).confirmDataBySchm(params);
        }
    }

    public static AccountCheckWorkeFilterInfo getAccountCheckWorkeFilter(Context ctx, AutoCheckParams autoCheckParams, FullOrgUnitInfo orgUnit) throws AutoCheckException {
        String checkageCompanyId = orgUnit.getId().toString();
        AutoCheckSchmInfo schmInfo = autoCheckParams.getSchmInfo();
        CurrencyInfo currency = schmInfo.getCurrency();
        int year = autoCheckParams.getYear();
        String currencyNumber = currency.getNumber();
        String currencyId = currency.getId().toString();
        if (StringUtils.isEmpty((String)currencyNumber)) {
            try {
                CurrencyCollection currencyCollection = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection("select number where id='" + currencyId + "'");
                if (currencyCollection != null && currencyCollection.size() > 0) {
                    currencyNumber = currencyCollection.get(0).getNumber();
                }
            }
            catch (BOSException e) {
                logger.error((Object)"getAccountCheckWorkeFilter_getCurrency_error", (Throwable)e);
                throw new AutoCheckException("getAccountCheckWorkeFilter_getCurrency_error");
            }
        }
        AccountCheckWorkeFilterInfo filterInfo = new AccountCheckWorkeFilterInfo();
        filterInfo.setAccountCheckCompanyId(checkageCompanyId);
        filterInfo.setYear(year);
        filterInfo.setCurrencyId(currencyId);
        filterInfo.setCurrencyNumber(currencyNumber);
        return filterInfo;
    }

    @Override
    protected void insertOrgUnitExecLog(Context ctx, FullOrgUnitInfo orgUnit, boolean isSuccess) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        String bosType = new AutoCheckSchmUnitLogInfo().getBOSType().toString();
        String schmLogId = this.params.getSchmLogId();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String curTime = "{ts'" + formatter.format(new Date()) + "'}";
        AutoCheckSchmInfo schmInfo = this.params.getSchmInfo();
        int year = this.params.getYear();
        int[] periods = this.params.getPeriods();
        HashSet<Integer> periodSet = new HashSet<Integer>();
        for (int i : periods) {
            periodSet.add(i);
        }
        CurrencyInfo currency = schmInfo.getCurrency();
        String schmId = schmInfo.getId().toString();
        String creatorId = ctx.getCaller().toString();
        String orgUnitId = orgUnit.getId().toString();
        int getCheckDataStatus = this.params.getSchmInfo().isIsGetCheckData() ? 3 : 0;
        int confirmExecStatus = isSuccess ? 3 : 4;
        sql.append("insert into T_Csl_AutoCheckSchmUnitLog(fid,FSchmLogId,FOwnCompanyId,FTargetCompanyId,FGetDataExecStatus,FConfirmExecStatus,");
        sql.append("FDiffAmount,FcreateTime,fcreatorId,flastUpdateUserId,flastUpdateTime) \n");
        sql.append(" select newbosid('").append(bosType).append("') fid,'").append(schmLogId).append("' FSchmLogId, \n");
        sql.append("'").append(orgUnitId).append("' FOwnCompanyId, case when min(rs.targetCompanyId2)=? then max(rs.targetCompanyId2) else min(rs.targetCompanyId2) end FTargetCompanyId, \n", orgUnitId);
        sql.append(getCheckDataStatus).append(" FGetDataExecStatus, ").append(confirmExecStatus).append(" FConfirmExecStatus, \n");
        sql.append("isnull(sum(rs.confirmDebit2),0)-isnull(sum(rs.confirmCredit2),0) diffAmount,").append(curTime).append(" FcreateTime,'").append(creatorId).append("' fcreatorId,\n");
        sql.append("'").append(creatorId).append("' flastUpdateUserId,").append(curTime).append(" flastUpdateTime ");
        sql.append("from (  \n");
        sql.append("select bill2.FCompanyId ownCompanyId2,bill2.ftargetCompanyId targetCompanyId2,  \n");
        sql.append("case when bill2.FCompanyId>bill2.FTargetCompanyId then concat(bill2.FCompanyId, bill2.FTargetCompanyId)   \n");
        sql.append("else concat(bill2.FTargetCompanyId,bill2.FCompanyId) end companyKey,  \n");
        sql.append("bill2.FConfirmDebit confirmDebit2, bill2.FConfirmCredit confirmCredit2  \n");
        sql.append("from T_Csl_CheckageBill bill2  \n");
        sql.append("where bill2.FbillHeadId in   \n");
        sql.append("(  \n");
        sql.append("select distinct bill1.FbillHeadId  \n");
        sql.append("from T_Csl_CheckageBill bill1  \n");
        sql.append("inner join T_Csl_CheckageBillCompany billCompany on billCompany.fid=bill1.FBillCompanyId  \n");
        sql.append("where billCompany.FConfirmSchmId=?  \n", schmId);
        sql.append("and bill1.FYear=?  \n", year);
        sql.append("and bill1.FPeriod in  \n", periodSet);
        sql.append("and bill1.FCurrencyId=?  \n", currency.getId().toString());
        sql.append("and bill1.FCompanyId=?  \n", orgUnitId);
        sql.append(")  \n");
        sql.append(") rs  \n");
        sql.append("group by rs.companyKey");
        DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
    }
}

