/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.DiffModeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageFilterInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.ICheckageBill;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AbstractAutoCheckOrgUnitTask;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AutoCheckParams;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class AutoDiffHandleTask
extends AbstractAutoCheckOrgUnitTask {
    private static Logger logger = Logger.getLogger(AutoDiffHandleTask.class);
    private int batchSize = 300;

    @Override
    public void processSingleOrgUnit(Context ctx, AutoCheckParams params, FullOrgUnitInfo orgUnit) throws Exception {
        CheckageFilterInfo filterInfo = null;
        AccountCheckUtil.initOrgTree(ctx, params);
        ICheckageBill checkageBillInf = CheckageBillFactory.getLocalInstance(ctx);
        filterInfo = checkageBillInf.prepareFetchGroupCheckageBill(this.initFilterInfo(params, orgUnit));
        if (!StringUtils.isEmpty((String)filterInfo.tmpTable)) {
            this.sameParentCompanysTbl = filterInfo.sameParentCompanyTbl;
            this.batchDiffHandle(ctx, params, filterInfo.tmpTable, true);
            this.batchDiffHandle(ctx, params, filterInfo.tmpTable, false);
        }
    }

    protected void batchDiffHandle(Context ctx, AutoCheckParams params, String tmpTable, boolean isSingleDiffHandle) throws Exception {
        DiffModeEnum diffModeEnum;
        AutoCheckSchmInfo schmInfo = params.getSchmInfo();
        DiffModeEnum diffModeEnum2 = diffModeEnum = isSingleDiffHandle ? schmInfo.getSingleDiffMode() : schmInfo.getDoubleDiffMode();
        if (diffModeEnum != null && !diffModeEnum.equals((Object)DiffModeEnum.FetchHandCraft)) {
            SQLBuilder sql = new SQLBuilder();
            sql.append(" select distinct billHead.fid ");
            sql.append(" from T_Csl_CheckageBillHead billHead ");
            sql.append(" inner join T_Csl_AccountMap acctMap on acctMap.fid=billHead.FAccountMapId ");
            if (!isSingleDiffHandle) {
                sql.append(" inner join (");
                sql.append("       select count(*),rs1.headId from (");
                sql.append("            select distinct a.fid headId,b.fcompanyid companyId,c.FCONFIRMSTATUS from T_Csl_CheckageBillHead a");
                sql.append("            inner join t_csl_checkagebill b on a.fid=b.FBILLHEADID");
                sql.append("            inner join t_csl_checkagebillcompany c on c.fid=b.FBILLCOMPANYID");
                sql.append("            inner join ").append(tmpTable).append(" tmp on tmp.fid=a.fid ");
                sql.append("            where c.FCONFIRMSTATUS=1 ) rs1 group by rs1.headId having count(*)>=2 ");
                sql.append("      ) head on billHead.fid=head.headId ");
            } else {
                sql.append(" where billHead.fid in(select fid from  ").append(tmpTable).append(" ) ");
            }
            sql.append(" and acctMap.FIsUnilateralReconciliation=").append(isSingleDiffHandle ? "1" : "0");
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL());
            if (rowSet != null) {
                ArrayList<String> billHeadIds = new ArrayList<String>();
                while (rowSet.next()) {
                    if (billHeadIds.size() < this.batchSize) {
                        billHeadIds.add(rowSet.getString(1));
                        continue;
                    }
                    AccountCheckUtil.diffHandle(ctx, billHeadIds, diffModeEnum, schmInfo.getId().toString());
                    billHeadIds.clear();
                }
                if (!billHeadIds.isEmpty()) {
                    AccountCheckUtil.diffHandle(ctx, billHeadIds, diffModeEnum, schmInfo.getId().toString());
                }
            }
        }
    }

    protected CheckageFilterInfo initFilterInfo(AutoCheckParams params, FullOrgUnitInfo orgUnit) {
        CheckageFilterInfo filterInfo = super.initCommonFilterInfo(params, orgUnit);
        filterInfo.confirmStatus = 1;
        filterInfo.auditStatus = 1;
        return filterInfo;
    }
}

