/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app.importFromRpt;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.UserObject;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslReportCollection;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckFacadeFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckWorkeFilterInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillDataInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageOrgPackInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.DataSourceEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.app.CheckDataImport;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.newrpt.util.TemplateItemListNewUtil;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.framework.AbstractDataBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ImportFromRptUtil {
    private static final Logger logger = Logger.getLogger(ImportFromRptUtil.class);
    public static ImportFromRptUtil importFromRptUtil = null;

    public static synchronized ImportFromRptUtil getInstance() {
        if (importFromRptUtil == null) {
            importFromRptUtil = new ImportFromRptUtil();
        }
        return importFromRptUtil;
    }

    public String importItemDatasFromCheckAgeBillRpt(Context ctx, Map<String, List<String>> templates, List<String> orgUnitIds, int year, int period, int periodType, String currencyId, int[] rptAuditStatus, int[] rptCommitStatus, int importMode) throws Exception {
        if (templates != null && !templates.isEmpty()) {
            String tmpTable = null;
            try {
                HashMap<String, String> templateId_srcTemplateIds;
                OneToManyMap tmplateId_rptIds;
                StringBuffer msg = new StringBuffer();
                this.checkBeforeHandle(ctx, orgUnitIds, periodType, year, period, msg);
                if (!(orgUnitIds.isEmpty() || (tmplateId_rptIds = this.getReportIds(ctx, templates, orgUnitIds, year, period, periodType, currencyId, rptAuditStatus, rptCommitStatus, templateId_srcTemplateIds = new HashMap<String, String>(), msg, "checkDataRpt")).isEmpty() || StringUtils.isEmpty((String)(tmpTable = this.getImportDataTmpTable(ctx))))) {
                    Map<String, ImportTemplateInfo> importTemplateMap = this.getImportTemplateInfo(ctx, tmplateId_rptIds.keySet(), templates, templateId_srcTemplateIds);
                    for (Object templateId : tmplateId_rptIds.keySet()) {
                        ImportTemplateInfo importTemplateInfo = importTemplateMap.get(templateId);
                        List rptIds = (List)tmplateId_rptIds.get(templateId);
                        this.importFromCheckAgeBillRpt(ctx, tmpTable, (String)templateId, rptIds, importTemplateInfo.sheetNames, msg);
                    }
                    this.importRptCheckAgeBillDataFromTmp(ctx, tmpTable, importMode, msg);
                }
                String string = msg.toString();
                return string;
            }
            catch (Exception e) {
                logger.error((Object)"importItemDatasFromCheckAgeBillRpt error.", (Throwable)e);
                throw e;
            }
            finally {
                if (!DebugLogger.isDebug) {
                    TempTablePool tempTablePool = TempTablePool.getInstance((Context)ctx);
                    if (!StringUtils.isEmpty(tmpTable)) {
                        tempTablePool.releaseTable(tmpTable);
                    }
                }
            }
        }
        return null;
    }

    private void importRptCheckAgeBillDataFromTmp(Context ctx, String tmpTable, int importMode, StringBuffer msg) throws Exception {
        HashSet noPermissionCompanyNumberSet = new HashSet();
        CheckDataImport checkDataImport = new CheckDataImport(true);
        Hashtable<String, Integer> contextMap = checkDataImport.getContextMap();
        if (contextMap == null) {
            contextMap = new Hashtable<String, Integer>();
            checkDataImport.setContextParameter(contextMap);
        }
        contextMap.put("DATATASKMODE", importMode == 0 ? 8 : 16);
        String la = ctx.getLocale().getLanguage();
        SQLBuilder sql = new SQLBuilder();
        sql.append("select tmp.FYear fyear,tmp.FPeriod period,tmp.FCompanyNumber companyNumber,company.fname_").append(la).append(" companyName,tmp.FTargetCompanyNumber targetCompanyNumber,tmp.FItemType itemType, \n");
        sql.append("tarCompany.fname_").append(la).append(" tarCompanyName,tmp.FItemNumber itemNumber,tmp.FCurrencyNumber currencyNumber,tmp.FDataElementNumber dataElementNumber,tmp.FDebit debit,tmp.FCredit credit, \n");
        sql.append("template.fnumber templateNumber,template.fname templateName,tmp.FRemarks remarks,tmp.freportid reportid,tmp.ftemplateId,tmp.fsheetid,tmp.fsheetName sheetName,tmp.FRowNum frowNum, \n");
        sql.append("tmp.FRptCompanyNumber rptCompanyNumber,tmp.FRptCompanyName rptCompanyName \n");
        sql.append("from ").append(tmpTable).append(" tmp \n ");
        sql.append("inner join T_ORG_Company company on company.fnumber=tmp.FCompanyNumber \n ");
        sql.append("inner join T_ORG_Company tarCompany on tarCompany.fnumber=tmp.FTargetCompanyNumber \n ");
        sql.append("inner join T_RPT_Template template on template.fid=tmp.ftemplateId \n ");
        sql.append("order by tmp.FItemType,tmp.FYear,tmp.FPeriod,tmp.FRptCompanyNumber,tmp.FRowNum");
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL());
        if (rowSet != null && rowSet.size() > 0) {
            Hashtable<String, DataToken> hsData = new Hashtable<String, DataToken>();
            CheckageBillDataInfo checkageBillData = null;
            while (rowSet.next()) {
                if (noPermissionCompanyNumberSet.contains(rowSet.getString("companyNumber"))) continue;
                hsData.clear();
                hsData.put("FYear", new DataToken("FYear", (Object)rowSet.getString("fyear")));
                hsData.put("FPeriod", new DataToken("FPeriod", (Object)rowSet.getString("period")));
                hsData.put("FCompanyNumber", new DataToken("FCompanyNumber", (Object)rowSet.getString("companyNumber")));
                hsData.put("FTargetCompanyNumber", new DataToken("FTargetCompanyNumber", (Object)rowSet.getString("targetCompanyNumber")));
                hsData.put("FItemType", new DataToken("FItemType", (Object)rowSet.getString("itemType")));
                hsData.put("FItemNumber", new DataToken("FItemNumber", (Object)rowSet.getString("itemNumber")));
                hsData.put("FCurrencyNumber", new DataToken("FCurrencyNumber", (Object)rowSet.getString("currencyNumber")));
                hsData.put("FDataElementNumber", new DataToken("FDataElementNumber", (Object)rowSet.getString("dataElementNumber")));
                hsData.put("FDebit", new DataToken("FDebit", (Object)rowSet.getString("debit")));
                hsData.put("FCredit", new DataToken("FCredit", (Object)rowSet.getString("credit")));
                hsData.put("FRemarks", new DataToken("FRemarks", (Object)rowSet.getString("remarks")));
                hsData.put("templateName", new DataToken("templateName", (Object)rowSet.getString("templateName")));
                hsData.put("templateNumber", new DataToken("templateNumber", (Object)rowSet.getString("templateNumber")));
                hsData.put("sheetName", new DataToken("sheetName", (Object)rowSet.getString("sheetName")));
                hsData.put("rowNum", new DataToken("rowNum", (Object)rowSet.getInt("frowNum")));
                hsData.put("rptCompanyNumber", new DataToken("rptCompanyNumber", (Object)rowSet.getString("rptCompanyNumber")));
                hsData.put("rptCompanyName", new DataToken("rptCompanyName", (Object)rowSet.getString("rptCompanyName")));
                try {
                    CoreBaseInfo info = checkDataImport.transmit(hsData, ctx);
                    checkageBillData = (CheckageBillDataInfo)info;
                    checkageBillData.setImportReportId(rowSet.getString("reportid"));
                    checkageBillData.setImportSheetName(rowSet.getString("sheetName"));
                    checkageBillData.setDataSource(DataSourceEnum.rptImport);
                    checkageBillData.put("rowNum", rowSet.getInt("frowNum"));
                    checkDataImport.submit(info, ctx);
                }
                catch (TaskExternalException e) {
                    this.packErrorMsg(ctx, hsData, rowSet, msg, e.getMessage(), checkDataImport);
                }
            }
            checkDataImport.importOnFinished(ctx, null);
        }
    }

    private String fecthData(Hashtable hsData, String key) {
        DataToken dataToken = (DataToken)hsData.get(key);
        if (dataToken != null) {
            return dataToken.toString();
        }
        return null;
    }

    private void packErrorMsg(Context ctx, Hashtable hsData, IRowSet rowSet, StringBuffer msg, String errorFlag, CheckDataImport checkDataImport) throws Exception {
        if (errorFlag.startsWith("249_confirmCheckData_")) {
            msg.append(AccountCheckUtil.getResourceString(ctx, "importFromRpt_sameDataHeadConfirm", new Object[]{this.getNameNumber(rowSet, "rptCompanyName", "rptCompanyNumber"), this.getNameNumber(rowSet, "templateName", "templateNumber"), this.fecthData(hsData, "sheetName"), this.fecthData(hsData, "rowNum"), errorFlag.replaceFirst("249_confirmCheckData_", "")}));
            msg.append("\n");
            return;
        }
        if (errorFlag.startsWith("247_dataDup_")) {
            CheckDataImport.DupCheckageBillData dupCheckageBillData = checkDataImport.importRptKeyMap.get(errorFlag.replaceFirst("247_dataDup_", ""));
            msg.append(AccountCheckUtil.getResourceString(ctx, "importFromRpt_dataDup", new Object[]{this.getNameNumber(rowSet, "rptCompanyName", "rptCompanyNumber"), this.getNameNumber(rowSet, "templateName", "templateNumber"), this.fecthData(hsData, "sheetName"), this.fecthData(hsData, "rowNum"), dupCheckageBillData.getRptCompanyNumber() + "(" + dupCheckageBillData.getRptCompanyName() + ")", dupCheckageBillData.getTemplateNumber() + "(" + dupCheckageBillData.getTemplateName() + ")", dupCheckageBillData.getSheetName(), dupCheckageBillData.getRowNum()}));
            msg.append("\n");
            return;
        }
        if (errorFlag.startsWith("232_itemTypeIsNotExist_") || errorFlag.startsWith("234_itemNumberIsNotExist_") || errorFlag.startsWith("236_dataElementIsNotExist_") || errorFlag.startsWith("238_currencyNumberIsNotExist_")) {
            String notExistType = null;
            String number = null;
            if (errorFlag.startsWith("232_itemTypeIsNotExist_")) {
                notExistType = AccountCheckUtil.getResourceString(ctx, "CheckageBillSet_itemTypeNumber", null);
                number = errorFlag.replaceFirst("232_itemTypeIsNotExist_", "");
            } else if (errorFlag.startsWith("234_itemNumberIsNotExist_")) {
                notExistType = AccountCheckUtil.getResourceString(ctx, "CheckageBillSet_itemNumber", null);
                number = errorFlag.replaceFirst("234_itemNumberIsNotExist_", "");
            } else if (errorFlag.startsWith("236_dataElementIsNotExist_")) {
                notExistType = AccountCheckUtil.getResourceString(ctx, "CheckageBillSet_dataElementNumber", null);
                number = errorFlag.replaceFirst("236_dataElementIsNotExist_", "");
            } else if (errorFlag.startsWith("238_currencyNumberIsNotExist_")) {
                notExistType = AccountCheckUtil.getResourceString(ctx, "CheckageBillSet_CurrencyNumber", null);
                number = errorFlag.replaceFirst("238_currencyNumberIsNotExist_", "");
            }
            msg.append(AccountCheckUtil.getResourceString(ctx, "importFromRpt_notExist", new Object[]{this.getNameNumber(rowSet, "rptCompanyName", "rptCompanyNumber"), this.getNameNumber(rowSet, "templateName", "templateNumber"), this.fecthData(hsData, "sheetName"), this.fecthData(hsData, "rowNum"), notExistType, number}));
            msg.append("\n");
            return;
        }
        if ("221_periodError".equals(errorFlag)) {
            msg.append(AccountCheckUtil.getResourceString(ctx, "importFromRpt_periodError", new Object[]{this.getNameNumber(rowSet, "rptCompanyName", "rptCompanyNumber"), this.getNameNumber(rowSet, "templateName", "templateNumber"), this.fecthData(hsData, "sheetName"), this.fecthData(hsData, "rowNum")}));
            msg.append("\n");
            return;
        }
        if ("225_ownerComCheckPerm".equals(errorFlag)) {
            msg.append(AccountCheckUtil.getResourceString(ctx, "importFromRpt_companyNoPermission", new Object[]{this.getNameNumber(rowSet, "rptCompanyName", "rptCompanyNumber"), this.getNameNumber(rowSet, "templateName", "templateNumber"), this.fecthData(hsData, "sheetName"), this.fecthData(hsData, "rowNum"), this.getNameNumber(rowSet, "companyName", "companyNumber")}));
            msg.append("\n");
            return;
        }
        if ("230_tarComCheckPerm".equals(errorFlag)) {
            msg.append(AccountCheckUtil.getResourceString(ctx, "importFromRpt_companyNoPermission", new Object[]{this.getNameNumber(rowSet, "rptCompanyName", "rptCompanyNumber"), this.getNameNumber(rowSet, "templateName", "templateNumber"), this.fecthData(hsData, "sheetName"), this.fecthData(hsData, "rowNum"), this.getNameNumber(rowSet, "tarCompanyName", "targetCompanyNumber")}));
            msg.append("\n");
            return;
        }
        if ("223_ownerComIsNotCheckCom".equals(errorFlag)) {
            msg.append(AccountCheckUtil.getResourceString(ctx, "importFromRpt_notCheckOrgUnit", new Object[]{this.getNameNumber(rowSet, "rptCompanyName", "rptCompanyNumber"), this.getNameNumber(rowSet, "templateName", "templateNumber"), this.fecthData(hsData, "sheetName"), this.fecthData(hsData, "rowNum"), this.getNameNumber(rowSet, "companyName", "companyNumber")}));
            msg.append("\n");
            return;
        }
        if ("228_tarComIsNotCheckCom".equals(errorFlag)) {
            msg.append(AccountCheckUtil.getResourceString(ctx, "importFromRpt_notCheckOrgUnit", new Object[]{this.getNameNumber(rowSet, "rptCompanyName", "rptCompanyNumber"), this.getNameNumber(rowSet, "templateName", "templateNumber"), this.fecthData(hsData, "sheetName"), this.fecthData(hsData, "rowNum"), this.getNameNumber(rowSet, "tarCompanyName", "targetCompanyNumber")}));
            msg.append("\n");
            return;
        }
        if ("224_ownerComIsFreeze".equals(errorFlag)) {
            msg.append(AccountCheckUtil.getResourceString(ctx, "importFromRpt_orgUnitIsFree", new Object[]{this.getNameNumber(rowSet, "rptCompanyName", "rptCompanyNumber"), this.getNameNumber(rowSet, "templateName", "templateNumber"), this.fecthData(hsData, "sheetName"), this.fecthData(hsData, "rowNum"), this.getNameNumber(rowSet, "companyName", "companyNumber")}));
            msg.append("\n");
            return;
        }
        if ("229_tarComIsFreeze".equals(errorFlag)) {
            msg.append(AccountCheckUtil.getResourceString(ctx, "importFromRpt_orgUnitIsFree", new Object[]{this.getNameNumber(rowSet, "rptCompanyName", "rptCompanyNumber"), this.getNameNumber(rowSet, "templateName", "templateNumber"), this.fecthData(hsData, "sheetName"), this.fecthData(hsData, "rowNum"), this.getNameNumber(rowSet, "tarCompanyName", "targetCompanyNumber")}));
            msg.append("\n");
            return;
        }
        if ("248_checkDataExist".equals(errorFlag)) {
            msg.append(AccountCheckUtil.getResourceString(ctx, "importFromRpt_existData", new Object[]{this.getNameNumber(rowSet, "rptCompanyName", "rptCompanyNumber"), this.getNameNumber(rowSet, "templateName", "templateNumber"), this.fecthData(hsData, "sheetName"), this.fecthData(hsData, "rowNum")}));
            msg.append("\n");
            return;
        }
        if ("263_accountIsNotExist".equals(errorFlag)) {
            msg.append(AccountCheckUtil.getResourceString(ctx, "importFromRpt_accountNotExist", new Object[]{this.getNameNumber(rowSet, "rptCompanyName", "rptCompanyNumber"), this.getNameNumber(rowSet, "templateName", "templateNumber"), this.fecthData(hsData, "sheetName"), this.fecthData(hsData, "rowNum"), this.fecthData(hsData, "FYear"), this.fecthData(hsData, "FPeriod"), this.fecthData(hsData, "FItemNumber")}));
            msg.append("\n");
            return;
        }
        if (!("231_ItemTypeIsNull".equals(errorFlag) || "233_itemNumberIsNull".equals(errorFlag) || "235_dataElementIsNull".equals(errorFlag))) {
            if ("237_currencyNumberIsNull".equals(errorFlag)) {
                String nullType = null;
                if ("231_ItemTypeIsNull".equals(errorFlag)) {
                    nullType = AccountCheckUtil.getResourceString(ctx, "CheckageBillSet_itemTypeNumber", null);
                } else if ("233_itemNumberIsNull".equals(errorFlag)) {
                    nullType = AccountCheckUtil.getResourceString(ctx, "CheckageBillSet_itemNumber", null);
                } else if ("235_dataElementIsNull".equals(errorFlag)) {
                    nullType = AccountCheckUtil.getResourceString(ctx, "CheckageBillSet_dataElementNumber", null);
                } else if ("237_currencyNumberIsNull".equals(errorFlag)) {
                    nullType = AccountCheckUtil.getResourceString(ctx, "CheckageBillSet_CurrencyNumber", null);
                }
                msg.append(AccountCheckUtil.getResourceString(ctx, "importFromRpt_null", new Object[]{this.getNameNumber(rowSet, "rptCompanyName", "rptCompanyNumber"), this.getNameNumber(rowSet, "templateName", "templateNumber"), this.fecthData(hsData, "sheetName"), this.fecthData(hsData, "rowNum"), nullType}));
                msg.append("\n");
                return;
            }
            if (!"isNotUsedElim".equals(errorFlag) && !"260_existInCheckageAccount".equals(errorFlag)) {
                if ("261_existAccountMap".equals(errorFlag)) {
                    String infoType = null;
                    if ("isNotUsedElim".equals(errorFlag)) {
                        infoType = "importFromRpt_dataElementNotElim";
                    } else if ("260_existInCheckageAccount".equals(errorFlag)) {
                        infoType = "importFromRpt_itemError";
                    } else if ("261_existAccountMap".equals(errorFlag)) {
                        infoType = "importFromRpt_itemMappingError";
                    }
                    msg.append(AccountCheckUtil.getResourceString(ctx, infoType, new Object[]{this.getNameNumber(rowSet, "rptCompanyName", "rptCompanyNumber"), this.getNameNumber(rowSet, "templateName", "templateNumber"), this.fecthData(hsData, "sheetName"), this.fecthData(hsData, "rowNum")}));
                    msg.append("\n");
                    return;
                }
                msg.append(errorFlag);
                msg.append("\n");
            }
        }
    }

    private void importFromCheckAgeBillRpt(Context ctx, String tmpTable, String templateId, List<String> rptIds, List<String> sheetNames, StringBuffer msg) throws Exception {
        if (sheetNames == null) {
            return;
        }
        HashSet<String> rptIdSet = new HashSet<String>(rptIds);
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("orgUnit"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        viewInfo.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("id", rptIdSet, CompareType.INCLUDE));
        CslReportCollection cslReportCollection = CslReportFactory.getLocalInstance((Context)ctx).getCslReportCollection(viewInfo);
        if (cslReportCollection != null && !cslReportCollection.isEmpty()) {
            HashMap<String, TemplateInfo> templateInfoMap = new HashMap<String, TemplateInfo>();
            HashSet<String> filedKeySet = new HashSet<String>();
            filedKeySet.addAll(NewRptUtil.checkageBillSetInfoMap.keySet());
            filedKeySet.add("remarks");
            ArrayList paramsList = new ArrayList();
            for (int i = 0; i < cslReportCollection.size(); ++i) {
                CslReportInfo cslReportInfo = cslReportCollection.get(i);
                Book book = cslReportInfo.getBook();
                ReportVariables variable = ReportVariables.loadFromBook((Book)book);
                for (int x = 0; x < book.getSheetCount(); ++x) {
                    String sheetName;
                    Sheet sheet = book.getSheet(x);
                    int sheet_type = variable.getIntValue("SheetClass", sheet.getSheetName(), 1);
                    if (sheet_type != 51 || !sheetNames.contains(sheetName = sheet.getSheetName())) continue;
                    paramsList.clear();
                    Object[] fieldsInfo = NewRptUtil.getCheckageBillSetFieldsInfo(sheet);
                    Point basePoint = (Point)fieldsInfo[1];
                    if (basePoint == null) continue;
                    int fieldsCount = (Integer)fieldsInfo[0];
                    int maxRow = sheet.getRows().getMaxIntMark() + 1;
                    boolean isEnd = false;
                    boolean rowHasData = false;
                    HashMap<String, Object> rowDataMap = new HashMap<String, Object>();
                    int cloCount = sheet.getCols().getMaxIntMark() + 1;
                    for (int z = basePoint.y + 1; z < maxRow && !isEnd; ++z) {
                        rowHasData = false;
                        rowDataMap.clear();
                        for (int j = basePoint.x; j < cloCount; ++j) {
                            String fieldKey;
                            Cell cell = sheet.getCell(z, j, true);
                            Cell HeadCell = sheet.getCell(basePoint.y, j, true);
                            UserObject isEndObj = cell.getUserObject("isEnd");
                            if (isEndObj != null && Boolean.TRUE.equals(isEndObj.getValue())) {
                                isEnd = true;
                                break;
                            }
                            String string = fieldKey = HeadCell.getUserObject("fieldKey") == null ? null : (String)HeadCell.getUserObject("fieldKey").getValue();
                            if (StringUtils.isEmpty(fieldKey)) continue;
                            Variant value = cell.getValue();
                            if (filedKeySet.contains(fieldKey)) {
                                rowDataMap.put(fieldKey, value != null && !value.isNull() ? value.getValue() : null);
                            }
                            if (value == null || value.isNull()) continue;
                            rowHasData = true;
                        }
                        if (!rowHasData) continue;
                        rowDataMap.put("freportid", cslReportInfo.getId().toString());
                        rowDataMap.put("ftemplateId", templateId);
                        rowDataMap.put("fsheetid", sheet.getID().toString());
                        rowDataMap.put("fsheetName", sheet.getSheetName());
                        rowDataMap.put("rowNum", z + 1);
                        rowDataMap.put("FRptCompanyNumber", cslReportInfo.getOrgUnit().getNumber());
                        rowDataMap.put("FRptCompanyName", cslReportInfo.getOrgUnit().getName());
                        this.insertIntoTempList(rowDataMap, paramsList);
                    }
                    if (paramsList.size() > 0) {
                        StringBuilder insertSqlSb = new StringBuilder();
                        insertSqlSb.append("insert into ").append(tmpTable).append(" (FYear,FPeriod,FCompanyNumber,FTargetCompanyNumber,FItemType,");
                        insertSqlSb.append("FItemNumber,FDataElementNumber,FCurrencyNumber,FDebit,FCredit,FRemarks, ");
                        insertSqlSb.append("freportid,ftemplateId,fsheetid,fsheetName,FRowNum,FRptCompanyNumber,FRptCompanyName) ");
                        insertSqlSb.append("values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                        DbUtil.executeBatch(ctx, insertSqlSb.toString(), paramsList);
                        continue;
                    }
                    TemplateInfo templateInfo = (TemplateInfo)templateInfoMap.get(templateId);
                    if (templateInfo == null) {
                        templateInfo = TemplateFactory.getLocalInstance((Context)ctx).getTemplateInfo("select id,number,name where id='" + templateId + "'");
                        templateInfoMap.put(templateId, templateInfo);
                    }
                    msg.append(AccountCheckUtil.getResourceString(ctx, "importFromRpt_noRptData", new Object[]{cslReportInfo.getOrgUnit().getNumber() + "(" + cslReportInfo.getOrgUnit().getName() + ")", templateInfo.getNumber(), templateInfo.getName(), sheet.getSheetName()}));
                    msg.append("\n");
                }
            }
        }
    }

    private void insertIntoTempList(Map<String, Object> rowDataMap, List paramsList) {
        Object[] params = new Object[]{this.objToString(rowDataMap.get("year")), this.objToString(rowDataMap.get("period")), this.objToString(rowDataMap.get("companyNumber")), this.objToString(rowDataMap.get("tarCompanyNumber")), this.objToString(rowDataMap.get("itemTypeNumber")), this.objToString(rowDataMap.get("itemNumber")), this.objToString(rowDataMap.get("dataElementNumber")), this.objToString(rowDataMap.get("currencyNumber")), this.objToString(rowDataMap.get("debit")), this.objToString(rowDataMap.get("credit")), this.objToString(rowDataMap.get("remarks")), this.objToString(rowDataMap.get("freportid")), this.objToString(rowDataMap.get("ftemplateId")), this.objToString(rowDataMap.get("fsheetid")), this.objToString(rowDataMap.get("fsheetName")), rowDataMap.get("rowNum"), this.objToString(rowDataMap.get("FRptCompanyNumber")), this.objToString(rowDataMap.get("FRptCompanyName"))};
        paramsList.add(params);
    }

    private String objToString(Object obj) {
        return obj == null ? null : obj.toString();
    }

    public String importItemDatasFromInterExchDyRpt(Context ctx, Map<String, List<String>> templates, List<String> orgUnitIds, int year, int period, int periodType, String currencyId, int[] rptAuditStatus, int[] rptCommitStatus, int importMode) throws Exception {
        if (templates != null && !templates.isEmpty()) {
            String tmpTable = null;
            String noPassCheckTmpTable = null;
            String insertIdsTable = null;
            try {
                HashMap<String, String> templateId_srcTemplateIds;
                OneToManyMap tmplateId_rptIds;
                StringBuffer msg = new StringBuffer();
                this.checkBeforeHandle(ctx, orgUnitIds, periodType, year, period, msg);
                if (!orgUnitIds.isEmpty() && !(tmplateId_rptIds = this.getReportIds(ctx, templates, orgUnitIds, year, period, periodType, currencyId, rptAuditStatus, rptCommitStatus, templateId_srcTemplateIds = new HashMap<String, String>(), msg, null)).isEmpty()) {
                    tmpTable = this.getImportItemDataTmpTable(ctx);
                    if (!StringUtils.isEmpty((String)tmpTable)) {
                        Map<String, ImportTemplateInfo> importTemplateMap = this.getImportTemplateInfo(ctx, tmplateId_rptIds.keySet(), templates, templateId_srcTemplateIds);
                        for (Object templateId : tmplateId_rptIds.keySet()) {
                            ImportTemplateInfo importTemplateInfo = importTemplateMap.get(templateId);
                            if (importTemplateInfo.isDyTemplate) {
                                this.importFromDynaRpt(ctx, (String)templateId, tmpTable, (List)tmplateId_rptIds.get(templateId), importTemplateInfo.sheetNames);
                                continue;
                            }
                            this.importFromInterExchRpt(ctx, (String)templateId, importTemplateInfo, tmpTable, (List)tmplateId_rptIds.get(templateId));
                        }
                    }
                    noPassCheckTmpTable = this.checkAfterHandle(ctx, tmplateId_rptIds, tmpTable, templates, currencyId, periodType, year, period, importMode, templateId_srcTemplateIds, msg);
                    insertIdsTable = this.insertBillData(ctx, tmpTable, noPassCheckTmpTable, year, period, periodType, currencyId, importMode);
                    this.writeOrgPackInfo(ctx, tmpTable, insertIdsTable, year, period, currencyId);
                    this.refreshCompanyCheckageBill(ctx, tmpTable, insertIdsTable, year, period, currencyId);
                }
                String string = msg.toString();
                return string;
            }
            catch (Exception e) {
                logger.error((Object)"importItemCheckDatasFromInterExchRpt error.", (Throwable)e);
                throw e;
            }
            finally {
                if (!DebugLogger.isDebug) {
                    TempTablePool tempTablePool = TempTablePool.getInstance((Context)ctx);
                    if (!StringUtils.isEmpty(tmpTable)) {
                        tempTablePool.releaseTable(tmpTable);
                    }
                    if (!StringUtils.isEmpty(noPassCheckTmpTable)) {
                        tempTablePool.releaseTable(noPassCheckTmpTable);
                    }
                    if (!StringUtils.isEmpty(insertIdsTable)) {
                        tempTablePool.releaseTable(insertIdsTable);
                    }
                }
            }
        }
        return null;
    }

    public void refreshCompanyCheckageBill(Context ctx, String tmpTable, String insertIdsTable, int year, int period, String currencyId) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append(" select distinct fcompanyid ");
        sql.append(" from ").append(tmpTable);
        sql.append(" where fid in(select fid from ").append(insertIdsTable).append(") ");
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL());
        AccountCheckWorkeFilterInfo filterInfo = null;
        HashMap<String, AccountCheckWorkeFilterInfo> params = new HashMap<String, AccountCheckWorkeFilterInfo>();
        while (rowSet.next()) {
            if (filterInfo == null) {
                filterInfo = new AccountCheckWorkeFilterInfo();
                filterInfo.setYear(year);
                filterInfo.setPeriod(period);
                filterInfo.setCurrencyId(currencyId);
                filterInfo.setItemTypeEnum(ItemTypeEnum.rptItem);
                IRowSet curRowSet = DbUtil.executeQuery(ctx, "select fnumber from t_bd_currency where fid=? ", new Object[]{currencyId});
                if (curRowSet.next()) {
                    filterInfo.setCurrencyNumber(curRowSet.getString("fnumber"));
                }
            }
            filterInfo.setAccountCheckCompanyId(rowSet.getString("fcompanyid"));
            params.clear();
            params.put("filterInfo", filterInfo);
            params.put("autoCheckParams", null);
            AccountCheckFacadeFactory.getLocalInstance(ctx).fetchDataBySchm(params);
        }
    }

    public void writeOrgPackInfo(Context ctx, String tmpTable, String insertIdsTable, int year, int period, String currencyId) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        String bosType = new CheckageOrgPackInfo().getBOSType().toString();
        Date curdate = new Date();
        String time = CslRptUtil.formatDatetimeForSql((Date)curdate);
        sql.reset();
        sql.append(" update T_Csl_CheckageOrgPack set FLastGetDataTime=").append(time);
        sql.append(" where fid in(");
        sql.append(" select pack.fid ");
        sql.append(" from (select distinct fcompanyid ");
        sql.append(" \t\tfrom ").append(tmpTable);
        sql.append("\t\t where fid in(select fid from ").append(insertIdsTable).append(")) tmp ");
        sql.append("inner join T_Csl_CheckageOrgPack pack on pack.fcompanyid=tmp.fcompanyid and pack.fitemtype=?", 1);
        sql.append(" and pack.fyear=? ", year).append(" and pack.fperiod=?", period).append(" and pack.fcurrencyid=?", currencyId);
        sql.append(")");
        DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
        sql.reset();
        sql.append(" insert into T_Csl_CheckageOrgPack(fid,fyear,fperiod,fcurrencyId,fcompanyId,fitemType,FLastGetDataTime)");
        sql.append("select newbosid('").append(bosType).append("'),").append(year).append(" year,").append(period).append(" period,'").append(currencyId).append("' currencyId,");
        sql.append(" tmp.fcompanyid,").append(1).append(",").append(time);
        sql.append(" from (select distinct fcompanyid ");
        sql.append(" \t\tfrom ").append(tmpTable);
        sql.append("\t\t where fid in(select fid from ").append(insertIdsTable).append(")) tmp ");
        sql.append("left join T_Csl_CheckageOrgPack pack on pack.fcompanyid=tmp.fcompanyid and pack.fitemtype=?", 1);
        sql.append(" and pack.fyear=? ", year).append(" and pack.fperiod=?", period).append(" and pack.fcurrencyid=?", currencyId);
        sql.append(" where pack.fid is null ");
        DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
    }

    public Map<String, List<String>>[] getTemplateByGroup(Context ctx, Map<String, List<String>> templates) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append(" select distinct tmp.fid,tmp.FtemplateType,sheet.freportclass ");
        sql.append(" from t_rpt_template tmp ");
        sql.append(" inner join t_rpt_rptsheetpara sheet on sheet.freportid=tmp.fid ");
        sql.append(" where tmp.fid in ", templates.keySet());
        sql.append(" and (tmp.FtemplateType in(10,11,12,13) or sheet.freportclass in(10,20,51))");
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        HashMap<String, List<String>> interExchDyTemplates = new HashMap<String, List<String>>();
        HashMap<String, List<String>> checkDataRptTemplates = new HashMap<String, List<String>>();
        while (rowSet.next()) {
            String templateId = rowSet.getString("fid");
            int templateType = rowSet.getInt("FtemplateType");
            int freportclass = rowSet.getInt("freportclass");
            if (!(freportclass != 10 && freportclass != 20 && templateType != 10 && templateType != 11 && templateType != 12 && templateType != 13 || interExchDyTemplates.containsKey(templateId))) {
                interExchDyTemplates.put(templateId, templates.get(templateId));
            }
            if (freportclass != 51 || checkDataRptTemplates.containsKey(templateId)) continue;
            checkDataRptTemplates.put(templateId, templates.get(templateId));
        }
        return new Map[]{interExchDyTemplates, checkDataRptTemplates};
    }

    public String insertBillData(Context ctx, String tmpTable, String noPassCheckTmpTable, int year, int period, int periodType, String currencyId, int importMode) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        if (importMode == 1) {
            sql.append("delete from T_CSL_CheckageBillData where fid in(");
            sql.append(" select billData.fid from T_CSL_CheckageBillData billData ");
            sql.append(" inner join t_csl_rptitem item on item.fnumber=billData.FItemNumber ");
            sql.append(" inner join ").append(tmpTable).append(" tmpData on tmpData.fcompanyId=billData.fcompanyId ");
            sql.append("  and tmpData.ftargetCompanyId=billData.ftargetCompanyId and tmpData.fitemid=item.fid and tmpData.FDataElement=billData.FDataElement ");
            sql.append(" where billData.FItemType=?", 1);
            sql.append(" and billData.FCurrencyId=?", currencyId);
            sql.append(" and billData.fyear=?", year);
            sql.append(" and billData.fperiod=?", period);
            sql.append(" and tmpData.fid not in(select fid from ").append(noPassCheckTmpTable).append(") ");
            sql.append(")");
            DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
        }
        String insertIdsTable = TempTablePool.getInstance((Context)ctx).createTempTable(" create table t_csl_insertIds(fid varchar(44))");
        sql.reset();
        sql.append(" insert into ").append(insertIdsTable).append(" (fid) ");
        sql.append(" select tmpData.fid ");
        sql.append(" from (select a.* from ").append(tmpTable).append(" a ");
        sql.append("         left join ").append(noPassCheckTmpTable).append(" b on a.fid=b.fid ");
        sql.append("         where b.fid is null) tmpData ");
        sql.append(" inner join t_csl_rptitem item on item.fid=tmpData.fitemId ");
        sql.append(" inner join T_Csl_CheckageAccount checkItem on checkItem.FItemNumber=item.fnumber and checkItem.fdataElement=tmpData.fdataElement ");
        if (importMode == 0) {
            sql.append(" left join (select * from T_CSL_CheckageBillData  ");
            sql.append(" \t\t\t\twhere FItemType=?", 1);
            sql.append(" \t\t\t\tand FCurrencyId=?", currencyId);
            sql.append(" \t\t\t\tand fyear=?", year);
            sql.append(" \t\t\t\tand fperiod=?", period);
            sql.append("           ) billData on tmpData.fcompanyId=billData.fcompanyId");
            sql.append("    and tmpData.ftargetCompanyId=billData.ftargetCompanyId and item.fnumber=billData.fitemnumber and tmpData.FDataElement=billData.FDataElement ");
        }
        sql.append(" where checkItem.fitemType=?", 1);
        sql.append(" and checkItem.FIsFree=0 ");
        if (importMode == 0) {
            sql.append(" and billData.fid is null ");
        }
        DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
        sql.reset();
        String name = "fname_" + ctx.getLocale().getLanguage();
        String createId = ctx.getCaller().toString();
        Date curdate = new Date();
        String time = CslRptUtil.formatDatetimeForSql((Date)curdate);
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String bosType = new CheckageBillDataInfo().getBOSType().toString();
        sql.append(" Insert into T_Csl_CheckageBillData (FID,FYear,FPeriod,FCurrencyId,FCompanyId,FTargetCompanyId,FItemType,FDataElement,FItemNumber,FItemName,FDataSource,fimportreportid,");
        sql.append("FCreatorId,FCreateTime,FLastUpdateUserId,FLastUpdateTime,FControlUnitId,FCreateCompanyId,fimportSheetName,FDebit,FCredit,FConfirmDebit,FConfirmCredit,FAuditDebit,FAuditCredit)");
        sql.append(" select newbosid('").append(bosType).append("'),").append(year).append(" FYear,").append(period).append(" FPeriod,'").append(currencyId).append("' FCurrencyId,tmpData.fcompanyid,");
        sql.append("tmpData.FTargetCompanyId,").append(1).append(" FItemType,tmpData.FDataElement,item.fnumber FItemNumber,item.").append(name).append(" FItemName,");
        sql.append(3).append(" FDataSource,tmpData.freportid fimportreportid,'").append(createId).append("' FCreatorId,").append(time).append(" FCreateTime,'");
        sql.append(createId).append("' FLastUpdateUserId,").append(time).append(" FLastUpdateTime,'").append(cuId).append("' FControlUnitId,tmpData.fcompanyid FCreateCompanyId,tmpData.fsheetName,");
        sql.append("tmpData.fdebit FDebit,tmpData.fcredit FCredit,tmpData.fdebit FConfirmDebit,tmpData.fcredit FConfirmCredit,tmpData.fdebit FAuditDebit,tmpData.fcredit FAuditCredit");
        sql.append(" from ").append(tmpTable).append(" tmpData ");
        sql.append(" inner join t_csl_rptitem item on item.fid=tmpData.fitemId ");
        sql.append(" where tmpData.fid in(select fid from ").append(insertIdsTable).append(") ");
        DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
        return insertIdsTable;
    }

    public void checkBeforeHandle(Context ctx, List<String> orgUnitIds, int periodType, int year, int period, StringBuffer msg) throws Exception {
        this.checkOrgUnits(ctx, orgUnitIds, periodType, year, period, true, msg);
    }

    public String checkAfterHandle(Context ctx, OneToManyMap tmplateId_rptIds, String tmpTable, Map<String, List<String>> templates, String currencyId, int periodType, int year, int period, int importMode, Map<String, String> templateId_srcTemplateIds, StringBuffer msg) throws Exception {
        this.checkRptSheetHaveDatas(ctx, tmplateId_rptIds, tmpTable, templates, templateId_srcTemplateIds, msg);
        String noPassCheckTmpTable = TempTablePool.getInstance((Context)ctx).createTempTable(" create table t_csl_noPassCompany(fid varchar(44),fbillNumber nvarchar(120),ftype int)");
        this.checkTagertCompany(ctx, tmpTable, periodType, year, period, noPassCheckTmpTable, msg);
        this.checkCheckItemSetIsExists(ctx, tmpTable, noPassCheckTmpTable, msg);
        this.checkCheckItemMapIsExists(ctx, tmpTable, noPassCheckTmpTable, msg);
        this.checkCheckDataAuditedIsExists(ctx, tmpTable, currencyId, periodType, year, period, noPassCheckTmpTable, importMode, msg);
        this.checkCheckDataAuditedMapIsExists(ctx, tmpTable, currencyId, periodType, year, period, noPassCheckTmpTable, msg);
        this.checkItemDataRepeat(ctx, tmpTable, noPassCheckTmpTable, msg);
        this.getCheckErrorMsg(ctx, tmpTable, noPassCheckTmpTable, msg);
        return noPassCheckTmpTable;
    }

    public void checkRptSheetHaveDatas(Context ctx, OneToManyMap tmplateId_rptIds, String tmpTable, Map<String, List<String>> templates, Map<String, String> templateId_srcTemplateIds, StringBuffer msg) throws Exception {
        if (tmplateId_rptIds == null || tmplateId_rptIds.isEmpty()) {
            return;
        }
        SQLBuilder sql = new SQLBuilder();
        String errorMsg = AccountCheckUtil.getResourceString(ctx, "importFromRpt_noData", null);
        for (Object templateId : tmplateId_rptIds.keySet()) {
            List rptIds = (List)tmplateId_rptIds.get(templateId);
            List<String> sheetNames = templates.get(templateId_srcTemplateIds.get(templateId));
            sql.reset();
            sql.append("select distinct sheet.fsheetName,tmp.fname templateName,unit.fnumber unitNumber,unit.fname_").append(ctx.getLocale().getLanguage()).append(" unitName,tmp.fnumber tmpNumber ");
            sql.append(" from t_csl_cslreport rpt ");
            sql.append(" inner join t_org_baseunit unit on unit.fid=rpt.forgUnitid ");
            sql.append(" inner join t_rpt_template tmp on tmp.fid=rpt.ftemplateid ");
            sql.append(" inner join t_rpt_rptsheetpara sheet on sheet.freportid=rpt.fid ");
            sql.append(" left join ").append(tmpTable).append(" tmpTab  on tmpTab.freportid=rpt.fid and tmpTab.fsheetId=sheet.fsheetId ");
            sql.append(" where rpt.fid in ", rptIds);
            if (sheetNames != null && !sheetNames.isEmpty()) {
                sql.append("  and  sheet.fsheetName in ", sheetNames);
            }
            sql.append(" and tmpTab.fid is null ");
            sql.append(" order by unit.fnumber,sheet.fsheetName ");
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            while (rowSet != null && rowSet.next()) {
                msg.append(MessageFormat.format(errorMsg, this.getNameNumber(rowSet, "unitName", "unitNumber"), this.getNameNumber(rowSet, "templateName", "tmpNumber"), rowSet.getString("fsheetName")));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCheckItemMapIsExists(Context ctx, String tmpTable, String noPassCheckTmpTable, StringBuffer msg) throws Exception {
        String itemMapTmpName = null;
        TempTablePool tmpTablePool = TempTablePool.getInstance((Context)ctx);
        try {
            SQLBuilder sql = new SQLBuilder();
            sql.append(" create table t_csl_itemMap(fid varchar(44),fitemMapId varchar(44))");
            itemMapTmpName = tmpTablePool.createTempTable(sql.toString());
            sql.reset();
            sql.append(" insert into ").append(itemMapTmpName).append("(fid,fitemMapId)");
            sql.append("select  dataTab.fid fid, itemMap.fid ");
            sql.append(" from (select a.* from ").append(tmpTable).append(" a ");
            sql.append("         left join ").append(noPassCheckTmpTable).append(" b on a.fid=b.fid ");
            sql.append("         where b.fid is null) dataTab ");
            sql.append(" inner join t_csl_rptitem item on item.fid=dataTab.fitemId ");
            sql.append("left join( ");
            sql.append("      select distinct accountMap.fid,account.FItemNumber,account.FDataElement from T_Csl_AccountAndMapAccount accounts ");
            sql.append("      inner join T_Csl_AccountMap accountMap on accounts.FAccountMapId=accountMap.fid ");
            sql.append("      inner join T_Csl_CheckageAccount account on accounts.FCheckAccountId=account.fid ");
            sql.append("      where accountMap.FIsFree=0 and accountMap.FItemType=1 ) itemMap ");
            sql.append("   on itemMap.fitemNumber=item.fnumber and itemMap.fdataelement=dataTab.fdataelement ");
            DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
            sql.reset();
            sql.append(" insert into ").append(noPassCheckTmpTable).append("(fid,ftype) \n");
            sql.append(" select fid,").append(2).append(" ftype ");
            sql.append(" from ").append(itemMapTmpName);
            sql.append(" where fitemMapId is null ");
            DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
            sql.reset();
            sql.append(" insert into ").append(noPassCheckTmpTable).append("(fid,ftype) \n");
            sql.append(" select itemMap.fid,").append(7).append(" ftype ");
            sql.append(" from ").append(itemMapTmpName).append(" itemMap \n");
            sql.append(" inner join ").append(tmpTable).append(" itemdata on itemdata.fid=itemMap.fid \n");
            sql.append(" left join (select a.fid,a.faccountmapid,b.fcompanyid from t_csl_accountmapdispense a  inner join t_csl_checkageCompany b on a.fcheckageCompanyId=b.fid ) ownDisp on ");
            sql.append("   \t\townDisp.faccountmapid=itemMap.fitemMapId and ownDisp.fcompanyid=itemdata.fcompanyId \n");
            sql.append(" left join  (select a.fid,a.faccountmapid,b.fcompanyid from t_csl_accountmapdispense a  inner join t_csl_checkageCompany b on a.fcheckageCompanyId=b.fid ) tarDisp on ");
            sql.append("   \t\ttarDisp.faccountmapid=itemMap.fitemMapId and tarDisp.fcompanyid=itemdata.ftargetcompanyId \n");
            sql.append(" where ownDisp.fid is null or tarDisp.fid is null \n");
            DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
        }
        catch (Throwable throwable) {
            if (!DebugLogger.isDebug && !StringUtils.isEmpty(itemMapTmpName)) {
                tmpTablePool.releaseTable(itemMapTmpName);
            }
            throw throwable;
        }
        if (!DebugLogger.isDebug && !StringUtils.isEmpty((String)itemMapTmpName)) {
            tmpTablePool.releaseTable(itemMapTmpName);
        }
    }

    public void checkItemDataRepeat(Context ctx, String tmpTable, String noPassCheckTmpTable, StringBuffer msg) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append(" insert into ").append(noPassCheckTmpTable).append("(fid,ftype)");
        sql.append("select distinct dataTab.fid fid,").append(6).append(" ftype ");
        sql.append(" from (select a.fcompanyId,a.ftargetCompanyId,a.FItemID,a.FDataElement,count(a.fid) cnt from ").append(tmpTable).append(" a ");
        sql.append("         left join ").append(noPassCheckTmpTable).append(" b on a.fid=b.fid ");
        sql.append("         where b.fid is null group by a.fcompanyId,a.ftargetCompanyId,a.FItemID,a.FDataElement having count(a.fid)>1) repeat ");
        sql.append(" inner join (select a.* from ").append(tmpTable).append(" a ");
        sql.append("         left join ").append(noPassCheckTmpTable).append(" b on a.fid=b.fid ");
        sql.append("         where b.fid is null ) dataTab on repeat.fcompanyId=dataTab.fcompanyid and repeat.ftargetCompanyId=dataTab.ftargetCompanyId ");
        sql.append("       and repeat.FItemID=dataTab.FItemID and repeat.FDataElement=dataTab.FDataElement ");
        DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
    }

    public void checkCheckDataAuditedIsExists(Context ctx, String tmpTable, String currencyId, int periodType, int year, int period, String noPassCheckTmpTable, int importMode, StringBuffer msg) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append(" insert into ").append(noPassCheckTmpTable).append("(fid,ftype)");
        sql.append("select  dataTab.fid fid,").append(importMode == 0 ? 3 : 4).append(" ftype ");
        sql.append(" from (select a.* from ").append(tmpTable).append(" a ");
        sql.append("         left join ").append(noPassCheckTmpTable).append(" b on a.fid=b.fid ");
        sql.append("         where b.fid is null) dataTab ");
        sql.append(" inner join t_csl_rptitem item on item.fid=dataTab.fitemId ");
        sql.append(" inner join T_Csl_CheckageBill bill on bill.FItemNumber=item.fnumber and bill.FDataElement=dataTab.fdataElement ");
        sql.append("   and dataTab.fcompanyid=bill.fcompanyid and dataTab.ftargetCompanyid=bill.ftargetcompanyid ");
        sql.append("  inner join t_csl_checkagebillcompany companyCheck on companyCheck.fid=bill.fbillcompanyid ");
        sql.append(" where bill.FItemType=?", 1);
        sql.append(" and bill.fyear=? ", year).append(" and bill.fperiod=? ", period);
        sql.append(" and bill.fcurrencyid=?", currencyId);
        if (importMode == 1) {
            sql.append("  and companyCheck.fconfirmstatus=?", 1);
        }
        DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
    }

    public void checkCheckDataAuditedMapIsExists(Context ctx, String tmpTable, String currencyId, int periodType, int year, int period, String noPassCheckTmpTable, StringBuffer msg) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append(" insert into ").append(noPassCheckTmpTable).append("(fid,fbillNumber,ftype)");
        sql.append("select  dataTab.fid fid,bhead.fnumber,").append(5).append(" ftype ");
        sql.append(" from (select a.* from ").append(tmpTable).append(" a ");
        sql.append("         left join ").append(noPassCheckTmpTable).append(" b on a.fid=b.fid ");
        sql.append("         where b.fid is null) dataTab ");
        sql.append(" inner join t_csl_rptitem item on item.fid=dataTab.fitemId ");
        sql.append(" inner join T_Csl_CheckageAccount account on account.fitemNumber=item.fnumber and account.fdataelement=dataTab.fdataelement ");
        sql.append(" inner join T_Csl_AccountAndMapAccount accountUnAudited on accountUnAudited.FCheckAccountId=account.fid ");
        sql.append(" inner join T_Csl_AccountAndMapAccount accountAudited on accountAudited.FAccountMapId=accountUnAudited.FAccountMapId ");
        sql.append(" inner join T_Csl_CheckageBillHead bhead on bhead.FAccountMapId=accountAudited.FAccountMapId ");
        sql.append(" inner join  T_Csl_CheckageBill bill on bhead.fid=bill.FBillHeadId and bill.FCheckAccountId=accountAudited.FCheckAccountId ");
        sql.append("     and (accountAudited.FIsMapAccount=accountUnAudited.FIsMapAccount and dataTab.fcompanyid=bill.fcompanyid and dataTab.ftargetcompanyid= bill.ftargetcompanyid  ");
        sql.append("         or accountAudited.FIsMapAccount<>accountUnAudited.FIsMapAccount and dataTab.fcompanyid=bill.ftargetcompanyid and dataTab.ftargetcompanyid=bill.fcompanyid ) ");
        sql.append(" inner join t_csl_checkagebillcompany companyCheck on companyCheck.fid=bill.fbillcompanyid ");
        sql.append(" where account.fitemType=1 ");
        sql.append(" and companyCheck.fconfirmstatus=?", 1);
        sql.append(" and bill.FItemType=?", 1);
        sql.append(" and bill.fyear=? ", year).append(" and bill.fperiod=? ", period);
        sql.append(" and bill.fcurrencyid=?", currencyId);
        DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
    }

    public void checkCheckItemSetIsExists(Context ctx, String tmpTable, String noPassCheckTmpTable, StringBuffer msg) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append(" insert into ").append(noPassCheckTmpTable).append("(fid,ftype)");
        sql.append("select  dataTab.fid fid,").append(1).append(" ftype ");
        sql.append(" from (select a.* from ").append(tmpTable).append(" a ");
        sql.append("         left join ").append(noPassCheckTmpTable).append(" b on a.fid=b.fid ");
        sql.append("         where b.fid is null) dataTab ");
        sql.append(" inner join t_csl_rptitem item on item.fid=dataTab.fitemId ");
        sql.append(" left join T_Csl_CheckageAccount checkItem on (checkItem.FItemNumber=item.fnumber and checkItem.FDataElement=dataTab.fdataElement ");
        sql.append(" and checkItem.FIsFree=0 and checkItem.FItemType=?", 1);
        sql.append(" ) where checkItem.fid is null ");
        DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
    }

    public void getCheckErrorMsg(Context ctx, String tmpTable, String noPassCheckTmpTable, StringBuffer msg) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        String name = "fname_" + ctx.getLocale().getLanguage();
        sql.append("select distinct ownUnit.").append(name).append(" companyName,targetUnit.").append(name).append(" targetCompanyName,");
        sql.append("item.").append(name).append(" itemName,dataelement.").append(name).append(" dataElementName,noPass.fbillNumber,noPass.ftype, ");
        sql.append("ownUnit.fnumber ownNumber,targetUnit.fnumber targetNumber,item.fnumber itemNumber,dataelement.fnumber dataElementNumber,");
        sql.append("dataTab.fsheetName,tmp.fname tmpName,tmp.fnumber tmpNumber,dataTab.fdataelement");
        sql.append(" from ").append(tmpTable).append(" dataTab ");
        sql.append(" inner join ").append(noPassCheckTmpTable).append(" noPass on noPass.fid=dataTab.fid");
        sql.append(" inner join t_csl_rptitem item on item.fid=dataTab.fitemId ");
        sql.append(" inner join t_rpt_template tmp on tmp.fid=dataTab.ftemplateid ");
        sql.append(" inner join t_csl_dataelement dataelement on dataelement.finterseq=dataTab.fdataelement ");
        sql.append(" inner join t_org_baseunit ownUnit on ownUnit.fid=dataTab.fcompanyid ");
        sql.append(" inner join t_org_baseunit targetUnit on targetUnit.fid=dataTab.ftargetcompanyid ");
        sql.append(" where noPass.ftype is not null ");
        sql.append(" order by noPass.ftype,ownUnit.fnumber,targetUnit.fnumber,item.fnumber,dataTab.fdataelement ");
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL());
        HashMap<Integer, String> errorMsgMap = new HashMap<Integer, String>();
        errorMsgMap.put(1, AccountCheckUtil.getResourceString(ctx, "importFromRpt_checkItemError", null));
        errorMsgMap.put(2, AccountCheckUtil.getResourceString(ctx, "importFromRpt_itemMapError", null));
        errorMsgMap.put(7, AccountCheckUtil.getResourceString(ctx, "557_importFromRpt_itemMapNotDisError", null));
        errorMsgMap.put(3, AccountCheckUtil.getResourceString(ctx, "importFromRpt_exists", null));
        errorMsgMap.put(4, AccountCheckUtil.getResourceString(ctx, "importFromRpt_checkDataAudited", null));
        errorMsgMap.put(5, AccountCheckUtil.getResourceString(ctx, "importFromRpt_checkDataConfirmed", null));
        OneToManyMap repeatItemDataMsg = new OneToManyMap();
        while (rowSet != null && rowSet.next()) {
            int errorType = rowSet.getInt("ftype");
            String errorMsg = (String)errorMsgMap.get(errorType);
            if (errorType == 1 || errorType == 1 || errorType == 2 || errorType == 7 || errorType == 4 || errorType == 3) {
                msg.append(MessageFormat.format(errorMsg, this.getNameNumber(rowSet, "companyName", "ownNumber"), this.getNameNumber(rowSet, "tmpName", "tmpNumber"), rowSet.getString("fsheetName"), this.getNameNumber(rowSet, "targetCompanyName", "targetNumber"), this.getNameNumber(rowSet, "itemName", "itemNumber"), this.getNameNumber(rowSet, "dataElementName", "dataElementNumber")));
                continue;
            }
            if (errorType == 5) {
                msg.append(MessageFormat.format(errorMsg, this.getNameNumber(rowSet, "companyName", "ownNumber"), this.getNameNumber(rowSet, "tmpName", "tmpNumber"), rowSet.getString("fsheetName"), this.getNameNumber(rowSet, "targetCompanyName", "targetNumber"), this.getNameNumber(rowSet, "itemName", "itemNumber"), this.getNameNumber(rowSet, "dataElementName", "dataElementNumber"), rowSet.getString("fbillNumber")));
                continue;
            }
            if (errorType != 6) continue;
            RepeatItemDataInfo info = this.getRepeatItemDataInfo(rowSet);
            repeatItemDataMsg.put((Object)info, (Object)info);
        }
        if (!repeatItemDataMsg.isEmpty()) {
            String itemDataRepeatMsg = AccountCheckUtil.getResourceString(ctx, "importFromRpt_itemDataRepeat", null);
            for (List repeats : repeatItemDataMsg.values()) {
                if (repeats.size() <= 1) continue;
                RepeatItemDataInfo ownInfo = (RepeatItemDataInfo)repeats.get(0);
                for (int i = 1; i < repeats.size(); ++i) {
                    RepeatItemDataInfo targetInfo = (RepeatItemDataInfo)repeats.get(i);
                    msg.append(MessageFormat.format(itemDataRepeatMsg, ownInfo.companyName, ownInfo.tmpName, ownInfo.sheetName, ownInfo.targetCompanyName, ownInfo.itemNumber, ownInfo.dataElementName, targetInfo.tmpNumber, targetInfo.tmpName, targetInfo.sheetName));
                }
            }
        }
    }

    public String getNameNumber(IRowSet rowSet, String nameField, String numberField) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(rowSet.getString(numberField)).append("(").append(rowSet.getString(nameField)).append(")");
        return sb.toString();
    }

    public void checkTagertCompany(Context ctx, String tmpTable, int periodType, int year, int period, String noPassCheckTmpTable, StringBuffer msg) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append("select distinct fid,ftargetCompanyId from ").append(tmpTable);
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL());
        if (rowSet != null && rowSet.size() > 0) {
            OneToManyMap companyIdMap = new OneToManyMap();
            while (rowSet.next()) {
                companyIdMap.put((Object)rowSet.getString("ftargetCompanyId"), (Object)new Object[]{rowSet.getString("fid")});
            }
            HashSet<String> companyIdSet = new HashSet<String>();
            companyIdSet.addAll(companyIdMap.keySet());
            this.checkOrgUnits(ctx, companyIdSet, periodType, year, period, false, msg);
            ArrayList params = new ArrayList();
            for (Object companyId : companyIdMap.keySet()) {
                if (companyIdSet.contains(companyId)) continue;
                params.addAll((List)companyIdMap.get(companyId));
            }
            if (!params.isEmpty()) {
                DbUtil.executeBatch(ctx, "insert into " + noPassCheckTmpTable + "(fid) values(?)", params);
            }
        }
    }

    public void checkOrgUnits(Context ctx, Collection<String> orgUnitIds, int periodType, int year, int period, boolean isOwnOrgUnit, StringBuffer msg) throws Exception {
        this.checkIsCheckOrgUnit(ctx, orgUnitIds, periodType, year, period, isOwnOrgUnit, msg);
        if (isOwnOrgUnit) {
            this.checkOrgUnitPermission(ctx, orgUnitIds, isOwnOrgUnit, msg);
        }
    }

    public void checkIsCheckOrgUnit(Context ctx, Collection<String> orgUnitIds, int periodType, int year, int period, boolean isOwnOrgUnit, StringBuffer msg) throws Exception {
        CheckageCompanyCollection coll = CheckageCompanyFactory.getLocalInstance(ctx).getCheckageCompanyCollection("select company.id,isfree,freeTime where company.id in(" + CslRptUtil.collection2String(orgUnitIds, (String)",", (boolean)true) + ")");
        HashMap<String, CheckageCompanyInfo> companys = new HashMap<String, CheckageCompanyInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            companys.put(coll.get(i).getCompany().getId().toString(), coll.get(i));
        }
        ArrayList<String> notSetCheckUnitIds = new ArrayList<String>();
        ArrayList<String> freeCheckUnitIds = new ArrayList<String>();
        int yearPeriod = this.getYearPeriod(year, period);
        for (String companyId : orgUnitIds) {
            CheckageCompanyInfo info = (CheckageCompanyInfo)companys.get(companyId);
            if (info == null) {
                notSetCheckUnitIds.add(companyId);
                continue;
            }
            if (!info.isIsfree() || info.getFreeTime() > yearPeriod) continue;
            freeCheckUnitIds.add(companyId);
        }
        if (!notSetCheckUnitIds.isEmpty() || !freeCheckUnitIds.isEmpty()) {
            String errorMsg;
            ArrayList<String> errorOrgUnitIds = new ArrayList<String>();
            errorOrgUnitIds.addAll(notSetCheckUnitIds);
            errorOrgUnitIds.addAll(freeCheckUnitIds);
            Map<String, OrgUnitInfo> orgUnits = this.getOrgUnitMap(ctx, errorOrgUnitIds);
            if (!notSetCheckUnitIds.isEmpty()) {
                errorMsg = isOwnOrgUnit ? AccountCheckUtil.getResourceString(ctx, "importFromRpt_ownNotCheckOrgUnit", null) : AccountCheckUtil.getResourceString(ctx, "importFromRpt_tragetNotCheckOrgUnit", null);
                this.setErrorMsg(notSetCheckUnitIds, orgUnits, errorMsg, 2, msg);
                orgUnitIds.removeAll(notSetCheckUnitIds);
            }
            if (!freeCheckUnitIds.isEmpty()) {
                errorMsg = isOwnOrgUnit ? AccountCheckUtil.getResourceString(ctx, "importFromRpt_ownOrgUnitIsFree", null) : AccountCheckUtil.getResourceString(ctx, "importFromRpt_tragetOrgUnitIsFree", null);
                this.setErrorMsg(freeCheckUnitIds, orgUnits, errorMsg, 1, msg);
                orgUnitIds.removeAll(freeCheckUnitIds);
            }
        }
    }

    public int getYearPeriod(int year, int period) throws Exception {
        StringBuffer yearPeriod = new StringBuffer();
        yearPeriod.append(year);
        if (period < 10) {
            yearPeriod.append("0");
        }
        yearPeriod.append(period);
        return Integer.valueOf(yearPeriod.toString());
    }

    public void checkOrgUnitPermission(Context ctx, Collection<String> orgUnitIds, boolean isCheckOwnOrg, StringBuffer msg) throws Exception {
        if (orgUnitIds != null && !orgUnitIds.isEmpty()) {
            IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
            IObjectPK[] orgPKs = new IObjectPK[orgUnitIds.size()];
            int i = 0;
            for (String orgUnitId : orgUnitIds) {
                orgPKs[i++] = new ObjectUuidPK(orgUnitId);
            }
            Set hasPermOrgIds = iPermission.checkBatchPermission(ctx.getCaller(), orgPKs, "csl_checkwork_view");
            Collection<String> noHasPermOrgIds = null;
            if (hasPermOrgIds == null || hasPermOrgIds.isEmpty()) {
                noHasPermOrgIds = orgUnitIds;
            } else if (hasPermOrgIds.size() < orgUnitIds.size()) {
                noHasPermOrgIds = new ArrayList<String>();
                for (String orgUnitId : orgUnitIds) {
                    if (hasPermOrgIds.contains(orgUnitId)) continue;
                    noHasPermOrgIds.add(orgUnitId);
                }
            }
            if (noHasPermOrgIds != null && !noHasPermOrgIds.isEmpty()) {
                Map<String, OrgUnitInfo> noHasPermOrgs = this.getOrgUnitMap(ctx, noHasPermOrgIds);
                String orgUnitMsg = isCheckOwnOrg ? AccountCheckUtil.getResourceString(ctx, "importFromRpt_OwnNoPermission", null) : AccountCheckUtil.getResourceString(ctx, "importFromRpt_targetNoPermission", null);
                this.setErrorMsg(noHasPermOrgIds, noHasPermOrgs, orgUnitMsg, 1, msg);
                orgUnitIds.removeAll(noHasPermOrgIds);
            }
        }
    }

    public void setErrorMsg(Collection<String> errorOrgUnitIds, Map<String, OrgUnitInfo> errorOrgMap, String errorMsg, int paramCount, StringBuffer msgBuffer) throws Exception {
        for (String orgUnitId : errorOrgUnitIds) {
            OrgUnitInfo orgUnit = errorOrgMap.get(orgUnitId);
            if (orgUnit == null) continue;
            Object[] params = new Object[paramCount];
            for (int i = 0; i < paramCount; ++i) {
                params[i] = orgUnit.getNumber() + "(" + orgUnit.getName() + ")";
            }
            msgBuffer.append(MessageFormat.format(errorMsg, params));
        }
    }

    public Map<String, OrgUnitInfo> getOrgUnitMap(Context ctx, Collection<String> orgUnitIds) throws Exception {
        OrgUnitCollection coll;
        HashMap<String, OrgUnitInfo> orgUnitNameMap = new HashMap<String, OrgUnitInfo>();
        if (orgUnitIds != null && !orgUnitIds.isEmpty() && (coll = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitCollection("select name,number,id where id in(" + CslRptUtil.collection2String(orgUnitIds, (String)",", (boolean)true) + ")")) != null && !coll.isEmpty()) {
            for (int i = 0; i < coll.size(); ++i) {
                orgUnitNameMap.put(coll.get(i).getId().toString(), coll.get(i));
            }
        }
        return orgUnitNameMap;
    }

    public String checkSheetNotDataImport(Context ctx, Collection rptIds, String tmpTable) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append("select ");
        sql.append("from t_rpt_rptsheetpara sheetPara ");
        sql.append(" left join ");
        return null;
    }

    public void importFromDynaRpt(Context ctx, String templateId, String tmpTable, List<String> rptIds, List<String> sheetNames) throws Exception {
        Integer[] integerArray = new Integer[]{1, 2, 3};
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int dynaItemType = integerArray[i];
            this.importFromDynaRpt(ctx, templateId, tmpTable, rptIds, sheetNames, dynaItemType);
        }
    }

    public void importFromInterExchRpt(Context ctx, String templateId, ImportTemplateInfo importTemplateInfo, String tmpTable, List<String> rptIds) throws Exception {
        this.importFromInterExchRpt(ctx, templateId, tmpTable, rptIds, importTemplateInfo.templetItemListTable, importTemplateInfo.sheetNames, true);
        this.importFromInterExchRpt(ctx, templateId, tmpTable, rptIds, importTemplateInfo.templetItemListTable, importTemplateInfo.sheetNames, false);
    }

    public void importFromInterExchRpt(Context ctx, String templateId, String tmpTable, List<String> rptIds, String templateItemListTable, List<String> sheetNames, boolean isInter) throws Exception {
        String bosType = new CheckageBillDataInfo().getBOSType().toString();
        String itemDataTable = "t_csl_interitemdata";
        if (!isInter) {
            itemDataTable = "t_csl_exchitemdata";
        }
        SQLBuilder sql = new SQLBuilder();
        sql.append("insert into ").append(tmpTable).append("(fid,fcompanyId,FItemID,FDataElement,freportid,ftargetCompanyId,fsheetid,fsheetName,ftemplateid,fdebit,fcredit)");
        sql.append(" select newbosid('").append(bosType).append("') ,itemdata.fcompanyid,item.fid,itemdata.fdataelement,itemdata.freport,");
        sql.append("itemdata.ftargetCompanyId,itemList.fsheetId,itemList.fsheetName,'").append(templateId).append("' ftemplateid");
        sql.append(",case when item.fdc=1 then isnull(itemdata.fmoney,0) else null end fdebit,case when item.fdc=0 then isnull(itemdata.fmoney,0) else null end fcredit");
        sql.append(" from ").append(itemDataTable).append(" itemData ");
        sql.append(" inner join t_csl_rptitem item on item.fnumber=itemData.fitemNumber ");
        sql.append(" inner join (");
        sql.append("  \t\t\tselect distinct fitemNumber,fdataelement,fsheetid,fsheetName from ").append(templateItemListTable).append("  ");
        sql.append("  \t\t\twhere ftemplateid=? ", templateId);
        if (sheetNames != null && !sheetNames.isEmpty()) {
            sql.append("  \t\tand fsheetName in ", sheetNames);
        }
        sql.append(" ) itemList on itemList.fitemNumber=itemdata.fitemNumber and itemList.fdataelement=itemdata.fdataelement ");
        sql.append(" where itemdata.freport in ", rptIds);
        sql.append(" and itemdata.fmoney<>0 and itemdata.fmoney is not null ");
        DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
    }

    public void importFromDynaRpt(Context ctx, String templateId, String tmpTable, List<String> rptIds, List<String> sheetNames, int dynaItemType) throws Exception {
        try {
            boolean isCompany;
            String asstActTypeTable = null;
            boolean bl = isCompany = dynaItemType == 1;
            if (isCompany) {
                asstActTypeTable = "t_org_company";
            } else if (dynaItemType == 2) {
                asstActTypeTable = "T_BD_Customer";
            } else if (dynaItemType == 3) {
                asstActTypeTable = "T_BD_Supplier";
            }
            if (StringUtils.isEmpty((String)asstActTypeTable)) {
                return;
            }
            String bosType = new CheckageBillDataInfo().getBOSType().toString();
            boolean isSheetNamesNull = sheetNames == null || sheetNames.isEmpty();
            SQLBuilder sql = new SQLBuilder();
            String insertStr = "insert into " + tmpTable + "(fid,fcompanyId,FItemID,FDataElement,freportid,ftargetCompanyId,fsheetid,fsheetName,ftemplateid,fdebit,fcredit)";
            if (isCompany) {
                sql.append(insertStr);
            }
            sql.append(" select newbosid('").append(bosType).append("') fid,itemdata.forgUnitId fcompanyId,item.fid FItemID,dataEntry.fdataelement,itemdata.freportid");
            if (isCompany) {
                sql.append(",asstType.fid ftargetCompanyId ");
            } else {
                sql.append(",dataEntry.fkeyNumber");
            }
            sql.append(",dataEntry.fsheetid,sheet.fsheetName,'").append(templateId).append("' ftemplateid ");
            sql.append(",case when item.fdc=1 then isnull(dataEntry.fvalue,0) else null end fdebit,case when item.fdc=0 then isnull(dataEntry.fvalue,0) else null end fcredit");
            sql.append(" from t_csl_dynaitemdata itemdata ");
            sql.append(" inner join t_csl_dynaitemdataentry dataEntry on itemdata.fid=dataEntry.Fitemdataid ");
            sql.append(" inner join t_csl_rptitem item on item.fnumber=dataEntry.fitemid ");
            if (isCompany) {
                sql.append(" inner join ").append(asstActTypeTable).append(" asstType on asstType.flongNumber=dataEntry.fkeyNumber ");
            }
            if (!isSheetNamesNull) {
                sql.append(" inner join t_rpt_rptsheetpara sheet on sheet.fsheetid=dataEntry.fsheetid and sheet.freportid=itemdata.freportid ");
            } else {
                sql.append(" left join t_rpt_rptsheetpara sheet on sheet.fsheetid=dataEntry.fsheetid and sheet.freportid=itemdata.freportid ");
            }
            sql.append(" where itemdata.freportid in ", rptIds);
            sql.append(" and dataEntry.fvaluetype=1 and dataEntry.fvalue<>0 and dataEntry.fvalue is not null ");
            sql.append(" and dataEntry.FDYNAITEMTYPE=? ", dynaItemType);
            if (!isSheetNamesNull) {
                sql.append(" and sheet.fsheetName in ", sheetNames);
            }
            if (isCompany) {
                DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
            } else {
                Map<String, String> targetCompanyMap;
                IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                HashSet<String> numbers = new HashSet<String>();
                while (rowSet != null && rowSet.next()) {
                    String keyNumber = this.getShortNumber(rowSet.getString("fkeyNumber"));
                    numbers.add(keyNumber);
                }
                if (!numbers.isEmpty() && !(targetCompanyMap = this.getTargetCompanys(ctx, asstActTypeTable, numbers)).isEmpty()) {
                    rowSet.beforeFirst();
                    ArrayList<Object[]> params = new ArrayList<Object[]>();
                    while (rowSet != null && rowSet.next()) {
                        String keyNumber = this.getShortNumber(rowSet.getString("fkeyNumber"));
                        String targetCompanyId = targetCompanyMap.get(keyNumber);
                        if (StringUtils.isEmpty((String)targetCompanyId)) continue;
                        int i = 0;
                        Object[] param = new Object[11];
                        param[i++] = rowSet.getString("fid");
                        param[i++] = rowSet.getString("fcompanyId");
                        param[i++] = rowSet.getString("FItemID");
                        param[i++] = rowSet.getString("fdataelement");
                        param[i++] = rowSet.getString("freportid");
                        param[i++] = targetCompanyId;
                        param[i++] = rowSet.getString("fsheetid");
                        param[i++] = rowSet.getString("fsheetName");
                        param[i++] = rowSet.getString("ftemplateid");
                        param[i++] = rowSet.getBigDecimal("fdebit");
                        param[i++] = rowSet.getBigDecimal("fcredit");
                        params.add(param);
                    }
                    if (!params.isEmpty()) {
                        DbUtil.executeBatch(ctx, insertStr + " values(?,?,?,?,?,?,?,?,?,?,?)", params);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"importFromDynaRpt error", (Throwable)e);
            throw e;
        }
    }

    public String getShortNumber(String longNumber) throws Exception {
        int lastIndex;
        if (longNumber != null && (lastIndex = longNumber.lastIndexOf("!")) > 0 && longNumber.length() > lastIndex + 1) {
            return longNumber.substring(lastIndex + 1);
        }
        return longNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getTargetCompanys(Context ctx, String asstActTypeTable, Set<String> numbers) throws Exception {
        HashMap<String, String> number_ids = new HashMap<String, String>();
        ParamTempTblService service = null;
        try {
            String inStr = null;
            if (numbers.size() > 50) {
                TableInfo table = new TableInfo("T_Csl_dyNumber");
                table.addColumn(new ColumnInfo("fnumber", "nvarchar(80)"));
                service = ParamTempTblService.getInstance((Context)ctx, (TableInfo)table, numbers, null);
                inStr = "select fnumber from " + service.getTmpTableName();
            }
            SQLBuilder sql = new SQLBuilder();
            sql.append("select FInternalCompanyID,FInternalProfitCenter,fnumber from ").append(asstActTypeTable);
            sql.append(" where FIsInternalCompany=1 ");
            if (inStr != null) {
                sql.append(" and fnumber in (").append(inStr).append(") ");
            } else {
                sql.append(" and FNumber IN ", numbers);
            }
            sql.append(" order by  fnumber ");
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            while (rowSet != null && rowSet.next()) {
                String targetCompanyId = rowSet.getString("FInternalCompanyID");
                if (StringUtils.isEmpty((String)targetCompanyId)) {
                    targetCompanyId = rowSet.getString("FInternalProfitCenter");
                }
                if (StringUtils.isEmpty((String)targetCompanyId)) continue;
                number_ids.put(rowSet.getString("fnumber"), targetCompanyId);
            }
        }
        finally {
            if (service != null && !DebugLogger.isDebug) {
                service.release();
            }
        }
        return number_ids;
    }

    public Map<String, ImportTemplateInfo> getImportTemplateInfo(Context ctx, Set<String> templateIds, Map<String, List<String>> templates, Map<String, String> templateId_srcTemplateIds) throws Exception {
        HashMap<String, ImportTemplateInfo> templateInfoMap = new HashMap<String, ImportTemplateInfo>();
        SQLBuilder sql = new SQLBuilder();
        sql.append("select ftemplatetype,fid from t_rpt_template where fid in", templateIds);
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        while (rowSet != null && rowSet.next()) {
            int templateType = rowSet.getInt("ftemplatetype");
            if (templateType != 10) continue;
            String templateId = rowSet.getString("fid");
            ImportTemplateInfo importTemplate = (ImportTemplateInfo)templateInfoMap.get(templateId);
            if (importTemplate == null) {
                importTemplate = new ImportTemplateInfo();
                templateInfoMap.put(templateId, importTemplate);
            }
            importTemplate.isDyTemplate = true;
        }
        HashMap<String, String> TemplateItemListTableNames = TemplateItemListNewUtil.getTemplateItemListTableName(ctx, templateIds);
        for (String templateId : TemplateItemListTableNames.keySet()) {
            ImportTemplateInfo importTemplate = (ImportTemplateInfo)templateInfoMap.get(templateId);
            if (importTemplate == null) {
                importTemplate = new ImportTemplateInfo();
                templateInfoMap.put(templateId, importTemplate);
            }
            importTemplate.sheetNames = templates.get(templateId_srcTemplateIds.get(templateId));
            importTemplate.templetItemListTable = TemplateItemListTableNames.get(templateId);
        }
        return templateInfoMap;
    }

    public OneToManyMap getReportIds(Context ctx, Map<String, List<String>> templates, List<String> orgUnitIds, int year, int period, int periodType, String currencyId, int[] rptAuditStatus, int[] rptCommitStatus, Map<String, String> templateId_srcTemplateIds, StringBuffer msg, String type) throws Exception {
        Set<String> templateIds = templates.keySet();
        OneToManyMap rptIds = new OneToManyMap();
        SQLBuilder sql = new SQLBuilder();
        sql.append(" select distinct rpt.fid,rpt.forgunitid,case when tmp.fgrouptemplateid is null then tmp.fid else tmp.fgrouptemplateid end ftemplateId,tmp2.fid srcTemplateId ");
        sql.append(" from t_csl_cslreport rpt ");
        sql.append(" inner join t_rpt_template tmp on tmp.fid=rpt.ftemplateid ");
        sql.append(" inner join t_rpt_template tmp2 on tmp2.fgroup=tmp.fgroup ");
        sql.append(" where rpt.fyear=? ", year).append(" and rpt.fperiod=?", period).append(" and rpt.fperiodType=?", periodType);
        sql.append(" and rpt.fcurrencyid=?", currencyId);
        sql.append(" and rpt.forgunitid in ", orgUnitIds);
        sql.append(" and tmp2.fid in ", templateIds);
        if (rptAuditStatus != null && rptCommitStatus != null) {
            sql.append(" and (rpt.fauditedstatus in", rptAuditStatus).append(" or rpt.fcommittedStatus in", rptCommitStatus).append(")");
        } else {
            if (rptAuditStatus != null) {
                sql.append(" and rpt.fauditedstatus in", rptAuditStatus);
            }
            if (rptCommitStatus != null) {
                sql.append(" and rpt.fcommittedStatus in", rptCommitStatus);
            }
        }
        HashSet<String> exitsUnitTemplates = new HashSet<String>();
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        while (rowSet != null && rowSet.next()) {
            rptIds.put((Object)rowSet.getString("ftemplateId"), (Object)rowSet.getString("fid"));
            exitsUnitTemplates.add(rowSet.getString("forgunitid") + rowSet.getString("srcTemplateId"));
            templateId_srcTemplateIds.put(rowSet.getString("ftemplateId"), rowSet.getString("srcTemplateId"));
        }
        if (exitsUnitTemplates.size() < orgUnitIds.size() * templateIds.size()) {
            HashSet<String[]> notExistUnitTemplates = new HashSet<String[]>();
            for (String orgUnitId : orgUnitIds) {
                for (String template : templateIds) {
                    if (exitsUnitTemplates.contains(orgUnitId + template)) continue;
                    notExistUnitTemplates.add(new String[]{orgUnitId, template});
                }
            }
            exitsUnitTemplates.clear();
            if (!notExistUnitTemplates.isEmpty()) {
                FullOrgUnitCollection orgColl = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection("select name,number where id in(" + this.getInStr(notExistUnitTemplates, 0) + ")");
                TemplateCollection templateColl = TemplateFactory.getLocalInstance((Context)ctx).getTemplateCollection(" select name,number,templateType where id in(" + this.getInStr(notExistUnitTemplates, 1) + ") ");
                Map<String, String[]> orgMap = this.getId_NameMap((AbstractObjectCollection)orgColl);
                Map<String, String[]> templateMap = this.getId_NameMap((AbstractObjectCollection)templateColl);
                String msgStr1 = AccountCheckUtil.getResourceString(ctx, "importFromRpt_NoInterExchRpt", null);
                String msgStr2 = AccountCheckUtil.getResourceString(ctx, "importFromRpt_NoDyRpt", null);
                String msgStr3 = AccountCheckUtil.getResourceString(ctx, "importFromRpt_NoCheckBillRpt", null);
                for (String[] notExistUnitTemplate : notExistUnitTemplates) {
                    String[] org = orgMap.get(notExistUnitTemplate[0]);
                    String[] tmp = templateMap.get(notExistUnitTemplate[1]);
                    String msgStr = msgStr1;
                    if (10 == Integer.valueOf(tmp[2])) {
                        msgStr = msgStr2;
                    }
                    if ("checkDataRpt".equals(type)) {
                        msg.append(MessageFormat.format(msgStr3, org[0] + "(" + org[1] + ")", tmp[0], tmp[1]));
                        msg.append("\n");
                        continue;
                    }
                    msg.append(MessageFormat.format(msgStr, org[0] + "(" + org[1] + ")", tmp[0] + "(" + tmp[1] + ")"));
                }
            }
        }
        return rptIds;
    }

    public Map<String, String[]> getId_NameMap(AbstractObjectCollection coll) throws Exception {
        HashMap<String, String[]> id_NameMap = new HashMap<String, String[]>();
        for (int i = 0; i < coll.size(); ++i) {
            String[] stringArray;
            IObjectValue objectValue = coll.getObject(i);
            String name = null;
            name = objectValue instanceof AbstractDataBaseInfo ? ((AbstractDataBaseInfo)objectValue).getName() : objectValue.getString("name");
            String templateType = objectValue.getString("templateType");
            String string = coll.getObject(i).getString("id");
            if (!StringUtils.isEmpty((String)templateType)) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = objectValue.getString("number");
                stringArray2[1] = name;
                stringArray = stringArray2;
                stringArray2[2] = templateType;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = objectValue.getString("number");
                stringArray = stringArray3;
                stringArray3[1] = name;
            }
            id_NameMap.put(string, stringArray);
        }
        return id_NameMap;
    }

    public String getInStr(Set<String[]> notExistUnitTemplates, int arrayIndex) throws Exception {
        if (notExistUnitTemplates != null && !notExistUnitTemplates.isEmpty()) {
            StringBuffer inStr = new StringBuffer();
            for (String[] notExistUnitTemplate : notExistUnitTemplates) {
                if (inStr.length() > 0) {
                    inStr.append(",");
                }
                inStr.append("'").append(notExistUnitTemplate[arrayIndex]).append("'");
            }
            return inStr.toString();
        }
        return "";
    }

    public String getImportDataTmpTable(Context ctx) throws Exception {
        TempTablePool tmpTablePool = TempTablePool.getInstance((Context)ctx);
        StringBuffer sql = new StringBuffer();
        sql.append(" create table t_csl_importTFromRptDataTmp(FYear varchar(4), FPeriod nvarchar(2), FCompanyNumber nvarchar(80),FTargetCompanyNumber nvarchar(80), ");
        sql.append(" FItemType varchar(3), FItemNumber nvarchar(80), FDataElementNumber nvarchar(80),");
        sql.append(" FCurrencyNumber nvarchar(80), FDebit nvarchar(32), FCredit nvarchar(32), FRemarks nvarchar(2000),");
        sql.append(" freportid varchar(44), ftemplateId varchar(44), fsheetid varchar(44), fsheetName nvarchar(300), FRowNum int, FRptCompanyNumber nvarchar(80), FRptCompanyName nvarchar(255))");
        return tmpTablePool.createTempTable(sql.toString());
    }

    public String getImportItemDataTmpTable(Context ctx) throws Exception {
        TempTablePool tmpTablePool = TempTablePool.getInstance((Context)ctx);
        StringBuffer sql = new StringBuffer();
        sql.append(" create table t_csl_elimTemplateTmp(fid varchar(44),fcompanyId varchar(44),ftargetCompanyId varchar(44),FItemID varchar(44),FDataElement int,");
        sql.append(" fdebit NUMERIC(21,6), fcredit NUMERIC(21,6), freportid varchar(44), ftemplateId varchar(44), fsheetid varchar(44), fsheetName nvarchar(300))");
        return tmpTablePool.createTempTable(sql.toString());
    }

    public RepeatItemDataInfo getRepeatItemDataInfo(IRowSet rowSet) throws Exception {
        RepeatItemDataInfo info = new RepeatItemDataInfo();
        info.companyNumber = rowSet.getString("ownNumber");
        info.companyName = rowSet.getString("companyName");
        info.targetCompanyNumber = rowSet.getString("targetNumber");
        info.targetCompanyName = rowSet.getString("targetCompanyName");
        info.tmpNumber = rowSet.getString("tmpNumber");
        info.tmpName = rowSet.getString("tmpName");
        info.sheetName = rowSet.getString("fsheetName");
        info.itemNumber = rowSet.getString("itemNumber");
        info.itemName = rowSet.getString("itemName");
        info.dataElementName = rowSet.getString("dataElementName");
        info.dataElementNumber = rowSet.getString("dataElementNumber");
        return info;
    }

    public void test(Context ctx) {
        HashMap<String, List<String>> templates = new HashMap<String, List<String>>();
        ArrayList<String> sheetNames = new ArrayList<String>();
        sheetNames.add(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"85_ImportFromRptUtil", (Locale)ctx.getLocale()));
        sheetNames.add(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"86_ImportFromRptUtil", (Locale)ctx.getLocale()));
        templates.put("Rl3ejpq1TGmFcS8Wn+JM7C1SfUU=", sheetNames);
        ArrayList<String> sheetNames2 = new ArrayList<String>();
        sheetNames2.add(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"87_ImportFromRptUtil", (Locale)ctx.getLocale()));
        templates.put("4FjHCXxgRY+OtGHfPIATjC1SfUU=", sheetNames2);
        ArrayList<String> orgUnitIds = new ArrayList<String>();
        orgUnitIds.add("////8P//7/9zqgAAAFEUOMznrtQ=");
        orgUnitIds.add("////8P//7/9zqgAAAFEUNMznrtQ=");
        String currencyId = "dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC";
        try {
            this.importItemDatasFromInterExchDyRpt(ctx, templates, orgUnitIds, 2020, 1, 3, currencyId, new int[]{1}, null, 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public class ErrorType {
        public static final int itemSetError = 1;
        public static final int itemMapError = 2;
        public static final int itemDataExistsError = 3;
        public static final int itemDataAuditedError = 4;
        public static final int itemDataAuditedErrorMap = 5;
        public static final int itemDataRepeat = 6;
        public static final int itemMapNotDispenseError = 7;
    }

    public class RepeatItemDataInfo {
        public String companyNumber;
        public String targetCompanyNumber;
        public String companyName;
        public String targetCompanyName;
        public String tmpNumber;
        public String tmpName;
        public String sheetName;
        public String itemNumber;
        public String itemName;
        public String dataElementName;
        public String dataElementNumber;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.companyNumber).append(this.targetCompanyName).append(this.itemNumber);
            sb.append(this.dataElementNumber);
            return sb.toString();
        }

        public boolean equals(Object obj) {
            return this.toString().equals(obj.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    public class ImportTemplateInfo {
        String templetItemListTable = null;
        List<String> sheetNames = null;
        boolean isDyTemplate = false;
    }
}

