/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app.querycheckagedata;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.app.querycheckagedata.IQueryBalance;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.List;

public class AbstractQueryBalance
implements IQueryBalance {
    private Context ctx;
    private String companyId = null;
    String balTypeString = null;
    private String accountTempTable = null;
    private PeriodInfo currentPeriodInfo;
    private int startYear;
    private int startPeriod;
    private int endYear;
    private int endPeriod;
    private String currencyId;
    private boolean isIncludePosted = false;
    private boolean isDetailAccount = false;
    private boolean isMultiUnPosted = false;
    private static final String T_GL_ASSIST_BALANCE_1F = "T_GL_AssistBalance_1F";
    private static final String T_GL_ASSIST_BALANCE_5F = "T_GL_AssistBalance_5F";

    public AbstractQueryBalance(Context ctx, String companyId, String accountTempTable, PeriodInfo currentPeriodInfo, int startYear, int startPeriod, int endYear, int endPeriod, String currencyId, String balTypeString, boolean isIncludePosted, boolean isMultiUnPosted, boolean isDetailAccount) {
        this.ctx = ctx;
        this.balTypeString = balTypeString;
        this.companyId = companyId;
        this.accountTempTable = accountTempTable;
        this.currentPeriodInfo = currentPeriodInfo;
        this.startYear = startYear;
        this.startPeriod = startPeriod;
        this.endYear = endYear;
        this.endPeriod = endPeriod;
        this.currencyId = currencyId;
        this.isIncludePosted = isIncludePosted;
        this.isDetailAccount = isDetailAccount;
        this.isMultiUnPosted = isMultiUnPosted;
    }

    public String getBalTable() {
        if (this.isIncludePosted) {
            return T_GL_ASSIST_BALANCE_1F;
        }
        return T_GL_ASSIST_BALANCE_5F;
    }

    public String getPeriod(int startYear, int startPeriod, int endYear, int endPeriod) {
        String periodString = RptUtil.getYearPeriod((int)startYear, (int)startPeriod, (int)endYear, (int)endPeriod);
        return periodString;
    }

    @Override
    public StringBuffer buildSelectPart(boolean isOwner) {
        StringBuffer select = new StringBuffer();
        select.append(this.getSelectPart());
        select.append(" ,A_Bal.FOrgUnitID ownCompany");
        if (this.isDetailAccount) {
            select.append(" ,A_Bal.FAccountID accountID");
            if (!isOwner) {
                select.append(" ,A_ACCTLEAF.FDC dc");
            }
        } else {
            select.append(" ,A_Acct.FID accountID");
            if (!isOwner) {
                select.append(" ,A_Acct.FDC dc");
            }
        }
        return select;
    }

    private StringBuffer getSelectPart() {
        StringBuffer select = new StringBuffer();
        if (this.balTypeString.equals("JF_DF")) {
            select.append("SELECT SUM(A_Bal.FDebitFor) JF, SUM(A_Bal.FCreditFor) DF");
        } else if (this.balTypeString.equals("JL_DL")) {
            select.append("SELECT SUM(A_Bal.FYearDebitFor) JL, SUM(A_Bal.FYearCreditFor) DL");
        } else if (this.balTypeString.equals("C")) {
            select.append("SELECT SUM(A_Bal.FBeginBalanceFor) C");
        } else if (this.balTypeString.equals("Y")) {
            select.append("SELECT SUM(A_Bal.FEndBalanceFor) Y");
        } else if (this.balTypeString.equals("SY")) {
            select.append("SELECT SUM(A_Bal.FMonthPnLFor) SY");
        } else if (this.balTypeString.equals("SL")) {
            select.append("SELECT SUM(A_Bal.FYearPnLFor) SL");
        }
        return select;
    }

    @Override
    public StringBuffer buildFromPart(boolean isOwner) {
        StringBuffer from = new StringBuffer();
        from.append(" FROM ");
        if (this.isMultiUnPosted) {
            from.append(this.buildMultiSql(isOwner));
        } else {
            from.append(this.getBalTable()).append(" A_Bal \n");
        }
        if (this.isDetailAccount) {
            if (isOwner) {
                from.append(" INNER JOIN ").append(this.accountTempTable).append(" account ON ").append("account.FAccountId = A_Bal.FAccountID \n");
            } else {
                from.append(" INNER JOIN T_BD_AccountView A_ACCTLEAF ON A_Bal.FAccountID = A_AcctLeaf.FID \n");
                from.append(" INNER JOIN ").append(this.accountTempTable).append(" account ON ").append("account.FAccountId = A_ACCTLEAF.FNumber \n");
            }
        } else {
            from.append(" INNER JOIN T_BD_AccountView A_ACCTLEAF ON A_Bal.FAccountID = A_AcctLeaf.FID \n");
            from.append(" INNER JOIN T_BD_AccountView A_ACCT ON A_Acct.FCompanyID = A_AcctLeaf.FCompanyID AND A_Acct.FAccountTableID = A_AcctLeaf.FAccountTableID AND A_AcctLeaf.FNumber LIKE CONCAT(A_Acct.FNumber, '%') \n");
            if (isOwner) {
                from.append(" INNER JOIN ").append(this.accountTempTable).append(" account ON ").append("account.FAccountId = A_ACCT.FID \n");
            } else {
                from.append(" INNER JOIN ").append(this.accountTempTable).append(" account ON ").append("account.FAccountId = A_ACCT.FNumber \n");
            }
        }
        from.append(" INNER JOIN T_BD_AssistantHG A_HG ON A_Bal.FAssistGrpID = A_Hg.fid \n");
        return from;
    }

    public StringBuffer buildMultiSql(boolean isOwner) {
        StringBuffer select;
        StringBuffer sql = new StringBuffer();
        sql.append(" ( ");
        if (this.balTypeString.equals("C") || this.balTypeString.equals("Y") || this.startPeriod != 1) {
            select = this.getUnPostedBalanceSelectPart();
            sql.append(select);
            sql.append(" From ").append(this.getBalTable()).append(" BalancePart \n");
            sql.append(" Where BalancePart.FPeriod = ? ");
            sql.append(" And BalancePart.FCurrencyId = ? ");
            if (isOwner) {
                sql.append(" And BalancePart.FOrgUnitID = ? \n");
            } else {
                sql.append(" \n");
            }
            sql.append(" Union All \n");
        }
        select = this.getUnPostedAccrualSelectPart();
        sql.append(select);
        sql.append(" From ").append(this.getBalTable()).append(" AccrualPart");
        sql.append(" Where AccrualPart.FCurrencyId = ? ");
        if (isOwner) {
            sql.append(" And AccrualPart.FOrgUnitID = ? ");
        }
        sql.append(" And AccrualPart.FPeriod in (").append(this.getPeriodPlaceHolder()).append(") ");
        sql.append(" ) A_Bal \n");
        return sql;
    }

    public StringBuffer getUnPostedBalanceSelectPart() {
        StringBuffer select = new StringBuffer();
        if (this.balTypeString.equals("C")) {
            select.append("Select BalancePart.FBeginBalanceFor FBeginBalanceFor, BalancePart.FCurrencyID FCurrencyID,BalancePart.FOrgUnitID FOrgUnitID,BalancePart.FAccountID FAccountID, BalancePart.FAssistGrpID FAssistGrpID \n");
        } else if (this.balTypeString.equals("Y")) {
            select.append("Select BalancePart.FEndBalanceFor FEndBalanceFor, BalancePart.FCurrencyID FCurrencyID,BalancePart.FOrgUnitID FOrgUnitID,BalancePart.FAccountID FAccountID, BalancePart.FAssistGrpID FAssistGrpID \n");
        } else if (this.balTypeString.equals("SL")) {
            select.append("Select BalancePart.FYearPnLFor FYearPnLFor,BalancePart.FCurrencyID FCurrencyID,BalancePart.FOrgUnitID FOrgUnitID,BalancePart.FAccountID FAccountID, BalancePart.FAssistGrpID FAssistGrpID \n");
        } else if (this.balTypeString.equals("JL_DL")) {
            select.append("Select BalancePart.FYearDebitFor FYearDebitFor,BalancePart.FYearCreditFor FYearCreditFor,BalancePart.FCurrencyID FCurrencyID,BalancePart.FOrgUnitID FOrgUnitID,BalancePart.FAccountID FAccountID, BalancePart.FAssistGrpID FAssistGrpID \n");
        }
        return select;
    }

    public StringBuffer getUnPostedAccrualSelectPart() {
        StringBuffer select = new StringBuffer();
        if (this.balTypeString.equals("C")) {
            select.append("Select (AccrualPart.FDebitFor - AccrualPart.FCreditFor) FBeginBalanceFor ,AccrualPart.FCurrencyID FCurrencyID,AccrualPart.FOrgUnitID FOrgUnitID,AccrualPart.FAccountID FAccountID, AccrualPart.FAssistGrpID FAssistGrpID \n");
        } else if (this.balTypeString.equals("Y")) {
            select.append("Select (AccrualPart.FDebitFor - AccrualPart.FCreditFor) FEndBalanceFor,AccrualPart.FCurrencyID FCurrencyID,AccrualPart.FOrgUnitID FOrgUnitID,AccrualPart.FAccountID FAccountID, AccrualPart.FAssistGrpID FAssistGrpID \n");
        } else if (this.balTypeString.equals("SL")) {
            select.append("Select AccrualPart.FMonthPnLFor FYearPnLFor,AccrualPart.FCurrencyID FCurrencyID,AccrualPart.FOrgUnitID FOrgUnitID,AccrualPart.FAccountID FAccountID, AccrualPart.FAssistGrpID FAssistGrpID \n");
        } else if (this.balTypeString.equals("JL_DL")) {
            select.append("Select AccrualPart.FDebitFor FYearDebitFor,AccrualPart.FCreditFor FYearCreditFor,AccrualPart.FCurrencyID FCurrencyID,AccrualPart.FOrgUnitID FOrgUnitID,AccrualPart.FAccountID FAccountID, AccrualPart.FAssistGrpID FAssistGrpID \n");
        }
        return select;
    }

    @Override
    public StringBuffer buildWherePart(boolean isOwner) {
        StringBuffer where = new StringBuffer();
        where.append(" WHERE ");
        if (isOwner) {
            where.append(" A_Bal.FOrgUnitID = ? ").append(" And");
        }
        where.append(" A_Bal.FCurrencyID = ? \n");
        if (!this.isMultiUnPosted) {
            where.append(" AND A_Bal.FPeriod IN (").append(this.getPeriodPlaceHolder()).append(") \n");
        }
        if (!this.isDetailAccount) {
            where.append(" AND A_AcctLeaf.FIsLeaf = ? \n");
        }
        return where;
    }

    private String getPeriodPlaceHolder() {
        StringBuffer placeHoleder = new StringBuffer();
        String period = this.getPeriod(this.startYear, this.startPeriod, this.endYear, this.endPeriod);
        String[] periods = period.split(",");
        int length = periods.length;
        for (int i = 0; i < length; ++i) {
            placeHoleder.append("?");
            if (i == length - 1) continue;
            placeHoleder.append(",");
        }
        return placeHoleder.toString();
    }

    @Override
    public StringBuffer buildGroupPart(boolean isOwner) {
        StringBuffer group = new StringBuffer();
        group.append(" Group By ");
        if (this.isDetailAccount) {
            group.append(" A_Bal.FAccountID ");
            if (!isOwner) {
                group.append(" ,A_ACCTLEAF.FDC ");
            }
        } else {
            group.append(" A_Acct.FID ");
            if (!isOwner) {
                group.append(" ,A_Acct.FDC ");
            }
        }
        group.append(" ,A_Bal.FOrgUnitID ");
        return group;
    }

    public List getParams(boolean isOwner) {
        ArrayList<Object> params = new ArrayList<Object>();
        if (this.isMultiUnPosted) {
            if (this.balTypeString.equals("C") || this.balTypeString.equals("Y") || this.startPeriod != 1) {
                params.add(Integer.valueOf(this.getPeriod(this.currentPeriodInfo.getPeriodYear(), this.currentPeriodInfo.getPeriodNumber(), this.currentPeriodInfo.getPeriodYear(), this.currentPeriodInfo.getPeriodNumber())));
                params.add(this.currencyId);
                if (isOwner) {
                    params.add(this.companyId);
                }
            }
            params.add(this.currencyId);
            if (isOwner) {
                params.add(this.companyId);
            }
            this.getPeriodParams(params);
        }
        if (isOwner) {
            params.add(this.companyId);
        }
        params.add(this.currencyId);
        if (!this.isMultiUnPosted) {
            this.getPeriodParams(params);
        }
        if (!this.isDetailAccount) {
            params.add(1);
        }
        return params;
    }

    private void getPeriodParams(List params) {
        String periodStr = this.getPeriod(this.startYear, this.startPeriod, this.endYear, this.endPeriod);
        for (String period : periodStr.split(",")) {
            params.add(period);
        }
    }

    @Override
    public IRowSet queryOwnBalance() throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append(this.buildSelectPart(true));
        sql.append(this.buildFromPart(true));
        sql.append(this.buildWherePart(true));
        sql.append(this.buildGroupPart(true));
        List params = this.getParams(true);
        IRowSet rowSet = DbUtil.executeQuery(this.ctx, sql.toString(), params.toArray());
        return rowSet;
    }

    @Override
    public IRowSet queryTargetBalance() throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append(this.buildSelectPart(false));
        sql.append(this.buildFromPart(false));
        sql.append(this.buildWherePart(false));
        sql.append(this.buildGroupPart(false));
        List params = this.getParams(false);
        IRowSet rowSet = DbUtil.executeQuery(this.ctx, sql.toString(), params.toArray());
        return rowSet;
    }
}

