/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app.querycheckagedata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryCheckageAccounts {
    private Context ctx = null;
    private String companyTempTable = null;
    private int year;
    private int period;
    private String mappingId;
    private Map<String, Map<String, Map<String, List<String>>>> actTypeAcountIds = null;
    private Map<String, Map<String, Map<String, List<String>>>> actTypeDetailAcountIds = null;
    private Map<String, Map<String, Map<String, List<String>>>> actTypeAcountNumbers = null;
    private Map<String, Map<String, Map<String, List<String>>>> actTypeDetailAcountNumbers = null;
    private Map<String, Map<Integer, List<AccountViewInfo>>> balTypeAccounts = null;
    private ParamTempTblService service = null;
    private String accoutIdTempTable = null;

    public QueryCheckageAccounts(Context ctx, String companyTempTable, int year, int period) {
        this.ctx = ctx;
        this.companyTempTable = companyTempTable;
        this.year = year;
        this.period = period;
    }

    public QueryCheckageAccounts(Context ctx, String companyTempTable, int year, int period, String mappingId) {
        this.ctx = ctx;
        this.companyTempTable = companyTempTable;
        this.year = year;
        this.period = period;
        this.mappingId = mappingId;
    }

    public QueryCheckageAccounts(Context ctx) {
        this.ctx = ctx;
    }

    public void getCheckageAccounts() throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("Select accountView.FCompanyid companyId, accountView.FId accountId, accountView.FNumber accountNumber, chkAccount.FBalType balType, chkAccount.FasstActType asstActType, accountView.FDC dc, accountView.FIsLeaf isLeaf, newAccountView.FId newAccountId, newAccountView.FNumber newAccountNumber, newAccountView.FDC newdc, newAccountView.FIsLeaf isNewLeaf \n");
        sql.append(" From T_CSL_CheckageAccount chkAccount \n");
        sql.append(" Inner Join T_Csl_AccountAndMapAccount ama On ama.FCheckAccountId = chkAccount.FId \n");
        sql.append(" Inner Join T_Csl_AccountMap am On am.FId = ama.FAccountMapId \n");
        sql.append(" Inner Join T_Csl_AccountMapDispense disp On disp.FAccountMapId = am.FId \n");
        sql.append(" Inner Join T_Csl_CheckageCompany chkCom On chkCom.FID = disp.FCheckageCompanyId");
        sql.append(" Inner Join ").append(this.companyTempTable).append(" tempTbl On chkCom.FCompanyId = tempTbl.FcompanyId \n");
        sql.append(" Inner join T_BD_AccountView accountView On  chkAccount.FItemNumber = accountView.FNumber And tempTbl.FcompanyId = accountView.FCompanyID \n");
        sql.append(" Left Join T_BD_AcctRefContrastEntry accrce On accrce.FOldAcctID = accountView.FId \n");
        sql.append(" Left Join T_BD_AcctRefContrast accrc On accrc.FCompanyID = tempTbl.FcompanyId And (accrc.FId = accrce.FAcctRefContrastID And accrc.FRefType = ? And accrc.FISENABLED = ? And accrc.FENABLEDPERIODID IS NOT NULL) \n");
        sql.append(" Left Join T_BD_PERIOD period On (accrc.FENABLEDPERIODID = period.FID And (period.FPERIODYEAR < ? Or (period.FPERIODYEAR = ? And period.FPERIODNUMBER <= ?))) \n");
        sql.append(" Left Join T_BD_AccountView newAccountView On accrce.FNewAcctID = newAccountView.FId \n");
        sql.append(" Where chkAccount.FIsFree = ? And chkAccount.FItemType = ? And am.FItemType = ? And am.FIsFree = ? And ama.FDataSource = ?");
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(1);
        params.add(1);
        params.add(this.year);
        params.add(this.year);
        params.add(this.period);
        params.add(0);
        params.add(0);
        params.add(0);
        params.add(0);
        params.add(1);
        IRowSet rowSet = DbUtil.executeQuery(this.ctx, sql.toString(), params.toArray());
        Map<String, List<String>> actTypeMap = null;
        Map<String, Map<String, List<String>>> balTypeMap = null;
        List<String> accountIds = null;
        AccountViewInfo accountViewInfo = null;
        List<AccountViewInfo> accountViewInfos = null;
        Map<Integer, List<AccountViewInfo>> balTypeAcctInfoMap = null;
        while (rowSet.next()) {
            String companyId = rowSet.getString("companyId");
            String asstActType = rowSet.getString("asstActType");
            String chkAccountId = rowSet.getString("accountId");
            String chkAccountNumber = rowSet.getString("accountNumber");
            int balType = rowSet.getInt("balType");
            int dc = rowSet.getInt("dc");
            boolean isLeaf = rowSet.getBoolean("isLeaf");
            String newAccountId = rowSet.getString("newAccountId");
            String newAccountNumber = rowSet.getString("newAccountNumber");
            int newdc = rowSet.getInt("newdc");
            boolean isNewLeaf = rowSet.getBoolean("isNewLeaf");
            if (StringUtils.isEmpty((String)chkAccountId)) continue;
            if (isLeaf) {
                this.groupDetailAccountByActType(companyId, balType, asstActType, chkAccountId, balTypeMap, actTypeMap, accountIds);
                this.groupDetailAccountNumberByActType(companyId, balType, asstActType, chkAccountNumber, balTypeMap, actTypeMap, accountIds);
            } else {
                this.groupAccountByActType(companyId, balType, asstActType, chkAccountId, balTypeMap, actTypeMap, accountIds);
                this.groupAccountNumberByActType(companyId, balType, asstActType, chkAccountNumber, balTypeMap, actTypeMap, accountIds);
            }
            this.addNewAccountIdByActType(companyId, balType, asstActType, newAccountId, newAccountNumber, isNewLeaf, balTypeMap, actTypeMap, accountIds);
            this.groupAccountByBalType(companyId, balType, chkAccountId, chkAccountNumber, dc, balTypeAcctInfoMap, accountViewInfo, accountViewInfos);
            this.groupNewAccountByBalType(companyId, balType, newAccountId, chkAccountNumber, newdc, balTypeAcctInfoMap, accountViewInfo, accountViewInfos);
        }
    }

    public void getCheckageAccountsByMapping() throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("Select accountView.FCompanyid companyId, accountView.FId accountId, accountView.FNumber accountNumber, chkAccount.FBalType balType, chkAccount.FasstActType asstActType, mappingAccount.FDC dc, accountView.FIsLeaf isLeaf, newAccountView.FId newAccountId, newAccountView.FNumber newAccountNumber, mappingAccount.FDC newdc, newAccountView.FIsLeaf isNewLeaf \n");
        sql.append(" From T_CSL_CheckageAccount chkAccount \n");
        sql.append(" Inner join T_Csl_RPTItemAccount mappingAccount On mappingAccount.FCheckAccountId = chkAccount.FId \n");
        sql.append(" Inner join T_Csl_RPTItemMap mapping On mapping.FId = mappingAccount.FRptItemMapId \n");
        sql.append(" Inner join T_BD_AccountView accountView On  chkAccount.FItemNumber = accountView.FNumber \n");
        sql.append(" Inner Join ").append(this.companyTempTable).append(" tempTbl On tempTbl.FcompanyId = accountView.FCompanyID \n");
        sql.append(" Left Join T_BD_AcctRefContrastEntry accrce On accrce.FOldAcctID = accountView.FId \n");
        sql.append(" Left Join T_BD_AcctRefContrast accrc On (accrc.FId = accrce.FAcctRefContrastID And accrc.FRefType = ? And accrc.FISENABLED = ? And accrc.FENABLEDPERIODID IS NOT NULL ) \n");
        sql.append(" Left Join ").append(this.companyTempTable).append(" orgTempTbl On accrc.FCompanyID = orgTempTbl.FcompanyId \n");
        sql.append(" Left Join T_BD_PERIOD period On (accrc.FENABLEDPERIODID = period.FID And (period.FPERIODYEAR < ? Or (period.FPERIODYEAR = ? And period.FPERIODNUMBER <= ?))) \n");
        sql.append(" Left Join T_BD_AccountView newAccountView On accrce.FNewAcctID = newAccountView.FId \n");
        sql.append(" Where chkAccount.FIsFree = ? And chkAccount.FItemType = ? And mapping.FId = ?");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(1);
        params.add(1);
        params.add(this.year);
        params.add(this.year);
        params.add(this.period);
        params.add(0);
        params.add(0);
        params.add(this.mappingId);
        IRowSet rowSet = DbUtil.executeQuery(this.ctx, sql.toString(), params.toArray());
        Map<String, List<String>> actTypeMap = null;
        Map<String, Map<String, List<String>>> balTypeMap = null;
        List<String> accountIds = null;
        AccountViewInfo accountViewInfo = null;
        List<AccountViewInfo> accountViewInfos = null;
        Map<Integer, List<AccountViewInfo>> balTypeAcctInfoMap = null;
        while (rowSet.next()) {
            String companyId = rowSet.getString("companyId");
            String asstActType = rowSet.getString("asstActType");
            String chkAccountId = rowSet.getString("accountId");
            String chkAccountNumber = rowSet.getString("accountNumber");
            int balType = rowSet.getInt("balType");
            int dc = rowSet.getInt("dc");
            boolean isLeaf = rowSet.getBoolean("isLeaf");
            String newAccountId = rowSet.getString("newAccountId");
            String newAccountNumber = rowSet.getString("newAccountNumber");
            int newdc = rowSet.getInt("newdc");
            boolean isNewLeaf = rowSet.getBoolean("isNewLeaf");
            if (StringUtils.isEmpty((String)chkAccountId)) continue;
            if (isLeaf) {
                this.groupDetailAccountByActType(companyId, balType, asstActType, chkAccountId, balTypeMap, actTypeMap, accountIds);
                this.groupDetailAccountNumberByActType(companyId, balType, asstActType, chkAccountNumber, balTypeMap, actTypeMap, accountIds);
            } else {
                this.groupAccountByActType(companyId, balType, asstActType, chkAccountId, balTypeMap, actTypeMap, accountIds);
                this.groupAccountNumberByActType(companyId, balType, asstActType, chkAccountNumber, balTypeMap, actTypeMap, accountIds);
            }
            this.addNewAccountIdByActType(companyId, balType, asstActType, newAccountId, newAccountNumber, isNewLeaf, balTypeMap, actTypeMap, accountIds);
            this.groupAccountByBalType(companyId, balType, chkAccountId, chkAccountNumber, dc, balTypeAcctInfoMap, accountViewInfo, accountViewInfos);
            this.groupNewAccountByBalType(companyId, balType, newAccountId, chkAccountNumber, newdc, balTypeAcctInfoMap, accountViewInfo, accountViewInfos);
        }
    }

    private void groupNewAccountByBalType(String companyId, int balType, String newAccountId, String chkAccountNumber, int newdc, Map<Integer, List<AccountViewInfo>> balTypeAcctInfoMap, AccountViewInfo accountViewInfo, List<AccountViewInfo> accountViewInfos) {
        if (!StringUtils.isEmpty((String)newAccountId)) {
            this.groupAccountByBalType(companyId, balType, newAccountId, chkAccountNumber, newdc, balTypeAcctInfoMap, accountViewInfo, accountViewInfos);
        }
    }

    public void groupAccountByBalType(String companyId, int balType, String chkAccountId, String chkAccountNumber, int dc, Map<Integer, List<AccountViewInfo>> balTypeAcctInfoMap, AccountViewInfo accountViewInfo, List<AccountViewInfo> accountViewInfos) {
        accountViewInfos = new ArrayList<AccountViewInfo>();
        balTypeAcctInfoMap = new HashMap<Integer, List<AccountViewInfo>>();
        if (this.balTypeAccounts == null) {
            this.balTypeAccounts = new HashMap<String, Map<Integer, List<AccountViewInfo>>>();
            accountViewInfo = this.getAccountViewInfo(accountViewInfo, chkAccountId, chkAccountNumber, dc);
            accountViewInfos.add(accountViewInfo);
            balTypeAcctInfoMap.put(balType, accountViewInfos);
            this.balTypeAccounts.put(companyId, balTypeAcctInfoMap);
        } else if (this.balTypeAccounts.containsKey(companyId)) {
            balTypeAcctInfoMap = this.balTypeAccounts.get(companyId);
            if (balTypeAcctInfoMap.containsKey(balType)) {
                accountViewInfo = this.getAccountViewInfo(accountViewInfo, chkAccountId, chkAccountNumber, dc);
                balTypeAcctInfoMap.get(balType).add(accountViewInfo);
                this.balTypeAccounts.put(companyId, balTypeAcctInfoMap);
            } else {
                accountViewInfo = this.getAccountViewInfo(accountViewInfo, chkAccountId, chkAccountNumber, dc);
                accountViewInfos.add(accountViewInfo);
                balTypeAcctInfoMap.put(balType, accountViewInfos);
                this.balTypeAccounts.put(companyId, balTypeAcctInfoMap);
            }
        } else {
            accountViewInfo = this.getAccountViewInfo(accountViewInfo, chkAccountId, chkAccountNumber, dc);
            accountViewInfos.add(accountViewInfo);
            balTypeAcctInfoMap.put(balType, accountViewInfos);
            this.balTypeAccounts.put(companyId, balTypeAcctInfoMap);
        }
    }

    private AccountViewInfo getAccountViewInfo(AccountViewInfo accountViewInfo, String chkAccountId, String chkAccountNumber, int dc) {
        accountViewInfo = new AccountViewInfo();
        accountViewInfo.setId(BOSUuid.read((String)chkAccountId));
        accountViewInfo.setNumber(chkAccountNumber);
        accountViewInfo.setDC(BalanceDirectionEnum.getEnum((int)dc));
        return accountViewInfo;
    }

    private void addNewAccountIdByActType(String companyId, int balType, String asstActType, String newAccountId, String newAccountNumber, boolean isNewLeaf, Map<String, Map<String, List<String>>> balTypeMap, Map<String, List<String>> actTypeMap, List<String> accounts) {
        if (!StringUtils.isEmpty((String)newAccountId)) {
            if (isNewLeaf) {
                this.groupDetailAccountByActType(companyId, balType, asstActType, newAccountId, balTypeMap, actTypeMap, accounts);
                this.groupDetailAccountNumberByActType(companyId, balType, asstActType, newAccountNumber, balTypeMap, actTypeMap, accounts);
            } else {
                this.groupAccountByActType(companyId, balType, asstActType, newAccountId, balTypeMap, actTypeMap, accounts);
                this.groupAccountNumberByActType(companyId, balType, asstActType, newAccountNumber, balTypeMap, actTypeMap, accounts);
            }
        }
    }

    public void groupDetailAccountByActType(String companyId, int balType, String asstActType, String chkAccountId, Map<String, Map<String, List<String>>> balTypeMap, Map<String, List<String>> actTypeMap, List<String> detailAccountIds) {
        detailAccountIds = new ArrayList<String>();
        String balTypeString = this.getBalTypeString(balType);
        actTypeMap = new HashMap<String, List<String>>();
        balTypeMap = new HashMap<String, Map<String, List<String>>>();
        if (this.actTypeDetailAcountIds == null) {
            this.actTypeDetailAcountIds = new HashMap<String, Map<String, Map<String, List<String>>>>();
            detailAccountIds.add(chkAccountId);
            actTypeMap.put(asstActType, detailAccountIds);
            balTypeMap.put(balTypeString, actTypeMap);
            this.actTypeDetailAcountIds.put(companyId, balTypeMap);
        } else if (this.actTypeDetailAcountIds.containsKey(companyId)) {
            balTypeMap = this.actTypeDetailAcountIds.get(companyId);
            if (balTypeMap.containsKey(balTypeString)) {
                actTypeMap = balTypeMap.get(balTypeString);
                if (actTypeMap.containsKey(asstActType)) {
                    detailAccountIds = actTypeMap.get(asstActType);
                    if (!detailAccountIds.contains(chkAccountId)) {
                        detailAccountIds.add(chkAccountId);
                    }
                } else if (!detailAccountIds.contains(chkAccountId)) {
                    detailAccountIds.add(chkAccountId);
                    actTypeMap.put(asstActType, detailAccountIds);
                }
            } else if (!detailAccountIds.contains(chkAccountId)) {
                detailAccountIds.add(chkAccountId);
                actTypeMap.put(asstActType, detailAccountIds);
                balTypeMap.put(balTypeString, actTypeMap);
                this.actTypeDetailAcountIds.put(companyId, balTypeMap);
            }
        } else if (!detailAccountIds.contains(chkAccountId)) {
            detailAccountIds.add(chkAccountId);
            actTypeMap.put(asstActType, detailAccountIds);
            balTypeMap.put(balTypeString, actTypeMap);
            this.actTypeDetailAcountIds.put(companyId, balTypeMap);
        }
    }

    public void groupDetailAccountNumberByActType(String companyId, int balType, String asstActType, String chkAccountNumber, Map<String, Map<String, List<String>>> balTypeMap, Map<String, List<String>> actTypeMap, List<String> accountNumbers) {
        accountNumbers = new ArrayList<String>();
        String balTypeString = this.getBalTypeString(balType);
        actTypeMap = new HashMap<String, List<String>>();
        balTypeMap = new HashMap<String, Map<String, List<String>>>();
        if (this.actTypeDetailAcountNumbers == null) {
            this.actTypeDetailAcountNumbers = new HashMap<String, Map<String, Map<String, List<String>>>>();
            accountNumbers.add(chkAccountNumber);
            actTypeMap.put(asstActType, accountNumbers);
            balTypeMap.put(balTypeString, actTypeMap);
            this.actTypeDetailAcountNumbers.put(companyId, balTypeMap);
        } else if (this.actTypeDetailAcountNumbers.containsKey(companyId)) {
            balTypeMap = this.actTypeDetailAcountNumbers.get(companyId);
            if (balTypeMap.containsKey(balTypeString)) {
                actTypeMap = balTypeMap.get(balTypeString);
                if (actTypeMap.containsKey(asstActType)) {
                    accountNumbers = actTypeMap.get(asstActType);
                    if (!accountNumbers.contains(chkAccountNumber)) {
                        accountNumbers.add(chkAccountNumber);
                    }
                } else if (!accountNumbers.contains(chkAccountNumber)) {
                    accountNumbers.add(chkAccountNumber);
                    actTypeMap.put(asstActType, accountNumbers);
                }
            } else if (!accountNumbers.contains(chkAccountNumber)) {
                accountNumbers.add(chkAccountNumber);
                actTypeMap.put(asstActType, accountNumbers);
                balTypeMap.put(balTypeString, actTypeMap);
                this.actTypeDetailAcountNumbers.put(companyId, balTypeMap);
            }
        } else if (!accountNumbers.contains(chkAccountNumber)) {
            accountNumbers.add(chkAccountNumber);
            actTypeMap.put(asstActType, accountNumbers);
            balTypeMap.put(balTypeString, actTypeMap);
            this.actTypeDetailAcountNumbers.put(companyId, balTypeMap);
        }
    }

    private String getBalTypeString(int balType) {
        switch (balType) {
            case 2: {
                return "JF_DF";
            }
            case 3: {
                return "JF_DF";
            }
            case 4: {
                return "JL_DL";
            }
            case 5: {
                return "JL_DL";
            }
            case 6: {
                return "SY";
            }
            case 7: {
                return "SL";
            }
            case 1: {
                return "C";
            }
            case 8: {
                return "Y";
            }
        }
        return null;
    }

    public void groupAccountByActType(String companyId, int balType, String asstActType, String chkAccountId, Map<String, Map<String, List<String>>> balTypeMap, Map<String, List<String>> actTypeMap, List<String> accountIds) {
        accountIds = new ArrayList<String>();
        String balTypeString = this.getBalTypeString(balType);
        actTypeMap = new HashMap<String, List<String>>();
        balTypeMap = new HashMap<String, Map<String, List<String>>>();
        if (this.actTypeAcountIds == null) {
            this.actTypeAcountIds = new HashMap<String, Map<String, Map<String, List<String>>>>();
            accountIds.add(chkAccountId);
            actTypeMap.put(asstActType, accountIds);
            balTypeMap.put(balTypeString, actTypeMap);
            this.actTypeAcountIds.put(companyId, balTypeMap);
        } else if (this.actTypeAcountIds.containsKey(companyId)) {
            balTypeMap = this.actTypeAcountIds.get(companyId);
            if (balTypeMap.containsKey(balTypeString)) {
                actTypeMap = balTypeMap.get(balTypeString);
                if (actTypeMap.containsKey(asstActType)) {
                    accountIds = actTypeMap.get(asstActType);
                    if (!accountIds.contains(chkAccountId)) {
                        accountIds.add(chkAccountId);
                    }
                } else if (!accountIds.contains(chkAccountId)) {
                    accountIds.add(chkAccountId);
                    actTypeMap.put(asstActType, accountIds);
                }
            } else if (!accountIds.contains(chkAccountId)) {
                accountIds.add(chkAccountId);
                actTypeMap.put(asstActType, accountIds);
                balTypeMap.put(balTypeString, actTypeMap);
                this.actTypeAcountIds.put(companyId, balTypeMap);
            }
        } else if (!accountIds.contains(chkAccountId)) {
            accountIds.add(chkAccountId);
            actTypeMap.put(asstActType, accountIds);
            balTypeMap.put(balTypeString, actTypeMap);
            this.actTypeAcountIds.put(companyId, balTypeMap);
        }
    }

    public void groupAccountNumberByActType(String companyId, int balType, String asstActType, String chkAccountNumber, Map<String, Map<String, List<String>>> balTypeMap, Map<String, List<String>> actTypeMap, List<String> accountNumbers) {
        accountNumbers = new ArrayList<String>();
        String balTypeString = this.getBalTypeString(balType);
        actTypeMap = new HashMap<String, List<String>>();
        balTypeMap = new HashMap<String, Map<String, List<String>>>();
        if (this.actTypeAcountNumbers == null) {
            this.actTypeAcountNumbers = new HashMap<String, Map<String, Map<String, List<String>>>>();
            accountNumbers.add(chkAccountNumber);
            actTypeMap.put(asstActType, accountNumbers);
            balTypeMap.put(balTypeString, actTypeMap);
            this.actTypeAcountNumbers.put(companyId, balTypeMap);
        } else if (this.actTypeAcountNumbers.containsKey(companyId)) {
            balTypeMap = this.actTypeAcountNumbers.get(companyId);
            if (balTypeMap.containsKey(balTypeString)) {
                actTypeMap = balTypeMap.get(balTypeString);
                if (actTypeMap.containsKey(asstActType)) {
                    accountNumbers = actTypeMap.get(asstActType);
                    if (!accountNumbers.contains(accountNumbers)) {
                        accountNumbers.add(chkAccountNumber);
                    }
                } else if (!accountNumbers.contains(chkAccountNumber)) {
                    accountNumbers.add(chkAccountNumber);
                    actTypeMap.put(asstActType, accountNumbers);
                }
            } else if (!accountNumbers.contains(chkAccountNumber)) {
                accountNumbers.add(chkAccountNumber);
                actTypeMap.put(asstActType, accountNumbers);
                balTypeMap.put(balTypeString, actTypeMap);
                this.actTypeAcountNumbers.put(companyId, balTypeMap);
            }
        } else if (!accountNumbers.contains(chkAccountNumber)) {
            accountNumbers.add(chkAccountNumber);
            actTypeMap.put(asstActType, accountNumbers);
            balTypeMap.put(balTypeString, actTypeMap);
            this.actTypeAcountNumbers.put(companyId, balTypeMap);
        }
    }

    public Map<String, Map<String, Map<String, List<String>>>> getAsstActTypeAccountIds() throws Exception {
        if (this.actTypeAcountIds == null && this.actTypeDetailAcountIds == null) {
            if (this.mappingId != null) {
                this.getCheckageAccountsByMapping();
            } else {
                this.getCheckageAccounts();
            }
            return this.actTypeAcountIds;
        }
        return this.actTypeAcountIds;
    }

    public Map<String, Map<String, Map<String, List<String>>>> getAsstActTypeAccountNumbers() throws Exception {
        if (this.actTypeAcountNumbers == null && this.actTypeDetailAcountIds == null) {
            if (this.mappingId != null) {
                this.getCheckageAccountsByMapping();
            } else {
                this.getCheckageAccounts();
            }
            return this.actTypeAcountNumbers;
        }
        return this.actTypeAcountNumbers;
    }

    public Map<String, Map<String, Map<String, List<String>>>> getAsstActTypeDetailAccountIds() throws Exception {
        if (this.actTypeDetailAcountIds == null && this.actTypeAcountIds == null) {
            if (this.mappingId != null) {
                this.getCheckageAccountsByMapping();
            } else {
                this.getCheckageAccounts();
            }
            return this.actTypeDetailAcountIds;
        }
        return this.actTypeDetailAcountIds;
    }

    public Map<String, Map<String, Map<String, List<String>>>> getAsstActTypeDetailAccountNumbers() throws Exception {
        if (this.actTypeDetailAcountNumbers == null && this.actTypeAcountIds == null) {
            if (this.mappingId != null) {
                this.getCheckageAccountsByMapping();
            } else {
                this.getCheckageAccounts();
            }
            return this.actTypeDetailAcountNumbers;
        }
        return this.actTypeDetailAcountNumbers;
    }

    public Map<String, Map<Integer, List<AccountViewInfo>>> getAccountByBalType() throws Exception {
        if (this.balTypeAccounts == null) {
            if (this.mappingId != null) {
                this.getCheckageAccountsByMapping();
            } else {
                this.getCheckageAccounts();
            }
            return this.balTypeAccounts;
        }
        return this.balTypeAccounts;
    }

    public String getAccountTempTable(List<String> accountIds) throws BOSException {
        String tableName = "T_CSL_CheckageAccount_Temp";
        this.service = this.getTempTblService(this.ctx, tableName, accountIds);
        this.accoutIdTempTable = this.service.getTmpTableName();
        return this.accoutIdTempTable;
    }

    private ParamTempTblService getTempTblService(Context ctx, String tableName, Collection params) {
        TableInfo table = new TableInfo(tableName);
        table.addColumn(new ColumnInfo("FAccountId", "varchar(44)"));
        ParamTempTblService service = ParamTempTblService.getInstance((Context)ctx, (TableInfo)table, (Collection)params, null);
        return service;
    }

    public void release() {
        if (this.service != null) {
            if (!DebugLogger.isDebug) {
                this.service.release();
            }
            this.accoutIdTempTable = null;
        }
    }
}

