/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app.querycheckagedata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryCheckageCompanys {
    private String userId = null;
    private Context ctx = null;
    private int year = 0;
    private int period = 0;
    private List<String> companys = null;
    private Map<String, Boolean> includeUnPosteds = null;
    private Map<String, String> companyNumbers = null;
    private Map<String, String> companyNames = null;

    public QueryCheckageCompanys(Context ctx, String userId, int year, int period) {
        this.ctx = ctx;
        this.userId = userId;
        this.year = year;
        this.period = period;
    }

    public QueryCheckageCompanys(Context ctx) {
        this.ctx = ctx;
    }

    public List<String> getCheckageCompanys() throws Exception {
        if (this.companys == null) {
            this.companys = new ArrayList<String>();
        }
        if (this.includeUnPosteds == null) {
            this.includeUnPosteds = new HashMap<String, Boolean>();
        }
        if (this.companyNumbers == null) {
            this.companyNumbers = new HashMap<String, String>();
        }
        if (this.companyNames == null) {
            this.companyNames = new HashMap<String, String>();
        }
        String lang = this.ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        sql.append("Select chkCompany.FCompanyId companyId,company.FNumber companyNumber, company.FName_" + lang + " companyName, chkCompany.FIsIncludingUnPosted isIncludingUnPosted \n");
        sql.append(" From T_CSL_CheckageCompany chkCompany \n");
        sql.append(" Inner join T_ORG_Company company On chkCompany.FCompanyId = company.Fid \n");
        sql.append(" Where (chkCompany.FIsfree = ? or (chkCompany.FIsfree = ? and chkCompany.FFreeTime > ?)) ");
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(0);
        params.add(1);
        params.add(this.getYearPeiord());
        IRowSet iRowSet = DbUtil.executeQuery(this.ctx, sql.toString(), params.toArray());
        while (iRowSet.next()) {
            String companyId = iRowSet.getString("companyId");
            boolean isIncludingUnPosted = iRowSet.getBoolean("isIncludingUnPosted");
            String companyNumber = iRowSet.getString("companyNumber");
            String companyName = iRowSet.getString("companyName");
            this.companys.add(companyId);
            this.includeUnPosteds.put(companyId, isIncludingUnPosted);
            this.companyNumbers.put(companyId, companyNumber);
            this.companyNames.put(companyId, companyName);
        }
        return this.companys;
    }

    private String getForbiddenOrgIdsSQL(Context ctx, String permItemID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT 1 FROM T_PM_UserOrgPerm USERORGPERM ").append(" WHERE UserOrgPerm.FOwner = ? AND UserOrgPerm.FPermItemID = '").append(permItemID).append("' AND UserOrgPerm.FPermType = ").append(20).append(" AND USERORGPERM.Forgid = chkCompany.FCompanyId ").append(" UNION ALL ").append(" SELECT 1 FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON RolePerm.FRoleID = UserRoleOrg.FRoleID ").append(" WHERE UserRoleOrg.FUserID = ? AND RolePerm.FPermItemID = '").append(permItemID).append("' AND RolePerm.FPermType = ").append(20).append(" AND UserRoleOrg.Forgid = chkCompany.FCompanyId ");
        return sql.toString();
    }

    private String getAuthorizedOrgIdsSQL(Context ctx, String permItemID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT 1 FROM T_PM_UserOrgPerm USERORGPERM ").append(" WHERE UserOrgPerm.FOwner = ? AND UserOrgPerm.FPermItemID = '").append(permItemID).append("' AND UserOrgPerm.FPermType = ").append(10).append(" AND USERORGPERM.Forgid = chkCompany.FCompanyId ").append(" UNION ALL ").append(" SELECT 1 FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON RolePerm.FRoleID = UserRoleOrg.FRoleID ").append(" WHERE UserRoleOrg.FUserID = ? AND RolePerm.FPermItemID = '").append(permItemID).append("' AND RolePerm.FPermType = ").append(10).append(" AND UserRoleOrg.Forgid = chkCompany.FCompanyId ");
        return sql.toString();
    }

    private int getYearPeiord() {
        return Integer.valueOf(RptUtil.getYearPeriod((int)this.year, (int)this.period, (int)this.year, (int)this.period));
    }

    public ParamTempTblService getCheckageCompanysTempTable(List<String> companyIds) throws Exception {
        if (companyIds == null) {
            companyIds = this.getCheckageCompanys();
        }
        ParamTempTblService service = this.getTempTblService(this.ctx, companyIds);
        return service;
    }

    public Map<String, Boolean> getIncludeUnPosteds() throws Exception {
        if (this.includeUnPosteds != null && !this.includeUnPosteds.isEmpty()) {
            return this.includeUnPosteds;
        }
        this.getCheckageCompanys();
        return this.includeUnPosteds;
    }

    public Map<String, String> getCompanyNumbers() throws Exception {
        if (this.companyNumbers != null && !this.companyNumbers.isEmpty()) {
            return this.companyNumbers;
        }
        this.getCheckageCompanys();
        return this.companyNumbers;
    }

    public Map<String, String> getCompanyNames() throws Exception {
        if (this.companyNames != null && !this.companyNames.isEmpty()) {
            return this.companyNames;
        }
        this.getCheckageCompanys();
        return this.companyNames;
    }

    private ParamTempTblService getTempTblService(Context ctx, Collection params) {
        TableInfo table = new TableInfo("t_csl_checkageCompany_temp");
        table.addColumn(new ColumnInfo("FCompanyId", "varchar(44)"));
        ParamTempTblService service = ParamTempTblService.getInstance((Context)ctx, (TableInfo)table, (Collection)params, null);
        return service;
    }
}

