/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.bi.util.DynaItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemDataCondition;
import com.kingdee.eas.fi.gr.cslrpt.RPTDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.DynaRptItemDataFacadeFactory;
import com.kingdee.eas.fi.newrpt.AnalysisReportInfo;
import com.kingdee.eas.fi.newrpt.app.AbstractAnalysisReportControllerBean;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisCellObject;
import com.kingdee.eas.fi.newrpt.report.ItemAnalysisConstant;
import com.kingdee.eas.fi.newrpt.util.RptLoggerUtils;
import com.kingdee.eas.fi.rpt.batch.IBatchSQLSortState;
import com.kingdee.eas.fi.rpt.batch.iref.AcctItemAsstTranslator;
import com.kingdee.eas.fi.rpt.batch.iref.AsstItemInfo;
import com.kingdee.eas.fi.rpt.batch.iref.IRefBatchSQLProcessor;
import com.kingdee.eas.fi.rpt.batch.iref.IRefSortState;
import com.kingdee.eas.fi.rpt.batch.iref.ITranslator;
import com.kingdee.eas.fi.rpt.batch.iref.IntegrateSchemeHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AnalysisReportControllerBean
extends AbstractAnalysisReportControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.app.AnalysisReportControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AnalysisReportInfo info = (AnalysisReportInfo)model;
        if (info.getId() == null) {
            info.setId(BOSUuid.create((BOSObjectType)this.getBOSType()));
        }
        return super._addnew(ctx, (IObjectValue)info);
    }

    @Override
    protected Map _getAnalysisDatas(Context ctx, Map paramsMap) throws BOSException, EASBizException {
        try {
            if (paramsMap != null && !paramsMap.isEmpty()) {
                List orgUnits;
                Map dataMap;
                boolean isDynamicAnalysis = (Boolean)paramsMap.get(ItemAnalysisConstant.isDynamicAnalysis);
                List selectSourceType = (List)paramsMap.get(ItemAnalysisConstant.sourceType);
                boolean isSumValueFromSumRpt = (Boolean)paramsMap.get(ItemAnalysisConstant.isSumValueFromSumRpt);
                boolean isGetSum = false;
                if (isSumValueFromSumRpt && !selectSourceType.contains(ItemAnalysisConstant.cslType)) {
                    isGetSum = true;
                }
                List<Integer> postionIndex = this.getArrayIndex(paramsMap, isDynamicAnalysis);
                HashSet<String> notLeafOrgs = new HashSet<String>();
                if (!isSumValueFromSumRpt) {
                    this.initNotLeafOrgs(notLeafOrgs, paramsMap);
                }
                ItemDataCondition conditions = new ItemDataCondition();
                HashMap<String, Integer> extConditions = new HashMap<String, Integer>();
                this.initCondition(conditions, extConditions, paramsMap, isDynamicAnalysis, isGetSum);
                this.initExtConditions(paramsMap, extConditions);
                HashMap<String, BigDecimal> analysisDatasMap = new HashMap<String, BigDecimal>();
                List result = !isDynamicAnalysis ? RPTDataServiceFactory.getLocalInstance((Context)ctx).getItemData(conditions, extConditions) : DynaRptItemDataFacadeFactory.getLocalInstance((Context)ctx).getDynamicItemData(conditions, extConditions);
                RptLoggerUtils.getInstance().printList(logger, result, "getItemData---------------");
                this.handleResult(result, analysisDatasMap, postionIndex, paramsMap, notLeafOrgs, ItemAnalysisConstant.cslType);
                RptLoggerUtils.getInstance().printMap(logger, analysisDatasMap, "getAnalysisDatasMap");
                if (isSumValueFromSumRpt && !isGetSum) {
                    this.initDataSource(conditions, paramsMap, isDynamicAnalysis, true);
                    dataMap = (Map)paramsMap.get(ItemAnalysisConstant.filterData);
                    orgUnits = (List)dataMap.get(ItemAnalysisConstant.orgUnitKey);
                    this.setOrgUnitCondition(orgUnits, conditions, true);
                    if (conditions.getOrgUnitNumber() != null && !conditions.getOrgUnitNumber().isEmpty()) {
                        result = !isDynamicAnalysis ? RPTDataServiceFactory.getLocalInstance((Context)ctx).getItemData(conditions, extConditions) : DynaRptItemDataFacadeFactory.getLocalInstance((Context)ctx).getDynamicItemData(conditions, extConditions);
                        RptLoggerUtils.getInstance().printList(logger, result, "getItemDataSum---------------");
                        this.handleResult(result, analysisDatasMap, postionIndex, paramsMap, notLeafOrgs, ItemAnalysisConstant.sumType);
                    }
                }
                if (selectSourceType.contains(ItemAnalysisConstant.elimType)) {
                    if (conditions.getOrgUnitNumber() != null && !conditions.getOrgUnitNumber().isEmpty()) {
                        extConditions.put("dataType", new Integer(isDynamicAnalysis ? 5 : 3));
                        result = !isDynamicAnalysis ? RPTDataServiceFactory.getLocalInstance((Context)ctx).getItemData(conditions, extConditions) : DynaRptItemDataFacadeFactory.getLocalInstance((Context)ctx).getDynamicItemData(conditions, extConditions);
                        this.handleResult(result, analysisDatasMap, postionIndex, paramsMap, notLeafOrgs, ItemAnalysisConstant.elimType);
                    }
                } else if (selectSourceType.contains(ItemAnalysisConstant.sumType)) {
                    extConditions.put("dataType", new Integer(4));
                    conditions.setDataSource(2);
                    dataMap = (Map)paramsMap.get(ItemAnalysisConstant.filterData);
                    orgUnits = (List)dataMap.get(ItemAnalysisConstant.orgUnitKey);
                    ArrayList<String> orgUnitNumberList = new ArrayList<String>();
                    for (ItemAnalysisCellObject orgUnit : orgUnits) {
                        if (!notLeafOrgs.contains(orgUnit.getKey()) || orgUnitNumberList.contains(orgUnit.getSourceKey())) continue;
                        orgUnitNumberList.add(orgUnit.getSourceKey());
                    }
                    conditions.setOrgUnitNumber(orgUnitNumberList);
                    if (conditions.getOrgUnitNumber() != null && !conditions.getOrgUnitNumber().isEmpty()) {
                        result = !isDynamicAnalysis ? RPTDataServiceFactory.getLocalInstance((Context)ctx).getItemData(conditions, extConditions) : DynaRptItemDataFacadeFactory.getLocalInstance((Context)ctx).getDynamicItemData(conditions, extConditions);
                        this.handleResult(result, analysisDatasMap, postionIndex, paramsMap, notLeafOrgs, ItemAnalysisConstant.sumType);
                    }
                }
                notLeafOrgs.clear();
                return analysisDatasMap;
            }
        }
        catch (Exception e) {
            logger.error((Object)"_getAnalysisDatas error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private void initNotLeafOrgs(Set<String> notLeafOrgs, Map paramsMap) {
        Map dataMap = (Map)paramsMap.get(ItemAnalysisConstant.filterData);
        List orgUnits = (List)dataMap.get(ItemAnalysisConstant.orgUnitKey);
        Map orgChild_ParentMap = (Map)paramsMap.get(ItemAnalysisConstant.orgRelationsKey);
        HashSet<String> paraentOrgKey = new HashSet<String>();
        for (String key : orgChild_ParentMap.values()) {
            paraentOrgKey.add(key);
        }
        if (orgUnits != null) {
            for (ItemAnalysisCellObject orgUnit : orgUnits) {
                if (!paraentOrgKey.contains(orgUnit.getKey())) continue;
                notLeafOrgs.add(orgUnit.getKey());
            }
        }
        paraentOrgKey.clear();
    }

    private void initExtConditions(Map paramsMap, HashMap extConditions) {
        List rowKeyList = (List)paramsMap.get(ItemAnalysisConstant.rowKeys);
        List colKeyList = (List)paramsMap.get(ItemAnalysisConstant.colKeys);
        List selectSourceType = (List)paramsMap.get(ItemAnalysisConstant.sourceType);
        extConditions.put("dataType", new Integer(2));
        if (rowKeyList.contains(ItemAnalysisConstant.AdjustType) || colKeyList.contains(ItemAnalysisConstant.AdjustType) || selectSourceType.contains(ItemAnalysisConstant.sumType) || selectSourceType.contains(ItemAnalysisConstant.cslType) && ((Boolean)paramsMap.get(ItemAnalysisConstant.isDynamicAnalysis)).booleanValue()) {
            extConditions.put("isPerspectiveAdjust", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResult(List dataList, Map<String, BigDecimal> resultMap, List<Integer> postionIndex, Map paramsMap, Set<String> notLeafOrgs, String sourceType) throws Exception {
        if (dataList != null) {
            HashMap<MapKey, BigDecimal> tempMap = new HashMap<MapKey, BigDecimal>();
            try {
                List sourceTypeList = (List)paramsMap.get(ItemAnalysisConstant.sourceType);
                boolean isSumByQuarter = (Boolean)paramsMap.get(ItemAnalysisConstant.sumByQuarterKey);
                boolean isOnlyDisplayQuarter = (Boolean)paramsMap.get(ItemAnalysisConstant.onlyDisplayQuarterKey);
                Map orgChild_ParentMap = (Map)paramsMap.get(ItemAnalysisConstant.orgRelationsKey);
                String orgGroupKey = (String)paramsMap.get(ItemAnalysisConstant.orgGroupKey);
                boolean isDynamicAnalysis = (Boolean)paramsMap.get(ItemAnalysisConstant.isDynamicAnalysis);
                String solutId = (String)paramsMap.get(ItemAnalysisConstant.schemeId);
                int dataElementIndex = isDynamicAnalysis ? 27 : 22;
                boolean isNotShowDataElement = postionIndex.indexOf(dataElementIndex) < 0;
                int dataElementKeyArrIndex = isNotShowDataElement ? postionIndex.size() : postionIndex.indexOf(dataElementIndex);
                int periodTypeKeyArrIndex = isNotShowDataElement ? postionIndex.size() + 1 : postionIndex.size();
                int sourceTypeKeyArrIndex = periodTypeKeyArrIndex + 1;
                int keyArrSize = sourceTypeKeyArrIndex + 1;
                keyArrSize = sourceTypeList.contains(ItemAnalysisConstant.sumType) ? keyArrSize + 1 : keyArrSize;
                this.putResultListToMap(dataList, tempMap, orgGroupKey, postionIndex, dataElementKeyArrIndex, periodTypeKeyArrIndex, sourceTypeKeyArrIndex, keyArrSize, sourceType, isDynamicAnalysis);
                this.handleQuarter(tempMap, postionIndex, dataElementKeyArrIndex, periodTypeKeyArrIndex, isDynamicAnalysis, isSumByQuarter);
                boolean isSumValueFromSumRpt = (Boolean)paramsMap.get(ItemAnalysisConstant.isSumValueFromSumRpt);
                if (!isSumValueFromSumRpt) {
                    this.handleSum(tempMap, postionIndex, orgChild_ParentMap, notLeafOrgs, sourceTypeList, sourceTypeKeyArrIndex, sourceType, isDynamicAnalysis, !StringUtils.isEmpty((String)solutId));
                }
                this.buildRusultMap(tempMap, resultMap, postionIndex, sourceTypeKeyArrIndex, periodTypeKeyArrIndex, isOnlyDisplayQuarter, isSumByQuarter);
            }
            finally {
                tempMap.clear();
                dataList.clear();
            }
        }
    }

    private void buildRusultMap(Map<MapKey, BigDecimal> handledDataMap, Map<String, BigDecimal> resultMap, List<Integer> postionIndex, int sourceTypeKeyArrIndex, int periodTypeKeyArrIndex, boolean isOnlyDisplayQuarter, boolean isSumByQuarter) {
        if (!handledDataMap.isEmpty()) {
            StringBuffer resultKey = new StringBuffer();
            int yearIndex = 8;
            yearIndex = postionIndex.indexOf(yearIndex);
            String[] keyArray = null;
            for (MapKey mapKey : handledDataMap.keySet()) {
                keyArray = mapKey.getKeys();
                if (isOnlyDisplayQuarter && !keyArray[periodTypeKeyArrIndex].equals("2") || yearIndex < 0 && isSumByQuarter && !keyArray[periodTypeKeyArrIndex].equals("2")) continue;
                resultKey.setLength(0);
                resultKey.append(ItemAnalysisConstant.splitStr);
                for (int i = 0; i < postionIndex.size(); ++i) {
                    resultKey.append(keyArray[i]);
                    if (keyArray[periodTypeKeyArrIndex].equals("2") && yearIndex == i) {
                        resultKey.append(ItemAnalysisConstant.quarterSplitStr);
                        continue;
                    }
                    resultKey.append(ItemAnalysisConstant.splitStr);
                }
                resultKey.append(keyArray[sourceTypeKeyArrIndex]);
                resultKey.append(ItemAnalysisConstant.splitStr);
                this.putMap(resultMap, resultKey.toString(), handledDataMap.get(mapKey));
            }
        }
    }

    private void handleSum(Map<MapKey, BigDecimal> dataMap, List<Integer> postionIndex, Map<String, String> orgChild_ParentMap, Set<String> notLeafOrgs, List<String> sourceTypeList, int sourceTypeKeyArrIndex, String sourceType, boolean isDynamicAnalysis, boolean isMangeMerger) throws Exception {
        if (!sourceType.equals(ItemAnalysisConstant.elimType) && sourceTypeList.contains(ItemAnalysisConstant.sumType) && dataMap.size() > 0) {
            int orgUnitIndex = isDynamicAnalysis ? 2 : 0;
            orgUnitIndex = postionIndex.indexOf(orgUnitIndex);
            int adjustTypeIndex = isDynamicAnalysis ? 28 : 24;
            adjustTypeIndex = postionIndex.indexOf(adjustTypeIndex);
            String orgUnitKey = null;
            String parentOrgUnitKey = null;
            String[] parentKeys = null;
            if (orgUnitIndex >= 0) {
                HashMap<MapKey, BigDecimal> curTmpMap = new HashMap<MapKey, BigDecimal>();
                String[] keys = null;
                boolean isUnion = false;
                for (MapKey mapKey : dataMap.keySet()) {
                    keys = mapKey.getKeys();
                    orgUnitKey = keys[orgUnitIndex];
                    isUnion = notLeafOrgs.contains(orgUnitKey);
                    if ((isUnion || !keys[sourceTypeKeyArrIndex].equals(ItemAnalysisConstant.cslType)) && (!isUnion || !keys[sourceTypeKeyArrIndex].equals(ItemAnalysisConstant.sumType) || !keys[keys.length - 1].equals("1")) || StringUtils.isEmpty((String)(parentOrgUnitKey = orgChild_ParentMap.get(orgUnitKey))) && !isUnion) continue;
                    parentKeys = (String[])keys.clone();
                    parentKeys[sourceTypeKeyArrIndex] = ItemAnalysisConstant.sumType;
                    String string = parentKeys[orgUnitIndex] = isUnion ? orgUnitKey : parentOrgUnitKey;
                    if (!isUnion && keys[keys.length - 1].equals("1") && adjustTypeIndex >= 0) {
                        parentKeys[adjustTypeIndex] = "0";
                    }
                    this.putMap(curTmpMap, new MapKey(parentKeys), dataMap.get(mapKey));
                    if (!isMangeMerger || isMangeMerger && notLeafOrgs.contains(parentKeys[orgUnitIndex])) {
                        this.handleParentOrgUnit(parentKeys, dataMap.get(mapKey), orgUnitIndex, orgChild_ParentMap, curTmpMap, adjustTypeIndex, isUnion);
                    }
                    if (!isUnion || adjustTypeIndex < 0) continue;
                    parentKeys = (String[])keys.clone();
                    parentKeys[sourceTypeKeyArrIndex] = ItemAnalysisConstant.sumType;
                    parentKeys[adjustTypeIndex] = "2";
                    this.putMap(curTmpMap, new MapKey(parentKeys), dataMap.get(mapKey));
                }
                if (!curTmpMap.isEmpty()) {
                    dataMap.putAll(curTmpMap);
                    curTmpMap.clear();
                }
            }
        }
    }

    private void handleParentOrgUnit(String[] curkeys, BigDecimal curValue, int orgUnitKeyIndex, Map<String, String> orgChild_ParentMap, Map<MapKey, BigDecimal> resultMap, int adjustTypeIndex, boolean isUnion) {
        String orgUnitKey = curkeys[orgUnitKeyIndex];
        String parentOrgUnitKey = orgChild_ParentMap.get(orgUnitKey);
        String[] parentKeys = null;
        if (!StringUtils.isEmpty((String)parentOrgUnitKey)) {
            parentKeys = (String[])curkeys.clone();
            parentKeys[orgUnitKeyIndex] = parentOrgUnitKey;
            if (isUnion && adjustTypeIndex >= 0) {
                String[] parentKeys2 = (String[])parentKeys.clone();
                parentKeys2[adjustTypeIndex] = "2";
                this.putMap(resultMap, new MapKey(parentKeys2), curValue);
                parentKeys2 = (String[])parentKeys.clone();
                parentKeys2[adjustTypeIndex] = "0";
                this.putMap(resultMap, new MapKey(parentKeys2), curValue);
            } else {
                this.putMap(resultMap, new MapKey(parentKeys), curValue);
            }
            this.handleParentOrgUnit(parentKeys, curValue, orgUnitKeyIndex, orgChild_ParentMap, resultMap, adjustTypeIndex, isUnion);
        }
    }

    private void handleQuarter(Map<MapKey, BigDecimal> dataMap, List<Integer> postionIndex, int dataElementKeyArrIndex, int periodTypeKeyArrIndex, boolean isDynamicAnalysis, boolean isSumByQuarter) throws Exception {
        if (isSumByQuarter) {
            int yearIndex = 8;
            int periodIndex = 9;
            yearIndex = postionIndex.indexOf(yearIndex);
            periodIndex = postionIndex.indexOf(periodIndex);
            int periodValue = 0;
            int quarterValue = 0;
            if (dataMap.size() > 0 && yearIndex >= 0) {
                String[] tmpKeys = null;
                boolean isAddQuarter = true;
                HashMap<MapKey, BigDecimal[]> periodEndMap = new HashMap<MapKey, BigDecimal[]>();
                HashMap quarterMap = new HashMap();
                boolean isHandlePeriodEnd = true;
                BigDecimal value = null;
                String[] keys = null;
                for (MapKey mapKey : dataMap.keySet()) {
                    keys = mapKey.getKeys();
                    periodValue = Integer.valueOf(keys[periodIndex].toString());
                    periodValue = periodValue == 13 ? 12 : periodValue;
                    isAddQuarter = false;
                    isHandlePeriodEnd = false;
                    if (1 == Integer.valueOf(keys[dataElementKeyArrIndex].toString()) || 5 == Integer.valueOf(keys[dataElementKeyArrIndex].toString())) {
                        if ((periodValue - 1) % 3 == 0) {
                            isAddQuarter = true;
                        }
                    } else if (3 == Integer.valueOf(keys[dataElementKeyArrIndex].toString()) || 4 == Integer.valueOf(keys[dataElementKeyArrIndex].toString())) {
                        if (periodValue == 12) {
                            isHandlePeriodEnd = true;
                        }
                        if (periodValue % 3 == 0) {
                            isAddQuarter = true;
                        }
                    } else {
                        isAddQuarter = true;
                    }
                    if (isAddQuarter || isHandlePeriodEnd) {
                        quarterValue = (periodValue - 1) / 3 + 1;
                        tmpKeys = (String[])keys.clone();
                        tmpKeys[periodTypeKeyArrIndex] = "2";
                        tmpKeys[periodIndex] = String.valueOf(quarterValue);
                        value = dataMap.get(mapKey);
                    }
                    if (isAddQuarter) {
                        this.putMap(quarterMap, new MapKey(tmpKeys), value);
                    }
                    if (!isHandlePeriodEnd) continue;
                    this.putPeriodEndMap(periodEndMap, new MapKey(tmpKeys), Integer.valueOf(keys[periodIndex].toString()), value);
                }
                if (!periodEndMap.isEmpty()) {
                    String[] key = null;
                    for (MapKey mapKey : periodEndMap.keySet()) {
                        key = mapKey.getKeys();
                        BigDecimal[] tmpValues = (BigDecimal[])periodEndMap.get(key);
                        value = tmpValues[1] != null && tmpValues[1].compareTo(BigDecimal.ZERO) != 0 ? tmpValues[1] : tmpValues[0];
                        this.putMap(quarterMap, mapKey, value);
                    }
                    periodEndMap.clear();
                }
                if (!quarterMap.isEmpty()) {
                    dataMap.putAll(quarterMap);
                    quarterMap.clear();
                }
            }
        }
    }

    private void putResultListToMap(List result, Map<MapKey, BigDecimal> analysisDatasMap, String orgGroupKey, List<Integer> postionIndex, int dataElementKeyArrIndex, int periodTypeKeyArrIndex, int sourceTypeKeyArrIndex, int keyArrSize, String sourceType, boolean isDynamicAnalysis) throws Exception {
        int debitIndex = isDynamicAnalysis ? 21 : 11;
        int creditIndex = isDynamicAnalysis ? 22 : 12;
        int orgUnitIndex = isDynamicAnalysis ? 2 : 0;
        int dataElementIndex = isDynamicAnalysis ? 27 : 22;
        int adjystTypeIndex = isDynamicAnalysis ? 28 : 24;
        int dataSourceIndex = isDynamicAnalysis ? 29 : 25;
        boolean isNotShowDataElement = postionIndex.indexOf(dataElementIndex) < 0;
        BigDecimal debit = null;
        BigDecimal credit = null;
        BigDecimal value = null;
        Object[] rowValues = null;
        String[] keys = null;
        MapKey mapKey = null;
        boolean isDisplayAdjust = postionIndex.indexOf(adjystTypeIndex) >= 0;
        String curSourceType = null;
        for (Object valueArray : result) {
            rowValues = (Object[])valueArray;
            if (!ItemAnalysisConstant.elimType.equals(sourceType) && !isDisplayAdjust && rowValues[adjystTypeIndex].toString().equals("2")) continue;
            keys = new String[keyArrSize];
            mapKey = new MapKey(keys);
            for (int i = 0; i < postionIndex.size(); ++i) {
                keys[i] = rowValues[postionIndex.get(i)].toString();
                if (orgUnitIndex != postionIndex.get(i) || StringUtils.isEmpty((String)orgGroupKey)) continue;
                keys[i] = keys[i] + ItemAnalysisConstant.splitStr + orgGroupKey;
            }
            if (isNotShowDataElement) {
                keys[dataElementKeyArrIndex] = rowValues[dataElementIndex].toString();
            }
            curSourceType = sourceType;
            if (rowValues.length > dataSourceIndex && ((Integer)rowValues[dataSourceIndex] == 2 || (Integer)rowValues[dataSourceIndex] == 11 || (Integer)rowValues[dataSourceIndex] == 32)) {
                curSourceType = ItemAnalysisConstant.sumType;
            } else if (ItemAnalysisConstant.sumType.equals(sourceType)) {
                rowValues[adjystTypeIndex] = 1;
            }
            keys[periodTypeKeyArrIndex] = "1";
            keys[sourceTypeKeyArrIndex] = curSourceType;
            if (keyArrSize > sourceTypeKeyArrIndex + 1) {
                keys[sourceTypeKeyArrIndex + 1] = rowValues[adjystTypeIndex].toString();
            }
            debit = (BigDecimal)rowValues[debitIndex];
            credit = (BigDecimal)rowValues[creditIndex];
            value = credit == null || credit.compareTo(BigDecimal.ZERO) == 0 && debit != null ? debit : credit;
            this.putMap(analysisDatasMap, mapKey, value);
        }
    }

    private void putPeriodEndMap(Map<MapKey, BigDecimal[]> periodEndMap, MapKey keys, int period, BigDecimal value) {
        BigDecimal[] tmpValues = periodEndMap.get(keys);
        if (tmpValues == null) {
            tmpValues = new BigDecimal[2];
        }
        if (value == null) {
            value = BigDecimal.ZERO;
        }
        if (tmpValues[period == 12 ? 0 : 1] == null) {
            tmpValues[period == 12 ? 0 : 1] = BigDecimal.ZERO;
        }
        tmpValues[period == 12 ? 0 : 1] = tmpValues[period == 12 ? 0 : 1].add(value);
        periodEndMap.put(keys, tmpValues);
    }

    private void putMap(Map analysisDatasMap, Object key, BigDecimal value) {
        BigDecimal tmpValue = (BigDecimal)analysisDatasMap.get(key);
        if (tmpValue == null) {
            tmpValue = BigDecimal.ZERO;
        }
        if (value == null) {
            value = BigDecimal.ZERO;
        }
        analysisDatasMap.put(key, value.add(tmpValue));
    }

    private List<Integer> getArrayIndex(Map paramsMap, boolean isDynamicAnalysis) {
        HashMap<String, Object> initMap = new HashMap<String, Object>();
        if (isDynamicAnalysis) {
            initMap.put(ItemAnalysisConstant.orgUnitKey, 2);
            initMap.put(ItemAnalysisConstant.itemKey, 11);
            initMap.put(ItemAnalysisConstant.dataElementKey, 27);
            initMap.put(ItemAnalysisConstant.periodKey, new Integer[]{8, 9});
            initMap.put(ItemAnalysisConstant.dyItemKey, 19);
            initMap.put(ItemAnalysisConstant.AdjustType, 28);
        } else {
            initMap.put(ItemAnalysisConstant.orgUnitKey, 0);
            initMap.put(ItemAnalysisConstant.itemKey, 2);
            initMap.put(ItemAnalysisConstant.dataElementKey, 22);
            initMap.put(ItemAnalysisConstant.periodKey, new Integer[]{8, 9});
            initMap.put(ItemAnalysisConstant.AdjustType, 24);
        }
        ArrayList<Integer> keyIndex = new ArrayList<Integer>();
        List rowKeyList = (List)paramsMap.get(ItemAnalysisConstant.rowKeys);
        List colKeyList = (List)paramsMap.get(ItemAnalysisConstant.colKeys);
        this.handleIndex(rowKeyList, keyIndex, initMap);
        this.handleIndex(colKeyList, keyIndex, initMap);
        initMap.clear();
        return keyIndex;
    }

    private void handleIndex(List keyList, List<Integer> keyIndex, Map key_indeMap) {
        for (Object key : keyList) {
            if (key_indeMap.get(key) instanceof Integer) {
                keyIndex.add((Integer)key_indeMap.get(key));
                continue;
            }
            Integer[] integerArray = (Integer[])key_indeMap.get(key);
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int i2 = integerArray[i];
                keyIndex.add(i2);
            }
        }
    }

    private void initDataSource(ItemDataCondition condition, Map paramsMap, boolean isDynamicAnalysis, boolean isGetSum) {
        String schemeId = (String)paramsMap.get(ItemAnalysisConstant.schemeId);
        if (!StringUtils.isEmpty((String)schemeId)) {
            condition.setDataSource(isDynamicAnalysis ? (isGetSum ? 32 : 35) : (isGetSum ? 31 : 34));
        } else {
            condition.setDataSource(isDynamicAnalysis ? (isGetSum ? 2 : 3) : (isGetSum ? 2 : 3));
        }
    }

    private void initCondition(ItemDataCondition condition, HashMap extConditions, Map paramsMap, boolean isDynamicAnalysis, boolean isGetSum) {
        condition.setForBiReport(true);
        condition.setForPerspective(true);
        List selectSourceType = (List)paramsMap.get(ItemAnalysisConstant.sourceType);
        if (selectSourceType != null) {
            ArrayList<ValueTypeEnum> dataType = new ArrayList<ValueTypeEnum>();
            dataType.add(ValueTypeEnum.MONEY);
            dataType.add(ValueTypeEnum.QUANTITY);
            extConditions.put("DATA_TYPE", dataType);
            String schemeId = (String)paramsMap.get(ItemAnalysisConstant.schemeId);
            if (!StringUtils.isEmpty((String)schemeId)) {
                condition.setFastMergeSoluId(schemeId);
            }
            condition.setIsAdjusted(true);
            this.initDataSource(condition, paramsMap, isDynamicAnalysis, isGetSum);
            Map dataMap = (Map)paramsMap.get(ItemAnalysisConstant.filterData);
            List items = (List)dataMap.get(ItemAnalysisConstant.itemKey);
            this.setItemCondition(items, condition);
            List orgUnits = (List)dataMap.get(ItemAnalysisConstant.orgUnitKey);
            this.setOrgUnitCondition(orgUnits, condition, false);
            String orgTreeNumber = (String)paramsMap.get(ItemAnalysisConstant.orgTreeNumber);
            if (isDynamicAnalysis) {
                List dyItems = (List)dataMap.get(ItemAnalysisConstant.dyItemKey);
                this.setDyitemKeyCondition(dyItems, extConditions);
                extConditions.put("ORG_TREE_NUMBER", orgTreeNumber);
            } else {
                condition.setOrgTreeNumber(orgTreeNumber);
            }
            List dataelements = (List)dataMap.get(ItemAnalysisConstant.dataElementKey);
            this.setDataElementCondition(dataelements, condition);
            this.setYearPeriodCondition(paramsMap, condition);
            String currencyId = (String)paramsMap.get(ItemAnalysisConstant.currency);
            condition.setTargetCurrency(currencyId);
            condition.setRptPeriodType(3);
            Boolean isIncluedUnReceivedData = (Boolean)paramsMap.get(ItemAnalysisConstant.incluedUnReceivedDataKey);
            if (!isIncluedUnReceivedData.booleanValue()) {
                condition.setCommitStatus(3);
            } else {
                condition.setIncludeUnAuditElim(true);
            }
        }
    }

    private void setDyitemKeyCondition(List<ItemAnalysisCellObject> dyItems, HashMap extConditions) {
        if (dyItems != null && !dyItems.isEmpty()) {
            ArrayList<String> dyItemKeys = new ArrayList<String>();
            for (ItemAnalysisCellObject dyItem : dyItems) {
                dyItemKeys.add(dyItem.getKey());
            }
            extConditions.put("keyName", dyItemKeys);
        }
    }

    private void setYearPeriodCondition(Map paramsMap, ItemDataCondition condition) {
        String[] start = ((String)paramsMap.get(ItemAnalysisConstant.startYearPeriodKey)).split(ItemAnalysisConstant.splitStr);
        String[] end = ((String)paramsMap.get(ItemAnalysisConstant.endYearPeriodKey)).split(ItemAnalysisConstant.splitStr);
        int startYear = Integer.valueOf(start[0]);
        int startPeriod = Integer.valueOf(start[1]);
        int endYear = Integer.valueOf(end[0]);
        int endPeriod = Integer.valueOf(end[1]);
        condition.setRptYearStart(startYear);
        condition.setRptYearEnd(endYear);
        condition.setRptPeriodStart(startPeriod);
        condition.setRptPeriodEnd(endPeriod);
    }

    private void setDataElementCondition(List<ItemAnalysisCellObject> dataelements, ItemDataCondition condition) {
        if (dataelements != null && !dataelements.isEmpty()) {
            ArrayList<String> dataElementList = new ArrayList<String>();
            for (ItemAnalysisCellObject dataElement : dataelements) {
                dataElementList.add(dataElement.getKey());
            }
            condition.setDataElement(dataElementList);
        }
    }

    private void setOrgUnitCondition(List<ItemAnalysisCellObject> orgUnits, ItemDataCondition condition, boolean isOnlyUnion) {
        if (orgUnits != null && !orgUnits.isEmpty()) {
            ArrayList<String> orgUnitNumberList = new ArrayList<String>();
            for (ItemAnalysisCellObject orgUnit : orgUnits) {
                if ((!isOnlyUnion || !orgUnit.isUnion()) && isOnlyUnion || orgUnitNumberList.contains(orgUnit.getSourceKey())) continue;
                orgUnitNumberList.add(orgUnit.getSourceKey());
            }
            condition.setOrgUnitNumber(orgUnitNumberList);
        }
    }

    private void setItemCondition(List<ItemAnalysisCellObject> items, ItemDataCondition condition) {
        if (items != null && !items.isEmpty()) {
            HashMap<String, Object> itemMap = new HashMap<String, Object>();
            for (ItemAnalysisCellObject item : items) {
                itemMap.put(item.getKey(), null);
            }
            condition.setItemList(itemMap);
        }
    }

    @Override
    protected List _getDyItemkey(Context ctx, Map params) throws BOSException, EASBizException {
        String orgTreeId = (String)params.get("orgTreeId");
        List orgUnits = (List)params.get("orgUnits");
        List items = (List)params.get("items");
        Integer startYear = (Integer)params.get("START_YEAR");
        Integer endYear = (Integer)params.get("END_YEAR");
        Integer startPeriod = (Integer)params.get("START_PERIOD");
        Integer endPeriod = (Integer)params.get("END_PERIOD");
        String schemeId = (String)params.get("SCHEME_ID");
        ArrayList<Object> sqlParams = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct entry.fkeynumber number,entry.fkeyname name from t_csl_dynaitemdataentry entry ");
        sql.append("inner join t_csl_dynaitemdata itemdata on  itemdata.fid=entry.fitemdataid ");
        if (!StringUtils.isEmpty((String)orgTreeId) && StringUtils.isEmpty((String)schemeId)) {
            sql.append("inner join t_csl_rptreceived received on  received.freportid=itemdata.freportid ");
            sql.append("where received.forgtreeid=? ");
            sqlParams.add(orgTreeId);
        } else {
            sql.append("where 1=1 ");
        }
        sql.append("and itemdata.fperiodtype=3 and itemdata.fdynatype=1 ");
        if (orgUnits != null && !orgUnits.isEmpty()) {
            sql.append("and itemdata.forgunitid in (");
            this.getInStr(sql, "id", sqlParams, orgUnits);
            sql.append(") ");
        }
        if (items != null && !items.isEmpty()) {
            sql.append("and entry.fitemid in (");
            this.getInStr(sql, "number", sqlParams, items);
            sql.append(") ");
        }
        if (!StringUtils.isEmpty((String)schemeId)) {
            sql.append("and itemdata.ffastmergesoluid=? ");
            sqlParams.add(schemeId);
        } else {
            sql.append("and itemdata.fcommitstatus=3 ");
        }
        if (startYear.equals(endYear)) {
            sql.append("and entry.fyear=? ");
            sqlParams.add(endYear);
            sql.append("and entry.fperiod>=? ");
            sqlParams.add(startPeriod);
            sql.append("and entry.fperiod<=? ");
            sqlParams.add(endPeriod);
        } else {
            sql.append("and (entry.fyear=? ");
            sqlParams.add(startYear);
            sql.append("and entry.fperiod>=? ");
            sqlParams.add(startPeriod);
            sql.append("or entry.fyear>?) ");
            sqlParams.add(startYear);
            sql.append("and (entry.fyear=? ");
            sqlParams.add(endYear);
            sql.append("and entry.fperiod<=? ");
            sqlParams.add(endPeriod);
            sql.append("or entry.fyear<?) ");
            sqlParams.add(endYear);
        }
        sql.append("order by entry.fkeynumber ");
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), sqlParams.toArray());
        ArrayList<DynaItemInfo> result = new ArrayList<DynaItemInfo>();
        if (rowSet != null) {
            try {
                DynaItemInfo info = null;
                while (rowSet.next()) {
                    info = new DynaItemInfo(rowSet.getString("name"), rowSet.getString("number"));
                    result.add(info);
                }
            }
            catch (SQLException e) {
                logger.error((Object)"_getDyItemkey error", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return result;
    }

    private void getInStr(StringBuffer sql, String keyField, List sqlParams, List srcObjs) {
        CoreBaseInfo info = null;
        for (Object obj : srcObjs) {
            info = (CoreBaseInfo)obj;
            sql.append("'").append(info.get(keyField)).append("',");
        }
        sql.deleteCharAt(sql.lastIndexOf(","));
    }

    @Override
    protected Map _getMidTabAnalysisDatas(Context ctx, Map paramsMap) throws BOSException, EASBizException {
        String[] companyNums = ((String)paramsMap.get("companyNum")).split(";");
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String num : companyNums) {
            try {
                int orgType = Integer.parseInt((String)paramsMap.get("orgType"));
                IRefBatchSQLProcessor process = new IRefBatchSQLProcessor(ctx);
                process.setSortState((IBatchSQLSortState)new IRefSortState(num, orgType));
                Map<String, DemensionMap2Field> fieldMap = DemensionMap2FieldFactory.getMapping(ctx, process);
                SQLBuilder sql = this.builderQuerySQL(ctx, paramsMap, num, fieldMap, process);
                IRowSet rs = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                this.wrappedResult(rs, paramsMap, result, fieldMap);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return result;
    }

    private void wrappedResult(IRowSet rs, Map paramsMap, Map<String, Object> result, Map<String, DemensionMap2Field> fieldMap) throws SQLException {
        List demensions = (List)paramsMap.get("demensionList");
        int valueType = Integer.parseInt((String)paramsMap.get("valueType"));
        boolean needRebuildHead = paramsMap.containsKey("needRebuildHead") ? (Boolean)paramsMap.get("needRebuildHead") : false;
        StringBuffer key = new StringBuffer();
        while (rs.next()) {
            key.setLength(0);
            for (Object obj : demensions) {
                key.append(ItemAnalysisConstant.splitStr);
                if (ItemAnalysisConstant.periodKey.equals(obj.toString())) {
                    key.append(this.getStringVal(rs, obj, true, fieldMap));
                } else {
                    key.append(this.getStringVal(rs, obj, false, fieldMap));
                }
                if (!needRebuildHead) continue;
                this.collectDemensionDatas(rs, obj, result, fieldMap);
            }
            key.append(ItemAnalysisConstant.splitStr);
            result.put(key.toString(), 3 == valueType ? rs.getString("FValue") : rs.getBigDecimal("FValue"));
        }
    }

    private void collectDemensionDatas(IRowSet rs, Object demension, Map<String, Object> result, Map<String, DemensionMap2Field> fieldMap) throws SQLException {
        if ("account".equals(demension.toString()) || demension.toString().startsWith("asstType")) {
            if (!result.containsKey(demension)) {
                ArrayList<ItemAnalysisCellObject> demensionItems = new ArrayList<ItemAnalysisCellObject>();
                demensionItems.add(new ItemAnalysisCellObject(this.getStringVal(rs, demension, false, fieldMap), this.getStringVal(rs, demension, false, fieldMap)));
                result.put(demension.toString(), demensionItems);
            } else {
                String key2 = this.getStringVal(rs, demension, false, fieldMap);
                boolean hasItem = false;
                for (ItemAnalysisCellObject item : (List)result.get(demension)) {
                    if (!item.getKey().equals(key2)) continue;
                    hasItem = true;
                    break;
                }
                if (!hasItem) {
                    ((List)result.get(demension)).add(new ItemAnalysisCellObject(this.getStringVal(rs, demension, false, fieldMap), this.getStringVal(rs, demension, false, fieldMap)));
                }
            }
        }
    }

    private String getStringVal(IRowSet rs, Object demension, boolean isDate, Map<String, DemensionMap2Field> fieldMap) throws SQLException {
        if (isDate) {
            return RPTDateUtil.formateDate((java.util.Date)rs.getDate(fieldMap.get((String)demension).getFieldAlias()), (String)"yyyy-MM-dd");
        }
        return rs.getString(fieldMap.get((String)demension).getFieldAlias());
    }

    private SQLBuilder builderQuerySQL(Context ctx, Map paramsMap, String companyNum, Map<String, DemensionMap2Field> fieldMap, IRefBatchSQLProcessor process) throws Exception {
        SQLBuilder sql = new SQLBuilder(500);
        this.builderSelectPart(sql, paramsMap, process, fieldMap);
        this.builderFromPart(ctx, sql, paramsMap, companyNum, process);
        this.builderFilterPart(ctx, sql, paramsMap, companyNum, process);
        this.builderGroupPart(sql, paramsMap, fieldMap);
        return sql;
    }

    private void builderSelectPart(SQLBuilder sql, Map paramsMap, IRefBatchSQLProcessor process, Map<String, DemensionMap2Field> fieldMap) {
        int valueType = Integer.parseInt((String)paramsMap.get("valueType"));
        sql.append(" Select ").append(3 == valueType ? process.getFiled(IntegrateSchemeHelper.Fields.ftxtvalue.name()) + "FValue ,\n" : "sum(" + process.getFiled(IntegrateSchemeHelper.Fields.famount.name()) + ") FValue ,\n");
        this.builderDemensionPart(sql, paramsMap, true, fieldMap);
    }

    private void builderFromPart(Context ctx, SQLBuilder sql, Map paramsMap, String companyNum, IRefBatchSQLProcessor process) throws Exception {
        int orgType = Integer.parseInt((String)paramsMap.get("orgType"));
        String midTableName = IntegrateSchemeHelper.getInstance().getTableName(ctx, companyNum, OrgType.getEnum((int)orgType));
        sql.append(" FROM ").append(midTableName).append(" data \n").append(" JOIN T_BD_Currency currency ON " + process.getFiled(IntegrateSchemeHelper.Fields.fcurrencynum.name()) + " = currency.Fid \n").append(" JOIN T_CSL_DataElement de ON de.FInterSeq = " + process.getFiled(IntegrateSchemeHelper.Fields.fdataelement.name()) + " \n").append(" JOIN T_ORG_BASEUNIT unit ON unit.Fid = " + process.getFiled(IntegrateSchemeHelper.Fields.fcompanynum.name()) + " \n").append(" JOIN T_BD_AccountView acct ON acct.Fid = " + process.getFiled(IntegrateSchemeHelper.Fields.faccountnum.name()) + " \n");
        String asstType = (String)paramsMap.get("asstType");
        String asstItems = (String)paramsMap.get("asstItems");
        AcctItemAsstTranslator translator = new AcctItemAsstTranslator(ctx);
        translator.translate(asstType, asstItems);
        int index = 1;
        while (translator.hasNext()) {
            AsstItemInfo info = (AsstItemInfo)translator.next();
            String tabAlias = " asstType" + index;
            sql.append(" JOIN ").append(info.getAsstType().getRealtionDataObject());
            sql.append(tabAlias).append(" ON ").append(tabAlias).append(".fnumber = ");
            sql.append(process.getFiled("fasst" + index + "_number"));
            sql.append(" \n");
            ++index;
        }
    }

    private void builderFilterPart(Context ctx, SQLBuilder sql, Map paramsMap, String companyNum, IRefBatchSQLProcessor process) throws Exception {
        Date startDate = new Date(RPTDateUtil.stringToDate((String)((String)paramsMap.get("startDate")), (String)"yyyy-MM-dd").getTime());
        Date endDate = new Date(RPTDateUtil.stringToDate((String)((String)paramsMap.get("endDate")), (String)"yyyy-MM-dd").getTime());
        String currencyNum = (String)paramsMap.get("currencyNum");
        String dataElement = (String)paramsMap.get("dataElement");
        int valueType = Integer.parseInt((String)paramsMap.get("valueType"));
        String account = (String)paramsMap.get("account");
        String asstType = (String)paramsMap.get("asstType");
        String asstItems = (String)paramsMap.get("asstItems");
        int orgType = Integer.parseInt((String)paramsMap.get("orgType"));
        AcctItemAsstTranslator translator = new AcctItemAsstTranslator(ctx);
        translator.translate(asstType, asstItems);
        sql.append(" WHERE unit.FNumber = ? \n", companyNum).append(" AND currency.FNumber = ? \n", currencyNum).append(" AND de.FNumber = ? \n", dataElement).append(" AND ").append(process.getFiled(IntegrateSchemeHelper.Fields.fvaluetype.name())).append(" = ? \n", valueType).append(" AND ").append(process.getFiled(IntegrateSchemeHelper.Fields.forgtype.name())).append(" = ? \n", orgType).append(" AND ").append(process.getFiled(IntegrateSchemeHelper.Fields.fbizdate.name())).append(" >= ?", startDate).append(" AND ").append(process.getFiled(IntegrateSchemeHelper.Fields.fbizdate.name())).append(" <= ?", endDate);
        process.buildAsstFilter(sql, (ITranslator)translator);
        this.filterAccountView(ctx, sql, account, process);
    }

    private void builderGroupPart(SQLBuilder sql, Map paramsMap, Map<String, DemensionMap2Field> fieldMap) {
        int valueType = Integer.parseInt((String)paramsMap.get("valueType"));
        if (3 != valueType) {
            sql.append(" GROUP BY ");
            this.builderDemensionPart(sql, paramsMap, false, fieldMap);
        }
    }

    private void builderDemensionPart(SQLBuilder sql, Map paramsMap, boolean neetFieldAlias, Map<String, DemensionMap2Field> fieldMap) {
        List demensions = (List)paramsMap.get("demensionList");
        boolean hasMoreOne = false;
        for (Object obj : demensions) {
            if (hasMoreOne) {
                sql.append(",");
            }
            sql.append(fieldMap.get((String)obj).getField(neetFieldAlias));
            hasMoreOne = true;
        }
    }

    private void filterAccountView(Context ctx, SQLBuilder sql, String acctSerial, IRefBatchSQLProcessor process) throws BOSException {
        if (!StringUtils.isEmpty((String)acctSerial)) {
            if (acctSerial.indexOf(":") != -1) {
                String[] split = acctSerial.split(":");
                String acctFrom = split[0];
                String acctTo = split[1];
                sql.append(" and (acct.fnumber ").append(" >= ? \n", acctFrom);
                sql.append(" and acct.fnumber ").append(" <= ?) \n", acctTo);
            } else {
                String acctFrom = acctSerial;
                sql.append(" and acct.fnumber ").append(" = ? \n", acctFrom);
            }
        }
    }

    static class DemensionMap2FieldFactory {
        DemensionMap2FieldFactory() {
        }

        protected static Map<String, DemensionMap2Field> getMapping(Context ctx, IRefBatchSQLProcessor process) {
            HashMap<String, DemensionMap2Field> fieldMap = new HashMap<String, DemensionMap2Field>();
            fieldMap.put(ItemAnalysisConstant.periodKey, new DemensionMap2Field(process.getFiled(IntegrateSchemeHelper.Fields.fbizdate.name()), "bizDate"));
            fieldMap.put(ItemAnalysisConstant.orgUnitKey, new DemensionMap2Field("unit.FNumber", "cmpNum"));
            fieldMap.put(ItemAnalysisConstant.dataElementKey, new DemensionMap2Field("de.FNumber", "deNum"));
            String lan = ctx.getLocale().getLanguage();
            fieldMap.put("account", new DemensionMap2Field("acct.Fname_" + lan + "", "acctNum"));
            for (int i = 1; i <= 8; ++i) {
                fieldMap.put("asstType" + i, new DemensionMap2Field("asstType" + i + ".FName_" + lan + "", "FAsst" + i));
            }
            return fieldMap;
        }
    }

    static class DemensionMap2Field {
        String fieldName;
        String fieldAlias;

        DemensionMap2Field(String fieldName, String fieldAlias) {
            this.fieldName = fieldName;
            this.fieldAlias = fieldAlias;
        }

        String getField(boolean needAlias) {
            return this.fieldName + (needAlias ? " as " + this.fieldAlias : "");
        }

        String getFieldAlias() {
            return this.fieldAlias;
        }
    }

    private class MapKey {
        String[] keys = null;

        public MapKey(String[] keys) {
            this.keys = keys;
        }

        public String[] getKeys() {
            return this.keys;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.keys != null) {
                for (String key : this.keys) {
                    sb.append(key).append(",");
                }
            }
            return sb.toString();
        }

        public boolean equals(Object anObject) {
            if (anObject != null && anObject instanceof MapKey) {
                return ((MapKey)anObject).toString().equals(this.toString());
            }
            return false;
        }
    }
}

