/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.newrpt.CslGradeManageSettingFactory;
import com.kingdee.eas.fi.newrpt.CslGradeManageSettingInfo;
import com.kingdee.eas.fi.newrpt.app.AbstractCslGradeManageSettingControllerBean;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class CslGradeManageSettingControllerBean
extends AbstractCslGradeManageSettingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.app.CslGradeManageSettingControllerBean");

    @Override
    protected void _batchDeleteAndCopy(Context ctx, CoreBaseCollection cslGradeManageSettingColls, CoreBaseCollection fullOrgUnitColls) throws BOSException, EASBizException {
        this.deletCslGradeManageSettingByCreateOrgIDs(ctx, cslGradeManageSettingColls, fullOrgUnitColls);
        String inertSql = "insert into T_Csl_GradeManageSetting(FIsUpVisible,FIsSubVisible,FIsAllVisible,FCslMaterialID,FCreateOrgID,FID,FOrderNum) values(?,?,?,?,?,?,?)";
        PreparedStatement ps = null;
        Connection cn = super.getConnection(ctx);
        try {
            ps = cn.prepareStatement(inertSql);
            for (int i = 0; i < fullOrgUnitColls.size(); ++i) {
                String createOrgInfoID = fullOrgUnitColls.get(i).getId().toString();
                for (int j = 0; j < cslGradeManageSettingColls.size(); ++j) {
                    CslGradeManageSettingInfo cslGradeManageSettingInfo = (CslGradeManageSettingInfo)cslGradeManageSettingColls.get(j);
                    ps.setBoolean(1, cslGradeManageSettingInfo.isIsUpVisible());
                    ps.setBoolean(2, cslGradeManageSettingInfo.isIsSubVisible());
                    ps.setBoolean(3, cslGradeManageSettingInfo.isIsAllVisible());
                    ps.setString(4, cslGradeManageSettingInfo.getCslMaterial().getId().toString());
                    ps.setString(5, createOrgInfoID);
                    ps.setString(6, BOSUuid.create((String)"52A12851").toString());
                    ps.setInt(7, cslGradeManageSettingInfo.getOrderNum());
                    ps.addBatch();
                }
                if (i % 100 != 0) continue;
                ps.executeBatch();
                ps.clearBatch();
            }
            ps.executeBatch();
            ps.clearBatch();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup(null, (Statement)ps, (Connection)cn);
        }
    }

    private void deletCslGradeManageSettingByCreateOrgIDs(Context ctx, CoreBaseCollection cslGradeManageSettingColls, CoreBaseCollection fullOrgUnitColls) throws BOSException, EASBizException {
        FilterInfo filter = this.buildDeleteFilter(cslGradeManageSettingColls, fullOrgUnitColls);
        CslGradeManageSettingFactory.getLocalInstance(ctx).delete(filter);
    }

    private FilterInfo buildDeleteFilter(CoreBaseCollection cslGradeManageSettingColls, CoreBaseCollection fullOrgUnitColls) {
        HashSet<String> createOrgIDs = new HashSet<String>();
        for (int i = 0; i < fullOrgUnitColls.size(); ++i) {
            createOrgIDs.add(fullOrgUnitColls.get(i).getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("createOrg.id", createOrgIDs, CompareType.INCLUDE));
        return filter;
    }

    @Override
    protected void _updateMaintainOrg(Context ctx, Map paramMap) throws BOSException, EASBizException {
        if (!this.isPassedcheckParam(paramMap)) {
            return;
        }
        ParamTempTblService srv = this.buildTempTblForID(ctx, paramMap);
        StringBuffer sql = this.buildSqlForUpdateMaintainOrg(paramMap, srv);
        DbUtil.execute(ctx, sql.toString(), new Object[]{paramMap.get("orgID")});
        srv.release();
    }

    private StringBuffer buildSqlForUpdateMaintainOrg(Map paramMap, ParamTempTblService srv) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update");
        sql.append(" " + paramMap.get("tableName").toString());
        sql.append(" set " + paramMap.get("orgColName").toString() + " = ?");
        sql.append(" where fid in (" + srv.getParamsSql() + ")");
        return sql;
    }

    private ParamTempTblService buildTempTblForID(Context ctx, Map paramMap) {
        TableInfo table = new TableInfo("T_TMPL_GRADE");
        table.addColumn("ID");
        HashSet<String> ids = new HashSet<String>();
        ArrayList list = (ArrayList)paramMap.get("selectedIDList");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            ids.add(list.get(i).toString());
        }
        ParamTempTblService srv = new ParamTempTblService(ctx, table, ids, null);
        return srv;
    }

    private boolean isPassedcheckParam(Map paramMap) {
        if (!paramMap.containsKey("tableName")) {
            return false;
        }
        if (!paramMap.containsKey("selectedIDList")) {
            return false;
        }
        if (!paramMap.containsKey("orgID")) {
            return false;
        }
        return paramMap.containsKey("orgColName");
    }
}

