/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.CommonFilterUtil;
import com.kingdee.eas.base.commonquery.app.CommonQueryUtil;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.RuleUtil;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.base.permission.app.config.ConfigurationLoader;
import com.kingdee.eas.base.permission.app.config.PermissionFilterConfiguration;
import com.kingdee.eas.base.permission.app.discrete.DiscretePermissionDAO;
import com.kingdee.eas.base.permission.app.service.DataPermissionService;
import com.kingdee.eas.base.permission.app.util.DebugHelper;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.log4j.Logger;

public class CslRptDataPermissionService
extends DataPermissionService {
    private static Logger logger = Logger.getLogger(CslRptDataPermissionService.class);
    private Context context = null;
    DataPermissionService service = null;

    public CslRptDataPermissionService(Context context) {
        super(context);
        this.context = context;
        this.service = new DataPermissionService(context);
    }

    public String getPermissionRule(IObjectPK userPK, IObjectPK orgPK, String permItemName) throws BOSException, EASBizException {
        assert (userPK != null && permItemName != null);
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache((Context)this.context).getPermItem(this.context, permItemName);
        if (StringUtils.isEmpty((String)permItemInfo.getObjectType()) || !permItemInfo.isEnableDataPermission()) {
            return " WHERE ( id = '00000000-0000-0000-0000-00000000000013B7DE7F' OR id <> '00000000-0000-0000-0000-00000000000013B7DE7F' )";
        }
        IObjectPK permissionOrgPK = PermissionUtil.getPermissionOrgPK((Context)this.context, (OrgType)permItemInfo.getOrgRelation(), (IObjectPK)orgPK, null);
        if (permissionOrgPK == null) {
            DebugHelper.debugNoFunctionPermission((Context)this.context, (IObjectPK)userPK, (IObjectPK)orgPK, (String)permItemName);
            return this.getNoRightRuleInfo(permItemName);
        }
        try {
            String rule = this.getRule(userPK, permissionOrgPK, permItemInfo);
            return rule;
        }
        catch (ParserException e) {
            logger.error((Object)e);
            throw new PermissionException(PermissionException.CHECK_PERMISSION_FAIL, (Throwable)e);
        }
    }

    private String getRule(IObjectPK userPK, IObjectPK orgPK, PermItemInfo permItemInfo) throws EASBizException, ParserException, BOSException {
        String rule;
        String commonRule = this.getDataRule(userPK, orgPK, permItemInfo);
        String specialRule = this.getSpecialDataPermRule(userPK, orgPK, permItemInfo);
        String bizPermitemlogic = null;
        if (!StringUtils.isEmpty((String)specialRule)) {
            bizPermitemlogic = this.getItemLogicPriority(orgPK, permItemInfo);
        }
        if ((rule = this.mergeCommonAndSpecialRule(commonRule, specialRule, bizPermitemlogic)) == null) {
            return rule;
        }
        EntityViewInfo oldViewInfo = new EntityViewInfo(rule);
        EntityViewInfo coopFieldViewInfo = new EntityViewInfo();
        coopFieldViewInfo.setFilter(this.getCoopFieldRule(orgPK, permItemInfo));
        EntityViewInfo resViewInfo = RuleUtil.mergeEntityViewInfo((EntityViewInfo)oldViewInfo, (EntityViewInfo)coopFieldViewInfo, (String)"OR");
        if (resViewInfo != null) {
            return resViewInfo.toString();
        }
        return null;
    }

    private String getDataRule(IObjectPK userPK, IObjectPK orgPK, PermItemInfo permItemInfo) throws EASBizException, ParserException, BOSException {
        String commonDataRule = this.getCommonDataRule(userPK, orgPK, permItemInfo);
        if (CommonFilterUtil.isLikeVarEnumValue((String)commonDataRule)) {
            commonDataRule = CommonQueryUtil.getInnerFilterInfo((Context)this.context, (String)commonDataRule);
        }
        String discreteDataRule = this.getDiscreteDataRule(userPK, orgPK, permItemInfo);
        return RuleUtil.mergeOQL((String)commonDataRule, (String)discreteDataRule, (String)"OR");
    }

    private String getDiscreteDataRule(IObjectPK userPK, IObjectPK orgPK, PermItemInfo permItemInfo) throws EASBizException, BOSException {
        if (this.isDiscretePermItem(permItemInfo)) {
            String discretePermissionRule = this.getDiscretePermissionRule(userPK, orgPK, permItemInfo.getName());
            return discretePermissionRule;
        }
        return null;
    }

    private String getCommonDataRule(IObjectPK userPK, IObjectPK orgPK, PermItemInfo permItemInfo) throws EASBizException, ParserException, BOSException {
        try {
            Method method = this.service.getClass().getDeclaredMethod("getCommonDataRule", IObjectPK.class, IObjectPK.class, PermItemInfo.class);
            NewRptUtil.makeAccessible(method);
            return (String)method.invoke((Object)this.service, userPK, orgPK, permItemInfo);
        }
        catch (Exception e) {
            logger.error((Object)"getCommonDataRule error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private boolean isDiscretePermItem(PermItemInfo permItemInfo) {
        Set permItems = (Set)ConfigurationLoader.getInstance().getConfigurationInfo().getDiscretEntityPermItems().get(permItemInfo.getObjectType());
        if (permItems == null) {
            return false;
        }
        return permItems.contains(permItemInfo.getName());
    }

    private String getNoRightRuleInfo(String strKey) {
        return PermissionFilterConfiguration.getList().getFilterString(strKey);
    }

    public String getDiscretePermissionRule(IObjectPK userPK, IObjectPK orgPK, String permItemName) throws BOSException, EASBizException {
        PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache((Context)this.context).getPermItem(this.context, permItemName);
        DiscretePermissionDAO dao = new DiscretePermissionDAO(this.context);
        String sql = dao.getDiscretePermissionSQL(BOSObjectType.create((String)permItemInfo.getObjectType()), userPK, orgPK, (IObjectPK)new ObjectUuidPK(permItemInfo.getId()));
        StringBuffer rule = new StringBuffer(100);
        if (!StringUtils.isEmpty((String)sql)) {
            return rule.append("WHERE creator.id = '").append(userPK.toString()).append("' OR id IN (").append(sql).append(") ").toString();
        }
        return null;
    }

    private String getSpecialDataPermRule(IObjectPK userPK, IObjectPK orgPK, PermItemInfo permItemInfo) throws EASBizException, BOSException {
        try {
            Method method = this.service.getClass().getDeclaredMethod("getSpecialDataPermRule", IObjectPK.class, IObjectPK.class, PermItemInfo.class);
            NewRptUtil.makeAccessible(method);
            return (String)method.invoke((Object)this.service, userPK, orgPK, permItemInfo);
        }
        catch (Exception e) {
            logger.error((Object)"getCommonDataRule error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private String getItemLogicPriority(IObjectPK orgPK, PermItemInfo permItemInfo) throws EASBizException, BOSException {
        try {
            Method method = this.service.getClass().getDeclaredMethod("getItemLogicPriority", IObjectPK.class, PermItemInfo.class);
            NewRptUtil.makeAccessible(method);
            return (String)method.invoke((Object)this.service, orgPK, permItemInfo);
        }
        catch (Exception e) {
            logger.error((Object)"getCommonDataRule error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private String mergeCommonAndSpecialRule(String commonRule, String specialRule, String bizPermitemlogic) throws ParserException, BOSException, EASBizException {
        try {
            Method method = this.service.getClass().getDeclaredMethod("mergeCommonAndSpecialRule", String.class, String.class, String.class);
            NewRptUtil.makeAccessible(method);
            return (String)method.invoke((Object)this.service, commonRule, specialRule, bizPermitemlogic);
        }
        catch (Exception e) {
            logger.error((Object)"getCommonDataRule error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private FilterInfo getCoopFieldRule(IObjectPK orgPK, PermItemInfo permItemInfo) throws EASBizException, BOSException {
        try {
            Method method = this.service.getClass().getDeclaredMethod("getCoopFieldRule", IObjectPK.class, PermItemInfo.class);
            NewRptUtil.makeAccessible(method);
            return (FilterInfo)method.invoke((Object)this.service, orgPK, permItemInfo);
        }
        catch (Exception e) {
            logger.error((Object)"getCommonDataRule error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }
}

