/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.sql.shell.KDPreparedStatement;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.newrpt.dbcenter.DBCenterInfo;
import com.kingdee.eas.fi.newrpt.dbcenter.pool.DBPoolManager;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.PsSql;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DbUtil {
    private static final Logger logger = Logger.getLogger(DbUtil.class);
    private static Map<String, Boolean> isCreateLogTableMap = new HashMap<String, Boolean>();
    private static String sqlLogTableName = "T_CSL_SQLLOG";

    public static IRowSet executeQueryNoTx(Context ctx, String sql) throws BOSException {
        long time = System.currentTimeMillis();
        IRowSet rowSet = com.kingdee.eas.util.app.DbUtil.executeQueryNoTx((Context)ctx, (String)sql);
        if (DebugLogger.isDebug) {
            DbUtil.writeSqlLog(ctx, sql, null, System.currentTimeMillis() - time);
        }
        return rowSet;
    }

    public static IRowSet executeQueryNoTx(Context ctx, String sql, Object[] params) throws BOSException {
        long time = System.currentTimeMillis();
        IRowSet rowSet = com.kingdee.eas.util.app.DbUtil.executeQueryNoTx((Context)ctx, (String)sql, (Object[])params);
        if (DebugLogger.isDebug) {
            DbUtil.writeSqlLog(ctx, sql, null, System.currentTimeMillis() - time);
        }
        return rowSet;
    }

    public static IRowSet executeQuery(Context ctx, String sql) throws BOSException {
        long time = System.currentTimeMillis();
        IRowSet rowSet = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql);
        if (DebugLogger.isDebug) {
            DbUtil.writeSqlLog(ctx, sql, null, System.currentTimeMillis() - time);
        }
        return rowSet;
    }

    public static int executeUpdate(Context ctx, String sql, Object[] params) throws BOSException {
        long time = System.currentTimeMillis();
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("executeUpdate error.", (Throwable)exc);
        }
        try {
            int i;
            ps = conn.prepareStatement(sql);
            for (i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            i = ps.executeUpdate();
            return i;
        }
        catch (SQLException exc) {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < params.length; ++i) {
                sb.append("param ").append(i).append(" is:").append(params[i]);
            }
            logger.error((Object)("222 sql is:" + sql + " param is:" + sb.toString()), (Throwable)exc);
            throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)conn);
            if (DebugLogger.isDebug) {
                DbUtil.writeSqlLog(ctx, sql, params, System.currentTimeMillis() - time);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRowSet executeQuery(Context ctx, DBCenterInfo dbCenter, String sql) {
        long time = System.currentTimeMillis();
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        JdbcRowSet rowset = null;
        try {
            conn = DBPoolManager.getConnection(dbCenter);
            statement = conn.createStatement();
            rs = statement.executeQuery(sql);
            rowset = new JdbcRowSet();
            rowset.populate(rs);
        }
        catch (Exception exc) {
            try {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        if (DebugLogger.isDebug) {
            DbUtil.writeSqlLog(ctx, sql, null, System.currentTimeMillis() - time);
        }
        return rowset;
    }

    public static IRowSet executeQuery(Context ctx, String sql, int start, int rows) throws BOSException {
        long time = System.currentTimeMillis();
        IRowSet rowSet = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (int)start, (int)rows);
        if (DebugLogger.isDebug) {
            DbUtil.writeSqlLog(ctx, sql, null, System.currentTimeMillis() - time);
        }
        return rowSet;
    }

    public static IRowSet executeQuery(Context ctx, String sql, Object[] params) throws BOSException {
        long time = System.currentTimeMillis();
        IRowSet rowSet = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        if (DebugLogger.isDebug) {
            DbUtil.writeSqlLog(ctx, sql, params, System.currentTimeMillis() - time);
        }
        return rowSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRowSet executeQuery(Context ctx, DBCenterInfo dbCenter, String sql, Object[] params) {
        long time = System.currentTimeMillis();
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        JdbcRowSet rowset = null;
        try {
            conn = DBPoolManager.getConnection(dbCenter);
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            rowset = new JdbcRowSet();
            rowset.populate(rs);
        }
        catch (Exception exc) {
            try {
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        if (DebugLogger.isDebug) {
            DbUtil.writeSqlLog(ctx, sql, params, System.currentTimeMillis() - time);
        }
        return rowset;
    }

    public static void execute(Context ctx, PreparedStatement ps) throws SQLException {
        try {
            long time = System.currentTimeMillis();
            ps.execute();
            if (DebugLogger.isDebug) {
                try {
                    Field stmt = ps.getClass().getSuperclass().getDeclaredField("stmt");
                    NewRptUtil.makeAccessible(stmt);
                    Object curStmt = stmt.get(ps);
                    if (curStmt instanceof KDPreparedStatement) {
                        Field ksql = KDPreparedStatement.class.getDeclaredField("ksql");
                        NewRptUtil.makeAccessible(ksql);
                        Field params = KDPreparedStatement.class.getDeclaredField("params");
                        NewRptUtil.makeAccessible(params);
                        Object ksqlStr = ksql.get(curStmt);
                        Object paramsObj = params.get(curStmt);
                        DbUtil.writeSqlLog(ctx, ksqlStr.toString(), (Object[])paramsObj, System.currentTimeMillis() - time);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"execute error", (Throwable)e);
                }
            }
            ps.close();
        }
        catch (Exception ex) {
            logger.error((Object)"execute(Context ctx,PreparedStatement ps) error", (Throwable)ex);
            throw new SQLException("execute(Context ctx,PreparedStatement ps) error : ", ex);
        }
    }

    public static void execute(Context ctx, String sql) throws BOSException {
        long time = System.currentTimeMillis();
        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql);
        if (DebugLogger.isDebug) {
            DbUtil.writeSqlLog(ctx, sql, null, System.currentTimeMillis() - time);
        }
    }

    public static void execute(Context ctx, String sql, Object[] params) throws BOSException {
        long time = System.currentTimeMillis();
        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        if (DebugLogger.isDebug) {
            DbUtil.writeSqlLog(ctx, sql, params, System.currentTimeMillis() - time);
        }
    }

    public static RptRowSet executeQuery(Context ctx, String sql, SqlParams pp, int from, int length, Connection con) throws SQLException {
        long time = System.currentTimeMillis();
        RptRowSet rowSet = DBUtil.executeQuery((String)sql, (SqlParams)pp, (int)from, (int)length, (Connection)con);
        if (DebugLogger.isDebug) {
            DbUtil.writeSqlLog(ctx, sql, pp.getParams(), System.currentTimeMillis() - time);
        }
        return rowSet;
    }

    public static boolean execute(String sql, SqlParams pp, Connection con, Context ctx) throws SQLException {
        long time = System.currentTimeMillis();
        boolean result = DBUtil.execute((String)sql, (SqlParams)pp, (Connection)con);
        if (DebugLogger.isDebug) {
            sql = pp.getSqlWithParams(sql);
            DbUtil.writeSqlLog(ctx, sql, null, System.currentTimeMillis() - time);
        }
        return result;
    }

    public static int[] executeBatchAndReturn(Context ctx, String sql, List paramsList) throws BOSException {
        long time = System.currentTimeMillis();
        int[] resut = com.kingdee.eas.util.app.DbUtil.executeBatchAndReturn((Context)ctx, (String)sql, (List)paramsList);
        if (DebugLogger.isDebug) {
            DbUtil.writeSqlLog(ctx, sql, paramsList != null && !paramsList.isEmpty() ? (Object[])paramsList.get(0) : null, System.currentTimeMillis() - time);
            if (paramsList != null && paramsList.size() > 0) {
                DbUtil.writerSqlParams(ctx, sql, paramsList);
            }
        }
        return resut;
    }

    public static void prepareVarcharParam(PreparedStatement stmt, int index, String param) throws SQLException {
        com.kingdee.eas.util.app.DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)index, (String)param);
    }

    public static void executeBatch(Context ctx, String sql, List paramsList) throws BOSException {
        long time = System.currentTimeMillis();
        com.kingdee.eas.util.app.DbUtil.executeBatch((Context)ctx, (String)sql, (List)paramsList);
        if (DebugLogger.isDebug) {
            DbUtil.writeSqlLog(ctx, sql, paramsList != null && !paramsList.isEmpty() ? (Object[])paramsList.get(0) : null, System.currentTimeMillis() - time);
            if (paramsList != null && paramsList.size() > 0) {
                DbUtil.writerSqlParams(ctx, sql, paramsList);
            }
        }
    }

    public static void writerSqlParams(Context ctx, String sql, List paramsList) throws BOSException {
        if (DebugLogger.isDebug) {
            try {
                IRowSet rowSet = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)("select * from KSQL_USERCOLUMNS where KSQL_COL_TABNAME='" + sqlLogTableName + "DATA'"));
                if (rowSet == null || !rowSet.next()) {
                    String curSql = "create table " + sqlLogTableName + "DATA (fsql clob,fparams nvarchar(2000),fcreateTime datetime)";
                    com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)curSql);
                }
                String sqlStr = "insert into " + sqlLogTableName + "DATA (fsql,fparams,fcreateTime) values(?,?,?)";
                ArrayList<Object[]> params = new ArrayList<Object[]>();
                StringBuffer paramStr = new StringBuffer();
                for (Object pram : paramsList) {
                    paramStr.setLength(0);
                    for (Object param1 : (Object[])pram) {
                        paramStr.append(param1).append(",");
                    }
                    params.add(new Object[]{sql, paramStr.toString(), new Timestamp(new Date().getTime())});
                }
                com.kingdee.eas.util.app.DbUtil.executeBatch((Context)ctx, (String)sqlStr, params);
            }
            catch (Exception e) {
                logger.error((Object)"writeLog error:", (Throwable)e);
            }
        }
    }

    public static void writeSqlLog(Context ctx, String sql, Object[] params, long spentTime) {
        if (DebugLogger.isDebug) {
            try {
                CslRptUtil.invokeByManualForStatic(DbUtil.class, (String)"writeSqlLogFact", (Class[])new Class[]{Context.class, String.class, Object[].class, Long.TYPE}, (Object[])new Object[]{ctx, sql, params, spentTime}, (int)3);
            }
            catch (Exception ex) {
                logger.error((Object)"writeLog error:", (Throwable)ex);
            }
        }
    }

    public static void writeSqlLogFact(Context ctx, String sql, Object[] params, long spentTime) throws Exception {
        DbUtil.createTable(ctx);
        String dbType = ContextUtil.getDbType((Context)ctx);
        String tranSql = sql;
        if (params != null) {
            tranSql = PsSql.getSqlWithParams((Object)sql, (Object[])params, (int)DbType.getValue((String)dbType), (boolean)false);
        }
        Exception ex = new Exception();
        StackTraceElement[] elements = ex.getStackTrace();
        StringBuffer stack = new StringBuffer();
        int elementLength = elements.length;
        boolean isStart = false;
        int index = 0;
        for (int i = elementLength > 10 ? 10 : 1; i <= (elementLength > 20 ? 19 : elementLength); ++i) {
            if (!isStart && elements[i].toString().indexOf("com.kingdee.eas.fi.newrpt.app.DbUtil") >= 0) {
                isStart = true;
            }
            if (!isStart || ++index < 3) continue;
            stack.append(elements[i].toString()).append("/n");
        }
        String sqlStr = "insert into " + sqlLogTableName + " (fid,fstack,fuserName,fSql,fSpentTime,fcreateTime) values(?,?,?,?,?,?)";
        Object[] curParams = new Object[]{Uuid.create().toString(), stack.toString(), ctx.getUserName(), tranSql, String.valueOf(spentTime), new Timestamp(new Date().getTime())};
        com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sqlStr, (Object[])curParams);
    }

    public static void createTable(Context ctx) throws Exception {
        String dataCenter = ctx.getAIS();
        if (isCreateLogTableMap.get(dataCenter) == null || !isCreateLogTableMap.get(dataCenter).booleanValue()) {
            IRowSet rowSet = com.kingdee.eas.util.app.DbUtil.executeQuery((Context)ctx, (String)("select * from KSQL_USERCOLUMNS where KSQL_COL_TABNAME='" + sqlLogTableName + "'"));
            if (rowSet == null || !rowSet.next()) {
                String sql = "create table " + sqlLogTableName + " (fid varchar(44),fstack nvarchar(2000),fuserName nvarchar(80),fSql clob,fSpentTime NUMERIC(21,0),fcreateTime datetime)";
                com.kingdee.eas.util.app.DbUtil.execute((Context)ctx, (String)sql);
            }
            isCreateLogTableMap.put(dataCenter, true);
        }
    }
}

