/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookFormulaHelper;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.common.perf.JobInstStatusFacadeFactory;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.common.perf.app.PerfSepServerUtils;
import com.kingdee.eas.basedata.common.perf.app.util.MessageInfo;
import com.kingdee.eas.basedata.common.perf.app.util.MessageUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptCalcUtil;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.cslrpt.MaintainYearInitDataFacadeFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveCalcHelper;
import com.kingdee.eas.fi.gr.weaverpt.app.RptWeaveReportCalculate;
import com.kingdee.eas.fi.newrpt.RptCalculateParams;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.IReport;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptDataInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.batch.ChecFmlParamPermissionUtil;
import com.kingdee.eas.fi.rpt.rptdata.RptDataTogether;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReportCalculateHandler
implements IJobHandler {
    private static final Logger logger = Logger.getLogger(ReportCalculateHandler.class);
    private static final long serialVersionUID = 7000669261807170067L;

    public Object execute(Job job) throws Exception {
        Context ctx = null;
        MessageInfo messageInfo = null;
        String reportId = "";
        IMutexServiceControl mutexService = null;
        boolean isgetMutex = false;
        try {
            ctx = job.getContext();
            JobParam jobParam = (JobParam)job.getParameters();
            RptCalculateParams params = (RptCalculateParams)jobParam.getBizParam();
            reportId = params.getString("reportInfoId");
            String reportType = params.getString("reportType");
            mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            String jobinstId = jobParam.getJobId();
            ctx.put((Object)"JOB_INST_ID", (Object)jobinstId);
            ctx.put((Object)"UserInfo", params.getObject("UserInfo"));
            ContextUtil.setCurrentFIUnit((Context)ctx, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)params.getObject("CompanyInfo")));
            Locale locale = null;
            locale = jobParam.getLocale() != null ? jobParam.getLocale() : new Locale("L2");
            if ("report".equals(reportType)) {
                IReport iReport = ReportFactory.getLocalInstance((Context)ctx);
                if (!iReport.exists((IObjectPK)new ObjectStringPK(reportId))) {
                    ReportInfo reportInfo = (ReportInfo)params.getObject("reportInfo");
                    messageInfo = this.setMessageInfo(ctx, jobParam, (ReportBaseInfo)reportInfo);
                    messageInfo.setExecption(RptUtil.getReportResource((String)"notEixt", (Locale)locale));
                    messageInfo.setSuccessed(false);
                    messageInfo.setSendMsg(true);
                    MessageUtil.sendMsg((Context)ctx, (MessageInfo)messageInfo);
                    Boolean bl = new Boolean(false);
                    return bl;
                }
                ReportInfo reportInfo = iReport.getReportInfo((IObjectPK)new ObjectStringPK(reportId), this.getAllReportSelectors());
                messageInfo = this.setMessageInfo(ctx, jobParam, (ReportBaseInfo)reportInfo);
                if (reportInfo.getAuditedStatus() == AuditedStatusEnum.AUDITED) {
                    messageInfo.setExecption(RptUtil.getReportResource((String)"notCalc", (Locale)locale));
                    messageInfo.setSuccessed(false);
                    messageInfo.setSendMsg(true);
                    MessageUtil.sendMsg((Context)ctx, (MessageInfo)messageInfo);
                    Boolean bl = new Boolean(false);
                    return bl;
                }
                JobInstStatusFacadeFactory.getLocalInstance((Context)ctx).updateProgress(jobinstId, 10, "Report Calculate...", "Report Calculate...", "Report Calculate...");
                isgetMutex = mutexService.requestObjIDForUpdate(reportId);
                if (!isgetMutex) {
                    messageInfo.setExecption(RptUtil.getReportResource((String)"Error_Request_ObjectUpdateLock", (Locale)locale));
                    messageInfo.setSuccessed(false);
                    messageInfo.setSendMsg(true);
                    MessageUtil.sendMsg((Context)ctx, (MessageInfo)messageInfo);
                    Boolean bl = new Boolean(false);
                    return bl;
                }
                boolean isDynamicRpt = RptWeaveCalcHelper.isDynamicRpt((ReportBaseInfo)reportInfo);
                FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)params.getObject("FullOrgUnit");
                RptWeaveReportCalculate rptCalc = new RptWeaveReportCalculate(ctx, (OrgUnitInfo)orgUnitInfo);
                if (isDynamicRpt) {
                    rptCalc.fillDynamicItemsandCalc((ReportBaseInfo)reportInfo, false);
                } else {
                    rptCalc.interOrExchFillCompanyAndCalc((ReportBaseInfo)reportInfo, false);
                }
                messageInfo.setSuccessed(true);
                messageInfo.setSendMsg(true);
                MessageUtil.sendMsg((Context)ctx, (MessageInfo)messageInfo);
                Boolean bl = new Boolean(true);
                return bl;
            }
            if ("CslReport".equals(reportType)) {
                Object isSuccess;
                ICslReport iReport = CslReportFactory.getLocalInstance((Context)ctx);
                if (!iReport.exists((IObjectPK)new ObjectStringPK(reportId))) {
                    ReportInfo reportInfo = (ReportInfo)params.getObject("reportInfo");
                    messageInfo = this.setMessageInfo(ctx, jobParam, (ReportBaseInfo)reportInfo);
                    messageInfo.setExecption(RptUtil.getReportResource((String)"notEixt", (Locale)locale));
                    messageInfo.setSuccessed(false);
                    messageInfo.setSendMsg(true);
                    MessageUtil.sendMsg((Context)ctx, (MessageInfo)messageInfo);
                    Boolean isDynamicRpt = new Boolean(false);
                    return isDynamicRpt;
                }
                CslReportInfo reportInfo = iReport.getCslReportInfo((IObjectPK)new ObjectStringPK(reportId), this.getAllReportSelectors());
                messageInfo = this.setMessageInfo(ctx, jobParam, (ReportBaseInfo)reportInfo);
                if (reportInfo.getAuditedStatus() == AuditedStatusEnum.AUDITED) {
                    messageInfo.setExecption(RptUtil.getReportResource((String)"notCalc", (Locale)locale));
                    messageInfo.setSuccessed(false);
                    messageInfo.setSendMsg(true);
                    MessageUtil.sendMsg((Context)ctx, (MessageInfo)messageInfo);
                    Boolean isDynamicRpt = new Boolean(false);
                    return isDynamicRpt;
                }
                isgetMutex = mutexService.requestObjIDForUpdate(reportId);
                if (!isgetMutex) {
                    messageInfo.setExecption(RptUtil.getReportResource((String)"Error_Request_ObjectUpdateLock", (Locale)locale));
                    messageInfo.setSuccessed(false);
                    messageInfo.setSendMsg(true);
                    MessageUtil.sendMsg((Context)ctx, (MessageInfo)messageInfo);
                    Boolean isDynamicRpt = new Boolean(false);
                    return isDynamicRpt;
                }
                JobInstStatusFacadeFactory.getLocalInstance((Context)ctx).updateProgress(jobinstId, 10, "Report Calculate...", "Report Calculate...", "Report Calculate...");
                Object object = isSuccess = this.cslRptCalculate(job, reportInfo, messageInfo);
                return object;
            }
        }
        catch (EASBizException e) {
            messageInfo.setExecption(e.getMessage());
            messageInfo.setSuccessed(false);
            messageInfo.setSendMsg(true);
            MessageUtil.sendMsg((Context)ctx, messageInfo);
            throw e;
        }
        catch (Exception e1) {
            logger.error((Object)"RptCalculate", (Throwable)e1);
            messageInfo.setExecption(e1.getMessage());
            messageInfo.setSuccessed(false);
            messageInfo.setSendMsg(true);
            MessageUtil.sendMsg((Context)ctx, messageInfo);
            throw e1;
        }
        finally {
            PerfSepServerUtils.updateTaskState((Job)job);
            if (isgetMutex) {
                mutexService.releaseObjIDForUpdate(reportId);
            }
        }
        return new Boolean(true);
    }

    private Object cslRptCalculate(Job job, CslReportInfo cslReportInfo, MessageInfo messageInfo) throws Exception {
        Context ctx = job.getContext();
        JobParam jobParam = (JobParam)job.getParameters();
        RptCalculateParams calcparams = (RptCalculateParams)jobParam.getBizParam();
        RptDataTogether rptDataTogether = this.startRecordRptData(ctx, cslReportInfo, cslReportInfo.getBook());
        if (cslReportInfo.getSourceType() == RptSrcTypeEnum.NORMAL || cslReportInfo.getSourceType() == RptSrcTypeEnum.DYNAMICNORMALREPORT || cslReportInfo.getSourceType() == RptSrcTypeEnum.COMMITREPORT) {
            boolean isDynamicRpt = RptWeaveCalcHelper.isDynamicRpt((ReportBaseInfo)cslReportInfo);
            FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)calcparams.getObject("FullOrgUnit");
            if (orgUnitInfo == null) {
                orgUnitInfo = cslReportInfo.getOrgUnit();
            }
            RptWeaveReportCalculate rptCalc = new RptWeaveReportCalculate(ctx, (OrgUnitInfo)orgUnitInfo);
            if (isDynamicRpt) {
                rptCalc.fillDynamicItemsandCalc((ReportBaseInfo)cslReportInfo, true);
            } else {
                rptCalc.interOrExchFillCompanyAndCalc((ReportBaseInfo)cslReportInfo, true);
            }
        } else if (cslReportInfo.getSourceType() == RptSrcTypeEnum.MANUSCRIPT || cslReportInfo.getSourceType() == RptSrcTypeEnum.CONSOLIDATION) {
            Book book = this.prepareCalculate(ctx, cslReportInfo);
            BookProperties p = BookProperties.loadFromBook((Book)book);
            int dataElementRelat = p.getDataElementRelating();
            HashMap<String, Object> params = new HashMap<String, Object>(3);
            params.put("dataElementRelating", new Integer(dataElementRelat));
            params.put((String)OrgType.UnionDebt, calcparams.getObject(String.valueOf(8)));
            params.put("KEY_ORGTREE_INFO", calcparams.getObject("KEY_ORGTREE_INFO"));
            new CslRptCalcUtil().calculateSheets(ctx, book, cslReportInfo, params);
            book.calc();
            cslReportInfo.setBook(book);
            ICslReport iReport = CslReportFactory.getLocalInstance((Context)ctx);
            iReport.submit((CoreBaseInfo)cslReportInfo);
        }
        messageInfo.setSendMsg(true);
        messageInfo.setSuccessed(true);
        MessageUtil.sendMsg((Context)ctx, (MessageInfo)messageInfo);
        this.endRecordRptData(rptDataTogether);
        return new Boolean(true);
    }

    private RptDataTogether startRecordRptData(Context ctx, CslReportInfo cslReportInfo, Book book) {
        logger.info((Object)"[rptData]start backCalc-cslreport");
        if (cslReportInfo == null) {
            return null;
        }
        RptDataTogether instance = null;
        boolean isRecord = false;
        try {
            isRecord = CslRptUtil.getCslParam((Context)ctx, (String)"IsRecordRptData");
            String rptDataId = null;
            if (isRecord) {
                long currTime = System.currentTimeMillis();
                instance = new RptDataTogether(ctx);
                RptDataInfo rptDataInfo = new RptDataInfo(ctx, cslReportInfo, this.getAllMethods(book));
                rptDataInfo.setId(BOSUuid.read(rptDataId));
                rptDataInfo.setCalcStartTime(new Timestamp(currTime));
                if (rptDataInfo.getUserId() != null) {
                    IUser userDB = UserFactory.getLocalInstance((Context)ctx);
                    UserInfo userInfo = userDB.getUserInfo("select number,name where id = '" + rptDataInfo.getUserId().toString() + "'");
                    rptDataInfo.setUserNumber(userInfo.getNumber());
                    rptDataInfo.setUserName(userInfo.getName());
                }
                if (isRecord = instance.register(rptDataInfo)) {
                    instance.startRecordForServer(new Timestamp(currTime));
                } else {
                    instance = null;
                }
            }
        }
        catch (Exception e1) {
            logger.error((Object)"", (Throwable)e1);
            instance = null;
        }
        return instance;
    }

    private Map<String, Integer> getAllMethods(Book book) {
        return BookFormulaHelper.statBook((Book)book).getFunctionMap();
    }

    private void endRecordRptData(RptDataTogether instance) {
        if (instance == null) {
            return;
        }
        try {
            instance.endRecordForAll();
            logger.info((Object)"[rptData]end backCalc-cslreport");
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    private MessageInfo setMessageInfo(Context ctx, JobParam jobParam, ReportBaseInfo reportInfo) {
        Locale locale = null;
        locale = jobParam.getLocale() != null ? jobParam.getLocale() : new Locale("L2");
        MessageInfo info = new MessageInfo();
        info.setUserID(ctx.getCaller().toString());
        String companyName = reportInfo.getCompany() == null ? "" : reportInfo.getCompany().getName();
        companyName = companyName == null ? "" : companyName + ":";
        info.setbizAction(companyName + reportInfo.getNumber() + ":" + reportInfo.getName() + "(" + RptUtil.getReportResource((String)"ReportCalcMsg", (Locale)locale) + ")");
        info.setOrgNumber(reportInfo.getCompany().getNumber());
        return info;
    }

    private void fillYearInitData(Context ctx, String reportId, Book book) throws Exception {
        boolean isAllInterExchInvest = true;
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet curSheet = book.getSheet(i);
            if (RptUtil.isInterOrExchSheet((Sheet)curSheet) || RptUtil.isInvestSheet((Sheet)curSheet)) continue;
            isAllInterExchInvest = false;
            break;
        }
        if (isAllInterExchInvest) {
            return;
        }
        List valueList = MaintainYearInitDataFacadeFactory.getLocalInstance((Context)ctx).getCellValueFromYearInitDataByReportID(reportId);
        if (valueList != null) {
            boolean needGetCellItemFormula = true;
            Map cellItemFormula = new HashMap();
            Iterator valueIt = valueList.iterator();
            HashMap valueMap = null;
            BigDecimal zero = new BigDecimal("0");
            while (valueIt.hasNext()) {
                String itemFormula;
                valueMap = (HashMap)valueIt.next();
                BigDecimal value = null;
                int dc = (Integer)valueMap.get("RptItemDC");
                if (valueMap.get("Debit") != null && ((BigDecimal)valueMap.get("Debit")).compareTo(zero) != 0) {
                    value = ((BigDecimal)valueMap.get("Debit")).multiply(new BigDecimal(dc == 1 ? "1" : "-1"));
                }
                if (valueMap.get("Credit") != null && ((BigDecimal)valueMap.get("Credit")).compareTo(zero) != 0) {
                    value = ((BigDecimal)valueMap.get("Credit")).multiply(new BigDecimal(dc == 1 ? "-1" : "1"));
                }
                String string = itemFormula = valueMap.get("itemFormula") == null ? null : (String)valueMap.get("itemFormula");
                if (needGetCellItemFormula) {
                    cellItemFormula = RptUtil.getBookCellItemFormula((Book)book, (boolean)false, (boolean)false);
                    needGetCellItemFormula = false;
                }
                if (itemFormula == null || cellItemFormula.get(itemFormula) == null) continue;
                Cell cell = (Cell)cellItemFormula.get(itemFormula);
                int currencyScale = (Integer)valueMap.get("CurrencyPrecision");
                if (value != null) {
                    value = value.setScale(currencyScale, 4);
                    cell.setValue(new Variant((Object)value));
                    continue;
                }
                cell.setValue(Variant.nullVariant);
            }
        }
    }

    private Book prepareCalculate(Context ctx, CslReportInfo reportInfo) throws Exception {
        Book book = null;
        book = reportInfo.getData() != null ? reportInfo.getBook() : Book.Manager.getNewBook((String)"Sheet1", (int)1);
        book.setCalculate(false);
        BookProperties p = BookProperties.loadFromBook((Book)book);
        CSLPropertyAdapter adapter = new CSLPropertyAdapter();
        adapter.initReportProperties((IObjectValue)reportInfo, ctx);
        ReportCalculateContext context = new ReportCalculateContext(ctx, (IReportPropertyAdapter)adapter, p.getVariables(), (IErrorProvider)p.getErrorProvider(), null);
        context.setPermission(new ChecFmlParamPermissionUtil(ctx));
        FormulaDefinition.registerFormulaToBook(book, context);
        return book;
    }

    private Book prepareCalculate(Context ctx, ReportInfo reportInfo) throws Exception {
        Book book = null;
        book = reportInfo.getData() != null ? reportInfo.getBook() : Book.Manager.getNewBook((String)"Sheet1", (int)1);
        book.setCalculate(false);
        ReportCalculateContext calcContext = new ReportCalculateContext(ctx);
        ReportInfo report = reportInfo;
        if (report.getPeriodType() == null) {
            report.setPeriodType(RptPeriodTypeEnum.MONTHLY);
        }
        ReportCalculateErrorProvider errorhandler = null;
        errorhandler = (ReportCalculateErrorProvider)reportInfo.get("RPT_ERRORHANDLER");
        calcContext.setErrorProvider((IErrorProvider)errorhandler);
        BookProperties bookProperties = BookProperties.loadFromBook((Book)book);
        calcContext.setReportVariables(bookProperties.getVariables());
        calcContext.setReportAdapter((IReportPropertyAdapter)new RptReportPropertyAdapter(report));
        calcContext.setPermission(new ChecFmlParamPermissionUtil(ctx));
        FormulaDefinition.registerFormulaToBook(book, calcContext);
        book.getUndoManager().enable(false);
        book.setCalculate(false);
        return book;
    }

    private SelectorItemCollection getAllReportSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.cu.id"));
        sic.add(new SelectorItemInfo("orgTree.id"));
        sic.add(new SelectorItemInfo("orgTree.number"));
        sic.add(new SelectorItemInfo("dataCollect.*"));
        sic.add(new SelectorItemInfo("dataCollectNumber"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("sourceCurrency.name"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("sourceCurrency.precision"));
        sic.add(new SelectorItemInfo("orgRela.id"));
        sic.add(new SelectorItemInfo("orgRela.orgType"));
        sic.add(new SelectorItemInfo("orgRela.relaType"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.number"));
        sic.add(new SelectorItemInfo("savePoint.relaType"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgType"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("template.name"));
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("template.templateType"));
        sic.add(new SelectorItemInfo("template.dynaRptType"));
        sic.add(new SelectorItemInfo("template.group"));
        return sic;
    }
}

