/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.UnionVersionControllerFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.RptProperties;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.app.AbstractRptNewUIHandleFacadeControllerBean;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.AccountORMFactory;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.PublishedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportCollection;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.app.ConditionWrappedInfo;
import com.kingdee.eas.fi.rpt.app.TemplateControllerBean;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptNewUIHandleFacadeControllerBean
extends AbstractRptNewUIHandleFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.app.RptNewUIHandleFacadeControllerBean");
    private RptProperties _pros = null;

    @Override
    protected IRowSet _getAuthorizedOrg(Context ctx, IObjectPK userPK, String[] permItems, OrgType orgType) throws BOSException, EASBizException {
        long starttime = System.currentTimeMillis();
        if (userPK == null || permItems == null || permItems != null && permItems.length == 0 || orgType == null) {
            throw new IllegalArgumentException("RptNewUIHandleFacadeControllerBean's arguments is Illegal!");
        }
        boolean isFromAdjustWorkSheet = false;
        if (permItems[0].equals("isFromAdjustWorkSheet")) {
            isFromAdjustWorkSheet = true;
            permItems = new String[]{permItems[1]};
        }
        String treeID = PermissionCacheFactory.getOrgCache((Context)ctx).getBasicTreeID(ctx, orgType);
        PermItemInfo[] permItemInfos = this.getPermItemInfo(ctx, permItems);
        String[] permItemIDs = new String[permItemInfos.length];
        for (int i = 0; i < permItemInfos.length; ++i) {
            permItemIDs[i] = permItemInfos[i].getId().toString();
        }
        Object[] params = new Object[]{treeID};
        String nameField = MultiLangHelper.getFieldName((String)"FName", (Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer(1000);
        sql.append(" SELECT BaseUnit.FID, BaseUnit.FNumber, Structure.FLongNumber, \n").append(" BaseUnit.").append(nameField).append(" Fname, ").append(RptNewUIHandleFacadeControllerBean.constructCaseWhenSQL("perm.FPermItemID", "FPermItemName", permItemIDs, permItems)).append(" FROM T_ORG_BaseUnit BaseUnit \n").append(" INNER JOIN T_ORG_Structure Structure ON Structure.FUnitId = BaseUnit.FID \n").append(" INNER JOIN (").append(this.combineHasPermSQL(userPK, permItemIDs)).append(") perm \n").append(" on BaseUnit.FID = perm.FOrgID \n");
        if (!isFromAdjustWorkSheet) {
            sql.append(" WHERE Structure.FTreeId = ? \n");
        }
        if (this._pros != null && this._pros.getString("schemeId") != null) {
            String schemeid = this._pros.getString("schemeId");
            sql.append(" AND BaseUnit.FID IN (SELECT schmOrg.FCompany FROM T_CSL_RptWeaveSchmCompEntry schmOrg WHERE schmOrg.FScheme = '" + schemeid + "')");
        }
        sql.append("  order by Structure.FLongNumber asc \n");
        IRowSet rowSet = null;
        rowSet = !isFromAdjustWorkSheet ? DbUtil.executeQuery(ctx, sql.toString(), params) : DbUtil.executeQuery(ctx, sql.toString());
        long spantime = System.currentTimeMillis() - starttime;
        System.out.println("getAuthorizeSpanTime:" + spantime);
        return rowSet;
    }

    private PermItemInfo[] getPermItemInfo(Context ctx, String[] permItemNames) throws EASBizException, BOSException {
        PermItemInfo[] permItemInfos = new PermItemInfo[permItemNames.length];
        for (int i = 0; i < permItemNames.length; ++i) {
            permItemInfos[i] = PermissionCacheFactory.getPermItemCache((Context)ctx).getPermItem(ctx, permItemNames[i]);
        }
        return permItemInfos;
    }

    private String combineHasPermSQL(IObjectPK userPK, String[] permItemIDs) {
        StringBuffer sql = new StringBuffer(1000);
        String userID = userPK == null ? "userid " : userPK.toString();
        String permItemStr = CslRptUtil.AryToItemString(Arrays.asList(permItemIDs));
        sql.append(" SELECT UserOrgPerm.FOrgID AS FOrgID,UserOrgPerm.FPermItemID as FPermItemID \n").append(" FROM T_PM_UserOrgPerm UserOrgPerm \n").append(" WHERE UserOrgPerm.FOwner = '").append(userID).append("' AND UserOrgPerm.FPermItemID \n").append(" in(").append(permItemStr).append(") AND UserOrgPerm.FPermType = ").append(10).append(" AND NOT EXISTS ( \n").append(" SELECT 'X' FROM T_PM_UserOrgPerm UserOrgPerm2 \n").append(" WHERE UserOrgPerm2.FOwner = '").append(userID).append("' AND UserOrgPerm2.FPermItemID \n").append(" in(").append(permItemStr).append(") AND UserOrgPerm2.FPermType = ").append(20).append("\n").append(" AND UserOrgPerm.FPermItemID = UserOrgPerm2.FPermItemID \n").append(" AND UserOrgPerm.FOrgID = UserOrgPerm2.FOrgID) \n").append(" Union  \n").append(" SELECT UserRoleOrg.FOrgID AS FOrgID,RolePerm.FPermItemID as FPermItemID FROM T_PM_RolePerm RolePerm \n").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON  RolePerm.FRoleID = UserRoleOrg.FRoleID \n").append(" WHERE UserRoleOrg.FUserID = '").append(userID).append("' AND RolePerm.FPermItemID in(").append(permItemStr).append(" ) AND RolePerm.FPermType = ").append(10).append(" AND NOT EXISTS( \n").append(" SELECT 'X' FROM T_PM_RolePerm RolePerm2 \n").append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg2 ON  RolePerm2.FRoleID = UserRoleOrg2.FRoleID \n").append(" WHERE UserRoleOrg2.FUserID = '").append(userID).append("' AND RolePerm2.FPermItemID in(").append(permItemStr).append(" ) AND RolePerm2.FPermType = ").append(20).append(" \n").append(" AND RolePerm.FPermItemID = RolePerm2.FPermItemID \n").append(" AND UserRoleOrg.FOrgID = UserRoleOrg2.FOrgID) \n");
        return sql.toString();
    }

    private String constructDeCodeSQL(String field, String alias, String[] permItemIDs, String[] permItemNames) {
        StringBuffer caseSQL = new StringBuffer();
        caseSQL.append(" DECODE(").append(field).append(",");
        for (int i = 0; i < permItemIDs.length; ++i) {
            caseSQL.append("'").append(permItemIDs[i]).append("',").append("'").append(permItemNames[i]).append("',");
        }
        caseSQL.append("'NONE'").append(") as ").append(alias);
        return caseSQL.toString();
    }

    private static String constructCaseWhenSQL(String field, String alias, String[] permItemIDs, String[] permItemNames) {
        StringBuffer caseSQL = new StringBuffer();
        caseSQL.append(" CASE ").append(field).append(" ");
        for (int i = 0; i < permItemIDs.length; ++i) {
            caseSQL.append(" WHEN '").append(permItemIDs[i]).append("' THEN ").append("'").append(permItemNames[i]).append("' \n");
        }
        caseSQL.append(" ELSE 'NONE'").append(" END as ").append(alias);
        return caseSQL.toString();
    }

    public static void main(String[] args) {
        System.out.println(RptNewUIHandleFacadeControllerBean.constructCaseWhenSQL("fvalue", "permitemname", new String[]{"11", "22"}, new String[]{"view", "edit"}));
        String[] arr = new String[]{"11", "22"};
        List<String> lst = Arrays.asList(arr);
        for (int i = 0; i < lst.size(); ++i) {
            System.out.println(lst.get(i).toString());
        }
    }

    @Override
    protected Map _getOrgReportData(Context ctx, RptProperties condition) throws BOSException, EASBizException {
        long starttime = System.currentTimeMillis();
        String tmplTable = this.isNewQuery(condition) ? this.createTmplTable(ctx) : condition.getString("tplTable");
        Collection orgIDs = condition.getCollection("orgIDs");
        if (orgIDs == null || orgIDs.size() == 0) {
            throw new RuntimeException("parameter orgIDs is null!");
        }
        this.releaseTmplTable(ctx, condition);
        if (this.isNewQuery(condition)) {
            ParamTempTblService paramSrv = this.getCompanyIDParamSrv(ctx, orgIDs);
            this.insertReportData2TmplTbl(ctx, condition, tmplTable, paramSrv);
            if (this.isIncludGroupTmpl(condition)) {
                this.insertTemplateData2TmplTbl(ctx, condition, tmplTable, paramSrv);
                this.deleteUnneedData(ctx, condition, tmplTable);
            }
            condition.setString("tplTable", tmplTable);
            this.deleteNoDataPermission(ctx, condition, paramSrv);
            this.excludeOutOfOrgBoundTemplate(ctx, condition, paramSrv);
            this.deleteNotConformConditionData(ctx, condition);
            paramSrv.release();
        }
        Map result = this.getNextPageResult(ctx, condition);
        result.put("condition", condition);
        if (this.isNewQuery(condition)) {
            result.put("statistic", this.getStatistic(ctx, tmplTable));
        }
        long spantime = System.currentTimeMillis() - starttime;
        logger.info((Object)("_getOrgReportDataSpanTime:" + spantime));
        return result;
    }

    private void deleteNotConformConditionData(Context ctx, RptProperties condition) throws EASBizException, BOSException {
        if (condition.containsKey("template_idset") && condition.getCollection("template_idset").size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(" delete ").append(condition.getString("tplTable")).append(" where tgroup not in( \n").append(" select fgroup from t_rpt_template \n").append(" where fid in(").append(CslRptUtil.AryToItemString((Collection)condition.getCollection("template_idset"))).append(" ) and tgroup is not null )");
            DbUtil.execute(ctx, sb.toString());
        }
    }

    private void excludeOutOfOrgBoundTemplate(Context ctx, RptProperties condition, ParamTempTblService paramSrv) throws EASBizException, BOSException {
        int periodType;
        int period;
        int year = condition.getInt("year");
        String[] orgBoundIDs = this.getInsideTimestampOrgBoundIDs(ctx, year, period = condition.getInt("period"), periodType = condition.getInt("periodType"));
        if (orgBoundIDs == null || orgBoundIDs.length <= 0) {
            return;
        }
        StringBuffer sql = new StringBuffer(500);
        sql.append(" Delete from ").append(condition.getString("tplTable")).append(" where id in(").append(" select id from ").append(condition.getString("tplTable")).append(" tmp where isReport = 0 \n").append(" and not exists( select 'X' from t_csl_templetDispense dis \n").append(" join ( select queryTmp.id ,case when tmpl.fgroupTemplateId is null \n").append(" then tmpl.fid else fgroupTemplateId end fgrpTmpId,queryTmp.companyid from t_rpt_template tmpl \n").append(" join ").append(condition.getString("tplTable")).append(" queryTmp \n").append(" on tmpl.fid = queryTmp.id \n").append(" where queryTmp.isReport = 0 ) as grpTmp on dis.fdispensesrcid = grpTmp.fgrpTmpId and grpTmp.companyid = dis.fcompanyid \n").append(" where dis.fcompanyid in(").append(paramSrv.getParamsSql()).append(") \n").append(" and dis.forgboundid in(").append(CslRptUtil.AryToItemString(Arrays.asList(orgBoundIDs))).append(")").append(" and tmp.id = grpTmp.id and tmp.companyid = grpTmp.companyid ))");
        long startTime = System.currentTimeMillis();
        DbUtil.execute(ctx, sql.toString());
        logger.info((Object)("RptNewUIHandleFacadeControllerBean.excludeOutOfOrgBoundTemplate1():" + (System.currentTimeMillis() - startTime)));
    }

    private String[] getInsideTimestampOrgBoundIDs(Context ctx, int year, int period, int periodType) throws EASBizException, BOSException {
        Date date = RPTDate13Util.getPeriodLastDate((int)year, (int)period, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)periodType));
        Timestamp ts = new Timestamp(date.getTime());
        return UnionVersionControllerFacadeFactory.getLocalInstance((Context)ctx).getIDList(ts);
    }

    private void deleteNoDataPermission(Context ctx, RptProperties condition, ParamTempTblService paramSrv) throws BOSException {
        StringBuffer sql = new StringBuffer(100);
        sql.append(" delete ").append(condition.getString("tplTable")).append(" where publicStatus = 1 and isReport = 1 \n").append(" and creatorId <> '").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("'").append(" and id not in( SELECT DISTINCT FBizDataID FROM T_PM_DiscretePermReport \n").append(" where FUserID ='").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("'").append(" and FOrgID in (").append(paramSrv.getParamsSql()).append(")\n").append(" )");
        DbUtil.execute(ctx, sql.toString());
    }

    private void deleteUnneedData(Context ctx, RptProperties condition, String tmplTable) throws BOSException, EASBizException {
        if (2 == condition.getInt("dataType")) {
            return;
        }
        StringBuffer delete = new StringBuffer();
        delete.append(" delete ").append(tmplTable);
        String filter = this.appendDeleteRptStateFilter("", condition);
        if (!StringUtils.isEmpty((String)filter)) {
            delete.append(" where ").append(filter);
            DbUtil.execute(ctx, delete.toString());
        }
    }

    private String appendDeleteRptStateFilter(String alias, RptProperties condition) {
        Boolean[] stateBoolArr = (Boolean[])condition.getObject("stateBooleanVal");
        boolean doing = stateBoolArr[1];
        boolean audited = stateBoolArr[2];
        boolean committed = stateBoolArr[3];
        boolean hasSelected = doing || audited || committed;
        StringBuffer filter = new StringBuffer();
        alias = StringUtils.isEmpty((String)alias) ? "" : alias + ".";
        filter.append(alias).append("isReport = 1 ");
        filter.append(" and ").append(alias).append("SourceType not in(1,6)");
        if (hasSelected) {
            filter.append(" and (");
            int total = (doing ? 1 : 0) + (audited ? 3 : 0) + (committed ? 5 : 0);
            if (total == 1) {
                filter.append(alias).append("auditedStatus = 2 ");
            } else if (total == 3) {
                filter.append(alias).append("auditedStatus = 1 ");
                filter.append(" or ").append(alias).append("committedStatus >= 2 ");
            } else if (total == 5) {
                filter.append(alias).append("committedStatus = 1 ");
            } else if (total == 4) {
                filter.append(alias).append("committedStatus >= 2 ");
            } else if (total == 6) {
                filter.append(alias).append("auditedStatus = 2 and ");
                filter.append(alias).append("committedStatus = 1 ");
            } else if (total == 8) {
                filter.append(alias).append("auditedStatus = 1 ");
            } else {
                return "";
            }
            filter.append(")");
        }
        return filter.toString();
    }

    private boolean isIncludGroupTmpl(RptProperties condition) {
        boolean isIncludeunDoing;
        Boolean[] stateBoolArr = (Boolean[])condition.getObject("stateBooleanVal");
        boolean bl = isIncludeunDoing = stateBoolArr == null ? true : stateBoolArr[0];
        if (1 == condition.getInt("dataType") && isIncludeunDoing) {
            return true;
        }
        return 3 == condition.getInt("dataType") && isIncludeunDoing;
    }

    private void insertReportData2TmplTbl(Context ctx, RptProperties condition, String tmplTable, ParamTempTblService paramSrv) throws BOSException, EASBizException {
        StringBuffer sql = this.getInsertReportDataSQL(ctx, tmplTable, condition, paramSrv);
        Object[] params = new Object[]{condition.getInt("year"), condition.getInt("period"), condition.getInt("periodType"), this.getOrgTypeVal(condition), condition.getString("currency")};
        DbUtil.execute(ctx, sql.toString(), params);
    }

    private void insertTemplateData2TmplTbl(Context ctx, RptProperties condition, String tmplTable, ParamTempTblService paramSrv) throws BOSException, EASBizException {
        int companyIDSize = paramSrv.getParams().size();
        boolean isSupportK3Query = companyIDSize == 1;
        boolean bl = isSupportK3Query = isSupportK3Query && AccountORMFactory.getLocalInstance((Context)ctx).isLockByCompany((IObjectPK)new ObjectUuidPK((String)paramSrv.getParams().iterator().next()));
        if (isSupportK3Query) {
            this.insertTemplateData4K3(ctx, condition, tmplTable, paramSrv);
        } else {
            this.insertTemplateData4NotK3(ctx, condition, tmplTable, paramSrv);
        }
    }

    private void insertTemplateData4K3(Context ctx, RptProperties condition, String tmplTable, ParamTempTblService paramSrv) throws BOSException, EASBizException {
        ConditionWrappedInfo wrappedInfo = new ConditionWrappedInfo();
        wrappedInfo.setCompanyID((String)paramSrv.getParams().iterator().next());
        wrappedInfo.setFromNewRptUI(true);
        wrappedInfo.setOnlyUnversion(true);
        wrappedInfo.setRemovePublished(true);
        wrappedInfo.setShowFreezed(false);
        wrappedInfo.setUseK3(true);
        wrappedInfo.setOrgType(this.getOrgTypeVal(condition));
        wrappedInfo.setTemplateType(Arrays.asList(RptTmpTypeEnum.RPTDYNAMICREPORT, RptTmpTypeEnum.MULTIRPTDYNAMICREPORT));
        wrappedInfo.setSelectorSql(this.getSelectPart(ctx, true));
        wrappedInfo.setDisplayTemplateTypeValue(StringUtils.isEmpty((String)condition.getString("displayType")) ? "ALL" : "('" + condition.getString("displayType") + "')");
        wrappedInfo.setPeriodType(RptPeriodTypeEnum.getEnum((int)condition.getInt("periodType")));
        TemplateControllerBean.createDispenseTemplateRecordTable((Context)ctx, (ConditionWrappedInfo)wrappedInfo);
        StringBuffer sql = new StringBuffer(2000);
        sql.append(" INSERT INTO ").append(tmplTable).append(" \n").append(" SELECT * from ( \n").append(" SELECT * FROM ( \n");
        sql.append(TemplateControllerBean.builderGroupTmplSQL((ConditionWrappedInfo)wrappedInfo));
        sql.append(" UNION ALL \n");
        sql.append(TemplateControllerBean.builderSubTmplSQL((ConditionWrappedInfo)wrappedInfo));
        sql.append(" ) t \n");
        sql.append(" WHERE NOT EXISTS ( \n");
        sql.append(" SELECT 'X' from ").append(tmplTable).append(" t1 \n");
        sql.append(" WHERE t.tgroup = t1.tgroup AND t.companyID = t1.companyID)) tmp\n ");
        DbUtil.execute(ctx, sql.toString());
        if (!StringUtils.isEmpty((String)wrappedInfo.getDispTmplTable())) {
            TempTablePool.getInstance((Context)ctx).releaseTable(wrappedInfo.getDispTmplTable());
        }
    }

    private void insertTemplateData4NotK3(Context ctx, RptProperties condition, String tmplTable, ParamTempTblService paramSrv) throws BOSException, EASBizException {
        StringBuffer sql = this.getInsertTemplateDataSQL(ctx, tmplTable, condition, paramSrv);
        Object[] params = new Object[]{condition.getInt("periodType"), this.getOrgTypeVal(condition), condition.getInt("periodType"), this.getOrgTypeVal(condition), condition.getInt("periodType"), this.getOrgTypeVal(condition)};
        DbUtil.execute(ctx, sql.toString(), params);
    }

    private int[] getStatistic(Context ctx, String tmplTable) throws BOSException {
        int[] statis = new int[6];
        StringBuffer sql = new StringBuffer(100);
        sql.append(" select count(1) as cnt, 0 as state from ").append(tmplTable).append("   \n").append(" where sourceType in (7,10,13,2,12,16) and (isSupportGroup = 1 or isReport = 0) \n").append(" union all \n").append(" Select count(1) as cnt, -1 as state from ").append(tmplTable).append("  \n").append(" where isReport = 0 ").append(" union all \n").append(" Select count(1) as cnt, 1 as state from ").append(tmplTable).append("   \n").append(" where isReport = 1 and auditedStatus = 1 and sourceType in (7,10,13)    \n").append(" and isSupportGroup = 1 \n").append(" union all ").append(" Select count(1) as cnt, 2 as state from ").append(tmplTable).append("   \n").append(" where isReport = 1 and auditedStatus = 2 and committedStatus = 1 and sourceType in (7,10,13)\n").append(" and isSupportGroup = 1 \n").append(" union all ").append(" Select count(1) as cnt, 3 as state from ").append(tmplTable).append("   \n").append(" where isReport = 1 and committedStatus >= 2 and sourceType in (7,10,13)  \n").append(" and isSupportGroup = 1 \n").append(" union all ").append(" Select count(1) as cnt, 4 as state from ").append(tmplTable).append("   \n");
        IRowSet rs = DbUtil.executeQuery(ctx, sql.toString());
        try {
            while (rs.next()) {
                if (rs.getInt("state") == 0) {
                    statis[0] = rs.getInt("cnt");
                    continue;
                }
                if (rs.getInt("state") == -1) {
                    statis[1] = rs.getInt("cnt");
                    continue;
                }
                if (rs.getInt("state") == 1) {
                    statis[2] = rs.getInt("cnt");
                    continue;
                }
                if (rs.getInt("state") == 2) {
                    statis[3] = rs.getInt("cnt");
                    continue;
                }
                if (rs.getInt("state") == 3) {
                    statis[4] = rs.getInt("cnt");
                    continue;
                }
                if (rs.getInt("state") != 4) continue;
                statis[5] = rs.getInt("cnt");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return statis;
    }

    private StringBuffer getInsertTemplateDataSQL(Context ctx, String tmplTable, RptProperties condition, ParamTempTblService paramSrv) throws BOSException {
        String schemeid;
        StringBuffer sql = new StringBuffer(2000);
        sql.append(" INSERT INTO ").append(tmplTable).append(" \n").append(" SELECT * FROM (").append(this.getSelectPart(ctx, false)).append(" FROM T_RPT_Template template \n").append(" INNER JOIN (Select distinct d.fdispensesrcid,d.fcompanyid companyid \n").append(" FROM T_CSL_TempletDispense d \n").append(" INNER JOIN t_rpt_template template ON d.fdispensesrcid = template.fid \n").append(" WHERE template.fversionstatus = 1 AND template.FIsFreezed = 0 and template.fperiodtype = ? \n").append(" AND template.forgtype = ? \n").append(this.appendTemplateTypeFilter("template", condition));
        if (condition.getString("schemeId") != null) {
            schemeid = condition.getString("schemeId");
            sql.append(" AND template.FNumber in (SELECT tmp.FNumber FROM t_rpt_template tmp INNER JOIN T_CSL_RptWeaveSchmTempEntry schmTmpl ON schmTmpl.FTemplate = tmp.FID AND schmTmpl.FSchemeID = '" + schemeid + "') \n");
            sql.append(" AND template.FTemplateType in (SELECT tmp.FTemplateType FROM t_rpt_template tmp INNER JOIN T_CSL_RptWeaveSchmTempEntry schmTmpl ON schmTmpl.FTemplate = tmp.FID AND schmTmpl.FSchemeID = '" + schemeid + "') \n");
            sql.append(" AND d.fcompanyid in (SELECT schmOrg.FCompany FROM T_CSL_RptWeaveSchmCompEntry schmOrg WHERE schmOrg.FScheme = '" + schemeid + "' AND schmOrg.FCompany IN(" + paramSrv.getParamsSql() + "))) AS disp \n");
        } else {
            sql.append(" AND d.fcompanyid in(").append(paramSrv.getParamsSql()).append(")) AS disp \n");
        }
        sql.append(" ON template.fid = disp.fdispensesrcid \n").append(this.appendTemplateTypeFilter("template", condition)).append(" LEFT JOIN T_PM_User AS creator ON template.FCreatorID = creator.FID \n").append(" LEFT JOIN T_PM_User AS auditor ON template.FAuditorID = auditor.FID \n").append(" LEFT JOIN T_PM_User AS lastupdateuser ON template.FLastUpdateUserID = lastupdateuser.FID \n").append(" INNER JOIN t_org_BaseUnit AS company ON disp.CompanyID = company.FID \n").append(" WHERE NOT EXISTS \n").append(" (SELECT 'X' \n").append(" FROM T_RPT_Template t \n").append(" WHERE t.FVersionStatus = 1 AND t.fisfreezed = 0 AND t.fperiodtype = ? \n").append(" AND t.forgtype = ? \n").append(this.appendTemplateTypeFilter("t", condition)).append(" AND (t.FTemplateType = 2 OR t.FTemplateType = 12 OR t.FTemplateType = 16) \n").append(" AND template.fid = t.FGroupTemplateID and company.fid = t.FCompanyID \n").append(" AND t.FCompanyID in(").append(paramSrv.getParamsSql()).append(")) \n").append(" UNION ALL \n").append(this.getSelectPart(ctx, false)).append(" FROM T_RPT_Template template \n").append(" LEFT JOIN T_PM_User AS creator ON template.FCreatorID = creator.FID \n").append(" LEFT JOIN T_PM_User AS  auditor ON template.FAuditorID = auditor.FID \n").append(" LEFT JOIN T_PM_User AS lastupdateuser ON template.FLastUpdateUserID =lastupdateuser.FID \n").append(" INNER JOIN t_org_BaseUnit AS company ON template.FCompanyID = company.FID \n").append(" WHERE template.FVersionStatus = 1 and template.fisfreezed = 0  \n").append(" and template.FPublishedStatus = 1 \n").append(this.appendTemplateTypeFilter("template", condition)).append(" AND template.fperiodtype = ? \n").append(" AND template.forgtype = ? \n").append(" AND template.fisK3Tpl = 0    \n");
        if (condition.getString("schemeId") != null) {
            schemeid = condition.getString("schemeId");
            sql.append(" AND template.FNumber in (SELECT tmp.FNumber FROM t_rpt_template tmp INNER JOIN T_CSL_RptWeaveSchmTempEntry schmTmpl ON schmTmpl.FTemplate = tmp.FID AND schmTmpl.FSchemeID = '" + schemeid + "') \n");
        }
        sql.append(" AND (template.FTemplateType = 2 OR template.FTemplateType = 12 OR template.FTemplateType = 16) \n");
        sql.append(" AND template.fcompanyid IN(").append(paramSrv.getParamsSql()).append(")) t \n");
        sql.append(" WHERE NOT EXISTS ( \n").append(" SELECT 'X' from ").append(tmplTable).append(" t1 \n").append(" WHERE t.tgroup = t1.tgroup AND t.companyID = t1.companyID) \n ");
        return sql;
    }

    private String getSelectPart(Context ctx, boolean isK3) {
        String lan = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer(500);
        sql.append(" SELECT template.FID ID,company.FID companyID,company.FName_" + lan + " companyName,\n").append(" CASE template.FTemplateType  WHEN 6 THEN 2 WHEN 10 THEN 12 \n").append(" WHEN 15 THEN 16 ELSE template.FTemplateType END AS sourceType, \n").append(" NULL AS rptNumber,NULL AS rptName,template.FperiodType periodType , CONVERT(DATETIME,NULL) as reportPeriod , \n").append(" -1 as fyear,-1 period,null AS currName,null AS sourceCurrName,-1 AS isSupportGroup, \n").append(" -1 as auditedStatus,-1 AS committedStatus,-1 AS convertStatus , \n").append(" template.FNumber tmplNumber,template.FName tmplName,template.FVersionNumber versionNumber , \n").append(" -1 AS isSupportAdjust,-1 AS publicStatus, -1 AS publishedStatus,lastupdateuser.FName_" + lan + " lastupdateuserName, \n").append(" template.FLastUpdateTime lastUpdateTime,auditor.FName_" + lan + " auditName,null AS commitorName ,\n").append(" CONVERT(DATETIME,NULL) as commitTime ,creator.FName_" + lan + " creatorName,template.FCreateTime createTime , \n").append(" 0 AS isReport," + (isK3 ? "d." : "template.") + "FGroup tgroup,template.FcreatorId creatorId\n");
        return sql.toString();
    }

    private Map getNextPageResult(Context ctx, RptProperties condition) throws BOSException, EASBizException {
        HashMap<String, RptRowSet> result = new HashMap<String, RptRowSet>();
        int from = condition.getInt("fetch_from");
        int length = condition.getInt("fetch_len");
        String tplTable = condition.getString("tplTable");
        RptRowSet rst = null;
        Connection con = null;
        SqlParams sp = new SqlParams();
        StringBuffer sql = new StringBuffer();
        this.checkCondition(condition);
        sql.append("select * from ").append(tplTable).append(" order by ").append(condition.getString("sortType"));
        try {
            con = this.getConnection(ctx);
            rst = DBUtil.executeQuery((String)sql.toString(), (SqlParams)sp, (int)from, (int)length, (Connection)con);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        result.put("rowSet", rst);
        return result;
    }

    private void checkCondition(RptProperties condition) {
        String sortStr = condition.getString("sortType");
        String[] strs = sortStr.split(" ");
        String str = strs[0];
        String[] checkStrs = sortStr.split(",");
        ArrayList<String> deleteList = new ArrayList<String>();
        for (int i = 0; i < checkStrs.length; ++i) {
            if (checkStrs[i].startsWith(str) && i != 0) continue;
            deleteList.add(checkStrs[i]);
        }
        sortStr = this.mergerSortCondition(deleteList);
        condition.setString("sortType", sortStr);
    }

    private String mergerSortCondition(List<String> deleteList) {
        StringBuilder str = new StringBuilder();
        if (deleteList.size() > 0) {
            for (int i = 0; i < deleteList.size(); ++i) {
                if (i == 0) {
                    str.append(deleteList.get(i)).append(" ");
                    continue;
                }
                str.append(",").append(" ").append(deleteList.get(i));
            }
        }
        return str.toString();
    }

    private void releaseTmplTable(Context ctx, RptProperties condition) {
        String tplTable = condition.getString("tplTable");
        if (this.isNewQuery(condition)) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tplTable);
        }
    }

    private boolean isNewQuery(RptProperties condition) {
        int from = condition.getInt("fetch_from");
        boolean isNotNeedQuery = condition.getBoolean("need_requery");
        return from <= 0 && !isNotNeedQuery;
    }

    private StringBuffer getInsertReportDataSQL(Context ctx, String tmplTable, RptProperties condition, ParamTempTblService paramSrv) throws BOSException {
        String lan = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer(500);
        sql.append(" INSERT INTO ").append(tmplTable).append(" \n").append(" SELECT rpt.FID ID,company.FID companyID,company.FName_" + lan + " companyName, \n").append(" rpt.FSourceType sourceType,rpt.FNumber rptNumber,rpt.FName rptName, \n").append(" rpt.FPeriodType periodType,rpt.FEndDate as reportPeriod,rpt.FYear Fyear,rpt.FPeriod period, \n").append(" curr.FName_" + lan + " currName,sourceCurr.FName_" + lan + " sourceCurrName, \n").append(" rpt.FIsSupportGroup isSupportGroup,rpt.FAuditedStatus auditedStatus, \n").append(" rpt.FCommittedStatus committedStatus,rpt.FConvertStatus convertStatus, \n").append(" tmpl.FNumber tmplNumber,tmpl.FName tmplName,tmpl.FVersionNumber versionNumber,\n").append(" rpt.FIsSupportAdjust isSupportAdjust,rpt.FPublicStatus publicStatus, \n").append(" rpt.FPublishedStatus publishedStatus,lastupdateuser.FName_" + lan + " lastupdateuserName,\n").append(" rpt.FLastUpdateTime lastUpdateTime,auditor.FName_" + lan + " auditName,commitor.FName_" + lan + " commitorName,\n").append(" rpt.FCommitTime commitTime,creator.FName_" + lan + " creatorName,rpt.FCreateTime createTime, \n").append(" 1 AS isReport,tmpl.FGroup tgroup,rpt.FcreatorId creatorId \n").append(" FROM t_rpt_report rpt \n").append(" JOIN t_org_BaseUnit company ON rpt.FCompanyID = company.FID \n").append(" LEFT JOIN t_rpt_template tmpl ON rpt.FTemplateID = tmpl.FID \n").append(" JOIN t_bd_currency curr ON rpt.FCurrencyID = curr.FID \n").append(" LEFT JOIN t_bd_currency sourceCurr ON rpt.FSourceCurrencyID = sourceCurr.FID \n").append(" LEFT JOIN t_pm_user auditor ON rpt.FAuditorID = auditor.FID \n").append(" LEFT JOIN t_pm_user commitor ON rpt.FCommitorID = commitor.FID \n").append(" LEFT JOIN t_pm_user creator ON rpt.FCreatorID = creator.FID \n").append(" LEFT JOIN t_pm_user lastupdateuser ON rpt.FLastUpdateUserID = lastupdateuser.FID \n").append(" WHERE rpt.FYear = ? AND rpt.FPeriod = ? AND rpt.FPeriodType = ? \n").append(" AND rpt.FOrgType = ? AND curr.FID = ? \n");
        if (condition.getString("schemeId") != null) {
            String schemeid = condition.getString("schemeId");
            sql.append(" AND company.FID in (SELECT schmOrg.FCompany FROM T_CSL_RptWeaveSchmCompEntry schmOrg WHERE schmOrg.FScheme = '" + schemeid + "' AND schmOrg.FCompany IN(" + paramSrv.getParamsSql() + ")) \n");
            sql.append(" AND tmpl.FNumber in (SELECT tmp.FNumber FROM t_rpt_template tmp INNER JOIN T_CSL_RptWeaveSchmTempEntry schmTmpl ON schmTmpl.FTemplate = tmp.FID AND schmTmpl.FSchemeID = '" + schemeid + "') \n");
            sql.append(" AND (tmpl.FTemplateType in (SELECT tmp.FTemplateType FROM t_rpt_template tmp INNER JOIN T_CSL_RptWeaveSchmTempEntry schmTmpl ON schmTmpl.FTemplate = tmp.FID AND schmTmpl.FSchemeID = '" + schemeid + "') \n");
            sql.append(" OR tmpl.FTemplateType in (2,12,16)) ");
        } else {
            sql.append(" AND company.FID in(").append(paramSrv.getParamsSql()).append(") \n");
        }
        sql.append(" AND rpt.FSourceType in(").append(this.getRptSourceTypeList(condition)).append(") \n").append(this.appendTemplateTypeFilter("tmpl", condition)).append(this.appendRptStateFilter("rpt", condition));
        return sql;
    }

    private int getOrgTypeVal(RptProperties condition) {
        int orgTypeVal = 1;
        if (condition.containsKey("orgType")) {
            OrgType orgType = (OrgType)condition.getObject("orgType");
            orgTypeVal = orgType == null ? 1 : orgType.getValue();
        }
        return orgTypeVal;
    }

    private String appendRptStateFilter(String alias, RptProperties condition) {
        StringBuffer filter = new StringBuffer();
        if (!this.isIncludGroupTmpl(condition)) {
            boolean isAll;
            Boolean[] stateBoolArr = (Boolean[])condition.getObject("stateBooleanVal");
            boolean doing = stateBoolArr[1];
            boolean audited = stateBoolArr[2];
            boolean committed = stateBoolArr[3];
            boolean bl = isAll = doing && audited && committed;
            if (!isAll) {
                int total = (doing ? 1 : 0) + (audited ? 3 : 0) + (committed ? 5 : 0);
                filter.append(" and (");
                if (1 == condition.getInt("dataType")) {
                    filter.append("(");
                }
                if (total == 1) {
                    filter.append(alias).append(".FauditedStatus = 1 ");
                } else if (total == 3) {
                    filter.append(alias).append(".FauditedStatus = 2 ");
                    filter.append(" and ").append(alias).append(".FcommittedStatus = 1 ");
                } else if (total == 5) {
                    filter.append(alias).append(".FcommittedStatus >= 2 ");
                } else if (total == 4) {
                    filter.append(alias).append(".FcommittedStatus = 1 ");
                } else if (total == 6) {
                    filter.append(alias).append(".FauditedStatus = 1 or ");
                    filter.append(alias).append(".FcommittedStatus >= 2 ");
                } else if (total == 8) {
                    filter.append(alias).append(".FauditedStatus = 2 ");
                } else {
                    return "";
                }
                filter.append(")");
                if (1 == condition.getInt("dataType")) {
                    filter.append(" or ").append(alias).append(".FSourceType  in(1,6))");
                }
            }
        }
        return filter.toString();
    }

    private String appendTemplateTypeFilter(String alias, RptProperties condition) {
        if (3 == condition.getInt("dataType") && condition.getString("displayType") != null) {
            return " AND " + alias + ".FDisplayTemplateTypeID = '" + condition.getString("displayType") + "'";
        }
        return "";
    }

    private String getRptSourceTypeList(RptProperties condition) {
        if (1 == condition.getInt("dataType")) {
            return "1,6,7,10,13";
        }
        if (3 == condition.getInt("dataType")) {
            return "7,10,13";
        }
        return "1,6";
    }

    private ParamTempTblService getCompanyIDParamSrv(Context ctx, Collection params) {
        TableInfo table = new TableInfo("tpl_org_IDs");
        table.addColumn("ID");
        return ParamTempTblService.getInstance((Context)ctx, (TableInfo)table, (Collection)params, null);
    }

    private String createTmplTable(Context ctx) throws BOSException {
        String tableName;
        StringBuffer createSql = new StringBuffer(300);
        createSql.append(" create table Tmp_ReportWorkTable_Table(").append(" ID VARCHAR(44),companyID VARCHAR(44),").append(" companyName NVARCHAR(80),sourceType INT,").append(" rptNumber NVARCHAR(80),rptName NVARCHAR(80),").append(" periodType INT,reportPeriod DateTime,year INT,period INT,").append(" currName NVARCHAR(80),sourceCurrName NVARCHAR(80),").append(" isSupportGroup INT,auditedStatus INT, committedStatus INT,").append(" convertStatus INT,tmplNumber NVARCHAR(80),tmplName NVARCHAR(80),").append(" versionNumber NVARCHAR(80),isSupportAdjust INT,").append(" publicStatus INT,publishedStatus INT,lastupdateuserName NVARCHAR(80),").append(" lastUpdateTime DateTime,auditorName NVARCHAR(80),commitorName NVARCHAR(80),").append(" commitTime DateTime,creatorName NVARCHAR(80),createTime DateTime,").append(" isReport INT,tgroup VARCHAR(44),creatorId VARCHAR(44))");
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            tableName = pool.createTempTable(createSql.toString());
            pool.createIndex(tableName, "isReport,tgroup", false, false);
            pool.createIndex(tableName, "auditedStatus,committedStatus", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    @Override
    protected TemplateCollection _getCompanyTemplate(Context ctx, Map params) throws BOSException, EASBizException {
        TemplateCollection tmp;
        TemplateCollection result = new TemplateCollection();
        if (params == null) {
            return result;
        }
        List selectPathIDs = (List)params.get("selectedPathId");
        ArrayList tempTypeList = (ArrayList)params.get("tempTypeList");
        boolean isAudited = params.get("isAudited") == null ? true : (Boolean)params.get("isAudited");
        boolean isRemovePublished = params.get("isRemovePublished") == null ? true : (Boolean)params.get("isRemovePublished");
        String companyPK = params.get("companyPK") == null ? ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString() : (String)params.get("companyPK");
        EntityViewInfo view = params.get("commonView") == null ? null : (EntityViewInfo)params.get("commonView");
        RptPeriodTypeEnum periodType = params.get("periodType") == null ? null : (RptPeriodTypeEnum)params.get("periodType");
        Integer year = params.get("year") == null ? 0 : (Integer)params.get("year");
        Integer period = params.get("period") == null ? 0 : (Integer)params.get("period");
        String currencyID = (String)params.get("currency");
        OrgType orgType = params.get("orgType") == null ? OrgType.Company : (OrgType)params.get("orgType");
        String schemeid = null;
        if (params.containsKey("schemeId")) {
            schemeid = (String)params.get("schemeId");
        }
        if (schemeid == null) {
            tmp = this.getCommonTemplateCollection(ctx, selectPathIDs, tempTypeList, isAudited, isRemovePublished, companyPK, view, orgType);
            if (tmp != null) {
                result.addCollection(tmp);
            }
            if ((tmp = this.getPublicTemplateCollection(ctx, companyPK, Arrays.asList(new Integer(1)), false, false, orgType)) != null) {
                result.addCollection(tmp);
            }
        }
        EntityViewInfo groupView = new EntityViewInfo();
        if (schemeid != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("schemeId", (Object)schemeid));
            groupView.setFilter(filter);
        }
        if ((tmp = this.getDispenseTemplateCollection(ctx, companyPK, true, true, false, orgType, groupView)) != null) {
            result.addCollection(tmp);
        }
        if (result.size() > 0) {
            this.filterTemplateByPeriodType(periodType, result);
        }
        if (result.size() > 0) {
            this.handleHasReportTemplate(ctx, result, year, period, periodType, companyPK, currencyID);
            this.excludeOutOfOrgBoundTemplate(ctx, result, year, period, periodType, companyPK);
        }
        return result;
    }

    private void excludeOutOfOrgBoundTemplate(Context ctx, TemplateCollection tmplCol, Integer year, Integer period, RptPeriodTypeEnum periodType, String companyPK) throws EASBizException, BOSException {
        String[] orgBoundIDs = this.getInsideTimestampOrgBoundIDs(ctx, year, period, periodType.getValue());
        if (orgBoundIDs == null || orgBoundIDs.length <= 0) {
            return;
        }
        HashSet<String> setIDs = new HashSet<String>(tmplCol.size());
        for (int i = 0; i < tmplCol.size(); ++i) {
            if (!this.isGrpTmplAndNotDoRpt(tmplCol.get(i))) continue;
            setIDs.add(tmplCol.get(i).getGroupTemplate() == null ? tmplCol.get(i).getId().toString() : tmplCol.get(i).getGroupTemplate().getId().toString());
        }
        if (setIDs.size() == 0) {
            return;
        }
        ParamTempTblService paramSrv = this.getCompanyIDParamSrv(ctx, setIDs);
        StringBuffer sql = new StringBuffer(300);
        sql.append(" select distinct fdispensesrcid from t_csl_templetdispense dis \n").append(" where dis.fdispensesrcid in(").append(paramSrv.getParamsSql()).append(") \n").append(" and dis.fcompanyid = '").append(companyPK).append("' \n").append(" and dis.forgBoundId in(").append(CslRptUtil.AryToItemString(Arrays.asList(orgBoundIDs))).append(")");
        long startTime = System.currentTimeMillis();
        IRowSet rs = DbUtil.executeQuery(ctx, sql.toString());
        logger.info((Object)("RptNewUIHandleFacadeControllerBean.excludeOutOfOrgBoundTemplate2():" + (System.currentTimeMillis() - startTime)));
        System.out.println("RptNewUIHandleFacadeControllerBean.excludeOutOfOrgBoundTemplate2():" + (System.currentTimeMillis() - startTime));
        if (rs != null) {
            setIDs.clear();
            try {
                while (rs.next()) {
                    setIDs.add(rs.getString("fdispensesrcid"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        int size = tmplCol.size();
        for (int i = size - 1; i >= 0; --i) {
            if (!this.isGrpTmplAndNotDoRpt(tmplCol.get(i)) || setIDs.contains(tmplCol.get(i).getGroupTemplate() == null ? tmplCol.get(i).getId().toString() : tmplCol.get(i).getGroupTemplate().getId().toString())) continue;
            tmplCol.remove(tmplCol.get(i));
        }
        paramSrv.release();
    }

    private boolean isGrpTmplAndNotDoRpt(TemplateInfo info) {
        Object hasReport = info.get("hasReport");
        return RptNewUIUtil.isGroupTemplate(info.getTemplateType()) && (hasReport == null || hasReport != null && (Integer)hasReport == 0);
    }

    private void handleHasReportTemplate(Context ctx, TemplateCollection tmplCol, Integer year, Integer period, RptPeriodTypeEnum periodType, String companyPK, String currencyID) throws BOSException {
        Map<String, String> grpIDsMap = RptNewUIUtil.collectGrpIDsMap(ctx, tmplCol, true);
        ReportCollection rptCol = RptNewUIUtil.getReportCollByTmplGroupID(ctx, null, new HashSet<String>(grpIDsMap.values()), periodType, year, period, companyPK, currencyID);
        RptNewUIUtil.setReportTag2Template(rptCol, tmplCol, grpIDsMap);
    }

    private void filterTemplateByPeriodType(RptPeriodTypeEnum periodType, TemplateCollection tmplCol) {
        if (periodType == null) {
            return;
        }
        Object[] obj = tmplCol.toArray();
        for (int k = 0; k < obj.length; ++k) {
            if (periodType.equals((Object)((TemplateInfo)obj[k]).getPeriodType())) continue;
            tmplCol.remove((TemplateInfo)obj[k]);
        }
    }

    private TemplateCollection getDispenseTemplateCollection(Context ctx, String companyPK, boolean isRemovePublished, boolean isOnlyUnversion, boolean isShowFreezed, OrgType orgType) throws EASBizException, BOSException {
        return TemplateFactory.getLocalInstance((Context)ctx).getTreeDispenseData2(companyPK, isRemovePublished, isOnlyUnversion, isShowFreezed, new ArrayList<Object>(Arrays.asList(RptTmpTypeEnum.RPTDYNAMICREPORT, RptTmpTypeEnum.MULTIRPTDYNAMICREPORT, RptTmpTypeEnum.GROUPCOMMREPORT, orgType)), null);
    }

    private TemplateCollection getDispenseTemplateCollection(Context ctx, String companyPK, boolean isRemovePublished, boolean isOnlyUnversion, boolean isShowFreezed, OrgType orgType, EntityViewInfo view) throws EASBizException, BOSException {
        return TemplateFactory.getLocalInstance((Context)ctx).getTreeDispenseData2(companyPK, isRemovePublished, isOnlyUnversion, isShowFreezed, new ArrayList<Object>(Arrays.asList(RptTmpTypeEnum.RPTDYNAMICREPORT, RptTmpTypeEnum.MULTIRPTDYNAMICREPORT, RptTmpTypeEnum.GROUPCOMMREPORT, orgType)), view);
    }

    private TemplateCollection getPublicTemplateCollection(Context ctx, String companyID, List versionTypeList, boolean isShowUnpublish, boolean isShowUnaudit, OrgType orgType) throws EASBizException, BOSException {
        versionTypeList = this.addOrgType2List(versionTypeList, orgType);
        IRowSet rowSet = TemplateFactory.getLocalInstance((Context)ctx).getRowSetForPublicTemplate(companyID, versionTypeList, isShowUnpublish, isShowUnaudit, null);
        TemplateCollection result = new TemplateCollection();
        try {
            while (rowSet.next()) {
                TemplateInfo info = new TemplateInfo();
                info.setId(BOSUuid.read((String)rowSet.getString("TEMPLATE.ID")));
                info.setName(rowSet.getString("TEMPLATE.NAME"));
                info.setNumber(rowSet.getString("TEMPLATE.NUMBER"));
                info.setPeriodType(RptPeriodTypeEnum.getEnum((int)rowSet.getInt("TEMPLATE.PERIODTYPE")));
                info.setTemplateType(RptTmpTypeEnum.getEnum((int)rowSet.getInt("TEMPLATE.TEMPLATETYPE")));
                info.setVersionNumber(rowSet.getString("VERSIONNUMBER"));
                info.setGroup(rowSet.getString("TEMPLATE.GROUP"));
                info.setAuditedStatus(AuditedStatusEnum.getEnum((int)rowSet.getInt("AUDITEDSTATUS")));
                info.setPublishedStatus(PublishedStatusEnum.getEnum((int)rowSet.getInt("PUBLISHEDSTATUS")));
                result.add(info);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    private List addOrgType2List(List lst, OrgType orgType) {
        lst = lst == null ? new ArrayList<OrgType>() : new ArrayList(lst);
        lst.add(orgType);
        return lst;
    }

    private TemplateCollection getCommonTemplateCollection(Context ctx, List selectedPathId, ArrayList tempTypeList, boolean needAudited, boolean isRemovePublished, String companyPK, EntityViewInfo commonView, OrgType orgType) throws EASBizException, BOSException {
        List ids = this.getCommonTemplateIDs(ctx, selectedPathId, tempTypeList, needAudited, isRemovePublished, companyPK, commonView, orgType);
        if (ids != null && ids.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("number"));
            view.getSelector().add(new SelectorItemInfo("name"));
            view.getSelector().add(new SelectorItemInfo("templateType"));
            view.getSelector().add(new SelectorItemInfo("versionNumber"));
            view.getSelector().add(new SelectorItemInfo("periodType"));
            view.getSelector().add(new SelectorItemInfo("group"));
            view.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
            return TemplateFactory.getLocalInstance((Context)ctx).getTemplateCollection(view);
        }
        return null;
    }

    private List getCommonTemplateIDs(Context ctx, List selectedPathId, List tempTypeList, boolean needAudited, boolean isRemovePublished, String companyPK, EntityViewInfo commonView, OrgType orgType) throws EASBizException, BOSException {
        tempTypeList = this.addOrgType2List(tempTypeList, orgType);
        String permissionContidion = null;
        boolean usingDiscretePermission = this.isDiscretePermItem("2D527D45", ctx);
        if (usingDiscretePermission && OrgType.Company.equals((Object)orgType)) {
            String companyid = companyPK == null ? ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString() : companyPK;
            permissionContidion = PermissionFactory.getLocalInstance((Context)ctx).getQueryPermissionSQL((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()), (IObjectPK)new ObjectUuidPK(companyid), "rpt_template_view");
            permissionContidion = "in (" + permissionContidion + ")";
        }
        return TemplateFactory.getLocalInstance((Context)ctx).getTemplateIds(selectedPathId, (ArrayList)tempTypeList, needAudited, isRemovePublished, companyPK, commonView, permissionContidion);
    }

    private boolean isDiscretePermItem(String bostype, Context ctx) {
        try {
            return InitDataFacadaFactory.getLocalInstance((Context)ctx).isDiscretePermItem(bostype);
        }
        catch (BOSException e) {
            return false;
        }
    }

    @Override
    protected TemplateCollection _getCompanyAllTemplate(Context ctx, Map params) throws EASBizException, BOSException {
        String companyPK = params.get("companyPK") == null ? ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString() : (String)params.get("companyPK");
        OrgType orgType = (OrgType)params.get("orgType");
        HashSet<String> IDs = new HashSet<String>();
        TemplateCollection tmplCol = this.getDispenseTemplateCollection(ctx, companyPK, false, false, false, orgType);
        this.collectTemplateIDs(tmplCol, IDs);
        TemplateCollection tempCol = tmplCol;
        tmplCol = this.getPublicTemplateCollection(ctx, companyPK, Arrays.asList(0, 1), true, true, orgType);
        this.collectTemplateIDs(tmplCol, IDs);
        ArrayList<RptTmpTypeEnum> templateType = new ArrayList<RptTmpTypeEnum>();
        templateType.add(RptTmpTypeEnum.COMMONREPORT);
        EntityViewInfo commonView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBatchReport", (Object)"true"));
        commonView.setFilter(filter);
        List commonIds = this.getCommonTemplateIDs(ctx, null, templateType, false, false, companyPK, commonView, orgType);
        if (commonIds != null) {
            IDs.addAll(commonIds);
        }
        if (IDs.size() == 0) {
            return new TemplateCollection();
        }
        tmplCol = this.getTemplateCollectionByIDs(ctx, IDs);
        this.synchroInfo(tmplCol, tempCol);
        return tmplCol;
    }

    private void synchroInfo(TemplateCollection src, TemplateCollection des) {
        if (src == null || des == null) {
            return;
        }
        int srcSize = src.size();
        int desSize = des.size();
        block0: for (int i = 0; i < srcSize; ++i) {
            for (int k = 0; k < desSize; ++k) {
                if (!src.get(i).getId().toString().equals(des.get(k).getId().toString())) continue;
                src.get(i).setIsAllowSubCompanyModify(des.get(k).isIsAllowSubCompanyModify());
                continue block0;
            }
        }
    }

    private TemplateCollection getTemplateCollectionByIDs(Context ctx, Set<String> IDs) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selCol = this.getSelectorItemCollection();
        SorterItemCollection sortor = new SorterItemCollection();
        sortor.add(new SorterItemInfo("templateType"));
        sortor.add(new SorterItemInfo("number"));
        sortor.add(new SorterItemInfo("name"));
        view.setSorter(sortor);
        view.setSelector(selCol);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", IDs, CompareType.INCLUDE));
        view.setFilter(filter);
        return TemplateFactory.getLocalInstance((Context)ctx).getTemplateCollection(view);
    }

    private void collectTemplateIDs(TemplateCollection tmplCol, Set<String> IDs) {
        if (tmplCol == null) {
            return;
        }
        for (int i = 0; i < tmplCol.size(); ++i) {
            IDs.add(tmplCol.get(i).getId().toString());
        }
    }

    private SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection selCol = new SelectorItemCollection();
        selCol.add("id");
        selCol.add("number");
        selCol.add("name");
        selCol.add("isAllowSubCompanyModify");
        selCol.add("templateType");
        selCol.add("versionNumber");
        selCol.add("templateSource");
        selCol.add("periodType");
        selCol.add("isGroup");
        selCol.add("company.name");
        selCol.add("groupCompany.name");
        selCol.add("lastUpdateUser.name");
        selCol.add("lastUpdateTime");
        selCol.add("publishedStatus");
        selCol.add("auditedStatus");
        selCol.add("auditor.name");
        selCol.add("canClosePeriod");
        selCol.add("CheckOpenPeriod");
        selCol.add("isAllowChange");
        selCol.add("creator.name");
        selCol.add("createTime");
        selCol.add("displayTemplateType.id");
        return selCol;
    }

    @Override
    protected boolean _isExistGuide(Context ctx, String UIClassName) throws BOSException, EASBizException {
        String sql = "SELECT FISNEEDNOTICE FROM T_CSL_HELPGUIDE where FUICLASSNAME='" + UIClassName + "' AND FUSERID ='" + ctx.getCaller().toString() + "'";
        IRowSet rs = DbUtil.executeQuery(ctx, sql);
        if (rs == null || rs.size() == 0) {
            return false;
        }
        try {
            if (rs.next()) {
                boolean isNeedNotice = rs.getBoolean("FISNEEDNOTICE");
                if (isNeedNotice) {
                    DbUtil.execute(ctx, "UPDATE  T_CSL_HELPGUIDE SET FISNEEDNOTICE = 0 WHERE FUICLASSNAME='" + UIClassName + "' AND FUSERID ='" + ctx.getCaller().toString() + "'");
                }
                return !isNeedNotice;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    @Override
    protected void _saveGuide(Context ctx, String UIClassName) throws BOSException, EASBizException {
        boolean isExistGuide;
        String sql = "SELECT FISNEEDNOTICE FROM T_CSL_HELPGUIDE where FUICLASSNAME='" + UIClassName + "' AND FUSERID ='" + ctx.getCaller().toString() + "'";
        IRowSet rs = DbUtil.executeQuery(ctx, sql);
        boolean bl = isExistGuide = rs != null && rs.size() != 0;
        if (isExistGuide) {
            sql = "UPDATE  T_CSL_HELPGUIDE SET FISNEEDNOTICE = 0,FVIEWCOUNT=FVIEWCOUNT+1 WHERE FUICLASSNAME='" + UIClassName + "' AND FUSERID ='" + ctx.getCaller().toString() + "'";
            DbUtil.execute(ctx, sql);
        } else {
            Timestamp currTime = new Timestamp(System.currentTimeMillis());
            String uuid = BOSUuid.create((String)"0758F09F").toString();
            sql = "INSERT INTO T_CSL_HELPGUIDE VALUES(?,?,?,?,?,?,?)";
            Object[] params = new Object[]{uuid, ctx.getCaller().toString(), 0, UIClassName, 1, currTime, currTime};
            DbUtil.execute(ctx, sql, params);
        }
    }

    protected CompanyOrgUnitInfo _getDelegateCompanyOrgUnit(Context ctx, IObjectPK pk, OrgType orgType) throws BOSException, EASBizException {
        if (orgType == null) {
            throw new IllegalArgumentException("OrgType is null!");
        }
        if (OrgType.Company.equals((Object)orgType)) {
            return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(pk);
        }
        return null;
    }

    @Override
    protected IRowSet _getAuthorizedOrg(Context ctx, IObjectPK userPK, String[] permItems, OrgType orgType, RptProperties pros) throws BOSException, EASBizException {
        this._pros = pros;
        return this.getAuthorizedOrg(ctx, userPK, permItems, orgType);
    }
}

