/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.cslworktable.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataElementFactory;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletFactory;
import com.kingdee.eas.fi.gr.cslrpt.InvestTempletInfo;
import com.kingdee.eas.fi.gr.cslrpt.OperateSymbolEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.investworkpaper.LogicFlagEnum;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneFactory;
import com.kingdee.eas.fi.newrpt.investworkpaper.SceneInfo;
import com.kingdee.eas.fi.newrpt.investworkpaper.TemplateEntryInfo;
import com.kingdee.eas.fi.newrpt.investworkpaper.TriggerConditionEntryInfo;
import com.kingdee.eas.fi.newrpt.investworkpaper.TriggerConditionFactory;
import com.kingdee.eas.fi.newrpt.investworkpaper.TriggerConditionInfo;
import com.kingdee.eas.fi.newrpt.investworkpaper.VerifyRelationInfo;
import com.kingdee.eas.fi.rpt.DisplayTemplateTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateTypeInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class SceneImport
extends AbstractDataTransmission {
    private Map cachedTemplateType = new HashMap();
    private Map cachedTriggerCondition = new HashMap();
    private Map cachedInvestTemplate = new HashMap();
    private Map cachedRptItem = new HashMap();
    private Map cachedDataElement = new HashMap();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return SceneFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String sceneNumber = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)"FNumber")).data;
        if (StringUtils.isEmpty((String)sceneNumber)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"56_sceneNumNull", (Locale)ctx.getOriginLocale()));
        }
        String sceneName = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)"FName")).data;
        if (StringUtils.isEmpty((String)sceneNumber)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"57_sceneNameNull", (Locale)ctx.getOriginLocale()));
        }
        String sceneDes = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)"FDescription")).data;
        String sceneIsFreezed = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)"FIsFreezed")).data;
        if (StringUtils.isEmpty((String)sceneIsFreezed)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"58_sceneFreezeNull", (Locale)ctx.getOriginLocale()));
        }
        boolean isFreezed = this.getBooleanFromAlias(sceneIsFreezed, ctx);
        String sceneTypeLongNumber = (String)((DataToken)((Hashtable)hsData.get((Object)new Integer((int)0))).get((Object)"FSceneType")).data;
        TemplateTypeInfo templateTypeInfo = null;
        if (StringUtils.isEmpty((String)sceneTypeLongNumber)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"59_sceneTypeNull", (Locale)ctx.getOriginLocale()));
        }
        templateTypeInfo = this.getTemplateTypeInfo(ctx, sceneTypeLongNumber, DisplayTemplateTypeEnum.SCENE);
        if (templateTypeInfo == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"60_sceneTypeError", (Locale)ctx.getOriginLocale()));
        }
        SceneInfo sceneInfo = new SceneInfo();
        sceneInfo.setNumber(sceneNumber);
        sceneInfo.setName(sceneName);
        sceneInfo.setDescription(sceneDes);
        sceneInfo.setIsFreezed(isFreezed);
        sceneInfo.setDisplayTemplateType(templateTypeInfo);
        Hashtable entryData = null;
        String leftBracket = null;
        TriggerConditionInfo triggerConditioninfo = null;
        String rightBracket = null;
        LogicFlagEnum logicFlagEnum = null;
        ArrayList<TriggerConditionEntryInfo> tcEntrys = new ArrayList<TriggerConditionEntryInfo>();
        for (int i = 0; i < hsData.size(); ++i) {
            entryData = (Hashtable)hsData.get(new Integer(i));
            leftBracket = (String)((DataToken)entryData.get((Object)"FLeftBracket")).data;
            String triggerConditionNumber = (String)((DataToken)entryData.get((Object)"FTriggerCondition")).data;
            if (StringUtils.isEmpty((String)triggerConditionNumber)) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"61_triggerConditionNull", (Locale)ctx.getOriginLocale()));
            }
            triggerConditioninfo = this.getTriggerCondition(ctx, triggerConditionNumber);
            if (triggerConditioninfo == null) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"62_triggerConditionError", (Locale)ctx.getOriginLocale()));
            }
            rightBracket = (String)((DataToken)entryData.get((Object)"FRightBracket")).data;
            String logicFlag = (String)((DataToken)entryData.get((Object)"FLogicFlag")).data;
            if (!StringUtils.isEmpty((String)logicFlag) && (logicFlagEnum = this.getLogicFlagEnum(ctx, logicFlag)) == null) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"63_logicFlagError", (Locale)ctx.getOriginLocale()));
            }
            TriggerConditionEntryInfo entryInfo = new TriggerConditionEntryInfo();
            entryInfo.setLeftBracket(leftBracket);
            entryInfo.setTriggerCondition(triggerConditioninfo);
            entryInfo.setRightBracket(rightBracket);
            entryInfo.setLogicFlag(logicFlagEnum);
            entryInfo.setScene(sceneInfo);
            if (tcEntrys.contains(entryInfo)) continue;
            tcEntrys.add(entryInfo);
        }
        if (tcEntrys.size() > 0) {
            int size = tcEntrys.size();
            for (int j = 0; j < size; ++j) {
                TriggerConditionEntryInfo tcInfo = (TriggerConditionEntryInfo)tcEntrys.get(j);
                tcInfo.setSeq(j + 1);
                sceneInfo.getTriggerConditionEtries().add(tcInfo);
            }
        }
        Hashtable investTemplateData = null;
        InvestTempletInfo investTemplateInfo = null;
        ArrayList<TemplateEntryInfo> tmplEntrys = new ArrayList<TemplateEntryInfo>();
        for (int i = 0; i < hsData.size(); ++i) {
            investTemplateData = (Hashtable)hsData.get(new Integer(i));
            String investTemplateNumber = (String)((DataToken)investTemplateData.get((Object)"FTemplate")).data;
            if (StringUtils.isEmpty((String)investTemplateNumber)) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"64_investTmplNull", (Locale)ctx.getOriginLocale()));
            }
            investTemplateInfo = this.getInvestTemplateInfo(ctx, investTemplateNumber);
            if (investTemplateInfo == null) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"65_investTmplError", (Locale)ctx.getOriginLocale()));
            }
            TemplateEntryInfo TemplateEntryInfo2 = new TemplateEntryInfo();
            TemplateEntryInfo2.setTemplate(investTemplateInfo);
            TemplateEntryInfo2.setScene(sceneInfo);
            if (tmplEntrys.contains(TemplateEntryInfo2)) continue;
            tmplEntrys.add(TemplateEntryInfo2);
        }
        if (tmplEntrys.size() > 0) {
            int size = tmplEntrys.size();
            for (int j = 0; j < size; ++j) {
                TemplateEntryInfo tmplInfo = (TemplateEntryInfo)tmplEntrys.get(j);
                tmplInfo.setSeq(j + 1);
                sceneInfo.getTemplateEtries().add(tmplInfo);
            }
        }
        Hashtable verifyRelaData = null;
        RPTItemInfo rptItemInfo = null;
        DataElementInfo dataElementInfo = null;
        OperateSymbolEnum operateSymbolEnum = null;
        Object amount = null;
        String verifyTips = null;
        ArrayList<VerifyRelationInfo> verifyRelaEntrys = new ArrayList<VerifyRelationInfo>();
        for (int i = 0; i < hsData.size(); ++i) {
            verifyRelaData = (Hashtable)hsData.get(new Integer(i));
            String rptItemNumber = (String)((DataToken)verifyRelaData.get((Object)"FRptItem")).data;
            if (!StringUtils.isEmpty((String)rptItemNumber) && (rptItemInfo = this.getRPTItemInfo(ctx, rptItemNumber)) == null) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"66_rptItemError", (Locale)ctx.getOriginLocale()));
            }
            String dataElementNumber = (String)((DataToken)verifyRelaData.get((Object)"FDataElement")).data;
            if (!StringUtils.isEmpty((String)dataElementNumber) && (dataElementInfo = this.getDataElementInfo(ctx, dataElementNumber)) == null) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"67_dataElementError", (Locale)ctx.getOriginLocale()));
            }
            String operateSymbol = (String)((DataToken)verifyRelaData.get((Object)"FOperateSymbol")).data;
            if (!StringUtils.isEmpty((String)operateSymbol) && (operateSymbolEnum = this.getOperateSymbolEnum(ctx, operateSymbol)) == null) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.investworkpaper.InvestElimManuScriptResource", (String)"68_operateSymbolError", (Locale)ctx.getOriginLocale()));
            }
            String amountStr = (String)((DataToken)verifyRelaData.get((Object)"FAmount")).data;
            verifyTips = (String)((DataToken)verifyRelaData.get((Object)"FVerifyTips")).data;
            if (StringUtils.isEmpty((String)rptItemNumber)) continue;
            VerifyRelationInfo verifyRelationInfo = new VerifyRelationInfo();
            verifyRelationInfo.setRptItem(rptItemInfo);
            verifyRelationInfo.setDataElement(dataElementInfo);
            verifyRelationInfo.setOperateSymbol(operateSymbolEnum);
            verifyRelationInfo.setAmount(amountStr);
            verifyRelationInfo.setVerifyTips(verifyTips);
            verifyRelationInfo.setScene(sceneInfo);
            if (verifyRelaEntrys.contains(verifyRelationInfo)) continue;
            verifyRelaEntrys.add(verifyRelationInfo);
        }
        if (verifyRelaEntrys.size() > 0) {
            int size = verifyRelaEntrys.size();
            for (int j = 0; j < size; ++j) {
                VerifyRelationInfo verifyRelaInfo = (VerifyRelationInfo)verifyRelaEntrys.get(j);
                verifyRelaInfo.setSeq(j + 1);
                sceneInfo.getVerifyRelation().add(verifyRelaInfo);
            }
        }
        if (ContextUtil.getCurrentOrgUnit((Context)ctx) != null) {
            try {
                ObjectStringPK companyPK = new ObjectStringPK(ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString());
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)companyPK);
                sceneInfo.setTrackRecordCreator(company);
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        return sceneInfo;
    }

    private OperateSymbolEnum getOperateSymbolEnum(Context ctx, String name) {
        Iterator iterator = OperateSymbolEnum.iterator();
        while (iterator.hasNext()) {
            OperateSymbolEnum operateSymbolEnum = (OperateSymbolEnum)iterator.next();
            if (!operateSymbolEnum.getAlias(ctx.getOriginLocale()).equals(name)) continue;
            return operateSymbolEnum;
        }
        return null;
    }

    private DataElementInfo getDataElementInfo(Context ctx, String dataElementNumber) throws TaskExternalException {
        try {
            if (this.cachedDataElement.containsKey(dataElementNumber)) {
                return (DataElementInfo)this.cachedDataElement.get(dataElementNumber);
            }
            DataElementInfo info = DataElementFactory.getLocalInstance((Context)ctx).getDataElementInfo("where number = '" + dataElementNumber + "'");
            this.cachedDataElement.put(dataElementNumber, info);
            return info;
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private RPTItemInfo getRPTItemInfo(Context ctx, String rptItemNumber) throws TaskExternalException {
        try {
            if (this.cachedRptItem.containsKey(rptItemNumber)) {
                return (RPTItemInfo)this.cachedRptItem.get(rptItemNumber);
            }
            RPTItemInfo info = RPTItemFactory.getLocalInstance((Context)ctx).getRPTItemInfo("where number = '" + rptItemNumber + "'");
            this.cachedRptItem.put(rptItemNumber, info);
            return info;
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private InvestTempletInfo getInvestTemplateInfo(Context ctx, String investTemplateNumber) throws TaskExternalException {
        try {
            if (this.cachedInvestTemplate.containsKey(investTemplateNumber)) {
                return (InvestTempletInfo)this.cachedInvestTemplate.get(investTemplateNumber);
            }
            InvestTempletInfo info = InvestTempletFactory.getLocalInstance((Context)ctx).getInvestTempletInfo("where number = '" + investTemplateNumber + "'");
            this.cachedInvestTemplate.put(investTemplateNumber, info);
            return info;
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private LogicFlagEnum getLogicFlagEnum(Context ctx, String name) {
        Iterator iterator = LogicFlagEnum.iterator();
        while (iterator.hasNext()) {
            LogicFlagEnum operateSymbolEnum = (LogicFlagEnum)((Object)iterator.next());
            if (!operateSymbolEnum.getAlias(ctx.getOriginLocale()).equals(name)) continue;
            return operateSymbolEnum;
        }
        return null;
    }

    private TriggerConditionInfo getTriggerCondition(Context ctx, String triggerConditionNumber) throws TaskExternalException {
        try {
            if (this.cachedTriggerCondition.containsKey(triggerConditionNumber)) {
                return (TriggerConditionInfo)this.cachedTriggerCondition.get(triggerConditionNumber);
            }
            TriggerConditionInfo info = TriggerConditionFactory.getLocalInstance(ctx).getTriggerConditionInfo("where number = '" + triggerConditionNumber + "'");
            this.cachedTriggerCondition.put(triggerConditionNumber, info);
            return info;
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private TemplateTypeInfo getTemplateTypeInfo(Context ctx, String longNumber, DisplayTemplateTypeEnum templateType) throws TaskExternalException {
        if (this.cachedTemplateType.containsKey(longNumber + new Integer(templateType.getValue()).toString())) {
            return (TemplateTypeInfo)this.cachedTemplateType.get(longNumber + new Integer(templateType.getValue()).toString());
        }
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select fid, flongnumber, FReportType");
            sql.append(" from T_RPT_TemplateType where flongnumber = ? and FReportType = ?");
            IRowSet rs = DbUtil.executeQuery(ctx, sql.toString(), new Object[]{longNumber, new Integer(templateType.getValue())});
            TemplateTypeInfo templateTypeInfo = null;
            if (rs != null && rs.next()) {
                templateTypeInfo = new TemplateTypeInfo();
                templateTypeInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                templateTypeInfo.setLongNumber(rs.getString("flongnumber"));
                templateTypeInfo.setReportType(DisplayTemplateTypeEnum.getEnum((int)rs.getInt("FReportType")));
                this.cachedTemplateType.put(longNumber + new Integer(templateType.getValue()).toString(), templateTypeInfo);
            }
            return templateTypeInfo;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private boolean getBooleanFromAlias(String bool, Context ctx) {
        if (StringUtils.isEmpty((String)bool)) {
            return false;
        }
        String upperCase = bool.toUpperCase(Locale.ENGLISH);
        return ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptItem_Yes", (Locale)ctx.getOriginLocale()).equals(upperCase) || ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"RptItem_True", (Locale)ctx.getOriginLocale()).equals(upperCase) || "Y".equals(upperCase) || "TRUE".equals(upperCase);
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            this.setData(result, "FNumber", rs.getObject("number"));
            this.setData(result, "FName", rs.getObject("name"));
            this.setData(result, "FDescription", rs.getObject("description"));
            if (rs.getBoolean("isFreezed")) {
                result.put("FIsFreezed", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"793_RptItemDataImport", (Locale)ctx.getOriginLocale()));
            } else {
                result.put("FIsFreezed", ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"794_RptItemDataImport", (Locale)ctx.getOriginLocale()));
            }
            this.setData(result, "FSceneType", rs.getObject("displayTemplateType.longNumber"));
            this.setData(result, "FLeftBracket", rs.getObject("triggerConditionEtries.leftBracket"));
            this.setData(result, "FTriggerCondition", rs.getObject("triggerCondition.number"));
            this.setData(result, "FRightBracket", rs.getObject("triggerConditionEtries.rightBracket"));
            this.setData(result, "FLogicFlag", rs.getString("triggerConditionEtries.logicFlag") != null ? LogicFlagEnum.getEnum(rs.getString("triggerConditionEtries.logicFlag")).getAlias(ctx.getOriginLocale()) : null);
            this.setData(result, "FTemplate", rs.getObject("template.number"));
            this.setData(result, "FRptItem", rs.getObject("rptItem.number"));
            this.setData(result, "FDataElement", rs.getObject("dataElement.number"));
            this.setData(result, "FOperateSymbol", rs.getObject("verifyRelation.operateSymbol") != null ? OperateSymbolEnum.getEnum((int)rs.getInt("verifyRelation.operateSymbol")).getAlias() : null);
            this.setData(result, "FAmount", rs.getObject("verifyRelation.amount"));
            this.setData(result, "FVerifyTips", rs.getObject("verifyRelation.verifyTips"));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void setData(Hashtable result, String key, Object value) {
        if (value != null) {
            if (value instanceof BigDecimal) {
                result.put(key, CslRptUtil.ReduceBigDecimalZeros((BigDecimal)((BigDecimal)value)));
            } else {
                result.put(key, value.toString());
            }
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.newrpt.investworkpaper.SceneForExportQuery";
    }

    public String getMainField() {
        return "FNumber";
    }

    public int getSubmitType() {
        return 1;
    }

    public void setContextParameter(Hashtable param) {
        param.put("mainQueryPK", MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fi.newrpt.investworkpaper.SceneForExportQuery"));
        super.setContextParameter((Map)param);
    }
}

