/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.cslworktable.util.context;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.eas.fi.newrpt.RptNewUIUtil;
import com.kingdee.eas.fi.newrpt.client.rptnewui.rptprop.ReportCondition;
import com.kingdee.eas.fi.newrpt.cslworktable.util.context.CslTmplNodeUserDefineInfo;
import com.kingdee.eas.fi.rpt.ReportCollection;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CslTmplQueryDataCache {
    private Map<CacheState, List<CslTmplNodeUserDefineInfo>> cache = new HashMap<CacheState, List<CslTmplNodeUserDefineInfo>>();

    public boolean hasCache(String cacheKey) {
        if (StringUtil.isEmpty((String)cacheKey)) {
            return false;
        }
        CacheState state = this.find(cacheKey);
        if (state == null) {
            return false;
        }
        return state._isCache;
    }

    public void cacheQueryData(String cacheKey, List rs) throws SQLException {
        ArrayList<CslTmplNodeUserDefineInfo> cacheLst = new ArrayList<CslTmplNodeUserDefineInfo>();
        if (rs != null && rs.size() > 0) {
            for (Map map : rs) {
                CslTmplNodeUserDefineInfo info = new CslTmplNodeUserDefineInfo();
                info.setTmplID(String.valueOf(map.get("id")));
                info.setTmplName(String.valueOf(map.get("name")));
                info.setTmplNumber(String.valueOf(map.get("templatenumber")));
                info.setTmplVersionNum(String.valueOf(map.get("templateVersion")));
                info.setPeriodType(RptPeriodTypeEnum.getEnum((int)Integer.valueOf(String.valueOf(map.get("periodtype")))));
                info.setTmplType(Integer.valueOf(String.valueOf(map.get("rpttype"))));
                int isTemplate = Integer.valueOf(map.get("istemplate").toString());
                info.setTemplate(isTemplate == 1);
                cacheLst.add(info);
            }
        }
        CacheState cacheState = this.find(cacheKey);
        this.cache.remove(cacheState);
        Collections.sort(cacheLst, new TmplComparator());
        this.cache.put(new CacheState(cacheKey, true), cacheLst);
    }

    public void loadReport2TmplNode(String cacheKey, ReportCondition condition) throws BOSException {
        RptPeriodTypeEnum periodType = condition.getPeriodType();
        List<CslTmplNodeUserDefineInfo> lst = this.getDataFromCache(cacheKey, periodType);
        if (lst == null || lst.size() == 0) {
            return;
        }
        this.loadTmplNode(lst, condition);
    }

    public void loadReport2AllTmplNode(ReportCondition condition) throws BOSException {
        if (this.cache.size() == 0) {
            return;
        }
        ArrayList<CslTmplNodeUserDefineInfo> col = new ArrayList<CslTmplNodeUserDefineInfo>();
        Iterator<List<CslTmplNodeUserDefineInfo>> it = this.cache.values().iterator();
        while (it.hasNext()) {
            col.addAll(this.getHasNodeOfTmplLst(it.next(), condition.getPeriodType()));
        }
        this.loadTmplNode(col, condition);
    }

    private void loadTmplNode(List<CslTmplNodeUserDefineInfo> lst, ReportCondition condition) throws BOSException {
        if (lst == null || lst.size() == 0) {
            return;
        }
        HashSet<String> grpIDs = new HashSet<String>(lst.size());
        this.collectTmplGroupIDs(lst, grpIDs);
        Map<String, String> tmpl2rptMap = this.getTmpl2ReportMap(grpIDs, condition);
        for (CslTmplNodeUserDefineInfo defineInfo : lst) {
            defineInfo.setReportID(tmpl2rptMap.get(defineInfo.getTmplGroup()));
        }
    }

    private Map<String, String> getTmpl2ReportMap(Set<String> grpIDs, ReportCondition condition) throws BOSException {
        HashMap<String, String> tmpl2rptMap = new HashMap<String, String>();
        ReportCollection rptcol = RptNewUIUtil.getReportCollByCondition(grpIDs, condition);
        if (rptcol != null && rptcol.size() > 0) {
            int size = rptcol.size();
            for (int i = 0; i < size; ++i) {
                ReportInfo info = rptcol.get(i);
                String group = info.getK3Template() != null ? info.getK3Template().getGroup() : info.getTemplate().getGroup();
                tmpl2rptMap.put(group, info.getId().toString());
            }
        }
        return tmpl2rptMap;
    }

    private void collectTmplGroupIDs(List<CslTmplNodeUserDefineInfo> lst, Set<String> grpIDs) {
        if (lst == null) {
            return;
        }
        Iterator<CslTmplNodeUserDefineInfo> it = lst.iterator();
        while (it.hasNext()) {
            grpIDs.add(it.next().getTmplGroup());
        }
    }

    public List<CslTmplNodeUserDefineInfo> getDataFromCache(String cacheKey, RptPeriodTypeEnum periodType) {
        List<CslTmplNodeUserDefineInfo> rstLst = this.getDataFromCache(cacheKey);
        return this.filterTmplByPeriodType(rstLst, periodType);
    }

    public List<CslTmplNodeUserDefineInfo> getDataFromCache(String cacheKey) {
        CacheState state = this.find(cacheKey);
        return this.cache.get(state);
    }

    private List<CslTmplNodeUserDefineInfo> getHasNodeOfTmplLst(List<CslTmplNodeUserDefineInfo> lst, RptPeriodTypeEnum periodType) {
        ArrayList<CslTmplNodeUserDefineInfo> result = new ArrayList<CslTmplNodeUserDefineInfo>(0);
        if (lst == null || lst.size() == 0) {
            return result;
        }
        List<CslTmplNodeUserDefineInfo> filtlst = this.filterTmplByPeriodType(lst, periodType);
        for (CslTmplNodeUserDefineInfo info : filtlst) {
            if (info.getNode() == null) continue;
            result.add(info);
        }
        return result;
    }

    private List<CslTmplNodeUserDefineInfo> filterTmplByPeriodType(List<CslTmplNodeUserDefineInfo> lst, RptPeriodTypeEnum periodType) {
        if (lst == null || lst.size() == 0) {
            return new ArrayList<CslTmplNodeUserDefineInfo>(0);
        }
        ArrayList<CslTmplNodeUserDefineInfo> filtlst = new ArrayList<CslTmplNodeUserDefineInfo>(0);
        for (CslTmplNodeUserDefineInfo info : lst) {
            if (!periodType.equals((Object)info.getPeriodType())) continue;
            filtlst.add(info);
        }
        return filtlst;
    }

    private CacheState find(String cacheKey) {
        for (CacheState state : this.cache.keySet()) {
            if (!cacheKey.equals(state._cacheKey)) continue;
            return state;
        }
        return null;
    }

    public void clearCache() {
        this.cache.clear();
    }

    public Map<CacheState, List<CslTmplNodeUserDefineInfo>> getCache() {
        return this.cache;
    }

    public void setCache(Map<CacheState, List<CslTmplNodeUserDefineInfo>> cache) {
        this.cache = cache;
    }

    public class TmplComparator
    implements Comparator<CslTmplNodeUserDefineInfo> {
        @Override
        public int compare(CslTmplNodeUserDefineInfo o1, CslTmplNodeUserDefineInfo o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            return o1.getTmplNumber().compareTo(o2.getTmplNumber());
        }
    }

    public static class CacheState {
        public boolean _isCache = false;
        public String _cacheKey = "";

        public CacheState(String cacheKey, boolean isCache) {
            this._isCache = isCache;
            this._cacheKey = cacheKey;
        }
    }
}

