/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.dbcenter.pool;

import com.kingdee.eas.fi.newrpt.dbcenter.DBCenterInfo;
import com.kingdee.eas.fi.newrpt.dbcenter.pool.AbstractDBPool;
import com.kingdee.eas.fi.newrpt.dbcenter.pool.DB2DBPool;
import com.kingdee.eas.fi.newrpt.dbcenter.pool.DMDBPool;
import com.kingdee.eas.fi.newrpt.dbcenter.pool.IDBPool;
import com.kingdee.eas.fi.newrpt.dbcenter.pool.MysqlDBPool;
import com.kingdee.eas.fi.newrpt.dbcenter.pool.OracleDBPool;
import com.kingdee.eas.fi.newrpt.dbcenter.pool.PostgresqlDBPool;
import com.kingdee.eas.fi.newrpt.dbcenter.pool.SqlServerDBPool;

public class DBPoolFactory {
    public static IDBPool createPoolInstance(DBCenterInfo dbCenterInfo) throws Exception {
        AbstractDBPool pool = null;
        int type = dbCenterInfo.getDbType().getValue();
        if (type == 0) {
            pool = new SqlServerDBPool(dbCenterInfo);
        } else if (type == 1) {
            pool = new OracleDBPool(dbCenterInfo);
        } else if (type == 2) {
            pool = new DB2DBPool(dbCenterInfo);
        } else if (type == 3) {
            pool = new MysqlDBPool(dbCenterInfo);
        } else if (type == 4) {
            pool = new PostgresqlDBPool(dbCenterInfo);
        } else if (type == 5) {
            pool = new DMDBPool(dbCenterInfo);
        }
        if (pool == null) {
            return null;
        }
        pool.init();
        pool.startPool();
        return pool;
    }
}

