/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.designer.comment;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.PostilInfo;
import com.kingdee.eas.fi.rpt.RptComment;
import com.kingdee.eas.fi.rpt.RptCommentTank;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class CommentUtil {
    private static Logger logger = Logger.getLogger(CommentUtil.class);

    public static RptCommentTank getReportComment(Cell cell, boolean convert) {
        return CommentUtil.getReportComment(cell, null, convert);
    }

    public static RptCommentTank getReportComment(Cell cell) {
        return CommentUtil.getReportComment(cell, null, true);
    }

    public static RptCommentTank getReportComment(Cell cell, UserInfo defaultAuthor, boolean convert) {
        if (cell == null) {
            return null;
        }
        Comment comment = cell.getComment();
        if (comment == null) {
            return null;
        }
        RptCommentTank ct = null;
        if (comment instanceof RptCommentTank) {
            ct = (RptCommentTank)comment;
        } else if (convert) {
            ct = CommentUtil.convertComment(comment, defaultAuthor != null ? defaultAuthor : SysContext.getSysContext().getCurrentUserInfo());
            cell.setComment((Comment)ct);
        }
        return ct;
    }

    public static RptCommentTank getReportComment(Range cell, UserInfo defaultAuthor) {
        if (cell == null) {
            return null;
        }
        Comment comment = cell.getComment();
        if (comment == null) {
            return null;
        }
        RptCommentTank ct = null;
        if (comment instanceof RptCommentTank) {
            ct = (RptCommentTank)comment;
        } else {
            ct = CommentUtil.convertComment(comment, defaultAuthor != null ? defaultAuthor : SysContext.getSysContext().getCurrentUserInfo());
            cell.setComment((Comment)ct);
        }
        return ct;
    }

    public static RptCommentTank getReportComment(Range cell) {
        return CommentUtil.getReportComment(cell, null);
    }

    public static RptCommentTank convertComment(Comment c, UserInfo author, Timestamp date) {
        if (c == null) {
            return null;
        }
        if (c instanceof RptCommentTank) {
            return (RptCommentTank)c;
        }
        String text = c.getText();
        RptCommentTank ct = CommentUtil.createRptCommentTank(author, date, text);
        return ct;
    }

    public static RptCommentTank createRptCommentTank(UserInfo author, Timestamp date, String text) {
        RptCommentTank ct = new RptCommentTank();
        try {
            PostilInfo postil = new PostilInfo();
            postil.setCreator(author);
            postil.setDescription(text);
            postil.setLastUpdateTime(date);
            RptComment rptComment = new RptComment(postil);
            rptComment.content = text;
            rptComment.date = date == null ? new Timestamp(Calendar.getInstance().getTimeInMillis()) : date;
            rptComment.author = author;
            ct.addEntry(rptComment);
        }
        catch (Exception e) {
            logger.debug((Object)e.getStackTrace(), (Throwable)e);
        }
        return ct;
    }

    public static RptCommentTank convertComment(Comment c, UserInfo author) {
        return CommentUtil.convertComment(c, author, null);
    }
}

